/*
 * The canonical list of T10 Additional Sense Codes is available at:
 * http://www.t10.org/lists/asc-num.txt [most recent: 20141221]
 */

SENSE_CODE(0x0000, "No additional sense information")
SENSE_CODE(0x0001, "Filemark detected")
SENSE_CODE(0x0002, "End-of-partition/medium detected")
SENSE_CODE(0x0003, "Setmark detected")
SENSE_CODE(0x0004, "Beginning-of-partition/medium detected")
SENSE_CODE(0x0005, "End-of-data detected")
SENSE_CODE(0x0006, "I/O process terminated")
SENSE_CODE(0x0007, "Programmable early warning detected")
SENSE_CODE(0x0011, "Audio play operation in progress")
SENSE_CODE(0x0012, "Audio play operation paused")
SENSE_CODE(0x0013, "Audio play operation successfully completed")
SENSE_CODE(0x0014, "Audio play operation stopped due to error")
SENSE_CODE(0x0015, "No current audio status to return")
SENSE_CODE(0x0016, "Operation in progress")
SENSE_CODE(0x0017, "Cleaning requested")
SENSE_CODE(0x0018, "Erase operation in progress")
SENSE_CODE(0x0019, "Locate operation in progress")
SENSE_CODE(0x001A, "Rewind operation in progress")
SENSE_CODE(0x001B, "Set capacity operation in progress")
SENSE_CODE(0x001C, "Verify operation in progress")
SENSE_CODE(0x001D, "ATA pass through information available")
SENSE_CODE(0x001E, "Conflicting SA creation request")
SENSE_CODE(0x001F, "Logical unit transitioning to another power condition")
SENSE_CODE(0x0020, "Extended copy information available")
SENSE_CODE(0x0021, "Atomic command aborted due to ACA")

SENSE_CODE(0x0100, "No index/sector signal")

SENSE_CODE(0x0200, "No seek complete")

SENSE_CODE(0x0300, "Peripheral device write fault")
SENSE_CODE(0x0301, "No write current")
SENSE_CODE(0x0302, "Excessive write errors")

SENSE_CODE(0x0400, "Logical unit not ready, cause not reportable")
SENSE_CODE(0x0401, "Logical unit is in process of becoming ready")
SENSE_CODE(0x0402, "Logical unit not ready, initializing command required")
SENSE_CODE(0x0403, "Logical unit not ready, manual intervention required")
SENSE_CODE(0x0404, "Logical unit not ready, format in progress")
SENSE_CODE(0x0405, "Logical unit not ready, rebuild in progress")
SENSE_CODE(0x0406, "Logical unit not ready, recalculation in progress")
SENSE_CODE(0x0407, "Logical unit not ready, operation in progress")
SENSE_CODE(0x0408, "Logical unit not ready, long write in progress")
SENSE_CODE(0x0409, "Logical unit not ready, self-test in progress")
SENSE_CODE(0x040A, "Logical unit not accessible, asymmetric access state transition")
SENSE_CODE(0x040B, "Logical unit not accessible, target port in standby state")
SENSE_CODE(0x040C, "Logical unit not accessible, target port in unavailable state")
SENSE_CODE(0x040D, "Logical unit not ready, structure check required")
SENSE_CODE(0x040E, "Logical unit not ready, security session in progress")
SENSE_CODE(0x0410, "Logical unit not ready, auxiliary memory not accessible")
SENSE_CODE(0x0411, "Logical unit not ready, notify (enable spinup) required")
SENSE_CODE(0x0412, "Logical unit not ready, offline")
SENSE_CODE(0x0413, "Logical unit not ready, SA creation in progress")
SENSE_CODE(0x0414, "Logical unit not ready, space allocation in progress")
SENSE_CODE(0x0415, "Logical unit not ready, robotics disabled")
SENSE_CODE(0x0416, "Logical unit not ready, configuration required")
SENSE_CODE(0x0417, "Logical unit not ready, calibration required")
SENSE_CODE(0x0418, "Logical unit not ready, a door is open")
SENSE_CODE(0x0419, "Logical unit not ready, operating in sequential mode")
SENSE_CODE(0x041A, "Logical unit not ready, start stop unit command in progress")
SENSE_CODE(0x041B, "Logical unit not ready, sanitize in progress")
SENSE_CODE(0x041C, "Logical unit not ready, additional power use not yet granted")
SENSE_CODE(0x041D, "Logical unit not ready, configuration in progress")
SENSE_CODE(0x041E, "Logical unit not ready, microcode activation required")
SENSE_CODE(0x041F, "Logical unit not ready, microcode download required")
SENSE_CODE(0x0420, "Logical unit not ready, logical unit reset required")
SENSE_CODE(0x0421, "Logical unit not ready, hard reset required")
SENSE_CODE(0x0422, "Logical unit not ready, power cycle required")

SENSE_CODE(0x0500, "Logical unit does not respond to selection")

SENSE_CODE(0x0600, "No reference position found")

SENSE_CODE(0x0700, "Multiple peripheral devices selected")

SENSE_CODE(0x0800, "Logical unit communication failure")
SENSE_CODE(0x0801, "Logical unit communication time-out")
SENSE_CODE(0x0802, "Logical unit communication parity error")
SENSE_CODE(0x0803, "Logical unit communication CRC error (Ultra-DMA/32)")
SENSE_CODE(0x0804, "Unreachable copy target")

SENSE_CODE(0x0900, "Track following error")
SENSE_CODE(0x0901, "Tracking servo failure")
SENSE_CODE(0x0902, "Focus servo failure")
SENSE_CODE(0x0903, "Spindle servo failure")
SENSE_CODE(0x0904, "Head select fault")
SENSE_CODE(0x0905, "Vibration induced tracking error")

SENSE_CODE(0x0A00, "Error log overflow")

SENSE_CODE(0x0B00, "Warning")
SENSE_CODE(0x0B01, "Warning - specified temperature exceeded")
SENSE_CODE(0x0B02, "Warning - enclosure degraded")
SENSE_CODE(0x0B03, "Warning - background self-test failed")
SENSE_CODE(0x0B04, "Warning - background pre-scan detected medium error")
SENSE_CODE(0x0B05, "Warning - background medium scan detected medium error")
SENSE_CODE(0x0B06, "Warning - non-volatile cache now volatile")
SENSE_CODE(0x0B07, "Warning - degraded power to non-volatile cache")
SENSE_CODE(0x0B08, "Warning - power loss expected")
SENSE_CODE(0x0B09, "Warning - device statistics notification active")

SENSE_CODE(0x0C00, "Write error")
SENSE_CODE(0x0C01, "Write error - recovered with auto reallocation")
SENSE_CODE(0x0C02, "Write error - auto reallocation failed")
SENSE_CODE(0x0C03, "Write error - recommend reassignment")
SENSE_CODE(0x0C04, "Compression check miscompare error")
SENSE_CODE(0x0C05, "Data expansion occurred during compression")
SENSE_CODE(0x0C06, "Block not compressible")
SENSE_CODE(0x0C07, "Write error - recovery needed")
SENSE_CODE(0x0C08, "Write error - recovery failed")
SENSE_CODE(0x0C09, "Write error - loss of streaming")
SENSE_CODE(0x0C0A, "Write error - padding blocks added")
SENSE_CODE(0x0C0B, "Auxiliary memory write error")
SENSE_CODE(0x0C0C, "Write error - unexpected unsolicited data")
SENSE_CODE(0x0C0D, "Write error - not enough unsolicited data")
SENSE_CODE(0x0C0E, "Multiple write errors")
SENSE_CODE(0x0C0F, "Defects in error window")
SENSE_CODE(0x0C10, "Incomplete multiple atomic write operations")

SENSE_CODE(0x0D00, "Error detected by third party temporary initiator")
SENSE_CODE(0x0D01, "Third party device failure")
SENSE_CODE(0x0D02, "Copy target device not reachable")
SENSE_CODE(0x0D03, "Incorrect copy target device type")
SENSE_CODE(0x0D04, "Copy target device data underrun")
SENSE_CODE(0x0D05, "Copy target device data overrun")

SENSE_CODE(0x0E00, "Invalid information unit")
SENSE_CODE(0x0E01, "Information unit too short")
SENSE_CODE(0x0E02, "Information unit too long")
SENSE_CODE(0x0E03, "Invalid field in command information unit")

SENSE_CODE(0x1000, "Id CRC or ECC error")
SENSE_CODE(0x1001, "Logical block guard check failed")
SENSE_CODE(0x1002, "Logical block application tag check failed")
SENSE_CODE(0x1003, "Logical block reference tag check failed")
SENSE_CODE(0x1004, "Logical block protection error on recover buffered data")
SENSE_CODE(0x1005, "Logical block protection method error")

SENSE_CODE(0x1100, "Unrecovered read error")
SENSE_CODE(0x1101, "Read retries exhausted")
SENSE_CODE(0x1102, "Error too long to correct")
SENSE_CODE(0x1103, "Multiple read errors")
SENSE_CODE(0x1104, "Unrecovered read error - auto reallocate failed")
SENSE_CODE(0x1105, "L-EC uncorrectable error")
SENSE_CODE(0x1106, "CIRC unrecovered error")
SENSE_CODE(0x1107, "Data re-synchronization error")
SENSE_CODE(0x1108, "Incomplete block read")
SENSE_CODE(0x1109, "No gap found")
SENSE_CODE(0x110A, "Miscorrected error")
SENSE_CODE(0x110B, "Unrecovered read error - recommend reassignment")
SENSE_CODE(0x110C, "Unrecovered read error - recommend rewrite the data")
SENSE_CODE(0x110D, "De-compression CRC error")
SENSE_CODE(0x110E, "Cannot decompress using declared algorithm")
SENSE_CODE(0x110F, "Error reading UPC/EAN number")
SENSE_CODE(0x1110, "Error reading ISRC number")
SENSE_CODE(0x1111, "Read error - loss of streaming")
SENSE_CODE(0x1112, "Auxiliary memory read error")
SENSE_CODE(0x1113, "Read error - failed retransmission request")
SENSE_CODE(0x1114, "Read error - lba marked bad by application client")
SENSE_CODE(0x1115, "Write after sanitize required")

SENSE_CODE(0x1200, "Address mark not found for id field")

SENSE_CODE(0x1300, "Address mark not found for data field")

SENSE_CODE(0x1400, "Recorded entity not found")
SENSE_CODE(0x1401, "Record not found")
SENSE_CODE(0x1402, "Filemark or setmark not found")
SENSE_CODE(0x1403, "End-of-data not found")
SENSE_CODE(0x1404, "Block sequence error")
SENSE_CODE(0x1405, "Record not found - recommend reassignment")
SENSE_CODE(0x1406, "Record not found - data auto-reallocated")
SENSE_CODE(0x1407, "Locate operation failure")

SENSE_CODE(0x1500, "Random positioning error")
SENSE_CODE(0x1501, "Mechanical positioning error")
SENSE_CODE(0x1502, "Positioning error detected by read of medium")

SENSE_CODE(0x1600, "Data synchronization mark error")
SENSE_CODE(0x1601, "Data sync error - data rewritten")
SENSE_CODE(0x1602, "Data sync error - recommend rewrite")
SENSE_CODE(0x1603, "Data sync error - data auto-reallocated")
SENSE_CODE(0x1604, "Data sync error - recommend reassignment")

SENSE_CODE(0x1700, "Recovered data with no error correction applied")
SENSE_CODE(0x1701, "Recovered data with retries")
SENSE_CODE(0x1702, "Recovered data with positive head offset")
SENSE_CODE(0x1703, "Recovered data with negative head offset")
SENSE_CODE(0x1704, "Recovered data with retries and/or circ applied")
SENSE_CODE(0x1705, "Recovered data using previous sector id")
SENSE_CODE(0x1706, "Recovered data without ECC - data auto-reallocated")
SENSE_CODE(0x1707, "Recovered data without ECC - recommend reassignment")
SENSE_CODE(0x1708, "Recovered data without ECC - recommend rewrite")
SENSE_CODE(0x1709, "Recovered data without ECC - data rewritten")

SENSE_CODE(0x1800, "Recovered data with error correction applied")
SENSE_CODE(0x1801, "Recovered data with error corr. & retries applied")
SENSE_CODE(0x1802, "Recovered data - data auto-reallocated")
SENSE_CODE(0x1803, "Recovered data with CIRC")
SENSE_CODE(0x1804, "Recovered data with L-EC")
SENSE_CODE(0x1805, "Recovered data - recommend reassignment")
SENSE_CODE(0x1806, "Recovered data - recommend rewrite")
SENSE_CODE(0x1807, "Recovered data with ECC - data rewritten")
SENSE_CODE(0x1808, "Recovered data with linking")

SENSE_CODE(0x1900, "Defect list error")
SENSE_CODE(0x1901, "Defect list not available")
SENSE_CODE(0x1902, "Defect list error in primary list")
SENSE_CODE(0x1903, "Defect list error in grown list")

SENSE_CODE(0x1A00, "Parameter list length error")

SENSE_CODE(0x1B00, "Synchronous data transfer error")

SENSE_CODE(0x1C00, "Defect list not found")
SENSE_CODE(0x1C01, "Primary defect list not found")
SENSE_CODE(0x1C02, "Grown defect list not found")

SENSE_CODE(0x1D00, "Miscompare during verify operation")
SENSE_CODE(0x1D01, "Miscompare verify of unmapped LBA")

SENSE_CODE(0x1E00, "Recovered id with ECC correction")

SENSE_CODE(0x1F00, "Partial defect list transfer")

SENSE_CODE(0x2000, "Invalid command operation code")
SENSE_CODE(0x2001, "Access denied - initiator pending-enrolled")
SENSE_CODE(0x2002, "Access denied - no access rights")
SENSE_CODE(0x2003, "Access denied - invalid mgmt id key")
SENSE_CODE(0x2004, "Illegal command while in write capable state")
SENSE_CODE(0x2005, "Obsolete")
SENSE_CODE(0x2006, "Illegal command while in explicit address mode")
SENSE_CODE(0x2007, "Illegal command while in implicit address mode")
SENSE_CODE(0x2008, "Access denied - enrollment conflict")
SENSE_CODE(0x2009, "Access denied - invalid LU identifier")
SENSE_CODE(0x200A, "Access denied - invalid proxy token")
SENSE_CODE(0x200B, "Access denied - ACL LUN conflict")
SENSE_CODE(0x200C, "Illegal command when not in append-only mode")

SENSE_CODE(0x2100, "Logical block address out of range")
SENSE_CODE(0x2101, "Invalid element address")
SENSE_CODE(0x2102, "Invalid address for write")
SENSE_CODE(0x2103, "Invalid write crossing layer jump")
SENSE_CODE(0x2104, "Unaligned write command")
SENSE_CODE(0x2105, "Write boundary violation")
SENSE_CODE(0x2106, "Attempt to read invalid data")
SENSE_CODE(0x2107, "Read boundary violation")

SENSE_CODE(0x2200, "Illegal function (use 20 00, 24 00, or 26 00)")

SENSE_CODE(0x2300, "Invalid token operation, cause not reportable")
SENSE_CODE(0x2301, "Invalid token operation, unsupported token type")
SENSE_CODE(0x2302, "Invalid token operation, remote token usage not supported")
SENSE_CODE(0x2303, "Invalid token operation, remote rod token creation not supported")
SENSE_CODE(0x2304, "Invalid token operation, token unknown")
SENSE_CODE(0x2305, "Invalid token operation, token corrupt")
SENSE_CODE(0x2306, "Invalid token operation, token revoked")
SENSE_CODE(0x2307, "Invalid token operation, token expired")
SENSE_CODE(0x2308, "Invalid token operation, token cancelled")
SENSE_CODE(0x2309, "Invalid token operation, token deleted")
SENSE_CODE(0x230A, "Invalid token operation, invalid token length")

SENSE_CODE(0x2400, "Invalid field in cdb")
SENSE_CODE(0x2401, "CDB decryption error")
SENSE_CODE(0x2402, "Obsolete")
SENSE_CODE(0x2403, "Obsolete")
SENSE_CODE(0x2404, "Security audit value frozen")
SENSE_CODE(0x2405, "Security working key frozen")
SENSE_CODE(0x2406, "Nonce not unique")
SENSE_CODE(0x2407, "Nonce timestamp out of range")
SENSE_CODE(0x2408, "Invalid XCDB")

SENSE_CODE(0x2500, "Logical unit not supported")

SENSE_CODE(0x2600, "Invalid field in parameter list")
SENSE_CODE(0x2601, "Parameter not supported")
SENSE_CODE(0x2602, "Parameter value invalid")
SENSE_CODE(0x2603, "Threshold parameters not supported")
SENSE_CODE(0x2604, "Invalid release of persistent reservation")
SENSE_CODE(0x2605, "Data decryption error")
SENSE_CODE(0x2606, "Too many target descriptors")
SENSE_CODE(0x2607, "Unsupported target descriptor type code")
SENSE_CODE(0x2608, "Too many segment descriptors")
SENSE_CODE(0x2609, "Unsupported segment descriptor type code")
SENSE_CODE(0x260A, "Unexpected inexact segment")
SENSE_CODE(0x260B, "Inline data length exceeded")
SENSE_CODE(0x260C, "Invalid operation for copy source or destination")
SENSE_CODE(0x260D, "Copy segment granularity violation")
SENSE_CODE(0x260E, "Invalid parameter while port is enabled")
SENSE_CODE(0x260F, "Invalid data-out buffer integrity check value")
SENSE_CODE(0x2610, "Data decryption key fail limit reached")
SENSE_CODE(0x2611, "Incomplete key-associated data set")
SENSE_CODE(0x2612, "Vendor specific key reference not found")

SENSE_CODE(0x2700, "Write protected")
SENSE_CODE(0x2701, "Hardware write protected")
SENSE_CODE(0x2702, "Logical unit software write protected")
SENSE_CODE(0x2703, "Associated write protect")
SENSE_CODE(0x2704, "Persistent write protect")
SENSE_CODE(0x2705, "Permanent write protect")
SENSE_CODE(0x2706, "Conditional write protect")
SENSE_CODE(0x2707, "Space allocation failed write protect")
SENSE_CODE(0x2708, "Zone is read only")

SENSE_CODE(0x2800, "Not ready to ready change, medium may have changed")
SENSE_CODE(0x2801, "Import or export element accessed")
SENSE_CODE(0x2802, "Format-layer may have changed")
SENSE_CODE(0x2803, "Import/export element accessed, medium changed")

SENSE_CODE(0x2900, "Power on, reset, or bus device reset occurred")
SENSE_CODE(0x2901, "Power on occurred")
SENSE_CODE(0x2902, "Scsi bus reset occurred")
SENSE_CODE(0x2903, "Bus device reset function occurred")
SENSE_CODE(0x2904, "Device internal reset")
SENSE_CODE(0x2905, "Transceiver mode changed to single-ended")
SENSE_CODE(0x2906, "Transceiver mode changed to lvd")
SENSE_CODE(0x2907, "I_T nexus loss occurred")

SENSE_CODE(0x2A00, "Parameters changed")
SENSE_CODE(0x2A01, "Mode parameters changed")
SENSE_CODE(0x2A02, "Log parameters changed")
SENSE_CODE(0x2A03, "Reservations preempted")
SENSE_CODE(0x2A04, "Reservations released")
SENSE_CODE(0x2A05, "Registrations preempted")
SENSE_CODE(0x2A06, "Asymmetric access state changed")
SENSE_CODE(0x2A07, "Implicit asymmetric access state transition failed")
SENSE_CODE(0x2A08, "Priority changed")
SENSE_CODE(0x2A09, "Capacity data has changed")
SENSE_CODE(0x2A0A, "Error history I_T nexus cleared")
SENSE_CODE(0x2A0B, "Error history snapshot released")
SENSE_CODE(0x2A0C, "Error recovery attributes have changed")
SENSE_CODE(0x2A0D, "Data encryption capabilities changed")
SENSE_CODE(0x2A10, "Timestamp changed")
SENSE_CODE(0x2A11, "Data encryption parameters changed by another i_t nexus")
SENSE_CODE(0x2A12, "Data encryption parameters changed by vendor specific event")
SENSE_CODE(0x2A13, "Data encryption key instance counter has changed")
SENSE_CODE(0x2A14, "SA creation capabilities data has changed")
SENSE_CODE(0x2A15, "Medium removal prevention preempted")

SENSE_CODE(0x2B00, "Copy cannot execute since host cannot disconnect")

SENSE_CODE(0x2C00, "Command sequence error")
SENSE_CODE(0x2C01, "Too many windows specified")
SENSE_CODE(0x2C02, "Invalid combination of windows specified")
SENSE_CODE(0x2C03, "Current program area is not empty")
SENSE_CODE(0x2C04, "Current program area is empty")
SENSE_CODE(0x2C05, "Illegal power condition request")
SENSE_CODE(0x2C06, "Persistent prevent conflict")
SENSE_CODE(0x2C07, "Previous busy status")
SENSE_CODE(0x2C08, "Previous task set full status")
SENSE_CODE(0x2C09, "Previous reservation conflict status")
SENSE_CODE(0x2C0A, "Partition or collection contains user objects")
SENSE_CODE(0x2C0B, "Not reserved")
SENSE_CODE(0x2C0C, "Orwrite generation does not match")
SENSE_CODE(0x2C0D, "Reset write pointer not allowed")
SENSE_CODE(0x2C0E, "Zone is offline")

SENSE_CODE(0x2D00, "Overwrite error on update in place")

SENSE_CODE(0x2E00, "Insufficient time for operation")
SENSE_CODE(0x2E01, "Command timeout before processing")
SENSE_CODE(0x2E02, "Command timeout during processing")
SENSE_CODE(0x2E03, "Command timeout during processing due to error recovery")

SENSE_CODE(0x2F00, "Commands cleared by another initiator")
SENSE_CODE(0x2F01, "Commands cleared by power loss notification")
SENSE_CODE(0x2F02, "Commands cleared by device server")
SENSE_CODE(0x2F03, "Some commands cleared by queuing layer event")

SENSE_CODE(0x3000, "Incompatible medium installed")
SENSE_CODE(0x3001, "Cannot read medium - unknown format")
SENSE_CODE(0x3002, "Cannot read medium - incompatible format")
SENSE_CODE(0x3003, "Cleaning cartridge installed")
SENSE_CODE(0x3004, "Cannot write medium - unknown format")
SENSE_CODE(0x3005, "Cannot write medium - incompatible format")
SENSE_CODE(0x3006, "Cannot format medium - incompatible medium")
SENSE_CODE(0x3007, "Cleaning failure")
SENSE_CODE(0x3008, "Cannot write - application code mismatch")
SENSE_CODE(0x3009, "Current session not fixated for append")
SENSE_CODE(0x300A, "Cleaning request rejected")
SENSE_CODE(0x300C, "WORM medium - overwrite attempted")
SENSE_CODE(0x300D, "WORM medium - integrity check")
SENSE_CODE(0x3010, "Medium not formatted")
SENSE_CODE(0x3011, "Incompatible volume type")
SENSE_CODE(0x3012, "Incompatible volume qualifier")
SENSE_CODE(0x3013, "Cleaning volume expired")

SENSE_CODE(0x3100, "Medium format corrupted")
SENSE_CODE(0x3101, "Format command failed")
SENSE_CODE(0x3102, "Zoned formatting failed due to spare linking")
SENSE_CODE(0x3103, "Sanitize command failed")

SENSE_CODE(0x3200, "No defect spare location available")
SENSE_CODE(0x3201, "Defect list update failure")

SENSE_CODE(0x3300, "Tape length error")

SENSE_CODE(0x3400, "Enclosure failure")

SENSE_CODE(0x3500, "Enclosure services failure")
SENSE_CODE(0x3501, "Unsupported enclosure function")
SENSE_CODE(0x3502, "Enclosure services unavailable")
SENSE_CODE(0x3503, "Enclosure services transfer failure")
SENSE_CODE(0x3504, "Enclosure services transfer refused")
SENSE_CODE(0x3505, "Enclosure services checksum error")

SENSE_CODE(0x3600, "Ribbon, ink, or toner failure")

SENSE_CODE(0x3700, "Rounded parameter")

SENSE_CODE(0x3800, "Event status notification")
SENSE_CODE(0x3802, "Esn - power management class event")
SENSE_CODE(0x3804, "Esn - media class event")
SENSE_CODE(0x3806, "Esn - device busy class event")
SENSE_CODE(0x3807, "Thin Provisioning soft threshold reached")

SENSE_CODE(0x3900, "Saving parameters not supported")

SENSE_CODE(0x3A00, "Medium not present")
SENSE_CODE(0x3A01, "Medium not present - tray closed")
SENSE_CODE(0x3A02, "Medium not present - tray open")
SENSE_CODE(0x3A03, "Medium not present - loadable")
SENSE_CODE(0x3A04, "Medium not present - medium auxiliary memory accessible")

SENSE_CODE(0x3B00, "Sequential positioning error")
SENSE_CODE(0x3B01, "Tape position error at beginning-of-medium")
SENSE_CODE(0x3B02, "Tape position error at end-of-medium")
SENSE_CODE(0x3B03, "Tape or electronic vertical forms unit not ready")
SENSE_CODE(0x3B04, "Slew failure")
SENSE_CODE(0x3B05, "Paper jam")
SENSE_CODE(0x3B06, "Failed to sense top-of-form")
SENSE_CODE(0x3B07, "Failed to sense bottom-of-form")
SENSE_CODE(0x3B08, "Reposition error")
SENSE_CODE(0x3B09, "Read past end of medium")
SENSE_CODE(0x3B0A, "Read past beginning of medium")
SENSE_CODE(0x3B0B, "Position past end of medium")
SENSE_CODE(0x3B0C, "Position past beginning of medium")
SENSE_CODE(0x3B0D, "Medium destination element full")
SENSE_CODE(0x3B0E, "Medium source element empty")
SENSE_CODE(0x3B0F, "End of medium reached")
SENSE_CODE(0x3B11, "Medium magazine not accessible")
SENSE_CODE(0x3B12, "Medium magazine removed")
SENSE_CODE(0x3B13, "Medium magazine inserted")
SENSE_CODE(0x3B14, "Medium magazine locked")
SENSE_CODE(0x3B15, "Medium magazine unlocked")
SENSE_CODE(0x3B16, "Mechanical positioning or changer error")
SENSE_CODE(0x3B17, "Read past end of user object")
SENSE_CODE(0x3B18, "Element disabled")
SENSE_CODE(0x3B19, "Element enabled")
SENSE_CODE(0x3B1A, "Data transfer device removed")
SENSE_CODE(0x3B1B, "Data transfer device inserted")
SENSE_CODE(0x3B1C, "Too many logical objects on partition to support operation")

SENSE_CODE(0x3D00, "Invalid bits in identify message")

SENSE_CODE(0x3E00, "Logical unit has not self-configured yet")
SENSE_CODE(0x3E01, "Logical unit failure")
SENSE_CODE(0x3E02, "Timeout on logical unit")
SENSE_CODE(0x3E03, "Logical unit failed self-test")
SENSE_CODE(0x3E04, "Logical unit unable to update self-test log")

SENSE_CODE(0x3F00, "Target operating conditions have changed")
SENSE_CODE(0x3F01, "Microcode has been changed")
SENSE_CODE(0x3F02, "Changed operating definition")
SENSE_CODE(0x3F03, "Inquiry data has changed")
SENSE_CODE(0x3F04, "Component device attached")
SENSE_CODE(0x3F05, "Device identifier changed")
SENSE_CODE(0x3F06, "Redundancy group created or modified")
SENSE_CODE(0x3F07, "Redundancy group deleted")
SENSE_CODE(0x3F08, "Spare created or modified")
SENSE_CODE(0x3F09, "Spare deleted")
SENSE_CODE(0x3F0A, "Volume set created or modified")
SENSE_CODE(0x3F0B, "Volume set deleted")
SENSE_CODE(0x3F0C, "Volume set deassigned")
SENSE_CODE(0x3F0D, "Volume set reassigned")
SENSE_CODE(0x3F0E, "Reported luns data has changed")
SENSE_CODE(0x3F0F, "Echo buffer overwritten")
SENSE_CODE(0x3F10, "Medium loadable")
SENSE_CODE(0x3F11, "Medium auxiliary memory accessible")
SENSE_CODE(0x3F12, "iSCSI IP address added")
SENSE_CODE(0x3F13, "iSCSI IP address removed")
SENSE_CODE(0x3F14, "iSCSI IP address changed")
SENSE_CODE(0x3F15, "Inspect referrals sense descriptors")
SENSE_CODE(0x3F16, "Microcode has been changed without reset")
/*
 *	SENSE_CODE(0x40NN, "Ram failure")
 *	SENSE_CODE(0x40NN, "Diagnostic failure on component nn")
 *	SENSE_CODE(0x41NN, "Data path failure")
 *	SENSE_CODE(0x42NN, "Power-on or self-test failure")
 */
SENSE_CODE(0x4300, "Message error")

SENSE_CODE(0x4400, "Internal target failure")
SENSE_CODE(0x4401, "Persistent reservation information lost")
SENSE_CODE(0x4471, "ATA device failed set features")

SENSE_CODE(0x4500, "Select or reselect failure")

SENSE_CODE(0x4600, "Unsuccessful soft reset")

SENSE_CODE(0x4700, "Scsi parity error")
SENSE_CODE(0x4701, "Data phase CRC error detected")
SENSE_CODE(0x4702, "Scsi parity error detected during st data phase")
SENSE_CODE(0x4703, "Information unit iuCRC error detected")
SENSE_CODE(0x4704, "Asynchronous information protection error detected")
SENSE_CODE(0x4705, "Protocol service CRC error")
SENSE_CODE(0x4706, "Phy test function in progress")
SENSE_CODE(0x477f, "Some commands cleared by iSCSI Protocol event")

SENSE_CODE(0x4800, "Initiator detected error message received")

SENSE_CODE(0x4900, "Invalid message error")

SENSE_CODE(0x4A00, "Command phase error")

SENSE_CODE(0x4B00, "Data phase error")
SENSE_CODE(0x4B01, "Invalid target port transfer tag received")
SENSE_CODE(0x4B02, "Too much write data")
SENSE_CODE(0x4B03, "Ack/nak timeout")
SENSE_CODE(0x4B04, "Nak received")
SENSE_CODE(0x4B05, "Data offset error")
SENSE_CODE(0x4B06, "Initiator response timeout")
SENSE_CODE(0x4B07, "Connection lost")
SENSE_CODE(0x4B08, "Data-in buffer overflow - data buffer size")
SENSE_CODE(0x4B09, "Data-in buffer overflow - data buffer descriptor area")
SENSE_CODE(0x4B0A, "Data-in buffer error")
SENSE_CODE(0x4B0B, "Data-out buffer overflow - data buffer size")
SENSE_CODE(0x4B0C, "Data-out buffer overflow - data buffer descriptor area")
SENSE_CODE(0x4B0D, "Data-out buffer error")
SENSE_CODE(0x4B0E, "PCIe fabric error")
SENSE_CODE(0x4B0F, "PCIe completion timeout")
SENSE_CODE(0x4B10, "PCIe completer abort")
SENSE_CODE(0x4B11, "PCIe poisoned tlp received")
SENSE_CODE(0x4B12, "PCIe eCRC check failed")
SENSE_CODE(0x4B13, "PCIe unsupported request")
SENSE_CODE(0x4B14, "PCIe acs violation")
SENSE_CODE(0x4B15, "PCIe tlp prefix blocked")

SENSE_CODE(0x4C00, "Logical unit failed self-configuration")
/*
 *	SENSE_CODE(0x4DNN, "Tagged overlapped commands (nn = queue tag)")
 */
SENSE_CODE(0x4E00, "Overlapped commands attempted")

SENSE_CODE(0x5000, "Write append error")
SENSE_CODE(0x5001, "Write append position error")
SENSE_CODE(0x5002, "Position error related to timing")

SENSE_CODE(0x5100, "Erase failure")
SENSE_CODE(0x5101, "Erase failure - incomplete erase operation detected")

SENSE_CODE(0x5200, "Cartridge fault")

SENSE_CODE(0x5300, "Media load or eject failed")
SENSE_CODE(0x5301, "Unload tape failure")
SENSE_CODE(0x5302, "Medium removal prevented")
SENSE_CODE(0x5303, "Medium removal prevented by data transfer element")
SENSE_CODE(0x5304, "Medium thread or unthread failure")
SENSE_CODE(0x5305, "Volume identifier invalid")
SENSE_CODE(0x5306, "Volume identifier missing")
SENSE_CODE(0x5307, "Duplicate volume identifier")
SENSE_CODE(0x5308, "Element status unknown")
SENSE_CODE(0x5309, "Data transfer device error - load failed")
SENSE_CODE(0x530a, "Data transfer device error - unload failed")
SENSE_CODE(0x530b, "Data transfer device error - unload missing")
SENSE_CODE(0x530c, "Data transfer device error - eject failed")
SENSE_CODE(0x530d, "Data transfer device error - library communication failed")

SENSE_CODE(0x5400, "Scsi to host system interface failure")

SENSE_CODE(0x5500, "System resource failure")
SENSE_CODE(0x5501, "System buffer full")
SENSE_CODE(0x5502, "Insufficient reservation resources")
SENSE_CODE(0x5503, "Insufficient resources")
SENSE_CODE(0x5504, "Insufficient registration resources")
SENSE_CODE(0x5505, "Insufficient access control resources")
SENSE_CODE(0x5506, "Auxiliary memory out of space")
SENSE_CODE(0x5507, "Quota error")
SENSE_CODE(0x5508, "Maximum number of supplemental decryption keys exceeded")
SENSE_CODE(0x5509, "Medium auxiliary memory not accessible")
SENSE_CODE(0x550A, "Data currently unavailable")
SENSE_CODE(0x550B, "Insufficient power for operation")
SENSE_CODE(0x550C, "Insufficient resources to create rod")
SENSE_CODE(0x550D, "Insufficient resources to create rod token")
SENSE_CODE(0x550E, "Insufficient zone resources")

SENSE_CODE(0x5700, "Unable to recover table-of-contents")

SENSE_CODE(0x5800, "Generation does not exist")

SENSE_CODE(0x5900, "Updated block read")

SENSE_CODE(0x5A00, "Operator request or state change input")
SENSE_CODE(0x5A01, "Operator medium removal request")
SENSE_CODE(0x5A02, "Operator selected write protect")
SENSE_CODE(0x5A03, "Operator selected write permit")

SENSE_CODE(0x5B00, "Log exception")
SENSE_CODE(0x5B01, "Threshold condition met")
SENSE_CODE(0x5B02, "Log counter at maximum")
SENSE_CODE(0x5B03, "Log list codes exhausted")

SENSE_CODE(0x5C00, "Rpl status change")
SENSE_CODE(0x5C01, "Spindles synchronized")
SENSE_CODE(0x5C02, "Spindles not synchronized")

SENSE_CODE(0x5D00, "Failure prediction threshold exceeded")
SENSE_CODE(0x5D01, "Media failure prediction threshold exceeded")
SENSE_CODE(0x5D02, "Logical unit failure prediction threshold exceeded")
SENSE_CODE(0x5D03, "Spare area exhaustion prediction threshold exceeded")
SENSE_CODE(0x5D10, "Hardware impending failure general hard drive failure")
SENSE_CODE(0x5D11, "Hardware impending failure drive error rate too high")
SENSE_CODE(0x5D12, "Hardware impending failure data error rate too high")
SENSE_CODE(0x5D13, "Hardware impending failure seek error rate too high")
SENSE_CODE(0x5D14, "Hardware impending failure too many block reassigns")
SENSE_CODE(0x5D15, "Hardware impending failure access times too high")
SENSE_CODE(0x5D16, "Hardware impending failure start unit times too high")
SENSE_CODE(0x5D17, "Hardware impending failure channel parametrics")
SENSE_CODE(0x5D18, "Hardware impending failure controller detected")
SENSE_CODE(0x5D19, "Hardware impending failure throughput performance")
SENSE_CODE(0x5D1A, "Hardware impending failure seek time performance")
SENSE_CODE(0x5D1B, "Hardware impending failure spin-up retry count")
SENSE_CODE(0x5D1C, "Hardware impending failure drive calibration retry count")
SENSE_CODE(0x5D20, "Controller impending failure general hard drive failure")
SENSE_CODE(0x5D21, "Controller impending failure drive error rate too high")
SENSE_CODE(0x5D22, "Controller impending failure data error rate too high")
SENSE_CODE(0x5D23, "Controller impending failure seek error rate too high")
SENSE_CODE(0x5D24, "Controller impending failure too many block reassigns")
SENSE_CODE(0x5D25, "Controller impending failure access times too high")
SENSE_CODE(0x5D26, "Controller impending failure start unit times too high")
SENSE_CODE(0x5D27, "Controller impending failure channel parametrics")
SENSE_CODE(0x5D28, "Controller impending failure controller detected")
SENSE_CODE(0x5D29, "Controller impending failure throughput performance")
SENSE_CODE(0x5D2A, "Controller impending failure seek time performance")
SENSE_CODE(0x5D2B, "Controller impending failure spin-up retry count")
SENSE_CODE(0x5D2C, "Controller impending failure drive calibration retry count")
SENSE_CODE(0x5D30, "Data channel impending failure general hard drive failure")
SENSE_CODE(0x5D31, "Data channel impending failure drive error rate too high")
SENSE_CODE(0x5D32, "Data channel impending failure data error rate too high")
SENSE_CODE(0x5D33, "Data channel impending failure seek error rate too high")
SENSE_CODE(0x5D34, "Data channel impending failure too many block reassigns")
SENSE_CODE(0x5D35, "Data channel impending failure access times too high")
SENSE_CODE(0x5D36, "Data channel impending failure start unit times too high")
SENSE_CODE(0x5D37, "Data channel impending failure channel parametrics")
SENSE_CODE(0x5D38, "Data channel impending failure controller detected")
SENSE_CODE(0x5D39, "Data channel impending failure throughput performance")
SENSE_CODE(0x5D3A, "Data channel impending failure seek time performance")
SENSE_CODE(0x5D3B, "Data channel impending failure spin-up retry count")
SENSE_CODE(0x5D3C, "Data channel impending failure drive calibration retry count")
SENSE_CODE(0x5D40, "Servo impending failure general hard drive failure")
SENSE_CODE(0x5D41, "Servo impending failure drive error rate too high")
SENSE_CODE(0x5D42, "Servo impending failure data error rate too high")
SENSE_CODE(0x5D43, "Servo impending failure seek error rate too high")
SENSE_CODE(0x5D44, "Servo impending failure too many block reassigns")
SENSE_CODE(0x5D45, "Servo impending failure access times too high")
SENSE_CODE(0x5D46, "Servo impending failure start unit times too high")
SENSE_CODE(0x5D47, "Servo impending failure channel parametrics")
SENSE_CODE(0x5D48, "Servo impending failure controller detected")
SENSE_CODE(0x5D49, "Servo impending failure throughput performance")
SENSE_CODE(0x5D4A, "Servo impending failure seek time performance")
SENSE_CODE(0x5D4B, "Servo impending failure spin-up retry count")
SENSE_CODE(0x5D4C, "Servo impending failure drive calibration retry count")
SENSE_CODE(0x5D50, "Spindle impending failure general hard drive failure")
SENSE_CODE(0x5D51, "Spindle impending failure drive error rate too high")
SENSE_CODE(0x5D52, "Spindle impending failure data error rate too high")
SENSE_CODE(0x5D53, "Spindle impending failure seek error rate too high")
SENSE_CODE(0x5D54, "Spindle impending failure too many block reassigns")
SENSE_CODE(0x5D55, "Spindle impending failure access times too high")
SENSE_CODE(0x5D56, "Spindle impending failure start unit times too high")
SENSE_CODE(0x5D57, "Spindle impending failure channel parametrics")
SENSE_CODE(0x5D58, "Spindle impending failure controller detected")
SENSE_CODE(0x5D59, "Spindle impending failure throughput performance")
SENSE_CODE(0x5D5A, "Spindle impending failure seek time performance")
SENSE_CODE(0x5D5B, "Spindle impending failure spin-up retry count")
SENSE_CODE(0x5D5C, "Spindle impending failure drive calibration retry count")
SENSE_CODE(0x5D60, "Firmware impending failure general hard drive failure")
SENSE_CODE(0x5D61, "Firmware impending failure drive error rate too high")
SENSE_CODE(0x5D62, "Firmware impending failure data error rate too high")
SENSE_CODE(0x5D63, "Firmware impending failure seek error rate too high")
SENSE_CODE(0x5D64, "Firmware impending failure too many block reassigns")
SENSE_CODE(0x5D65, "Firmware impending failure access times too high")
SENSE_CODE(0x5D66, "Firmware impending failure start unit times too high")
SENSE_CODE(0x5D67, "Firmware impending failure channel parametrics")
SENSE_CODE(0x5D68, "Firmware impending failure controller detected")
SENSE_CODE(0x5D69, "Firmware impending failure throughput performance")
SENSE_CODE(0x5D6A, "Firmware impending failure seek time performance")
SENSE_CODE(0x5D6B, "Firmware impending failure spin-up retry count")
SENSE_CODE(0x5D6C, "Firmware impending failure drive calibration retry count")
SENSE_CODE(0x5DFF, "Failure prediction threshold exceeded (false)")

SENSE_CODE(0x5E00, "Low power condition on")
SENSE_CODE(0x5E01, "Idle condition activated by timer")
SENSE_CODE(0x5E02, "Standby condition activated by timer")
SENSE_CODE(0x5E03, "Idle condition activated by command")
SENSE_CODE(0x5E04, "Standby condition activated by command")
SENSE_CODE(0x5E05, "Idle_b condition activated by timer")
SENSE_CODE(0x5E06, "Idle_b condition activated by command")
SENSE_CODE(0x5E07, "Idle_c condition activated by timer")
SENSE_CODE(0x5E08, "Idle_c condition activated by command")
SENSE_CODE(0x5E09, "Standby_y condition activated by timer")
SENSE_CODE(0x5E0A, "Standby_y condition activated by command")
SENSE_CODE(0x5E41, "Power state change to active")
SENSE_CODE(0x5E42, "Power state change to idle")
SENSE_CODE(0x5E43, "Power state change to standby")
SENSE_CODE(0x5E45, "Power state change to sleep")
SENSE_CODE(0x5E47, "Power state change to device control")

SENSE_CODE(0x6000, "Lamp failure")

SENSE_CODE(0x6100, "Video acquisition error")
SENSE_CODE(0x6101, "Unable to acquire video")
SENSE_CODE(0x6102, "Out of focus")

SENSE_CODE(0x6200, "Scan head positioning error")

SENSE_CODE(0x6300, "End of user area encountered on this track")
SENSE_CODE(0x6301, "Packet does not fit in available space")

SENSE_CODE(0x6400, "Illegal mode for this track")
SENSE_CODE(0x6401, "Invalid packet size")

SENSE_CODE(0x6500, "Voltage fault")

SENSE_CODE(0x6600, "Automatic document feeder cover up")
SENSE_CODE(0x6601, "Automatic document feeder lift up")
SENSE_CODE(0x6602, "Document jam in automatic document feeder")
SENSE_CODE(0x6603, "Document miss feed automatic in document feeder")

SENSE_CODE(0x6700, "Configuration failure")
SENSE_CODE(0x6701, "Configuration of incapable logical units failed")
SENSE_CODE(0x6702, "Add logical unit failed")
SENSE_CODE(0x6703, "Modification of logical unit failed")
SENSE_CODE(0x6704, "Exchange of logical unit failed")
SENSE_CODE(0x6705, "Remove of logical unit failed")
SENSE_CODE(0x6706, "Attachment of logical unit failed")
SENSE_CODE(0x6707, "Creation of logical unit failed")
SENSE_CODE(0x6708, "Assign failure occurred")
SENSE_CODE(0x6709, "Multiply assigned logical unit")
SENSE_CODE(0x670A, "Set target port groups command failed")
SENSE_CODE(0x670B, "ATA device feature not enabled")

SENSE_CODE(0x6800, "Logical unit not configured")
SENSE_CODE(0x6801, "Subsidiary logical unit not configured")

SENSE_CODE(0x6900, "Data loss on logical unit")
SENSE_CODE(0x6901, "Multiple logical unit failures")
SENSE_CODE(0x6902, "Parity/data mismatch")

SENSE_CODE(0x6A00, "Informational, refer to log")

SENSE_CODE(0x6B00, "State change has occurred")
SENSE_CODE(0x6B01, "Redundancy level got better")
SENSE_CODE(0x6B02, "Redundancy level got worse")

SENSE_CODE(0x6C00, "Rebuild failure occurred")

SENSE_CODE(0x6D00, "Recalculate failure occurred")

SENSE_CODE(0x6E00, "Command to logical unit failed")

SENSE_CODE(0x6F00, "Copy protection key exchange failure - authentication failure")
SENSE_CODE(0x6F01, "Copy protection key exchange failure - key not present")
SENSE_CODE(0x6F02, "Copy protection key exchange failure - key not established")
SENSE_CODE(0x6F03, "Read of scrambled sector without authentication")
SENSE_CODE(0x6F04, "Media region code is mismatched to logical unit region")
SENSE_CODE(0x6F05, "Drive region must be permanent/region reset count error")
SENSE_CODE(0x6F06, "Insufficient block count for binding nonce recording")
SENSE_CODE(0x6F07, "Conflict in binding nonce recording")
/*
 *	SENSE_CODE(0x70NN, "Decompression exception short algorithm id of nn")
 */
SENSE_CODE(0x7100, "Decompression exception long algorithm id")

SENSE_CODE(0x7200, "Session fixation error")
SENSE_CODE(0x7201, "Session fixation error writing lead-in")
SENSE_CODE(0x7202, "Session fixation error writing lead-out")
SENSE_CODE(0x7203, "Session fixation error - incomplete track in session")
SENSE_CODE(0x7204, "Empty or partially written reserved track")
SENSE_CODE(0x7205, "No more track reservations allowed")
SENSE_CODE(0x7206, "RMZ extension is not allowed")
SENSE_CODE(0x7207, "No more test zone extensions are allowed")

SENSE_CODE(0x7300, "Cd control error")
SENSE_CODE(0x7301, "Power calibration area almost full")
SENSE_CODE(0x7302, "Power calibration area is full")
SENSE_CODE(0x7303, "Power calibration area error")
SENSE_CODE(0x7304, "Program memory area update failure")
SENSE_CODE(0x7305, "Program memory area is full")
SENSE_CODE(0x7306, "RMA/PMA is almost full")
SENSE_CODE(0x7310, "Current power calibration area almost full")
SENSE_CODE(0x7311, "Current power calibration area is full")
SENSE_CODE(0x7317, "RDZ is full")

SENSE_CODE(0x7400, "Security error")
SENSE_CODE(0x7401, "Unable to decrypt data")
SENSE_CODE(0x7402, "Unencrypted data encountered while decrypting")
SENSE_CODE(0x7403, "Incorrect data encryption key")
SENSE_CODE(0x7404, "Cryptographic integrity validation failed")
SENSE_CODE(0x7405, "Error decrypting data")
SENSE_CODE(0x7406, "Unknown signature verification key")
SENSE_CODE(0x7407, "Encryption parameters not useable")
SENSE_CODE(0x7408, "Digital signature validation failure")
SENSE_CODE(0x7409, "Encryption mode mismatch on read")
SENSE_CODE(0x740A, "Encrypted block not raw read enabled")
SENSE_CODE(0x740B, "Incorrect Encryption parameters")
SENSE_CODE(0x740C, "Unable to decrypt parameter list")
SENSE_CODE(0x740D, "Encryption algorithm disabled")
SENSE_CODE(0x7410, "SA creation parameter value invalid")
SENSE_CODE(0x7411, "SA creation parameter value rejected")
SENSE_CODE(0x7412, "Invalid SA usage")
SENSE_CODE(0x7421, "Data Encryption configuration prevented")
SENSE_CODE(0x7430, "SA creation parameter not supported")
SENSE_CODE(0x7440, "Authentication failed")
SENSE_CODE(0x7461, "External data encryption key manager access error")
SENSE_CODE(0x7462, "External data encryption key manager error")
SENSE_CODE(0x7463, "External data encryption key not found")
SENSE_CODE(0x7464, "External data encryption request not authorized")
SENSE_CODE(0x746E, "External data encryption control timeout")
SENSE_CODE(0x746F, "External data encryption control error")
SENSE_CODE(0x7471, "Logical unit access not authorized")
SENSE_CODE(0x7479, "Security conflict in translated device")
