/*
 * Copyright (c) 2010 Broadcom Corporation
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <linux/types.h>
#include <sbhnddma.h>
#include <wlc_phy_int.h>
#include <wlc_phytbl_lcn.h>

const u32 dot11lcn_gain_tbl_rev0[] = {
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000d,
	0x0000004d,
	0x0000008d,
	0x0000000d,
	0x0000004d,
	0x0000008d,
	0x000000cd,
	0x0000004f,
	0x0000008f,
	0x000000cf,
	0x000000d3,
	0x00000113,
	0x00000513,
	0x00000913,
	0x00000953,
	0x00000d53,
	0x00001153,
	0x00001193,
	0x00005193,
	0x00009193,
	0x0000d193,
	0x00011193,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000d,
	0x0000004d,
	0x0000008d,
	0x0000000d,
	0x0000004d,
	0x0000008d,
	0x000000cd,
	0x0000004f,
	0x0000008f,
	0x000000cf,
	0x000000d3,
	0x00000113,
	0x00000513,
	0x00000913,
	0x00000953,
	0x00000d53,
	0x00001153,
	0x00005153,
	0x00009153,
	0x0000d153,
	0x00011153,
	0x00015153,
	0x00019153,
	0x0001d153,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

const u32 dot11lcn_gain_tbl_rev1[] = {
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000008,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000D,
	0x00000011,
	0x00000051,
	0x00000091,
	0x00000011,
	0x00000051,
	0x00000091,
	0x000000d1,
	0x00000053,
	0x00000093,
	0x000000d3,
	0x000000d7,
	0x00000117,
	0x00000517,
	0x00000917,
	0x00000957,
	0x00000d57,
	0x00001157,
	0x00001197,
	0x00005197,
	0x00009197,
	0x0000d197,
	0x00011197,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000008,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000D,
	0x00000011,
	0x00000051,
	0x00000091,
	0x00000011,
	0x00000051,
	0x00000091,
	0x000000d1,
	0x00000053,
	0x00000093,
	0x000000d3,
	0x000000d7,
	0x00000117,
	0x00000517,
	0x00000917,
	0x00000957,
	0x00000d57,
	0x00001157,
	0x00005157,
	0x00009157,
	0x0000d157,
	0x00011157,
	0x00015157,
	0x00019157,
	0x0001d157,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

const u16 dot11lcn_aux_gain_idx_tbl_rev0[] = {
	0x0401,
	0x0402,
	0x0403,
	0x0404,
	0x0405,
	0x0406,
	0x0407,
	0x0408,
	0x0409,
	0x040a,
	0x058b,
	0x058c,
	0x058d,
	0x058e,
	0x058f,
	0x0090,
	0x0091,
	0x0092,
	0x0193,
	0x0194,
	0x0195,
	0x0196,
	0x0197,
	0x0198,
	0x0199,
	0x019a,
	0x019b,
	0x019c,
	0x019d,
	0x019e,
	0x019f,
	0x01a0,
	0x01a1,
	0x01a2,
	0x01a3,
	0x01a4,
	0x01a5,
	0x0000,
};

const u32 dot11lcn_gain_idx_tbl_rev0[] = {
	0x00000000,
	0x00000000,
	0x10000000,
	0x00000000,
	0x20000000,
	0x00000000,
	0x30000000,
	0x00000000,
	0x40000000,
	0x00000000,
	0x50000000,
	0x00000000,
	0x60000000,
	0x00000000,
	0x70000000,
	0x00000000,
	0x80000000,
	0x00000000,
	0x90000000,
	0x00000008,
	0xa0000000,
	0x00000008,
	0xb0000000,
	0x00000008,
	0xc0000000,
	0x00000008,
	0xd0000000,
	0x00000008,
	0xe0000000,
	0x00000008,
	0xf0000000,
	0x00000008,
	0x00000000,
	0x00000009,
	0x10000000,
	0x00000009,
	0x20000000,
	0x00000019,
	0x30000000,
	0x00000019,
	0x40000000,
	0x00000019,
	0x50000000,
	0x00000019,
	0x60000000,
	0x00000019,
	0x70000000,
	0x00000019,
	0x80000000,
	0x00000019,
	0x90000000,
	0x00000019,
	0xa0000000,
	0x00000019,
	0xb0000000,
	0x00000019,
	0xc0000000,
	0x00000019,
	0xd0000000,
	0x00000019,
	0xe0000000,
	0x00000019,
	0xf0000000,
	0x00000019,
	0x00000000,
	0x0000001a,
	0x10000000,
	0x0000001a,
	0x20000000,
	0x0000001a,
	0x30000000,
	0x0000001a,
	0x40000000,
	0x0000001a,
	0x50000000,
	0x00000002,
	0x60000000,
	0x00000002,
	0x70000000,
	0x00000002,
	0x80000000,
	0x00000002,
	0x90000000,
	0x00000002,
	0xa0000000,
	0x00000002,
	0xb0000000,
	0x00000002,
	0xc0000000,
	0x0000000a,
	0xd0000000,
	0x0000000a,
	0xe0000000,
	0x0000000a,
	0xf0000000,
	0x0000000a,
	0x00000000,
	0x0000000b,
	0x10000000,
	0x0000000b,
	0x20000000,
	0x0000000b,
	0x30000000,
	0x0000000b,
	0x40000000,
	0x0000000b,
	0x50000000,
	0x0000001b,
	0x60000000,
	0x0000001b,
	0x70000000,
	0x0000001b,
	0x80000000,
	0x0000001b,
	0x90000000,
	0x0000001b,
	0xa0000000,
	0x0000001b,
	0xb0000000,
	0x0000001b,
	0xc0000000,
	0x0000001b,
	0xd0000000,
	0x0000001b,
	0xe0000000,
	0x0000001b,
	0xf0000000,
	0x0000001b,
	0x00000000,
	0x0000001c,
	0x10000000,
	0x0000001c,
	0x20000000,
	0x0000001c,
	0x30000000,
	0x0000001c,
	0x40000000,
	0x0000001c,
	0x50000000,
	0x0000001c,
	0x60000000,
	0x0000001c,
	0x70000000,
	0x0000001c,
	0x80000000,
	0x0000001c,
	0x90000000,
	0x0000001c,
};

const u16 dot11lcn_aux_gain_idx_tbl_2G[] = {
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0001,
	0x0080,
	0x0081,
	0x0100,
	0x0101,
	0x0180,
	0x0181,
	0x0182,
	0x0183,
	0x0184,
	0x0185,
	0x0186,
	0x0187,
	0x0188,
	0x0285,
	0x0289,
	0x028a,
	0x028b,
	0x028c,
	0x028d,
	0x028e,
	0x028f,
	0x0290,
	0x0291,
	0x0292,
	0x0293,
	0x0294,
	0x0295,
	0x0296,
	0x0297,
	0x0298,
	0x0299,
	0x029a,
	0x0000
};

const u8 dot11lcn_gain_val_tbl_2G[] = {
	0xfc,
	0x02,
	0x08,
	0x0e,
	0x13,
	0x1b,
	0xfc,
	0x02,
	0x08,
	0x0e,
	0x13,
	0x1b,
	0xfc,
	0x00,
	0x0c,
	0x03,
	0xeb,
	0xfe,
	0x07,
	0x0b,
	0x0f,
	0xfb,
	0xfe,
	0x01,
	0x05,
	0x08,
	0x0b,
	0x0e,
	0x11,
	0x14,
	0x17,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x15,
	0x18,
	0x1b,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00
};

const u32 dot11lcn_gain_idx_tbl_2G[] = {
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x10000000,
	0x00000000,
	0x00000000,
	0x00000008,
	0x10000000,
	0x00000008,
	0x00000000,
	0x00000010,
	0x10000000,
	0x00000010,
	0x00000000,
	0x00000018,
	0x10000000,
	0x00000018,
	0x20000000,
	0x00000018,
	0x30000000,
	0x00000018,
	0x40000000,
	0x00000018,
	0x50000000,
	0x00000018,
	0x60000000,
	0x00000018,
	0x70000000,
	0x00000018,
	0x80000000,
	0x00000018,
	0x50000000,
	0x00000028,
	0x90000000,
	0x00000028,
	0xa0000000,
	0x00000028,
	0xb0000000,
	0x00000028,
	0xc0000000,
	0x00000028,
	0xd0000000,
	0x00000028,
	0xe0000000,
	0x00000028,
	0xf0000000,
	0x00000028,
	0x00000000,
	0x00000029,
	0x10000000,
	0x00000029,
	0x20000000,
	0x00000029,
	0x30000000,
	0x00000029,
	0x40000000,
	0x00000029,
	0x50000000,
	0x00000029,
	0x60000000,
	0x00000029,
	0x70000000,
	0x00000029,
	0x80000000,
	0x00000029,
	0x90000000,
	0x00000029,
	0xa0000000,
	0x00000029,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x10000000,
	0x00000000,
	0x00000000,
	0x00000008,
	0x10000000,
	0x00000008,
	0x00000000,
	0x00000010,
	0x10000000,
	0x00000010,
	0x00000000,
	0x00000018,
	0x10000000,
	0x00000018,
	0x20000000,
	0x00000018,
	0x30000000,
	0x00000018,
	0x40000000,
	0x00000018,
	0x50000000,
	0x00000018,
	0x60000000,
	0x00000018,
	0x70000000,
	0x00000018,
	0x80000000,
	0x00000018,
	0x50000000,
	0x00000028,
	0x90000000,
	0x00000028,
	0xa0000000,
	0x00000028,
	0xb0000000,
	0x00000028,
	0xc0000000,
	0x00000028,
	0xd0000000,
	0x00000028,
	0xe0000000,
	0x00000028,
	0xf0000000,
	0x00000028,
	0x00000000,
	0x00000029,
	0x10000000,
	0x00000029,
	0x20000000,
	0x00000029,
	0x30000000,
	0x00000029,
	0x40000000,
	0x00000029,
	0x50000000,
	0x00000029,
	0x60000000,
	0x00000029,
	0x70000000,
	0x00000029,
	0x80000000,
	0x00000029,
	0x90000000,
	0x00000029,
	0xa0000000,
	0x00000029,
	0xb0000000,
	0x00000029,
	0xc0000000,
	0x00000029,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const u32 dot11lcn_gain_tbl_2G[] = {
	0x00000000,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000d,
	0x0000004d,
	0x0000008d,
	0x00000049,
	0x00000089,
	0x000000c9,
	0x0000004b,
	0x0000008b,
	0x000000cb,
	0x000000cf,
	0x0000010f,
	0x0000050f,
	0x0000090f,
	0x0000094f,
	0x00000d4f,
	0x0000114f,
	0x0000118f,
	0x0000518f,
	0x0000918f,
	0x0000d18f,
	0x0001118f,
	0x0001518f,
	0x0001918f,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const u32 dot11lcn_gain_tbl_extlna_2G[] = {
	0x00000000,
	0x00000004,
	0x00000008,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000d,
	0x00000003,
	0x00000007,
	0x0000000b,
	0x0000000f,
	0x0000004f,
	0x0000008f,
	0x000000cf,
	0x0000010f,
	0x0000014f,
	0x0000018f,
	0x0000058f,
	0x0000098f,
	0x00000d8f,
	0x00008000,
	0x00008004,
	0x00008008,
	0x00008001,
	0x00008005,
	0x00008009,
	0x0000800d,
	0x00008003,
	0x00008007,
	0x0000800b,
	0x0000800f,
	0x0000804f,
	0x0000808f,
	0x000080cf,
	0x0000810f,
	0x0000814f,
	0x0000818f,
	0x0000858f,
	0x0000898f,
	0x00008d8f,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const u16 dot11lcn_aux_gain_idx_tbl_extlna_2G[] = {
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0400,
	0x0401,
	0x0402,
	0x0403,
	0x0404,
	0x0483,
	0x0484,
	0x0485,
	0x0486,
	0x0583,
	0x0584,
	0x0585,
	0x0587,
	0x0588,
	0x0589,
	0x058a,
	0x0687,
	0x0688,
	0x0689,
	0x068a,
	0x068b,
	0x068c,
	0x068d,
	0x068e,
	0x068f,
	0x0690,
	0x0691,
	0x0692,
	0x0693,
	0x0000
};

const u8 dot11lcn_gain_val_tbl_extlna_2G[] = {
	0xfc,
	0x02,
	0x08,
	0x0e,
	0x13,
	0x1b,
	0xfc,
	0x02,
	0x08,
	0x0e,
	0x13,
	0x1b,
	0xfc,
	0x00,
	0x0f,
	0x03,
	0xeb,
	0xfe,
	0x07,
	0x0b,
	0x0f,
	0xfb,
	0xfe,
	0x01,
	0x05,
	0x08,
	0x0b,
	0x0e,
	0x11,
	0x14,
	0x17,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x15,
	0x18,
	0x1b,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00
};

const u32 dot11lcn_gain_idx_tbl_extlna_2G[] = {
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000040,
	0x10000000,
	0x00000040,
	0x20000000,
	0x00000040,
	0x30000000,
	0x00000040,
	0x40000000,
	0x00000040,
	0x30000000,
	0x00000048,
	0x40000000,
	0x00000048,
	0x50000000,
	0x00000048,
	0x60000000,
	0x00000048,
	0x30000000,
	0x00000058,
	0x40000000,
	0x00000058,
	0x50000000,
	0x00000058,
	0x70000000,
	0x00000058,
	0x80000000,
	0x00000058,
	0x90000000,
	0x00000058,
	0xa0000000,
	0x00000058,
	0x70000000,
	0x00000068,
	0x80000000,
	0x00000068,
	0x90000000,
	0x00000068,
	0xa0000000,
	0x00000068,
	0xb0000000,
	0x00000068,
	0xc0000000,
	0x00000068,
	0xd0000000,
	0x00000068,
	0xe0000000,
	0x00000068,
	0xf0000000,
	0x00000068,
	0x00000000,
	0x00000069,
	0x10000000,
	0x00000069,
	0x20000000,
	0x00000069,
	0x30000000,
	0x00000069,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x40000000,
	0x00000041,
	0x50000000,
	0x00000041,
	0x60000000,
	0x00000041,
	0x70000000,
	0x00000041,
	0x80000000,
	0x00000041,
	0x70000000,
	0x00000049,
	0x80000000,
	0x00000049,
	0x90000000,
	0x00000049,
	0xa0000000,
	0x00000049,
	0x70000000,
	0x00000059,
	0x80000000,
	0x00000059,
	0x90000000,
	0x00000059,
	0xb0000000,
	0x00000059,
	0xc0000000,
	0x00000059,
	0xd0000000,
	0x00000059,
	0xe0000000,
	0x00000059,
	0xb0000000,
	0x00000069,
	0xc0000000,
	0x00000069,
	0xd0000000,
	0x00000069,
	0xe0000000,
	0x00000069,
	0xf0000000,
	0x00000069,
	0x00000000,
	0x0000006a,
	0x10000000,
	0x0000006a,
	0x20000000,
	0x0000006a,
	0x30000000,
	0x0000006a,
	0x40000000,
	0x0000006a,
	0x50000000,
	0x0000006a,
	0x60000000,
	0x0000006a,
	0x70000000,
	0x0000006a,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const u32 dot11lcn_aux_gain_idx_tbl_5G[] = {
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0001,
	0x0002,
	0x0003,
	0x0004,
	0x0083,
	0x0084,
	0x0085,
	0x0086,
	0x0087,
	0x0186,
	0x0187,
	0x0188,
	0x0189,
	0x018a,
	0x018b,
	0x018c,
	0x018d,
	0x018e,
	0x018f,
	0x0190,
	0x0191,
	0x0192,
	0x0193,
	0x0194,
	0x0195,
	0x0196,
	0x0197,
	0x0198,
	0x0199,
	0x019a,
	0x019b,
	0x019c,
	0x019d,
	0x0000
};

const u32 dot11lcn_gain_val_tbl_5G[] = {
	0xf7,
	0xfd,
	0x00,
	0x04,
	0x04,
	0x04,
	0xf7,
	0xfd,
	0x00,
	0x04,
	0x04,
	0x04,
	0xf6,
	0x00,
	0x0c,
	0x03,
	0xeb,
	0xfe,
	0x06,
	0x0a,
	0x10,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x15,
	0x18,
	0x1b,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x15,
	0x18,
	0x1b,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00
};

const u32 dot11lcn_gain_idx_tbl_5G[] = {
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x10000000,
	0x00000000,
	0x20000000,
	0x00000000,
	0x30000000,
	0x00000000,
	0x40000000,
	0x00000000,
	0x30000000,
	0x00000008,
	0x40000000,
	0x00000008,
	0x50000000,
	0x00000008,
	0x60000000,
	0x00000008,
	0x70000000,
	0x00000008,
	0x60000000,
	0x00000018,
	0x70000000,
	0x00000018,
	0x80000000,
	0x00000018,
	0x90000000,
	0x00000018,
	0xa0000000,
	0x00000018,
	0xb0000000,
	0x00000018,
	0xc0000000,
	0x00000018,
	0xd0000000,
	0x00000018,
	0xe0000000,
	0x00000018,
	0xf0000000,
	0x00000018,
	0x00000000,
	0x00000019,
	0x10000000,
	0x00000019,
	0x20000000,
	0x00000019,
	0x30000000,
	0x00000019,
	0x40000000,
	0x00000019,
	0x50000000,
	0x00000019,
	0x60000000,
	0x00000019,
	0x70000000,
	0x00000019,
	0x80000000,
	0x00000019,
	0x90000000,
	0x00000019,
	0xa0000000,
	0x00000019,
	0xb0000000,
	0x00000019,
	0xc0000000,
	0x00000019,
	0xd0000000,
	0x00000019,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const u32 dot11lcn_gain_tbl_5G[] = {
	0x00000000,
	0x00000040,
	0x00000080,
	0x00000001,
	0x00000005,
	0x00000009,
	0x0000000d,
	0x00000011,
	0x00000015,
	0x00000055,
	0x00000095,
	0x00000017,
	0x0000001b,
	0x0000005b,
	0x0000009b,
	0x000000db,
	0x0000011b,
	0x0000015b,
	0x0000019b,
	0x0000059b,
	0x0000099b,
	0x00000d9b,
	0x0000119b,
	0x0000519b,
	0x0000919b,
	0x0000d19b,
	0x0001119b,
	0x0001519b,
	0x0001919b,
	0x0001d19b,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_rev0[] = {
	{&dot11lcn_gain_tbl_rev0,
	 sizeof(dot11lcn_gain_tbl_rev0) / sizeof(dot11lcn_gain_tbl_rev0[0]), 18,
	 0, 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_gain_idx_tbl_rev0[0]), 13, 0, 32}
	,
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_rev1[] = {
	{&dot11lcn_gain_tbl_rev1,
	 sizeof(dot11lcn_gain_tbl_rev1) / sizeof(dot11lcn_gain_tbl_rev1[0]), 18,
	 0, 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_gain_idx_tbl_rev0[0]), 13, 0, 32}
	,
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_2G_rev2[] = {
	{&dot11lcn_gain_tbl_2G,
	 sizeof(dot11lcn_gain_tbl_2G) / sizeof(dot11lcn_gain_tbl_2G[0]), 18, 0,
	 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_2G,
	 sizeof(dot11lcn_aux_gain_idx_tbl_2G) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_2G[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_2G,
	 sizeof(dot11lcn_gain_idx_tbl_2G) / sizeof(dot11lcn_gain_idx_tbl_2G[0]),
	 13, 0, 32}
	,
	{&dot11lcn_gain_val_tbl_2G,
	 sizeof(dot11lcn_gain_val_tbl_2G) / sizeof(dot11lcn_gain_val_tbl_2G[0]),
	 17, 0, 8}
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_5G_rev2[] = {
	{&dot11lcn_gain_tbl_5G,
	 sizeof(dot11lcn_gain_tbl_5G) / sizeof(dot11lcn_gain_tbl_5G[0]), 18, 0,
	 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_5G,
	 sizeof(dot11lcn_aux_gain_idx_tbl_5G) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_5G[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_5G,
	 sizeof(dot11lcn_gain_idx_tbl_5G) / sizeof(dot11lcn_gain_idx_tbl_5G[0]),
	 13, 0, 32}
	,
	{&dot11lcn_gain_val_tbl_5G,
	 sizeof(dot11lcn_gain_val_tbl_5G) / sizeof(dot11lcn_gain_val_tbl_5G[0]),
	 17, 0, 8}
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_extlna_2G_rev2[] = {
	{&dot11lcn_gain_tbl_extlna_2G,
	 sizeof(dot11lcn_gain_tbl_extlna_2G) /
	 sizeof(dot11lcn_gain_tbl_extlna_2G[0]), 18, 0, 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_extlna_2G,
	 sizeof(dot11lcn_aux_gain_idx_tbl_extlna_2G) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_extlna_2G[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_extlna_2G,
	 sizeof(dot11lcn_gain_idx_tbl_extlna_2G) /
	 sizeof(dot11lcn_gain_idx_tbl_extlna_2G[0]), 13, 0, 32}
	,
	{&dot11lcn_gain_val_tbl_extlna_2G,
	 sizeof(dot11lcn_gain_val_tbl_extlna_2G) /
	 sizeof(dot11lcn_gain_val_tbl_extlna_2G[0]), 17, 0, 8}
};

const dot11lcnphytbl_info_t dot11lcnphytbl_rx_gain_info_extlna_5G_rev2[] = {
	{&dot11lcn_gain_tbl_5G,
	 sizeof(dot11lcn_gain_tbl_5G) / sizeof(dot11lcn_gain_tbl_5G[0]), 18, 0,
	 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_5G,
	 sizeof(dot11lcn_aux_gain_idx_tbl_5G) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_5G[0]), 14, 0, 16}
	,
	{&dot11lcn_gain_idx_tbl_5G,
	 sizeof(dot11lcn_gain_idx_tbl_5G) / sizeof(dot11lcn_gain_idx_tbl_5G[0]),
	 13, 0, 32}
	,
	{&dot11lcn_gain_val_tbl_5G,
	 sizeof(dot11lcn_gain_val_tbl_5G) / sizeof(dot11lcn_gain_val_tbl_5G[0]),
	 17, 0, 8}
};

const u32 dot11lcnphytbl_rx_gain_info_sz_rev0 =
    sizeof(dot11lcnphytbl_rx_gain_info_rev0) /
    sizeof(dot11lcnphytbl_rx_gain_info_rev0[0]);

const u32 dot11lcnphytbl_rx_gain_info_sz_rev1 =
    sizeof(dot11lcnphytbl_rx_gain_info_rev1) /
    sizeof(dot11lcnphytbl_rx_gain_info_rev1[0]);

const u32 dot11lcnphytbl_rx_gain_info_2G_rev2_sz =
    sizeof(dot11lcnphytbl_rx_gain_info_2G_rev2) /
    sizeof(dot11lcnphytbl_rx_gain_info_2G_rev2[0]);

const u32 dot11lcnphytbl_rx_gain_info_5G_rev2_sz =
    sizeof(dot11lcnphytbl_rx_gain_info_5G_rev2) /
    sizeof(dot11lcnphytbl_rx_gain_info_5G_rev2[0]);

const u16 dot11lcn_min_sig_sq_tbl_rev0[] = {
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
	0x014d,
};

const u16 dot11lcn_noise_scale_tbl_rev0[] = {
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
};

const u32 dot11lcn_fltr_ctrl_tbl_rev0[] = {
	0x000141f8,
	0x000021f8,
	0x000021fb,
	0x000041fb,
	0x0001fe4b,
	0x0000217b,
	0x00002133,
	0x000040eb,
	0x0001fea3,
	0x0000024b,
};

const u32 dot11lcn_ps_ctrl_tbl_rev0[] = {
	0x00100001,
	0x00200010,
	0x00300001,
	0x00400010,
	0x00500022,
	0x00600122,
	0x00700222,
	0x00800322,
	0x00900422,
	0x00a00522,
	0x00b00622,
	0x00c00722,
	0x00d00822,
	0x00f00922,
	0x00100a22,
	0x00200b22,
	0x00300c22,
	0x00400d22,
	0x00500e22,
	0x00600f22,
};

const u16 dot11lcn_sw_ctrl_tbl_4313_epa_rev0_combo[] = {
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x0007,
	0x0005,
	0x0006,
	0x0004,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,
	0x000b,
	0x000b,
	0x000a,
	0x000a,

};

const u16 dot11lcn_sw_ctrl_tbl_4313_bt_epa_p250_rev0[] = {
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0005,
	0x0002,
	0x0000,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
	0x0007,
	0x0007,
	0x0002,
	0x0002,
};

const u16 dot11lcn_sw_ctrl_tbl_4313_epa_rev0[] = {
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
	0x0002,
	0x0008,
	0x0004,
	0x0001,
};

const u16 dot11lcn_sw_ctrl_tbl_4313_rev0[] = {
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
	0x000a,
	0x0009,
	0x0006,
	0x0005,
};

const u16 dot11lcn_sw_ctrl_tbl_rev0[] = {
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
	0x0004,
	0x0004,
	0x0002,
	0x0002,
};

const u8 dot11lcn_nf_table_rev0[] = {
	0x5f,
	0x36,
	0x29,
	0x1f,
	0x5f,
	0x36,
	0x29,
	0x1f,
	0x5f,
	0x36,
	0x29,
	0x1f,
	0x5f,
	0x36,
	0x29,
	0x1f,
};

const u8 dot11lcn_gain_val_tbl_rev0[] = {
	0x09,
	0x0f,
	0x14,
	0x18,
	0xfe,
	0x07,
	0x0b,
	0x0f,
	0xfb,
	0xfe,
	0x01,
	0x05,
	0x08,
	0x0b,
	0x0e,
	0x11,
	0x14,
	0x17,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0x06,
	0x09,
	0x0c,
	0x0f,
	0x12,
	0x15,
	0x18,
	0x1b,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x03,
	0xeb,
	0x00,
	0x00,
};

const u8 dot11lcn_spur_tbl_rev0[] = {
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x02,
	0x03,
	0x01,
	0x03,
	0x02,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x02,
	0x03,
	0x01,
	0x03,
	0x02,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
	0x01,
};

const u16 dot11lcn_unsup_mcs_tbl_rev0[] = {
	0x001a,
	0x0034,
	0x004e,
	0x0068,
	0x009c,
	0x00d0,
	0x00ea,
	0x0104,
	0x0034,
	0x0068,
	0x009c,
	0x00d0,
	0x0138,
	0x01a0,
	0x01d4,
	0x0208,
	0x004e,
	0x009c,
	0x00ea,
	0x0138,
	0x01d4,
	0x0270,
	0x02be,
	0x030c,
	0x0068,
	0x00d0,
	0x0138,
	0x01a0,
	0x0270,
	0x0340,
	0x03a8,
	0x0410,
	0x0018,
	0x009c,
	0x00d0,
	0x0104,
	0x00ea,
	0x0138,
	0x0186,
	0x00d0,
	0x0104,
	0x0104,
	0x0138,
	0x016c,
	0x016c,
	0x01a0,
	0x0138,
	0x0186,
	0x0186,
	0x01d4,
	0x0222,
	0x0222,
	0x0270,
	0x0104,
	0x0138,
	0x016c,
	0x0138,
	0x016c,
	0x01a0,
	0x01d4,
	0x01a0,
	0x01d4,
	0x0208,
	0x0208,
	0x023c,
	0x0186,
	0x01d4,
	0x0222,
	0x01d4,
	0x0222,
	0x0270,
	0x02be,
	0x0270,
	0x02be,
	0x030c,
	0x030c,
	0x035a,
	0x0036,
	0x006c,
	0x00a2,
	0x00d8,
	0x0144,
	0x01b0,
	0x01e6,
	0x021c,
	0x006c,
	0x00d8,
	0x0144,
	0x01b0,
	0x0288,
	0x0360,
	0x03cc,
	0x0438,
	0x00a2,
	0x0144,
	0x01e6,
	0x0288,
	0x03cc,
	0x0510,
	0x05b2,
	0x0654,
	0x00d8,
	0x01b0,
	0x0288,
	0x0360,
	0x0510,
	0x06c0,
	0x0798,
	0x0870,
	0x0018,
	0x0144,
	0x01b0,
	0x021c,
	0x01e6,
	0x0288,
	0x032a,
	0x01b0,
	0x021c,
	0x021c,
	0x0288,
	0x02f4,
	0x02f4,
	0x0360,
	0x0288,
	0x032a,
	0x032a,
	0x03cc,
	0x046e,
	0x046e,
	0x0510,
	0x021c,
	0x0288,
	0x02f4,
	0x0288,
	0x02f4,
	0x0360,
	0x03cc,
	0x0360,
	0x03cc,
	0x0438,
	0x0438,
	0x04a4,
	0x032a,
	0x03cc,
	0x046e,
	0x03cc,
	0x046e,
	0x0510,
	0x05b2,
	0x0510,
	0x05b2,
	0x0654,
	0x0654,
	0x06f6,
};

const u16 dot11lcn_iq_local_tbl_rev0[] = {
	0x0200,
	0x0300,
	0x0400,
	0x0600,
	0x0800,
	0x0b00,
	0x1000,
	0x1001,
	0x1002,
	0x1003,
	0x1004,
	0x1005,
	0x1006,
	0x1007,
	0x1707,
	0x2007,
	0x2d07,
	0x4007,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0200,
	0x0300,
	0x0400,
	0x0600,
	0x0800,
	0x0b00,
	0x1000,
	0x1001,
	0x1002,
	0x1003,
	0x1004,
	0x1005,
	0x1006,
	0x1007,
	0x1707,
	0x2007,
	0x2d07,
	0x4007,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x4000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
	0x0000,
};

const u32 dot11lcn_papd_compdelta_tbl_rev0[] = {
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
	0x00080000,
};

const dot11lcnphytbl_info_t dot11lcnphytbl_info_rev0[] = {
	{&dot11lcn_min_sig_sq_tbl_rev0,
	 sizeof(dot11lcn_min_sig_sq_tbl_rev0) /
	 sizeof(dot11lcn_min_sig_sq_tbl_rev0[0]), 2, 0, 16}
	,
	{&dot11lcn_noise_scale_tbl_rev0,
	 sizeof(dot11lcn_noise_scale_tbl_rev0) /
	 sizeof(dot11lcn_noise_scale_tbl_rev0[0]), 1, 0, 16}
	,
	{&dot11lcn_fltr_ctrl_tbl_rev0,
	 sizeof(dot11lcn_fltr_ctrl_tbl_rev0) /
	 sizeof(dot11lcn_fltr_ctrl_tbl_rev0[0]), 11, 0, 32}
	,
	{&dot11lcn_ps_ctrl_tbl_rev0,
	 sizeof(dot11lcn_ps_ctrl_tbl_rev0) /
	 sizeof(dot11lcn_ps_ctrl_tbl_rev0[0]), 12, 0, 32}
	,
	{&dot11lcn_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_gain_idx_tbl_rev0[0]), 13, 0, 32}
	,
	{&dot11lcn_aux_gain_idx_tbl_rev0,
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0) /
	 sizeof(dot11lcn_aux_gain_idx_tbl_rev0[0]), 14, 0, 16}
	,
	{&dot11lcn_sw_ctrl_tbl_rev0,
	 sizeof(dot11lcn_sw_ctrl_tbl_rev0) /
	 sizeof(dot11lcn_sw_ctrl_tbl_rev0[0]), 15, 0, 16}
	,
	{&dot11lcn_nf_table_rev0,
	 sizeof(dot11lcn_nf_table_rev0) / sizeof(dot11lcn_nf_table_rev0[0]), 16,
	 0, 8}
	,
	{&dot11lcn_gain_val_tbl_rev0,
	 sizeof(dot11lcn_gain_val_tbl_rev0) /
	 sizeof(dot11lcn_gain_val_tbl_rev0[0]), 17, 0, 8}
	,
	{&dot11lcn_gain_tbl_rev0,
	 sizeof(dot11lcn_gain_tbl_rev0) / sizeof(dot11lcn_gain_tbl_rev0[0]), 18,
	 0, 32}
	,
	{&dot11lcn_spur_tbl_rev0,
	 sizeof(dot11lcn_spur_tbl_rev0) / sizeof(dot11lcn_spur_tbl_rev0[0]), 20,
	 0, 8}
	,
	{&dot11lcn_unsup_mcs_tbl_rev0,
	 sizeof(dot11lcn_unsup_mcs_tbl_rev0) /
	 sizeof(dot11lcn_unsup_mcs_tbl_rev0[0]), 23, 0, 16}
	,
	{&dot11lcn_iq_local_tbl_rev0,
	 sizeof(dot11lcn_iq_local_tbl_rev0) /
	 sizeof(dot11lcn_iq_local_tbl_rev0[0]), 0, 0, 16}
	,
	{&dot11lcn_papd_compdelta_tbl_rev0,
	 sizeof(dot11lcn_papd_compdelta_tbl_rev0) /
	 sizeof(dot11lcn_papd_compdelta_tbl_rev0[0]), 24, 0, 32}
	,
};

const dot11lcnphytbl_info_t dot11lcn_sw_ctrl_tbl_info_4313 = {
	&dot11lcn_sw_ctrl_tbl_4313_rev0,
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_rev0) /
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_rev0[0]), 15, 0, 16
};

const dot11lcnphytbl_info_t dot11lcn_sw_ctrl_tbl_info_4313_epa = {
	&dot11lcn_sw_ctrl_tbl_4313_epa_rev0,
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_epa_rev0) /
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_epa_rev0[0]), 15, 0, 16
};

const dot11lcnphytbl_info_t dot11lcn_sw_ctrl_tbl_info_4313_bt_epa = {
	&dot11lcn_sw_ctrl_tbl_4313_epa_rev0_combo,
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_epa_rev0_combo) /
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_epa_rev0_combo[0]), 15, 0, 16
};

const dot11lcnphytbl_info_t dot11lcn_sw_ctrl_tbl_info_4313_bt_epa_p250 = {
	&dot11lcn_sw_ctrl_tbl_4313_bt_epa_p250_rev0,
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_bt_epa_p250_rev0) /
	    sizeof(dot11lcn_sw_ctrl_tbl_4313_bt_epa_p250_rev0[0]), 15, 0, 16
};

const u32 dot11lcnphytbl_info_sz_rev0 =
    sizeof(dot11lcnphytbl_info_rev0) / sizeof(dot11lcnphytbl_info_rev0[0]);

const lcnphy_tx_gain_tbl_entry dot11lcnphy_2GHz_extPA_gaintable_rev0[128] = {
	{3, 0, 31, 0, 72,}
	,
	{3, 0, 31, 0, 70,}
	,
	{3, 0, 31, 0, 68,}
	,
	{3, 0, 30, 0, 67,}
	,
	{3, 0, 29, 0, 68,}
	,
	{3, 0, 28, 0, 68,}
	,
	{3, 0, 27, 0, 69,}
	,
	{3, 0, 26, 0, 70,}
	,
	{3, 0, 25, 0, 70,}
	,
	{3, 0, 24, 0, 71,}
	,
	{3, 0, 23, 0, 72,}
	,
	{3, 0, 23, 0, 70,}
	,
	{3, 0, 22, 0, 71,}
	,
	{3, 0, 21, 0, 72,}
	,
	{3, 0, 21, 0, 70,}
	,
	{3, 0, 21, 0, 68,}
	,
	{3, 0, 21, 0, 66,}
	,
	{3, 0, 21, 0, 64,}
	,
	{3, 0, 21, 0, 63,}
	,
	{3, 0, 20, 0, 64,}
	,
	{3, 0, 19, 0, 65,}
	,
	{3, 0, 19, 0, 64,}
	,
	{3, 0, 18, 0, 65,}
	,
	{3, 0, 18, 0, 64,}
	,
	{3, 0, 17, 0, 65,}
	,
	{3, 0, 17, 0, 64,}
	,
	{3, 0, 16, 0, 65,}
	,
	{3, 0, 16, 0, 64,}
	,
	{3, 0, 16, 0, 62,}
	,
	{3, 0, 16, 0, 60,}
	,
	{3, 0, 16, 0, 58,}
	,
	{3, 0, 15, 0, 61,}
	,
	{3, 0, 15, 0, 59,}
	,
	{3, 0, 14, 0, 61,}
	,
	{3, 0, 14, 0, 60,}
	,
	{3, 0, 14, 0, 58,}
	,
	{3, 0, 13, 0, 60,}
	,
	{3, 0, 13, 0, 59,}
	,
	{3, 0, 12, 0, 62,}
	,
	{3, 0, 12, 0, 60,}
	,
	{3, 0, 12, 0, 58,}
	,
	{3, 0, 11, 0, 62,}
	,
	{3, 0, 11, 0, 60,}
	,
	{3, 0, 11, 0, 59,}
	,
	{3, 0, 11, 0, 57,}
	,
	{3, 0, 10, 0, 61,}
	,
	{3, 0, 10, 0, 59,}
	,
	{3, 0, 10, 0, 57,}
	,
	{3, 0, 9, 0, 62,}
	,
	{3, 0, 9, 0, 60,}
	,
	{3, 0, 9, 0, 58,}
	,
	{3, 0, 9, 0, 57,}
	,
	{3, 0, 8, 0, 62,}
	,
	{3, 0, 8, 0, 60,}
	,
	{3, 0, 8, 0, 58,}
	,
	{3, 0, 8, 0, 57,}
	,
	{3, 0, 8, 0, 55,}
	,
	{3, 0, 7, 0, 61,}
	,
	{3, 0, 7, 0, 60,}
	,
	{3, 0, 7, 0, 58,}
	,
	{3, 0, 7, 0, 56,}
	,
	{3, 0, 7, 0, 55,}
	,
	{3, 0, 6, 0, 62,}
	,
	{3, 0, 6, 0, 60,}
	,
	{3, 0, 6, 0, 58,}
	,
	{3, 0, 6, 0, 57,}
	,
	{3, 0, 6, 0, 55,}
	,
	{3, 0, 6, 0, 54,}
	,
	{3, 0, 6, 0, 52,}
	,
	{3, 0, 5, 0, 61,}
	,
	{3, 0, 5, 0, 59,}
	,
	{3, 0, 5, 0, 57,}
	,
	{3, 0, 5, 0, 56,}
	,
	{3, 0, 5, 0, 54,}
	,
	{3, 0, 5, 0, 53,}
	,
	{3, 0, 5, 0, 51,}
	,
	{3, 0, 4, 0, 62,}
	,
	{3, 0, 4, 0, 60,}
	,
	{3, 0, 4, 0, 58,}
	,
	{3, 0, 4, 0, 57,}
	,
	{3, 0, 4, 0, 55,}
	,
	{3, 0, 4, 0, 54,}
	,
	{3, 0, 4, 0, 52,}
	,
	{3, 0, 4, 0, 51,}
	,
	{3, 0, 4, 0, 49,}
	,
	{3, 0, 4, 0, 48,}
	,
	{3, 0, 4, 0, 46,}
	,
	{3, 0, 3, 0, 60,}
	,
	{3, 0, 3, 0, 58,}
	,
	{3, 0, 3, 0, 57,}
	,
	{3, 0, 3, 0, 55,}
	,
	{3, 0, 3, 0, 54,}
	,
	{3, 0, 3, 0, 52,}
	,
	{3, 0, 3, 0, 51,}
	,
	{3, 0, 3, 0, 49,}
	,
	{3, 0, 3, 0, 48,}
	,
	{3, 0, 3, 0, 46,}
	,
	{3, 0, 3, 0, 45,}
	,
	{3, 0, 3, 0, 44,}
	,
	{3, 0, 3, 0, 43,}
	,
	{3, 0, 3, 0, 41,}
	,
	{3, 0, 2, 0, 61,}
	,
	{3, 0, 2, 0, 59,}
	,
	{3, 0, 2, 0, 57,}
	,
	{3, 0, 2, 0, 56,}
	,
	{3, 0, 2, 0, 54,}
	,
	{3, 0, 2, 0, 53,}
	,
	{3, 0, 2, 0, 51,}
	,
	{3, 0, 2, 0, 50,}
	,
	{3, 0, 2, 0, 48,}
	,
	{3, 0, 2, 0, 47,}
	,
	{3, 0, 2, 0, 46,}
	,
	{3, 0, 2, 0, 44,}
	,
	{3, 0, 2, 0, 43,}
	,
	{3, 0, 2, 0, 42,}
	,
	{3, 0, 2, 0, 41,}
	,
	{3, 0, 2, 0, 39,}
	,
	{3, 0, 2, 0, 38,}
	,
	{3, 0, 2, 0, 37,}
	,
	{3, 0, 2, 0, 36,}
	,
	{3, 0, 2, 0, 35,}
	,
	{3, 0, 2, 0, 34,}
	,
	{3, 0, 2, 0, 33,}
	,
	{3, 0, 2, 0, 32,}
	,
	{3, 0, 1, 0, 63,}
	,
	{3, 0, 1, 0, 61,}
	,
	{3, 0, 1, 0, 59,}
	,
	{3, 0, 1, 0, 57,}
	,
};

const lcnphy_tx_gain_tbl_entry dot11lcnphy_2GHz_gaintable_rev0[128] = {
	{7, 0, 31, 0, 72,}
	,
	{7, 0, 31, 0, 70,}
	,
	{7, 0, 31, 0, 68,}
	,
	{7, 0, 30, 0, 67,}
	,
	{7, 0, 29, 0, 68,}
	,
	{7, 0, 28, 0, 68,}
	,
	{7, 0, 27, 0, 69,}
	,
	{7, 0, 26, 0, 70,}
	,
	{7, 0, 25, 0, 70,}
	,
	{7, 0, 24, 0, 71,}
	,
	{7, 0, 23, 0, 72,}
	,
	{7, 0, 23, 0, 70,}
	,
	{7, 0, 22, 0, 71,}
	,
	{7, 0, 21, 0, 72,}
	,
	{7, 0, 21, 0, 70,}
	,
	{7, 0, 21, 0, 68,}
	,
	{7, 0, 21, 0, 66,}
	,
	{7, 0, 21, 0, 64,}
	,
	{7, 0, 21, 0, 63,}
	,
	{7, 0, 20, 0, 64,}
	,
	{7, 0, 19, 0, 65,}
	,
	{7, 0, 19, 0, 64,}
	,
	{7, 0, 18, 0, 65,}
	,
	{7, 0, 18, 0, 64,}
	,
	{7, 0, 17, 0, 65,}
	,
	{7, 0, 17, 0, 64,}
	,
	{7, 0, 16, 0, 65,}
	,
	{7, 0, 16, 0, 64,}
	,
	{7, 0, 16, 0, 62,}
	,
	{7, 0, 16, 0, 60,}
	,
	{7, 0, 16, 0, 58,}
	,
	{7, 0, 15, 0, 61,}
	,
	{7, 0, 15, 0, 59,}
	,
	{7, 0, 14, 0, 61,}
	,
	{7, 0, 14, 0, 60,}
	,
	{7, 0, 14, 0, 58,}
	,
	{7, 0, 13, 0, 60,}
	,
	{7, 0, 13, 0, 59,}
	,
	{7, 0, 12, 0, 62,}
	,
	{7, 0, 12, 0, 60,}
	,
	{7, 0, 12, 0, 58,}
	,
	{7, 0, 11, 0, 62,}
	,
	{7, 0, 11, 0, 60,}
	,
	{7, 0, 11, 0, 59,}
	,
	{7, 0, 11, 0, 57,}
	,
	{7, 0, 10, 0, 61,}
	,
	{7, 0, 10, 0, 59,}
	,
	{7, 0, 10, 0, 57,}
	,
	{7, 0, 9, 0, 62,}
	,
	{7, 0, 9, 0, 60,}
	,
	{7, 0, 9, 0, 58,}
	,
	{7, 0, 9, 0, 57,}
	,
	{7, 0, 8, 0, 62,}
	,
	{7, 0, 8, 0, 60,}
	,
	{7, 0, 8, 0, 58,}
	,
	{7, 0, 8, 0, 57,}
	,
	{7, 0, 8, 0, 55,}
	,
	{7, 0, 7, 0, 61,}
	,
	{7, 0, 7, 0, 60,}
	,
	{7, 0, 7, 0, 58,}
	,
	{7, 0, 7, 0, 56,}
	,
	{7, 0, 7, 0, 55,}
	,
	{7, 0, 6, 0, 62,}
	,
	{7, 0, 6, 0, 60,}
	,
	{7, 0, 6, 0, 58,}
	,
	{7, 0, 6, 0, 57,}
	,
	{7, 0, 6, 0, 55,}
	,
	{7, 0, 6, 0, 54,}
	,
	{7, 0, 6, 0, 52,}
	,
	{7, 0, 5, 0, 61,}
	,
	{7, 0, 5, 0, 59,}
	,
	{7, 0, 5, 0, 57,}
	,
	{7, 0, 5, 0, 56,}
	,
	{7, 0, 5, 0, 54,}
	,
	{7, 0, 5, 0, 53,}
	,
	{7, 0, 5, 0, 51,}
	,
	{7, 0, 4, 0, 62,}
	,
	{7, 0, 4, 0, 60,}
	,
	{7, 0, 4, 0, 58,}
	,
	{7, 0, 4, 0, 57,}
	,
	{7, 0, 4, 0, 55,}
	,
	{7, 0, 4, 0, 54,}
	,
	{7, 0, 4, 0, 52,}
	,
	{7, 0, 4, 0, 51,}
	,
	{7, 0, 4, 0, 49,}
	,
	{7, 0, 4, 0, 48,}
	,
	{7, 0, 4, 0, 46,}
	,
	{7, 0, 3, 0, 60,}
	,
	{7, 0, 3, 0, 58,}
	,
	{7, 0, 3, 0, 57,}
	,
	{7, 0, 3, 0, 55,}
	,
	{7, 0, 3, 0, 54,}
	,
	{7, 0, 3, 0, 52,}
	,
	{7, 0, 3, 0, 51,}
	,
	{7, 0, 3, 0, 49,}
	,
	{7, 0, 3, 0, 48,}
	,
	{7, 0, 3, 0, 46,}
	,
	{7, 0, 3, 0, 45,}
	,
	{7, 0, 3, 0, 44,}
	,
	{7, 0, 3, 0, 43,}
	,
	{7, 0, 3, 0, 41,}
	,
	{7, 0, 2, 0, 61,}
	,
	{7, 0, 2, 0, 59,}
	,
	{7, 0, 2, 0, 57,}
	,
	{7, 0, 2, 0, 56,}
	,
	{7, 0, 2, 0, 54,}
	,
	{7, 0, 2, 0, 53,}
	,
	{7, 0, 2, 0, 51,}
	,
	{7, 0, 2, 0, 50,}
	,
	{7, 0, 2, 0, 48,}
	,
	{7, 0, 2, 0, 47,}
	,
	{7, 0, 2, 0, 46,}
	,
	{7, 0, 2, 0, 44,}
	,
	{7, 0, 2, 0, 43,}
	,
	{7, 0, 2, 0, 42,}
	,
	{7, 0, 2, 0, 41,}
	,
	{7, 0, 2, 0, 39,}
	,
	{7, 0, 2, 0, 38,}
	,
	{7, 0, 2, 0, 37,}
	,
	{7, 0, 2, 0, 36,}
	,
	{7, 0, 2, 0, 35,}
	,
	{7, 0, 2, 0, 34,}
	,
	{7, 0, 2, 0, 33,}
	,
	{7, 0, 2, 0, 32,}
	,
	{7, 0, 1, 0, 63,}
	,
	{7, 0, 1, 0, 61,}
	,
	{7, 0, 1, 0, 59,}
	,
	{7, 0, 1, 0, 57,}
	,
};

const lcnphy_tx_gain_tbl_entry dot11lcnphy_5GHz_gaintable_rev0[128] = {
	{255, 255, 0xf0, 0, 152,}
	,
	{255, 255, 0xf0, 0, 147,}
	,
	{255, 255, 0xf0, 0, 143,}
	,
	{255, 255, 0xf0, 0, 139,}
	,
	{255, 255, 0xf0, 0, 135,}
	,
	{255, 255, 0xf0, 0, 131,}
	,
	{255, 255, 0xf0, 0, 128,}
	,
	{255, 255, 0xf0, 0, 124,}
	,
	{255, 255, 0xf0, 0, 121,}
	,
	{255, 255, 0xf0, 0, 117,}
	,
	{255, 255, 0xf0, 0, 114,}
	,
	{255, 255, 0xf0, 0, 111,}
	,
	{255, 255, 0xf0, 0, 107,}
	,
	{255, 255, 0xf0, 0, 104,}
	,
	{255, 255, 0xf0, 0, 101,}
	,
	{255, 255, 0xf0, 0, 99,}
	,
	{255, 255, 0xf0, 0, 96,}
	,
	{255, 255, 0xf0, 0, 93,}
	,
	{255, 255, 0xf0, 0, 90,}
	,
	{255, 255, 0xf0, 0, 88,}
	,
	{255, 255, 0xf0, 0, 85,}
	,
	{255, 255, 0xf0, 0, 83,}
	,
	{255, 255, 0xf0, 0, 81,}
	,
	{255, 255, 0xf0, 0, 78,}
	,
	{255, 255, 0xf0, 0, 76,}
	,
	{255, 255, 0xf0, 0, 74,}
	,
	{255, 255, 0xf0, 0, 72,}
	,
	{255, 255, 0xf0, 0, 70,}
	,
	{255, 255, 0xf0, 0, 68,}
	,
	{255, 255, 0xf0, 0, 66,}
	,
	{255, 255, 0xf0, 0, 64,}
	,
	{255, 248, 0xf0, 0, 64,}
	,
	{255, 241, 0xf0, 0, 64,}
	,
	{255, 251, 0xe0, 0, 64,}
	,
	{255, 244, 0xe0, 0, 64,}
	,
	{255, 254, 0xd0, 0, 64,}
	,
	{255, 246, 0xd0, 0, 64,}
	,
	{255, 239, 0xd0, 0, 64,}
	,
	{255, 249, 0xc0, 0, 64,}
	,
	{255, 242, 0xc0, 0, 64,}
	,
	{255, 255, 0xb0, 0, 64,}
	,
	{255, 248, 0xb0, 0, 64,}
	,
	{255, 241, 0xb0, 0, 64,}
	,
	{255, 254, 0xa0, 0, 64,}
	,
	{255, 246, 0xa0, 0, 64,}
	,
	{255, 239, 0xa0, 0, 64,}
	,
	{255, 255, 0x90, 0, 64,}
	,
	{255, 248, 0x90, 0, 64,}
	,
	{255, 241, 0x90, 0, 64,}
	,
	{255, 234, 0x90, 0, 64,}
	,
	{255, 255, 0x80, 0, 64,}
	,
	{255, 248, 0x80, 0, 64,}
	,
	{255, 241, 0x80, 0, 64,}
	,
	{255, 234, 0x80, 0, 64,}
	,
	{255, 255, 0x70, 0, 64,}
	,
	{255, 248, 0x70, 0, 64,}
	,
	{255, 241, 0x70, 0, 64,}
	,
	{255, 234, 0x70, 0, 64,}
	,
	{255, 227, 0x70, 0, 64,}
	,
	{255, 221, 0x70, 0, 64,}
	,
	{255, 215, 0x70, 0, 64,}
	,
	{255, 208, 0x70, 0, 64,}
	,
	{255, 203, 0x70, 0, 64,}
	,
	{255, 197, 0x70, 0, 64,}
	,
	{255, 255, 0x60, 0, 64,}
	,
	{255, 248, 0x60, 0, 64,}
	,
	{255, 241, 0x60, 0, 64,}
	,
	{255, 234, 0x60, 0, 64,}
	,
	{255, 227, 0x60, 0, 64,}
	,
	{255, 221, 0x60, 0, 64,}
	,
	{255, 255, 0x50, 0, 64,}
	,
	{255, 248, 0x50, 0, 64,}
	,
	{255, 241, 0x50, 0, 64,}
	,
	{255, 234, 0x50, 0, 64,}
	,
	{255, 227, 0x50, 0, 64,}
	,
	{255, 221, 0x50, 0, 64,}
	,
	{255, 215, 0x50, 0, 64,}
	,
	{255, 208, 0x50, 0, 64,}
	,
	{255, 255, 0x40, 0, 64,}
	,
	{255, 248, 0x40, 0, 64,}
	,
	{255, 241, 0x40, 0, 64,}
	,
	{255, 234, 0x40, 0, 64,}
	,
	{255, 227, 0x40, 0, 64,}
	,
	{255, 221, 0x40, 0, 64,}
	,
	{255, 215, 0x40, 0, 64,}
	,
	{255, 208, 0x40, 0, 64,}
	,
	{255, 203, 0x40, 0, 64,}
	,
	{255, 197, 0x40, 0, 64,}
	,
	{255, 255, 0x30, 0, 64,}
	,
	{255, 248, 0x30, 0, 64,}
	,
	{255, 241, 0x30, 0, 64,}
	,
	{255, 234, 0x30, 0, 64,}
	,
	{255, 227, 0x30, 0, 64,}
	,
	{255, 221, 0x30, 0, 64,}
	,
	{255, 215, 0x30, 0, 64,}
	,
	{255, 208, 0x30, 0, 64,}
	,
	{255, 203, 0x30, 0, 64,}
	,
	{255, 197, 0x30, 0, 64,}
	,
	{255, 191, 0x30, 0, 64,}
	,
	{255, 186, 0x30, 0, 64,}
	,
	{255, 181, 0x30, 0, 64,}
	,
	{255, 175, 0x30, 0, 64,}
	,
	{255, 255, 0x20, 0, 64,}
	,
	{255, 248, 0x20, 0, 64,}
	,
	{255, 241, 0x20, 0, 64,}
	,
	{255, 234, 0x20, 0, 64,}
	,
	{255, 227, 0x20, 0, 64,}
	,
	{255, 221, 0x20, 0, 64,}
	,
	{255, 215, 0x20, 0, 64,}
	,
	{255, 208, 0x20, 0, 64,}
	,
	{255, 203, 0x20, 0, 64,}
	,
	{255, 197, 0x20, 0, 64,}
	,
	{255, 191, 0x20, 0, 64,}
	,
	{255, 186, 0x20, 0, 64,}
	,
	{255, 181, 0x20, 0, 64,}
	,
	{255, 175, 0x20, 0, 64,}
	,
	{255, 170, 0x20, 0, 64,}
	,
	{255, 166, 0x20, 0, 64,}
	,
	{255, 161, 0x20, 0, 64,}
	,
	{255, 156, 0x20, 0, 64,}
	,
	{255, 152, 0x20, 0, 64,}
	,
	{255, 148, 0x20, 0, 64,}
	,
	{255, 143, 0x20, 0, 64,}
	,
	{255, 139, 0x20, 0, 64,}
	,
	{255, 135, 0x20, 0, 64,}
	,
	{255, 132, 0x20, 0, 64,}
	,
	{255, 255, 0x10, 0, 64,}
	,
	{255, 248, 0x10, 0, 64,}
	,
};
