########################################################################
# Copyright (C) 2021 - 2023  Alejandro Colomar <alx@kernel.org>
# SPDX-License-Identifier:  GPL-3.0-or-later  OR  LGPL-3.0-or-later
########################################################################


ifndef MAKEFILE_BUILD_INCLUDED
MAKEFILE_BUILD_INCLUDED := 1


include $(srcdir)/lib/cmd.mk
include $(srcdir)/lib/src.mk


builddir := .tmp

SYSCONFDIR := $(srcdir)/etc

_MANDIR := $(builddir)/man


MKDIR := mkdir -p
RM    := rm


NONSO_MAN := $(shell $(FIND) $(MANDIR)/man*/ -type f \
		| $(GREP) '$(MANEXT)' \
		| $(XARGS) $(GREP) -l '^\.TH ' \
		| $(SORT))
_MANDIRS := $(patsubst $(MANDIR)/%,$(_MANDIR)/%/,$(MANDIRS))


$(_MANDIRS): %/: | $$(dir %) $(_MANDIR)/


$(builddir)/%/:
	+$(info MKDIR	$(@D)/)
	+$(MKDIR) $(@D)


.PHONY: build
build: build-catman build-html build-src
	@:

.PHONY: clean
clean:
	$(info RM -rf	$(builddir))
	$(RM) -rf $(builddir)


endif  # MAKEFILE_BUILD_INCLUDED
