/***************************************************************************
                           algo_pc1.cpp  -  PC1 algorithm
                               -------------------

    copyright            : (C) 1992 by Alexander PUKALL


 written in Borland Turbo C 2.0 on PC
 PC1 Cipher Algorithm ( Pukall Cipher 1 )
 By Alexander PUKALL 1991
 free code no restriction to use
 please include the name of the Author in the final software
 the Key is 128 bits
 Tested with Turbo C 2.0 for DOS and Microsoft Visual C++ 5.0 for Win 32

 Note that PC1COD.c is the encryption routine
 PC1DEC.c is the decryption routine
 Only the K zone change in the two routines
 You can create a single routine with the two parts in it


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <qfileinfo.h>

#include "kfilecoder.h"
#include "algo_pc1.h"
#include "resource.h"

extern BYTE *g_cConstantKey;

// ===========================================================================================================================
void pc1Assemble(UINT *x1a0, const BYTE *key, UINT *inter, UINT *i, UINT *x1a2, UINT *si)
{

	x1a0[0]= ( key[0]*256 )+ key[1];	
	(*inter) = pc1Code(x1a2, i, x1a0, si);

	x1a0[1]= x1a0[0] ^ ( (key[2]*256) + key[3] );	
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[2]= x1a0[1] ^ ( (key[4]*256) + key[5] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[3]= x1a0[2] ^ ( (key[6]*256) + key[7] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[4]= x1a0[3] ^ ( (key[8]*256) + key[9] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[5]= x1a0[4] ^ ( (key[10]*256) + key[11] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[6]= x1a0[5] ^ ( (key[12]*256) + key[13] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	x1a0[7]= x1a0[6] ^ ( (key[14]*256) + key[15] );
	(*inter) = (*inter) ^ pc1Code(x1a2, i, x1a0, si);

	(*i) = 0;
}

// ===========================================================================================================================
UINT pc1Code(UINT *x1a2, UINT *i, UINT *x1a0, UINT *si)
{
	UINT tmp; // used to swap
	UINT ax, bx, cx, dx;
	
	dx=(*x1a2)+(*i);
	ax=x1a0[(*i)];
	cx=0x015a;
	bx=0x4e35;

	tmp=ax; // swap(ax, si)
	ax=(*si);
	(*si)=tmp;

	tmp=ax; // swap(ax, dw)
	ax=dx;
	dx=tmp;

	if (ax!=0)
	{
		ax=ax*bx;
	}

	tmp=ax; // swap(ax, cx)
	ax=cx;
	cx=tmp;

	if (ax!=0)
	{
		ax=ax*(*si);
		cx=ax+cx;
	}

	tmp=ax; // swap (ax, si)
	ax=(*si);
	(*si)=tmp;
	
	ax=ax*bx;
	dx=cx+dx;

	ax++;

	(*x1a2)=dx;
	x1a0[(*i)]=ax;

	(*i)++;
	
	return (ax^dx); //(*res)=ax^dx;
}

// ===========================================================================================================================
int addFileAlgoPc1(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToAdd, FILE *fArchive, BYTE *cHashControl, QWORD *qwCompressedFileSize, QWORD *qwEncodedFileSize)
{	
	QString strMess;
	int nRes;
	short int cCurChar;
	int iFor;
	QFileInfo fi;
	QWORD qwBytesRead; // To check all bytes of the original files have been read
	DWORD dwHashPos;
	DWORD z, end, dwCount;

	// PC1 variables
	UINT pcSi,pcX1a2, pcX1a0[8], pcI, pcInter, pcCfc, pcCfd;
	BYTE pcKey[ENCODING_LEN+1];
	
	// Initializations
	memset(cHashControl, 0, ENCODING_LEN);
	*qwCompressedFileSize = 0;
	qwBytesRead = 0L;
	dwHashPos = 0L;

	memcpy(pcKey, cPassword, ENCODING_LEN);
	
	// PC1 Init
	pcSi=0;
	pcX1a2=0;
	pcI=0;
		
	// encode data
	while ((cCurChar = fgetc(fFileToAdd)) != EOF)
	{	(*qwCompressedFileSize)++;
		
		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255; // pcCfc^pcCfd = random byte

		// K ZONE !!!!!!!!!!!!!
		// here the mix of c and key[iFor] is before the encryption of cCurChar

		for (iFor=0; iFor < ENCODING_LEN; iFor++)
		{
			// we mix the plaintext byte with the key
			pcKey[iFor] ^= cCurChar;
		}

		cCurChar ^= (pcCfc ^ pcCfd);
		
		// update the hash control table
		cHashControl[dwHashPos] ^= cCurChar;

    dwHashPos++;
    if (dwHashPos >= ENCODING_LEN)
    	dwHashPos = 0;
    	
		errno = 0;
		nRes = fputc(cCurChar, fArchive);
		if (nRes == -1)
  	{	strMess.sprintf(i18n("Can't write file <b>%s</b> to archive: Error %s"), szFilename, strerror(errno));
			KMessageBox::error (wWin, strMess);
			return ERROR_FAILED;
		}
	}

	// encode the hash control table
	end = (ENCODING_LEN+1)*ENCODING_LEN;

	for (z=1; z <= end; z++)
	{
		cCurChar = cHashControl[dwHashPos];

		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = random byte

		for (dwCount = 0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHashControl[dwHashPos] ^= cCurChar;

		dwHashPos++;
		if (dwHashPos >= ENCODING_LEN)
			dwHashPos = 0;
	}
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;

	// In this algo, EncodedSize == DecodedSize
	*qwEncodedFileSize = *qwCompressedFileSize;	
	
	return ERROR_SUCCESS;
}

// ===========================================================================================================================
int extractFilesAlgoPc1(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToDecode, FILE *fArchive, BYTE *cHashControl, QWORD qwCompressedFileSize, QWORD qwEncodedFileSize)
{
	QString strMess;
	int nRes;
	int cCurChar;
	int iFor; // for(;;)
	DWORD dwHashPos;
	DWORD dwCount, end, z;

	// PC1 variables
	UINT pcSi, pcX1a2, pcX1a0[8], pcI, pcInter, pcCfc, pcCfd;
	BYTE pcKey[ENCODING_LEN+1];
	
	// init
	memset(cHashControl, 0, ENCODING_LEN);
	QWORD qwCount=0LL;
	dwHashPos = 0L;
	
	memcpy(pcKey, cPassword, ENCODING_LEN);

	// In the PC1 algo, (qwOriginalFileSize == qwEncodedFileSize)
	
	// PC1 Init
	pcSi=0;
	pcX1a2=0;
	pcI=0;

	while(qwCount < qwCompressedFileSize)
	{	
  	// Reads a character from archive
		errno=0;
		cCurChar = fgetc(fArchive);
		if (cCurChar == EOF)
   	{	strMess.sprintf(i18n("Can't extract <b>%s</b> from archive: Error %s"), szFilename, strerror(errno));
   		KMessageBox::error (wWin, strMess);
			return ERROR_FAILED;
		}
		qwCount++;
		
		// update the hash control table
		cHashControl[dwHashPos] ^= cCurChar;

    dwHashPos++;
    if (dwHashPos >= ENCODING_LEN)
    	dwHashPos = 0;
    	
		// Decode character		
		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255; // pcCfc ^ pcCfd = random byte

		// K ZONE !!!!!!!!!!!!!
		// here the mix of cCurChar and pcKey[nCount] is after the decryption of cCurChar

		cCurChar = cCurChar ^ (pcCfc ^ pcCfd);

		for (iFor=0; iFor < ENCODING_LEN; iFor++)
		{
			// we mix the plaintext byte with the key
			pcKey[iFor] = pcKey[iFor] ^ cCurChar;
		}

		if (szFilename && fFileToDecode) // if these variables are NULL, it's only a test ==> do not write anything
		{	nRes = putc(cCurChar, fFileToDecode);		
			if (nRes == EOF)
			{	strMess.sprintf(i18n("Can't write file <b>%s</b>."), szFilename);
				KMessageBox::error (wWin, strMess);
				return ERROR_FAILED;
			}
		}
		
	}		

	// encode the hash control table
	end = (ENCODING_LEN+1)*ENCODING_LEN;

	for (z=1; z <= end; z++)
	{
		cCurChar = cHashControl[dwHashPos];

		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = random byte

		for (dwCount = 0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHashControl[dwHashPos] ^= cCurChar;

		dwHashPos++;
		if (dwHashPos >= ENCODING_LEN)
			dwHashPos = 0;
	}
	
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;

	return ERROR_SUCCESS;
}

// ===========================================================================================================================
// Used to encode a buffer with PC1, not a file
int pc1Encode(BYTE *cDestBuffer, const BYTE *cSrcBuffer, DWORD dwBufferLen, const BYTE *cPass)
{
	DWORD dwCount, dwBufferPos;
	BYTE pcKey[ENCODING_LEN+1];
	BYTE cCurChar;
	DWORD iFor;

	UINT pcSi, pcX1a2, pcI, pcInter, pcCfc, pcCfd, pcX1a0[8];

	pcSi=0;
	pcX1a2=0;
	pcI=0;

	// initialize key
	if (cPass) // if the key was passed
	{	memcpy(pcKey, cPass, ENCODING_LEN);
	}
	else // key not passed ==> use the constant key
	{	memcpy(pcKey, g_cConstantKey, ENCODING_LEN);
	}

	// first part: encoding
  // for every byte of the buffer...
	for (dwBufferPos = 0; dwBufferPos < dwBufferLen; dwBufferPos++)
	{
		cCurChar = cSrcBuffer[dwBufferPos];
	
		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = ramdom byte

		for (dwCount=0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);
		cDestBuffer[dwBufferPos] = cCurChar;
	}
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;
	
	return ERROR_SUCCESS;
}

// ===========================================================================================================================
// Used to encode a buffer with PC1, not a file
int pc1Decode(BYTE *cDestBuffer, const BYTE *cSrcBuffer, DWORD dwBufferLen, const BYTE *cPass)
{
	DWORD dwCount, dwBufferPos;
	BYTE pcKey[ENCODING_LEN+1];
	BYTE cCurChar;
	DWORD iFor;

	UINT pcSi, pcX1a2, pcI, pcInter, pcCfc, pcCfd, pcX1a0[8];

	pcSi=0;
	pcX1a2=0;
	pcI=0;

	// initialize key
	if (cPass) // if the key was passed
	{	memcpy(pcKey, cPass, ENCODING_LEN);
	}
	else // key not passed ==> use the constant key
	{	memcpy(pcKey, g_cConstantKey, ENCODING_LEN);
	}

	// first part: encoding
  // for every byte of the buffer...
	for (dwBufferPos = 0; dwBufferPos < dwBufferLen; dwBufferPos++)
	{
		cCurChar = cSrcBuffer[dwBufferPos];
	
		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = ramdom byte

		cCurChar ^= (pcCfc ^ pcCfd);

		for (dwCount=0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cDestBuffer[dwBufferPos] = cCurChar;
	}
	
	// delete password in the memory, to increase the security
	for (iFor=0; iFor < ENCODING_LEN; iFor++)
		pcKey[iFor] = 0;
	for (iFor=0; iFor < 8; iFor++)
		pcX1a0[iFor] = 0;
	pcSi = 0;
	pcX1a2 = 0;
	pcI = 0;
	pcInter = 0;
	pcCfc = 0;
	pcCfd = 0;
	
	return ERROR_SUCCESS;
}


