#ifndef CUPSPARSERVIEW_H
#define CUPSPARSERVIEW_H

#include <qlistview.h>
#include <qptrlist.h>
#include <qdict.h>

#include "cupsparser.h"

class CupsParserViewItem;

class CupsParserView : public QListView
{
	Q_OBJECT
public:
	CupsParserView( QWidget *parent = 0, const char *name = 0 );
	~CupsParserView();

	void setParser( CupsParser* );
	CupsParser* parser() const;
	int limit() const;
	void setLimit( int );
	int grouping() const;
	bool restored() const;
	void setRestored( bool );

signals:
	void itemsChanged( int nbrOfItems );

public slots:
	void slotGrouping( int );
	void slotProperty();

protected slots:
	void slotNewItems( const CupsParser::ItemList& );
	void slotRestarted();

protected:
	CupsParserViewItem* createItem( CupsParser::Item* );
	QListViewItem* findGroupItem( const QString& );
	QString formatItem( CupsParser::Item* );

private:
	CupsParser *m_parser;
	int m_limit;
	QPtrList<CupsParserViewItem> m_items;
	QDict<QListViewItem> m_groupitems;
	int m_grouping;
	bool m_restored;
};

class CupsParserViewItem : public QListViewItem
{
public:
	CupsParserViewItem( QListView*, CupsParser::Item* );
	CupsParserViewItem( QListViewItem*, CupsParser::Item* );
	~CupsParserViewItem();

	int compare( QListViewItem*, int, bool ) const;
	QString groupKey( int );
	bool match( int, const QString& );
	CupsParser::Item* item() const;

private:
	CupsParser::Item *m_item;

	void init();
};

#endif /* CUPSPARSERVIEW_H */
