/***************************************************************************
                          kscribbledoc.cpp  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>

// application specific includes
#include "kscribbledoc.h"
#include "kscribble.h"
#include "kscribbleview.h"


KScribbleDoc::KScribbleDoc()
{
  pViewList = new QList<KScribbleView>;
  pViewList->setAutoDelete(false);
}

KScribbleDoc::~KScribbleDoc()
{
  delete pViewList;
}

void KScribbleDoc::addView(KScribbleView *view)
{
  pViewList->append(view);
	changedViewList();
}

void KScribbleDoc::removeView(KScribbleView *view)
{
	  pViewList->remove(view);
	  if(!pViewList->isEmpty())
			changedViewList();
		else
			deleteContents();
}

void KScribbleDoc::changedViewList(){	
	
	KScribbleView *w;
	if((int)pViewList->count() == 1){
  	w=pViewList->first();
  	w->setCaption(m_title);
	}
	else{	
		int i;
    for( i=1,w=pViewList->first(); w!=0; i++, w=pViewList->next())
  		w->setCaption(QString(m_title+":%1").arg(i));	
	}
}

bool KScribbleDoc::isLastView() {
  return ((int) pViewList->count() == 1);
}


void KScribbleDoc::updateAllViews(KScribbleView *sender)
{
  KScribbleView *w;
  for(w=pViewList->first(); w!=0; w=pViewList->next())
  {
		  w->update(sender);
  }

}

void KScribbleDoc::setPathName(const QString &name)
{
  m_filename=name;
	m_title=QFileInfo(name).fileName();
}

const QString& KScribbleDoc::pathName() const
{
  return m_filename;
}

void KScribbleDoc::setTitle(const QString &title)
{
  m_title=title;
}

const QString &KScribbleDoc::title() const
{
  return m_title;
}


void KScribbleDoc::closeDocument()
{
  KScribbleView *w;
  if(!isLastView())
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
   	 	if(!w->close())
 				break;
    }
	}
  if(isLastView())
  {
  	w=pViewList->first();
  	w->close();
  }
}

bool KScribbleDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  size=QSize(300,200 );
 	pen=QPen( Qt::black, 3 );
 	polyline=QPointArray(3);
  buffer.resize(size);
  buffer.fill( Qt::white );
  /////////////////////////////////////////////////
  modified=false;
  return true;
}

bool KScribbleDoc::openDocument(const QString &filename, const char *format /*=0*/)
{

	QFile f( filename );
//	if ( !f.open( IO_ReadOnly ) )
//		return false;
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
	if(!buffer.load( filename, format ))
		return false;
	size=buffer.size();
  /////////////////////////////////////////////////
//	f.close();
	
  modified=false;
  m_filename=filename;
	m_title=QFileInfo(f).fileName();
  return true;
}

bool KScribbleDoc::saveDocument(const QString &filename, const char *format /*=0*/)
{
	QFile f( filename );
//	if ( !f.open( IO_WriteOnly ) )
//		return false;

  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
	if(!buffer.save( filename, format ))
		return false;
  /////////////////////////////////////////////////

//  f.close();

  modified=false;
  m_filename=filename;
	m_title=QFileInfo(f).fileName();
  return true;
}

void KScribbleDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  buffer.fill( Qt::white );
  /////////////////////////////////////////////////

}

bool KScribbleDoc::canCloseFrame(KScribbleView* pFrame)
{
	if(!isLastView())
		return true;
		
	bool ret=false;
  if(isModified())
  {
		QString saveName;
  	switch(KMessageBox::warningYesNoCancel(pFrame, i18n("The current file has been modified.\n"
                          "Do you want to save it?"),title()))
    {
			case KMessageBox::Yes:
				if(title().contains(i18n("Untitled")))
				{
					saveName=KFileDialog::getSaveFileName(QDir::currentDirPath(),
                      i18n("*|All files"), pFrame, i18n("Save as..."));
          if(saveName.isEmpty())
          	return false;
				}
				else
					saveName=pathName();
					
				if(!saveDocument(saveName))
				{
 					switch(KMessageBox::warningYesNo(pFrame,i18n("Could not save the current document !\n"
																												"Close anyway ?"), i18n("I/O Error !")))
 					{
 						case KMessageBox::Yes:
 							ret=true;
 						case KMessageBox::No:
 							ret=false;
 					}	        			
				}
				else
					ret=true;
				break;
			case KMessageBox::No:
				ret=true;
				break;
			case KMessageBox::Cancel:
			default:
				ret=false; 				
				break;
		}
	}
	else
		ret=true;
		
	return ret;
}

void KScribbleDoc::editClearAll()
{
  deleteContents();
  setModified();
  updateAllViews(0);
}
