/***************************************************************************
                 wakeup.h  -  alarm plugin for noatun
                     -------------------
     begin    : Wed Apr 11 CEST 2000
     copyright: (C) 2001 by Mickael Marchand <mikmak@linuxfr.net>
                                                       
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef WAKEUP_H
#define WAKEUP_H

#include <noatunpref.h>
#include <plugin.h>
class QSpinBox;
class QCheckBox;

class Wakeup : public QObject, public Plugin
{
	Q_OBJECT
	NOATUNPLUGIND;

public:
	Wakeup();
	~Wakeup();
	static Wakeup *wakeme;
	
	void update();

public slots:
	void slotVolumeUp();
	void slotVolumeDown();
	void slotCheckTime();
	
private:
	QStringList *day_list;
	QString songlist;
	int hour;
	int minute;
	bool days[7];
};


class WakeupPrefs : public CModule
{
	Q_OBJECT

public:
	WakeupPrefs( QObject *parent );
	virtual void save();
	virtual void load();

private:
	QCheckBox *monday;
	QCheckBox *tuesday;
	QCheckBox *wednesday;
	QCheckBox *thursday;
	QCheckBox *friday;
	QCheckBox *saturday;
	QCheckBox *sunday;
	QSpinBox *minute1;
	QSpinBox *hour1;
};

#endif // WAKEUP_H
