/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.auth.callback;

import gnu.crypto.auth.callback.AbstractCallbackHandler;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;

public class AWTCallbackHandler
extends AbstractCallbackHandler
implements ActionListener,
WindowListener {
    private static final String ACTION_CANCEL = "CANCEL";
    private static final String ACTION_NO = "NO";
    private static final String ACTION_NONE = "NONE";
    private static final String ACTION_OK = "OK";
    private static final String ACTION_YES = "YES";
    protected String actionCommand = "NONE";

    protected synchronized void handleChoice(ChoiceCallback c) {
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        String[] choices = c.getChoices();
        dialog.setTitle(c.getPrompt());
        Label label = new Label(c.getPrompt());
        List list = new List(Math.min(5, choices.length), c.allowMultipleSelections());
        Panel buttons = new Panel();
        Button ok = new Button(this.messages.getString("callback.ok"));
        ok.setActionCommand(ACTION_OK);
        ok.addActionListener(this);
        Button cancel = new Button(this.messages.getString("callback.cancel"));
        cancel.setActionCommand(ACTION_CANCEL);
        cancel.addActionListener(this);
        int i = 0;
        while (i < choices.length) {
            list.add(choices[i]);
            ++i;
        }
        if (c.getDefaultChoice() >= 0 && c.getDefaultChoice() < choices.length) {
            list.select(c.getDefaultChoice());
        }
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)label, "North");
        dialog.add((Component)list, "Center");
        buttons.setLayout(new FlowLayout(2));
        buttons.add(cancel);
        buttons.add(ok);
        dialog.add((Component)buttons, "South");
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.actionCommand.equals(ACTION_OK)) {
            if (c.allowMultipleSelections()) {
                c.setSelectedIndexes(list.getSelectedIndexes());
            } else {
                c.setSelectedIndex(list.getSelectedIndex());
            }
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    protected synchronized void handleConfirmation(ConfirmationCallback c) {
        int i;
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        switch (c.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            default: {
                dialog.setTitle("");
            }
        }
        dialog.setLayout(new GridLayout(2, 1));
        dialog.add(new Label(c.getPrompt()));
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        dialog.add(buttons);
        String[] choices = null;
        int[] values = null;
        switch (c.getOptionType()) {
            case 2: {
                choices = new String[]{this.messages.getString("callback.cancel"), this.messages.getString("callback.ok")};
                values = new int[]{2, 3};
                break;
            }
            case 1: {
                choices = new String[]{this.messages.getString("callback.cancel"), this.messages.getString("callback.no"), this.messages.getString("callback.yes")};
                int[] nArray = new int[3];
                nArray[0] = 2;
                nArray[1] = 1;
                values = nArray;
                break;
            }
            case 0: {
                choices = new String[]{this.messages.getString("callback.no"), this.messages.getString("callback.yes")};
                int[] nArray = new int[2];
                nArray[0] = 1;
                values = nArray;
                break;
            }
            case -1: {
                choices = c.getOptions();
                values = new int[choices.length];
                i = 0;
                while (i < values.length) {
                    values[i] = i;
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        i = 0;
        while (i < choices.length) {
            Button b = new Button(choices[i]);
            b.setActionCommand(choices[i]);
            b.addActionListener(this);
            buttons.add(b);
            ++i;
        }
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        int i2 = 0;
        while (i2 < choices.length) {
            if (this.actionCommand.equals(choices[i2])) {
                c.setSelectedIndex(values[i2]);
                break;
            }
            ++i2;
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    protected synchronized void handleLanguage(LanguageCallback c) {
        int index;
        Locale[] locales = Locale.getAvailableLocales();
        String[] languages = new String[locales.length];
        Locale def = Locale.getDefault();
        int defind = 0;
        int i = 0;
        while (i < locales.length) {
            StringBuffer lang = new StringBuffer(locales[i].getDisplayLanguage(locales[i]));
            String country = locales[i].getDisplayCountry(locales[i]);
            String variant = locales[i].getDisplayVariant(locales[i]);
            if (country.length() > 0 && variant.length() > 0) {
                lang.append(" (");
                lang.append(country);
                lang.append(", ");
                lang.append(variant);
                lang.append(")");
            } else if (country.length() > 0) {
                lang.append(" (");
                lang.append(country);
                lang.append(")");
            } else if (variant.length() > 0) {
                lang.append(" (");
                lang.append(variant);
                lang.append(")");
            }
            languages[i] = lang.toString();
            if (locales[i].equals(def)) {
                defind = i;
            }
            ++i;
        }
        ChoiceCallback c2 = new ChoiceCallback(this.messages.getString("callback.language"), languages, defind, false);
        this.handleChoice(c2);
        c.setLocale(def);
        if (c2.getSelectedIndexes() != null && c2.getSelectedIndexes().length > 0 && (index = c2.getSelectedIndexes()[0]) >= 0 && index < locales.length) {
            c.setLocale(locales[index]);
        }
    }

    protected synchronized void handleName(NameCallback c) {
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        dialog.setTitle(c.getPrompt());
        dialog.setLayout(new GridLayout(3, 1));
        Label label = new Label(c.getPrompt());
        TextField input = new TextField();
        if (c.getDefaultName() != null) {
            input.setText(c.getDefaultName());
        }
        Panel buttons = new Panel();
        Button ok = new Button(this.messages.getString("callback.ok"));
        ok.setActionCommand(ACTION_OK);
        ok.addActionListener(this);
        Button cancel = new Button(this.messages.getString("callback.cancel"));
        cancel.setActionCommand(ACTION_CANCEL);
        cancel.addActionListener(this);
        dialog.add(label);
        dialog.add(input);
        buttons.setLayout(new FlowLayout(2));
        buttons.add(ok);
        buttons.add(cancel);
        dialog.add(buttons);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.actionCommand.equals(ACTION_OK)) {
            c.setName(input.getText());
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    protected synchronized void handlePassword(PasswordCallback c) {
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        dialog.setTitle(c.getPrompt());
        dialog.setLayout(new GridLayout(3, 1));
        Label label = new Label(c.getPrompt());
        TextField input = new TextField();
        if (!c.isEchoOn()) {
            input.setEchoChar('*');
        }
        Panel buttons = new Panel();
        Button ok = new Button(this.messages.getString("callback.ok"));
        ok.setActionCommand(ACTION_OK);
        ok.addActionListener(this);
        Button cancel = new Button(this.messages.getString("callback.cancel"));
        cancel.setActionCommand(ACTION_CANCEL);
        cancel.addActionListener(this);
        dialog.add(label);
        dialog.add(input);
        buttons.setLayout(new FlowLayout(2));
        buttons.add(ok);
        buttons.add(cancel);
        dialog.add(buttons);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.actionCommand.equals(ACTION_OK)) {
            c.setPassword(input.getText().toCharArray());
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    protected synchronized void handleTextInput(TextInputCallback c) {
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        dialog.setTitle(c.getPrompt());
        dialog.setLayout(new BorderLayout());
        Label label = new Label(c.getPrompt());
        TextArea text = new TextArea(10, 40);
        if (c.getDefaultText() != null) {
            text.setText(c.getDefaultText());
        }
        Panel buttons = new Panel();
        Button ok = new Button(this.messages.getString("callback.ok"));
        ok.setActionCommand(ACTION_OK);
        ok.addActionListener(this);
        Button cancel = new Button(this.messages.getString("callback.cancel"));
        cancel.setActionCommand(ACTION_CANCEL);
        cancel.addActionListener(this);
        dialog.add((Component)label, "North");
        dialog.add((Component)text, "Center");
        buttons.setLayout(new FlowLayout(2));
        buttons.add(ok);
        buttons.add(cancel);
        dialog.add((Component)buttons, "South");
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.actionCommand.equals(ACTION_OK)) {
            c.setText(text.getText());
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    protected synchronized void handleTextOutput(TextOutputCallback c) {
        Frame ownerFrame = new Frame();
        Dialog dialog = new Dialog(ownerFrame);
        dialog.setLayout(new GridLayout(2, 1));
        switch (c.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            default: {
                dialog.setTitle("");
            }
        }
        Label label = new Label(c.getMessage());
        Panel buttons = new Panel();
        Button ok = new Button(this.messages.getString("callback.ok"));
        buttons.setLayout(new FlowLayout(2));
        buttons.add(ok);
        ok.addActionListener(this);
        dialog.add(label);
        dialog.add(buttons);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        dialog.dispose();
        ownerFrame.dispose();
    }

    public synchronized void actionPerformed(ActionEvent ae) {
        this.actionCommand = ae.getActionCommand();
        this.notifyAll();
    }

    public synchronized void windowClosing(WindowEvent we) {
        this.actionCommand = ACTION_NONE;
        this.notifyAll();
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }
}

