/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IResourceRef;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.Messages;

public class DeleteAudioNotesCommand
extends SourceCommand {
    private ITopic topic;
    List<IResourceRef> refs;
    List<String> elementValues;

    public DeleteAudioNotesCommand(ITopic topic) {
        super((Object)topic);
        this.topic = topic;
        this.setLabel(Messages.DeleteAudioNotesCommand_label);
        this.elementValues = new ArrayList<String>();
    }

    public void redo() {
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        if (this.topic.equals(agent.getCurrentTopic())) {
            agent.stop();
            Shell[] shellArray = Display.getCurrent().getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (Messages.AudioNotesDialog_title.equals(shell.getText())) {
                    shell.dispose();
                }
                ++n2;
            }
        }
        ITopicExtension audioNotes = this.topic.getExtension("org.xmind.ui.audionotes");
        this.refs = audioNotes.getResourceRefs();
        ITopicExtensionElement content = audioNotes.getContent();
        this.elementValues.add(((ITopicExtensionElement)content.getFirstChild("duration")).getTextContent());
        this.elementValues.add(((ITopicExtensionElement)content.getFirstChild("record-time")).getTextContent());
        this.elementValues.add(((ITopicExtensionElement)content.getFirstChild("file-size")).getTextContent());
        this.topic.deleteExtension("org.xmind.ui.audionotes");
        this.fireCoreEvent(this.topic);
        super.redo();
    }

    public void undo() {
        ITopicExtension audioNotes = this.topic.createExtension("org.xmind.ui.audionotes");
        for (IResourceRef ref : this.refs) {
            audioNotes.addResourceRef(ref);
        }
        audioNotes.getContent().setAttribute("recording", null);
        ITopicExtensionElement content = audioNotes.getContent();
        ((ITopicExtensionElement)content.getCreatedChild("duration")).setTextContent(this.elementValues.get(0));
        ((ITopicExtensionElement)content.getCreatedChild("record-time")).setTextContent(this.elementValues.get(1));
        ((ITopicExtensionElement)content.getCreatedChild("file-size")).setTextContent(this.elementValues.get(2));
        this.fireCoreEvent(this.topic);
        super.undo();
    }

    private void fireCoreEvent(ITopic topic) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, "org.xmind.core.event.audioNotesModify", null);
        }
    }
}

