/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.IMetaData;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.Meta;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.MetaDataImpl;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaImpl
extends Meta
implements ICoreEventSource {
    private Document implementation;
    private WorkbookImpl ownedWorkbook;
    private ElementRegistry elementRegistry;

    public MetaImpl(Document implementation) {
        this.implementation = implementation;
        this.init();
    }

    protected void setOwnedWorkbook(WorkbookImpl ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "meta");
        NS.setNS(NS.Meta, m, new NS[0]);
        InternalDOMUtils.addVersion(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MetaImpl)) {
            return false;
        }
        MetaImpl that = (MetaImpl)obj;
        return that.implementation == this.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Document.class)) {
            return adapter.cast(this.implementation);
        }
        if (ElementRegistry.class.equals(adapter)) {
            return adapter.cast(this.getElementRegistry());
        }
        return super.getAdapter(adapter);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    protected Element getMetaElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return this.ownedWorkbook == null;
    }

    private String[] getKeys(String keyPath) {
        return keyPath.split("/");
    }

    private Element findElementByPath(String keyPath, boolean ensure) {
        String[] keys = this.getKeys(keyPath);
        if (keys.length == 0) {
            return null;
        }
        Element e = this.getMetaElement();
        Element c = null;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (!"".equals(key)) {
                c = ensure ? DOMUtils.ensureChildElement(e, key) : DOMUtils.getFirstChildElementByTag(e, key);
                if (c == null) {
                    return null;
                }
                e = c;
            }
            ++i;
        }
        return c;
    }

    @Override
    public String getValue(String keyPath) {
        Element d = this.findElementByPath(keyPath, false);
        return d == null ? null : d.getTextContent();
    }

    @Override
    public void setValue(String keyPath, String value) {
        String oldValue = null;
        if (value == null) {
            Element d = this.findElementByPath(keyPath, false);
            if (d != null && d.getParentNode() != null) {
                oldValue = d.getTextContent();
                d.getParentNode().removeChild(d);
            }
        } else {
            Element d = this.findElementByPath(keyPath, true);
            if (d != null) {
                oldValue = d.getTextContent();
                d.setTextContent(value);
            }
        }
        this.getCoreEventSupport().dispatchTargetValueChange(this, "metadata", keyPath, oldValue, value);
    }

    @Override
    public Set<String> getKeyPaths() {
        HashSet<String> keyPaths = new HashSet<String>();
        this.collectKeyPaths(this.getMetaElement(), null, keyPaths);
        return keyPaths;
    }

    private void collectKeyPaths(Element parentEle, String parentKeyPath, Set<String> keyPaths) {
        Iterator<Element> it = DOMUtils.childElementIter(parentEle);
        while (it.hasNext()) {
            String childKeyPath;
            Element childEle = it.next();
            String childKey = childEle.getTagName();
            String string = childKeyPath = parentKeyPath == null ? childKey : String.valueOf(parentKeyPath) + "/" + childKey;
            if (childEle.hasChildNodes()) {
                this.collectKeyPaths(childEle, childKeyPath, keyPaths);
                continue;
            }
            keyPaths.add(childKeyPath);
        }
    }

    @Override
    public void addMetaData(IMetaData data) {
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.getMetaElement().appendChild(mdEle);
        String keyPath = ((MetaDataImpl)data).getKeyPath();
        String newValue = data.getValue();
        this.getCoreEventSupport().dispatchTargetValueChange(this, "metadata", keyPath, null, newValue);
    }

    @Override
    public void removeMetaData(IMetaData data) {
        String keyPath = ((MetaDataImpl)data).getKeyPath();
        String oldValue = data.getValue();
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.getMetaElement().removeChild(mdEle);
        this.getCoreEventSupport().dispatchTargetValueChange(this, "metadata", keyPath, oldValue, null);
    }

    @Override
    public IMetaData createMetaData(String key) {
        Element mdEle = this.implementation.createElement(key);
        MetaDataImpl md = new MetaDataImpl(mdEle, this);
        this.getElementRegistry().registerByKey(mdEle, md);
        return md;
    }

    @Override
    public IMetaData[] getMetaData(String key) {
        ArrayList<MetaDataImpl> list = new ArrayList<MetaDataImpl>();
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getMetaElement(), key);
        while (it.hasNext()) {
            Element mdEle = it.next();
            list.add(this.getMetaData(mdEle));
        }
        return list.toArray(new IMetaData[list.size()]);
    }

    protected MetaDataImpl getMetaData(Element mdEle) {
        Object md;
        if (this.elementRegistry != null && (md = this.elementRegistry.getElement(mdEle)) != null && md instanceof IMetaData) {
            return (MetaDataImpl)md;
        }
        md = new MetaDataImpl(mdEle, this);
        this.getElementRegistry().registerByKey(mdEle, md);
        return md;
    }

    public ElementRegistry getElementRegistry() {
        if (this.elementRegistry == null) {
            this.elementRegistry = new ElementRegistry();
        }
        return this.elementRegistry;
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedWorkbook.getCoreEventSupport();
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }
}

