/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;

public abstract class AbstractWorkbookBuilder
implements IWorkbookBuilder {
    private IEncryptionHandler defaultEncryptionHandler = null;
    public String creatorName;
    public String creatorVersion;

    public synchronized void setDefaultEncryptionHandler(IEncryptionHandler encryptionHandler) {
        if (this.defaultEncryptionHandler != null) {
            return;
        }
        this.defaultEncryptionHandler = encryptionHandler;
    }

    public synchronized void setCreator(String name, String version) {
        this.creatorName = name;
        this.creatorVersion = version;
    }

    protected IEncryptionHandler getDefaultEncryptionHandler() {
        return this.defaultEncryptionHandler;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getCreatorVersion() {
        return this.creatorVersion;
    }

    public IWorkbook createWorkbook() {
        return this.createWorkbook(new ByteArrayStorage());
    }

    public IWorkbook createWorkbook(IStorage storage) {
        return this.doCreateWorkbook(storage);
    }

    public IWorkbook loadFromPath(String path) throws IOException, CoreException {
        return this.loadFromPath(path, new ByteArrayStorage(), this.getDefaultEncryptionHandler());
    }

    public IWorkbook loadFromPath(String path, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromPath(path, new ByteArrayStorage(), encryptionHandler);
    }

    public IWorkbook loadFromPath(String path, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return this.doLoadFromPath(path, storage, encryptionHandler);
    }

    public IWorkbook loadFromFile(File file) throws IOException, CoreException {
        return this.loadFromFile(file, new ByteArrayStorage(), this.getDefaultEncryptionHandler());
    }

    public IWorkbook loadFromFile(File file, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromFile(file, new ByteArrayStorage(), encryptionHandler);
    }

    public IWorkbook loadFromFile(File file, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not exists: " + file);
        }
        if (file.isDirectory()) {
            return this.doLoadFromDirectory(file, storage, encryptionHandler);
        }
        if (!file.canRead()) {
            throw new IOException("File can't be read: " + file);
        }
        return this.doLoadFromFile(file, storage, encryptionHandler);
    }

    public IWorkbook loadFromStream(InputStream in) throws IOException, CoreException {
        return this.loadFromStream(in, new ByteArrayStorage(), this.getDefaultEncryptionHandler());
    }

    public IWorkbook loadFromStream(InputStream in, IStorage storage) throws IOException, CoreException {
        return this.loadFromStream(in, storage, this.getDefaultEncryptionHandler());
    }

    public IWorkbook loadFromStream(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        return this.doLoadFromStream(in, storage, encryptionHandler);
    }

    public IWorkbook loadFromInputSource(IInputSource source) throws IOException, CoreException {
        return this.loadFromInputSource(source, new ByteArrayStorage(), this.getDefaultEncryptionHandler());
    }

    public IWorkbook loadFromInputSource(IInputSource source, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromInputSource(source, new ByteArrayStorage(), encryptionHandler);
    }

    public IWorkbook loadFromInputSource(IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (source == null) {
            throw new IllegalArgumentException("Input source is null");
        }
        return this.doLoadFromInputSource(source, storage, encryptionHandler);
    }

    public IWorkbook loadFromStorage(IStorage storage) throws IOException, CoreException {
        if (storage == null) {
            throw new IllegalArgumentException("Storage is null");
        }
        return this.loadFromStorage(storage, null);
    }

    public IWorkbook loadFromStorage(IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (storage == null) {
            throw new IllegalArgumentException("Storage is null");
        }
        return this.doLoadFromStorage(storage, encryptionHandler);
    }

    @Deprecated
    public IWorkbook loadFromTempLocation(String tempLocation) throws IOException, CoreException {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new FileNotFoundException("Temp location not found: " + tempLocation);
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Temp location is not directory: " + tempLocation);
        }
        DirectoryStorage storage = new DirectoryStorage(dir);
        return this.doLoadFromStorage(storage, null);
    }

    protected abstract IWorkbook doCreateWorkbook(IStorage var1);

    protected IWorkbook doLoadFromPath(String path, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromFile(new File(path), storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromDirectory(File dir, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromInputSource(new DirectoryInputSource(dir), storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromFile(File file, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException, FileNotFoundException {
        return this.loadFromStream((InputStream)new FileInputStream(file), storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromStream(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (storage == null) {
            storage = new ByteArrayStorage();
        }
        try {
            this.extractFromStream(in, storage.getOutputTarget());
        }
        finally {
            in.close();
        }
        return this.doLoadFromStorage(storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromInputSource(IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (storage == null) {
            storage = new ByteArrayStorage();
        }
        FileUtils.transfer(source, storage.getOutputTarget());
        return this.doLoadFromStorage(storage, encryptionHandler);
    }

    protected abstract void extractFromStream(InputStream var1, IOutputTarget var2) throws IOException, CoreException;

    protected abstract IWorkbook doLoadFromStorage(IStorage var1, IEncryptionHandler var2) throws IOException, CoreException;

    @Deprecated
    public IWorkbook createWorkbook(String targetPath) {
        return this.createWorkbook(new ByteArrayStorage());
    }

    @Deprecated
    public IWorkbook createWorkbookOnTemp(String tempLocation) {
        return this.createWorkbook(new DirectoryStorage(new File(tempLocation)));
    }

    @Deprecated
    public IWorkbook loadFromStream(InputStream in, String tempLocation) throws IOException, CoreException {
        return this.loadFromStream(in, tempLocation, null);
    }

    @Deprecated
    public IWorkbook loadFromStream(InputStream in, String tempLocation, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new FileNotFoundException("Temp location not found: " + tempLocation);
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Temp location is not directory: " + tempLocation);
        }
        return this.loadFromStream(in, new DirectoryStorage(dir), encryptionHandler);
    }
}

