/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.styleeditor.StylePropertyChangeOperation;
import org.xmind.ui.internal.styleeditor.StylePropertyDescriptors;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEditModel {
    public static final String PREFIX_ANONYMOUS_STYLE = "style:anonymous/";
    public static final String PREFIX_ANONYMOUS_THEME = "theme:anonymous/";
    public static final String PROP_DISPLAY_NAME = "org.xmind.ui.displayname";
    public static final String PROP_NAME = "org.xmind.core.name";
    public static final String PROP_STYLE_FAMILY_PREFIX = "org.xmind.core.style.family.";
    public static final String PROP_DIRTY = "__dirty__";
    private static final Map<String, StyleEditModel> MODEL_REGISTRY = new HashMap<String, StyleEditModel>();
    private final String uri;
    private final boolean exists;
    private final boolean readOnly;
    private final String type;
    private final IPropertyDescriptor[] descriptors;
    private final Properties defaults = new Properties();
    private final Properties properties = new Properties();
    private final PropertyChangeSupport eventSupport = new PropertyChangeSupport(this);
    private IUndoableOperation cleanOperation = null;
    private int references = 0;
    private boolean isModifyByAll = false;
    private IUndoContext undoContext = new UndoContext();
    private IOperationHistoryListener operationHistoryListener = new IOperationHistoryListener(){
        boolean oldDirty = false;

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation operation = event.getOperation();
            if (operation == null || !operation.hasContext(StyleEditModel.this.undoContext)) {
                return;
            }
            int eventType = event.getEventType();
            if (eventType == 1 || eventType == 2 || eventType == 3) {
                this.oldDirty = StyleEditModel.this.isDirty();
            } else {
                boolean newDirty = StyleEditModel.this.isDirty();
                if (this.oldDirty != newDirty) {
                    StyleEditModel.this.fireDirtyChange(this.oldDirty, newDirty);
                }
            }
        }
    };

    private StyleEditModel(String uri, boolean exists, boolean readOnly, String type) {
        this.uri = uri;
        this.exists = exists;
        this.readOnly = readOnly;
        this.type = type;
        this.descriptors = StylePropertyDescriptors.getSingleton().getPropertyDescriptors(type);
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().addOperationHistoryListener(this.operationHistoryListener);
    }

    public String getURI() {
        return this.uri;
    }

    public boolean exists() {
        return this.exists;
    }

    public String getType() {
        return this.type;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public String getPropertyValue(String propertyId) {
        return this.properties.getProperty(propertyId, this.defaults.getProperty(propertyId));
    }

    public boolean isPropertySet(String propertyId) {
        String defaultValue;
        String value = this.properties.getProperty(propertyId);
        return value != (defaultValue = this.defaults.getProperty(propertyId)) && (value == null || !value.equals(defaultValue));
    }

    public void setPropertyValue(String propertyId, String value, String propagationId) {
        this.modifyPropertyValue(propertyId, value, propagationId);
    }

    public void forceSetPropertyValue(String propertyId, String value, String propagationId) {
        if (value == null) {
            this.properties.remove(propertyId);
        } else {
            this.properties.setProperty(propertyId, value);
        }
    }

    public void resetPropertyValue(String propertyId, String propagationId) {
        this.modifyPropertyValue(propertyId, this.defaults.getProperty(propertyId), propagationId);
    }

    protected void modifyPropertyValue(String propertyId, String value, String propagationId) {
        String oldValue = this.getPropertyValue(propertyId);
        if (oldValue == value || oldValue != null && oldValue.equals(value)) {
            return;
        }
        if ("theme".equals(this.getType())) {
            List<String> styleFamilyNames = this.getStyleFamilyNames();
            block0: for (String familyName : styleFamilyNames) {
                String uri;
                StyleEditModel model;
                String styleId;
                if (familyName.equals("map") || (styleId = this.properties.getProperty(familyName)) == null || (model = MODEL_REGISTRY.get(uri = StyleEditModel.generateAnonymousURI(styleId, this.transformStyleFamilyToStyleType(familyName)))) == null) continue;
                IPropertyDescriptor[] iPropertyDescriptorArray = model.getPropertyDescriptors();
                int n = iPropertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                    if (descriptor.getId().equals(propertyId)) {
                        if (descriptor.getId().equals("shape-class") && ("relationship".equals(familyName) || "boundary".equals(familyName) || "summary".equals(familyName))) continue block0;
                        model.isModifyByAll = true;
                        final StylePropertyChangeOperation op = new StylePropertyChangeOperation(model, propertyId, oldValue, value, propagationId);
                        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                            public void run() throws Exception {
                                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, null);
                            }
                        });
                        model.isModifyByAll = false;
                    }
                    ++n2;
                }
            }
        }
        final StylePropertyChangeOperation op = new StylePropertyChangeOperation(this, propertyId, oldValue, value, propagationId);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, null);
            }
        });
    }

    public boolean isPropertyResettable(String propertyId) {
        return !PROP_DISPLAY_NAME.equals(propertyId);
    }

    public void addListener(PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(listener);
    }

    public IUndoableOperation getUndoOperation() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().getUndoOperation(this.undoContext);
    }

    public IUndoableOperation getRedoOperation() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().getRedoOperation(this.undoContext);
    }

    public boolean canUndo() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().canUndo(this.undoContext) && !"theme".equals(this.getType());
    }

    public boolean canRedo() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().canRedo(this.undoContext) && !"theme".equals(this.getType());
    }

    public boolean isDirty() {
        return this.cleanOperation != this.getUndoOperation();
    }

    public void clean() {
        boolean oldDirty = this.isDirty();
        this.cleanOperation = this.getUndoOperation();
        boolean newDirty = this.isDirty();
        if (newDirty != oldDirty) {
            this.fireDirtyChange(oldDirty, newDirty);
        }
    }

    protected void fireDirtyChange(boolean oldDirty, boolean newDirty) {
        this.eventSupport.firePropertyChange(PROP_DIRTY, oldDirty, newDirty);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.eventSupport.firePropertyChange(event);
    }

    protected String doGetPropertyValue(String propertyId) {
        return this.properties.getProperty(propertyId);
    }

    protected void doSetPropertyValue(String propertyId, String value) {
        if (value == null) {
            this.properties.remove(propertyId);
        } else {
            this.properties.setProperty(propertyId, value);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void recordDefaultValues() {
        this.defaults.clear();
        this.defaults.setProperty(PROP_DISPLAY_NAME, this.properties.getProperty(PROP_DISPLAY_NAME));
        this.defaults.setProperty(PROP_NAME, this.properties.getProperty(PROP_NAME));
    }

    public void readStyle(IStyle style) {
        this.properties.clear();
        this.properties.setProperty(PROP_DISPLAY_NAME, style.getName());
        this.properties.setProperty(PROP_NAME, style.getName());
        Iterator ps = style.properties();
        while (ps.hasNext()) {
            Property p = (Property)ps.next();
            this.properties.setProperty(p.key, p.value);
        }
    }

    private List<String> getStyleFamilyNames() {
        ArrayList<String> styleFamilyNames = new ArrayList<String>();
        styleFamilyNames.add("centralTopic");
        styleFamilyNames.add("mainTopic");
        styleFamilyNames.add("subTopic");
        styleFamilyNames.add("calloutTopic");
        styleFamilyNames.add("floatingTopic");
        styleFamilyNames.add("map");
        styleFamilyNames.add("boundary");
        styleFamilyNames.add("relationship");
        styleFamilyNames.add("summary");
        styleFamilyNames.add("summaryTopic");
        return styleFamilyNames;
    }

    private String transformStyleFamilyToStyleType(String family) {
        if ("centralTopic".equals(family) || "mainTopic".equals(family) || "subTopic".equals(family) || "summaryTopic".equals(family) || "floatingTopic".equals(family) || "calloutTopic".equals(family)) {
            return "topic";
        }
        if ("relationship".equals(family)) {
            return "relationship";
        }
        if ("boundary".equals(family)) {
            return "boundary";
        }
        if ("map".equals(family)) {
            return "map";
        }
        if ("summary".equals(family)) {
            return "summary";
        }
        return null;
    }

    public void writeStyle(IStyle style) {
        style.setName(this.properties.getProperty(PROP_NAME));
        IPropertyDescriptor[] iPropertyDescriptorArray = this.descriptors;
        int n = this.descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor d = iPropertyDescriptorArray[n2];
            style.setProperty(d.getId(), this.properties.getProperty(d.getId()));
            ++n2;
        }
    }

    public void unload() {
        --this.references;
        if (this.references < 1) {
            MODEL_REGISTRY.remove(this.uri);
            this.dispose();
        }
    }

    private void dispose() {
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().removeOperationHistoryListener(this.operationHistoryListener);
    }

    public static StyleEditModel load(String uri, String displayName) {
        Object resource;
        Assert.isNotNull((Object)uri, (String)"key is null");
        StyleEditModel model = MODEL_REGISTRY.get(uri);
        if (model != null) {
            ++model.references;
            return model;
        }
        if (!StyleEditModel.isAnonymousURI(uri) && (resource = MindMapUI.getResourceManager().findResource(uri)) instanceof IStyle) {
            IStyle style = (IStyle)resource;
            IStyleSheet styleSheet = style.getOwnedStyleSheet();
            model = new StyleEditModel(uri, true, styleSheet == MindMapUI.getResourceManager().getSystemStyleSheet() || styleSheet == MindMapUI.getResourceManager().getSystemThemeSheet(), style.getType());
            model.readStyle(style);
        }
        if (model == null) {
            model = new StyleEditModel(uri, false, false, StyleEditModel.getAnonymousType(uri));
            String name = displayName != null ? displayName : StyleEditModel.getAnonymousName(uri);
            model.readAnonymousStyle(name);
        }
        model.recordDefaultValues();
        ++model.references;
        MODEL_REGISTRY.put(uri, model);
        return model;
    }

    private void readAnonymousStyle(String displayName) {
        this.properties.clear();
        this.properties.setProperty(PROP_DISPLAY_NAME, displayName);
        this.properties.setProperty(PROP_NAME, displayName);
    }

    public static StyleEditModel loadAnonymousStyle(IStyle style, String uri, String displayName) {
        Assert.isTrue((boolean)StyleEditModel.isAnonymousURI(uri));
        StyleEditModel model = MODEL_REGISTRY.get(uri);
        if (model != null) {
            ++model.references;
            return model;
        }
        model = new StyleEditModel(uri, false, false, StyleEditModel.getAnonymousType(uri));
        String name = displayName != null ? displayName : StyleEditModel.getAnonymousName(uri);
        model.readAnonymousStyle(name);
        model.readStyle(style);
        model.recordDefaultValues();
        ++model.references;
        MODEL_REGISTRY.put(uri, model);
        return model;
    }

    public static final String generateAnonymousURI(IStyle style) {
        String type = style.getType();
        String styleId = style.getId();
        return StyleEditModel.generateAnonymousURI(styleId, type);
    }

    private static final String generateAnonymousURI(String styleId, String styleType) {
        String prefix = "theme".equals(styleType) ? PREFIX_ANONYMOUS_THEME : PREFIX_ANONYMOUS_STYLE;
        return String.valueOf(prefix) + styleType + "/" + styleId;
    }

    public static final String generateAnonymousURI(String type) {
        if ("theme".equals(type)) {
            return PREFIX_ANONYMOUS_THEME + type + "/" + UUID.randomUUID().toString();
        }
        return PREFIX_ANONYMOUS_STYLE + type + "/" + UUID.randomUUID().toString();
    }

    public static final boolean isAnonymousURI(String uri) {
        return uri.startsWith(PREFIX_ANONYMOUS_STYLE) || uri.startsWith(PREFIX_ANONYMOUS_THEME);
    }

    private static final String getAnonymousType(String uri) {
        String[] segments = uri.split("/");
        if (segments.length > 1) {
            return segments[1];
        }
        return "topic";
    }

    public static final String getAnonymousStyleId(String uri) {
        String[] segments = uri.split("/");
        if (segments.length > 2) {
            return segments[2];
        }
        return null;
    }

    public static final String getAnonymousName(String uri) {
        StyleEditModel model = MODEL_REGISTRY.get(uri);
        if (model != null) {
            return model.getPropertyValue(PROP_DISPLAY_NAME);
        }
        if (uri.startsWith("theme:")) {
            return StyleEditorMessages.UntitledTheme_displayName;
        }
        return StyleEditorMessages.UntitledStyle_displayName;
    }

    public boolean isModifyByAll() {
        return this.isModifyByAll;
    }
}

