/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;

public abstract class PathElement {
    public abstract void addToPath(Path var1);

    public static PathElement getMoveElement(double x, double y) {
        return new MoveElement(x, y);
    }

    public static PathElement getClosePathElement() {
        return new ClosePathElement();
    }

    public static PathElement getCurveElement(double x1, double y1, double x2, double y2, double endX, double endY) {
        return new CurveElement(x1, y1, x2, y2, endX, endY);
    }

    public static PathElement getQuadraticBelzierCurveElement(double x, double y, double endX, double endY) {
        return new QuadraticBelzierCurveElement(x, y, endX, endY);
    }

    public static PathElement getLineElement(double x, double y) {
        return new LineElement(x, y);
    }

    private static class ClosePathElement
    extends PathElement {
        private ClosePathElement() {
        }

        @Override
        public void addToPath(Path path) {
            path.close();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClosePathElement;
        }

        public String toString() {
            return "Close Path";
        }
    }

    private static class CurveElement
    extends PathElement {
        private PrecisionPoint control1;
        private PrecisionPoint control2;
        private PrecisionPoint dest;

        public CurveElement(double x1, double y1, double x2, double y2, double endX, double endY) {
            this.control1 = new PrecisionPoint(x1, y1);
            this.control2 = new PrecisionPoint(x2, y2);
            this.dest = new PrecisionPoint(endX, endY);
        }

        @Override
        public void addToPath(Path path) {
            path.cubicTo(this.control1, this.control2, this.dest);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MoveElement) {
                CurveElement element = (CurveElement)obj;
                return this.control1.equals((Object)element.control1) && this.control2.equals((Object)element.control2) && this.dest.equals((Object)element.dest);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + (int)Double.doubleToLongBits(this.control1.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.control1.y);
            result = result * 31 + (int)Double.doubleToLongBits(this.control2.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.control2.y);
            result = result * 31 + (int)Double.doubleToLongBits(this.dest.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.dest.y);
            return result;
        }

        public String toString() {
            String str = "Curve to (";
            str = String.valueOf(str) + "control1:(" + this.control1.x + "," + this.control1.y + ")";
            str = String.valueOf(str) + "control2:(" + this.control2.x + "," + this.control2.y + ")";
            str = String.valueOf(str) + "dest(" + this.dest.x + "," + this.dest.y + ")";
            str = String.valueOf(str) + ")";
            return str;
        }
    }

    private static class LineElement
    extends PathElement {
        private PrecisionPoint p;

        public LineElement(double x, double y) {
            this.p = new PrecisionPoint(x, y);
        }

        @Override
        public void addToPath(Path path) {
            path.lineTo(this.p);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineElement) {
                LineElement element = (LineElement)obj;
                return this.p.equals((Object)element.p);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + (int)Double.doubleToLongBits(this.p.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.p.y);
            return result;
        }

        public String toString() {
            return "Line to(" + this.p.x + " " + this.p.y + ")";
        }
    }

    private static class MoveElement
    extends PathElement {
        private PrecisionPoint p;

        public MoveElement(double x, double y) {
            this.p = new PrecisionPoint(x, y);
        }

        @Override
        public void addToPath(Path path) {
            path.moveTo(this.p);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MoveElement) {
                MoveElement element = (MoveElement)obj;
                return this.p.equals((Object)element.p);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + (int)Double.doubleToLongBits(this.p.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.p.y);
            return result;
        }

        public String toString() {
            return "Move to (" + this.p.x + "," + this.p.y + ")";
        }
    }

    private static class QuadraticBelzierCurveElement
    extends PathElement {
        private PrecisionPoint control;
        private PrecisionPoint dest;

        public QuadraticBelzierCurveElement(double x, double y, double endX, double endY) {
            this.control = new PrecisionPoint(x, y);
            this.dest = new PrecisionPoint(endX, endY);
        }

        @Override
        public void addToPath(Path path) {
            path.quadTo(this.control, this.dest);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MoveElement) {
                CurveElement element = (CurveElement)obj;
                return this.control.equals((Object)element.control1) && this.dest.equals((Object)element.dest);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + (int)Double.doubleToLongBits(this.control.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.control.y);
            result = result * 31 + (int)Double.doubleToLongBits(this.dest.x);
            result = result * 31 + (int)Double.doubleToLongBits(this.dest.y);
            return result;
        }

        public String toString() {
            String str = "Quadratic Belzier Curve(";
            str = String.valueOf(str) + "control1:(" + this.control.x + "," + this.control.y + ")";
            str = String.valueOf(str) + "control2:(" + this.dest.x + " " + this.dest.y + ")";
            str = String.valueOf(str) + ")";
            return str;
        }
    }
}

