/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xmind.core.IBoundary;
import org.xmind.core.IImage;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.DeleteBoundaryCommand;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.DeleteRelationshipCommand;
import org.xmind.ui.commands.DeleteSummaryCommand;
import org.xmind.ui.commands.DeleteTopicCommand;
import org.xmind.ui.commands.ModifyImageAlignmentCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.util.MindMapUtils;

public class DeleteCommandBuilder
extends CommandBuilder {
    private static final Collection<Object> EMPTY = Collections.emptySet();
    private Stack<Object> deleting = null;
    private Set<IRelationship> relationships = null;
    private Map<ITopic, Set<ITopicRange>> subRanges = null;
    private Set<Object> deleted = null;

    public DeleteCommandBuilder(IViewer viewer, CommandBuilder delegate) {
        super(viewer, delegate);
    }

    public DeleteCommandBuilder(IViewer viewer, ICommandStack commandStack) {
        super(viewer, commandStack);
    }

    public void delete(Object element) {
        if (element instanceof ITopic) {
            this.deleteTopic((ITopic)element, true);
        } else if (element instanceof IBoundary) {
            this.deleteBoundary((IBoundary)element, true);
        } else if (element instanceof ISummary) {
            this.deleteSummary((ISummary)element, true);
        } else if (element instanceof IRelationship) {
            this.deleteRelationship((IRelationship)element, true);
        } else if (element instanceof IMarkerRef) {
            this.deleteMarkerRef((IMarkerRef)element, true);
        } else if (element instanceof IImage) {
            this.deleteImage((IImage)element, true);
        }
    }

    protected boolean startDeleting(Object element) {
        if (this.isDeleting(element) || this.isDeleted(element)) {
            return false;
        }
        if (this.deleting == null) {
            this.deleting = new Stack();
        }
        this.deleting.push(element);
        return true;
    }

    protected boolean isDeleting(Object element) {
        return this.deleting != null && this.deleting.contains(element);
    }

    protected void endDeleting() {
        if (this.deleting != null) {
            this.deleting.pop();
        }
    }

    protected void addDeleted(Object element) {
        if (this.deleted == null) {
            this.deleted = new HashSet<Object>();
        }
        this.deleted.add(element);
    }

    protected void removeDeleted(Object element) {
        if (this.deleted != null) {
            this.deleted.remove(element);
        }
    }

    protected boolean isDeleted(Object element) {
        return this.deleted != null && this.deleted.contains(element);
    }

    protected Collection<Object> getDeleted() {
        return this.deleted == null ? EMPTY : this.deleted;
    }

    protected Collection<Object> getDeleting() {
        return this.deleting == null ? EMPTY : this.deleting;
    }

    protected void deleteTopic(ITopic topic, boolean sourceCollectable) {
        if (!this.startDeleting(topic)) {
            return;
        }
        this.deleteRelsByTopic(topic);
        ITopic parent = topic.getParent();
        if (parent != null) {
            ISummary summary;
            String topicType = topic.getType();
            if ("attached".equals(topicType)) {
                Set<ITopicRange> ranges = this.getSubRanges(parent);
                this.deleteTopicInRanges(topic, ranges, parent);
            } else if ("summary".equals(topicType) && (summary = this.findSummaryBySummaryTopic(topic, parent)) != null) {
                this.deleteSummary(summary, false);
            }
        }
        this.add((Command)new DeleteTopicCommand(topic), sourceCollectable);
        this.addDeleted(topic);
        this.endDeleting();
    }

    protected void deleteTopicInRanges(ITopic topic, Set<ITopicRange> ranges, ITopic parent) {
        if (ranges.isEmpty()) {
            return;
        }
        int index = topic.getIndex();
        if (index < 0) {
            return;
        }
        Object[] objectArray = ranges.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            Object o = objectArray[n2];
            ITopicRange range = (ITopicRange)o;
            int start = range.getStartIndex();
            if (start == (end = range.getEndIndex()) && start == index) {
                this.deleteTopicRange(range);
            } else {
                if (start > index) {
                    this.add((Command)new ModifyRangeCommand((IRange)range, start - 1, true), false);
                }
                if (end >= index) {
                    this.add((Command)new ModifyRangeCommand((IRange)range, end - 1, false), false);
                }
            }
            ++n2;
        }
    }

    protected void deleteTopicRange(ITopicRange range) {
        if (range instanceof IBoundary) {
            this.deleteBoundary((IBoundary)range, false);
        } else if (range instanceof ISummary) {
            this.deleteSummary((ISummary)range, false);
        }
    }

    protected void deleteRelsByTopic(ITopic topic) {
        this.deleteRelByRelEnd((IRelationshipEnd)topic);
        for (ITopic child : topic.getAllChildren()) {
            this.deleteRelsByTopic(child);
        }
        for (IBoundary boundary : topic.getBoundaries()) {
            this.deleteRelByRelEnd((IRelationshipEnd)boundary);
        }
    }

    protected void deleteRelByRelEnd(IRelationshipEnd end) {
        if (this.hasRelationship()) {
            String id = end.getId();
            Object[] objectArray = this.getRelationships().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IRelationship r = (IRelationship)o;
                if (id.equals(r.getEnd1Id()) || id.equals(r.getEnd2Id())) {
                    this.deleteRelationship(r, false);
                }
                ++n2;
            }
        }
    }

    protected boolean hasRelationship() {
        return !this.getRelationships().isEmpty();
    }

    protected Set<IRelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new HashSet<IRelationship>();
            ISheet sheet = (ISheet)this.getViewer().getAdapter(ISheet.class);
            if (sheet != null) {
                this.relationships.addAll(sheet.getRelationships());
            }
        }
        return this.relationships;
    }

    protected ISummary findSummaryBySummaryTopic(ITopic topic, ITopic parent) {
        return MindMapUtils.findSummaryBySummaryTopic(topic, parent, this.getSubRanges(parent));
    }

    protected Set<ITopicRange> getSubRanges(ITopic parent) {
        Set<ITopicRange> ranges;
        if (this.subRanges == null) {
            this.subRanges = new HashMap<ITopic, Set<ITopicRange>>();
        }
        if ((ranges = this.subRanges.get(parent)) == null) {
            ranges = new HashSet<ITopicRange>();
            if (parent != null) {
                ranges.addAll(parent.getBoundaries());
                ranges.addAll(parent.getSummaries());
                this.subRanges.put(parent, ranges);
            }
        }
        return ranges;
    }

    protected void removeSubRange(ITopicRange range, ITopic parent) {
        Set<ITopicRange> ranges;
        if (this.subRanges != null && (ranges = this.subRanges.get(parent)) != null) {
            ranges.remove(range);
        }
    }

    protected void addSubRange(ITopicRange range, ITopic parent) {
        Set<ITopicRange> ranges;
        if (this.subRanges == null) {
            this.subRanges = new HashMap<ITopic, Set<ITopicRange>>();
        }
        if ((ranges = this.subRanges.get(parent)) == null) {
            ranges = new HashSet<ITopicRange>();
        }
        ranges.add(range);
    }

    protected void deleteBoundary(IBoundary boundary, boolean sourceCollectable) {
        if (!this.startDeleting(boundary)) {
            return;
        }
        this.deleteRelByRelEnd((IRelationshipEnd)boundary);
        ITopic parent = boundary.getParent();
        this.add((Command)new DeleteBoundaryCommand(boundary), sourceCollectable);
        this.removeSubRange((ITopicRange)boundary, parent);
        this.endDeleting();
        this.addDeleted(boundary);
    }

    protected void deleteSummary(ISummary summary, boolean sourceCollectable) {
        if (!this.startDeleting(summary)) {
            return;
        }
        ITopic parent = summary.getParent();
        ITopic summaryTopic = summary.getTopic();
        if (summaryTopic != null) {
            this.deleteTopic(summaryTopic, false);
        }
        this.add((Command)new DeleteSummaryCommand(summary), sourceCollectable);
        this.removeSubRange((ITopicRange)summary, parent);
        this.endDeleting();
        this.addDeleted(summary);
    }

    protected void deleteRelationship(IRelationship relationship, boolean sourceCollectable) {
        if (!this.startDeleting(relationship)) {
            return;
        }
        this.add((Command)new DeleteRelationshipCommand(relationship), sourceCollectable);
        if (this.relationships != null) {
            this.relationships.remove(relationship);
        }
        this.endDeleting();
        this.addDeleted(relationship);
    }

    protected void deleteMarkerRef(IMarkerRef markerRef, boolean sourceCollectable) {
        if (!this.startDeleting(markerRef)) {
            return;
        }
        this.add((Command)new DeleteMarkerCommand(markerRef), sourceCollectable);
        this.endDeleting();
        this.addDeleted(markerRef);
    }

    protected void deleteImage(IImage image, boolean sourceCollectable) {
        if (!this.startDeleting(image)) {
            return;
        }
        this.add((Command)new ModifyImageSourceCommand(image, null), sourceCollectable);
        this.add((Command)new ModifyImageAlignmentCommand(image, null), sourceCollectable);
        this.add((Command)new ModifyImageSizeCommand(image, -1, -1), sourceCollectable);
        this.endDeleting();
        this.addDeleted(image);
    }
}

