/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IDeserializer;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.IProgressReporter;
import org.xmind.core.util.ProgressReporter;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.Editable;
import org.xmind.gef.ui.editor.IEditingContext;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.IEncryptable;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.editor.MindMapPreviewOptions;
import org.xmind.ui.internal.editor.WorkbookRefEncryptable;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefListener;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.ImageFormat;

public abstract class AbstractWorkbookRef
extends Editable
implements IWorkbookRef,
ISchedulingRule,
IPropertyChangeListener {
    protected static final int TEMP_SAVING_DELAY = 500;
    protected static final String ATT_TEMP_LOCATION = "tempLocation";
    private static IEditingContext defaultEditingContext = IEditingContext.NULL;
    private IWorkbook workbook = null;
    private CoreEventRegister globalEventRegister = null;
    private IStorage tempStorage = null;
    private boolean shouldLoadFromTempStorage = false;
    private ICoreEventListener globalEventListener = new ICoreEventListener(){

        public void handleCoreEvent(CoreEvent event) {
            AbstractWorkbookRef.this.handleGlobalEvent(event);
        }
    };
    private WorkbookRefEncryptable encryptable = null;
    private Job tempSavingJob = null;
    private Object tempSavingLock = new Object();
    private List<IWorkbookRefListener> workbookRefListeners = new ArrayList<IWorkbookRefListener>();

    protected AbstractWorkbookRef(URI uri, IMemento state) {
        super(uri);
        this.setEncryptable(this.createEncryptable());
        this.setCommandStack((ICommandStack)new CommandStack(Math.max(MindMapUIPlugin.getDefault().getPreferenceStore().getInt("undoLimit"), 1)));
        MindMapUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        if (state != null) {
            IStorage savedTempStorage = this.restoreStateForTempStorage(state);
            this.shouldLoadFromTempStorage = savedTempStorage != null;
            this.setTempStorage(savedTempStorage);
        }
    }

    @Override
    public String getSaveWizardId() {
        return null;
    }

    @Override
    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    protected void setWorkbook(IWorkbook workbook) {
        IMarkerSheet markerSheet;
        IWorkbook oldWorkbook = this.workbook;
        if (workbook == oldWorkbook) {
            return;
        }
        if (this.globalEventRegister != null) {
            this.globalEventRegister.unregisterAll();
            this.globalEventRegister = null;
        }
        if (oldWorkbook != null && (markerSheet = oldWorkbook.getMarkerSheet()) != null) {
            markerSheet.setParentSheet(null);
        }
        this.workbook = workbook;
        if (workbook != null) {
            markerSheet = workbook.getMarkerSheet();
            if (markerSheet != null) {
                markerSheet.setParentSheet(MindMapUI.getResourceManager().getSystemMarkerSheet());
            }
            if (this.globalEventRegister == null) {
                this.globalEventRegister = new CoreEventRegister(this.globalEventListener);
            }
            this.registerGlobalEvents(this.globalEventRegister, workbook);
        }
    }

    private void registerGlobalEvents(CoreEventRegister register, IWorkbook workbook) {
        ICoreEventSupport support = (ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class);
        if (support != null) {
            register.setNextSupport(support);
            register.register("markerRefAdd");
            register.register("passwordChange");
        }
    }

    private void handleGlobalEvent(CoreEvent event) {
        String type = event.getType();
        if ("markerRefAdd".equals(type)) {
            this.handleMarkerAdded((String)event.getTarget());
        } else if ("passwordChange".equals(type)) {
            this.scheduleTempSaving();
        }
    }

    private void handleMarkerAdded(String markerId) {
        IMarkerGroup group;
        IMarkerSheet userMarkerSheet;
        IMarker userMarker;
        IMarkerGroup group2;
        IMarkerGroup recentMarkerGroup = MindMapUI.getResourceManager().getRecentMarkerGroup();
        IMarkerSheet systemMarkerSheet = MindMapUI.getResourceManager().getSystemMarkerSheet();
        IMarker systemMarker = systemMarkerSheet.findMarker(markerId);
        if (systemMarker != null && (group2 = systemMarker.getParent()) != null && group2.getParent() != null && group2.getParent().equals(systemMarkerSheet)) {
            recentMarkerGroup.addMarker(systemMarker);
        }
        if ((userMarker = (userMarkerSheet = MindMapUI.getResourceManager().getUserMarkerSheet()).findMarker(markerId)) != null && (group = userMarker.getParent()) != null && group.getParent() != null && group.getParent().equals(userMarkerSheet)) {
            recentMarkerGroup.addMarker(userMarker);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getWorkbook());
        }
        if (IPersistable.class.equals(adapter)) {
            return adapter.cast(this.getPersistable());
        }
        if (IEncryptable.class.equals(adapter)) {
            return adapter.cast(this.encryptable);
        }
        return (T)super.getAdapter(adapter);
    }

    protected void setEncryptable(WorkbookRefEncryptable encryptable) {
        this.encryptable = encryptable;
    }

    protected WorkbookRefEncryptable getEncryptable() {
        return this.encryptable;
    }

    protected IEntryStreamNormalizer getEncryptionHandler() {
        return this.encryptable != null ? this.encryptable.getEncryptor() : IEntryStreamNormalizer.NULL;
    }

    protected void doOpen(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkbook workbook = this.doLoadWorkbook((IProgressMonitor)subMonitor.newChild(90));
        Assert.isTrue((workbook != null ? 1 : 0) != 0);
        this.doSaveWorkbookToTempStorage((IProgressMonitor)subMonitor.newChild(10), workbook);
        this.setWorkbook(workbook);
        MindMapUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        MindMapUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected IWorkbook doLoadWorkbook(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        if (this.shouldLoadFromTempStorage) {
            try {
                IWorkbook iWorkbook = this.doLoadWorkbookFromTempStorage(monitor, this.getTempStorage());
                return iWorkbook;
            }
            finally {
                this.shouldLoadFromTempStorage = false;
            }
        }
        return this.doLoadWorkbookFromURI(monitor, this.getURI());
    }

    protected IWorkbook doLoadWorkbookFromTempStorage(IProgressMonitor monitor, IStorage tempStorage) throws InterruptedException, InvocationTargetException {
        try {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.setWorkbookStorage(tempStorage);
            deserializer.setWorkbookStorageAsInputSource();
            deserializer.deserialize((IProgressReporter)new ProgressReporter(monitor));
            return deserializer.getWorkbook();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            if (e.getType() == 100) {
                throw new InterruptedException();
            }
            throw new InvocationTargetException(e);
        }
    }

    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    protected void doSave(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.appendLog("[save] doSave start...");
        IWorkbook workbook = this.getWorkbook();
        Assert.isTrue((workbook != null ? 1 : 0) != 0);
        URI targetURI = this.getURI();
        Assert.isTrue((targetURI != null ? 1 : 0) != 0);
        ICoreEventSource workbookAsEventSource = workbook instanceof ICoreEventSource ? (ICoreEventSource)workbook : null;
        if (workbookAsEventSource != null) {
            workbookAsEventSource.getCoreEventSupport().dispatch(workbookAsEventSource, new CoreEvent(workbookAsEventSource, "workbookPreSaveOnce", null));
            workbookAsEventSource.getCoreEventSupport().dispatch(workbookAsEventSource, new CoreEvent(workbookAsEventSource, "workbookPreSave", null));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.doSaveWorkbookToTempStorage((IProgressMonitor)subMonitor.newChild(20), workbook);
        this.doSaveWorkbookToURI((IProgressMonitor)subMonitor.newChild(80), workbook, targetURI);
        if (workbookAsEventSource != null) {
            workbookAsEventSource.getCoreEventSupport().dispatch(workbookAsEventSource, new CoreEvent(workbookAsEventSource, "workbookSave", null));
        }
        this.appendLog("[save] doSave over...");
    }

    protected void doSaveWorkbookToTempStorage(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
        this.appendLog("[save] doSaveWorkbookToTempStorage start...");
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setWorkbookStorageAsOutputTarget();
            serializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            serializer.serialize((IProgressReporter)new ProgressReporter(monitor));
            this.appendLog("[save] doSaveWorkbookToTempStorage over...");
        }
        catch (IOException e) {
            this.appendLog("[save] doSaveWorkbookToTempStorage IOException...");
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            this.appendLog("[save] doSaveWorkbookToTempStorage CoreException...");
            if (e.getType() == 100) {
                throw new InterruptedException();
            }
            if (e.getType() == 17 && this.getEncryptable() != null) {
                this.getEncryptable().reset();
            }
            throw new InvocationTargetException(e);
        }
    }

    protected void doSaveWorkbookToURI(IProgressMonitor monitor, IWorkbook workbook, URI uri) throws InterruptedException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    protected void doClose(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.stopTempSaving();
        IWorkbook workbook = this.getWorkbook();
        if (workbook != null) {
            this.doUnloadWorkbook((IProgressMonitor)subMonitor.newChild(30), workbook);
            this.doClearTempStorageOnClose((IProgressMonitor)subMonitor.newChild(60), workbook);
        }
        if (this.encryptable != null) {
            this.encryptable.reset();
        }
        subMonitor.setWorkRemaining(10);
        subMonitor.newChild(10);
        this.setWorkbook(null);
        this.setCommandStack((ICommandStack)new CommandStack(Math.max(MindMapUIPlugin.getDefault().getPreferenceStore().getInt("undoLimit"), 1)));
        MindMapUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void doUnloadWorkbook(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
    }

    protected void doClearTempStorageOnClose(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
        IStorage storage = (IStorage)workbook.getAdapter(IStorage.class);
        if (storage != null) {
            storage.clear();
        }
    }

    protected IStorage getTempStorage() {
        if (this.tempStorage == null) {
            IWorkbook workbook = this.getWorkbook();
            if (workbook != null) {
                this.tempStorage = (IStorage)workbook.getAdapter(IStorage.class);
            }
            if (this.tempStorage == null) {
                this.tempStorage = this.createDefaultTempStorage();
            }
        }
        return this.tempStorage;
    }

    protected IStorage createDefaultTempStorage() {
        return MME.createTempStorage();
    }

    protected void setTempStorage(IStorage storage) {
        this.tempStorage = storage;
    }

    @Override
    public boolean canImportFrom(IWorkbookRef source) {
        return false;
    }

    @Override
    public void importFrom(IProgressMonitor monitor, IWorkbookRef source) throws InterruptedException, InvocationTargetException {
        if (!this.canImportFrom(source)) {
            throw new IllegalArgumentException("Can't import from the given workbook ref");
        }
        if (source.isInState(1)) {
            throw new IllegalArgumentException("The given workbook ref is closed");
        }
        if (!this.isInState(1)) {
            throw new IllegalStateException("Import operation is not allowed when workbook ref is already open");
        }
        if (this.isInState(56)) {
            throw new IllegalStateException("Concurrent open/close/save/import operations are not allowed in a workbook ref");
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.newChild(5);
            this.addState(16);
            try {
                this.doImportFrom((IProgressMonitor)subMonitor.newChild(90), source);
            }
            finally {
                subMonitor.newChild(5);
                this.removeState(16);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
    }

    protected void doImportFrom(IProgressMonitor monitor, IWorkbookRef source) throws InterruptedException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getPreviewImageData(String sheetId, MindMapPreviewOptions options) throws IOException {
        if (sheetId == null) {
            throw new IllegalArgumentException();
        }
        IWorkbook workbook = this.getWorkbook();
        IFileEntry contentEntry = workbook.getManifest().getFileEntry("content.xml");
        if (contentEntry != null && contentEntry.getEncryptionData() != null) {
            return null;
        }
        if (workbook != null && sheetId.equals(workbook.getPrimarySheet().getId())) {
            IFileEntry previewEntry = workbook.getManifest().getFileEntry(MindMapImageExporter.toThumbnailArchivePath(ImageFormat.PNG));
            if (previewEntry == null) {
                previewEntry = workbook.getManifest().getFileEntry(MindMapImageExporter.toThumbnailArchivePath(ImageFormat.JPEG));
            }
            if (previewEntry != null) {
                return previewEntry.openInputStream();
            }
        }
        return null;
    }

    protected void saveStateForTempStorage(IMemento state, IWorkbook workbook) {
        IStorage storage = (IStorage)workbook.getAdapter(IStorage.class);
        if (storage == null) {
            return;
        }
        if (storage instanceof DirectoryStorage) {
            String path = ((DirectoryStorage)storage).getFullPath();
            if (path != null) {
                state.putString(ATT_TEMP_LOCATION, path);
            }
        } else {
            boolean cfr_ignored_0 = storage instanceof ByteArrayStorage;
        }
    }

    protected IStorage restoreStateForTempStorage(IMemento state) {
        String tempLocation = state.getString(ATT_TEMP_LOCATION);
        if (tempLocation != null) {
            return new DirectoryStorage(new File(tempLocation));
        }
        return null;
    }

    protected IPersistable getPersistable() {
        return new IPersistable(){

            public void saveState(IMemento memento) {
                AbstractWorkbookRef.this.saveState(memento);
            }
        };
    }

    protected void saveState(IMemento memento) {
        if (this.isInState(33)) {
            return;
        }
        IWorkbook workbook = this.getWorkbook();
        if (workbook != null) {
            this.saveStateForTempStorage(memento, workbook);
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.workbook instanceof ICoreEventSource2 && ((ICoreEventSource2)this.workbook).hasOnceListeners("workbookPreSaveOnce");
    }

    protected IMindMapPreviewGenerator findPreviewGenerator() {
        return this.getService(IMindMapPreviewGenerator.class);
    }

    protected <T> T getService(Class<T> serviceType) {
        Object service = super.getService(serviceType);
        if (service == null) {
            service = defaultEditingContext.getAdapter(serviceType);
        }
        return (T)service;
    }

    protected WorkbookRefEncryptable createEncryptable() {
        return new WorkbookRefEncryptable(this);
    }

    public boolean contains(ISchedulingRule rule) {
        return this.equals(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.equals(rule);
    }

    protected void doHandleCommandStackChange(CommandStackEvent event) {
        super.doHandleCommandStackChange(event);
        if ((event.getStatus() & 0x38) != 0) {
            this.scheduleTempSaving();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTempSaving() {
        final IWorkbook theWorkbook = this.getWorkbook();
        if (theWorkbook == null) {
            return;
        }
        final AbstractWorkbookRef subFamily = this;
        Job job = new Job("Saving Workbook To Temporary Storage"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    AbstractWorkbookRef.this.doSaveWorkbookToTempStorage(null, theWorkbook);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    return new Status(2, "org.xmind.ui.mindmap", "Failed to save workbook to temp location", (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (subFamily.equals(family)) {
                    return true;
                }
                Object jobFamily = AbstractWorkbookRef.this.getJobFamily();
                return jobFamily != null && jobFamily.equals(family);
            }
        };
        job.setSystem(true);
        job.setRule((ISchedulingRule)this);
        Object object = this.tempSavingLock;
        synchronized (object) {
            if (this.tempSavingJob != null) {
                this.tempSavingJob.cancel();
                this.tempSavingJob = null;
            }
            this.tempSavingJob = job;
        }
        this.scheduleTempSavingJob(job);
    }

    protected void scheduleTempSavingJob(Job job) {
        job.schedule(500L);
    }

    protected Object getJobFamily() {
        return AbstractWorkbookRef.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTempSaving() {
        Object object = this.tempSavingLock;
        synchronized (object) {
            if (this.tempSavingJob != null) {
                this.tempSavingJob.cancel();
                this.tempSavingJob = null;
            }
        }
        Job.getJobManager().cancel((Object)this);
    }

    public static void setDefaultEditingContext(IEditingContext context) {
        defaultEditingContext = context == null ? IEditingContext.NULL : context;
    }

    @Override
    public void addWorkbookRefListener(IWorkbookRefListener workbookRefListener) {
        this.workbookRefListeners.add(workbookRefListener);
    }

    @Override
    public void removeWorkbookRefListener(IWorkbookRefListener workbookRefListener) {
        this.workbookRefListeners.remove(workbookRefListener);
    }

    protected void fileChanged(String title, String message, String[] buttons) {
        for (IWorkbookRefListener listener : new ArrayList<IWorkbookRefListener>(this.workbookRefListeners)) {
            listener.fileChanged(title, message, buttons);
        }
    }

    protected void fileRemoved(String title, String message, String[] buttons, boolean forceQuit) {
        for (IWorkbookRefListener listener : new ArrayList<IWorkbookRefListener>(this.workbookRefListeners)) {
            listener.fileRemoved(title, message, buttons, forceQuit);
        }
    }

    @Override
    public boolean activateNotifier() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        ICommandStack commandStack = this.getCommandStack();
        if (commandStack != null && "undoLimit".equals(event.getProperty())) {
            int num = 0;
            try {
                num = Integer.parseInt(event.getNewValue().toString());
            }
            catch (Exception exception) {}
            commandStack.setUndoLimit(Math.max(num, 1));
        }
    }
}

