/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.jobs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.command.transfer.IncomingCommandHandler;

public class OpenXMindCommandFileJob
extends Job {
    private static final String DEBUG_OPTION = "/debug/openXMindCommandFile";
    private static boolean DEBUGGING = CathyPlugin.getDefault().isDebugging("/debug/openXMindCommandFile");
    private String commandFilePath;

    public OpenXMindCommandFileJob(String commandFilePath) {
        super(NLS.bind((String)WorkbenchMessages.OpenXMindCommandFileJob_name, (Object)commandFilePath));
        this.commandFilePath = commandFilePath;
        this.setUser(false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (this.commandFilePath == null) {
            return new Status(2, "org.xmind.cathy", WorkbenchMessages.OpenXMindCommandFileJob_failed_noCommandFilePath_text);
        }
        File commandFile = new File(this.commandFilePath);
        if (!(commandFile.exists() && commandFile.isFile() && commandFile.canRead())) {
            return new Status(2, "org.xmind.cathy", NLS.bind((String)WorkbenchMessages.OpenXMindCommandFileJob_failed_fileIsNotReadable, (Object)this.commandFilePath));
        }
        try {
            FileInputStream input = new FileInputStream(commandFile);
            try {
                IStatus iStatus;
                OutputStream output = this.createOutputStream();
                try {
                    InternalOpenXMindCommandFileHandler handler = new InternalOpenXMindCommandFileHandler();
                    handler.setPluginId("org.xmind.cathy");
                    IStatus result = handler.handleIncomingCommand(monitor, input, output);
                    if (DEBUGGING) {
                        this.logOutput(output);
                    }
                    iStatus = result;
                }
                catch (Throwable throwable) {
                    output.close();
                    throw throwable;
                }
                output.close();
                return iStatus;
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException e) {
            return new Status(2, "org.xmind.cathy", NLS.bind((String)WorkbenchMessages.OpenXMindCommandFileJob_failed_openXMindCommandFile, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void logOutput(OutputStream output) {
        if (!(output instanceof ByteArrayOutputStream)) {
            return;
        }
        try {
            String outputText = ((ByteArrayOutputStream)output).toString("UTF-8");
            System.out.println("Response of XMind command file: " + this.commandFilePath);
            System.out.println(outputText);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private OutputStream createOutputStream() {
        if (DEBUGGING) {
            return new ByteArrayOutputStream(4096);
        }
        return new NullOutputStream();
    }

    private static class InternalOpenXMindCommandFileHandler
    extends IncomingCommandHandler {
        private InternalOpenXMindCommandFileHandler() {
        }

        protected IStatus createReadingErrorStatus(Throwable e) {
            return super.createReadingErrorStatus(e);
        }

        protected IStatus createWritingErrorStatus(Throwable e) {
            return super.createWritingErrorStatus(e);
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

