/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.EditDomain;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.spreadsheet.Messages;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetColumnStructure;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class AddRowInfoItemContributor
extends AbstractInfoItemContributor {
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IViewer viewer;
        IBranchPart branch = MindMapUtils.findBranch((IPart)topicPart);
        if (branch != null && (viewer = branch.getSite().getViewer()) != null && this.isStructureAlgorithmId(branch, "org.xmind.ui.structure.column.spreadsheet")) {
            return new AddRowAction(viewer, topic);
        }
        return null;
    }

    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.spreadsheet/icons/add_row.svg";
    }

    private boolean isStructureAlgorithmId(IBranchPart branch, String expectedValue) {
        String id = (String)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.branchCache.structureId");
        return id != null && id.equals(expectedValue);
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
    }

    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
    }

    private static class AddRowAction
    extends Action {
        private IViewer viewer;
        private ITopic chartTopic;

        public AddRowAction(IViewer viewer, ITopic chartTopic) {
            this.viewer = viewer;
            this.chartTopic = chartTopic;
        }

        public void run() {
            EditDomain domain = this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            ICommandStack cs = domain.getCommandStack();
            if (cs == null) {
                return;
            }
            IPart part = this.viewer.findPart((Object)this.chartTopic);
            IBranchPart branch = MindMapUtils.findBranch((IPart)part);
            if (branch == null) {
                return;
            }
            IStructure sa = branch.getBranchPolicy().getStructure((IGraphicalPart)branch);
            if (sa instanceof SpreadsheetColumnStructure) {
                int childrenSize;
                ArraySourceProvider colProvider;
                SpreadsheetColumnStructure ca = (SpreadsheetColumnStructure)sa;
                Chart2 chart = ca.getChart(branch);
                String newRowTitle = this.createRowHead(branch, chart);
                ArrayList<Object> cmds = new ArrayList<Object>();
                List children = this.chartTopic.getChildren("attached");
                IWorkbook workbook = this.chartTopic.getOwnedWorkbook();
                if (children.isEmpty()) {
                    CreateTopicCommand createCol = new CreateTopicCommand(workbook);
                    cmds.add(createCol);
                    colProvider = createCol;
                    cmds.add(this.createSetTitleTextCommand(this.chartTopic.isRoot(), this.chartTopic.getChildren("attached").size(), (ISourceProvider)colProvider));
                    cmds.add(new AddTopicCommand((ISourceProvider)colProvider, this.chartTopic));
                    childrenSize = 0;
                } else {
                    ITopic colTopic = (ITopic)children.get(0);
                    colProvider = new ArraySourceProvider((Object)colTopic);
                    childrenSize = colTopic.getChildren("attached").size();
                }
                CreateTopicCommand createCell = new CreateTopicCommand(workbook);
                cmds.add(createCell);
                cmds.add(this.createSetTitleTextCommand(false, childrenSize, (ISourceProvider)createCell));
                cmds.add(new ModifyLabelCommand((ISourceProvider)createCell, Collections.singletonList(newRowTitle)));
                cmds.add(new AddTopicCommand((ISourceProvider)createCell, (ISourceProvider)colProvider));
                cs.execute((Command)new CompoundCommand(Messages.Command_AddRow, cmds));
                this.viewer.setSelection((ISelection)new StructuredSelection(createCell.getSource()));
            }
        }

        private Command createSetTitleTextCommand(boolean isRoot, int childrenSize, ISourceProvider sourceProvider) {
            int index = childrenSize + 1;
            String newTitle = isRoot ? NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)index) : NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)index);
            return new ModifyTitleTextCommand(sourceProvider, newTitle);
        }

        private String createRowHead(IBranchPart branch, Chart2 chart) {
            int numRows = chart.getNumValidRows();
            String newColumnHead = NLS.bind((String)Messages.Label_pattern, (Object)(numRows + 1));
            while (this.containsRowHead(branch, chart, newColumnHead)) {
                String newName;
                if (newColumnHead.equals(newName = NLS.bind((String)Messages.Label_pattern, (Object)(++numRows + 1)))) break;
                newColumnHead = newName;
            }
            return newColumnHead;
        }

        private boolean containsRowHead(IBranchPart branch, Chart2 chart, String newColumnTitle) {
            for (Row2 row : chart.getRows()) {
                if (!newColumnTitle.equals(row.getHead().toString())) continue;
                return true;
            }
            return false;
        }
    }
}

