/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONObject;
import org.xmind.gef.EditDomain;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderContainer;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderEvent;
import org.xmind.ui.internal.iconfinder.IconfinderIconTransfer;
import org.xmind.ui.internal.iconfinder.IconfinderListener;
import org.xmind.ui.internal.iconfinder.Messages;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.internal.iconfinder.model.Iconset;
import org.xmind.ui.resources.ColorUtils;

public class IconsetDialog
extends PopupDialog {
    private Rectangle aroundBounds = null;
    private Composite contentContainer;
    private Composite loadingPage;
    private Composite contentPage;
    private GalleryViewer viewer;
    private Label iconsetNameLabel;
    private IconfinderContainer iconfinderContainer;
    private Icon icon;
    private IconfinderListener iconfinderListener;
    private String iconsetIdentifier;
    private List<Control> foregroundColorExclusions;
    private LocalResourceManager localResourceManager;

    public IconsetDialog(Shell parent, IconfinderContainer iconfinderContainer, Icon icon) {
        super(parent, 8, true, false, false, false, false, null, null);
        this.iconfinderContainer = iconfinderContainer;
        this.icon = icon;
        this.iconfinderListener = new IconfinderListener(){

            @Override
            public void handlerIconfinderEvent(final IconfinderEvent event) {
                if (IconsetDialog.this.viewer != null) {
                    final Control control = IconsetDialog.this.viewer.getControl();
                    if (control == null || control.isDisposed()) {
                        return;
                    }
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (control.isDisposed()) {
                                return;
                            }
                            if (event.getType() == 1) {
                                IconsetDialog.this.updateItem((Icon)event.getSource());
                            } else if (event.getType() == 2) {
                                IconsetDialog.this.updateAll();
                            }
                        }
                    });
                }
            }
        };
        IconfinderCore.getInstance().addIconfinderListener(iconfinderContainer.getSearchIconSessionId(), this.iconfinderListener);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = Math.max(initialSize.x, 420);
        initialSize.y = Math.max(initialSize.y, 98);
        return initialSize;
    }

    protected Control createDialogArea(Composite parent) {
        this.contentContainer = new Composite(parent, 0);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.contentContainer);
        this.contentContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        StackLayout stackLayout = new StackLayout();
        this.contentContainer.setLayout((Layout)stackLayout);
        this.loadingPage = new Composite(this.contentContainer, 0);
        this.loadingPage.setLayout((Layout)new GridLayout());
        this.loadingPage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        Label loadingLabel = new Label(this.loadingPage, 0);
        loadingLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        loadingLabel.setText(Messages.Iconfinder_LoadingState_label);
        this.contentPage = new Composite(this.contentContainer, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.verticalSpacing = 0;
        this.contentPage.setLayout((Layout)layout);
        this.contentPage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.iconsetNameLabel = new Label(this.contentPage, 0);
        this.iconsetNameLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        Composite viewerContainer = new Composite(this.contentPage, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginTop = 0;
        viewerContainer.setLayout((Layout)layout2);
        viewerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new GalleryViewer();
        this.configrateViewer(this.viewer);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
            }
        });
        Control control = this.viewer.createControl(viewerContainer);
        control.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        final Label viewAllLabel = new Label(viewerContainer, 0);
        viewAllLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.getForegroundColorExclusions().add((Control)viewAllLabel);
        viewAllLabel.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                viewAllLabel.setCursor(null);
            }

            public void mouseEnter(MouseEvent e) {
                viewAllLabel.setCursor(viewAllLabel.getDisplay().getSystemCursor(21));
            }
        });
        viewAllLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4A90E2")));
        viewAllLabel.setText(Messages.Iconfinder_ViewAll_ForIconset_label);
        viewAllLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconsetDialog.this.iconfinderContainer.promoteToSearchIconset(IconsetDialog.this.iconsetIdentifier);
                IconsetDialog.this.close();
            }
        });
        this.createDragSource(control);
        List<Icon> icons = this.getIcons();
        if (icons != null) {
            this.viewer.setInput(icons);
            stackLayout.topControl = this.contentPage;
        } else {
            this.viewer.setInput((Object)Collections.EMPTY_LIST);
            stackLayout.topControl = this.loadingPage;
        }
        this.getShell().addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IconsetDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IconsetDialog.this.close();
                    }
                });
            }
        });
        return this.contentContainer;
    }

    private void configrateViewer(GalleryViewer viewer) {
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        viewer.setEditDomain(editDomain);
        Properties properties = viewer.getProperties();
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("stretched", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 2, 2, new Insets(0)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(41, 41));
        viewer.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List icons = (List)inputElement;
                    return icons.toArray();
                }
                return null;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Icon) {
                    Icon icon = (Icon)element;
                    File previewFile = IconfinderCore.getIconPreviewFile(IconsetDialog.this.iconfinderContainer.getSearchIconSessionId(), icon.getIconId());
                    if (previewFile.exists()) {
                        URL url = null;
                        try {
                            url = previewFile.toURI().toURL();
                        }
                        catch (MalformedURLException e) {
                            IconfinderActivator.log(e, "Failed to create url from file: " + previewFile.getAbsolutePath());
                        }
                        if (url != null) {
                            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                            return IconsetDialog.this.localResourceManager.createImage(imageDescriptor);
                        }
                    }
                }
                return super.getImage(element);
            }
        });
    }

    public boolean close() {
        IconfinderCore.getInstance().removeIconfinderListener(this.iconfinderContainer.getSearchIconSessionId(), this.iconfinderListener);
        return super.close();
    }

    public int open(Rectangle aroundBounds) {
        this.aroundBounds = aroundBounds;
        return super.open();
    }

    public int open(Point location) {
        if (location != null) {
            this.aroundBounds = new Rectangle(location.x, location.y, 1, 1);
        }
        return super.open();
    }

    private Point calcLocation(Rectangle aroundBounds, Point shellSize) {
        Point loc = new Point(aroundBounds.x, aroundBounds.y);
        loc.x = aroundBounds.x - shellSize.x / 2;
        Rectangle area = this.getShell().getDisplay().getClientArea();
        loc.y = aroundBounds.y + aroundBounds.height + shellSize.y > area.y + area.height ? aroundBounds.y - shellSize.y : aroundBounds.y + aroundBounds.height;
        return loc;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.aroundBounds != null) {
            return this.calcLocation(this.aroundBounds, initialSize);
        }
        return super.getInitialLocation(initialSize);
    }

    protected Color getBackground() {
        return Display.getCurrent().getSystemColor(1);
    }

    private void createDragSource(Control control) {
        final DragSource dragSource = new DragSource(control, 1);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        dragSource.setTransfer(new Transfer[]{IconfinderIconTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            Icon[] selectedIcons;

            public void dragStart(DragSourceEvent event) {
                this.selectedIcons = this.getSelectedIcons();
                if (this.selectedIcons.length == 0) {
                    event.doit = false;
                }
            }

            private Icon[] getSelectedIcons() {
                ArrayList<Icon> icons = new ArrayList<Icon>();
                ISelection selection = IconsetDialog.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    for (Object o : ss.toList()) {
                        if (!(o instanceof Icon)) continue;
                        VerifyUI20141031.getUsageDataCollector().increase("Iconfinder/Icon/UseCount");
                        icons.add((Icon)o);
                    }
                }
                return icons.toArray(new Icon[icons.size()]);
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.selectedIcons;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private void updateItem(Icon element) {
        List input;
        if (this.viewer != null && element != null && (input = (List)this.viewer.getInput()) != null) {
            for (Icon rightIcon : input) {
                if (rightIcon.getIconId() != element.getIconId()) continue;
                this.viewer.update(new Object[]{rightIcon});
                break;
            }
        }
    }

    private void updateAll() {
        StackLayout stackLayout = (StackLayout)this.contentContainer.getLayout();
        stackLayout.topControl = this.contentPage;
        List<Icon> icons = this.getIcons();
        if (icons != null) {
            this.viewer.setInput(icons);
        }
        this.contentPage.layout(true);
        this.contentContainer.layout(true);
    }

    private List<Icon> getIcons() {
        JSONObject iconDetailObject;
        int iconId;
        String sessionId = this.iconfinderContainer.getSearchIconSessionId();
        File detailsDir = IconfinderCore.getIconDetailsDirBasedOn(sessionId);
        File iconDetailFile = new File(detailsDir, String.valueOf(iconId = this.icon.getIconId()) + ".json");
        if (iconDetailFile.exists() && (iconDetailObject = IconfinderCore.readObject(iconDetailFile)) != null) {
            JSONObject iconsetObject = iconDetailObject.optJSONObject("iconset");
            Iconset iconset = new Iconset(iconsetObject);
            this.iconsetIdentifier = iconset.getIdentifier();
            this.iconsetNameLabel.setText(iconset.getName());
            return IconfinderCore.getIcons(this.iconsetIdentifier, 6, sessionId);
        }
        return null;
    }

    protected List<Control> getForegroundColorExclusions() {
        if (this.foregroundColorExclusions == null) {
            this.foregroundColorExclusions = super.getForegroundColorExclusions();
        }
        return this.foregroundColorExclusions;
    }
}

