/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PrecisionInsets {
    public double left;
    public double right;
    public double top;
    public double bottom;

    public PrecisionInsets(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public PrecisionInsets(Insets ins) {
        this(ins.top, ins.left, ins.bottom, ins.right);
    }

    public PrecisionInsets(PrecisionInsets ins) {
        this(ins.top, ins.left, ins.bottom, ins.right);
    }

    public PrecisionInsets(double allside) {
        this(allside, allside, allside, allside);
    }

    public PrecisionInsets() {
        this(0.0);
    }

    public Insets toDraw2DInsets() {
        return PrecisionInsets.toDraw2DInsets(this.top, this.left, this.bottom, this.right);
    }

    public static Insets toDraw2DInsets(double top, double left, double bottom, double right) {
        return new Insets((int)Math.floor(top + 1.0E-9), (int)Math.floor(left + 1.0E-9), (int)Math.floor(bottom + 1.0E-9), (int)Math.floor(right + 1.0E-9));
    }

    public Insets getBiggerDraw2DInsets() {
        return this.toBiggerDraw2DInsets(this.top, this.left, this.bottom, this.right);
    }

    public Insets toBiggerDraw2DInsets(double top, double left, double bottom, double right) {
        return new Insets((int)Math.ceil(top), (int)Math.ceil(left), (int)Math.ceil(bottom), (int)Math.ceil(right));
    }

    public PrecisionInsets add(PrecisionInsets ins) {
        return this.add(ins.top, ins.left, ins.bottom, ins.right);
    }

    public PrecisionInsets add(Insets ins) {
        return this.add(ins.top, ins.left, ins.bottom, ins.right);
    }

    public PrecisionInsets add(double allSide) {
        return this.add(allSide, allSide, allSide, allSide);
    }

    public PrecisionInsets add(double t, double l, double b, double r) {
        this.top += t;
        this.left += l;
        this.bottom += b;
        this.right += r;
        return this;
    }

    public PrecisionInsets getAdded(PrecisionInsets ins) {
        return new PrecisionInsets(this).add(ins);
    }

    public PrecisionInsets getAdded(double t, double l, double b, double r) {
        return new PrecisionInsets(this).add(t, l, b, r);
    }

    public PrecisionInsets getAdded(double allSide) {
        return new PrecisionInsets(this).add(allSide);
    }

    public PrecisionInsets remove(PrecisionInsets ins) {
        this.top -= ins.top;
        this.left -= ins.left;
        this.bottom -= ins.bottom;
        this.right -= ins.right;
        return this;
    }

    public PrecisionInsets getRemoved(PrecisionInsets ins) {
        return new PrecisionInsets(this).remove(ins);
    }

    public PrecisionInsets negate() {
        this.top = -this.top;
        this.left = -this.left;
        this.bottom = -this.bottom;
        this.right = -this.right;
        return this;
    }

    public PrecisionInsets getNegated() {
        return new PrecisionInsets(this).negate();
    }

    public boolean isEmpty() {
        return this.left == 0.0 && this.right == 0.0 && this.top == 0.0 && this.bottom == 0.0;
    }

    public double getWidth() {
        return this.left + this.right;
    }

    public double getHeight() {
        return this.top + this.bottom;
    }

    public PrecisionRectangle getBounds(PrecisionPoint p) {
        return new PrecisionRectangle(p.x - this.left, p.y - this.top, this.getWidth(), this.getHeight());
    }

    public PrecisionDimension getSize() {
        return new PrecisionDimension(this.getWidth(), this.getHeight());
    }

    public PrecisionInsets setInsets(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        return this;
    }

    public PrecisionInsets setInsets(PrecisionInsets insets) {
        return this.setInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public PrecisionInsets transpose() {
        double temp = this.top;
        this.top = this.left;
        this.left = temp;
        temp = this.right;
        this.right = this.bottom;
        this.bottom = temp;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrecisionInsets)) {
            return false;
        }
        PrecisionInsets ins = (PrecisionInsets)obj;
        return ins.top == this.top && ins.left == this.left && ins.bottom == this.bottom && ins.right == this.right;
    }

    public String toString() {
        return "PrecisionInsets(t=" + this.top + ",l=" + this.left + ",b=" + this.bottom + ",r=" + this.right + ")";
    }
}

