/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.ILineDecoration;

public abstract class AbstractLineDecoration
extends AbstractDecoration
implements ILineDecoration {
    private Color color = null;
    private int width = 1;
    private int lineStyle = 1;

    protected AbstractLineDecoration() {
    }

    protected AbstractLineDecoration(String id) {
        super(id);
    }

    public Color getLineColor() {
        return this.color;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.width;
    }

    public void setLineColor(IFigure figure, Color color) {
        if (color == this.color || color != null && color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineStyle(IFigure figure, int style) {
        if (style == this.lineStyle) {
            return;
        }
        this.lineStyle = style;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineWidth(IFigure figure, int width) {
        if (width == this.width) {
            return;
        }
        this.width = width;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    protected void performPaint(IFigure figure, Graphics g) {
        g.setAlpha(this.getAlpha());
        g.setForegroundColor(this.getLineColor(figure));
        g.setLineWidth(this.getLineWidth());
        g.setLineStyle(this.getLineStyle());
        this.decorateLine(figure, g);
        this.drawLine(figure, g);
    }

    protected void decorateLine(IFigure figure, Graphics g) {
    }

    protected abstract void drawLine(IFigure var1, Graphics var2);

    protected Color getLineColor(IFigure figure) {
        Color c = this.getLineColor();
        return c == null ? figure.getForegroundColor() : c;
    }
}

