/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.SWTUtils;

public class SliderViewer
extends ContentViewer
implements IPostSelectionProvider {
    protected static int DEFAULT_WIDTH = 200;
    protected static int DEFAULT_HEIGHT = 15;
    private static final int SLOT_HEIGHT = 4;
    private Control control;
    private IFigure slotFigure;
    private IFigure blockFigure;
    private double selectionRatio = 0.0;
    private Object selectionValue = null;
    private boolean vertical;
    private List<IOpenListener> openListeners = null;
    private List<ISelectionChangedListener> postSelectionChangedListeners = null;

    public SliderViewer(Composite parent, int style) {
        this.vertical = (style & 0x200) != 0;
        this.control = this.createControl(parent, style);
        this.configureControl(this.control);
        this.hookControl(this.control);
        this.setContentProvider(new DefaultSliderContentProvider());
    }

    protected Control createControl(Composite parent, int style) {
        int canvasStyle = 537920256;
        SliderFigureCanvas fc = new SliderFigureCanvas(canvasStyle, parent);
        return fc;
    }

    protected void configureControl(Control control) {
        if (control instanceof Scale) {
            Scale scale = (Scale)control;
            scale.setMinimum(0);
            scale.setMaximum(10000);
            scale.setSelection(0);
            return;
        }
        if (control instanceof FigureCanvas) {
            FigureCanvas fc = (FigureCanvas)control;
            fc.setScrollBarVisibility(FigureCanvas.NEVER);
            fc.getLightweightSystem().setEventDispatcher((EventDispatcher)new SliderEventDispatcher());
            fc.setViewport(this.createViewport(fc));
            IFigure contents = this.createContents(fc);
            fc.setContents(contents);
            this.createSlotFigure(contents);
            this.createBlockFigure(contents);
        }
    }

    protected Viewport createViewport(FigureCanvas fc) {
        return new Viewport(true);
    }

    protected IFigure createContents(final FigureCanvas fc) {
        FreeformLayer contents = new FreeformLayer();
        contents.addLayoutListener((LayoutListener)new LayoutListener.Stub(){

            public boolean layout(IFigure container) {
                SliderViewer.this.layoutFigures(fc);
                return true;
            }
        });
        return contents;
    }

    protected void createBlockFigure(IFigure contents) {
        this.blockFigure = this.createBlockFigure();
        contents.add(this.blockFigure);
    }

    protected void createSlotFigure(IFigure contents) {
        this.slotFigure = this.createSlotFigure();
        contents.add(this.slotFigure);
    }

    protected IFigure createBlockFigure() {
        final BlockFigure figure = new BlockFigure();
        ImageDescriptor descriptor = ToolkitImages.get("slider_handle.png");
        final Image image = descriptor == null ? null : descriptor.createImage((Device)this.control.getDisplay());
        figure.setImage(image);
        figure.setSize(figure.getPreferredSize());
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (image != null) {
                    image.dispose();
                }
                figure.setImage(null);
            }
        });
        return figure;
    }

    protected IFigure createSlotFigure() {
        return new SlotFigure();
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        if (control instanceof Scale) {
            Listener listener = new Listener(){
                private boolean mouseDown = false;
                private boolean mouseDrag = false;
                private boolean selectionChangedDuringDragging = false;

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 13: {
                            boolean selectionChanged = SliderViewer.this.handleScaleSelection((Scale)event.widget);
                            if (!selectionChanged || this.selectionChangedDuringDragging || !this.mouseDrag && !this.mouseDown) break;
                            this.selectionChangedDuringDragging = true;
                            break;
                        }
                        case 8: {
                            this.mouseDown = false;
                            this.mouseDrag = false;
                            this.selectionChangedDuringDragging = false;
                            SliderViewer.this.fireOpen(new OpenEvent((Viewer)SliderViewer.this, SliderViewer.this.getSelection()));
                            break;
                        }
                        case 3: {
                            this.mouseDown = true;
                            this.mouseDrag = false;
                            this.selectionChangedDuringDragging = false;
                            break;
                        }
                        case 5: {
                            if (this.mouseDrag || !this.mouseDown) break;
                            this.mouseDrag = true;
                            break;
                        }
                        case 4: {
                            boolean postSelected = this.selectionChangedDuringDragging;
                            this.mouseDown = false;
                            this.mouseDrag = false;
                            this.selectionChangedDuringDragging = false;
                            if (!postSelected) break;
                            SliderViewer.this.firePostSelectionChanged();
                        }
                    }
                }
            };
            control.addListener(13, listener);
            control.addListener(8, listener);
            control.addListener(3, listener);
            control.addListener(5, listener);
            control.addListener(4, listener);
            return;
        }
        if (control instanceof FigureCanvas) {
            Listener listener = new Listener(){
                private boolean mouseDown = false;
                private boolean mouseDrag = false;
                private boolean selectionChangedDuringDragging = false;

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 11: {
                            SliderViewer.this.handleResize();
                            break;
                        }
                        case 5: {
                            if (!this.mouseDrag && this.mouseDown) {
                                this.mouseDrag = true;
                            }
                            if (!this.mouseDrag || (event.stateMask & 0x80000) == 0 || !SliderViewer.this.handleCanvasSelection(event.x, event.y)) break;
                            this.selectionChangedDuringDragging = true;
                            break;
                        }
                        case 3: {
                            if (!SliderViewer.this.receives(event.x, event.y)) break;
                            this.mouseDown = true;
                            this.mouseDrag = false;
                            if (event.button != 1 || !SliderViewer.this.handleCanvasSelection(event.x, event.y)) break;
                            this.selectionChangedDuringDragging = true;
                            break;
                        }
                        case 4: {
                            boolean postSelected = this.selectionChangedDuringDragging;
                            this.mouseDown = false;
                            this.mouseDrag = false;
                            this.selectionChangedDuringDragging = false;
                            if (!postSelected) break;
                            SliderViewer.this.firePostSelectionChanged();
                            break;
                        }
                        case 8: {
                            this.mouseDown = false;
                            this.mouseDrag = false;
                            SliderViewer.this.fireOpen(new OpenEvent((Viewer)SliderViewer.this, SliderViewer.this.getSelection()));
                        }
                    }
                }
            };
            control.addListener(5, listener);
            control.addListener(3, listener);
            control.addListener(4, listener);
            control.addListener(11, listener);
            control.addListener(8, listener);
        }
    }

    protected boolean handleScaleSelection(Scale scale) {
        int min = scale.getMinimum();
        double portion = (double)(scale.getSelection() - min) * 1.0 / (double)(scale.getMaximum() - min);
        boolean selectionChanged = this.internalSetSelection(portion, false);
        this.refresh();
        return selectionChanged;
    }

    protected boolean handleCanvasSelection(int x, int y) {
        double newPortion = this.calcNewPortionCanvas(x, y);
        newPortion = Math.max(0.0, Math.min(1.0, newPortion));
        return this.internalSetSelection(newPortion, true);
    }

    protected double calcNewPortionCanvas(int x, int y) {
        Rectangle r = this.slotFigure.getBounds();
        if (this.vertical) {
            return (double)(r.y + r.height - y) * 1.0 / (double)r.height;
        }
        return (double)(x - r.x) * 1.0 / (double)r.width;
    }

    protected boolean isVertical() {
        return this.vertical;
    }

    protected void layoutFigures(FigureCanvas fc) {
        Rectangle r = new Rectangle(fc.getViewport().getClientArea());
        if (this.vertical) {
            SliderViewer.transpose(r);
        }
        Dimension size = this.blockFigure.getPreferredSize();
        Rectangle b = new Rectangle(r.x + size.width / 2, r.y + (r.height - 4) / 2, r.width - size.width, 4);
        int x = (int)((double)b.x + (double)b.width * this.selectionRatio);
        int y = b.y + b.height - b.height / 2;
        Rectangle b2 = new Rectangle(x - size.width / 2, y - size.height / 2, size.width, size.height);
        if (this.vertical) {
            SliderViewer.transpose(b);
            SliderViewer.transpose(b2);
        }
        this.slotFigure.setBounds(b);
        this.blockFigure.setBounds(b2);
    }

    private static void transpose(Rectangle r) {
        int temp = r.x;
        r.x = -r.y - r.height;
        r.y = -temp - r.width;
        temp = r.width;
        r.width = r.height;
        r.height = temp;
    }

    protected boolean receives(int x, int y) {
        return this.slotFigure.containsPoint(x, y) || this.blockFigure.containsPoint(x, y);
    }

    protected IFigure getSlotFigure() {
        return this.slotFigure;
    }

    protected IFigure getBlockFigure() {
        return this.blockFigure;
    }

    protected double getSelectionPortion() {
        return this.selectionRatio;
    }

    public Control getControl() {
        return this.control;
    }

    public Object getSelectionValue() {
        if (this.selectionValue == null) {
            if (this.getContentProvider() instanceof ISliderContentProvider) {
                this.selectionValue = ((ISliderContentProvider)this.getContentProvider()).getValue(this.getInput(), 0.0);
            }
            if (this.selectionValue == null) {
                this.selectionValue = 0.0;
            }
        }
        return this.selectionValue;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.getSelectionValue());
    }

    public void refresh() {
        this.selectionRatio = this.calcSelectionRatio();
        if (this.control instanceof Scale) {
            this.refreshScale((Scale)this.control);
        } else if (this.control instanceof FigureCanvas) {
            this.refreshCanvas((FigureCanvas)this.control);
        }
    }

    protected void refreshScale(Scale scale) {
        int min = scale.getMinimum();
        int sel = (int)Math.round((double)(scale.getMaximum() - min) * this.selectionRatio + (double)min);
        scale.setSelection(sel);
        scale.setToolTipText(this.getSelectionText());
    }

    private String getSelectionText() {
        Object value = this.getSelectionValue();
        if (value == null) {
            return null;
        }
        if (this.getLabelProvider() instanceof ILabelProvider) {
            return ((ILabelProvider)this.getLabelProvider()).getText(value);
        }
        return null;
    }

    protected void refreshCanvas(FigureCanvas fc) {
        fc.getContents().revalidate();
        fc.getContents().repaint();
        String text = this.getSelectionText();
        if (text == null) {
            this.blockFigure.setToolTip(null);
        } else {
            this.blockFigure.setToolTip((IFigure)new Label(text));
        }
    }

    protected double calcSelectionRatio() {
        Object value = this.getSelectionValue();
        if (value != null) {
            if (this.getContentProvider() instanceof ISliderContentProvider) {
                return ((ISliderContentProvider)this.getContentProvider()).getRatio(this.getInput(), value);
            }
            if (value instanceof Double) {
                return (Double)value;
            }
        }
        return 0.0;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object value = ss.getFirstElement();
            this.internalSetSelection(value, true);
        }
    }

    protected boolean internalSetSelection(double newPortion, boolean needRefresh) {
        return this.internalSetSelection(this.calcSelectionValue(newPortion), needRefresh);
    }

    protected Object calcSelectionValue(double portion) {
        if (portion >= 0.0 && portion <= 1.0 && this.getContentProvider() instanceof ISliderContentProvider) {
            return ((ISliderContentProvider)this.getContentProvider()).getValue(this.getInput(), portion);
        }
        return portion;
    }

    protected boolean internalSetSelection(Object newValue, boolean needRefresh) {
        if (newValue == this.selectionValue || this.selectionValue != null && this.selectionValue.equals(newValue)) {
            return false;
        }
        this.selectionValue = newValue;
        if (needRefresh) {
            this.refresh();
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        return true;
    }

    protected void handleResize() {
        this.slotFigure.revalidate();
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpen(final OpenEvent event) {
        if (this.openListeners == null) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(event);
                }
            });
            ++n2;
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.postSelectionChangedListeners == null) {
            this.postSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.postSelectionChangedListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.postSelectionChangedListeners == null) {
            return;
        }
        this.postSelectionChangedListeners.remove(listener);
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        if (this.postSelectionChangedListeners == null) {
            return;
        }
        Object[] objectArray = this.postSelectionChangedListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((ISelectionChangedListener)l).selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void firePostSelectionChanged() {
        if (this.getControl().isDisposed()) {
            return;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SliderViewer.this.getControl().isDisposed()) {
                    return;
                }
                SliderViewer.this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)SliderViewer.this, SliderViewer.this.getSelection()));
            }
        });
    }

    private final class BlockFigure
    extends ImageFigure {
        private BlockFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setAntialias(1);
            if (SliderViewer.this.control != null && !SliderViewer.this.control.isDisposed() && SliderViewer.this.control.isEnabled()) {
                graphics.setAlpha(255);
            } else {
                graphics.setAlpha(128);
            }
            super.paintFigure(graphics);
        }
    }

    private static class DefaultSliderContentProvider
    implements ISliderContentProvider {
        private DefaultSliderContentProvider() {
        }

        @Override
        public double getRatio(Object input, Object value) {
            return (Double)value;
        }

        @Override
        public Object getValue(Object input, double ratio) {
            return ratio;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SliderEventDispatcher
    extends SWTEventDispatcher {
        private SliderEventDispatcher() {
        }

        protected void updateFigureUnderCursor(MouseEvent me) {
            super.updateFigureUnderCursor(me);
            if (this.getCursorTarget() == SliderViewer.this.blockFigure && (me.stateMask & SWT.BUTTON_MASK) != 0) {
                this.getToolTipHelper().updateToolTip(null, null, 0, 0);
                this.updateHoverSource(me);
            }
        }
    }

    private final class SliderFigureCanvas
    extends FigureCanvas {
        private SliderFigureCanvas(int style, Composite parent) {
            super(style, parent);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int w;
            int n = wHint != -1 ? wHint : (w = SliderViewer.this.vertical ? DEFAULT_HEIGHT : DEFAULT_WIDTH);
            int h = hHint != -1 ? hHint : (SliderViewer.this.vertical ? DEFAULT_WIDTH : DEFAULT_HEIGHT);
            org.eclipse.swt.graphics.Rectangle trim = this.computeTrim(0, 0, w, h);
            return new Point(trim.width, trim.height);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.redraw();
        }
    }

    private class SlotFigure
    extends Figure {
        private SlotFigure() {
        }

        public boolean containsPoint(int x, int y) {
            Rectangle r = this.getBounds();
            return y >= r.y - 5 && y < r.y + r.height + 5 && x >= r.x && x < r.x + r.width;
        }

        protected void paintFigure(Graphics graphics) {
            int alpha = 96;
            graphics.setAntialias(1);
            if (SliderViewer.this.control != null && !SliderViewer.this.control.isDisposed() && SliderViewer.this.control.isEnabled()) {
                graphics.setAlpha(255);
            } else {
                graphics.setAlpha(144);
            }
            Rectangle r = this.getBounds();
            Path shape = new Path((Device)Display.getCurrent());
            float corner = Math.max(2, (SliderViewer.this.vertical ? r.width : r.height) / 2);
            SWTUtils.addRoundedRectangle(shape, r.x, r.y, r.width - 1, r.height - 1, corner);
            Pattern pattern = new Pattern((Device)Display.getCurrent(), (float)r.x, (float)r.y, (float)(SliderViewer.this.vertical ? r.right() - 1 : r.x), (float)(SliderViewer.this.vertical ? r.y : r.bottom() - 1), ColorConstants.gray, alpha, ColorConstants.lightGray, alpha);
            graphics.setBackgroundPattern(pattern);
            graphics.fillPath(shape);
            graphics.setBackgroundPattern(null);
            pattern.dispose();
            graphics.setAlpha(alpha);
            graphics.setForegroundColor(ColorConstants.gray);
            graphics.drawPath(shape);
            shape.dispose();
        }
    }
}

