/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.tabfolder.MTabBar;

public class MTabBarItem
extends Item {
    public static final String TEXT = "text";
    public static final String TEXT_ALIGN = "textAlign";
    public static final String IMAGE = "image";
    public static final String FILL = "fill";
    public static final String MARGIN = "margin";
    public static final String SEPARATOR = "separator";
    public static final int DEFAULT_SEPARATOR_WIDTH = 24;
    private MTabBar parent;
    private int width = 24;
    private boolean visible = true;
    private boolean selected = false;
    private boolean preselected = false;
    private String color;
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    protected Rectangle contentBounds = new Rectangle(0, 0, 0, 0);
    protected Rectangle imageBounds = new Rectangle(0, 0, 0, 0);
    protected Rectangle textBounds = new Rectangle(0, 0, 0, 0);
    protected int marginWidth = 0;
    protected int marginHeight = 0;
    protected int hSpacing = 0;
    protected int vSpacing = 0;
    protected int textPosition = 1024;
    protected boolean imageVisible = true;
    protected boolean textVisible = true;
    protected Font font = null;

    public MTabBarItem(MTabBar parent, int style) {
        super((Widget)parent, MTabBarItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    private static int checkStyle(int style) {
        int primaryStyle = style & 0x5A;
        primaryStyle = primaryStyle == 0 ? 16 : ((primaryStyle & 8) != 0 ? 8 : ((primaryStyle & 0x40) != 0 ? 64 : ((primaryStyle & 2) != 0 ? 2 : 16)));
        return primaryStyle;
    }

    public MTabBarItem(MTabBar parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        parent.createItem(this, index);
    }

    public MTabBar getParent() {
        return this.parent;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width == -1) {
            width = 24;
        }
        if (width < -2 || width == this.width) {
            return;
        }
        this.width = width;
        this.parent.updateItem(this);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        this.parent.updateItem(this);
    }

    public void setImage(Image image) {
        if (this.isSeparator()) {
            return;
        }
        super.setImage(image);
        this.parent.updateItem(this);
    }

    public void setText(String string) {
        if (this.isSeparator()) {
            return;
        }
        super.setText(string);
        this.parent.updateItem(this);
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isSelected() {
        this.checkWidget();
        return this.selected;
    }

    public boolean isPreselected() {
        this.checkWidget();
        return this.preselected;
    }

    protected void setSelected(boolean selected) {
        if (this.isSeparator() || this.isSimple()) {
            return;
        }
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.parent.updateItem(this);
    }

    protected void setPreselected(boolean preselected) {
        if (this.isSeparator() || this.isSimple()) {
            return;
        }
        if (preselected == this.preselected) {
            return;
        }
        this.preselected = preselected;
        this.parent.updateItem(this);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    protected boolean setBounds(int x, int y, int width, int height) {
        boolean changed = this.bounds.x != x || this.bounds.y != y || this.bounds.width != width || this.bounds.height != height;
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = width;
        this.bounds.height = height;
        return changed;
    }

    protected boolean isRadioButton() {
        return (this.getStyle() & 0x10) != 0;
    }

    protected boolean isSeparator() {
        return (this.getStyle() & 2) != 0;
    }

    protected boolean isPushButton() {
        return (this.getStyle() & 8) != 0;
    }

    protected boolean isSimple() {
        return (this.getStyle() & 0x40) != 0;
    }

    public void dispose() {
        super.dispose();
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        this.parent = null;
    }
}

