/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom.scrollbar;

import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.AbstractScrollHandler;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.AbstractThemedScrollBarAdapter;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.IScrollBarSettings;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.ScrollBarPositions;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class StyledTextThemedScrollBarAdapter
extends AbstractThemedScrollBarAdapter {
    private final int fInitialRightMargin;
    private final int fInitialBottomMargin;

    public StyledTextThemedScrollBarAdapter(StyledText styledText) {
        this(styledText, new AbstractThemedScrollBarAdapter.ScrollBarSettings());
    }

    private StyledTextThemedScrollBarAdapter(StyledText styledText, IScrollBarSettings scrollBarSettings) {
        super((Scrollable)styledText, new StyledTextHorizontalScrollHandler(styledText, scrollBarSettings), new StyledTextVerticalScrollHandler(styledText, scrollBarSettings), scrollBarSettings);
        this.fInitialRightMargin = styledText.getRightMargin();
        this.fInitialBottomMargin = styledText.getBottomMargin();
    }

    @Override
    protected AbstractThemedScrollBarAdapter.IScrollBarPainter createPaintListener() {
        return new StyledTextPaintListener(this.fHorizontalScrollHandler, this.fVerticalScrollHandler, this.fScrollBarSettings, this.fInitialBottomMargin, this.fInitialRightMargin);
    }

    @Override
    protected Point computeHorizontalAndTopPixel() {
        StyledText styledText = (StyledText)this.fScrollable;
        return new Point(styledText.getHorizontalPixel(), styledText.getTopPixel());
    }

    public static StyledTextThemedScrollBarAdapter getScrollbarAdapter(StyledText styledText) {
        if (styledText.getData("StyledTextThemedScrollBarAdapter") == null) {
            StyledTextThemedScrollBarAdapter scrollbarOnlyWhenNeeded = new StyledTextThemedScrollBarAdapter(styledText);
            styledText.setData("StyledTextThemedScrollBarAdapter", (Object)scrollbarOnlyWhenNeeded);
            return scrollbarOnlyWhenNeeded;
        }
        Object data = styledText.getData("StyledTextThemedScrollBarAdapter");
        if (data instanceof StyledTextThemedScrollBarAdapter) {
            return (StyledTextThemedScrollBarAdapter)data;
        }
        return null;
    }

    static abstract class AbstractStyledTextScrollHandler
    extends AbstractScrollHandler
    implements ModifyListener,
    TextChangeListener {
        private final StyledText fStyledText;
        private AbstractThemedScrollBarAdapter fAbstractThemedScrollBarAdapter;
        private StyledTextContent fTextContent;
        private int fLastMax;
        private int fLastSelection;
        private int fCheckedTimes;

        protected AbstractStyledTextScrollHandler(StyledText styledText, ScrollBar scrollBar, IScrollBarSettings scrollBarSettings) {
            super(scrollBar, scrollBarSettings);
            this.fStyledText = styledText;
            this.fStyledText.setAlwaysShowScrollBars(true);
        }

        @Override
        protected void checkScrollbarInvisible() {
            if (this.fScrollBar == null || this.fScrollBar.isDisposed() || !this.fScrollBarSettings.getScrollBarThemed()) {
                return;
            }
            if (this.fScrollBar.isVisible()) {
                if (this.fCheckedTimes > 20) {
                    return;
                }
                ++this.fCheckedTimes;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractStyledTextScrollHandler.this.fStyledText.isDisposed()) {
                            return;
                        }
                        if (!AbstractStyledTextScrollHandler.this.fStyledText.getAlwaysShowScrollBars()) {
                            AbstractStyledTextScrollHandler.this.fStyledText.setAlwaysShowScrollBars(true);
                        }
                        if (AbstractStyledTextScrollHandler.this.fScrollBar != null && !AbstractStyledTextScrollHandler.this.fScrollBar.isDisposed()) {
                            AbstractStyledTextScrollHandler.this.fScrollBar.setVisible(false);
                        }
                    }
                });
            }
        }

        @Override
        public void install(AbstractThemedScrollBarAdapter abstractThemedScrollBarAdapter) {
            super.install(abstractThemedScrollBarAdapter);
            this.fStyledText.addModifyListener((ModifyListener)this);
            this.fAbstractThemedScrollBarAdapter = abstractThemedScrollBarAdapter;
            this.fTextContent = this.fStyledText.getContent();
            this.fTextContent.addTextChangeListener((TextChangeListener)this);
            if (this.fScrollBar != null) {
                this.fLastMax = this.fScrollBar.getMaximum();
                this.fLastSelection = this.fScrollBar.getSelection();
            }
        }

        @Override
        public void uninstall(AbstractThemedScrollBarAdapter abstractThemedScrollBarAdapter, boolean disposing) {
            super.uninstall(abstractThemedScrollBarAdapter, disposing);
            this.fStyledText.removeModifyListener((ModifyListener)this);
            if (this.fTextContent != null) {
                this.fTextContent.removeTextChangeListener((TextChangeListener)this);
                this.fTextContent = null;
            }
            this.fAbstractThemedScrollBarAdapter = null;
        }

        private void checkNeedUpdate() {
            if (this.fScrollBar != null && (this.fLastMax != this.fScrollBar.getMaximum() || this.fLastSelection != this.fScrollBar.getSelection())) {
                this.fAbstractThemedScrollBarAdapter.fPainter.redrawScrollBars();
            }
        }

        public void modifyText(ModifyEvent e) {
            this.checkNeedUpdate();
        }

        public void textSet(TextChangedEvent event) {
            this.checkNeedUpdate();
        }

        public void textChanged(TextChangedEvent event) {
            this.checkNeedUpdate();
        }

        public void textChanging(TextChangingEvent event) {
        }

        @Override
        public void paintControl(GC gc, Rectangle currClientArea, Scrollable scrollable) {
            if (this.fScrollBar != null) {
                this.fLastMax = this.fScrollBar.getMaximum();
                this.fLastSelection = this.fScrollBar.getSelection();
            }
            if (this.fTextContent != null && this.fStyledText.getContent() != this.fTextContent) {
                this.fTextContent.removeTextChangeListener((TextChangeListener)this);
                this.fTextContent = this.fStyledText.getContent();
                this.fTextContent.addTextChangeListener((TextChangeListener)this);
            }
            super.paintControl(gc, currClientArea, scrollable);
        }
    }

    static class StyledTextHorizontalScrollHandler
    extends AbstractStyledTextScrollHandler {
        public StyledTextHorizontalScrollHandler(StyledText styledText, IScrollBarSettings scrollBarSettings) {
            super(styledText, styledText.getHorizontalBar(), scrollBarSettings);
        }

        @Override
        public void setPixel(Scrollable scrollable, int pixel) {
            StyledText styledText = (StyledText)scrollable;
            styledText.setHorizontalPixel(pixel);
        }

        @Override
        protected Rectangle getFullBackgroundRect(Scrollable scrollable, Rectangle currClientArea, boolean considerMargins) {
            StyledText styledText = (StyledText)scrollable;
            int lineWidth = this.getCurrentScrollBarWidth();
            int w = currClientArea.width;
            int h = currClientArea.height;
            if (considerMargins) {
                w -= styledText.getLeftMargin() + styledText.getRightMargin();
            }
            Rectangle rect = new Rectangle(considerMargins ? styledText.getLeftMargin() : 0, h - lineWidth, w, lineWidth);
            return rect;
        }

        @Override
        public Rectangle computeProximityRect(Rectangle currClientArea) {
            if (this.fScrollBar == null || !this.getVisible()) {
                return null;
            }
            int lineWidth = this.getMouseNearScrollScrollBarWidth();
            int w = currClientArea.width;
            int h = currClientArea.height;
            Rectangle rect = new Rectangle(0, h - lineWidth, w, lineWidth);
            rect.height += 30;
            rect.y -= 15;
            return rect;
        }

        @Override
        protected int getRelevantPositionFromPos(Point styledTextPos) {
            return styledTextPos.x;
        }

        @Override
        public boolean computePositions(Rectangle currClientArea, Scrollable scrollable) {
            this.fHandleDrawnRect = null;
            if (this.fScrollBar == null || this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum() <= 1 || !this.getVisible() || !this.fScrollBarSettings.getScrollBarThemed()) {
                return false;
            }
            StyledText styledText = (StyledText)scrollable;
            int lineWidth = this.getCurrentScrollBarWidth();
            int w = currClientArea.width - (styledText.getLeftMargin() + styledText.getRightMargin());
            int h = currClientArea.height;
            this.fScrollBarPositions = new ScrollBarPositions.ScrollBarPositionsHorizontal(this.fScrollBar.getMinimum(), this.fScrollBar.getMaximum(), styledText.getHorizontalPixel(), h, w);
            this.fHandleDrawnRect = this.fScrollBarPositions.getHandleDrawRect(lineWidth);
            return this.fHandleDrawnRect != null && w > this.fHandleDrawnRect.width;
        }

        @Override
        public void doPaintControl(GC gc, Rectangle currClientArea, Scrollable scrollable) {
            if (this.fHandleDrawnRect != null) {
                StyledText styledText = (StyledText)scrollable;
                int lineWidth = this.getCurrentScrollBarWidth();
                int w = currClientArea.width - (styledText.getLeftMargin() + styledText.getRightMargin());
                int h = currClientArea.height;
                int borderRadius = Math.min(this.fScrollBarSettings.getScrollBarBorderRadius(), lineWidth);
                gc.fillRoundRectangle(styledText.getLeftMargin(), h - lineWidth, w, lineWidth, borderRadius, borderRadius);
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setBackground(foreground);
                gc.fillRoundRectangle(this.fHandleDrawnRect.x, this.fHandleDrawnRect.y, this.fHandleDrawnRect.width, this.fHandleDrawnRect.height, borderRadius, borderRadius);
                gc.setBackground(background);
            }
        }
    }

    public static class StyledTextPaintListener
    implements AbstractThemedScrollBarAdapter.IScrollBarPainter {
        private final int fInitialBottomMargin;
        private final int fInitialRightMargin;
        private StyledText fStyledText;
        private boolean fInDraw;
        private Rectangle fCurrClientArea;
        private AbstractScrollHandler fHorizontalScrollHandler;
        private AbstractScrollHandler fVerticalScrollHandler;
        private IScrollBarSettings fScrollBarSettings;
        private Rectangle fLastHorizontalHandleRect;
        private Rectangle fLastVerticalHandleRect;

        public StyledTextPaintListener(AbstractScrollHandler horizontalScrollHandler, AbstractScrollHandler verticalScrollHandler, IScrollBarSettings colorProvider, int initialBottomMargin, int initialRightMargin) {
            this.fHorizontalScrollHandler = horizontalScrollHandler;
            this.fVerticalScrollHandler = verticalScrollHandler;
            this.fScrollBarSettings = colorProvider;
            this.fInitialBottomMargin = initialBottomMargin;
            this.fInitialRightMargin = initialRightMargin;
        }

        @Override
        public void install(Scrollable scrollable) {
            this.fStyledText = (StyledText)scrollable;
        }

        @Override
        public void uninstall() {
            this.fStyledText = null;
            this.fCurrClientArea = null;
        }

        public void paintControl(PaintEvent e) {
            if (this.fInDraw || this.fStyledText == null || this.fStyledText.isDisposed()) {
                return;
            }
            try {
                this.fInDraw = true;
                this.clientAreaChangedFromLastCall();
                int charCount = this.fStyledText.getCharCount();
                if (charCount <= 1) {
                    return;
                }
                if (this.fCurrClientArea == null || this.fCurrClientArea.width < this.fVerticalScrollHandler.getMouseNearScrollScrollBarWidth() || this.fCurrClientArea.height < this.fHorizontalScrollHandler.getMouseNearScrollScrollBarWidth()) {
                    return;
                }
                boolean drawHorizontal = this.fHorizontalScrollHandler.computePositions(this.fCurrClientArea, (Scrollable)this.fStyledText);
                boolean drawVertical = this.fVerticalScrollHandler.computePositions(this.fCurrClientArea, (Scrollable)this.fStyledText);
                if (!drawHorizontal && !drawVertical) {
                    return;
                }
                try {
                    this.fixMargins(drawHorizontal, drawVertical);
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (AutoCloseable temp = this.configGC(e.gc);){
                        Rectangle handleRect;
                        Rectangle clipping = e.gc.getClipping();
                        boolean redrawAsync = false;
                        if (drawHorizontal) {
                            handleRect = this.fHorizontalScrollHandler.getHandleRect();
                            if (!handleRect.equals((Object)this.fLastHorizontalHandleRect) && clipping.intersection((Rectangle)handleRect).height != handleRect.height) {
                                redrawAsync = true;
                            }
                            this.fLastHorizontalHandleRect = handleRect;
                            this.fHorizontalScrollHandler.paintControl(e.gc, this.fCurrClientArea, (Scrollable)this.fStyledText);
                        }
                        if (drawVertical) {
                            handleRect = this.fVerticalScrollHandler.getHandleRect();
                            if (!handleRect.equals((Object)this.fLastVerticalHandleRect) && clipping.intersection((Rectangle)handleRect).width != handleRect.width) {
                                redrawAsync = true;
                            }
                            this.fLastVerticalHandleRect = handleRect;
                            this.fVerticalScrollHandler.paintControl(e.gc, this.fCurrClientArea, (Scrollable)this.fStyledText);
                        }
                        if (redrawAsync) {
                            this.redrawAsync();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e1) {
                    CSSActivator.getDefault().log(1, "Error painting scrollbar", e1);
                }
            }
            finally {
                this.fInDraw = false;
            }
        }

        private void redrawAsync() {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StyledTextPaintListener.this.fStyledText != null && !StyledTextPaintListener.this.fStyledText.isDisposed()) {
                        StyledTextPaintListener.this.fStyledText.redraw();
                    }
                }
            });
        }

        private boolean fixMargins(boolean drawHorizontal, boolean drawVertical) {
            int bottomMargin;
            int rightMargin;
            if (!drawVertical) {
                rightMargin = this.fInitialRightMargin;
            } else {
                int verticalLineWidth = this.fVerticalScrollHandler.getCurrentScrollBarWidth();
                int n = rightMargin = this.fInitialRightMargin < verticalLineWidth ? verticalLineWidth : this.fInitialRightMargin;
                if (this.fVerticalScrollHandler.fScrollBar == null || !this.fVerticalScrollHandler.getVisible()) {
                    rightMargin = this.fStyledText.getRightMargin();
                }
            }
            if (!drawHorizontal) {
                bottomMargin = this.fInitialBottomMargin;
            } else {
                int horizontalLineWidth = this.fHorizontalScrollHandler.getCurrentScrollBarWidth();
                int n = bottomMargin = this.fInitialBottomMargin < horizontalLineWidth ? horizontalLineWidth : this.fInitialBottomMargin;
                if (this.fHorizontalScrollHandler.fScrollBar == null || !this.fHorizontalScrollHandler.getVisible()) {
                    bottomMargin = this.fStyledText.getBottomMargin();
                }
            }
            if (this.fStyledText.getRightMargin() != rightMargin || this.fStyledText.getBottomMargin() != bottomMargin) {
                final int applyRightMargin = rightMargin;
                final int applyBottomMargin = bottomMargin;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (StyledTextPaintListener.this.fStyledText != null && !StyledTextPaintListener.this.fStyledText.isDisposed()) {
                            StyledTextPaintListener.this.fStyledText.setMargins(StyledTextPaintListener.this.fStyledText.getLeftMargin(), StyledTextPaintListener.this.fStyledText.getTopMargin(), applyRightMargin, applyBottomMargin);
                        }
                    }
                });
                return true;
            }
            return false;
        }

        private AutoCloseable configGC(final GC gc) {
            Color background;
            final int oldLineStyle = gc.getLineStyle();
            final int oldAlpha = gc.getAlpha();
            final Color oldForeground = gc.getForeground();
            final Color oldBackground = gc.getBackground();
            final int oldLineWidth = gc.getLineWidth();
            final int oldAntialias = gc.getAntialias();
            Color foreground = this.fScrollBarSettings.getForegroundColor();
            if (foreground != null) {
                gc.setForeground(foreground);
            }
            if ((background = this.fScrollBarSettings.getBackgroundColor()) != null) {
                gc.setBackground(background);
            }
            gc.setLineStyle(1);
            gc.setAntialias(1);
            gc.setLineWidth(1);
            return new AutoCloseable(){

                @Override
                public void close() throws Exception {
                    gc.setForeground(oldForeground);
                    gc.setBackground(oldBackground);
                    gc.setAlpha(oldAlpha);
                    gc.setLineStyle(oldLineStyle);
                    gc.setLineWidth(oldLineWidth);
                    gc.setAntialias(oldAntialias);
                }
            };
        }

        private boolean clientAreaChangedFromLastCall() {
            Rectangle clientArea = this.fStyledText.getClientArea();
            if (this.fCurrClientArea == null || !this.fCurrClientArea.equals((Object)clientArea)) {
                this.fCurrClientArea = clientArea;
                return true;
            }
            return false;
        }

        @Override
        public void redrawScrollBars() {
            if (Display.getCurrent() != null && this.fStyledText != null && !this.fStyledText.isDisposed() && this.fStyledText.isVisible()) {
                Rectangle clientArea = this.fStyledText.getClientArea();
                this.fStyledText.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
            }
        }
    }

    static class StyledTextVerticalScrollHandler
    extends AbstractStyledTextScrollHandler {
        public StyledTextVerticalScrollHandler(StyledText styledText, IScrollBarSettings scrollBarSettings) {
            super(styledText, styledText.getVerticalBar(), scrollBarSettings);
        }

        @Override
        public void setPixel(Scrollable scrollable, int pixel) {
            StyledText styledText = (StyledText)scrollable;
            styledText.setTopPixel(pixel);
        }

        @Override
        protected Rectangle getFullBackgroundRect(Scrollable scrollable, Rectangle currClientArea, boolean considerMargins) {
            StyledText styledText = (StyledText)scrollable;
            int lineWidth = this.getCurrentScrollBarWidth();
            int w = currClientArea.width;
            int h = currClientArea.height;
            if (considerMargins) {
                h -= styledText.getTopMargin() + styledText.getBottomMargin();
            }
            Rectangle rect = new Rectangle(w - lineWidth, considerMargins ? styledText.getTopMargin() : 0, lineWidth, h);
            return rect;
        }

        @Override
        public Rectangle computeProximityRect(Rectangle currClientArea) {
            if (this.fScrollBar == null || !this.getVisible()) {
                return null;
            }
            int lineWidth = this.getMouseNearScrollScrollBarWidth();
            int w = currClientArea.width;
            int h = currClientArea.height;
            Rectangle rect = new Rectangle(w - lineWidth, 0, lineWidth, h);
            rect.width += 30;
            rect.x -= 15;
            return rect;
        }

        @Override
        protected int getRelevantPositionFromPos(Point styledTextPos) {
            return styledTextPos.y;
        }

        @Override
        public boolean computePositions(Rectangle currClientArea, Scrollable scrollable) {
            this.fHandleDrawnRect = null;
            if (this.fScrollBar == null || this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum() <= 1 || !this.getVisible() || !this.fScrollBarSettings.getScrollBarThemed()) {
                return false;
            }
            StyledText styledText = (StyledText)scrollable;
            int lineWidth = this.getCurrentScrollBarWidth();
            int w = currClientArea.width;
            int h = currClientArea.height - (styledText.getTopMargin() + styledText.getBottomMargin());
            this.fScrollBarPositions = new ScrollBarPositions.ScrollBarPositionsVertical(this.fScrollBar.getMinimum(), this.fScrollBar.getMaximum(), styledText.getTopPixel(), h, w);
            this.fHandleDrawnRect = this.fScrollBarPositions.getHandleDrawRect(lineWidth);
            return this.fHandleDrawnRect != null && h > this.fHandleDrawnRect.height;
        }

        @Override
        public void doPaintControl(GC gc, Rectangle currClientArea, Scrollable scrollable) {
            if (this.fHandleDrawnRect != null) {
                StyledText styledText = (StyledText)scrollable;
                int lineWidth = this.getCurrentScrollBarWidth();
                int w = currClientArea.width;
                int h = currClientArea.height - (styledText.getTopMargin() + styledText.getBottomMargin());
                int borderRadius = Math.min(this.fScrollBarSettings.getScrollBarBorderRadius(), lineWidth);
                gc.fillRoundRectangle(w - lineWidth, styledText.getTopMargin(), lineWidth, h, borderRadius, borderRadius);
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setBackground(foreground);
                gc.fillRoundRectangle(this.fHandleDrawnRect.x, this.fHandleDrawnRect.y, this.fHandleDrawnRect.width, this.fHandleDrawnRect.height, borderRadius, borderRadius);
                gc.setBackground(background);
            }
        }
    }
}

