/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.xmind.verify.ui.AbstractProViewPart20141031;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.PageBook;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IRevealServiceListener;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.RevealEvent;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.index.IndexType;
import org.xmind.ui.internal.index.IndexViewer;
import org.xmind.ui.internal.index.Messages;
import org.xmind.ui.internal.index.resource.IIndexResource;
import org.xmind.ui.internal.index.resource.IndexResources;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tabfolder.IPageClosedListener;

public class IndexView
extends AbstractProViewPart20141031
implements IPartListener,
IPageChangedListener,
IContributedContentsView,
IPageClosedListener,
ICoreEventListener {
    private CoreEventRegister coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private Composite parentComposite;
    private IGraphicalEditor sourceEditor;
    private IndexResources indexResources;
    private IGraphicalEditorPage sourcePage;
    private PageBook viewerStack;
    private Control defaultPage;
    private Map<IGraphicalEditor, Collection<IGraphicalEditorPage>> pages = new HashMap<IGraphicalEditor, Collection<IGraphicalEditorPage>>();
    private boolean showCurrentPage = false;
    private int indexType = 32;
    private Map<IGraphicalEditor, Map<String, IndexViewer>> indexViewers = new HashMap<IGraphicalEditor, Map<String, IndexViewer>>();
    private MenuManager dropDownMenuManager;
    private Composite topComposite;
    ToolItem indexTypeToolItem;

    protected int getRequiredFeatures() {
        return 3;
    }

    protected String getFeatureKey() {
        return "IndexView";
    }

    protected void doCreatePartControl(Composite parent) {
        this.parentComposite = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.topComposite = this.createTopComposite(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite contentComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        contentComposite.setLayout((Layout)gridLayout);
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerStack = new PageBook(contentComposite, 0);
        this.viewerStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPage = this.createDefaultPage((Composite)this.viewerStack);
        this.viewerStack.showPage(this.defaultPage);
        this.partActivated((IWorkbenchPart)this.getSite().getPage().getActiveEditor());
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private Composite createTopComposite(Composite composite) {
        Composite topComposite = new Composite(composite, 131072);
        topComposite.setBackground(topComposite.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ShowWorkbookAction showWorkbookAction = new ShowWorkbookAction();
        ShowCurrentSheetAction showCurrentSheetAction = new ShowCurrentSheetAction();
        showWorkbookAction.setChecked(!this.isShowCurrentPage());
        showCurrentSheetAction.setChecked(this.isShowCurrentPage());
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.add((IAction)showWorkbookAction);
        toolBarManager.add((IAction)showCurrentSheetAction);
        ToolBar leftToolBar = toolBarManager.createControl(topComposite);
        leftToolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ToolBar rightToolBar = new ToolBar(topComposite, 0);
        rightToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.indexTypeToolItem = new ToolItem(rightToolBar, 4);
        this.indexTypeToolItem.setText(IndexType.ByAZ.getName());
        this.indexTypeToolItem.addListener(12, this.getToolItemListener());
        this.indexTypeToolItem.addListener(13, this.getToolItemListener());
        return topComposite;
    }

    private Listener getToolItemListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        IndexView.this.handleWidgetDispose(event);
                        break;
                    }
                    case 13: {
                        Widget ew = event.widget;
                        if (ew == null) break;
                        IndexView.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                    }
                }
            }
        };
    }

    private void handleWidgetSelection(Event event, boolean selection) {
        if (event.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)event.widget;
            MenuManager menuMan = this.getDropDownMenuManager();
            Menu menu = menuMan.createContextMenu((Control)item.getParent());
            if (menu != null) {
                Rectangle b = item.getBounds();
                Point p = item.getParent().toDisplay(b.x, b.y + b.height);
                menu.setLocation(p.x, p.y);
                menu.setVisible(true);
            }
        }
    }

    private MenuManager getDropDownMenuManager() {
        if (this.dropDownMenuManager == null) {
            this.dropDownMenuManager = new MenuManager();
            this.dropDownMenuManager.setRemoveAllWhenShown(true);
            this.dropDownMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    String[] stringArray = IndexType.getNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        manager.add((IAction)new IndexTypeAction(name));
                        ++n2;
                    }
                }
            });
        }
        return this.dropDownMenuManager;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget instanceof ToolItem && this.dropDownMenuManager != null) {
            this.dropDownMenuManager.dispose();
            this.dropDownMenuManager = null;
        }
    }

    public IndexViewer getIndexViewer(IGraphicalEditor editor, String viewerType) {
        Map<String, IndexViewer> typeToViewers = this.indexViewers.get(editor);
        if (typeToViewers == null) {
            return null;
        }
        return typeToViewers.get(viewerType);
    }

    private String parseIndexTypeToViewerType(int indexType) {
        if (indexType == 4 || indexType == 8) {
            return "multiColumn";
        }
        if (indexType == 1 || indexType == 2 || indexType == 16 || indexType == 32 || indexType == 64) {
            return "singleColumn";
        }
        return null;
    }

    private void registerCoreEventForEditor() {
        IWorkbook workbook;
        if (this.sourceEditor != null && (workbook = (IWorkbook)this.sourceEditor.getAdapter(IWorkbook.class)) instanceof ICoreEventSource) {
            this.coreEventRegister = new CoreEventRegister((ICoreEventSource)workbook, (ICoreEventListener)this);
            this.coreEventRegister.register("modifyTime");
            this.coreEventRegister.register("workbookSave");
        }
    }

    public IndexResources getIndexResources() {
        return this.indexResources;
    }

    public boolean isShowCurrentPage() {
        return this.showCurrentPage;
    }

    public void setIndexType(int type) {
        String oldViewerType = this.parseIndexTypeToViewerType(this.indexType);
        IndexViewer oldViewer = this.getIndexViewer(this.sourceEditor, oldViewerType);
        this.indexType = type;
        String viewerType = this.parseIndexTypeToViewerType(type);
        IndexViewer newViewer = this.getIndexViewer(this.sourceEditor, viewerType);
        if (newViewer == null) {
            newViewer = this.createIndexViewer(this.viewerStack, viewerType);
            Map<String, IndexViewer> typeToViewer = this.indexViewers.get(this.sourceEditor);
            typeToViewer.put(viewerType, newViewer);
        }
        this.indexViewerChanged(oldViewer, newViewer);
    }

    public void dispose() {
        this.setEditor(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        Object[] objectArray = this.pages.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object editor = objectArray[n2];
            this.partClosed((IWorkbenchPart)((IGraphicalEditor)editor));
            ++n2;
        }
        this.coreEventRegister.unregisterAll();
        super.dispose();
    }

    private Composite createDefaultPage(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(page, 16448);
        label.setText(Messages.IndexView_DefaultPage_description);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return page;
    }

    protected void doSetFocus() {
        IndexViewer indexViewer = this.getIndexViewer(this.sourceEditor, this.parseIndexTypeToViewerType(this.indexType));
        if (indexViewer != null && !indexViewer.getControl().isDisposed()) {
            indexViewer.setFocus();
        } else if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.setFocus();
        } else if (this.parentComposite != null && !this.parentComposite.isDisposed()) {
            this.parentComposite.setFocus();
        }
    }

    public void pageClosed(Object pageObject) {
        if (pageObject instanceof IGraphicalEditorPage) {
            IGraphicalEditorPage page = (IGraphicalEditorPage)pageObject;
            this.unregisterSourcePage(page);
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.sourceEditor;
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                IndexView.this.setSourcePage(page);
            }
        });
    }

    public void partActivated(final IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IndexView.this.setEditor((IGraphicalEditor)part);
            }
        });
    }

    private void setEditor(IGraphicalEditor editor) {
        IGlobalActionHandlerService actionService;
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class);
            if (actionService != null) {
                actionService.removeActionBars(this.getViewSite().getActionBars());
            }
        }
        this.sourceEditor = editor;
        this.indexResources = editor == null ? null : new IndexResources();
        this.registerCoreEventForEditor();
        if (this.sourceEditor != null) {
            if (!this.indexViewers.containsKey(this.sourceEditor)) {
                this.indexViewers.put(this.sourceEditor, new HashMap());
            }
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class);
            if (actionService != null) {
                actionService.addActionBars(this.getViewSite().getActionBars());
            }
            this.setSourcePage(this.sourceEditor.getActivePageInstance());
        } else {
            this.setSourcePage(null);
        }
    }

    private void setSourcePage(IGraphicalEditorPage page) {
        if (page == this.sourcePage) {
            return;
        }
        this.sourcePage = page;
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            IndexViewer viewer;
            Control pageToShow = this.defaultPage;
            if (this.sourcePage != null && (viewer = this.ensureIndexViewer(this.sourcePage)) != null && !viewer.getControl().isDisposed()) {
                pageToShow = viewer.getControl();
            }
            this.viewerStack.showPage(pageToShow);
        }
    }

    private void indexViewerChanged(IndexViewer oldViewer, IndexViewer newViewer) {
        if (newViewer != null && !newViewer.getControl().isDisposed() && this.sourceEditor != null && this.sourcePage != null) {
            IWorkbook workbook = (IWorkbook)this.sourceEditor.getAdapter(IWorkbook.class);
            IIndexResource resourceForWorkbook = this.indexResources.getResourceForWorkbook(workbook, this.indexType, true);
            ISheet sheet = (ISheet)this.sourcePage.getAdapter(ISheet.class);
            IIndexResource resourceForSheet = this.indexResources.getResourceForSheet(sheet, this.indexType, true);
            if (this.showCurrentPage) {
                newViewer.setInput(resourceForSheet);
            } else {
                newViewer.setInput(resourceForWorkbook);
            }
            if (oldViewer != newViewer) {
                this.getSite().setSelectionProvider((ISelectionProvider)newViewer);
                if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
                    this.viewerStack.showPage(newViewer.getControl());
                }
            }
        }
    }

    private IndexViewer ensureIndexViewer(IGraphicalEditorPage page) {
        String viewerType = this.parseIndexTypeToViewerType(this.indexType);
        IndexViewer viewer = this.getIndexViewer(this.sourceEditor, viewerType);
        if (viewer == null && this.sourceEditor != null) {
            viewer = this.createIndexViewer(this.viewerStack, viewerType);
            this.registerSourcePage(page);
            Map<String, IndexViewer> typeToViewer = this.indexViewers.get(this.sourceEditor);
            typeToViewer.put(viewerType, viewer);
        }
        if (viewer != null) {
            if (this.showCurrentPage) {
                ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
                if (sheet != null) {
                    viewer.setInput(this.indexResources.getResourceForSheet(sheet, this.indexType, true));
                }
            } else {
                IWorkbook workbook = (IWorkbook)page.getParentEditor().getAdapter(IWorkbook.class);
                if (workbook != null) {
                    viewer.setInput(this.indexResources.getResourceForWorkbook(workbook, this.indexType, true));
                }
            }
        }
        return viewer;
    }

    private void registerSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list == null) {
            list = new HashSet<IGraphicalEditorPage>();
            this.pages.put(editor, list);
        }
        list.add(page);
    }

    private void unregisterSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list != null) {
            list.remove(page);
            if (list.isEmpty()) {
                this.pages.remove(editor);
            }
        }
    }

    private IndexViewer createIndexViewer(PageBook parent, String viewerType) {
        IndexViewer viewer = new IndexViewer((Composite)parent, viewerType);
        viewer.setAutoExpandLevel(4);
        viewer.getTree().setLinesVisible(true);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
                    IndexView.this.reveal((ITopic)element);
                }
            }
        });
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return viewer;
    }

    private void reveal(ITopic topic) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.getSite().getPage().activate((IWorkbenchPart)this.sourceEditor);
        if (topic != null) {
            Object selectedPage;
            ISelectionProvider selectionProvider = this.sourceEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object)topic));
            }
            if ((selectedPage = this.sourceEditor.getSelectedPage()) instanceof IGraphicalEditorPage) {
                IGraphicalEditorPage page = (IGraphicalEditorPage)selectedPage;
                IGraphicalViewer viewer = page.getViewer();
                if (viewer == null) {
                    return;
                }
                IPart selectedPart = viewer.getFocusedPart();
                if (selectedPart instanceof IGraphicalPart) {
                    IGraphicalPart part = (IGraphicalPart)selectedPart;
                    new CenteredRevealHelper((IViewer)viewer).start(part);
                }
            }
        }
    }

    private void disposeIndexViewer(IndexViewer viewer) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().dispose();
            viewer = null;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        Map<String, IndexViewer> typeToViewer;
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Collection<IGraphicalEditorPage> oldPages = this.pages.remove(part);
        if (part == this.sourceEditor) {
            this.setEditor(null);
        }
        if (oldPages != null) {
            Object[] objectArray = oldPages.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.pageClosed(page);
                ++n2;
            }
        }
        if ((typeToViewer = this.indexViewers.remove(part)) != null) {
            for (IndexViewer viewer : typeToViewer.values()) {
                this.disposeIndexViewer(viewer);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == this) {
            VerifyUI20141031.getUsageDataCollector().increase("ShowIndexViewCount");
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if (this.sourceEditor == null) {
            return;
        }
        final String type = event.getType();
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if ("workbookSave".equals(type)) {
                        IndexViewer currentViewer = IndexView.this.getIndexViewer(IndexView.this.sourceEditor, IndexView.this.parseIndexTypeToViewerType(IndexView.this.indexType));
                        if (currentViewer != null) {
                            currentViewer.refresh();
                        }
                    } else if ("modifyTime".equals(type) && IndexView.this.sourceEditor != null) {
                        Control control;
                        IndexViewer currentViewer;
                        IWorkbook workbook = (IWorkbook)IndexView.this.sourceEditor.getAdapter(IWorkbook.class);
                        IIndexResource resourceForWorkbook = IndexView.this.indexResources.getResourceForWorkbook(workbook, IndexView.this.indexType, true);
                        IIndexResource resourceForSheet = null;
                        if (IndexView.this.sourcePage != null) {
                            ISheet sheet = (ISheet)IndexView.this.sourcePage.getAdapter(ISheet.class);
                            resourceForSheet = IndexView.this.indexResources.getResourceForSheet(sheet, IndexView.this.indexType, true);
                        }
                        if ((currentViewer = IndexView.this.getIndexViewer(IndexView.this.sourceEditor, IndexView.this.parseIndexTypeToViewerType(IndexView.this.indexType))) != null && (control = currentViewer.getControl()) != null && !control.isDisposed()) {
                            if (!IndexView.this.showCurrentPage) {
                                if (resourceForWorkbook != null) {
                                    currentViewer.setInput(resourceForWorkbook);
                                }
                            } else if (resourceForSheet != null) {
                                currentViewer.setInput(resourceForSheet);
                            }
                        }
                    }
                }
            });
        }
    }

    private class CenteredRevealHelper
    implements IRevealServiceListener {
        private ZoomingAndPanningRevealService service;
        private boolean oldCentered;

        public CenteredRevealHelper(IViewer viewer) {
            IViewerService service = viewer.getService(IRevealService.class);
            if (service != null && service instanceof ZoomingAndPanningRevealService) {
                this.service = (ZoomingAndPanningRevealService)service;
                this.oldCentered = this.service.isCentered();
            } else {
                this.service = null;
                this.oldCentered = false;
            }
        }

        public void start(IGraphicalPart part) {
            if (this.service != null) {
                this.service.setCentered(true);
                this.service.reveal((ISelection)new StructuredSelection((Object)part));
                this.service.addRevealServiceListener((IRevealServiceListener)this);
            }
        }

        public void revealingStarted(RevealEvent event) {
        }

        public void revealingCanceled(RevealEvent event) {
            this.restore();
        }

        public void revealingFinished(RevealEvent event) {
            this.restore();
        }

        void restore() {
            this.service.removeRevealServiceListener((IRevealServiceListener)this);
            this.service.setCentered(this.oldCentered);
        }
    }

    private class IndexTypeAction
    extends Action {
        IndexTypeAction(String name) {
            super(name, 2);
        }

        public void run() {
            if (IndexView.this.indexTypeToolItem != null && !IndexView.this.indexTypeToolItem.isDisposed()) {
                IndexView.this.setIndexType(IndexType.findByName(this.getText()).getType());
                IndexView.this.indexTypeToolItem.setText(this.getText());
                if (IndexView.this.topComposite != null && !IndexView.this.topComposite.isDisposed()) {
                    IndexView.this.topComposite.pack(true);
                    IndexView.this.topComposite.getParent().layout(true, true);
                }
            }
        }
    }

    private class ShowCurrentSheetAction
    extends Action {
        public ShowCurrentSheetAction() {
            super(Messages.IndexView_ShowSheetAction_text, 8);
            this.setId("org.xmind.ui.showCurrentSheet");
            this.setToolTipText(Messages.IndexView_ShowSheetAction_tooltip);
            this.setImageDescriptor(MindMapUI.getImages().get("sheet.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("sheet.png", false));
        }

        public void run() {
            if (IndexView.this.sourcePage == null) {
                return;
            }
            ISheet sheet = (ISheet)IndexView.this.sourcePage.getAdapter(ISheet.class);
            if (sheet == null) {
                return;
            }
            IndexViewer currentViewer = IndexView.this.getIndexViewer(IndexView.this.sourceEditor, IndexView.this.parseIndexTypeToViewerType(IndexView.this.indexType));
            if (currentViewer != null && !currentViewer.getControl().isDisposed()) {
                currentViewer.setInput(IndexView.this.indexResources.getResourceForSheet(sheet, IndexView.this.indexType, false));
            }
            IndexView.this.showCurrentPage = true;
        }
    }

    private class ShowWorkbookAction
    extends Action {
        public ShowWorkbookAction() {
            super(Messages.IndexView_ShowWorkbookAction_text, 8);
            this.setId("org.xmind.ui.showWorkbook");
            this.setToolTipText(Messages.IndexView_ShowWorkbookAction_tooltip);
            this.setImageDescriptor(MindMapUI.getImages().get("workbook.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("workbook.png", false));
        }

        public void run() {
            if (IndexView.this.sourceEditor == null) {
                return;
            }
            IWorkbook workbook = (IWorkbook)IndexView.this.sourceEditor.getAdapter(IWorkbook.class);
            if (workbook == null) {
                return;
            }
            IndexViewer currentViewer = IndexView.this.getIndexViewer(IndexView.this.sourceEditor, IndexView.this.parseIndexTypeToViewerType(IndexView.this.indexType));
            if (currentViewer != null && !currentViewer.getControl().isDisposed()) {
                currentViewer.setInput(IndexView.this.indexResources.getResourceForWorkbook(workbook, IndexView.this.indexType, false));
            }
            IndexView.this.showCurrentPage = false;
        }
    }
}

