// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DefaultsBase Defaults Base
//
// # HAProxy defaults configuration
//
// swagger:model defaults_base
type DefaultsBase struct {

	// error files
	ErrorFiles []*Errorfile `json:"error_files,omitempty"`

	// error files from HTTP errors
	ErrorFilesFromHTTPErrors []*Errorfiles `json:"errorfiles_from_http_errors,omitempty"`

	// log steps
	LogSteps []string `json:"log_steps,omitempty"`

	// abortonclose
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Abortonclose string `json:"abortonclose,omitempty"`

	// accept invalid http request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AcceptInvalidHTTPRequest string `json:"accept_invalid_http_request,omitempty"`

	// accept invalid http response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AcceptInvalidHTTPResponse string `json:"accept_invalid_http_response,omitempty"`

	// accept unsafe violations in http request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AcceptUnsafeViolationsInHTTPRequest string `json:"accept_unsafe_violations_in_http_request,omitempty"`

	// accept unsafe violations in http response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AcceptUnsafeViolationsInHTTPResponse string `json:"accept_unsafe_violations_in_http_response,omitempty"`

	// adv check
	// Enum: ["httpchk","ldap-check","mysql-check","pgsql-check","redis-check","smtpchk","ssl-hello-chk","tcp-check"]
	// +kubebuilder:validation:Enum=httpchk;ldap-check;mysql-check;pgsql-check;redis-check;smtpchk;ssl-hello-chk;tcp-check;
	AdvCheck string `json:"adv_check,omitempty"`

	// allbackups
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Allbackups string `json:"allbackups,omitempty"`

	// backlog
	Backlog *int64 `json:"backlog,omitempty"`

	// balance
	Balance *Balance `json:"balance,omitempty"`

	// check timeout
	CheckTimeout *int64 `json:"check_timeout,omitempty"`

	// checkcache
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Checkcache string `json:"checkcache,omitempty"`

	// clflog
	Clflog bool `json:"clflog,omitempty"`

	// client fin timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ClientFinTimeout *int64 `json:"client_fin_timeout,omitempty"`

	// client timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ClientTimeout *int64 `json:"client_timeout,omitempty"`

	// clitcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Clitcpka string `json:"clitcpka,omitempty"`

	// clitcpka cnt
	ClitcpkaCnt *int64 `json:"clitcpka_cnt,omitempty"`

	// clitcpka idle
	ClitcpkaIdle *int64 `json:"clitcpka_idle,omitempty"`

	// clitcpka intvl
	ClitcpkaIntvl *int64 `json:"clitcpka_intvl,omitempty"`

	// compression
	Compression *Compression `json:"compression,omitempty"`

	// connect timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ConnectTimeout *int64 `json:"connect_timeout,omitempty"`

	// contstats
	// Enum: ["enabled"]
	// +kubebuilder:validation:Enum=enabled;
	Contstats string `json:"contstats,omitempty"`

	// cookie
	Cookie *Cookie `json:"cookie,omitempty"`

	// default backend
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	DefaultBackend string `json:"default_backend,omitempty"`

	// default server
	DefaultServer *DefaultServer `json:"default_server,omitempty"`

	// disable h2 upgrade
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	DisableH2Upgrade string `json:"disable_h2_upgrade,omitempty"`

	// disabled
	Disabled bool `json:"disabled,omitempty"`

	// dontlog normal
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	DontlogNormal string `json:"dontlog_normal,omitempty"`

	// dontlognull
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Dontlognull string `json:"dontlognull,omitempty"`

	// dynamic cookie key
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	DynamicCookieKey string `json:"dynamic_cookie_key,omitempty"`

	// email alert
	EmailAlert *EmailAlert `json:"email_alert,omitempty"`

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// error log format
	ErrorLogFormat string `json:"error_log_format,omitempty"`

	// errorloc302
	Errorloc302 *Errorloc `json:"errorloc302,omitempty"`

	// errorloc303
	Errorloc303 *Errorloc `json:"errorloc303,omitempty"`

	// external check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ExternalCheck string `json:"external_check,omitempty"`

	// external check command
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ExternalCheckCommand string `json:"external_check_command,omitempty"`

	// external check path
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ExternalCheckPath string `json:"external_check_path,omitempty"`

	// forwardfor
	Forwardfor *Forwardfor `json:"forwardfor,omitempty"`

	// from
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	From string `json:"from,omitempty"`

	// fullconn
	Fullconn *int64 `json:"fullconn,omitempty"`

	// h1 case adjust bogus client
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	H1CaseAdjustBogusClient string `json:"h1_case_adjust_bogus_client,omitempty"`

	// h1 case adjust bogus server
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	H1CaseAdjustBogusServer string `json:"h1_case_adjust_bogus_server,omitempty"`

	// hash balance factor
	HashBalanceFactor *int64 `json:"hash_balance_factor,omitempty"`

	// hash type
	HashType *HashType `json:"hash_type,omitempty"`

	// http buffer request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPBufferRequest string `json:"http-buffer-request,omitempty"`

	// http use htx
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPUseHtx string `json:"http-use-htx,omitempty"`

	// http connection mode
	// Enum: ["httpclose","http-server-close","http-keep-alive"]
	// +kubebuilder:validation:Enum=httpclose;http-server-close;http-keep-alive;
	HTTPConnectionMode string `json:"http_connection_mode,omitempty"`

	// http ignore probes
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPIgnoreProbes string `json:"http_ignore_probes,omitempty"`

	// http keep alive timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPKeepAliveTimeout *int64 `json:"http_keep_alive_timeout,omitempty"`

	// http no delay
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPNoDelay string `json:"http_no_delay,omitempty"`

	// http pretend keepalive
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPPretendKeepalive string `json:"http_pretend_keepalive,omitempty"`

	// http request timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPRequestTimeout *int64 `json:"http_request_timeout,omitempty"`

	// http restrict req hdr names
	// Enum: ["preserve","delete","reject"]
	// +kubebuilder:validation:Enum=preserve;delete;reject;
	HTTPRestrictReqHdrNames string `json:"http_restrict_req_hdr_names,omitempty"`

	// http reuse
	// Enum: ["aggressive","always","never","safe"]
	// +kubebuilder:validation:Enum=aggressive;always;never;safe;
	HTTPReuse string `json:"http_reuse,omitempty"`

	// http send name header
	HTTPSendNameHeader *string `json:"http_send_name_header,omitempty"`

	// http use proxy header
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	HTTPUseProxyHeader string `json:"http_use_proxy_header,omitempty"`

	// httpchk params
	HttpchkParams *HttpchkParams `json:"httpchk_params,omitempty"`

	// httplog
	Httplog bool `json:"httplog,omitempty"`

	// httpslog
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Httpslog string `json:"httpslog,omitempty"`

	// idle close on response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	IdleCloseOnResponse string `json:"idle_close_on_response,omitempty"`

	// independent streams
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	IndependentStreams string `json:"independent_streams,omitempty"`

	// load server state from file
	// Enum: ["global","local","none"]
	// +kubebuilder:validation:Enum=global;local;none;
	LoadServerStateFromFile string `json:"load_server_state_from_file,omitempty"`

	// log format
	LogFormat string `json:"log_format,omitempty"`

	// log format sd
	LogFormatSd string `json:"log_format_sd,omitempty"`

	// log health checks
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	LogHealthChecks string `json:"log_health_checks,omitempty"`

	// log separate errors
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	LogSeparateErrors string `json:"log_separate_errors,omitempty"`

	// log tag
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	LogTag string `json:"log_tag,omitempty"`

	// logasap
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Logasap string `json:"logasap,omitempty"`

	// max keep alive queue
	MaxKeepAliveQueue *int64 `json:"max_keep_alive_queue,omitempty"`

	// maxconn
	Maxconn *int64 `json:"maxconn,omitempty"`

	// mode
	// Enum: ["tcp","http","log"]
	// +kubebuilder:validation:Enum=tcp;http;log;
	Mode string `json:"mode,omitempty"`

	// monitor uri
	MonitorURI MonitorURI `json:"monitor_uri,omitempty"`

	// mysql check params
	MysqlCheckParams *MysqlCheckParams `json:"mysql_check_params,omitempty"`

	// name
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	Name string `json:"name,omitempty"`

	// nolinger
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Nolinger string `json:"nolinger,omitempty"`

	// originalto
	Originalto *Originalto `json:"originalto,omitempty"`

	// persist
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Persist string `json:"persist,omitempty"`

	// persist rule
	PersistRule *PersistRule `json:"persist_rule,omitempty"`

	// pgsql check params
	PgsqlCheckParams *PgsqlCheckParams `json:"pgsql_check_params,omitempty"`

	// prefer last server
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	PreferLastServer string `json:"prefer_last_server,omitempty"`

	// queue timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	QueueTimeout *int64 `json:"queue_timeout,omitempty"`

	// redispatch
	Redispatch *Redispatch `json:"redispatch,omitempty"`

	// retries
	Retries *int64 `json:"retries,omitempty"`

	// retry on
	RetryOn string `json:"retry_on,omitempty"`

	// server fin timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ServerFinTimeout *int64 `json:"server_fin_timeout,omitempty"`

	// server timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ServerTimeout *int64 `json:"server_timeout,omitempty"`

	// smtpchk params
	SmtpchkParams *SmtpchkParams `json:"smtpchk_params,omitempty"`

	// socket stats
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SocketStats string `json:"socket_stats,omitempty"`

	// source
	Source *Source `json:"source,omitempty"`

	// splice auto
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SpliceAuto string `json:"splice_auto,omitempty"`

	// splice request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SpliceRequest string `json:"splice_request,omitempty"`

	// splice response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SpliceResponse string `json:"splice_response,omitempty"`

	// srvtcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Srvtcpka string `json:"srvtcpka,omitempty"`

	// srvtcpka cnt
	SrvtcpkaCnt *int64 `json:"srvtcpka_cnt,omitempty"`

	// srvtcpka idle
	SrvtcpkaIdle *int64 `json:"srvtcpka_idle,omitempty"`

	// srvtcpka intvl
	SrvtcpkaIntvl *int64 `json:"srvtcpka_intvl,omitempty"`

	// stats options
	StatsOptions *StatsOptions `json:"stats_options,omitempty"`

	// tarpit timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TarpitTimeout *int64 `json:"tarpit_timeout,omitempty"`

	// tcp smart accept
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	TCPSmartAccept string `json:"tcp_smart_accept,omitempty"`

	// tcp smart connect
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	TCPSmartConnect string `json:"tcp_smart_connect,omitempty"`

	// tcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Tcpka string `json:"tcpka,omitempty"`

	// tcplog
	Tcplog bool `json:"tcplog,omitempty"`

	// transparent
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Transparent string `json:"transparent,omitempty"`

	// tunnel timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TunnelTimeout *int64 `json:"tunnel_timeout,omitempty"`

	// unique id format
	UniqueIDFormat string `json:"unique_id_format,omitempty"`

	// unique id header
	UniqueIDHeader string `json:"unique_id_header,omitempty"`
}

// Validate validates this defaults base
func (m *DefaultsBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrorFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorFilesFromHTTPErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogSteps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAbortonclose(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptInvalidHTTPRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptInvalidHTTPResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptUnsafeViolationsInHTTPRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptUnsafeViolationsInHTTPResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdvCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAllbackups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBalance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientFinTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClitcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompression(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContstats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCookie(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultBackend(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDisableH2Upgrade(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDontlogNormal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDontlognull(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDynamicCookieKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmailAlert(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc302(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc303(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheckCommand(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheckPath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForwardfor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1CaseAdjustBogusClient(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1CaseAdjustBogusServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPBufferRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPUseHtx(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPConnectionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPIgnoreProbes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPKeepAliveTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPNoDelay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPPretendKeepalive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRequestTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRestrictReqHdrNames(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPReuse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPUseProxyHeader(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHttpchkParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHttpslog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdleCloseOnResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIndependentStreams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLoadServerStateFromFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogHealthChecks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogSeparateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogTag(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogasap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitorURI(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMysqlCheckParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNolinger(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOriginalto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersistRule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePgsqlCheckParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePreferLastServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQueueTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedispatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerFinTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSmtpchkParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSocketStats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceAuto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSrvtcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatsOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarpitTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPSmartAccept(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPSmartConnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransparent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTunnelTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DefaultsBase) validateErrorFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFiles) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFiles); i++ {
		if swag.IsZero(m.ErrorFiles[i]) { // not required
			continue
		}

		if m.ErrorFiles[i] != nil {
			if err := m.ErrorFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DefaultsBase) validateErrorFilesFromHTTPErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFilesFromHTTPErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {
		if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
			continue
		}

		if m.ErrorFilesFromHTTPErrors[i] != nil {
			if err := m.ErrorFilesFromHTTPErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var defaultsBaseLogStepsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["accept","request","connect","response","close","error","any"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseLogStepsItemsEnum = append(defaultsBaseLogStepsItemsEnum, v)
	}
}

func (m *DefaultsBase) validateLogStepsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseLogStepsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateLogSteps(formats strfmt.Registry) error {
	if swag.IsZero(m.LogSteps) { // not required
		return nil
	}

	for i := 0; i < len(m.LogSteps); i++ {

		// value enum
		if err := m.validateLogStepsItemsEnum("log_steps"+"."+strconv.Itoa(i), "body", m.LogSteps[i]); err != nil {
			return err
		}

	}

	return nil
}

var defaultsBaseTypeAbortonclosePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAbortonclosePropEnum = append(defaultsBaseTypeAbortonclosePropEnum, v)
	}
}

const (

	// DefaultsBaseAbortoncloseEnabled captures enum value "enabled"
	DefaultsBaseAbortoncloseEnabled string = "enabled"

	// DefaultsBaseAbortoncloseDisabled captures enum value "disabled"
	DefaultsBaseAbortoncloseDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAbortoncloseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAbortonclosePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAbortonclose(formats strfmt.Registry) error {
	if swag.IsZero(m.Abortonclose) { // not required
		return nil
	}

	// value enum
	if err := m.validateAbortoncloseEnum("abortonclose", "body", m.Abortonclose); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAcceptInvalidHTTPRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAcceptInvalidHTTPRequestPropEnum = append(defaultsBaseTypeAcceptInvalidHTTPRequestPropEnum, v)
	}
}

const (

	// DefaultsBaseAcceptInvalidHTTPRequestEnabled captures enum value "enabled"
	DefaultsBaseAcceptInvalidHTTPRequestEnabled string = "enabled"

	// DefaultsBaseAcceptInvalidHTTPRequestDisabled captures enum value "disabled"
	DefaultsBaseAcceptInvalidHTTPRequestDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAcceptInvalidHTTPRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAcceptInvalidHTTPRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAcceptInvalidHTTPRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptInvalidHTTPRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptInvalidHTTPRequestEnum("accept_invalid_http_request", "body", m.AcceptInvalidHTTPRequest); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAcceptInvalidHTTPResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAcceptInvalidHTTPResponsePropEnum = append(defaultsBaseTypeAcceptInvalidHTTPResponsePropEnum, v)
	}
}

const (

	// DefaultsBaseAcceptInvalidHTTPResponseEnabled captures enum value "enabled"
	DefaultsBaseAcceptInvalidHTTPResponseEnabled string = "enabled"

	// DefaultsBaseAcceptInvalidHTTPResponseDisabled captures enum value "disabled"
	DefaultsBaseAcceptInvalidHTTPResponseDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAcceptInvalidHTTPResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAcceptInvalidHTTPResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAcceptInvalidHTTPResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptInvalidHTTPResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptInvalidHTTPResponseEnum("accept_invalid_http_response", "body", m.AcceptInvalidHTTPResponse); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAcceptUnsafeViolationsInHTTPRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAcceptUnsafeViolationsInHTTPRequestPropEnum = append(defaultsBaseTypeAcceptUnsafeViolationsInHTTPRequestPropEnum, v)
	}
}

const (

	// DefaultsBaseAcceptUnsafeViolationsInHTTPRequestEnabled captures enum value "enabled"
	DefaultsBaseAcceptUnsafeViolationsInHTTPRequestEnabled string = "enabled"

	// DefaultsBaseAcceptUnsafeViolationsInHTTPRequestDisabled captures enum value "disabled"
	DefaultsBaseAcceptUnsafeViolationsInHTTPRequestDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAcceptUnsafeViolationsInHTTPRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAcceptUnsafeViolationsInHTTPRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAcceptUnsafeViolationsInHTTPRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptUnsafeViolationsInHTTPRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptUnsafeViolationsInHTTPRequestEnum("accept_unsafe_violations_in_http_request", "body", m.AcceptUnsafeViolationsInHTTPRequest); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAcceptUnsafeViolationsInHTTPResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAcceptUnsafeViolationsInHTTPResponsePropEnum = append(defaultsBaseTypeAcceptUnsafeViolationsInHTTPResponsePropEnum, v)
	}
}

const (

	// DefaultsBaseAcceptUnsafeViolationsInHTTPResponseEnabled captures enum value "enabled"
	DefaultsBaseAcceptUnsafeViolationsInHTTPResponseEnabled string = "enabled"

	// DefaultsBaseAcceptUnsafeViolationsInHTTPResponseDisabled captures enum value "disabled"
	DefaultsBaseAcceptUnsafeViolationsInHTTPResponseDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAcceptUnsafeViolationsInHTTPResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAcceptUnsafeViolationsInHTTPResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAcceptUnsafeViolationsInHTTPResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptUnsafeViolationsInHTTPResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptUnsafeViolationsInHTTPResponseEnum("accept_unsafe_violations_in_http_response", "body", m.AcceptUnsafeViolationsInHTTPResponse); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAdvCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["httpchk","ldap-check","mysql-check","pgsql-check","redis-check","smtpchk","ssl-hello-chk","tcp-check"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAdvCheckPropEnum = append(defaultsBaseTypeAdvCheckPropEnum, v)
	}
}

const (

	// DefaultsBaseAdvCheckHttpchk captures enum value "httpchk"
	DefaultsBaseAdvCheckHttpchk string = "httpchk"

	// DefaultsBaseAdvCheckLdapDashCheck captures enum value "ldap-check"
	DefaultsBaseAdvCheckLdapDashCheck string = "ldap-check"

	// DefaultsBaseAdvCheckMysqlDashCheck captures enum value "mysql-check"
	DefaultsBaseAdvCheckMysqlDashCheck string = "mysql-check"

	// DefaultsBaseAdvCheckPgsqlDashCheck captures enum value "pgsql-check"
	DefaultsBaseAdvCheckPgsqlDashCheck string = "pgsql-check"

	// DefaultsBaseAdvCheckRedisDashCheck captures enum value "redis-check"
	DefaultsBaseAdvCheckRedisDashCheck string = "redis-check"

	// DefaultsBaseAdvCheckSmtpchk captures enum value "smtpchk"
	DefaultsBaseAdvCheckSmtpchk string = "smtpchk"

	// DefaultsBaseAdvCheckSslDashHelloDashChk captures enum value "ssl-hello-chk"
	DefaultsBaseAdvCheckSslDashHelloDashChk string = "ssl-hello-chk"

	// DefaultsBaseAdvCheckTCPDashCheck captures enum value "tcp-check"
	DefaultsBaseAdvCheckTCPDashCheck string = "tcp-check"
)

// prop value enum
func (m *DefaultsBase) validateAdvCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAdvCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAdvCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.AdvCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateAdvCheckEnum("adv_check", "body", m.AdvCheck); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeAllbackupsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeAllbackupsPropEnum = append(defaultsBaseTypeAllbackupsPropEnum, v)
	}
}

const (

	// DefaultsBaseAllbackupsEnabled captures enum value "enabled"
	DefaultsBaseAllbackupsEnabled string = "enabled"

	// DefaultsBaseAllbackupsDisabled captures enum value "disabled"
	DefaultsBaseAllbackupsDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateAllbackupsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeAllbackupsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateAllbackups(formats strfmt.Registry) error {
	if swag.IsZero(m.Allbackups) { // not required
		return nil
	}

	// value enum
	if err := m.validateAllbackupsEnum("allbackups", "body", m.Allbackups); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateBalance(formats strfmt.Registry) error {
	if swag.IsZero(m.Balance) { // not required
		return nil
	}

	if m.Balance != nil {
		if err := m.Balance.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("balance")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("balance")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeCheckcachePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeCheckcachePropEnum = append(defaultsBaseTypeCheckcachePropEnum, v)
	}
}

const (

	// DefaultsBaseCheckcacheEnabled captures enum value "enabled"
	DefaultsBaseCheckcacheEnabled string = "enabled"

	// DefaultsBaseCheckcacheDisabled captures enum value "disabled"
	DefaultsBaseCheckcacheDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateCheckcacheEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeCheckcachePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateCheckcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Checkcache) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckcacheEnum("checkcache", "body", m.Checkcache); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateClientFinTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientFinTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("client_fin_timeout", "body", *m.ClientFinTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateClientTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("client_timeout", "body", *m.ClientTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeClitcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeClitcpkaPropEnum = append(defaultsBaseTypeClitcpkaPropEnum, v)
	}
}

const (

	// DefaultsBaseClitcpkaEnabled captures enum value "enabled"
	DefaultsBaseClitcpkaEnabled string = "enabled"

	// DefaultsBaseClitcpkaDisabled captures enum value "disabled"
	DefaultsBaseClitcpkaDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateClitcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeClitcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateClitcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Clitcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateClitcpkaEnum("clitcpka", "body", m.Clitcpka); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateCompression(formats strfmt.Registry) error {
	if swag.IsZero(m.Compression) { // not required
		return nil
	}

	if m.Compression != nil {
		if err := m.Compression.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateConnectTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("connect_timeout", "body", *m.ConnectTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeContstatsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeContstatsPropEnum = append(defaultsBaseTypeContstatsPropEnum, v)
	}
}

const (

	// DefaultsBaseContstatsEnabled captures enum value "enabled"
	DefaultsBaseContstatsEnabled string = "enabled"
)

// prop value enum
func (m *DefaultsBase) validateContstatsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeContstatsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateContstats(formats strfmt.Registry) error {
	if swag.IsZero(m.Contstats) { // not required
		return nil
	}

	// value enum
	if err := m.validateContstatsEnum("contstats", "body", m.Contstats); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateCookie(formats strfmt.Registry) error {
	if swag.IsZero(m.Cookie) { // not required
		return nil
	}

	if m.Cookie != nil {
		if err := m.Cookie.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookie")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookie")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateDefaultBackend(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultBackend) { // not required
		return nil
	}

	if err := validate.Pattern("default_backend", "body", m.DefaultBackend, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateDefaultServer(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultServer) { // not required
		return nil
	}

	if m.DefaultServer != nil {
		if err := m.DefaultServer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_server")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_server")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeDisableH2UpgradePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeDisableH2UpgradePropEnum = append(defaultsBaseTypeDisableH2UpgradePropEnum, v)
	}
}

const (

	// DefaultsBaseDisableH2UpgradeEnabled captures enum value "enabled"
	DefaultsBaseDisableH2UpgradeEnabled string = "enabled"

	// DefaultsBaseDisableH2UpgradeDisabled captures enum value "disabled"
	DefaultsBaseDisableH2UpgradeDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateDisableH2UpgradeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeDisableH2UpgradePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateDisableH2Upgrade(formats strfmt.Registry) error {
	if swag.IsZero(m.DisableH2Upgrade) { // not required
		return nil
	}

	// value enum
	if err := m.validateDisableH2UpgradeEnum("disable_h2_upgrade", "body", m.DisableH2Upgrade); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeDontlogNormalPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeDontlogNormalPropEnum = append(defaultsBaseTypeDontlogNormalPropEnum, v)
	}
}

const (

	// DefaultsBaseDontlogNormalEnabled captures enum value "enabled"
	DefaultsBaseDontlogNormalEnabled string = "enabled"

	// DefaultsBaseDontlogNormalDisabled captures enum value "disabled"
	DefaultsBaseDontlogNormalDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateDontlogNormalEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeDontlogNormalPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateDontlogNormal(formats strfmt.Registry) error {
	if swag.IsZero(m.DontlogNormal) { // not required
		return nil
	}

	// value enum
	if err := m.validateDontlogNormalEnum("dontlog_normal", "body", m.DontlogNormal); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeDontlognullPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeDontlognullPropEnum = append(defaultsBaseTypeDontlognullPropEnum, v)
	}
}

const (

	// DefaultsBaseDontlognullEnabled captures enum value "enabled"
	DefaultsBaseDontlognullEnabled string = "enabled"

	// DefaultsBaseDontlognullDisabled captures enum value "disabled"
	DefaultsBaseDontlognullDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateDontlognullEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeDontlognullPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateDontlognull(formats strfmt.Registry) error {
	if swag.IsZero(m.Dontlognull) { // not required
		return nil
	}

	// value enum
	if err := m.validateDontlognullEnum("dontlognull", "body", m.Dontlognull); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateDynamicCookieKey(formats strfmt.Registry) error {
	if swag.IsZero(m.DynamicCookieKey) { // not required
		return nil
	}

	if err := validate.Pattern("dynamic_cookie_key", "body", m.DynamicCookieKey, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateEmailAlert(formats strfmt.Registry) error {
	if swag.IsZero(m.EmailAlert) { // not required
		return nil
	}

	if m.EmailAlert != nil {
		if err := m.EmailAlert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateErrorloc302(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc302) { // not required
		return nil
	}

	if m.Errorloc302 != nil {
		if err := m.Errorloc302.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateErrorloc303(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc303) { // not required
		return nil
	}

	if m.Errorloc303 != nil {
		if err := m.Errorloc303.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeExternalCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeExternalCheckPropEnum = append(defaultsBaseTypeExternalCheckPropEnum, v)
	}
}

const (

	// DefaultsBaseExternalCheckEnabled captures enum value "enabled"
	DefaultsBaseExternalCheckEnabled string = "enabled"

	// DefaultsBaseExternalCheckDisabled captures enum value "disabled"
	DefaultsBaseExternalCheckDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateExternalCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeExternalCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateExternalCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateExternalCheckEnum("external_check", "body", m.ExternalCheck); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateExternalCheckCommand(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheckCommand) { // not required
		return nil
	}

	if err := validate.Pattern("external_check_command", "body", m.ExternalCheckCommand, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateExternalCheckPath(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheckPath) { // not required
		return nil
	}

	if err := validate.Pattern("external_check_path", "body", m.ExternalCheckPath, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateForwardfor(formats strfmt.Registry) error {
	if swag.IsZero(m.Forwardfor) { // not required
		return nil
	}

	if m.Forwardfor != nil {
		if err := m.Forwardfor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.From) { // not required
		return nil
	}

	if err := validate.Pattern("from", "body", m.From, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeH1CaseAdjustBogusClientPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeH1CaseAdjustBogusClientPropEnum = append(defaultsBaseTypeH1CaseAdjustBogusClientPropEnum, v)
	}
}

const (

	// DefaultsBaseH1CaseAdjustBogusClientEnabled captures enum value "enabled"
	DefaultsBaseH1CaseAdjustBogusClientEnabled string = "enabled"

	// DefaultsBaseH1CaseAdjustBogusClientDisabled captures enum value "disabled"
	DefaultsBaseH1CaseAdjustBogusClientDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateH1CaseAdjustBogusClientEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeH1CaseAdjustBogusClientPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateH1CaseAdjustBogusClient(formats strfmt.Registry) error {
	if swag.IsZero(m.H1CaseAdjustBogusClient) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1CaseAdjustBogusClientEnum("h1_case_adjust_bogus_client", "body", m.H1CaseAdjustBogusClient); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeH1CaseAdjustBogusServerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeH1CaseAdjustBogusServerPropEnum = append(defaultsBaseTypeH1CaseAdjustBogusServerPropEnum, v)
	}
}

const (

	// DefaultsBaseH1CaseAdjustBogusServerEnabled captures enum value "enabled"
	DefaultsBaseH1CaseAdjustBogusServerEnabled string = "enabled"

	// DefaultsBaseH1CaseAdjustBogusServerDisabled captures enum value "disabled"
	DefaultsBaseH1CaseAdjustBogusServerDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateH1CaseAdjustBogusServerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeH1CaseAdjustBogusServerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateH1CaseAdjustBogusServer(formats strfmt.Registry) error {
	if swag.IsZero(m.H1CaseAdjustBogusServer) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1CaseAdjustBogusServerEnum("h1_case_adjust_bogus_server", "body", m.H1CaseAdjustBogusServer); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateHashType(formats strfmt.Registry) error {
	if swag.IsZero(m.HashType) { // not required
		return nil
	}

	if m.HashType != nil {
		if err := m.HashType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hash_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hash_type")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeHTTPBufferRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPBufferRequestPropEnum = append(defaultsBaseTypeHTTPBufferRequestPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPBufferRequestEnabled captures enum value "enabled"
	DefaultsBaseHTTPBufferRequestEnabled string = "enabled"

	// DefaultsBaseHTTPBufferRequestDisabled captures enum value "disabled"
	DefaultsBaseHTTPBufferRequestDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPBufferRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPBufferRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPBufferRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPBufferRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPBufferRequestEnum("http-buffer-request", "body", m.HTTPBufferRequest); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPUseHtxPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPUseHtxPropEnum = append(defaultsBaseTypeHTTPUseHtxPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPUseHtxEnabled captures enum value "enabled"
	DefaultsBaseHTTPUseHtxEnabled string = "enabled"

	// DefaultsBaseHTTPUseHtxDisabled captures enum value "disabled"
	DefaultsBaseHTTPUseHtxDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPUseHtxEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPUseHtxPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPUseHtx(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPUseHtx) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPUseHtxEnum("http-use-htx", "body", m.HTTPUseHtx); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPConnectionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["httpclose","http-server-close","http-keep-alive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPConnectionModePropEnum = append(defaultsBaseTypeHTTPConnectionModePropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPConnectionModeHttpclose captures enum value "httpclose"
	DefaultsBaseHTTPConnectionModeHttpclose string = "httpclose"

	// DefaultsBaseHTTPConnectionModeHTTPDashServerDashClose captures enum value "http-server-close"
	DefaultsBaseHTTPConnectionModeHTTPDashServerDashClose string = "http-server-close"

	// DefaultsBaseHTTPConnectionModeHTTPDashKeepDashAlive captures enum value "http-keep-alive"
	DefaultsBaseHTTPConnectionModeHTTPDashKeepDashAlive string = "http-keep-alive"
)

// prop value enum
func (m *DefaultsBase) validateHTTPConnectionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPConnectionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPConnectionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConnectionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPConnectionModeEnum("http_connection_mode", "body", m.HTTPConnectionMode); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPIgnoreProbesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPIgnoreProbesPropEnum = append(defaultsBaseTypeHTTPIgnoreProbesPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPIgnoreProbesEnabled captures enum value "enabled"
	DefaultsBaseHTTPIgnoreProbesEnabled string = "enabled"

	// DefaultsBaseHTTPIgnoreProbesDisabled captures enum value "disabled"
	DefaultsBaseHTTPIgnoreProbesDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPIgnoreProbesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPIgnoreProbesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPIgnoreProbes(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPIgnoreProbes) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPIgnoreProbesEnum("http_ignore_probes", "body", m.HTTPIgnoreProbes); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateHTTPKeepAliveTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPKeepAliveTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_keep_alive_timeout", "body", *m.HTTPKeepAliveTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPNoDelayPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPNoDelayPropEnum = append(defaultsBaseTypeHTTPNoDelayPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPNoDelayEnabled captures enum value "enabled"
	DefaultsBaseHTTPNoDelayEnabled string = "enabled"

	// DefaultsBaseHTTPNoDelayDisabled captures enum value "disabled"
	DefaultsBaseHTTPNoDelayDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPNoDelayEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPNoDelayPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPNoDelay(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPNoDelay) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPNoDelayEnum("http_no_delay", "body", m.HTTPNoDelay); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPPretendKeepalivePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPPretendKeepalivePropEnum = append(defaultsBaseTypeHTTPPretendKeepalivePropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPPretendKeepaliveEnabled captures enum value "enabled"
	DefaultsBaseHTTPPretendKeepaliveEnabled string = "enabled"

	// DefaultsBaseHTTPPretendKeepaliveDisabled captures enum value "disabled"
	DefaultsBaseHTTPPretendKeepaliveDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPPretendKeepaliveEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPPretendKeepalivePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPPretendKeepalive(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPPretendKeepalive) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPPretendKeepaliveEnum("http_pretend_keepalive", "body", m.HTTPPretendKeepalive); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateHTTPRequestTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRequestTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_request_timeout", "body", *m.HTTPRequestTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPRestrictReqHdrNamesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preserve","delete","reject"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPRestrictReqHdrNamesPropEnum = append(defaultsBaseTypeHTTPRestrictReqHdrNamesPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPRestrictReqHdrNamesPreserve captures enum value "preserve"
	DefaultsBaseHTTPRestrictReqHdrNamesPreserve string = "preserve"

	// DefaultsBaseHTTPRestrictReqHdrNamesDelete captures enum value "delete"
	DefaultsBaseHTTPRestrictReqHdrNamesDelete string = "delete"

	// DefaultsBaseHTTPRestrictReqHdrNamesReject captures enum value "reject"
	DefaultsBaseHTTPRestrictReqHdrNamesReject string = "reject"
)

// prop value enum
func (m *DefaultsBase) validateHTTPRestrictReqHdrNamesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPRestrictReqHdrNamesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPRestrictReqHdrNames(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRestrictReqHdrNames) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPRestrictReqHdrNamesEnum("http_restrict_req_hdr_names", "body", m.HTTPRestrictReqHdrNames); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPReusePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aggressive","always","never","safe"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPReusePropEnum = append(defaultsBaseTypeHTTPReusePropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPReuseAggressive captures enum value "aggressive"
	DefaultsBaseHTTPReuseAggressive string = "aggressive"

	// DefaultsBaseHTTPReuseAlways captures enum value "always"
	DefaultsBaseHTTPReuseAlways string = "always"

	// DefaultsBaseHTTPReuseNever captures enum value "never"
	DefaultsBaseHTTPReuseNever string = "never"

	// DefaultsBaseHTTPReuseSafe captures enum value "safe"
	DefaultsBaseHTTPReuseSafe string = "safe"
)

// prop value enum
func (m *DefaultsBase) validateHTTPReuseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPReusePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPReuse(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPReuse) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPReuseEnum("http_reuse", "body", m.HTTPReuse); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeHTTPUseProxyHeaderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHTTPUseProxyHeaderPropEnum = append(defaultsBaseTypeHTTPUseProxyHeaderPropEnum, v)
	}
}

const (

	// DefaultsBaseHTTPUseProxyHeaderEnabled captures enum value "enabled"
	DefaultsBaseHTTPUseProxyHeaderEnabled string = "enabled"

	// DefaultsBaseHTTPUseProxyHeaderDisabled captures enum value "disabled"
	DefaultsBaseHTTPUseProxyHeaderDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHTTPUseProxyHeaderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHTTPUseProxyHeaderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHTTPUseProxyHeader(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPUseProxyHeader) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPUseProxyHeaderEnum("http_use_proxy_header", "body", m.HTTPUseProxyHeader); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateHttpchkParams(formats strfmt.Registry) error {
	if swag.IsZero(m.HttpchkParams) { // not required
		return nil
	}

	if m.HttpchkParams != nil {
		if err := m.HttpchkParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("httpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("httpchk_params")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeHttpslogPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeHttpslogPropEnum = append(defaultsBaseTypeHttpslogPropEnum, v)
	}
}

const (

	// DefaultsBaseHttpslogEnabled captures enum value "enabled"
	DefaultsBaseHttpslogEnabled string = "enabled"

	// DefaultsBaseHttpslogDisabled captures enum value "disabled"
	DefaultsBaseHttpslogDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateHttpslogEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeHttpslogPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateHttpslog(formats strfmt.Registry) error {
	if swag.IsZero(m.Httpslog) { // not required
		return nil
	}

	// value enum
	if err := m.validateHttpslogEnum("httpslog", "body", m.Httpslog); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeIdleCloseOnResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeIdleCloseOnResponsePropEnum = append(defaultsBaseTypeIdleCloseOnResponsePropEnum, v)
	}
}

const (

	// DefaultsBaseIdleCloseOnResponseEnabled captures enum value "enabled"
	DefaultsBaseIdleCloseOnResponseEnabled string = "enabled"

	// DefaultsBaseIdleCloseOnResponseDisabled captures enum value "disabled"
	DefaultsBaseIdleCloseOnResponseDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateIdleCloseOnResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeIdleCloseOnResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateIdleCloseOnResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.IdleCloseOnResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateIdleCloseOnResponseEnum("idle_close_on_response", "body", m.IdleCloseOnResponse); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeIndependentStreamsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeIndependentStreamsPropEnum = append(defaultsBaseTypeIndependentStreamsPropEnum, v)
	}
}

const (

	// DefaultsBaseIndependentStreamsEnabled captures enum value "enabled"
	DefaultsBaseIndependentStreamsEnabled string = "enabled"

	// DefaultsBaseIndependentStreamsDisabled captures enum value "disabled"
	DefaultsBaseIndependentStreamsDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateIndependentStreamsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeIndependentStreamsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateIndependentStreams(formats strfmt.Registry) error {
	if swag.IsZero(m.IndependentStreams) { // not required
		return nil
	}

	// value enum
	if err := m.validateIndependentStreamsEnum("independent_streams", "body", m.IndependentStreams); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeLoadServerStateFromFilePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["global","local","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeLoadServerStateFromFilePropEnum = append(defaultsBaseTypeLoadServerStateFromFilePropEnum, v)
	}
}

const (

	// DefaultsBaseLoadServerStateFromFileGlobal captures enum value "global"
	DefaultsBaseLoadServerStateFromFileGlobal string = "global"

	// DefaultsBaseLoadServerStateFromFileLocal captures enum value "local"
	DefaultsBaseLoadServerStateFromFileLocal string = "local"

	// DefaultsBaseLoadServerStateFromFileNone captures enum value "none"
	DefaultsBaseLoadServerStateFromFileNone string = "none"
)

// prop value enum
func (m *DefaultsBase) validateLoadServerStateFromFileEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeLoadServerStateFromFilePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateLoadServerStateFromFile(formats strfmt.Registry) error {
	if swag.IsZero(m.LoadServerStateFromFile) { // not required
		return nil
	}

	// value enum
	if err := m.validateLoadServerStateFromFileEnum("load_server_state_from_file", "body", m.LoadServerStateFromFile); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeLogHealthChecksPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeLogHealthChecksPropEnum = append(defaultsBaseTypeLogHealthChecksPropEnum, v)
	}
}

const (

	// DefaultsBaseLogHealthChecksEnabled captures enum value "enabled"
	DefaultsBaseLogHealthChecksEnabled string = "enabled"

	// DefaultsBaseLogHealthChecksDisabled captures enum value "disabled"
	DefaultsBaseLogHealthChecksDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateLogHealthChecksEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeLogHealthChecksPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateLogHealthChecks(formats strfmt.Registry) error {
	if swag.IsZero(m.LogHealthChecks) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogHealthChecksEnum("log_health_checks", "body", m.LogHealthChecks); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeLogSeparateErrorsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeLogSeparateErrorsPropEnum = append(defaultsBaseTypeLogSeparateErrorsPropEnum, v)
	}
}

const (

	// DefaultsBaseLogSeparateErrorsEnabled captures enum value "enabled"
	DefaultsBaseLogSeparateErrorsEnabled string = "enabled"

	// DefaultsBaseLogSeparateErrorsDisabled captures enum value "disabled"
	DefaultsBaseLogSeparateErrorsDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateLogSeparateErrorsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeLogSeparateErrorsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateLogSeparateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.LogSeparateErrors) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogSeparateErrorsEnum("log_separate_errors", "body", m.LogSeparateErrors); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateLogTag(formats strfmt.Registry) error {
	if swag.IsZero(m.LogTag) { // not required
		return nil
	}

	if err := validate.Pattern("log_tag", "body", m.LogTag, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeLogasapPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeLogasapPropEnum = append(defaultsBaseTypeLogasapPropEnum, v)
	}
}

const (

	// DefaultsBaseLogasapEnabled captures enum value "enabled"
	DefaultsBaseLogasapEnabled string = "enabled"

	// DefaultsBaseLogasapDisabled captures enum value "disabled"
	DefaultsBaseLogasapDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateLogasapEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeLogasapPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateLogasap(formats strfmt.Registry) error {
	if swag.IsZero(m.Logasap) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogasapEnum("logasap", "body", m.Logasap); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tcp","http","log"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeModePropEnum = append(defaultsBaseTypeModePropEnum, v)
	}
}

const (

	// DefaultsBaseModeTCP captures enum value "tcp"
	DefaultsBaseModeTCP string = "tcp"

	// DefaultsBaseModeHTTP captures enum value "http"
	DefaultsBaseModeHTTP string = "http"

	// DefaultsBaseModeLog captures enum value "log"
	DefaultsBaseModeLog string = "log"
)

// prop value enum
func (m *DefaultsBase) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateMonitorURI(formats strfmt.Registry) error {
	if swag.IsZero(m.MonitorURI) { // not required
		return nil
	}

	if err := m.MonitorURI.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("monitor_uri")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("monitor_uri")
		}
		return err
	}

	return nil
}

func (m *DefaultsBase) validateMysqlCheckParams(formats strfmt.Registry) error {
	if swag.IsZero(m.MysqlCheckParams) { // not required
		return nil
	}

	if m.MysqlCheckParams != nil {
		if err := m.MysqlCheckParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mysql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mysql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeNolingerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeNolingerPropEnum = append(defaultsBaseTypeNolingerPropEnum, v)
	}
}

const (

	// DefaultsBaseNolingerEnabled captures enum value "enabled"
	DefaultsBaseNolingerEnabled string = "enabled"

	// DefaultsBaseNolingerDisabled captures enum value "disabled"
	DefaultsBaseNolingerDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateNolingerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeNolingerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateNolinger(formats strfmt.Registry) error {
	if swag.IsZero(m.Nolinger) { // not required
		return nil
	}

	// value enum
	if err := m.validateNolingerEnum("nolinger", "body", m.Nolinger); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateOriginalto(formats strfmt.Registry) error {
	if swag.IsZero(m.Originalto) { // not required
		return nil
	}

	if m.Originalto != nil {
		if err := m.Originalto.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypePersistPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypePersistPropEnum = append(defaultsBaseTypePersistPropEnum, v)
	}
}

const (

	// DefaultsBasePersistEnabled captures enum value "enabled"
	DefaultsBasePersistEnabled string = "enabled"

	// DefaultsBasePersistDisabled captures enum value "disabled"
	DefaultsBasePersistDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validatePersistEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypePersistPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validatePersist(formats strfmt.Registry) error {
	if swag.IsZero(m.Persist) { // not required
		return nil
	}

	// value enum
	if err := m.validatePersistEnum("persist", "body", m.Persist); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validatePersistRule(formats strfmt.Registry) error {
	if swag.IsZero(m.PersistRule) { // not required
		return nil
	}

	if m.PersistRule != nil {
		if err := m.PersistRule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("persist_rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("persist_rule")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validatePgsqlCheckParams(formats strfmt.Registry) error {
	if swag.IsZero(m.PgsqlCheckParams) { // not required
		return nil
	}

	if m.PgsqlCheckParams != nil {
		if err := m.PgsqlCheckParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pgsql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pgsql_check_params")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypePreferLastServerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypePreferLastServerPropEnum = append(defaultsBaseTypePreferLastServerPropEnum, v)
	}
}

const (

	// DefaultsBasePreferLastServerEnabled captures enum value "enabled"
	DefaultsBasePreferLastServerEnabled string = "enabled"

	// DefaultsBasePreferLastServerDisabled captures enum value "disabled"
	DefaultsBasePreferLastServerDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validatePreferLastServerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypePreferLastServerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validatePreferLastServer(formats strfmt.Registry) error {
	if swag.IsZero(m.PreferLastServer) { // not required
		return nil
	}

	// value enum
	if err := m.validatePreferLastServerEnum("prefer_last_server", "body", m.PreferLastServer); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateQueueTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.QueueTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("queue_timeout", "body", *m.QueueTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateRedispatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Redispatch) { // not required
		return nil
	}

	if m.Redispatch != nil {
		if err := m.Redispatch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redispatch")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("redispatch")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateServerFinTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerFinTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("server_fin_timeout", "body", *m.ServerFinTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateServerTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("server_timeout", "body", *m.ServerTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateSmtpchkParams(formats strfmt.Registry) error {
	if swag.IsZero(m.SmtpchkParams) { // not required
		return nil
	}

	if m.SmtpchkParams != nil {
		if err := m.SmtpchkParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smtpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("smtpchk_params")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeSocketStatsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeSocketStatsPropEnum = append(defaultsBaseTypeSocketStatsPropEnum, v)
	}
}

const (

	// DefaultsBaseSocketStatsEnabled captures enum value "enabled"
	DefaultsBaseSocketStatsEnabled string = "enabled"

	// DefaultsBaseSocketStatsDisabled captures enum value "disabled"
	DefaultsBaseSocketStatsDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateSocketStatsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeSocketStatsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateSocketStats(formats strfmt.Registry) error {
	if swag.IsZero(m.SocketStats) { // not required
		return nil
	}

	// value enum
	if err := m.validateSocketStatsEnum("socket_stats", "body", m.SocketStats); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

var defaultsBaseTypeSpliceAutoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeSpliceAutoPropEnum = append(defaultsBaseTypeSpliceAutoPropEnum, v)
	}
}

const (

	// DefaultsBaseSpliceAutoEnabled captures enum value "enabled"
	DefaultsBaseSpliceAutoEnabled string = "enabled"

	// DefaultsBaseSpliceAutoDisabled captures enum value "disabled"
	DefaultsBaseSpliceAutoDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateSpliceAutoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeSpliceAutoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateSpliceAuto(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceAuto) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceAutoEnum("splice_auto", "body", m.SpliceAuto); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeSpliceRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeSpliceRequestPropEnum = append(defaultsBaseTypeSpliceRequestPropEnum, v)
	}
}

const (

	// DefaultsBaseSpliceRequestEnabled captures enum value "enabled"
	DefaultsBaseSpliceRequestEnabled string = "enabled"

	// DefaultsBaseSpliceRequestDisabled captures enum value "disabled"
	DefaultsBaseSpliceRequestDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateSpliceRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeSpliceRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateSpliceRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceRequestEnum("splice_request", "body", m.SpliceRequest); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeSpliceResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeSpliceResponsePropEnum = append(defaultsBaseTypeSpliceResponsePropEnum, v)
	}
}

const (

	// DefaultsBaseSpliceResponseEnabled captures enum value "enabled"
	DefaultsBaseSpliceResponseEnabled string = "enabled"

	// DefaultsBaseSpliceResponseDisabled captures enum value "disabled"
	DefaultsBaseSpliceResponseDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateSpliceResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeSpliceResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateSpliceResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceResponseEnum("splice_response", "body", m.SpliceResponse); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeSrvtcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeSrvtcpkaPropEnum = append(defaultsBaseTypeSrvtcpkaPropEnum, v)
	}
}

const (

	// DefaultsBaseSrvtcpkaEnabled captures enum value "enabled"
	DefaultsBaseSrvtcpkaEnabled string = "enabled"

	// DefaultsBaseSrvtcpkaDisabled captures enum value "disabled"
	DefaultsBaseSrvtcpkaDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateSrvtcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeSrvtcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateSrvtcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Srvtcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateSrvtcpkaEnum("srvtcpka", "body", m.Srvtcpka); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateStatsOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.StatsOptions) { // not required
		return nil
	}

	if m.StatsOptions != nil {
		if err := m.StatsOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) validateTarpitTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TarpitTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("tarpit_timeout", "body", *m.TarpitTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeTCPSmartAcceptPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeTCPSmartAcceptPropEnum = append(defaultsBaseTypeTCPSmartAcceptPropEnum, v)
	}
}

const (

	// DefaultsBaseTCPSmartAcceptEnabled captures enum value "enabled"
	DefaultsBaseTCPSmartAcceptEnabled string = "enabled"

	// DefaultsBaseTCPSmartAcceptDisabled captures enum value "disabled"
	DefaultsBaseTCPSmartAcceptDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateTCPSmartAcceptEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeTCPSmartAcceptPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateTCPSmartAccept(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPSmartAccept) { // not required
		return nil
	}

	// value enum
	if err := m.validateTCPSmartAcceptEnum("tcp_smart_accept", "body", m.TCPSmartAccept); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeTCPSmartConnectPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeTCPSmartConnectPropEnum = append(defaultsBaseTypeTCPSmartConnectPropEnum, v)
	}
}

const (

	// DefaultsBaseTCPSmartConnectEnabled captures enum value "enabled"
	DefaultsBaseTCPSmartConnectEnabled string = "enabled"

	// DefaultsBaseTCPSmartConnectDisabled captures enum value "disabled"
	DefaultsBaseTCPSmartConnectDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateTCPSmartConnectEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeTCPSmartConnectPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateTCPSmartConnect(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPSmartConnect) { // not required
		return nil
	}

	// value enum
	if err := m.validateTCPSmartConnectEnum("tcp_smart_connect", "body", m.TCPSmartConnect); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeTcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeTcpkaPropEnum = append(defaultsBaseTypeTcpkaPropEnum, v)
	}
}

const (

	// DefaultsBaseTcpkaEnabled captures enum value "enabled"
	DefaultsBaseTcpkaEnabled string = "enabled"

	// DefaultsBaseTcpkaDisabled captures enum value "disabled"
	DefaultsBaseTcpkaDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateTcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeTcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateTcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Tcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateTcpkaEnum("tcpka", "body", m.Tcpka); err != nil {
		return err
	}

	return nil
}

var defaultsBaseTypeTransparentPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		defaultsBaseTypeTransparentPropEnum = append(defaultsBaseTypeTransparentPropEnum, v)
	}
}

const (

	// DefaultsBaseTransparentEnabled captures enum value "enabled"
	DefaultsBaseTransparentEnabled string = "enabled"

	// DefaultsBaseTransparentDisabled captures enum value "disabled"
	DefaultsBaseTransparentDisabled string = "disabled"
)

// prop value enum
func (m *DefaultsBase) validateTransparentEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, defaultsBaseTypeTransparentPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DefaultsBase) validateTransparent(formats strfmt.Registry) error {
	if swag.IsZero(m.Transparent) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransparentEnum("transparent", "body", m.Transparent); err != nil {
		return err
	}

	return nil
}

func (m *DefaultsBase) validateTunnelTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TunnelTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("tunnel_timeout", "body", *m.TunnelTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this defaults base based on the context it is used
func (m *DefaultsBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrorFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorFilesFromHTTPErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBalance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompression(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCookie(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDefaultServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmailAlert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc302(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc303(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateForwardfor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHashType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHttpchkParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMonitorURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMysqlCheckParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOriginalto(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePersistRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePgsqlCheckParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedispatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSmtpchkParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatsOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DefaultsBase) contextValidateErrorFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFiles); i++ {

		if m.ErrorFiles[i] != nil {

			if swag.IsZero(m.ErrorFiles[i]) { // not required
				return nil
			}

			if err := m.ErrorFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DefaultsBase) contextValidateErrorFilesFromHTTPErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {

		if m.ErrorFilesFromHTTPErrors[i] != nil {

			if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
				return nil
			}

			if err := m.ErrorFilesFromHTTPErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DefaultsBase) contextValidateBalance(ctx context.Context, formats strfmt.Registry) error {

	if m.Balance != nil {

		if swag.IsZero(m.Balance) { // not required
			return nil
		}

		if err := m.Balance.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("balance")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("balance")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateCompression(ctx context.Context, formats strfmt.Registry) error {

	if m.Compression != nil {

		if swag.IsZero(m.Compression) { // not required
			return nil
		}

		if err := m.Compression.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateCookie(ctx context.Context, formats strfmt.Registry) error {

	if m.Cookie != nil {

		if swag.IsZero(m.Cookie) { // not required
			return nil
		}

		if err := m.Cookie.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookie")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookie")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateDefaultServer(ctx context.Context, formats strfmt.Registry) error {

	if m.DefaultServer != nil {

		if swag.IsZero(m.DefaultServer) { // not required
			return nil
		}

		if err := m.DefaultServer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_server")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_server")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateEmailAlert(ctx context.Context, formats strfmt.Registry) error {

	if m.EmailAlert != nil {

		if swag.IsZero(m.EmailAlert) { // not required
			return nil
		}

		if err := m.EmailAlert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateErrorloc302(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc302 != nil {

		if swag.IsZero(m.Errorloc302) { // not required
			return nil
		}

		if err := m.Errorloc302.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateErrorloc303(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc303 != nil {

		if swag.IsZero(m.Errorloc303) { // not required
			return nil
		}

		if err := m.Errorloc303.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateForwardfor(ctx context.Context, formats strfmt.Registry) error {

	if m.Forwardfor != nil {

		if swag.IsZero(m.Forwardfor) { // not required
			return nil
		}

		if err := m.Forwardfor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateHashType(ctx context.Context, formats strfmt.Registry) error {

	if m.HashType != nil {

		if swag.IsZero(m.HashType) { // not required
			return nil
		}

		if err := m.HashType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hash_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hash_type")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateHttpchkParams(ctx context.Context, formats strfmt.Registry) error {

	if m.HttpchkParams != nil {

		if swag.IsZero(m.HttpchkParams) { // not required
			return nil
		}

		if err := m.HttpchkParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("httpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("httpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateMonitorURI(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.MonitorURI) { // not required
		return nil
	}

	if err := m.MonitorURI.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("monitor_uri")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("monitor_uri")
		}
		return err
	}

	return nil
}

func (m *DefaultsBase) contextValidateMysqlCheckParams(ctx context.Context, formats strfmt.Registry) error {

	if m.MysqlCheckParams != nil {

		if swag.IsZero(m.MysqlCheckParams) { // not required
			return nil
		}

		if err := m.MysqlCheckParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mysql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mysql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateOriginalto(ctx context.Context, formats strfmt.Registry) error {

	if m.Originalto != nil {

		if swag.IsZero(m.Originalto) { // not required
			return nil
		}

		if err := m.Originalto.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidatePersistRule(ctx context.Context, formats strfmt.Registry) error {

	if m.PersistRule != nil {

		if swag.IsZero(m.PersistRule) { // not required
			return nil
		}

		if err := m.PersistRule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("persist_rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("persist_rule")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidatePgsqlCheckParams(ctx context.Context, formats strfmt.Registry) error {

	if m.PgsqlCheckParams != nil {

		if swag.IsZero(m.PgsqlCheckParams) { // not required
			return nil
		}

		if err := m.PgsqlCheckParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pgsql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pgsql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateRedispatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Redispatch != nil {

		if swag.IsZero(m.Redispatch) { // not required
			return nil
		}

		if err := m.Redispatch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redispatch")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("redispatch")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateSmtpchkParams(ctx context.Context, formats strfmt.Registry) error {

	if m.SmtpchkParams != nil {

		if swag.IsZero(m.SmtpchkParams) { // not required
			return nil
		}

		if err := m.SmtpchkParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smtpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("smtpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {

		if swag.IsZero(m.Source) { // not required
			return nil
		}

		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *DefaultsBase) contextValidateStatsOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.StatsOptions != nil {

		if swag.IsZero(m.StatsOptions) { // not required
			return nil
		}

		if err := m.StatsOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DefaultsBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DefaultsBase) UnmarshalBinary(b []byte) error {
	var res DefaultsBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
