// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CrtStore Certificate Store
//
// # Storage mechanism to load and store certificates used in the configuration
//
// swagger:model crt_store
type CrtStore struct {

	// Default directory to fetch SSL certificates from
	CrtBase string `json:"crt_base,omitempty"`

	// Default directory to fetch SSL private keys from
	KeyBase string `json:"key_base,omitempty"`

	// loads
	Loads CrtLoads `json:"loads,omitempty"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_]+$`
	Name string `json:"name"`
}

// Validate validates this crt store
func (m *CrtStore) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLoads(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CrtStore) validateLoads(formats strfmt.Registry) error {
	if swag.IsZero(m.Loads) { // not required
		return nil
	}

	if err := m.Loads.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("loads")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("loads")
		}
		return err
	}

	return nil
}

func (m *CrtStore) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this crt store based on the context it is used
func (m *CrtStore) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLoads(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CrtStore) contextValidateLoads(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Loads.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("loads")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("loads")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CrtStore) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CrtStore) UnmarshalBinary(b []byte) error {
	var res CrtStore
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
