// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneQuicOptions tune quic options
//
// swagger:model tune_quic_options
type TuneQuicOptions struct {

	// frontend conn tx buffers limit
	FrontendConnTxBuffersLimit *int64 `json:"frontend_conn_tx_buffers_limit,omitempty"`

	// frontend max idle timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	FrontendMaxIdleTimeout *int64 `json:"frontend_max_idle_timeout,omitempty"`

	// frontend max streams bidi
	FrontendMaxStreamsBidi *int64 `json:"frontend_max_streams_bidi,omitempty"`

	// max frame loss
	MaxFrameLoss *int64 `json:"max_frame_loss,omitempty"`

	// reorder ratio
	// Maximum: 100
	// Minimum: 0
	// +kubebuilder:validation:Maximum=100
	// +kubebuilder:validation:Minimum=0
	ReorderRatio *int64 `json:"reorder_ratio,omitempty"`

	// retry threshold
	RetryThreshold *int64 `json:"retry_threshold,omitempty"`

	// socket owner
	// Enum: ["listener","connection"]
	// +kubebuilder:validation:Enum="listener","connection";
	SocketOwner string `json:"socket_owner,omitempty"`

	// zero copy fwd send
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ZeroCopyFwdSend string `json:"zero_copy_fwd_send,omitempty"`
}

// Validate validates this tune quic options
func (m *TuneQuicOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFrontendMaxIdleTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReorderRatio(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSocketOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateZeroCopyFwdSend(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TuneQuicOptions) validateFrontendMaxIdleTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.FrontendMaxIdleTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("frontend_max_idle_timeout", "body", *m.FrontendMaxIdleTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *TuneQuicOptions) validateReorderRatio(formats strfmt.Registry) error {
	if swag.IsZero(m.ReorderRatio) { // not required
		return nil
	}

	if err := validate.MinimumInt("reorder_ratio", "body", *m.ReorderRatio, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("reorder_ratio", "body", *m.ReorderRatio, 100, false); err != nil {
		return err
	}

	return nil
}

var tuneQuicOptionsTypeSocketOwnerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["listener","connection"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneQuicOptionsTypeSocketOwnerPropEnum = append(tuneQuicOptionsTypeSocketOwnerPropEnum, v)
	}
}

const (

	// TuneQuicOptionsSocketOwnerListener captures enum value "listener"
	TuneQuicOptionsSocketOwnerListener string = "listener"

	// TuneQuicOptionsSocketOwnerConnection captures enum value "connection"
	TuneQuicOptionsSocketOwnerConnection string = "connection"
)

// prop value enum
func (m *TuneQuicOptions) validateSocketOwnerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneQuicOptionsTypeSocketOwnerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneQuicOptions) validateSocketOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.SocketOwner) { // not required
		return nil
	}

	// value enum
	if err := m.validateSocketOwnerEnum("socket_owner", "body", m.SocketOwner); err != nil {
		return err
	}

	return nil
}

var tuneQuicOptionsTypeZeroCopyFwdSendPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneQuicOptionsTypeZeroCopyFwdSendPropEnum = append(tuneQuicOptionsTypeZeroCopyFwdSendPropEnum, v)
	}
}

const (

	// TuneQuicOptionsZeroCopyFwdSendEnabled captures enum value "enabled"
	TuneQuicOptionsZeroCopyFwdSendEnabled string = "enabled"

	// TuneQuicOptionsZeroCopyFwdSendDisabled captures enum value "disabled"
	TuneQuicOptionsZeroCopyFwdSendDisabled string = "disabled"
)

// prop value enum
func (m *TuneQuicOptions) validateZeroCopyFwdSendEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneQuicOptionsTypeZeroCopyFwdSendPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneQuicOptions) validateZeroCopyFwdSend(formats strfmt.Registry) error {
	if swag.IsZero(m.ZeroCopyFwdSend) { // not required
		return nil
	}

	// value enum
	if err := m.validateZeroCopyFwdSendEnum("zero_copy_fwd_send", "body", m.ZeroCopyFwdSend); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune quic options based on context it is used
func (m *TuneQuicOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneQuicOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneQuicOptions) UnmarshalBinary(b []byte) error {
	var res TuneQuicOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
