/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.IdentityImpl;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;

class PluginFragmentImpl
extends IdentityImpl
implements PluginFragment {
    private final PluginRegistry registry;
    private final URL location;
    private final ModelPluginFragment model;
    private Documentation doc;

    PluginFragmentImpl(PluginRegistry pluginRegistry, ModelPluginFragment modelPluginFragment, URL uRL) throws ManifestProcessingException {
        super(modelPluginFragment.getId());
        this.registry = pluginRegistry;
        this.model = modelPluginFragment;
        this.location = uRL;
        if (this.model.getVendor() == null) {
            this.model.setVendor("");
        }
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "fragmentPliginIdIsBlank", this.getId());
        }
        if (this.getId().equals(this.model.getPluginId())) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidFragmentPluginId", this.getId());
        }
        if (this.model.getDocsPath() == null || this.model.getDocsPath().trim().length() == 0) {
            this.model.setDocsPath("docs");
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl(this, this.model.getDocumentation());
        }
        this.log.debug("object instantiated: " + this);
    }

    ModelPluginFragment getModel() {
        return this.model;
    }

    public String getUniqueId() {
        return this.registry.makeUniqueId(this.getId(), this.model.getVersion());
    }

    public String getVendor() {
        return this.model.getVendor();
    }

    public Version getVersion() {
        return this.model.getVersion();
    }

    public String getPluginId() {
        return this.model.getPluginId();
    }

    public Version getPluginVersion() {
        return this.model.getPluginVersion();
    }

    public PluginRegistry getRegistry() {
        return this.registry;
    }

    public boolean matches(PluginDescriptor pluginDescriptor) {
        return PluginPrerequisiteImpl.matches(this.model.getPluginVersion(), pluginDescriptor.getVersion(), this.model.getMatch());
    }

    public Documentation getDocumentation() {
        return this.doc;
    }

    public String getDocsPath() {
        return this.model.getDocsPath();
    }

    public URL getLocation() {
        return this.location;
    }

    protected boolean isEqualTo(Identity identity) {
        if (!(identity instanceof PluginFragmentImpl)) {
            return false;
        }
        PluginFragmentImpl pluginFragmentImpl = (PluginFragmentImpl)identity;
        return this.getLocation().equals(pluginFragmentImpl.getLocation()) && this.getUniqueId().equals(pluginFragmentImpl.getUniqueId());
    }

    public String toString() {
        return "{PluginFragment: uid=" + this.getUniqueId() + "}";
    }
}

