/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.InputStream;
import org.onemind.commons.java.util.FileUtils;
import org.onemind.jxp.CachedJxpPage;
import org.onemind.jxp.CachingPageSource;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageParseException;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.parser.AstJxpDocument;
import org.onemind.jxp.parser.JxpParser;
import org.onemind.jxp.parser.ParseException;

public class ResourceStreamPageSource
extends CachingPageSource {
    private String _pathPrefix;

    public ResourceStreamPageSource(String pathPrefix) {
        this._pathPrefix = pathPrefix;
    }

    public final String getPathPrefix() {
        return this._pathPrefix;
    }

    protected final CachedJxpPage loadJxpPage(String pageName) {
        String streamName = this.getStreamName(pageName);
        InputStream stream = this.getClass().getResourceAsStream(streamName);
        if (streamName != null) {
            return new ResourceStreamJxpPage(this, pageName, stream);
        }
        return null;
    }

    public final String getStreamName(String pageName) {
        return FileUtils.concatFilePath(this.getPathPrefix(), pageName);
    }

    public final AstJxpDocument parseJxpDocument(JxpPage page) throws JxpPageParseException {
        ResourceStreamJxpPage streamPage = (ResourceStreamJxpPage)page;
        if (streamPage.getInputStream() != null) {
            try {
                JxpParser parser = new JxpParser(streamPage.getInputStream());
                AstJxpDocument astJxpDocument = parser.JxpDocument();
                return astJxpDocument;
            }
            catch (ParseException e) {
                String message = "Problem parsing page " + page.getName() + ": " + e.getMessage();
                throw new JxpPageParseException(message, e);
            }
            finally {
                streamPage.setInputStream(null);
            }
        }
        throw new IllegalStateException("Inputstream of page " + page.getName() + " not found");
    }

    public final boolean hasJxpPage(String id) {
        if (this.isJxpPageCached(id)) {
            return true;
        }
        String streamName = this.getStreamName(id);
        InputStream stream = this.getClass().getResourceAsStream(streamName);
        return stream != null;
    }

    public final void setPathPrefix(String pathPrefix) {
        this._pathPrefix = pathPrefix;
    }

    protected final class ResourceStreamJxpPage
    extends CachedJxpPage {
        private InputStream _stream;

        public ResourceStreamJxpPage(JxpPageSource source, String name, InputStream stream) {
            super(source, name);
            this._stream = stream;
        }

        public final InputStream getInputStream() {
            return this._stream;
        }

        public final void setInputStream(InputStream stream) {
            this._stream = stream;
        }
    }
}

