/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageNotFoundException;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.JxpPageSourceException;
import org.onemind.jxp.parser.AstJxpDocument;

public class MultiSourcePageSource
extends JxpPageSource {
    private List _sources = new ArrayList();

    public final void addPageSource(JxpPageSource source) {
        this._sources.add(source);
    }

    public final void removePageSource(JxpPageSource source) {
        this._sources.remove(source);
    }

    public final List getPageSources() {
        return Collections.unmodifiableList(this._sources);
    }

    public final JxpPage getJxpPage(String id) throws JxpPageNotFoundException {
        for (int i = 0; i < this._sources.size(); ++i) {
            JxpPageSource source = (JxpPageSource)this._sources.get(i);
            if (!source.hasJxpPage(id)) continue;
            return source.getJxpPage(id);
        }
        throw new JxpPageNotFoundException("Page " + id + " not found");
    }

    public final StringBuffer getErrorSource(JxpPage page, int line, int col) throws IOException {
        return page.getSource().getErrorSource(page, line, col);
    }

    public final AstJxpDocument getJxpDocument(JxpPage page) throws JxpPageSourceException {
        return page.getSource().getJxpDocument(page);
    }

    public boolean hasJxpPage(String id) {
        for (int i = 0; i < this._sources.size(); ++i) {
            JxpPageSource source = (JxpPageSource)this._sources.get(i);
            if (!source.hasJxpPage(id)) continue;
            return true;
        }
        return false;
    }
}

