/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.lang.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SoftHashMap
extends AbstractMap {
    private final Map hash = new HashMap();
    private final int HARD_REF_SIZE;
    private final LinkedList hardRefCache;
    private final ReferenceQueue queue = new ReferenceQueue();

    public SoftHashMap() {
        this(0);
    }

    public SoftHashMap(int hardSize) {
        this.HARD_REF_SIZE = hardSize;
        this.hardRefCache = this.HARD_REF_SIZE > 0 ? new LinkedList() : null;
    }

    public Object get(Object key) {
        Object result = null;
        SoftReference soft_ref = (SoftReference)this.hash.get(key);
        if (soft_ref != null) {
            result = soft_ref.get();
            if (result == null) {
                this.hash.remove(key);
            } else if (this.HARD_REF_SIZE > 0) {
                this.hardRefCache.addFirst(result);
                if (this.hardRefCache.size() > this.HARD_REF_SIZE) {
                    this.hardRefCache.removeLast();
                }
            }
        }
        return result;
    }

    private void _cleanCollectedValues() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    public Object put(Object key, Object value) {
        this._cleanCollectedValues();
        return this.hash.put(key, new SoftValue(value, key, this.queue));
    }

    public Object remove(Object key) {
        this._cleanCollectedValues();
        return this.hash.remove(key);
    }

    public void clear() {
        if (this.HARD_REF_SIZE > 0) {
            this.hardRefCache.clear();
        }
        this._cleanCollectedValues();
        this.hash.clear();
    }

    public int size() {
        this._cleanCollectedValues();
        return this.hash.size();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object k, Object key, ReferenceQueue q) {
            super(k, q);
            this.key = key;
        }
    }
}

