# frozen_string_literal: true

# Licensed to the Software Freedom Conservancy (SFC) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The SFC licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

module Selenium
  module WebDriver
    class BiDi
      class Session
        Status = Struct.new(:ready, :message)

        def initialize(bidi)
          @bidi = bidi
        end

        def status
          status = @bidi.send_cmd('session.status')
          Status.new(status['ready'], status['message'])
        end

        def subscribe(events, browsing_contexts = nil)
          events_list = Array(events)
          browsing_contexts_list = browsing_contexts.nil? ? nil : Array(browsing_contexts)

          @bidi.send_cmd('session.subscribe', events: events_list, contexts: browsing_contexts_list)
        end

        def unsubscribe(events, browsing_contexts = nil)
          events_list = Array(events)
          browsing_contexts_list = browsing_contexts.nil? ? nil : Array(browsing_contexts)

          @bidi.send_cmd('session.unsubscribe', events: events_list, contexts: browsing_contexts_list)
        end
      end # Session
    end # BiDi
  end # WebDriver
end # Selenium
