#
# String handling from the Arm Optimized Routines
# https://github.com/ARM-software/optimized-routines
#

AARCH64_STRING_FUNCS= \
	memcmp \
	memmove \
	memrchr \
	stpcpy \
	strchr \
	strchrnul \
	strcpy \
	strnlen \
	strrchr

AARCH64_STRING_IFUNC_FILES= \
	memcpy-mops.S \
	memmove-mops.S \
	memset-mops.S

# SIMD-enhanced routines not derived from Arm's code
MDSRCS+= \
	memchr.S \
	strcmp.S \
	strspn.S \
	strcspn.S \
	strpbrk.c \
	strsep.c \
	strcat.c \
	strlcpy.S \
	strncmp.S \
	memccpy.S \
	strncat.c \
	strlcat.c \
	strlen.S \
	timingsafe_bcmp.S \
	timingsafe_memcmp.S \
	bcopy.c \
	bzero.c \
	memcpy.S \
	memcpy_resolver.c \
	memmove_resolver.c \
	memset.S \
	memset_resolver.c \
	memset_zva64.S

#
# Add the above functions. Generate an asm file that includes the needed
# Arm Optimized Routines file defining the function name to the libc name.
# Some file need multiple macros defined or a weak symbol added we can
# override the generated file in these cases.
#
.for FUNC in ${AARCH64_STRING_FUNCS}
.if !exists(${LIBC_SRCTOP}/aarch64/string/${FUNC}.S)
${FUNC}.S: ${LIBC_SRCTOP}/aarch64/string/Makefile.inc
	printf '/* %sgenerated by libc/aarch64/string/Makefile.inc */\n' @ > ${.TARGET}
	printf '#define	__%s_aarch64 %s\n' ${FUNC} ${FUNC} >> ${.TARGET}
	printf '#include "aarch64/%s.S"\n' ${FUNC} >> ${.TARGET}
CLEANFILES+=	${FUNC}.S
.endif

MDSRCS+=	${FUNC}.S
CFLAGS.${FUNC}.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
.endfor

.for FILE in ${AARCH64_STRING_IFUNC_FILES}
${FILE}: ${LIBC_SRCTOP}/aarch64/string/Makefile.inc
	printf '/* %sgenerated by libc/aarch64/string/Makefile.inc */\n' @ > ${.TARGET}
	printf '#include "aarch64/%s"\n' ${FILE} >> ${.TARGET}
CLEANFILES+=   ${FILE}
MDSRCS+=       ${FILE}
CFLAGS.${FILE}+=-I${SRCTOP}/contrib/arm-optimized-routines/string
.endfor

# Several files are wrappers in the src tree for the implementation from
# arm-optimized-routines
CFLAGS.memchr.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
CFLAGS.memcpy.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
CFLAGS.memset.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
CFLAGS.memset_zva64.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
