<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Base Math

> Standard library math base implementations.

<section class="usage">

## Usage

```javascript
var math = require( '@stdlib/math/base' );
```

#### math

Standard library base math.

```javascript
var ns = math;
// returns {...}
```

The namespace contains the following sub-namespaces:

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`assert`][@stdlib/math/base/assert]</span><span class="delimiter">: </span><span class="description">standard library basic mathematical assertion utilities.</span>
-   <span class="signature">[`ops`][@stdlib/math/base/ops]</span><span class="delimiter">: </span><span class="description">standard library base math operators.</span>
-   <span class="signature">[`special`][@stdlib/math/base/special]</span><span class="delimiter">: </span><span class="description">standard library base special math functions.</span>
-   <span class="signature">[`tools`][@stdlib/math/base/tools]</span><span class="delimiter">: </span><span class="description">standard library basic mathematical tools.</span>
-   <span class="signature">[`utils`][@stdlib/math/base/utils]</span><span class="delimiter">: </span><span class="description">standard library basic mathematical utilities.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<!-- Package notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var ns = require( '@stdlib/math/base' );

console.log( objectKeys( ns ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/math/base/assert]: https://github.com/stdlib-js/math/tree/main/base/assert

[@stdlib/math/base/ops]: https://github.com/stdlib-js/math/tree/main/base/ops

[@stdlib/math/base/special]: https://github.com/stdlib-js/math/tree/main/base/special

[@stdlib/math/base/tools]: https://github.com/stdlib-js/math/tree/main/base/tools

[@stdlib/math/base/utils]: https://github.com/stdlib-js/math/tree/main/base/utils

<!-- </toc-links> -->

</section>

<!-- /.links -->
