/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_th.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t19, t22, t23, t30;
  double t31, t32, t33, t34, t37, tzk0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = rho[0] * rho[0];
  t19 = 0.1e1 / tau[0];
  t22 = M_CBRT2;
  t23 = 0.1e1 / rho[0];
  t30 = POW_1_3(0.1e1 / M_PI);
  t31 = 0.1e1 / t30;
  t32 = M_CBRT4;
  t33 = t31 * t32;
  t34 = t22 * (0.1e1 + 0.7e1 / 0.216e3 * sigma[0] * t23 * t19) * t33;
  t37 = my_piecewise3(t3, 0, -0.27e2 / 0.16e3 * t17 * t18 * t19 * t34);
  tzk0 = 0.2e1 * t37;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t19, t22, t23, t30;
  double t31, t32, t33, t34, t37, tzk0;

  double t42, t43, t44, t46, t50, tvrho0, t53, t58;
  double tvsigma0, tvlapl0, t65, t67, t71, tvtau0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = rho[0] * rho[0];
  t19 = 0.1e1 / tau[0];
  t22 = M_CBRT2;
  t23 = 0.1e1 / rho[0];
  t30 = POW_1_3(0.1e1 / M_PI);
  t31 = 0.1e1 / t30;
  t32 = M_CBRT4;
  t33 = t31 * t32;
  t34 = t22 * (0.1e1 + 0.7e1 / 0.216e3 * sigma[0] * t23 * t19) * t33;
  t37 = my_piecewise3(t3, 0, -0.27e2 / 0.16e3 * t17 * t18 * t19 * t34);
  tzk0 = 0.2e1 * t37;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = tau[0] * tau[0];
  t43 = 0.1e1 / t42;
  t44 = t17 * t43;
  t46 = t22 * sigma[0] * t33;
  t50 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * rho[0] * t19 * t34 + 0.7e1 / 0.128e4 * t44 * t46);
  tvrho0 = 0.2e1 * rho[0] * t50 + 0.2e1 * t37;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t53 = t17 * rho[0];
  t58 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t53 * t43 * t22 * t33);
  tvsigma0 = 0.2e1 * rho[0] * t58;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t65 = 0.1e1 / t42 / tau[0];
  t67 = t17 * rho[0] * t65;
  t71 = my_piecewise3(t3, 0, 0.27e2 / 0.16e3 * t17 * t18 * t43 * t34 + 0.7e1 / 0.128e4 * t67 * t46);
  tvtau0 = 0.2e1 * rho[0] * t71;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t19, t22, t23, t30;
  double t31, t32, t33, t34, t37, tzk0;

  double t42, t43, t44, t46, t50, tvrho0, t53, t58;
  double tvsigma0, tvlapl0, t65, t67, t71, tvtau0;

  double t82, tv2rho20, t86, t89, tv2rhosigma0, tv2rholapl0, t96, tv2rhotau0;
  double tv2sigma20, tv2sigmalapl0, t103, tv2sigmatau0, tv2lapl20, tv2lapltau0, t109, t110;
  double t112, t116, tv2tau20;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = rho[0] * rho[0];
  t19 = 0.1e1 / tau[0];
  t22 = M_CBRT2;
  t23 = 0.1e1 / rho[0];
  t30 = POW_1_3(0.1e1 / M_PI);
  t31 = 0.1e1 / t30;
  t32 = M_CBRT4;
  t33 = t31 * t32;
  t34 = t22 * (0.1e1 + 0.7e1 / 0.216e3 * sigma[0] * t23 * t19) * t33;
  t37 = my_piecewise3(t3, 0, -0.27e2 / 0.16e3 * t17 * t18 * t19 * t34);
  tzk0 = 0.2e1 * t37;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = tau[0] * tau[0];
  t43 = 0.1e1 / t42;
  t44 = t17 * t43;
  t46 = t22 * sigma[0] * t33;
  t50 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * rho[0] * t19 * t34 + 0.7e1 / 0.128e4 * t44 * t46);
  tvrho0 = 0.2e1 * rho[0] * t50 + 0.2e1 * t37;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t53 = t17 * rho[0];
  t58 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t53 * t43 * t22 * t33);
  tvsigma0 = 0.2e1 * rho[0] * t58;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t65 = 0.1e1 / t42 / tau[0];
  t67 = t17 * rho[0] * t65;
  t71 = my_piecewise3(t3, 0, 0.27e2 / 0.16e3 * t17 * t18 * t43 * t34 + 0.7e1 / 0.128e4 * t67 * t46);
  tvtau0 = 0.2e1 * rho[0] * t71;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t82 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t19 * t34 + 0.7e1 / 0.64e3 * t17 * t23 * t43 * t46);
  tv2rho20 = 0.2e1 * rho[0] * t82 + 0.4e1 * t50;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t22 * t31 * t32;
  t89 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t44 * t86);
  tv2rhosigma0 = 0.2e1 * rho[0] * t89 + 0.2e1 * t58;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t96 = my_piecewise3(t3, 0, 0.27e2 / 0.8e2 * t17 * rho[0] * t43 * t34);
  tv2rhotau0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t71;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t103 = my_piecewise3(t3, 0, 0.7e1 / 0.64e3 * t53 * t65 * t22 * t33);
  tv2sigmatau0 = 0.2e1 * rho[0] * t103;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t17 * rho[0] * t110;
  t116 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t18 * t65 * t34 - 0.7e1 / 0.32e3 * t112 * t46);
  tv2tau20 = 0.2e1 * rho[0] * t116;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t19, t22, t23, t30;
  double t31, t32, t33, t34, t37, tzk0;

  double t42, t43, t44, t46, t50, tvrho0, t53, t58;
  double tvsigma0, tvlapl0, t65, t67, t71, tvtau0;

  double t82, tv2rho20, t86, t89, tv2rhosigma0, tv2rholapl0, t96, tv2rhotau0;
  double tv2sigma20, tv2sigmalapl0, t103, tv2sigmatau0, tv2lapl20, tv2lapltau0, t109, t110;
  double t112, t116, tv2tau20;

  double t119, t121, tv3rho30, tv3rho2sigma0, tv3rho2lapl0, t131, tv3rho2tau0, tv3rhosigma20;
  double tv3rhosigmalapl0, t134, t137, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t142, t146;
  double tv3rhotau20, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t153, tv3sigmatau20;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, t160, t166, tv3tau30;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = rho[0] * rho[0];
  t19 = 0.1e1 / tau[0];
  t22 = M_CBRT2;
  t23 = 0.1e1 / rho[0];
  t30 = POW_1_3(0.1e1 / M_PI);
  t31 = 0.1e1 / t30;
  t32 = M_CBRT4;
  t33 = t31 * t32;
  t34 = t22 * (0.1e1 + 0.7e1 / 0.216e3 * sigma[0] * t23 * t19) * t33;
  t37 = my_piecewise3(t3, 0, -0.27e2 / 0.16e3 * t17 * t18 * t19 * t34);
  tzk0 = 0.2e1 * t37;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = tau[0] * tau[0];
  t43 = 0.1e1 / t42;
  t44 = t17 * t43;
  t46 = t22 * sigma[0] * t33;
  t50 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * rho[0] * t19 * t34 + 0.7e1 / 0.128e4 * t44 * t46);
  tvrho0 = 0.2e1 * rho[0] * t50 + 0.2e1 * t37;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t53 = t17 * rho[0];
  t58 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t53 * t43 * t22 * t33);
  tvsigma0 = 0.2e1 * rho[0] * t58;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t65 = 0.1e1 / t42 / tau[0];
  t67 = t17 * rho[0] * t65;
  t71 = my_piecewise3(t3, 0, 0.27e2 / 0.16e3 * t17 * t18 * t43 * t34 + 0.7e1 / 0.128e4 * t67 * t46);
  tvtau0 = 0.2e1 * rho[0] * t71;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t82 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t19 * t34 + 0.7e1 / 0.64e3 * t17 * t23 * t43 * t46);
  tv2rho20 = 0.2e1 * rho[0] * t82 + 0.4e1 * t50;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t22 * t31 * t32;
  t89 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t44 * t86);
  tv2rhosigma0 = 0.2e1 * rho[0] * t89 + 0.2e1 * t58;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t96 = my_piecewise3(t3, 0, 0.27e2 / 0.8e2 * t17 * rho[0] * t43 * t34);
  tv2rhotau0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t71;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t103 = my_piecewise3(t3, 0, 0.7e1 / 0.64e3 * t53 * t65 * t22 * t33);
  tv2sigmatau0 = 0.2e1 * rho[0] * t103;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t17 * rho[0] * t110;
  t116 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t18 * t65 * t34 - 0.7e1 / 0.32e3 * t112 * t46);
  tv2tau20 = 0.2e1 * rho[0] * t116;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t119 = my_piecewise3(t3, 0, 0);
  t121 = 0.2e1 * rho[0] * t119;
  tv3rho30 = 0.6e1 * t82 + t121;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho2sigma0 = 0.4e1 * t89 + t121;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t131 = my_piecewise3(t3, 0, 0.27e2 / 0.8e2 * t44 * t34 - 0.7e1 / 0.64e3 * t17 * t23 * t65 * t46);
  tv3rho2tau0 = 0.2e1 * rho[0] * t131 + 0.4e1 * t96;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t134 = t17 * t65;
  t137 = my_piecewise3(t3, 0, 0.7e1 / 0.64e3 * t134 * t86);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t137 + 0.2e1 * t103;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t142 = t17 * t110;
  t146 = my_piecewise3(t3, 0, -0.27e2 / 0.4e2 * t67 * t34 - 0.7e1 / 0.64e3 * t142 * t46);
  tv3rhotau20 = 0.2e1 * rho[0] * t146 + 0.2e1 * t116;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t153 = my_piecewise3(t3, 0, -0.21e2 / 0.64e3 * t53 * t110 * t22 * t33);
  tv3sigmatau20 = 0.2e1 * rho[0] * t153;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t160 = 0.1e1 / t109 / tau[0];
  t166 = my_piecewise3(t3, 0, 0.81e2 / 0.8e2 * t17 * t18 * t110 * t34 + 0.63e2 / 0.64e3 * t17 * rho[0] * t160 * t46);
  tv3tau30 = 0.2e1 * rho[0] * t166;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t19, t22, t23, t30;
  double t31, t32, t33, t34, t37, tzk0;

  double t42, t43, t44, t46, t50, tvrho0, t53, t58;
  double tvsigma0, tvlapl0, t65, t67, t71, tvtau0;

  double t82, tv2rho20, t86, t89, tv2rhosigma0, tv2rholapl0, t96, tv2rhotau0;
  double tv2sigma20, tv2sigmalapl0, t103, tv2sigmatau0, tv2lapl20, tv2lapltau0, t109, t110;
  double t112, t116, tv2tau20;

  double t119, t121, tv3rho30, tv3rho2sigma0, tv3rho2lapl0, t131, tv3rho2tau0, tv3rhosigma20;
  double tv3rhosigmalapl0, t134, t137, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t142, t146;
  double tv3rhotau20, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t153, tv3sigmatau20;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, t160, t166, tv3tau30;

  double tv4rho40, tv4rho3sigma0, tv4rho3lapl0, tv4rho3tau0, tv4rho2sigma20, tv4rho2sigmalapl0, tv4rho2sigmatau0, tv4rho2lapl20;
  double tv4rho2lapltau0, t180, tv4rho2tau20, tv4rhosigma30, tv4rhosigma2lapl0, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0;
  double t185, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, t194, tv4rhotau30, tv4sigma40;
  double tv4sigma3lapl0, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20;
  double t201, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, t214, tv4tau40;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = rho[0] * rho[0];
  t19 = 0.1e1 / tau[0];
  t22 = M_CBRT2;
  t23 = 0.1e1 / rho[0];
  t30 = POW_1_3(0.1e1 / M_PI);
  t31 = 0.1e1 / t30;
  t32 = M_CBRT4;
  t33 = t31 * t32;
  t34 = t22 * (0.1e1 + 0.7e1 / 0.216e3 * sigma[0] * t23 * t19) * t33;
  t37 = my_piecewise3(t3, 0, -0.27e2 / 0.16e3 * t17 * t18 * t19 * t34);
  tzk0 = 0.2e1 * t37;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = tau[0] * tau[0];
  t43 = 0.1e1 / t42;
  t44 = t17 * t43;
  t46 = t22 * sigma[0] * t33;
  t50 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * rho[0] * t19 * t34 + 0.7e1 / 0.128e4 * t44 * t46);
  tvrho0 = 0.2e1 * rho[0] * t50 + 0.2e1 * t37;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t53 = t17 * rho[0];
  t58 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t53 * t43 * t22 * t33);
  tvsigma0 = 0.2e1 * rho[0] * t58;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t65 = 0.1e1 / t42 / tau[0];
  t67 = t17 * rho[0] * t65;
  t71 = my_piecewise3(t3, 0, 0.27e2 / 0.16e3 * t17 * t18 * t43 * t34 + 0.7e1 / 0.128e4 * t67 * t46);
  tvtau0 = 0.2e1 * rho[0] * t71;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t82 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t19 * t34 + 0.7e1 / 0.64e3 * t17 * t23 * t43 * t46);
  tv2rho20 = 0.2e1 * rho[0] * t82 + 0.4e1 * t50;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t22 * t31 * t32;
  t89 = my_piecewise3(t3, 0, -0.7e1 / 0.128e4 * t44 * t86);
  tv2rhosigma0 = 0.2e1 * rho[0] * t89 + 0.2e1 * t58;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t96 = my_piecewise3(t3, 0, 0.27e2 / 0.8e2 * t17 * rho[0] * t43 * t34);
  tv2rhotau0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t71;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t103 = my_piecewise3(t3, 0, 0.7e1 / 0.64e3 * t53 * t65 * t22 * t33);
  tv2sigmatau0 = 0.2e1 * rho[0] * t103;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t17 * rho[0] * t110;
  t116 = my_piecewise3(t3, 0, -0.27e2 / 0.8e2 * t17 * t18 * t65 * t34 - 0.7e1 / 0.32e3 * t112 * t46);
  tv2tau20 = 0.2e1 * rho[0] * t116;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t119 = my_piecewise3(t3, 0, 0);
  t121 = 0.2e1 * rho[0] * t119;
  tv3rho30 = 0.6e1 * t82 + t121;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho2sigma0 = 0.4e1 * t89 + t121;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t131 = my_piecewise3(t3, 0, 0.27e2 / 0.8e2 * t44 * t34 - 0.7e1 / 0.64e3 * t17 * t23 * t65 * t46);
  tv3rho2tau0 = 0.2e1 * rho[0] * t131 + 0.4e1 * t96;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t134 = t17 * t65;
  t137 = my_piecewise3(t3, 0, 0.7e1 / 0.64e3 * t134 * t86);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t137 + 0.2e1 * t103;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t142 = t17 * t110;
  t146 = my_piecewise3(t3, 0, -0.27e2 / 0.4e2 * t67 * t34 - 0.7e1 / 0.64e3 * t142 * t46);
  tv3rhotau20 = 0.2e1 * rho[0] * t146 + 0.2e1 * t116;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t153 = my_piecewise3(t3, 0, -0.21e2 / 0.64e3 * t53 * t110 * t22 * t33);
  tv3sigmatau20 = 0.2e1 * rho[0] * t153;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t160 = 0.1e1 / t109 / tau[0];
  t166 = my_piecewise3(t3, 0, 0.81e2 / 0.8e2 * t17 * t18 * t110 * t34 + 0.63e2 / 0.64e3 * t17 * rho[0] * t160 * t46);
  tv3tau30 = 0.2e1 * rho[0] * t166;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv4rho40 = 0.8e1 * t119 + t121;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  tv4rho3sigma0 = 0.6e1 * t119 + t121;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.6e1 * t131 + t121;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.4e1 * t137 + t121;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t180 = my_piecewise3(t3, 0, -0.27e2 / 0.4e2 * t134 * t34 + 0.7e1 / 0.32e3 * t17 * t23 * t110 * t46);
  tv4rho2tau20 = 0.2e1 * rho[0] * t180 + 0.4e1 * t146;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t185 = my_piecewise3(t3, 0, -0.21e2 / 0.64e3 * t142 * t86);
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t185 + 0.2e1 * t153;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t194 = my_piecewise3(t3, 0, 0.81e2 / 0.4e2 * t112 * t34 + 0.21e2 / 0.32e3 * t17 * t160 * t46);
  tv4rhotau30 = 0.2e1 * rho[0] * t194 + 0.2e1 * t166;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t201 = my_piecewise3(t3, 0, 0.21e2 / 0.16e3 * t53 * t160 * t22 * t33);
  tv4sigmatau30 = 0.2e1 * rho[0] * t201;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t214 = my_piecewise3(t3, 0, -0.81e2 / 0.2e2 * t17 * t18 * t160 * t34 - 0.21e2 / 0.4e2 * t17 * rho[0] / t109 / t42 * t46);
  tv4tau40 = 0.2e1 * rho[0] * t214;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t37, t40, t42, t43, t44, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t60, t61, t62, t68, t70, t73, tzk0;


  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t27 = 0.1e1 / tau[0];
  t28 = t26 * t27;
  t29 = t25 * t28;
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t37 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[0] / rho[0] * t27;
  t40 = POW_1_3(0.1e1 / M_PI);
  t42 = M_CBRT4;
  t43 = 0.1e1 / t40 * t42;
  t44 = t31 * rho[0] * t37 * t43;
  t47 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t29 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t58 = 0.1e1 / tau[1];
  t59 = t26 * t58;
  t60 = t57 * t59;
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t68 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[2] / rho[1] * t58;
  t70 = t62 * rho[1] * t68 * t43;
  t73 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t60 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t37, t40, t42, t43, t44, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t60, t61, t62, t68, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t83, t86;
  double t87, t88, t89, t91, t93, t96, t97, t98;
  double t99, t100, t102, t106, t107, t109, t112, t113;
  double t114, t117, t118, t120, t122, tvrho0, t126, t129;
  double t130, t131, t135, t137, t140, t141, t142, t146;
  double t149, t150, t151, t152, t153, t155, t159, tvrho1;
  double t162, t164, t167, tvsigma0, tvsigma1, t168, t170, t173;
  double tvsigma2, tvlapl0, tvlapl1, t177, t178, t179, t181, t185;
  double tvtau0, t189, t190, t191, t193, t197, tvtau1;


  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t27 = 0.1e1 / tau[0];
  t28 = t26 * t27;
  t29 = t25 * t28;
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t37 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[0] / rho[0] * t27;
  t40 = POW_1_3(0.1e1 / M_PI);
  t42 = M_CBRT4;
  t43 = 0.1e1 / t40 * t42;
  t44 = t31 * rho[0] * t37 * t43;
  t47 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t29 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t58 = 0.1e1 / tau[1];
  t59 = t26 * t58;
  t60 = t57 * t59;
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t68 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[2] / rho[1] * t58;
  t70 = t62 * rho[1] * t68 * t43;
  t73 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t60 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t83 = t82 * t28;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t88 = t87 * t27;
  t89 = t25 * t88;
  t91 = 0.9e1 / 0.8e2 * t89 * t44;
  t93 = t31 * t37 * t43;
  t96 = tau[0] * tau[0];
  t97 = 0.1e1 / t96;
  t98 = t26 * t97;
  t99 = t25 * t98;
  t100 = 0.1e1 / t30;
  t102 = t100 * sigma[0] * t43;
  t106 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t83 * t44 - t91 - 0.9e1 / 0.16e2 * t29 * t93 + 0.7e1 / 0.64e3 * t99 * t102);
  t107 = t49 * t75;
  t109 = my_piecewise5(t13, 0, t9, 0, -t6 - t107);
  t112 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t109);
  t113 = t4 * t112;
  t114 = t113 * t59;
  t117 = t87 * t58;
  t118 = t57 * t117;
  t120 = 0.9e1 / 0.8e2 * t118 * t70;
  t122 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t114 * t70 - t120);
  tvrho0 = t47 + t73 + t5 * (t106 + t122);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t126 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t129 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t126);
  t130 = t4 * t129;
  t131 = t130 * t28;
  t135 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t131 * t44 - t91);
  t137 = my_piecewise5(t13, 0, t9, 0, t6 - t107);
  t140 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t137);
  t141 = t4 * t140;
  t142 = t141 * t59;
  t146 = t62 * t68 * t43;
  t149 = tau[1] * tau[1];
  t150 = 0.1e1 / t149;
  t151 = t26 * t150;
  t152 = t57 * t151;
  t153 = 0.1e1 / t61;
  t155 = t153 * sigma[2] * t43;
  t159 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t142 * t70 - t120 - 0.9e1 / 0.16e2 * t60 * t146 + 0.7e1 / 0.64e3 * t152 * t155);
  tvrho1 = t47 + t73 + t5 * (t135 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t162 = t25 * t26;
  t164 = t97 * t31 * t43;
  t167 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t162 * t164);
  tvsigma0 = t5 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t168 = t57 * t26;
  t170 = t150 * t62 * t43;
  t173 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t168 * t170);
  tvsigma2 = t5 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = 0.1e1 / t96 / tau[0];
  t178 = t26 * t177;
  t179 = t25 * t178;
  t181 = t31 * sigma[0] * t43;
  t185 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t99 * t44 + 0.7e1 / 0.64e3 * t179 * t181);
  tvtau0 = t5 * t185;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t189 = 0.1e1 / t149 / tau[1];
  t190 = t26 * t189;
  t191 = t57 * t190;
  t193 = t62 * sigma[2] * t43;
  t197 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t152 * t70 + 0.7e1 / 0.64e3 * t191 * t193);
  tvtau1 = t5 * t197;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t37, t40, t42, t43, t44, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t60, t61, t62, t68, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t83, t86;
  double t87, t88, t89, t91, t93, t96, t97, t98;
  double t99, t100, t102, t106, t107, t109, t112, t113;
  double t114, t117, t118, t120, t122, tvrho0, t126, t129;
  double t130, t131, t135, t137, t140, t141, t142, t146;
  double t149, t150, t151, t152, t153, t155, t159, tvrho1;
  double t162, t164, t167, tvsigma0, tvsigma1, t168, t170, t173;
  double tvsigma2, tvlapl0, tvlapl1, t177, t178, t179, t181, t185;
  double tvtau0, t189, t190, t191, t193, t197, tvtau1;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t216, t219, t220, t224, t228, t229, t230;
  double t232, t233, t235, t236, t237, t240, t244, t246;
  double t250, t251, t252, t253, t256, t259, t263, t264;
  double t265, t268, t269, t271, t272, t274, t276, tv2rho20;
  double t279, t283, t287, t288, t289, t292, t293, t297;
  double t304, t305, t309, t313, t314, t315, t318, t319;
  double t324, t326, t329, t330, t331, t334, tv2rho21, t339;
  double t344, t348, t349, t350, t355, t356, t361, t365;
  double t366, t367, t373, t379, t383, t385, t389, tv2rho22;
  double t392, t395, t397, t399, t403, tv2rhosigma0, tv2rhosigma1, t405;
  double t408, t410, t412, tv2rhosigma2, t414, t418, tv2rhosigma3, tv2rhosigma4;
  double t420, t424, t428, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t433, t438, t441, t442, t444, t446, tv2rhotau0, t451;
  double t452, t455, t456, t458, t460, tv2rhotau1, t464, t468;
  double tv2rhotau2, t476, t480, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double t483, t486, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t488;
  double t491, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t494, t495, t496, t497, t501, tv2tau20, tv2tau21;
  double t504, t505, t506, t507, t511, tv2tau22;


  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t27 = 0.1e1 / tau[0];
  t28 = t26 * t27;
  t29 = t25 * t28;
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t37 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[0] / rho[0] * t27;
  t40 = POW_1_3(0.1e1 / M_PI);
  t42 = M_CBRT4;
  t43 = 0.1e1 / t40 * t42;
  t44 = t31 * rho[0] * t37 * t43;
  t47 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t29 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t58 = 0.1e1 / tau[1];
  t59 = t26 * t58;
  t60 = t57 * t59;
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t68 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[2] / rho[1] * t58;
  t70 = t62 * rho[1] * t68 * t43;
  t73 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t60 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t83 = t82 * t28;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t88 = t87 * t27;
  t89 = t25 * t88;
  t91 = 0.9e1 / 0.8e2 * t89 * t44;
  t93 = t31 * t37 * t43;
  t96 = tau[0] * tau[0];
  t97 = 0.1e1 / t96;
  t98 = t26 * t97;
  t99 = t25 * t98;
  t100 = 0.1e1 / t30;
  t102 = t100 * sigma[0] * t43;
  t106 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t83 * t44 - t91 - 0.9e1 / 0.16e2 * t29 * t93 + 0.7e1 / 0.64e3 * t99 * t102);
  t107 = t49 * t75;
  t109 = my_piecewise5(t13, 0, t9, 0, -t6 - t107);
  t112 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t109);
  t113 = t4 * t112;
  t114 = t113 * t59;
  t117 = t87 * t58;
  t118 = t57 * t117;
  t120 = 0.9e1 / 0.8e2 * t118 * t70;
  t122 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t114 * t70 - t120);
  tvrho0 = t47 + t73 + t5 * (t106 + t122);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t126 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t129 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t126);
  t130 = t4 * t129;
  t131 = t130 * t28;
  t135 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t131 * t44 - t91);
  t137 = my_piecewise5(t13, 0, t9, 0, t6 - t107);
  t140 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t137);
  t141 = t4 * t140;
  t142 = t141 * t59;
  t146 = t62 * t68 * t43;
  t149 = tau[1] * tau[1];
  t150 = 0.1e1 / t149;
  t151 = t26 * t150;
  t152 = t57 * t151;
  t153 = 0.1e1 / t61;
  t155 = t153 * sigma[2] * t43;
  t159 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t142 * t70 - t120 - 0.9e1 / 0.16e2 * t60 * t146 + 0.7e1 / 0.64e3 * t152 * t155);
  tvrho1 = t47 + t73 + t5 * (t135 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t162 = t25 * t26;
  t164 = t97 * t31 * t43;
  t167 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t162 * t164);
  tvsigma0 = t5 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t168 = t57 * t26;
  t170 = t150 * t62 * t43;
  t173 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t168 * t170);
  tvsigma2 = t5 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = 0.1e1 / t96 / tau[0];
  t178 = t26 * t177;
  t179 = t25 * t178;
  t181 = t31 * sigma[0] * t43;
  t185 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t99 * t44 + 0.7e1 / 0.64e3 * t179 * t181);
  tvtau0 = t5 * t185;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t189 = 0.1e1 / t149 / tau[1];
  t190 = t26 * t189;
  t191 = t57 * t190;
  t193 = t62 * sigma[2] * t43;
  t197 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t152 * t70 + 0.7e1 / 0.64e3 * t191 * t193);
  tvtau1 = t5 * t197;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t200 = t22 * t22;
  t201 = 0.1e1 / t200;
  t202 = t78 * t78;
  t205 = t74 * t5;
  t206 = 0.1e1 / t205;
  t207 = t15 * t206;
  t210 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t207);
  t214 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t22 * t210);
  t215 = t4 * t214;
  t216 = t215 * t28;
  t219 = t82 * t88;
  t220 = t219 * t44;
  t224 = t82 * t98;
  t228 = 0.1e1 / t86 / t5;
  t229 = t228 * t27;
  t230 = t25 * t229;
  t232 = 0.3e1 / 0.4e2 * t230 * t44;
  t233 = t89 * t93;
  t235 = t87 * t97;
  t236 = t25 * t235;
  t237 = t236 * t102;
  t240 = t100 * t37 * t43;
  t244 = 0.1e1 / t30 / rho[0];
  t246 = t244 * sigma[0] * t43;
  t250 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t216 * t44 - 0.9e1 / 0.4e2 * t220 - 0.9e1 / 0.8e1 * t83 * t93 + 0.7e1 / 0.32e3 * t224 * t102 + t232 - 0.3e1 / 0.8e1 * t233 + 0.7e1 / 0.96e3 * t237 - 0.3e1 / 0.8e1 * t29 * t240 + 0.7e1 / 0.48e3 * t99 * t246);
  t251 = t54 * t54;
  t252 = 0.1e1 / t251;
  t253 = t109 * t109;
  t256 = t49 * t206;
  t259 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t256);
  t263 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t253 + 0.4e1 / 0.3e1 * t54 * t259);
  t264 = t4 * t263;
  t265 = t264 * t59;
  t268 = t113 * t117;
  t269 = t268 * t70;
  t271 = t228 * t58;
  t272 = t57 * t271;
  t274 = 0.3e1 / 0.4e2 * t272 * t70;
  t276 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t265 * t70 - 0.9e1 / 0.4e2 * t269 + t274);
  tv2rho20 = 0.2e1 * t106 + 0.2e1 * t122 + t5 * (t250 + t276);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t279 = t201 * t126;
  t283 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t207);
  t287 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t279 * t78 + 0.4e1 / 0.3e1 * t22 * t283);
  t288 = t4 * t287;
  t289 = t288 * t28;
  t292 = t130 * t88;
  t293 = t292 * t44;
  t297 = t130 * t98;
  t304 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t289 * t44 - 0.9e1 / 0.8e2 * t293 - 0.9e1 / 0.16e2 * t131 * t93 + 0.7e1 / 0.64e3 * t297 * t102 - 0.9e1 / 0.8e2 * t220 + t232 - 0.3e1 / 0.16e2 * t233 + 0.7e1 / 0.192e4 * t237);
  t305 = t252 * t137;
  t309 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t256);
  t313 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t305 * t109 + 0.4e1 / 0.3e1 * t54 * t309);
  t314 = t4 * t313;
  t315 = t314 * t59;
  t318 = t141 * t117;
  t319 = t318 * t70;
  t324 = t118 * t146;
  t326 = t113 * t151;
  t329 = t87 * t150;
  t330 = t57 * t329;
  t331 = t330 * t155;
  t334 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t315 * t70 - 0.9e1 / 0.8e2 * t319 - 0.9e1 / 0.8e2 * t269 + t274 - 0.9e1 / 0.16e2 * t114 * t146 - 0.3e1 / 0.16e2 * t324 + 0.7e1 / 0.64e3 * t326 * t155 + 0.7e1 / 0.192e4 * t331);
  tv2rho21 = t106 + t122 + t135 + t159 + t5 * (t304 + t334);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t339 = t126 * t126;
  t344 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t207);
  t348 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t339 + 0.4e1 / 0.3e1 * t22 * t344);
  t349 = t4 * t348;
  t350 = t349 * t28;
  t355 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t350 * t44 - 0.9e1 / 0.4e2 * t293 + t232);
  t356 = t137 * t137;
  t361 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t256);
  t365 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t356 + 0.4e1 / 0.3e1 * t54 * t361);
  t366 = t4 * t365;
  t367 = t366 * t59;
  t373 = t141 * t151;
  t379 = t153 * t68 * t43;
  t383 = 0.1e1 / t61 / rho[1];
  t385 = t383 * sigma[2] * t43;
  t389 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t367 * t70 - 0.9e1 / 0.4e2 * t319 - 0.9e1 / 0.8e1 * t142 * t146 + 0.7e1 / 0.32e3 * t373 * t155 + t274 - 0.3e1 / 0.8e1 * t324 + 0.7e1 / 0.96e3 * t331 - 0.3e1 / 0.8e1 * t60 * t379 + 0.7e1 / 0.48e3 * t152 * t385);
  tv2rho22 = 0.2e1 * t135 + 0.2e1 * t159 + t5 * (t355 + t389);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t392 = t82 * t26;
  t395 = t25 * t87;
  t397 = 0.7e1 / 0.192e4 * t395 * t164;
  t399 = t97 * t100 * t43;
  t403 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t392 * t164 - t397 - 0.7e1 / 0.96e3 * t162 * t399);
  tv2rhosigma0 = t5 * t403 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t405 = t113 * t26;
  t408 = t57 * t87;
  t410 = 0.7e1 / 0.192e4 * t408 * t170;
  t412 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t405 * t170 - t410);
  tv2rhosigma2 = t5 * t412 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t414 = t130 * t26;
  t418 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t414 * t164 - t397);
  tv2rhosigma3 = t5 * t418 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t420 = t141 * t26;
  t424 = t150 * t153 * t43;
  t428 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t420 * t170 - t410 - 0.7e1 / 0.96e3 * t168 * t424);
  tv2rhosigma5 = t5 * t428 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t433 = 0.9e1 / 0.8e2 * t236 * t44;
  t438 = t82 * t178;
  t441 = t87 * t177;
  t442 = t25 * t441;
  t444 = 0.7e1 / 0.192e4 * t442 * t181;
  t446 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t224 * t44 + t433 + 0.9e1 / 0.16e2 * t99 * t93 - 0.7e1 / 0.192e4 * t179 * t102 + 0.7e1 / 0.64e3 * t438 * t181 + t444);
  tv2rhotau0 = t5 * t446 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t451 = 0.9e1 / 0.8e2 * t330 * t70;
  t452 = t113 * t190;
  t455 = t87 * t189;
  t456 = t57 * t455;
  t458 = 0.7e1 / 0.192e4 * t456 * t193;
  t460 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t326 * t70 + t451 + 0.7e1 / 0.64e3 * t452 * t193 + t458);
  tv2rhotau1 = t5 * t460 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t464 = t130 * t178;
  t468 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t297 * t44 + t433 + 0.7e1 / 0.64e3 * t464 * t181 + t444);
  tv2rhotau2 = t5 * t468 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t476 = t141 * t190;
  t480 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t373 * t70 + t451 + 0.9e1 / 0.16e2 * t152 * t146 - 0.7e1 / 0.192e4 * t191 * t155 + 0.7e1 / 0.64e3 * t476 * t193 + t458);
  tv2rhotau3 = t5 * t480 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t483 = t177 * t31 * t43;
  t486 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t162 * t483);
  tv2sigmatau0 = t5 * t486;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t488 = t189 * t62 * t43;
  t491 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t168 * t488);
  tv2sigmatau5 = t5 * t491;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t494 = t96 * t96;
  t495 = 0.1e1 / t494;
  t496 = t26 * t495;
  t497 = t25 * t496;
  t501 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t179 * t44 - 0.7e1 / 0.16e3 * t497 * t181);
  tv2tau20 = t5 * t501;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t504 = t149 * t149;
  t505 = 0.1e1 / t504;
  t506 = t26 * t505;
  t507 = t57 * t506;
  t511 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t191 * t70 - 0.7e1 / 0.16e3 * t507 * t193);
  tv2tau22 = t5 * t511;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t37, t40, t42, t43, t44, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t60, t61, t62, t68, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t83, t86;
  double t87, t88, t89, t91, t93, t96, t97, t98;
  double t99, t100, t102, t106, t107, t109, t112, t113;
  double t114, t117, t118, t120, t122, tvrho0, t126, t129;
  double t130, t131, t135, t137, t140, t141, t142, t146;
  double t149, t150, t151, t152, t153, t155, t159, tvrho1;
  double t162, t164, t167, tvsigma0, tvsigma1, t168, t170, t173;
  double tvsigma2, tvlapl0, tvlapl1, t177, t178, t179, t181, t185;
  double tvtau0, t189, t190, t191, t193, t197, tvtau1;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t216, t219, t220, t224, t228, t229, t230;
  double t232, t233, t235, t236, t237, t240, t244, t246;
  double t250, t251, t252, t253, t256, t259, t263, t264;
  double t265, t268, t269, t271, t272, t274, t276, tv2rho20;
  double t279, t283, t287, t288, t289, t292, t293, t297;
  double t304, t305, t309, t313, t314, t315, t318, t319;
  double t324, t326, t329, t330, t331, t334, tv2rho21, t339;
  double t344, t348, t349, t350, t355, t356, t361, t365;
  double t366, t367, t373, t379, t383, t385, t389, tv2rho22;
  double t392, t395, t397, t399, t403, tv2rhosigma0, tv2rhosigma1, t405;
  double t408, t410, t412, tv2rhosigma2, t414, t418, tv2rhosigma3, tv2rhosigma4;
  double t420, t424, t428, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t433, t438, t441, t442, t444, t446, tv2rhotau0, t451;
  double t452, t455, t456, t458, t460, tv2rhotau1, t464, t468;
  double tv2rhotau2, t476, t480, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double t483, t486, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t488;
  double t491, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t494, t495, t496, t497, t501, tv2tau20, tv2tau21;
  double t504, t505, t506, t507, t511, tv2tau22;

  double t514, t516, t519, t524, t525, t527, t532, t533;
  double t534, t536, t537, t538, t540, t542, t544, t548;
  double t549, t552, t555, t556, t557, t560, t564, t565;
  double t566, t569, t572, t573, t577, t578, t579, t581;
  double t583, t584, t586, t587, t590, t593, t596, t600;
  double t601, t602, t605, t606, t608, t609, t611, t612;
  double t614, t616, tv3rho30, t619, t620, t621, t623, t626;
  double t627, t630, t638, t641, t646, t647, t649, t653;
  double t654, t655, t658, t661, t663, t669, t670, t671;
  double t674, t679, t681, t685, t686, t687, t690, t692;
  double t693, t694, t701, t702, t704, t707, t709, t710;
  double t711, t712, t714, t715, tv3rho31, t718, t723, t727;
  double t731, t732, t733, t736, t737, t741, t748, t749;
  double t750, t755, t759, t763, t764, t765, t768, t769;
  double t774, t776, t779, t780, t787, t791, t793, t794;
  double tv3rho32, t799, t806, t810, t811, t812, t818, t820;
  double t835, t837, t839, t842, t849, t853, t854, t855;
  double t858, t863, t864, tv3rho33, t868, t871, t872, t876;
  double t878, t879, t882, t886, tv3rho2sigma0, tv3rho2sigma1, t889, t892;
  double t893, t895, t897, t899, tv3rho2sigma2, t901, t904, t905;
  double t912, tv3rho2sigma3, tv3rho2sigma4, t914, t917, t918, t923, t926;
  double tv3rho2sigma5, t929, t934, tv3rho2sigma6, tv3rho2sigma7, t937, t945, t949;
  double tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t954;
  double t961, t962, t964, t970, t973, t974, t976, t977;
  double t979, t980, t981, tv3rho2tau0, t986, t989, t990, t993;
  double t994, t996, t997, t999, t1001, tv3rho2tau1, t1005, t1014;
  double t1017, t1018, t1021, t1022, tv3rho2tau2, t1026, t1031, t1035;
  double t1037, t1040, t1041, t1044, t1045, tv3rho2tau3, t1051, t1056;
  double tv3rho2tau4, t1072, t1076, t1077, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t1082, t1084, t1088;
  double tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t1093, t1095, tv3rhosigmatau5;
  double t1100, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t1105, t1109;
  double tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0;
  double tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t1114;
  double t1119, t1122, t1123, t1125, t1127, tv3rhotau20, tv3rhotau21, t1132;
  double t1133, t1136, t1137, t1139, t1141, tv3rhotau22, t1145, t1149;
  double tv3rhotau23, tv3rhotau24, t1157, t1161, tv3rhotau25, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0;
  double tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8;
  double tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4;
  double tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t1164, t1167, tv3sigmatau20, tv3sigmatau21;
  double tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t1169, t1172;
  double tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, t1176, t1177, t1178, t1182, tv3tau30, tv3tau31, tv3tau32;
  double t1186, t1187, t1188, t1192, tv3tau33;


  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t27 = 0.1e1 / tau[0];
  t28 = t26 * t27;
  t29 = t25 * t28;
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t37 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[0] / rho[0] * t27;
  t40 = POW_1_3(0.1e1 / M_PI);
  t42 = M_CBRT4;
  t43 = 0.1e1 / t40 * t42;
  t44 = t31 * rho[0] * t37 * t43;
  t47 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t29 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t58 = 0.1e1 / tau[1];
  t59 = t26 * t58;
  t60 = t57 * t59;
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t68 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[2] / rho[1] * t58;
  t70 = t62 * rho[1] * t68 * t43;
  t73 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t60 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t83 = t82 * t28;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t88 = t87 * t27;
  t89 = t25 * t88;
  t91 = 0.9e1 / 0.8e2 * t89 * t44;
  t93 = t31 * t37 * t43;
  t96 = tau[0] * tau[0];
  t97 = 0.1e1 / t96;
  t98 = t26 * t97;
  t99 = t25 * t98;
  t100 = 0.1e1 / t30;
  t102 = t100 * sigma[0] * t43;
  t106 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t83 * t44 - t91 - 0.9e1 / 0.16e2 * t29 * t93 + 0.7e1 / 0.64e3 * t99 * t102);
  t107 = t49 * t75;
  t109 = my_piecewise5(t13, 0, t9, 0, -t6 - t107);
  t112 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t109);
  t113 = t4 * t112;
  t114 = t113 * t59;
  t117 = t87 * t58;
  t118 = t57 * t117;
  t120 = 0.9e1 / 0.8e2 * t118 * t70;
  t122 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t114 * t70 - t120);
  tvrho0 = t47 + t73 + t5 * (t106 + t122);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t126 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t129 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t126);
  t130 = t4 * t129;
  t131 = t130 * t28;
  t135 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t131 * t44 - t91);
  t137 = my_piecewise5(t13, 0, t9, 0, t6 - t107);
  t140 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t137);
  t141 = t4 * t140;
  t142 = t141 * t59;
  t146 = t62 * t68 * t43;
  t149 = tau[1] * tau[1];
  t150 = 0.1e1 / t149;
  t151 = t26 * t150;
  t152 = t57 * t151;
  t153 = 0.1e1 / t61;
  t155 = t153 * sigma[2] * t43;
  t159 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t142 * t70 - t120 - 0.9e1 / 0.16e2 * t60 * t146 + 0.7e1 / 0.64e3 * t152 * t155);
  tvrho1 = t47 + t73 + t5 * (t135 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t162 = t25 * t26;
  t164 = t97 * t31 * t43;
  t167 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t162 * t164);
  tvsigma0 = t5 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t168 = t57 * t26;
  t170 = t150 * t62 * t43;
  t173 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t168 * t170);
  tvsigma2 = t5 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = 0.1e1 / t96 / tau[0];
  t178 = t26 * t177;
  t179 = t25 * t178;
  t181 = t31 * sigma[0] * t43;
  t185 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t99 * t44 + 0.7e1 / 0.64e3 * t179 * t181);
  tvtau0 = t5 * t185;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t189 = 0.1e1 / t149 / tau[1];
  t190 = t26 * t189;
  t191 = t57 * t190;
  t193 = t62 * sigma[2] * t43;
  t197 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t152 * t70 + 0.7e1 / 0.64e3 * t191 * t193);
  tvtau1 = t5 * t197;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t200 = t22 * t22;
  t201 = 0.1e1 / t200;
  t202 = t78 * t78;
  t205 = t74 * t5;
  t206 = 0.1e1 / t205;
  t207 = t15 * t206;
  t210 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t207);
  t214 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t22 * t210);
  t215 = t4 * t214;
  t216 = t215 * t28;
  t219 = t82 * t88;
  t220 = t219 * t44;
  t224 = t82 * t98;
  t228 = 0.1e1 / t86 / t5;
  t229 = t228 * t27;
  t230 = t25 * t229;
  t232 = 0.3e1 / 0.4e2 * t230 * t44;
  t233 = t89 * t93;
  t235 = t87 * t97;
  t236 = t25 * t235;
  t237 = t236 * t102;
  t240 = t100 * t37 * t43;
  t244 = 0.1e1 / t30 / rho[0];
  t246 = t244 * sigma[0] * t43;
  t250 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t216 * t44 - 0.9e1 / 0.4e2 * t220 - 0.9e1 / 0.8e1 * t83 * t93 + 0.7e1 / 0.32e3 * t224 * t102 + t232 - 0.3e1 / 0.8e1 * t233 + 0.7e1 / 0.96e3 * t237 - 0.3e1 / 0.8e1 * t29 * t240 + 0.7e1 / 0.48e3 * t99 * t246);
  t251 = t54 * t54;
  t252 = 0.1e1 / t251;
  t253 = t109 * t109;
  t256 = t49 * t206;
  t259 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t256);
  t263 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t253 + 0.4e1 / 0.3e1 * t54 * t259);
  t264 = t4 * t263;
  t265 = t264 * t59;
  t268 = t113 * t117;
  t269 = t268 * t70;
  t271 = t228 * t58;
  t272 = t57 * t271;
  t274 = 0.3e1 / 0.4e2 * t272 * t70;
  t276 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t265 * t70 - 0.9e1 / 0.4e2 * t269 + t274);
  tv2rho20 = 0.2e1 * t106 + 0.2e1 * t122 + t5 * (t250 + t276);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t279 = t201 * t126;
  t283 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t207);
  t287 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t279 * t78 + 0.4e1 / 0.3e1 * t22 * t283);
  t288 = t4 * t287;
  t289 = t288 * t28;
  t292 = t130 * t88;
  t293 = t292 * t44;
  t297 = t130 * t98;
  t304 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t289 * t44 - 0.9e1 / 0.8e2 * t293 - 0.9e1 / 0.16e2 * t131 * t93 + 0.7e1 / 0.64e3 * t297 * t102 - 0.9e1 / 0.8e2 * t220 + t232 - 0.3e1 / 0.16e2 * t233 + 0.7e1 / 0.192e4 * t237);
  t305 = t252 * t137;
  t309 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t256);
  t313 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t305 * t109 + 0.4e1 / 0.3e1 * t54 * t309);
  t314 = t4 * t313;
  t315 = t314 * t59;
  t318 = t141 * t117;
  t319 = t318 * t70;
  t324 = t118 * t146;
  t326 = t113 * t151;
  t329 = t87 * t150;
  t330 = t57 * t329;
  t331 = t330 * t155;
  t334 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t315 * t70 - 0.9e1 / 0.8e2 * t319 - 0.9e1 / 0.8e2 * t269 + t274 - 0.9e1 / 0.16e2 * t114 * t146 - 0.3e1 / 0.16e2 * t324 + 0.7e1 / 0.64e3 * t326 * t155 + 0.7e1 / 0.192e4 * t331);
  tv2rho21 = t106 + t122 + t135 + t159 + t5 * (t304 + t334);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t339 = t126 * t126;
  t344 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t207);
  t348 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t339 + 0.4e1 / 0.3e1 * t22 * t344);
  t349 = t4 * t348;
  t350 = t349 * t28;
  t355 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t350 * t44 - 0.9e1 / 0.4e2 * t293 + t232);
  t356 = t137 * t137;
  t361 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t256);
  t365 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t356 + 0.4e1 / 0.3e1 * t54 * t361);
  t366 = t4 * t365;
  t367 = t366 * t59;
  t373 = t141 * t151;
  t379 = t153 * t68 * t43;
  t383 = 0.1e1 / t61 / rho[1];
  t385 = t383 * sigma[2] * t43;
  t389 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t367 * t70 - 0.9e1 / 0.4e2 * t319 - 0.9e1 / 0.8e1 * t142 * t146 + 0.7e1 / 0.32e3 * t373 * t155 + t274 - 0.3e1 / 0.8e1 * t324 + 0.7e1 / 0.96e3 * t331 - 0.3e1 / 0.8e1 * t60 * t379 + 0.7e1 / 0.48e3 * t152 * t385);
  tv2rho22 = 0.2e1 * t135 + 0.2e1 * t159 + t5 * (t355 + t389);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t392 = t82 * t26;
  t395 = t25 * t87;
  t397 = 0.7e1 / 0.192e4 * t395 * t164;
  t399 = t97 * t100 * t43;
  t403 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t392 * t164 - t397 - 0.7e1 / 0.96e3 * t162 * t399);
  tv2rhosigma0 = t5 * t403 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t405 = t113 * t26;
  t408 = t57 * t87;
  t410 = 0.7e1 / 0.192e4 * t408 * t170;
  t412 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t405 * t170 - t410);
  tv2rhosigma2 = t5 * t412 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t414 = t130 * t26;
  t418 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t414 * t164 - t397);
  tv2rhosigma3 = t5 * t418 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t420 = t141 * t26;
  t424 = t150 * t153 * t43;
  t428 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t420 * t170 - t410 - 0.7e1 / 0.96e3 * t168 * t424);
  tv2rhosigma5 = t5 * t428 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t433 = 0.9e1 / 0.8e2 * t236 * t44;
  t438 = t82 * t178;
  t441 = t87 * t177;
  t442 = t25 * t441;
  t444 = 0.7e1 / 0.192e4 * t442 * t181;
  t446 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t224 * t44 + t433 + 0.9e1 / 0.16e2 * t99 * t93 - 0.7e1 / 0.192e4 * t179 * t102 + 0.7e1 / 0.64e3 * t438 * t181 + t444);
  tv2rhotau0 = t5 * t446 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t451 = 0.9e1 / 0.8e2 * t330 * t70;
  t452 = t113 * t190;
  t455 = t87 * t189;
  t456 = t57 * t455;
  t458 = 0.7e1 / 0.192e4 * t456 * t193;
  t460 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t326 * t70 + t451 + 0.7e1 / 0.64e3 * t452 * t193 + t458);
  tv2rhotau1 = t5 * t460 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t464 = t130 * t178;
  t468 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t297 * t44 + t433 + 0.7e1 / 0.64e3 * t464 * t181 + t444);
  tv2rhotau2 = t5 * t468 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t476 = t141 * t190;
  t480 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t373 * t70 + t451 + 0.9e1 / 0.16e2 * t152 * t146 - 0.7e1 / 0.192e4 * t191 * t155 + 0.7e1 / 0.64e3 * t476 * t193 + t458);
  tv2rhotau3 = t5 * t480 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t483 = t177 * t31 * t43;
  t486 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t162 * t483);
  tv2sigmatau0 = t5 * t486;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t488 = t189 * t62 * t43;
  t491 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t168 * t488);
  tv2sigmatau5 = t5 * t491;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t494 = t96 * t96;
  t495 = 0.1e1 / t494;
  t496 = t26 * t495;
  t497 = t25 * t496;
  t501 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t179 * t44 - 0.7e1 / 0.16e3 * t497 * t181);
  tv2tau20 = t5 * t501;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t504 = t149 * t149;
  t505 = 0.1e1 / t504;
  t506 = t26 * t505;
  t507 = t57 * t506;
  t511 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t191 * t70 - 0.7e1 / 0.16e3 * t507 * t193);
  tv2tau22 = t5 * t511;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t514 = t230 * t93;
  t516 = t89 * t240;
  t519 = t244 * t37 * t43;
  t524 = t82 * t229;
  t525 = t524 * t44;
  t527 = t219 * t93;
  t532 = 0.1e1 / t86 / t74;
  t533 = t532 * t27;
  t534 = t25 * t533;
  t536 = t534 * t44 / 0.8e1;
  t537 = t215 * t88;
  t538 = t537 * t44;
  t540 = rho[0] * rho[0];
  t542 = 0.1e1 / t30 / t540;
  t544 = t542 * sigma[0] * t43;
  t548 = 0.1e1 / t200 / t18;
  t549 = t202 * t78;
  t552 = t201 * t78;
  t555 = t74 * t74;
  t556 = 0.1e1 / t555;
  t557 = t15 * t556;
  t560 = my_piecewise5(t9, 0, t13, 0, 0.6e1 * t206 - 0.6e1 * t557);
  t564 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t548 * t549 + 0.4e1 / 0.3e1 * t552 * t210 + 0.4e1 / 0.3e1 * t22 * t560);
  t565 = t4 * t564;
  t566 = t565 * t28;
  t569 = t215 * t98;
  t572 = t82 * t235;
  t573 = t572 * t102;
  t577 = t228 * t97;
  t578 = t25 * t577;
  t579 = t578 * t102;
  t581 = t236 * t246;
  t583 = 0.3e1 / 0.8e1 * t514 - 0.3e1 / 0.8e1 * t516 + t29 * t519 / 0.8e1 - 0.27e2 / 0.16e2 * t216 * t93 + 0.9e1 / 0.4e2 * t525 - 0.9e1 / 0.8e1 * t527 - 0.9e1 / 0.8e1 * t83 * t240 - t536 - 0.27e2 / 0.8e2 * t538 - 0.7e1 / 0.96e3 * t99 * t544 - 0.27e2 / 0.8e2 * t566 * t44 + 0.21e2 / 0.64e3 * t569 * t102 + 0.7e1 / 0.32e3 * t573 + 0.7e1 / 0.16e3 * t224 * t246 - 0.7e1 / 0.96e3 * t579 + 0.7e1 / 0.48e3 * t581;
  t584 = my_piecewise3(t2, 0, t583);
  t586 = 0.1e1 / t251 / t52;
  t587 = t253 * t109;
  t590 = t252 * t109;
  t593 = t49 * t556;
  t596 = my_piecewise5(t13, 0, t9, 0, -0.6e1 * t206 - 0.6e1 * t593);
  t600 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t586 * t587 + 0.4e1 / 0.3e1 * t590 * t259 + 0.4e1 / 0.3e1 * t54 * t596);
  t601 = t4 * t600;
  t602 = t601 * t59;
  t605 = t264 * t117;
  t606 = t605 * t70;
  t608 = t113 * t271;
  t609 = t608 * t70;
  t611 = t532 * t58;
  t612 = t57 * t611;
  t614 = t612 * t70 / 0.8e1;
  t616 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t602 * t70 - 0.27e2 / 0.8e2 * t606 + 0.9e1 / 0.4e2 * t609 - t614);
  tv3rho30 = 0.3e1 * t250 + 0.3e1 * t276 + t5 * (t584 + t616);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t619 = 0.2e1 * t304;
  t620 = 0.2e1 * t334;
  t621 = t288 * t88;
  t623 = 0.9e1 / 0.4e2 * t621 * t44;
  t626 = t130 * t229;
  t627 = t626 * t44;
  t630 = 0.3e1 / 0.8e1 * t292 * t93;
  t638 = t548 * t126;
  t641 = t201 * t283;
  t646 = 0.2e1 * t206;
  t647 = 0.6e1 * t557;
  t649 = my_piecewise5(t9, 0, t13, 0, t646 - t647);
  t653 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t638 * t202 + 0.8e1 / 0.9e1 * t641 * t78 + 0.4e1 / 0.9e1 * t279 * t210 + 0.4e1 / 0.3e1 * t22 * t649);
  t654 = t4 * t653;
  t655 = t654 * t28;
  t658 = t288 * t98;
  t661 = t130 * t235;
  t663 = 0.7e1 / 0.96e3 * t661 * t102;
  t669 = -t623 - 0.9e1 / 0.8e1 * t289 * t93 + 0.3e1 / 0.4e2 * t627 - t630 - 0.3e1 / 0.8e1 * t131 * t240 + t514 / 0.4e1 - t516 / 0.8e1 + 0.3e1 / 0.2e2 * t525 - 0.3e1 / 0.8e1 * t527 - t536 - 0.9e1 / 0.8e2 * t538 - 0.27e2 / 0.8e2 * t655 * t44 + 0.7e1 / 0.32e3 * t658 * t102 + t663 + 0.7e1 / 0.48e3 * t297 * t246 + 0.7e1 / 0.96e3 * t573 - 0.7e1 / 0.144e4 * t579 + 0.7e1 / 0.144e4 * t581;
  t670 = my_piecewise3(t2, 0, t669);
  t671 = t586 * t137;
  t674 = t252 * t309;
  t679 = 0.6e1 * t593;
  t681 = my_piecewise5(t13, 0, t9, 0, -t646 - t679);
  t685 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t671 * t253 + 0.8e1 / 0.9e1 * t674 * t109 + 0.4e1 / 0.9e1 * t305 * t259 + 0.4e1 / 0.3e1 * t54 * t681);
  t686 = t4 * t685;
  t687 = t686 * t59;
  t690 = t314 * t117;
  t692 = 0.9e1 / 0.4e2 * t690 * t70;
  t693 = t141 * t271;
  t694 = t693 * t70;
  t701 = 0.3e1 / 0.8e1 * t268 * t146;
  t702 = t272 * t146;
  t704 = t264 * t151;
  t707 = t113 * t329;
  t709 = 0.7e1 / 0.96e3 * t707 * t155;
  t710 = t228 * t150;
  t711 = t57 * t710;
  t712 = t711 * t155;
  t714 = -0.27e2 / 0.8e2 * t687 * t70 - t692 + 0.3e1 / 0.4e2 * t694 - 0.9e1 / 0.8e2 * t606 + 0.3e1 / 0.2e2 * t609 - t614 - 0.9e1 / 0.16e2 * t265 * t146 - t701 + t702 / 0.8e1 + 0.7e1 / 0.64e3 * t704 * t155 + t709 - 0.7e1 / 0.288e4 * t712;
  t715 = my_piecewise3(t48, 0, t714);
  tv3rho31 = t250 + t276 + t619 + t620 + t5 * (t670 + t715);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t718 = t548 * t339;
  t723 = t201 * t344;
  t727 = my_piecewise5(t9, 0, t13, 0, -t646 - t647);
  t731 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t718 * t78 + 0.8e1 / 0.9e1 * t279 * t283 + 0.4e1 / 0.9e1 * t723 * t78 + 0.4e1 / 0.3e1 * t22 * t727);
  t732 = t4 * t731;
  t733 = t732 * t28;
  t736 = t349 * t88;
  t737 = t736 * t44;
  t741 = t349 * t98;
  t748 = -0.27e2 / 0.8e2 * t733 * t44 - 0.9e1 / 0.8e2 * t737 - 0.9e1 / 0.16e2 * t350 * t93 + 0.7e1 / 0.64e3 * t741 * t102 - t623 + 0.3e1 / 0.2e2 * t627 - t630 + t663 + 0.3e1 / 0.4e2 * t525 - t536 + t514 / 0.8e1 - 0.7e1 / 0.288e4 * t579;
  t749 = my_piecewise3(t2, 0, t748);
  t750 = t586 * t356;
  t755 = t252 * t361;
  t759 = my_piecewise5(t13, 0, t9, 0, t646 - t679);
  t763 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t750 * t109 + 0.8e1 / 0.9e1 * t305 * t309 + 0.4e1 / 0.9e1 * t755 * t109 + 0.4e1 / 0.3e1 * t54 * t759);
  t764 = t4 * t763;
  t765 = t764 * t59;
  t768 = t366 * t117;
  t769 = t768 * t70;
  t774 = t318 * t146;
  t776 = t314 * t151;
  t779 = t141 * t329;
  t780 = t779 * t155;
  t787 = t118 * t379;
  t791 = t330 * t385;
  t793 = -0.27e2 / 0.8e2 * t765 * t70 - 0.9e1 / 0.8e2 * t769 - t692 + 0.3e1 / 0.2e2 * t694 - 0.9e1 / 0.8e1 * t315 * t146 - 0.3e1 / 0.8e1 * t774 + 0.7e1 / 0.32e3 * t776 * t155 + 0.7e1 / 0.96e3 * t780 + 0.3e1 / 0.4e2 * t609 - t614 - t701 + t702 / 0.4e1 + t709 - 0.7e1 / 0.144e4 * t712 - 0.3e1 / 0.8e1 * t114 * t379 - t787 / 0.8e1 + 0.7e1 / 0.48e3 * t326 * t385 + 0.7e1 / 0.144e4 * t791;
  t794 = my_piecewise3(t48, 0, t793);
  tv3rho32 = t619 + t620 + t355 + t389 + t5 * (t749 + t794);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t799 = t339 * t126;
  t806 = my_piecewise5(t9, 0, t13, 0, -0.6e1 * t206 - 0.6e1 * t557);
  t810 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t548 * t799 + 0.4e1 / 0.3e1 * t279 * t344 + 0.4e1 / 0.3e1 * t22 * t806);
  t811 = t4 * t810;
  t812 = t811 * t28;
  t818 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t812 * t44 - 0.27e2 / 0.8e2 * t737 + 0.9e1 / 0.4e2 * t627 - t536);
  t820 = t383 * t68 * t43;
  t835 = rho[1] * rho[1];
  t837 = 0.1e1 / t61 / t835;
  t839 = t837 * sigma[2] * t43;
  t842 = t356 * t137;
  t849 = my_piecewise5(t13, 0, t9, 0, 0.6e1 * t206 - 0.6e1 * t593);
  t853 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t586 * t842 + 0.4e1 / 0.3e1 * t305 * t361 + 0.4e1 / 0.3e1 * t54 * t849);
  t854 = t4 * t853;
  t855 = t854 * t59;
  t858 = t366 * t151;
  t863 = t60 * t820 / 0.8e1 - 0.27e2 / 0.16e2 * t367 * t146 - 0.9e1 / 0.8e1 * t142 * t379 - 0.9e1 / 0.8e1 * t774 + 0.7e1 / 0.32e3 * t780 - 0.3e1 / 0.8e1 * t787 + 0.7e1 / 0.48e3 * t791 - 0.7e1 / 0.96e3 * t712 - 0.27e2 / 0.8e2 * t769 + 0.9e1 / 0.4e2 * t694 + 0.3e1 / 0.8e1 * t702 - t614 - 0.7e1 / 0.96e3 * t152 * t839 - 0.27e2 / 0.8e2 * t855 * t70 + 0.21e2 / 0.64e3 * t858 * t155 + 0.7e1 / 0.16e3 * t373 * t385;
  t864 = my_piecewise3(t48, 0, t863);
  tv3rho33 = 0.3e1 * t355 + 0.3e1 * t389 + t5 * (t818 + t864);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t868 = t215 * t26;
  t871 = t82 * t87;
  t872 = t871 * t164;
  t876 = t25 * t228;
  t878 = 0.7e1 / 0.288e4 * t876 * t164;
  t879 = t395 * t399;
  t882 = t97 * t244 * t43;
  t886 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t868 * t164 - 0.7e1 / 0.96e3 * t872 - 0.7e1 / 0.48e3 * t392 * t399 + t878 - 0.7e1 / 0.144e4 * t879 + 0.7e1 / 0.288e4 * t162 * t882);
  tv3rho2sigma0 = t5 * t886 + 0.2e1 * t403;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t889 = t264 * t26;
  t892 = t113 * t87;
  t893 = t892 * t170;
  t895 = t57 * t228;
  t897 = 0.7e1 / 0.288e4 * t895 * t170;
  t899 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t889 * t170 - 0.7e1 / 0.96e3 * t893 + t897);
  tv3rho2sigma2 = t5 * t899 + 0.2e1 * t412;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t901 = t288 * t26;
  t904 = t130 * t87;
  t905 = t904 * t164;
  t912 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t901 * t164 - 0.7e1 / 0.192e4 * t905 - 0.7e1 / 0.96e3 * t414 * t399 - 0.7e1 / 0.192e4 * t872 + t878 - 0.7e1 / 0.288e4 * t879);
  tv3rho2sigma3 = t5 * t912 + t403 + t418;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t914 = t314 * t26;
  t917 = t141 * t87;
  t918 = t917 * t170;
  t923 = t408 * t424;
  t926 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t914 * t170 - 0.7e1 / 0.192e4 * t918 - 0.7e1 / 0.192e4 * t893 + t897 - 0.7e1 / 0.96e3 * t405 * t424 - 0.7e1 / 0.288e4 * t923);
  tv3rho2sigma5 = t5 * t926 + t412 + t428;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t929 = t349 * t26;
  t934 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t929 * t164 - 0.7e1 / 0.96e3 * t905 + t878);
  tv3rho2sigma6 = t5 * t934 + 0.2e1 * t418;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t937 = t366 * t26;
  t945 = t150 * t383 * t43;
  t949 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t937 * t170 - 0.7e1 / 0.96e3 * t918 - 0.7e1 / 0.48e3 * t420 * t424 + t897 - 0.7e1 / 0.144e4 * t923 + 0.7e1 / 0.288e4 * t168 * t945);
  tv3rho2sigma8 = t5 * t949 + 0.2e1 * t428;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t954 = t572 * t44;
  t961 = 0.3e1 / 0.4e2 * t578 * t44;
  t962 = t236 * t93;
  t964 = t442 * t102;
  t970 = t215 * t178;
  t973 = t82 * t441;
  t974 = t973 * t181;
  t976 = t228 * t177;
  t977 = t25 * t976;
  t979 = 0.7e1 / 0.288e4 * t977 * t181;
  t980 = 0.27e2 / 0.8e2 * t569 * t44 + 0.9e1 / 0.4e2 * t954 + 0.9e1 / 0.8e1 * t224 * t93 - 0.7e1 / 0.96e3 * t438 * t102 - t961 + 0.3e1 / 0.8e1 * t962 - 0.7e1 / 0.288e4 * t964 + 0.3e1 / 0.8e1 * t99 * t240 - 0.49e2 / 0.288e4 * t179 * t246 + 0.7e1 / 0.64e3 * t970 * t181 + 0.7e1 / 0.96e3 * t974 - t979;
  t981 = my_piecewise3(t2, 0, t980);
  tv3rho2tau0 = t5 * t981 + 0.2e1 * t446;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t986 = t707 * t70;
  t989 = 0.3e1 / 0.4e2 * t711 * t70;
  t990 = t264 * t190;
  t993 = t113 * t455;
  t994 = t993 * t193;
  t996 = t228 * t189;
  t997 = t57 * t996;
  t999 = 0.7e1 / 0.288e4 * t997 * t193;
  t1001 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t704 * t70 + 0.9e1 / 0.4e2 * t986 - t989 + 0.7e1 / 0.64e3 * t990 * t193 + 0.7e1 / 0.96e3 * t994 - t999);
  tv3rho2tau1 = t5 * t1001 + 0.2e1 * t460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1005 = t661 * t44;
  t1014 = t288 * t178;
  t1017 = t130 * t441;
  t1018 = t1017 * t181;
  t1021 = 0.27e2 / 0.8e2 * t658 * t44 + 0.9e1 / 0.8e2 * t1005 + 0.9e1 / 0.16e2 * t297 * t93 - 0.7e1 / 0.192e4 * t464 * t102 + 0.9e1 / 0.8e2 * t954 - t961 + 0.3e1 / 0.16e2 * t962 - 0.7e1 / 0.576e4 * t964 + 0.7e1 / 0.64e3 * t1014 * t181 + 0.7e1 / 0.192e4 * t1018 + 0.7e1 / 0.192e4 * t974 - t979;
  t1022 = my_piecewise3(t2, 0, t1021);
  tv3rho2tau2 = t5 * t1022 + t446 + t468;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1026 = t779 * t70;
  t1031 = t330 * t146;
  t1035 = t456 * t155;
  t1037 = t314 * t190;
  t1040 = t141 * t455;
  t1041 = t1040 * t193;
  t1044 = 0.27e2 / 0.8e2 * t776 * t70 + 0.9e1 / 0.8e2 * t1026 + 0.9e1 / 0.8e2 * t986 - t989 + 0.9e1 / 0.16e2 * t326 * t146 + 0.3e1 / 0.16e2 * t1031 - 0.7e1 / 0.192e4 * t452 * t155 - 0.7e1 / 0.576e4 * t1035 + 0.7e1 / 0.64e3 * t1037 * t193 + 0.7e1 / 0.192e4 * t1041 + 0.7e1 / 0.192e4 * t994 - t999;
  t1045 = my_piecewise3(t48, 0, t1044);
  tv3rho2tau3 = t5 * t1045 + t460 + t480;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t1051 = t349 * t178;
  t1056 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t741 * t44 + 0.9e1 / 0.4e2 * t1005 - t961 + 0.7e1 / 0.64e3 * t1051 * t181 + 0.7e1 / 0.96e3 * t1018 - t979);
  tv3rho2tau4 = t5 * t1056 + 0.2e1 * t468;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t1072 = t366 * t190;
  t1076 = 0.27e2 / 0.8e2 * t858 * t70 + 0.9e1 / 0.4e2 * t1026 + 0.9e1 / 0.8e1 * t373 * t146 - 0.7e1 / 0.96e3 * t476 * t155 - t989 + 0.3e1 / 0.8e1 * t1031 - 0.7e1 / 0.288e4 * t1035 + 0.3e1 / 0.8e1 * t152 * t379 - 0.49e2 / 0.288e4 * t191 * t385 + 0.7e1 / 0.64e3 * t1072 * t193 + 0.7e1 / 0.96e3 * t1041 - t999;
  t1077 = my_piecewise3(t48, 0, t1076);
  tv3rho2tau5 = t5 * t1077 + 0.2e1 * t480;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t1082 = 0.7e1 / 0.96e3 * t395 * t483;
  t1084 = t177 * t100 * t43;
  t1088 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t392 * t483 + t1082 + 0.7e1 / 0.48e3 * t162 * t1084);
  tv3rhosigmatau0 = t5 * t1088 + t486;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t1093 = 0.7e1 / 0.96e3 * t408 * t488;
  t1095 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t405 * t488 + t1093);
  tv3rhosigmatau5 = t5 * t1095 + t491;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t1100 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t414 * t483 + t1082);
  tv3rhosigmatau6 = t5 * t1100 + t486;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t1105 = t189 * t153 * t43;
  t1109 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t420 * t488 + t1093 + 0.7e1 / 0.48e3 * t168 * t1105);
  tv3rhosigmatau11 = t5 * t1109 + t491;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t1114 = 0.9e1 / 0.4e2 * t442 * t44;
  t1119 = t82 * t496;
  t1122 = t87 * t495;
  t1123 = t25 * t1122;
  t1125 = 0.7e1 / 0.48e3 * t1123 * t181;
  t1127 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t438 * t44 - t1114 - 0.9e1 / 0.8e1 * t179 * t93 - 0.7e1 / 0.96e3 * t497 * t102 - 0.7e1 / 0.16e3 * t1119 * t181 - t1125);
  tv3rhotau20 = t5 * t1127 + t501;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t1132 = 0.9e1 / 0.4e2 * t456 * t70;
  t1133 = t113 * t506;
  t1136 = t87 * t505;
  t1137 = t57 * t1136;
  t1139 = 0.7e1 / 0.48e3 * t1137 * t193;
  t1141 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t452 * t70 - t1132 - 0.7e1 / 0.16e3 * t1133 * t193 - t1139);
  tv3rhotau22 = t5 * t1141 + t511;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t1145 = t130 * t496;
  t1149 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t464 * t44 - t1114 - 0.7e1 / 0.16e3 * t1145 * t181 - t1125);
  tv3rhotau23 = t5 * t1149 + t501;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t1157 = t141 * t506;
  t1161 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t476 * t70 - t1132 - 0.9e1 / 0.8e1 * t191 * t146 - 0.7e1 / 0.96e3 * t507 * t155 - 0.7e1 / 0.16e3 * t1157 * t193 - t1139);
  tv3rhotau25 = t5 * t1161 + t511;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t1164 = t495 * t31 * t43;
  t1167 = my_piecewise3(t2, 0, -0.21e2 / 0.32e3 * t162 * t1164);
  tv3sigmatau20 = t5 * t1167;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t1169 = t505 * t62 * t43;
  t1172 = my_piecewise3(t48, 0, -0.21e2 / 0.32e3 * t168 * t1169);
  tv3sigmatau28 = t5 * t1172;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t1176 = 0.1e1 / t494 / tau[0];
  t1177 = t26 * t1176;
  t1178 = t25 * t1177;
  t1182 = my_piecewise3(t2, 0, 0.81e2 / 0.4e2 * t497 * t44 + 0.63e2 / 0.32e3 * t1178 * t181);
  tv3tau30 = t5 * t1182;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t1186 = 0.1e1 / t504 / tau[1];
  t1187 = t26 * t1186;
  t1188 = t57 * t1187;
  t1192 = my_piecewise3(t48, 0, 0.81e2 / 0.4e2 * t507 * t70 + 0.63e2 / 0.32e3 * t1188 * t193);
  tv3tau33 = t5 * t1192;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t37, t40, t42, t43, t44, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t60, t61, t62, t68, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t83, t86;
  double t87, t88, t89, t91, t93, t96, t97, t98;
  double t99, t100, t102, t106, t107, t109, t112, t113;
  double t114, t117, t118, t120, t122, tvrho0, t126, t129;
  double t130, t131, t135, t137, t140, t141, t142, t146;
  double t149, t150, t151, t152, t153, t155, t159, tvrho1;
  double t162, t164, t167, tvsigma0, tvsigma1, t168, t170, t173;
  double tvsigma2, tvlapl0, tvlapl1, t177, t178, t179, t181, t185;
  double tvtau0, t189, t190, t191, t193, t197, tvtau1;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t216, t219, t220, t224, t228, t229, t230;
  double t232, t233, t235, t236, t237, t240, t244, t246;
  double t250, t251, t252, t253, t256, t259, t263, t264;
  double t265, t268, t269, t271, t272, t274, t276, tv2rho20;
  double t279, t283, t287, t288, t289, t292, t293, t297;
  double t304, t305, t309, t313, t314, t315, t318, t319;
  double t324, t326, t329, t330, t331, t334, tv2rho21, t339;
  double t344, t348, t349, t350, t355, t356, t361, t365;
  double t366, t367, t373, t379, t383, t385, t389, tv2rho22;
  double t392, t395, t397, t399, t403, tv2rhosigma0, tv2rhosigma1, t405;
  double t408, t410, t412, tv2rhosigma2, t414, t418, tv2rhosigma3, tv2rhosigma4;
  double t420, t424, t428, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t433, t438, t441, t442, t444, t446, tv2rhotau0, t451;
  double t452, t455, t456, t458, t460, tv2rhotau1, t464, t468;
  double tv2rhotau2, t476, t480, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double t483, t486, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t488;
  double t491, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t494, t495, t496, t497, t501, tv2tau20, tv2tau21;
  double t504, t505, t506, t507, t511, tv2tau22;

  double t514, t516, t519, t524, t525, t527, t532, t533;
  double t534, t536, t537, t538, t540, t542, t544, t548;
  double t549, t552, t555, t556, t557, t560, t564, t565;
  double t566, t569, t572, t573, t577, t578, t579, t581;
  double t583, t584, t586, t587, t590, t593, t596, t600;
  double t601, t602, t605, t606, t608, t609, t611, t612;
  double t614, t616, tv3rho30, t619, t620, t621, t623, t626;
  double t627, t630, t638, t641, t646, t647, t649, t653;
  double t654, t655, t658, t661, t663, t669, t670, t671;
  double t674, t679, t681, t685, t686, t687, t690, t692;
  double t693, t694, t701, t702, t704, t707, t709, t710;
  double t711, t712, t714, t715, tv3rho31, t718, t723, t727;
  double t731, t732, t733, t736, t737, t741, t748, t749;
  double t750, t755, t759, t763, t764, t765, t768, t769;
  double t774, t776, t779, t780, t787, t791, t793, t794;
  double tv3rho32, t799, t806, t810, t811, t812, t818, t820;
  double t835, t837, t839, t842, t849, t853, t854, t855;
  double t858, t863, t864, tv3rho33, t868, t871, t872, t876;
  double t878, t879, t882, t886, tv3rho2sigma0, tv3rho2sigma1, t889, t892;
  double t893, t895, t897, t899, tv3rho2sigma2, t901, t904, t905;
  double t912, tv3rho2sigma3, tv3rho2sigma4, t914, t917, t918, t923, t926;
  double tv3rho2sigma5, t929, t934, tv3rho2sigma6, tv3rho2sigma7, t937, t945, t949;
  double tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t954;
  double t961, t962, t964, t970, t973, t974, t976, t977;
  double t979, t980, t981, tv3rho2tau0, t986, t989, t990, t993;
  double t994, t996, t997, t999, t1001, tv3rho2tau1, t1005, t1014;
  double t1017, t1018, t1021, t1022, tv3rho2tau2, t1026, t1031, t1035;
  double t1037, t1040, t1041, t1044, t1045, tv3rho2tau3, t1051, t1056;
  double tv3rho2tau4, t1072, t1076, t1077, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t1082, t1084, t1088;
  double tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t1093, t1095, tv3rhosigmatau5;
  double t1100, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t1105, t1109;
  double tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0;
  double tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t1114;
  double t1119, t1122, t1123, t1125, t1127, tv3rhotau20, tv3rhotau21, t1132;
  double t1133, t1136, t1137, t1139, t1141, tv3rhotau22, t1145, t1149;
  double tv3rhotau23, tv3rhotau24, t1157, t1161, tv3rhotau25, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0;
  double tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8;
  double tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4;
  double tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t1164, t1167, tv3sigmatau20, tv3sigmatau21;
  double tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t1169, t1172;
  double tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, t1176, t1177, t1178, t1182, tv3tau30, tv3tau31, tv3tau32;
  double t1186, t1187, t1188, t1192, tv3tau33;

  double t1196, t1198, t1199, t1201, t1203, t1204, t1210, t1216;
  double t1217, t1220, t1224, t1229, t1232, t1234, t1236, t1252;
  double t1254, t1255, t1256, t1258, t1263, t1264, t1266, t1269;
  double t1273, t1274, t1279, t1281, t1283, t1285, t1291, t1293;
  double t1294, t1296, t1297, t1303, t1308, t1311, t1315, t1321;
  double t1324, t1327, t1332, t1334, tv4rho40, t1354, t1357, t1358;
  double t1359, t1360, t1380, t1381, t1383, t1387, t1392, t1396;
  double t1398, t1399, t1403, t1404, t1405, t1410, t1411, t1412;
  double t1417, t1419, t1421, t1438, t1440, t1444, t1450, t1453;
  double t1454, t1456, t1463, t1465, t1466, t1467, t1469, t1472;
  double t1473, t1475, t1476, t1477, t1479, t1480, t1482, t1483;
  double tv4rho41, t1502, t1511, t1513, t1525, t1538, t1542, t1547;
  double t1550, t1551, t1556, t1558, t1560, t1572, t1574, t1575;
  double t1576, t1578, t1580, t1582, t1585, t1587, t1589, t1591;
  double t1592, t1595, t1599, t1614, t1627, t1631, t1636, t1638;
  double tv4rho42, t1659, t1663, t1669, t1673, t1684, t1685, t1698;
  double t1701, t1703, t1705, t1708, t1710, t1711, t1713, t1715;
  double t1743, t1747, t1752, t1755, t1757, tv4rho43, t1762, t1767;
  double t1774, t1778, t1787, t1799, t1810, t1815, t1822, t1826;
  double t1831, t1849, t1851, tv4rho44, t1859, t1864, t1866, t1872;
  double t1873, t1875, t1882, tv4rho3sigma0, tv4rho3sigma1, t1889, t1892, t1896;
  double t1898, tv4rho3sigma2, t1900, t1906, t1910, t1913, t1921, t1922;
  double tv4rho3sigma3, tv4rho3sigma4, t1924, t1930, t1932, t1939, t1940, t1943;
  double tv4rho3sigma5, t1949, t1957, tv4rho3sigma6, tv4rho3sigma7, t1963, t1968, t1974;
  double t1976, t1977, tv4rho3sigma8, t1986, tv4rho3sigma9, tv4rho3sigma10, t2006, tv4rho3sigma11;
  double tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7;
  double t2009, t2020, t2024, t2027, t2030, t2035, t2036, t2040;
  double t2042, t2047, t2048, t2050, t2054, t2055, tv4rho3tau0, t2060;
  double t2062, t2065, t2070, t2073, t2078, t2080, tv4rho3tau1, t2082;
  double t2087, t2089, t2092, t2095, t2098, t2102, t2110, t2121;
  double t2123, tv4rho3tau2, t2125, t2129, t2130, t2137, t2138, t2143;
  double t2144, t2151, t2153, t2157, t2158, tv4rho3tau3, t2162, t2176;
  double t2180, t2181, tv4rho3tau4, t2185, t2190, t2194, t2198, t2202;
  double t2206, t2212, t2216, t2218, tv4rho3tau5, t2231, tv4rho3tau6, t2261;
  double t2262, tv4rho3tau7, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25;
  double tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211, tv4rho2sigma212, tv4rho2sigma213;
  double tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3;
  double tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11;
  double tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, tv4rho2sigmalapl17, t2267, t2272;
  double t2273, t2280, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, t2285;
  double t2288, t2290, tv4rho2sigmatau5, t2294, t2301, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8;
  double tv4rho2sigmatau9, tv4rho2sigmatau10, t2305, t2310, t2313, tv4rho2sigmatau11, t2320, tv4rho2sigmatau12;
  double tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t2334, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21;
  double tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0;
  double tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t2339, t2346, t2347, t2349, t2359;
  double t2364, t2365, t2366, tv4rho2tau20, tv4rho2tau21, t2371, t2374, t2379;
  double t2384, t2386, tv4rho2tau22, t2390, t2403, t2406, t2407, tv4rho2tau23;
  double tv4rho2tau24, t2411, t2416, t2420, t2426, t2429, t2430, tv4rho2tau25;
  double t2441, tv4rho2tau26, tv4rho2tau27, t2461, t2462, tv4rho2tau28, tv4rhosigma30, tv4rhosigma31;
  double tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, tv4rhosigma39;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5;
  double tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13;
  double tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21;
  double tv4rhosigma2lapl22, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5;
  double tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13;
  double tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21;
  double tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25;
  double tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213;
  double tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3;
  double tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11;
  double tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19;
  double tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t2467, t2473, tv4rhosigmatau20, tv4rhosigmatau21;
  double tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, t2478, t2480;
  double tv4rhosigmatau28, t2485, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214;
  double tv4rhosigmatau215, tv4rhosigmatau216, t2494, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33;
  double tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3;
  double tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11;
  double tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27;
  double tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t2499, t2510, t2512, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, t2517, t2524, t2526, tv4rhotau33, t2534, tv4rhotau34;
  double tv4rhotau35, tv4rhotau36, t2546, tv4rhotau37, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43;
  double tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, tv4sigma3tau0;
  double tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8;
  double tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16;
  double tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24;
  double tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212;
  double tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2;
  double tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10;
  double tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18;
  double tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22;
  double tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210;
  double tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30;
  double tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38;
  double tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4;
  double tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12;
  double tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22;
  double tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210;
  double tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t2552;
  double tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37;
  double tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t2557, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42;
  double tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5;
  double tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25;
  double tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34;
  double tv4lapltau35, tv4lapltau36, tv4lapltau37, t2567, tv4tau40, tv4tau41, tv4tau42, tv4tau43;
  double t2577, tv4tau44;


  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t27 = 0.1e1 / tau[0];
  t28 = t26 * t27;
  t29 = t25 * t28;
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t37 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[0] / rho[0] * t27;
  t40 = POW_1_3(0.1e1 / M_PI);
  t42 = M_CBRT4;
  t43 = 0.1e1 / t40 * t42;
  t44 = t31 * rho[0] * t37 * t43;
  t47 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t29 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t58 = 0.1e1 / tau[1];
  t59 = t26 * t58;
  t60 = t57 * t59;
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t68 = 0.1e1 + 0.7e1 / 0.216e3 * sigma[2] / rho[1] * t58;
  t70 = t62 * rho[1] * t68 * t43;
  t73 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t60 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t83 = t82 * t28;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t88 = t87 * t27;
  t89 = t25 * t88;
  t91 = 0.9e1 / 0.8e2 * t89 * t44;
  t93 = t31 * t37 * t43;
  t96 = tau[0] * tau[0];
  t97 = 0.1e1 / t96;
  t98 = t26 * t97;
  t99 = t25 * t98;
  t100 = 0.1e1 / t30;
  t102 = t100 * sigma[0] * t43;
  t106 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t83 * t44 - t91 - 0.9e1 / 0.16e2 * t29 * t93 + 0.7e1 / 0.64e3 * t99 * t102);
  t107 = t49 * t75;
  t109 = my_piecewise5(t13, 0, t9, 0, -t6 - t107);
  t112 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t109);
  t113 = t4 * t112;
  t114 = t113 * t59;
  t117 = t87 * t58;
  t118 = t57 * t117;
  t120 = 0.9e1 / 0.8e2 * t118 * t70;
  t122 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t114 * t70 - t120);
  tvrho0 = t47 + t73 + t5 * (t106 + t122);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t126 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t129 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t126);
  t130 = t4 * t129;
  t131 = t130 * t28;
  t135 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t131 * t44 - t91);
  t137 = my_piecewise5(t13, 0, t9, 0, t6 - t107);
  t140 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t137);
  t141 = t4 * t140;
  t142 = t141 * t59;
  t146 = t62 * t68 * t43;
  t149 = tau[1] * tau[1];
  t150 = 0.1e1 / t149;
  t151 = t26 * t150;
  t152 = t57 * t151;
  t153 = 0.1e1 / t61;
  t155 = t153 * sigma[2] * t43;
  t159 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t142 * t70 - t120 - 0.9e1 / 0.16e2 * t60 * t146 + 0.7e1 / 0.64e3 * t152 * t155);
  tvrho1 = t47 + t73 + t5 * (t135 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t162 = t25 * t26;
  t164 = t97 * t31 * t43;
  t167 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t162 * t164);
  tvsigma0 = t5 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t168 = t57 * t26;
  t170 = t150 * t62 * t43;
  t173 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t168 * t170);
  tvsigma2 = t5 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = 0.1e1 / t96 / tau[0];
  t178 = t26 * t177;
  t179 = t25 * t178;
  t181 = t31 * sigma[0] * t43;
  t185 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t99 * t44 + 0.7e1 / 0.64e3 * t179 * t181);
  tvtau0 = t5 * t185;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t189 = 0.1e1 / t149 / tau[1];
  t190 = t26 * t189;
  t191 = t57 * t190;
  t193 = t62 * sigma[2] * t43;
  t197 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t152 * t70 + 0.7e1 / 0.64e3 * t191 * t193);
  tvtau1 = t5 * t197;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t200 = t22 * t22;
  t201 = 0.1e1 / t200;
  t202 = t78 * t78;
  t205 = t74 * t5;
  t206 = 0.1e1 / t205;
  t207 = t15 * t206;
  t210 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t207);
  t214 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t22 * t210);
  t215 = t4 * t214;
  t216 = t215 * t28;
  t219 = t82 * t88;
  t220 = t219 * t44;
  t224 = t82 * t98;
  t228 = 0.1e1 / t86 / t5;
  t229 = t228 * t27;
  t230 = t25 * t229;
  t232 = 0.3e1 / 0.4e2 * t230 * t44;
  t233 = t89 * t93;
  t235 = t87 * t97;
  t236 = t25 * t235;
  t237 = t236 * t102;
  t240 = t100 * t37 * t43;
  t244 = 0.1e1 / t30 / rho[0];
  t246 = t244 * sigma[0] * t43;
  t250 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t216 * t44 - 0.9e1 / 0.4e2 * t220 - 0.9e1 / 0.8e1 * t83 * t93 + 0.7e1 / 0.32e3 * t224 * t102 + t232 - 0.3e1 / 0.8e1 * t233 + 0.7e1 / 0.96e3 * t237 - 0.3e1 / 0.8e1 * t29 * t240 + 0.7e1 / 0.48e3 * t99 * t246);
  t251 = t54 * t54;
  t252 = 0.1e1 / t251;
  t253 = t109 * t109;
  t256 = t49 * t206;
  t259 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t256);
  t263 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t253 + 0.4e1 / 0.3e1 * t54 * t259);
  t264 = t4 * t263;
  t265 = t264 * t59;
  t268 = t113 * t117;
  t269 = t268 * t70;
  t271 = t228 * t58;
  t272 = t57 * t271;
  t274 = 0.3e1 / 0.4e2 * t272 * t70;
  t276 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t265 * t70 - 0.9e1 / 0.4e2 * t269 + t274);
  tv2rho20 = 0.2e1 * t106 + 0.2e1 * t122 + t5 * (t250 + t276);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t279 = t201 * t126;
  t283 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t207);
  t287 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t279 * t78 + 0.4e1 / 0.3e1 * t22 * t283);
  t288 = t4 * t287;
  t289 = t288 * t28;
  t292 = t130 * t88;
  t293 = t292 * t44;
  t297 = t130 * t98;
  t304 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t289 * t44 - 0.9e1 / 0.8e2 * t293 - 0.9e1 / 0.16e2 * t131 * t93 + 0.7e1 / 0.64e3 * t297 * t102 - 0.9e1 / 0.8e2 * t220 + t232 - 0.3e1 / 0.16e2 * t233 + 0.7e1 / 0.192e4 * t237);
  t305 = t252 * t137;
  t309 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t256);
  t313 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t305 * t109 + 0.4e1 / 0.3e1 * t54 * t309);
  t314 = t4 * t313;
  t315 = t314 * t59;
  t318 = t141 * t117;
  t319 = t318 * t70;
  t324 = t118 * t146;
  t326 = t113 * t151;
  t329 = t87 * t150;
  t330 = t57 * t329;
  t331 = t330 * t155;
  t334 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t315 * t70 - 0.9e1 / 0.8e2 * t319 - 0.9e1 / 0.8e2 * t269 + t274 - 0.9e1 / 0.16e2 * t114 * t146 - 0.3e1 / 0.16e2 * t324 + 0.7e1 / 0.64e3 * t326 * t155 + 0.7e1 / 0.192e4 * t331);
  tv2rho21 = t106 + t122 + t135 + t159 + t5 * (t304 + t334);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t339 = t126 * t126;
  t344 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t207);
  t348 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t201 * t339 + 0.4e1 / 0.3e1 * t22 * t344);
  t349 = t4 * t348;
  t350 = t349 * t28;
  t355 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t350 * t44 - 0.9e1 / 0.4e2 * t293 + t232);
  t356 = t137 * t137;
  t361 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t256);
  t365 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t252 * t356 + 0.4e1 / 0.3e1 * t54 * t361);
  t366 = t4 * t365;
  t367 = t366 * t59;
  t373 = t141 * t151;
  t379 = t153 * t68 * t43;
  t383 = 0.1e1 / t61 / rho[1];
  t385 = t383 * sigma[2] * t43;
  t389 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t367 * t70 - 0.9e1 / 0.4e2 * t319 - 0.9e1 / 0.8e1 * t142 * t146 + 0.7e1 / 0.32e3 * t373 * t155 + t274 - 0.3e1 / 0.8e1 * t324 + 0.7e1 / 0.96e3 * t331 - 0.3e1 / 0.8e1 * t60 * t379 + 0.7e1 / 0.48e3 * t152 * t385);
  tv2rho22 = 0.2e1 * t135 + 0.2e1 * t159 + t5 * (t355 + t389);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t392 = t82 * t26;
  t395 = t25 * t87;
  t397 = 0.7e1 / 0.192e4 * t395 * t164;
  t399 = t97 * t100 * t43;
  t403 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t392 * t164 - t397 - 0.7e1 / 0.96e3 * t162 * t399);
  tv2rhosigma0 = t5 * t403 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t405 = t113 * t26;
  t408 = t57 * t87;
  t410 = 0.7e1 / 0.192e4 * t408 * t170;
  t412 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t405 * t170 - t410);
  tv2rhosigma2 = t5 * t412 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t414 = t130 * t26;
  t418 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t414 * t164 - t397);
  tv2rhosigma3 = t5 * t418 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t420 = t141 * t26;
  t424 = t150 * t153 * t43;
  t428 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t420 * t170 - t410 - 0.7e1 / 0.96e3 * t168 * t424);
  tv2rhosigma5 = t5 * t428 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t433 = 0.9e1 / 0.8e2 * t236 * t44;
  t438 = t82 * t178;
  t441 = t87 * t177;
  t442 = t25 * t441;
  t444 = 0.7e1 / 0.192e4 * t442 * t181;
  t446 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t224 * t44 + t433 + 0.9e1 / 0.16e2 * t99 * t93 - 0.7e1 / 0.192e4 * t179 * t102 + 0.7e1 / 0.64e3 * t438 * t181 + t444);
  tv2rhotau0 = t5 * t446 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t451 = 0.9e1 / 0.8e2 * t330 * t70;
  t452 = t113 * t190;
  t455 = t87 * t189;
  t456 = t57 * t455;
  t458 = 0.7e1 / 0.192e4 * t456 * t193;
  t460 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t326 * t70 + t451 + 0.7e1 / 0.64e3 * t452 * t193 + t458);
  tv2rhotau1 = t5 * t460 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t464 = t130 * t178;
  t468 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t297 * t44 + t433 + 0.7e1 / 0.64e3 * t464 * t181 + t444);
  tv2rhotau2 = t5 * t468 + t185;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t476 = t141 * t190;
  t480 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t373 * t70 + t451 + 0.9e1 / 0.16e2 * t152 * t146 - 0.7e1 / 0.192e4 * t191 * t155 + 0.7e1 / 0.64e3 * t476 * t193 + t458);
  tv2rhotau3 = t5 * t480 + t197;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t483 = t177 * t31 * t43;
  t486 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t162 * t483);
  tv2sigmatau0 = t5 * t486;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t488 = t189 * t62 * t43;
  t491 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t168 * t488);
  tv2sigmatau5 = t5 * t491;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t494 = t96 * t96;
  t495 = 0.1e1 / t494;
  t496 = t26 * t495;
  t497 = t25 * t496;
  t501 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t179 * t44 - 0.7e1 / 0.16e3 * t497 * t181);
  tv2tau20 = t5 * t501;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t504 = t149 * t149;
  t505 = 0.1e1 / t504;
  t506 = t26 * t505;
  t507 = t57 * t506;
  t511 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t191 * t70 - 0.7e1 / 0.16e3 * t507 * t193);
  tv2tau22 = t5 * t511;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t514 = t230 * t93;
  t516 = t89 * t240;
  t519 = t244 * t37 * t43;
  t524 = t82 * t229;
  t525 = t524 * t44;
  t527 = t219 * t93;
  t532 = 0.1e1 / t86 / t74;
  t533 = t532 * t27;
  t534 = t25 * t533;
  t536 = t534 * t44 / 0.8e1;
  t537 = t215 * t88;
  t538 = t537 * t44;
  t540 = rho[0] * rho[0];
  t542 = 0.1e1 / t30 / t540;
  t544 = t542 * sigma[0] * t43;
  t548 = 0.1e1 / t200 / t18;
  t549 = t202 * t78;
  t552 = t201 * t78;
  t555 = t74 * t74;
  t556 = 0.1e1 / t555;
  t557 = t15 * t556;
  t560 = my_piecewise5(t9, 0, t13, 0, 0.6e1 * t206 - 0.6e1 * t557);
  t564 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t548 * t549 + 0.4e1 / 0.3e1 * t552 * t210 + 0.4e1 / 0.3e1 * t22 * t560);
  t565 = t4 * t564;
  t566 = t565 * t28;
  t569 = t215 * t98;
  t572 = t82 * t235;
  t573 = t572 * t102;
  t577 = t228 * t97;
  t578 = t25 * t577;
  t579 = t578 * t102;
  t581 = t236 * t246;
  t583 = 0.3e1 / 0.8e1 * t514 - 0.3e1 / 0.8e1 * t516 + t29 * t519 / 0.8e1 - 0.27e2 / 0.16e2 * t216 * t93 + 0.9e1 / 0.4e2 * t525 - 0.9e1 / 0.8e1 * t527 - 0.9e1 / 0.8e1 * t83 * t240 - t536 - 0.27e2 / 0.8e2 * t538 - 0.7e1 / 0.96e3 * t99 * t544 - 0.27e2 / 0.8e2 * t566 * t44 + 0.21e2 / 0.64e3 * t569 * t102 + 0.7e1 / 0.32e3 * t573 + 0.7e1 / 0.16e3 * t224 * t246 - 0.7e1 / 0.96e3 * t579 + 0.7e1 / 0.48e3 * t581;
  t584 = my_piecewise3(t2, 0, t583);
  t586 = 0.1e1 / t251 / t52;
  t587 = t253 * t109;
  t590 = t252 * t109;
  t593 = t49 * t556;
  t596 = my_piecewise5(t13, 0, t9, 0, -0.6e1 * t206 - 0.6e1 * t593);
  t600 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t586 * t587 + 0.4e1 / 0.3e1 * t590 * t259 + 0.4e1 / 0.3e1 * t54 * t596);
  t601 = t4 * t600;
  t602 = t601 * t59;
  t605 = t264 * t117;
  t606 = t605 * t70;
  t608 = t113 * t271;
  t609 = t608 * t70;
  t611 = t532 * t58;
  t612 = t57 * t611;
  t614 = t612 * t70 / 0.8e1;
  t616 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t602 * t70 - 0.27e2 / 0.8e2 * t606 + 0.9e1 / 0.4e2 * t609 - t614);
  tv3rho30 = 0.3e1 * t250 + 0.3e1 * t276 + t5 * (t584 + t616);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t619 = 0.2e1 * t304;
  t620 = 0.2e1 * t334;
  t621 = t288 * t88;
  t623 = 0.9e1 / 0.4e2 * t621 * t44;
  t626 = t130 * t229;
  t627 = t626 * t44;
  t630 = 0.3e1 / 0.8e1 * t292 * t93;
  t638 = t548 * t126;
  t641 = t201 * t283;
  t646 = 0.2e1 * t206;
  t647 = 0.6e1 * t557;
  t649 = my_piecewise5(t9, 0, t13, 0, t646 - t647);
  t653 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t638 * t202 + 0.8e1 / 0.9e1 * t641 * t78 + 0.4e1 / 0.9e1 * t279 * t210 + 0.4e1 / 0.3e1 * t22 * t649);
  t654 = t4 * t653;
  t655 = t654 * t28;
  t658 = t288 * t98;
  t661 = t130 * t235;
  t663 = 0.7e1 / 0.96e3 * t661 * t102;
  t669 = -t623 - 0.9e1 / 0.8e1 * t289 * t93 + 0.3e1 / 0.4e2 * t627 - t630 - 0.3e1 / 0.8e1 * t131 * t240 + t514 / 0.4e1 - t516 / 0.8e1 + 0.3e1 / 0.2e2 * t525 - 0.3e1 / 0.8e1 * t527 - t536 - 0.9e1 / 0.8e2 * t538 - 0.27e2 / 0.8e2 * t655 * t44 + 0.7e1 / 0.32e3 * t658 * t102 + t663 + 0.7e1 / 0.48e3 * t297 * t246 + 0.7e1 / 0.96e3 * t573 - 0.7e1 / 0.144e4 * t579 + 0.7e1 / 0.144e4 * t581;
  t670 = my_piecewise3(t2, 0, t669);
  t671 = t586 * t137;
  t674 = t252 * t309;
  t679 = 0.6e1 * t593;
  t681 = my_piecewise5(t13, 0, t9, 0, -t646 - t679);
  t685 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t671 * t253 + 0.8e1 / 0.9e1 * t674 * t109 + 0.4e1 / 0.9e1 * t305 * t259 + 0.4e1 / 0.3e1 * t54 * t681);
  t686 = t4 * t685;
  t687 = t686 * t59;
  t690 = t314 * t117;
  t692 = 0.9e1 / 0.4e2 * t690 * t70;
  t693 = t141 * t271;
  t694 = t693 * t70;
  t701 = 0.3e1 / 0.8e1 * t268 * t146;
  t702 = t272 * t146;
  t704 = t264 * t151;
  t707 = t113 * t329;
  t709 = 0.7e1 / 0.96e3 * t707 * t155;
  t710 = t228 * t150;
  t711 = t57 * t710;
  t712 = t711 * t155;
  t714 = -0.27e2 / 0.8e2 * t687 * t70 - t692 + 0.3e1 / 0.4e2 * t694 - 0.9e1 / 0.8e2 * t606 + 0.3e1 / 0.2e2 * t609 - t614 - 0.9e1 / 0.16e2 * t265 * t146 - t701 + t702 / 0.8e1 + 0.7e1 / 0.64e3 * t704 * t155 + t709 - 0.7e1 / 0.288e4 * t712;
  t715 = my_piecewise3(t48, 0, t714);
  tv3rho31 = t250 + t276 + t619 + t620 + t5 * (t670 + t715);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t718 = t548 * t339;
  t723 = t201 * t344;
  t727 = my_piecewise5(t9, 0, t13, 0, -t646 - t647);
  t731 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t718 * t78 + 0.8e1 / 0.9e1 * t279 * t283 + 0.4e1 / 0.9e1 * t723 * t78 + 0.4e1 / 0.3e1 * t22 * t727);
  t732 = t4 * t731;
  t733 = t732 * t28;
  t736 = t349 * t88;
  t737 = t736 * t44;
  t741 = t349 * t98;
  t748 = -0.27e2 / 0.8e2 * t733 * t44 - 0.9e1 / 0.8e2 * t737 - 0.9e1 / 0.16e2 * t350 * t93 + 0.7e1 / 0.64e3 * t741 * t102 - t623 + 0.3e1 / 0.2e2 * t627 - t630 + t663 + 0.3e1 / 0.4e2 * t525 - t536 + t514 / 0.8e1 - 0.7e1 / 0.288e4 * t579;
  t749 = my_piecewise3(t2, 0, t748);
  t750 = t586 * t356;
  t755 = t252 * t361;
  t759 = my_piecewise5(t13, 0, t9, 0, t646 - t679);
  t763 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t750 * t109 + 0.8e1 / 0.9e1 * t305 * t309 + 0.4e1 / 0.9e1 * t755 * t109 + 0.4e1 / 0.3e1 * t54 * t759);
  t764 = t4 * t763;
  t765 = t764 * t59;
  t768 = t366 * t117;
  t769 = t768 * t70;
  t774 = t318 * t146;
  t776 = t314 * t151;
  t779 = t141 * t329;
  t780 = t779 * t155;
  t787 = t118 * t379;
  t791 = t330 * t385;
  t793 = -0.27e2 / 0.8e2 * t765 * t70 - 0.9e1 / 0.8e2 * t769 - t692 + 0.3e1 / 0.2e2 * t694 - 0.9e1 / 0.8e1 * t315 * t146 - 0.3e1 / 0.8e1 * t774 + 0.7e1 / 0.32e3 * t776 * t155 + 0.7e1 / 0.96e3 * t780 + 0.3e1 / 0.4e2 * t609 - t614 - t701 + t702 / 0.4e1 + t709 - 0.7e1 / 0.144e4 * t712 - 0.3e1 / 0.8e1 * t114 * t379 - t787 / 0.8e1 + 0.7e1 / 0.48e3 * t326 * t385 + 0.7e1 / 0.144e4 * t791;
  t794 = my_piecewise3(t48, 0, t793);
  tv3rho32 = t619 + t620 + t355 + t389 + t5 * (t749 + t794);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t799 = t339 * t126;
  t806 = my_piecewise5(t9, 0, t13, 0, -0.6e1 * t206 - 0.6e1 * t557);
  t810 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t548 * t799 + 0.4e1 / 0.3e1 * t279 * t344 + 0.4e1 / 0.3e1 * t22 * t806);
  t811 = t4 * t810;
  t812 = t811 * t28;
  t818 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t812 * t44 - 0.27e2 / 0.8e2 * t737 + 0.9e1 / 0.4e2 * t627 - t536);
  t820 = t383 * t68 * t43;
  t835 = rho[1] * rho[1];
  t837 = 0.1e1 / t61 / t835;
  t839 = t837 * sigma[2] * t43;
  t842 = t356 * t137;
  t849 = my_piecewise5(t13, 0, t9, 0, 0.6e1 * t206 - 0.6e1 * t593);
  t853 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t586 * t842 + 0.4e1 / 0.3e1 * t305 * t361 + 0.4e1 / 0.3e1 * t54 * t849);
  t854 = t4 * t853;
  t855 = t854 * t59;
  t858 = t366 * t151;
  t863 = t60 * t820 / 0.8e1 - 0.27e2 / 0.16e2 * t367 * t146 - 0.9e1 / 0.8e1 * t142 * t379 - 0.9e1 / 0.8e1 * t774 + 0.7e1 / 0.32e3 * t780 - 0.3e1 / 0.8e1 * t787 + 0.7e1 / 0.48e3 * t791 - 0.7e1 / 0.96e3 * t712 - 0.27e2 / 0.8e2 * t769 + 0.9e1 / 0.4e2 * t694 + 0.3e1 / 0.8e1 * t702 - t614 - 0.7e1 / 0.96e3 * t152 * t839 - 0.27e2 / 0.8e2 * t855 * t70 + 0.21e2 / 0.64e3 * t858 * t155 + 0.7e1 / 0.16e3 * t373 * t385;
  t864 = my_piecewise3(t48, 0, t863);
  tv3rho33 = 0.3e1 * t355 + 0.3e1 * t389 + t5 * (t818 + t864);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t868 = t215 * t26;
  t871 = t82 * t87;
  t872 = t871 * t164;
  t876 = t25 * t228;
  t878 = 0.7e1 / 0.288e4 * t876 * t164;
  t879 = t395 * t399;
  t882 = t97 * t244 * t43;
  t886 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t868 * t164 - 0.7e1 / 0.96e3 * t872 - 0.7e1 / 0.48e3 * t392 * t399 + t878 - 0.7e1 / 0.144e4 * t879 + 0.7e1 / 0.288e4 * t162 * t882);
  tv3rho2sigma0 = t5 * t886 + 0.2e1 * t403;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t889 = t264 * t26;
  t892 = t113 * t87;
  t893 = t892 * t170;
  t895 = t57 * t228;
  t897 = 0.7e1 / 0.288e4 * t895 * t170;
  t899 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t889 * t170 - 0.7e1 / 0.96e3 * t893 + t897);
  tv3rho2sigma2 = t5 * t899 + 0.2e1 * t412;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t901 = t288 * t26;
  t904 = t130 * t87;
  t905 = t904 * t164;
  t912 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t901 * t164 - 0.7e1 / 0.192e4 * t905 - 0.7e1 / 0.96e3 * t414 * t399 - 0.7e1 / 0.192e4 * t872 + t878 - 0.7e1 / 0.288e4 * t879);
  tv3rho2sigma3 = t5 * t912 + t403 + t418;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t914 = t314 * t26;
  t917 = t141 * t87;
  t918 = t917 * t170;
  t923 = t408 * t424;
  t926 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t914 * t170 - 0.7e1 / 0.192e4 * t918 - 0.7e1 / 0.192e4 * t893 + t897 - 0.7e1 / 0.96e3 * t405 * t424 - 0.7e1 / 0.288e4 * t923);
  tv3rho2sigma5 = t5 * t926 + t412 + t428;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t929 = t349 * t26;
  t934 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t929 * t164 - 0.7e1 / 0.96e3 * t905 + t878);
  tv3rho2sigma6 = t5 * t934 + 0.2e1 * t418;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t937 = t366 * t26;
  t945 = t150 * t383 * t43;
  t949 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t937 * t170 - 0.7e1 / 0.96e3 * t918 - 0.7e1 / 0.48e3 * t420 * t424 + t897 - 0.7e1 / 0.144e4 * t923 + 0.7e1 / 0.288e4 * t168 * t945);
  tv3rho2sigma8 = t5 * t949 + 0.2e1 * t428;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t954 = t572 * t44;
  t961 = 0.3e1 / 0.4e2 * t578 * t44;
  t962 = t236 * t93;
  t964 = t442 * t102;
  t970 = t215 * t178;
  t973 = t82 * t441;
  t974 = t973 * t181;
  t976 = t228 * t177;
  t977 = t25 * t976;
  t979 = 0.7e1 / 0.288e4 * t977 * t181;
  t980 = 0.27e2 / 0.8e2 * t569 * t44 + 0.9e1 / 0.4e2 * t954 + 0.9e1 / 0.8e1 * t224 * t93 - 0.7e1 / 0.96e3 * t438 * t102 - t961 + 0.3e1 / 0.8e1 * t962 - 0.7e1 / 0.288e4 * t964 + 0.3e1 / 0.8e1 * t99 * t240 - 0.49e2 / 0.288e4 * t179 * t246 + 0.7e1 / 0.64e3 * t970 * t181 + 0.7e1 / 0.96e3 * t974 - t979;
  t981 = my_piecewise3(t2, 0, t980);
  tv3rho2tau0 = t5 * t981 + 0.2e1 * t446;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t986 = t707 * t70;
  t989 = 0.3e1 / 0.4e2 * t711 * t70;
  t990 = t264 * t190;
  t993 = t113 * t455;
  t994 = t993 * t193;
  t996 = t228 * t189;
  t997 = t57 * t996;
  t999 = 0.7e1 / 0.288e4 * t997 * t193;
  t1001 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t704 * t70 + 0.9e1 / 0.4e2 * t986 - t989 + 0.7e1 / 0.64e3 * t990 * t193 + 0.7e1 / 0.96e3 * t994 - t999);
  tv3rho2tau1 = t5 * t1001 + 0.2e1 * t460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1005 = t661 * t44;
  t1014 = t288 * t178;
  t1017 = t130 * t441;
  t1018 = t1017 * t181;
  t1021 = 0.27e2 / 0.8e2 * t658 * t44 + 0.9e1 / 0.8e2 * t1005 + 0.9e1 / 0.16e2 * t297 * t93 - 0.7e1 / 0.192e4 * t464 * t102 + 0.9e1 / 0.8e2 * t954 - t961 + 0.3e1 / 0.16e2 * t962 - 0.7e1 / 0.576e4 * t964 + 0.7e1 / 0.64e3 * t1014 * t181 + 0.7e1 / 0.192e4 * t1018 + 0.7e1 / 0.192e4 * t974 - t979;
  t1022 = my_piecewise3(t2, 0, t1021);
  tv3rho2tau2 = t5 * t1022 + t446 + t468;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1026 = t779 * t70;
  t1031 = t330 * t146;
  t1035 = t456 * t155;
  t1037 = t314 * t190;
  t1040 = t141 * t455;
  t1041 = t1040 * t193;
  t1044 = 0.27e2 / 0.8e2 * t776 * t70 + 0.9e1 / 0.8e2 * t1026 + 0.9e1 / 0.8e2 * t986 - t989 + 0.9e1 / 0.16e2 * t326 * t146 + 0.3e1 / 0.16e2 * t1031 - 0.7e1 / 0.192e4 * t452 * t155 - 0.7e1 / 0.576e4 * t1035 + 0.7e1 / 0.64e3 * t1037 * t193 + 0.7e1 / 0.192e4 * t1041 + 0.7e1 / 0.192e4 * t994 - t999;
  t1045 = my_piecewise3(t48, 0, t1044);
  tv3rho2tau3 = t5 * t1045 + t460 + t480;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t1051 = t349 * t178;
  t1056 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t741 * t44 + 0.9e1 / 0.4e2 * t1005 - t961 + 0.7e1 / 0.64e3 * t1051 * t181 + 0.7e1 / 0.96e3 * t1018 - t979);
  tv3rho2tau4 = t5 * t1056 + 0.2e1 * t468;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t1072 = t366 * t190;
  t1076 = 0.27e2 / 0.8e2 * t858 * t70 + 0.9e1 / 0.4e2 * t1026 + 0.9e1 / 0.8e1 * t373 * t146 - 0.7e1 / 0.96e3 * t476 * t155 - t989 + 0.3e1 / 0.8e1 * t1031 - 0.7e1 / 0.288e4 * t1035 + 0.3e1 / 0.8e1 * t152 * t379 - 0.49e2 / 0.288e4 * t191 * t385 + 0.7e1 / 0.64e3 * t1072 * t193 + 0.7e1 / 0.96e3 * t1041 - t999;
  t1077 = my_piecewise3(t48, 0, t1076);
  tv3rho2tau5 = t5 * t1077 + 0.2e1 * t480;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t1082 = 0.7e1 / 0.96e3 * t395 * t483;
  t1084 = t177 * t100 * t43;
  t1088 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t392 * t483 + t1082 + 0.7e1 / 0.48e3 * t162 * t1084);
  tv3rhosigmatau0 = t5 * t1088 + t486;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t1093 = 0.7e1 / 0.96e3 * t408 * t488;
  t1095 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t405 * t488 + t1093);
  tv3rhosigmatau5 = t5 * t1095 + t491;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t1100 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t414 * t483 + t1082);
  tv3rhosigmatau6 = t5 * t1100 + t486;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t1105 = t189 * t153 * t43;
  t1109 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t420 * t488 + t1093 + 0.7e1 / 0.48e3 * t168 * t1105);
  tv3rhosigmatau11 = t5 * t1109 + t491;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t1114 = 0.9e1 / 0.4e2 * t442 * t44;
  t1119 = t82 * t496;
  t1122 = t87 * t495;
  t1123 = t25 * t1122;
  t1125 = 0.7e1 / 0.48e3 * t1123 * t181;
  t1127 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t438 * t44 - t1114 - 0.9e1 / 0.8e1 * t179 * t93 - 0.7e1 / 0.96e3 * t497 * t102 - 0.7e1 / 0.16e3 * t1119 * t181 - t1125);
  tv3rhotau20 = t5 * t1127 + t501;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t1132 = 0.9e1 / 0.4e2 * t456 * t70;
  t1133 = t113 * t506;
  t1136 = t87 * t505;
  t1137 = t57 * t1136;
  t1139 = 0.7e1 / 0.48e3 * t1137 * t193;
  t1141 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t452 * t70 - t1132 - 0.7e1 / 0.16e3 * t1133 * t193 - t1139);
  tv3rhotau22 = t5 * t1141 + t511;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t1145 = t130 * t496;
  t1149 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t464 * t44 - t1114 - 0.7e1 / 0.16e3 * t1145 * t181 - t1125);
  tv3rhotau23 = t5 * t1149 + t501;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t1157 = t141 * t506;
  t1161 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t476 * t70 - t1132 - 0.9e1 / 0.8e1 * t191 * t146 - 0.7e1 / 0.96e3 * t507 * t155 - 0.7e1 / 0.16e3 * t1157 * t193 - t1139);
  tv3rhotau25 = t5 * t1161 + t511;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t1164 = t495 * t31 * t43;
  t1167 = my_piecewise3(t2, 0, -0.21e2 / 0.32e3 * t162 * t1164);
  tv3sigmatau20 = t5 * t1167;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t1169 = t505 * t62 * t43;
  t1172 = my_piecewise3(t48, 0, -0.21e2 / 0.32e3 * t168 * t1169);
  tv3sigmatau28 = t5 * t1172;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t1176 = 0.1e1 / t494 / tau[0];
  t1177 = t26 * t1176;
  t1178 = t25 * t1177;
  t1182 = my_piecewise3(t2, 0, 0.81e2 / 0.4e2 * t497 * t44 + 0.63e2 / 0.32e3 * t1178 * t181);
  tv3tau30 = t5 * t1182;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t1186 = 0.1e1 / t504 / tau[1];
  t1187 = t26 * t1186;
  t1188 = t57 * t1187;
  t1192 = my_piecewise3(t48, 0, 0.81e2 / 0.4e2 * t507 * t70 + 0.63e2 / 0.32e3 * t1188 * t193);
  tv3tau33 = t5 * t1192;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t1196 = t565 * t88 * t44;
  t1198 = t215 * t235;
  t1199 = t1198 * t102;
  t1201 = t18 * t18;
  t1203 = 0.1e1 / t200 / t1201;
  t1204 = t202 * t202;
  t1210 = t210 * t210;
  t1216 = 0.1e1 / t555 / t5;
  t1217 = t15 * t1216;
  t1220 = my_piecewise5(t9, 0, t13, 0, -0.24e2 * t556 + 0.24e2 * t1217);
  t1224 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1203 * t1204 - 0.16e2 / 0.9e1 * t548 * t202 * t210 + 0.4e1 / 0.3e1 * t201 * t1210 + 0.16e2 / 0.9e1 * t552 * t560 + 0.4e1 / 0.3e1 * t22 * t1220);
  t1229 = t565 * t98;
  t1232 = t578 * t246;
  t1234 = t219 * t240;
  t1236 = t236 * t544;
  t1252 = t215 * t229 * t44;
  t1254 = -0.9e1 / 0.2e2 * t1196 + 0.7e1 / 0.16e3 * t1199 - 0.27e2 / 0.8e2 * t4 * t1224 * t28 * t44 + 0.7e1 / 0.16e3 * t1229 * t102 - 0.7e1 / 0.36e3 * t1232 - 0.3e1 / 0.2e1 * t1234 - 0.7e1 / 0.72e3 * t1236 + t83 * t519 / 0.2e1 + 0.7e1 / 0.54e3 * t99 / t30 / t540 / rho[0] * sigma[0] * t43 - 0.9e1 / 0.4e1 * t566 * t93 + 0.7e1 / 0.8e2 * t569 * t246 + 0.9e1 / 0.2e2 * t1252;
  t1255 = t82 * t577;
  t1256 = t1255 * t102;
  t1258 = t572 * t246;
  t1263 = t25 * t532 * t97;
  t1264 = t1263 * t102;
  t1266 = t524 * t93;
  t1269 = 0.1e1 / t86 / t205;
  t1273 = t25 * t1269 * t27 * t44 / 0.3e1;
  t1274 = t537 * t93;
  t1279 = t82 * t533 * t44;
  t1281 = t534 * t93;
  t1283 = t230 * t240;
  t1285 = t89 * t519;
  t1291 = -0.7e1 / 0.24e3 * t1256 + 0.7e1 / 0.12e3 * t1258 - 0.7e1 / 0.24e3 * t224 * t544 + 0.7e1 / 0.432e3 * t1264 + 0.3e1 / 0.2e1 * t1266 + t1273 - 0.9e1 / 0.4e1 * t1274 - 0.9e1 / 0.4e1 * t216 * t240 - t1279 / 0.2e1 - 0.5e1 / 0.6e1 * t1281 + t1283 / 0.2e1 + t1285 / 0.6e1 - t29 * t542 * t37 * t43 / 0.6e1;
  t1293 = my_piecewise3(t2, 0, t1254 + t1291);
  t1294 = t52 * t52;
  t1296 = 0.1e1 / t251 / t1294;
  t1297 = t253 * t253;
  t1303 = t259 * t259;
  t1308 = t49 * t1216;
  t1311 = my_piecewise5(t13, 0, t9, 0, 0.24e2 * t556 + 0.24e2 * t1308);
  t1315 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1296 * t1297 - 0.16e2 / 0.9e1 * t586 * t253 * t259 + 0.4e1 / 0.3e1 * t252 * t1303 + 0.16e2 / 0.9e1 * t590 * t596 + 0.4e1 / 0.3e1 * t54 * t1311);
  t1321 = t601 * t117 * t70;
  t1324 = t264 * t271 * t70;
  t1327 = t113 * t611 * t70;
  t1332 = t57 * t1269 * t58 * t70 / 0.3e1;
  t1334 = my_piecewise3(t48, 0, -0.27e2 / 0.8e2 * t4 * t1315 * t59 * t70 - 0.9e1 / 0.2e2 * t1321 + 0.9e1 / 0.2e2 * t1324 - t1327 / 0.2e1 + t1332);
  tv4rho40 = 0.4e1 * t584 + 0.4e1 * t616 + t5 * (t1293 + t1334);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1354 = -0.9e1 / 0.8e2 * t1196 + 0.7e1 / 0.64e3 * t1199 - 0.7e1 / 0.72e3 * t1232 - 0.3e1 / 0.8e1 * t1234 - 0.7e1 / 0.288e4 * t1236 + 0.9e1 / 0.4e2 * t1252 - 0.7e1 / 0.48e3 * t1256 + 0.7e1 / 0.48e3 * t1258 + 0.7e1 / 0.576e3 * t1264 + 0.3e1 / 0.4e1 * t1266 + t1273 - 0.9e1 / 0.16e2 * t1274 - 0.3e1 / 0.8e1 * t1279 - 0.5e1 / 0.8e1 * t1281 + t1283 / 0.4e1 + t1285 / 0.24e2;
  t1357 = t130 * t577;
  t1358 = t1357 * t102;
  t1359 = 0.7e1 / 0.96e3 * t1358;
  t1360 = t661 * t246;
  t1380 = 0.12e2 * t556;
  t1381 = 0.24e2 * t1217;
  t1383 = my_piecewise5(t9, 0, t13, 0, -t1380 + t1381);
  t1387 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1203 * t126 * t549 - 0.8e1 / 0.9e1 * t548 * t283 * t202 - 0.8e1 / 0.9e1 * t638 * t78 * t210 + 0.4e1 / 0.3e1 * t201 * t649 * t78 + 0.4e1 / 0.3e1 * t641 * t210 + 0.4e1 / 0.9e1 * t279 * t560 + 0.4e1 / 0.3e1 * t22 * t1383);
  t1392 = t654 * t98;
  t1396 = t654 * t88 * t44;
  t1398 = t288 * t235;
  t1399 = t1398 * t102;
  t1403 = t626 * t93;
  t1404 = 0.3e1 / 0.8e1 * t1403;
  t1405 = t292 * t240;
  t1410 = t288 * t229 * t44;
  t1411 = 0.9e1 / 0.4e2 * t1410;
  t1412 = t621 * t93;
  t1417 = t130 * t533 * t44;
  t1419 = 0.7e1 / 0.16e3 * t658 * t246 - t1359 + 0.7e1 / 0.48e3 * t1360 - 0.7e1 / 0.96e3 * t297 * t544 - 0.27e2 / 0.8e2 * t4 * t1387 * t28 * t44 + 0.21e2 / 0.64e3 * t1392 * t102 - 0.27e2 / 0.8e2 * t1396 + 0.7e1 / 0.32e3 * t1399 - 0.27e2 / 0.16e2 * t655 * t93 + t1404 - 0.3e1 / 0.8e1 * t1405 + t131 * t519 / 0.8e1 + t1411 - 0.9e1 / 0.8e1 * t1412 - 0.9e1 / 0.8e1 * t289 * t240 - t1417 / 0.8e1;
  t1421 = my_piecewise3(t2, 0, t1354 + t1419);
  t1438 = 0.24e2 * t1308;
  t1440 = my_piecewise5(t13, 0, t9, 0, t1380 + t1438);
  t1444 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1296 * t137 * t587 - 0.8e1 / 0.9e1 * t586 * t309 * t253 - 0.8e1 / 0.9e1 * t671 * t109 * t259 + 0.4e1 / 0.3e1 * t252 * t681 * t109 + 0.4e1 / 0.3e1 * t674 * t259 + 0.4e1 / 0.9e1 * t305 * t596 + 0.4e1 / 0.3e1 * t54 * t1440);
  t1450 = t686 * t117 * t70;
  t1453 = t314 * t271 * t70;
  t1454 = 0.9e1 / 0.4e2 * t1453;
  t1456 = t141 * t611 * t70;
  t1463 = t605 * t146;
  t1465 = t608 * t146;
  t1466 = 0.3e1 / 0.8e1 * t1465;
  t1467 = t612 * t146;
  t1469 = t601 * t151;
  t1472 = t264 * t329;
  t1473 = t1472 * t155;
  t1475 = t113 * t710;
  t1476 = t1475 * t155;
  t1477 = 0.7e1 / 0.96e3 * t1476;
  t1479 = t57 * t532 * t150;
  t1480 = t1479 * t155;
  t1482 = -0.27e2 / 0.8e2 * t4 * t1444 * t59 * t70 - 0.27e2 / 0.8e2 * t1450 + t1454 - t1456 / 0.8e1 - 0.9e1 / 0.8e2 * t1321 + 0.9e1 / 0.4e2 * t1324 - 0.3e1 / 0.8e1 * t1327 + t1332 - 0.9e1 / 0.16e2 * t602 * t146 - 0.9e1 / 0.16e2 * t1463 + t1466 - 0.5e1 / 0.24e2 * t1467 + 0.7e1 / 0.64e3 * t1469 * t155 + 0.7e1 / 0.64e3 * t1473 - t1477 + 0.7e1 / 0.1728e4 * t1480;
  t1483 = my_piecewise3(t48, 0, t1482);
  tv4rho41 = t584 + t616 + 0.3e1 * t670 + 0.3e1 * t715 + t5 * (t1421 + t1483);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1502 = -0.7e1 / 0.216e4 * t1232 + 0.3e1 / 0.4e2 * t1252 - 0.7e1 / 0.144e4 * t1256 + 0.7e1 / 0.864e3 * t1264 + t1266 / 0.4e1 + t1273 - t1279 / 0.4e1 - 0.5e1 / 0.12e2 * t1281 + t1283 / 0.12e2 - 0.7e1 / 0.72e3 * t1358 + 0.7e1 / 0.72e3 * t1360 - 0.9e1 / 0.4e2 * t1396 + 0.7e1 / 0.48e3 * t1399;
  t1511 = t349 * t229 * t44;
  t1513 = t736 * t93;
  t1525 = t283 * t283;
  t1538 = my_piecewise5(t9, 0, t13, 0, t1381);
  t1542 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1203 * t339 * t202 - 0.32e2 / 0.27e2 * t638 * t78 * t283 - 0.8e1 / 0.27e2 * t718 * t210 + 0.8e1 / 0.9e1 * t201 * t1525 + 0.8e1 / 0.9e1 * t279 * t649 - 0.8e1 / 0.27e2 * t548 * t344 * t202 + 0.8e1 / 0.9e1 * t201 * t727 * t78 + 0.4e1 / 0.9e1 * t723 * t210 + 0.4e1 / 0.3e1 * t22 * t1538);
  t1547 = t732 * t98;
  t1550 = t349 * t235;
  t1551 = t1550 * t102;
  t1556 = t732 * t88 * t44;
  t1558 = t1403 / 0.2e1 - t1405 / 0.4e1 + 0.3e1 / 0.1e2 * t1410 - 0.3e1 / 0.4e1 * t1412 - t1417 / 0.4e1 - 0.9e1 / 0.8e1 * t733 * t93 + 0.3e1 / 0.4e2 * t1511 - 0.3e1 / 0.8e1 * t1513 - 0.3e1 / 0.8e1 * t350 * t240 - 0.27e2 / 0.8e2 * t4 * t1542 * t28 * t44 + 0.7e1 / 0.32e3 * t1547 * t102 + 0.7e1 / 0.96e3 * t1551 + 0.7e1 / 0.48e3 * t741 * t246 - 0.9e1 / 0.4e2 * t1556;
  t1560 = my_piecewise3(t2, 0, t1502 + t1558);
  t1572 = t711 * t385;
  t1574 = 0.3e1 / 0.4e2 * t1324 - t1327 / 0.4e1 + t1332 - 0.9e1 / 0.4e2 * t1450 + 0.3e1 / 0.1e2 * t1453 - t1456 / 0.4e1 - 0.3e1 / 0.8e1 * t1463 + t1465 / 0.2e1 - 0.5e1 / 0.12e2 * t1467 + 0.7e1 / 0.96e3 * t1473 - 0.7e1 / 0.72e3 * t1476 + 0.7e1 / 0.864e3 * t1480 - 0.7e1 / 0.216e4 * t1572;
  t1575 = t141 * t710;
  t1576 = t1575 * t155;
  t1578 = t268 * t379;
  t1580 = t272 * t379;
  t1582 = t707 * t385;
  t1585 = t366 * t271 * t70;
  t1587 = t690 * t146;
  t1589 = t693 * t146;
  t1591 = t314 * t329;
  t1592 = t1591 * t155;
  t1595 = t764 * t117 * t70;
  t1599 = t686 * t151;
  t1614 = t309 * t309;
  t1627 = my_piecewise5(t13, 0, t9, 0, t1438);
  t1631 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1296 * t356 * t253 - 0.32e2 / 0.27e2 * t671 * t109 * t309 - 0.8e1 / 0.27e2 * t750 * t259 + 0.8e1 / 0.9e1 * t252 * t1614 + 0.8e1 / 0.9e1 * t305 * t681 - 0.8e1 / 0.27e2 * t586 * t361 * t253 + 0.8e1 / 0.9e1 * t252 * t759 * t109 + 0.4e1 / 0.9e1 * t755 * t259 + 0.4e1 / 0.3e1 * t54 * t1627);
  t1636 = -0.7e1 / 0.144e4 * t1576 - t1578 / 0.4e1 + t1580 / 0.12e2 + 0.7e1 / 0.72e3 * t1582 + 0.3e1 / 0.4e2 * t1585 - 0.3e1 / 0.4e1 * t1587 + t1589 / 0.4e1 + 0.7e1 / 0.48e3 * t1592 - 0.9e1 / 0.4e2 * t1595 - 0.9e1 / 0.8e1 * t687 * t146 + 0.7e1 / 0.32e3 * t1599 * t155 - 0.3e1 / 0.8e1 * t265 * t379 + 0.7e1 / 0.48e3 * t704 * t385 - 0.27e2 / 0.8e2 * t4 * t1631 * t59 * t70;
  t1638 = my_piecewise3(t48, 0, t1574 + t1636);
  tv4rho42 = 0.2e1 * t670 + 0.2e1 * t715 + 0.2e1 * t749 + 0.2e1 * t794 + t5 * (t1560 + t1638);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1659 = my_piecewise5(t9, 0, t13, 0, t1380 + t1381);
  t1663 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1203 * t799 * t78 - 0.8e1 / 0.9e1 * t718 * t283 - 0.8e1 / 0.9e1 * t638 * t344 * t78 + 0.4e1 / 0.3e1 * t641 * t344 + 0.4e1 / 0.3e1 * t279 * t727 + 0.4e1 / 0.9e1 * t201 * t806 * t78 + 0.4e1 / 0.3e1 * t22 * t1659);
  t1669 = t811 * t88 * t44;
  t1673 = t811 * t98;
  t1684 = -0.27e2 / 0.8e2 * t4 * t1663 * t28 * t44 - 0.9e1 / 0.8e2 * t1669 - 0.9e1 / 0.16e2 * t812 * t93 + 0.7e1 / 0.64e3 * t1673 * t102 - 0.27e2 / 0.8e2 * t1556 + 0.9e1 / 0.4e2 * t1511 - 0.9e1 / 0.16e2 * t1513 + 0.7e1 / 0.64e3 * t1551 + t1411 - 0.3e1 / 0.8e1 * t1417 + t1404 - t1359 - t1279 / 0.8e1 + t1273 - 0.5e1 / 0.24e2 * t1281 + 0.7e1 / 0.1728e4 * t1264;
  t1685 = my_piecewise3(t2, 0, t1684);
  t1698 = -t1327 / 0.8e1 + t1332 + t1454 - 0.3e1 / 0.8e1 * t1456 + t1466 - 0.5e1 / 0.8e1 * t1467 - t1477 + 0.7e1 / 0.576e3 * t1480 - 0.7e1 / 0.72e3 * t1572 - 0.7e1 / 0.48e3 * t1576 - 0.3e1 / 0.8e1 * t1578 + t1580 / 0.4e1 + 0.7e1 / 0.48e3 * t1582 + 0.9e1 / 0.4e2 * t1585 - 0.9e1 / 0.8e1 * t1587 + 0.3e1 / 0.4e1 * t1589;
  t1701 = t779 * t385;
  t1703 = t318 * t379;
  t1705 = t330 * t839;
  t1708 = t854 * t117 * t70;
  t1710 = t366 * t329;
  t1711 = t1710 * t155;
  t1713 = t118 * t820;
  t1715 = t768 * t146;
  t1743 = my_piecewise5(t13, 0, t9, 0, -t1380 + t1438);
  t1747 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1296 * t842 * t109 - 0.8e1 / 0.9e1 * t750 * t309 - 0.8e1 / 0.9e1 * t671 * t361 * t109 + 0.4e1 / 0.3e1 * t674 * t361 + 0.4e1 / 0.3e1 * t305 * t759 + 0.4e1 / 0.9e1 * t252 * t849 * t109 + 0.4e1 / 0.3e1 * t54 * t1743);
  t1752 = t764 * t151;
  t1755 = 0.7e1 / 0.32e3 * t1592 - 0.27e2 / 0.8e2 * t1595 + 0.7e1 / 0.48e3 * t1701 - 0.3e1 / 0.8e1 * t1703 - 0.7e1 / 0.288e4 * t1705 - 0.9e1 / 0.8e2 * t1708 + 0.7e1 / 0.64e3 * t1711 + t1713 / 0.24e2 - 0.9e1 / 0.16e2 * t1715 + 0.7e1 / 0.16e3 * t776 * t385 + t114 * t820 / 0.8e1 - 0.27e2 / 0.16e2 * t765 * t146 - 0.9e1 / 0.8e1 * t315 * t379 - 0.7e1 / 0.96e3 * t326 * t839 - 0.27e2 / 0.8e2 * t4 * t1747 * t59 * t70 + 0.21e2 / 0.64e3 * t1752 * t155;
  t1757 = my_piecewise3(t48, 0, t1698 + t1755);
  tv4rho43 = 0.3e1 * t749 + 0.3e1 * t794 + t818 + t864 + t5 * (t1685 + t1757);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1762 = t339 * t339;
  t1767 = t344 * t344;
  t1774 = my_piecewise5(t9, 0, t13, 0, 0.24e2 * t556 + 0.24e2 * t1217);
  t1778 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1203 * t1762 - 0.16e2 / 0.9e1 * t718 * t344 + 0.4e1 / 0.3e1 * t201 * t1767 + 0.16e2 / 0.9e1 * t279 * t806 + 0.4e1 / 0.3e1 * t22 * t1774);
  t1787 = my_piecewise3(t2, 0, -0.27e2 / 0.8e2 * t4 * t1778 * t28 * t44 - 0.9e1 / 0.2e2 * t1669 + 0.9e1 / 0.2e2 * t1511 - t1417 / 0.2e1 + t1273);
  t1799 = t1332 - t1456 / 0.2e1 - 0.5e1 / 0.6e1 * t1467 + 0.7e1 / 0.432e3 * t1480 - 0.7e1 / 0.36e3 * t1572 - 0.7e1 / 0.24e3 * t1576 + t1580 / 0.2e1 + 0.9e1 / 0.2e2 * t1585 + 0.3e1 / 0.2e1 * t1589 + 0.7e1 / 0.12e3 * t1701 - 0.3e1 / 0.2e1 * t1703 - 0.7e1 / 0.72e3 * t1705;
  t1810 = t356 * t356;
  t1815 = t361 * t361;
  t1822 = my_piecewise5(t13, 0, t9, 0, -0.24e2 * t556 + 0.24e2 * t1308);
  t1826 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1296 * t1810 - 0.16e2 / 0.9e1 * t750 * t361 + 0.4e1 / 0.3e1 * t252 * t1815 + 0.16e2 / 0.9e1 * t305 * t849 + 0.4e1 / 0.3e1 * t54 * t1822);
  t1831 = t854 * t151;
  t1849 = -0.9e1 / 0.2e2 * t1708 + 0.7e1 / 0.16e3 * t1711 + t1713 / 0.6e1 - 0.9e1 / 0.4e1 * t1715 - t60 * t837 * t68 * t43 / 0.6e1 - 0.9e1 / 0.4e1 * t367 * t379 - 0.27e2 / 0.8e2 * t4 * t1826 * t59 * t70 + 0.7e1 / 0.16e3 * t1831 * t155 - 0.9e1 / 0.4e1 * t855 * t146 + 0.7e1 / 0.8e2 * t858 * t385 - 0.7e1 / 0.24e3 * t373 * t839 + t142 * t820 / 0.2e1 + 0.7e1 / 0.54e3 * t152 / t61 / t835 / rho[1] * sigma[2] * t43;
  t1851 = my_piecewise3(t48, 0, t1799 + t1849);
  tv4rho44 = 0.4e1 * t818 + 0.4e1 * t864 + t5 * (t1787 + t1851);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1859 = t215 * t87 * t164;
  t1864 = t82 * t228 * t164;
  t1866 = t871 * t399;
  t1872 = 0.7e1 / 0.1728e4 * t25 * t532 * t164;
  t1873 = t876 * t399;
  t1875 = t395 * t882;
  t1882 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t565 * t26 * t164 - 0.7e1 / 0.64e3 * t1859 - 0.7e1 / 0.32e3 * t868 * t399 + 0.7e1 / 0.96e3 * t1864 - 0.7e1 / 0.48e3 * t1866 + 0.7e1 / 0.96e3 * t392 * t882 - t1872 + 0.7e1 / 0.144e4 * t1873 + 0.7e1 / 0.288e4 * t1875 - 0.7e1 / 0.216e4 * t162 * t97 * t542 * t43);
  tv4rho3sigma0 = t5 * t1882 + 0.3e1 * t886;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1889 = t264 * t87 * t170;
  t1892 = t113 * t228 * t170;
  t1896 = 0.7e1 / 0.1728e4 * t57 * t532 * t170;
  t1898 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t601 * t26 * t170 - 0.7e1 / 0.64e3 * t1889 + 0.7e1 / 0.96e3 * t1892 - t1896);
  tv4rho3sigma2 = t5 * t1898 + 0.3e1 * t899;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1900 = 0.2e1 * t912;
  t1906 = 0.7e1 / 0.96e3 * t288 * t87 * t164;
  t1910 = t130 * t228 * t164;
  t1913 = 0.7e1 / 0.144e4 * t904 * t399;
  t1921 = -0.7e1 / 0.64e3 * t654 * t26 * t164 - t1906 - 0.7e1 / 0.48e3 * t901 * t399 + 0.7e1 / 0.288e4 * t1910 - t1913 + 0.7e1 / 0.288e4 * t414 * t882 - 0.7e1 / 0.192e4 * t1859 + 0.7e1 / 0.144e4 * t1864 - 0.7e1 / 0.144e4 * t1866 - t1872 + 0.7e1 / 0.216e4 * t1873 + 0.7e1 / 0.864e4 * t1875;
  t1922 = my_piecewise3(t2, 0, t1921);
  tv4rho3sigma3 = t5 * t1922 + t1900 + t886;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1924 = 0.2e1 * t926;
  t1930 = 0.7e1 / 0.96e3 * t314 * t87 * t170;
  t1932 = t141 * t228 * t170;
  t1939 = 0.7e1 / 0.144e4 * t892 * t424;
  t1940 = t895 * t424;
  t1943 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t686 * t26 * t170 - t1930 + 0.7e1 / 0.288e4 * t1932 - 0.7e1 / 0.192e4 * t1889 + 0.7e1 / 0.144e4 * t1892 - t1896 - 0.7e1 / 0.96e3 * t889 * t424 - t1939 + 0.7e1 / 0.432e4 * t1940);
  tv4rho3sigma5 = t5 * t1943 + t1924 + t899;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1949 = t349 * t87 * t164;
  t1957 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t732 * t26 * t164 - 0.7e1 / 0.192e4 * t1949 - 0.7e1 / 0.96e3 * t929 * t399 - t1906 + 0.7e1 / 0.144e4 * t1910 - t1913 + 0.7e1 / 0.288e4 * t1864 - t1872 + 0.7e1 / 0.432e4 * t1873);
  tv4rho3sigma6 = t5 * t1957 + t1900 + t934;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1963 = t366 * t87 * t170;
  t1968 = t917 * t424;
  t1974 = t408 * t945;
  t1976 = -0.7e1 / 0.64e3 * t764 * t26 * t170 - 0.7e1 / 0.192e4 * t1963 - t1930 + 0.7e1 / 0.144e4 * t1932 - 0.7e1 / 0.48e3 * t914 * t424 - 0.7e1 / 0.144e4 * t1968 + 0.7e1 / 0.288e4 * t1892 - t1896 - t1939 + 0.7e1 / 0.216e4 * t1940 + 0.7e1 / 0.288e4 * t405 * t945 + 0.7e1 / 0.864e4 * t1974;
  t1977 = my_piecewise3(t48, 0, t1976);
  tv4rho3sigma8 = t5 * t1977 + t1924 + t949;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t1986 = my_piecewise3(t2, 0, -0.7e1 / 0.64e3 * t811 * t26 * t164 - 0.7e1 / 0.64e3 * t1949 + 0.7e1 / 0.96e3 * t1910 - t1872);
  tv4rho3sigma9 = t5 * t1986 + 0.3e1 * t934;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2006 = my_piecewise3(t48, 0, -0.7e1 / 0.64e3 * t854 * t26 * t170 - 0.7e1 / 0.64e3 * t1963 - 0.7e1 / 0.32e3 * t937 * t424 + 0.7e1 / 0.96e3 * t1932 - 0.7e1 / 0.48e3 * t1968 + 0.7e1 / 0.96e3 * t420 * t945 - t1896 + 0.7e1 / 0.144e4 * t1940 + 0.7e1 / 0.288e4 * t1974 - 0.7e1 / 0.216e4 * t168 * t150 * t837 * t43);
  tv4rho3sigma11 = t5 * t2006 + 0.3e1 * t949;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t2009 = t442 * t246;
  t2020 = t973 * t102;
  t2024 = t977 * t102;
  t2027 = t215 * t441 * t181;
  t2030 = t82 * t976 * t181;
  t2035 = 0.7e1 / 0.1728e4 * t25 * t532 * t177 * t181;
  t2036 = t236 * t240;
  t2040 = t1255 * t44;
  t2042 = t572 * t93;
  t2047 = t1263 * t44 / 0.8e1;
  t2048 = t578 * t93;
  t2050 = t1198 * t44;
  t2054 = -0.49e2 / 0.288e4 * t2009 + 0.91e2 / 0.864e4 * t179 * t544 + 0.7e1 / 0.64e3 * t565 * t178 * t181 + 0.27e2 / 0.8e2 * t1229 * t44 - 0.7e1 / 0.64e3 * t970 * t102 - 0.7e1 / 0.96e3 * t2020 - 0.49e2 / 0.96e3 * t438 * t246 + 0.7e1 / 0.288e4 * t2024 + 0.7e1 / 0.64e3 * t2027 - 0.7e1 / 0.96e3 * t2030 + t2035 + 0.3e1 / 0.8e1 * t2036 - t99 * t519 / 0.8e1 - 0.9e1 / 0.4e2 * t2040 + 0.9e1 / 0.8e1 * t2042 + 0.9e1 / 0.8e1 * t224 * t240 + t2047 - 0.3e1 / 0.8e1 * t2048 + 0.27e2 / 0.8e2 * t2050 + 0.27e2 / 0.16e2 * t569 * t93;
  t2055 = my_piecewise3(t2, 0, t2054);
  tv4rho3tau0 = t5 * t2055 + 0.3e1 * t981;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2060 = t1472 * t70;
  t2062 = t1475 * t70;
  t2065 = t1479 * t70 / 0.8e1;
  t2070 = t264 * t455 * t193;
  t2073 = t113 * t996 * t193;
  t2078 = 0.7e1 / 0.1728e4 * t57 * t532 * t189 * t193;
  t2080 = my_piecewise3(t48, 0, 0.27e2 / 0.8e2 * t1469 * t70 + 0.27e2 / 0.8e2 * t2060 - 0.9e1 / 0.4e2 * t2062 + t2065 + 0.7e1 / 0.64e3 * t601 * t190 * t193 + 0.7e1 / 0.64e3 * t2070 - 0.7e1 / 0.96e3 * t2073 + t2078);
  tv4rho3tau1 = t5 * t2080 + 0.3e1 * t1001;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t2082 = 0.2e1 * t1022;
  t2087 = 0.7e1 / 0.96e3 * t288 * t441 * t181;
  t2089 = t130 * t976 * t181;
  t2092 = 0.9e1 / 0.4e2 * t1398 * t44;
  t2095 = t1357 * t44;
  t2098 = 0.3e1 / 0.8e1 * t661 * t93;
  t2102 = 0.7e1 / 0.288e4 * t1017 * t102;
  t2110 = 0.3e1 / 0.8e1 * t297 * t240 + t2087 - 0.7e1 / 0.288e4 * t2089 + t2092 + 0.9e1 / 0.8e1 * t658 * t93 - 0.3e1 / 0.4e2 * t2095 + t2098 - 0.7e1 / 0.96e3 * t1014 * t102 - t2102 - 0.49e2 / 0.288e4 * t464 * t246 + 0.7e1 / 0.64e3 * t654 * t178 * t181 + 0.27e2 / 0.8e2 * t1392 * t44;
  t2121 = -0.49e2 / 0.864e4 * t2009 - 0.7e1 / 0.288e4 * t2020 + 0.7e1 / 0.432e4 * t2024 + 0.7e1 / 0.192e4 * t2027 - 0.7e1 / 0.144e4 * t2030 + t2035 + t2036 / 0.8e1 - 0.3e1 / 0.2e2 * t2040 + 0.3e1 / 0.8e1 * t2042 + t2047 - t2048 / 0.4e1 + 0.9e1 / 0.8e2 * t2050;
  t2123 = my_piecewise3(t2, 0, t2110 + t2121);
  tv4rho3tau2 = t5 * t2123 + t2082 + t981;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t2125 = 0.2e1 * t1045;
  t2129 = 0.9e1 / 0.4e2 * t1591 * t70;
  t2130 = t1575 * t70;
  t2137 = 0.3e1 / 0.8e1 * t707 * t146;
  t2138 = t711 * t146;
  t2143 = 0.7e1 / 0.288e4 * t993 * t155;
  t2144 = t997 * t155;
  t2151 = 0.7e1 / 0.96e3 * t314 * t455 * t193;
  t2153 = t141 * t996 * t193;
  t2157 = 0.27e2 / 0.8e2 * t1599 * t70 + t2129 - 0.3e1 / 0.4e2 * t2130 + 0.9e1 / 0.8e2 * t2060 - 0.3e1 / 0.2e2 * t2062 + t2065 + 0.9e1 / 0.16e2 * t704 * t146 + t2137 - t2138 / 0.8e1 - 0.7e1 / 0.192e4 * t990 * t155 - t2143 + 0.7e1 / 0.864e4 * t2144 + 0.7e1 / 0.64e3 * t686 * t190 * t193 + t2151 - 0.7e1 / 0.288e4 * t2153 + 0.7e1 / 0.192e4 * t2070 - 0.7e1 / 0.144e4 * t2073 + t2078;
  t2158 = my_piecewise3(t48, 0, t2157);
  tv4rho3tau3 = t5 * t2158 + t1001 + t2125;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t2162 = t1550 * t44;
  t2176 = t349 * t441 * t181;
  t2180 = 0.27e2 / 0.8e2 * t1547 * t44 + 0.9e1 / 0.8e2 * t2162 + 0.9e1 / 0.16e2 * t741 * t93 - 0.7e1 / 0.192e4 * t1051 * t102 + t2092 - 0.3e1 / 0.2e2 * t2095 + t2098 - t2102 - 0.3e1 / 0.4e2 * t2040 + t2047 - t2048 / 0.8e1 + 0.7e1 / 0.864e4 * t2024 + 0.7e1 / 0.64e3 * t732 * t178 * t181 + 0.7e1 / 0.192e4 * t2176 + t2087 - 0.7e1 / 0.144e4 * t2089 - 0.7e1 / 0.288e4 * t2030 + t2035;
  t2181 = my_piecewise3(t2, 0, t2180);
  tv4rho3tau4 = t5 * t2181 + t1056 + t2082;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t2185 = t1710 * t70;
  t2190 = t779 * t146;
  t2194 = t1040 * t155;
  t2198 = 0.27e2 / 0.8e2 * t1752 * t70 + 0.9e1 / 0.8e2 * t2185 + t2129 - 0.3e1 / 0.2e2 * t2130 + 0.9e1 / 0.8e1 * t776 * t146 + 0.3e1 / 0.8e1 * t2190 - 0.7e1 / 0.96e3 * t1037 * t155 - 0.7e1 / 0.288e4 * t2194 - 0.3e1 / 0.4e2 * t2062 + t2065 + t2137 - t2138 / 0.4e1;
  t2202 = t330 * t379;
  t2206 = t456 * t385;
  t2212 = t366 * t455 * t193;
  t2216 = -t2143 + 0.7e1 / 0.432e4 * t2144 + 0.3e1 / 0.8e1 * t326 * t379 + t2202 / 0.8e1 - 0.49e2 / 0.288e4 * t452 * t385 - 0.49e2 / 0.864e4 * t2206 + 0.7e1 / 0.64e3 * t764 * t190 * t193 + 0.7e1 / 0.192e4 * t2212 + t2151 - 0.7e1 / 0.144e4 * t2153 - 0.7e1 / 0.288e4 * t2073 + t2078;
  t2218 = my_piecewise3(t48, 0, t2198 + t2216);
  tv4rho3tau5 = t5 * t2218 + t1077 + t2125;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t2231 = my_piecewise3(t2, 0, 0.27e2 / 0.8e2 * t1673 * t44 + 0.27e2 / 0.8e2 * t2162 - 0.9e1 / 0.4e2 * t2095 + t2047 + 0.7e1 / 0.64e3 * t811 * t178 * t181 + 0.7e1 / 0.64e3 * t2176 - 0.7e1 / 0.96e3 * t2089 + t2035);
  tv4rho3tau6 = t5 * t2231 + 0.3e1 * t1056;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t2261 = -t152 * t820 / 0.8e1 + 0.27e2 / 0.16e2 * t858 * t146 + 0.9e1 / 0.8e1 * t373 * t379 + 0.7e1 / 0.64e3 * t2212 + 0.9e1 / 0.8e1 * t2190 - 0.7e1 / 0.96e3 * t2194 + 0.3e1 / 0.8e1 * t2202 - 0.49e2 / 0.288e4 * t2206 + 0.27e2 / 0.8e2 * t2185 + 0.7e1 / 0.288e4 * t2144 - 0.7e1 / 0.96e3 * t2153 - 0.9e1 / 0.4e2 * t2130 - 0.3e1 / 0.8e1 * t2138 + t2078 + 0.91e2 / 0.864e4 * t191 * t839 + 0.7e1 / 0.64e3 * t854 * t190 * t193 + 0.27e2 / 0.8e2 * t1831 * t70 - 0.7e1 / 0.64e3 * t1072 * t155 - 0.49e2 / 0.96e3 * t476 * t385 + t2065;
  t2262 = my_piecewise3(t48, 0, t2261);
  tv4rho3tau7 = t5 * t2262 + 0.3e1 * t1077;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  tv4rho2sigma26 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  tv4rho2sigma212 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t2267 = t871 * t483;
  t2272 = 0.7e1 / 0.144e4 * t876 * t483;
  t2273 = t395 * t1084;
  t2280 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t868 * t483 + 0.7e1 / 0.48e3 * t2267 + 0.7e1 / 0.24e3 * t392 * t1084 - t2272 + 0.7e1 / 0.72e3 * t2273 - 0.7e1 / 0.144e4 * t162 * t177 * t244 * t43);
  tv4rho2sigmatau0 = t5 * t2280 + 0.2e1 * t1088;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t2285 = t892 * t488;
  t2288 = 0.7e1 / 0.144e4 * t895 * t488;
  t2290 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t889 * t488 + 0.7e1 / 0.48e3 * t2285 - t2288);
  tv4rho2sigmatau5 = t5 * t2290 + 0.2e1 * t1095;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t2294 = t904 * t483;
  t2301 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t901 * t483 + 0.7e1 / 0.96e3 * t2294 + 0.7e1 / 0.48e3 * t414 * t1084 + 0.7e1 / 0.96e3 * t2267 - t2272 + 0.7e1 / 0.144e4 * t2273);
  tv4rho2sigmatau6 = t5 * t2301 + t1088 + t1100;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t2305 = t917 * t488;
  t2310 = t408 * t1105;
  t2313 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t914 * t488 + 0.7e1 / 0.96e3 * t2305 + 0.7e1 / 0.96e3 * t2285 - t2288 + 0.7e1 / 0.48e3 * t405 * t1105 + 0.7e1 / 0.144e4 * t2310);
  tv4rho2sigmatau11 = t5 * t2313 + t1095 + t1109;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t2320 = my_piecewise3(t2, 0, 0.7e1 / 0.32e3 * t929 * t483 + 0.7e1 / 0.48e3 * t2294 - t2272);
  tv4rho2sigmatau12 = t5 * t2320 + 0.2e1 * t1100;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t2334 = my_piecewise3(t48, 0, 0.7e1 / 0.32e3 * t937 * t488 + 0.7e1 / 0.48e3 * t2305 + 0.7e1 / 0.24e3 * t420 * t1105 - t2288 + 0.7e1 / 0.72e3 * t2310 - 0.7e1 / 0.144e4 * t168 * t189 * t383 * t43);
  tv4rho2sigmatau17 = t5 * t2334 + 0.2e1 * t1109;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t2339 = t973 * t44;
  t2346 = 0.3e1 / 0.2e2 * t977 * t44;
  t2347 = t442 * t93;
  t2349 = t1123 * t102;
  t2359 = t82 * t1122 * t181;
  t2364 = 0.7e1 / 0.72e3 * t25 * t228 * t495 * t181;
  t2365 = -0.27e2 / 0.4e2 * t970 * t44 - 0.9e1 / 0.2e2 * t2339 - 0.9e1 / 0.4e1 * t438 * t93 - 0.7e1 / 0.48e3 * t1119 * t102 + t2346 - 0.3e1 / 0.4e1 * t2347 - 0.7e1 / 0.144e4 * t2349 - 0.3e1 / 0.4e1 * t179 * t240 + 0.7e1 / 0.18e3 * t497 * t246 - 0.7e1 / 0.16e3 * t215 * t496 * t181 - 0.7e1 / 0.24e3 * t2359 + t2364;
  t2366 = my_piecewise3(t2, 0, t2365);
  tv4rho2tau20 = t5 * t2366 + 0.2e1 * t1127;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t2371 = t993 * t70;
  t2374 = 0.3e1 / 0.2e2 * t997 * t70;
  t2379 = t113 * t1136 * t193;
  t2384 = 0.7e1 / 0.72e3 * t57 * t228 * t505 * t193;
  t2386 = my_piecewise3(t48, 0, -0.27e2 / 0.4e2 * t990 * t70 - 0.9e1 / 0.2e2 * t2371 + t2374 - 0.7e1 / 0.16e3 * t264 * t506 * t193 - 0.7e1 / 0.24e3 * t2379 + t2384);
  tv4rho2tau22 = t5 * t2386 + 0.2e1 * t1141;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t2390 = t1017 * t44;
  t2403 = t130 * t1122 * t181;
  t2406 = -0.27e2 / 0.4e2 * t1014 * t44 - 0.9e1 / 0.4e2 * t2390 - 0.9e1 / 0.8e1 * t464 * t93 - 0.7e1 / 0.96e3 * t1145 * t102 - 0.9e1 / 0.4e2 * t2339 + t2346 - 0.3e1 / 0.8e1 * t2347 - 0.7e1 / 0.288e4 * t2349 - 0.7e1 / 0.16e3 * t288 * t496 * t181 - 0.7e1 / 0.48e3 * t2403 - 0.7e1 / 0.48e3 * t2359 + t2364;
  t2407 = my_piecewise3(t2, 0, t2406);
  tv4rho2tau23 = t5 * t2407 + t1127 + t1149;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t2411 = t1040 * t70;
  t2416 = t456 * t146;
  t2420 = t1137 * t155;
  t2426 = t141 * t1136 * t193;
  t2429 = -0.27e2 / 0.4e2 * t1037 * t70 - 0.9e1 / 0.4e2 * t2411 - 0.9e1 / 0.4e2 * t2371 + t2374 - 0.9e1 / 0.8e1 * t452 * t146 - 0.3e1 / 0.8e1 * t2416 - 0.7e1 / 0.96e3 * t1133 * t155 - 0.7e1 / 0.288e4 * t2420 - 0.7e1 / 0.16e3 * t314 * t506 * t193 - 0.7e1 / 0.48e3 * t2426 - 0.7e1 / 0.48e3 * t2379 + t2384;
  t2430 = my_piecewise3(t48, 0, t2429);
  tv4rho2tau25 = t5 * t2430 + t1141 + t1161;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t2441 = my_piecewise3(t2, 0, -0.27e2 / 0.4e2 * t1051 * t44 - 0.9e1 / 0.2e2 * t2390 + t2346 - 0.7e1 / 0.16e3 * t349 * t496 * t181 - 0.7e1 / 0.24e3 * t2403 + t2364);
  tv4rho2tau26 = t5 * t2441 + 0.2e1 * t1149;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t2461 = -0.27e2 / 0.4e2 * t1072 * t70 - 0.9e1 / 0.2e2 * t2411 - 0.9e1 / 0.4e1 * t476 * t146 - 0.7e1 / 0.48e3 * t1157 * t155 + t2374 - 0.3e1 / 0.4e1 * t2416 - 0.7e1 / 0.144e4 * t2420 - 0.3e1 / 0.4e1 * t191 * t379 + 0.7e1 / 0.18e3 * t507 * t385 - 0.7e1 / 0.16e3 * t366 * t506 * t193 - 0.7e1 / 0.24e3 * t2426 + t2384;
  t2462 = my_piecewise3(t48, 0, t2461);
  tv4rho2tau28 = t5 * t2462 + 0.2e1 * t1161;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t2467 = 0.7e1 / 0.32e3 * t395 * t1164;
  t2473 = my_piecewise3(t2, 0, -0.21e2 / 0.32e3 * t392 * t1164 - t2467 - 0.7e1 / 0.16e3 * t162 * t495 * t100 * t43);
  tv4rhosigmatau20 = t5 * t2473 + t1167;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t2478 = 0.7e1 / 0.32e3 * t408 * t1169;
  t2480 = my_piecewise3(t48, 0, -0.21e2 / 0.32e3 * t405 * t1169 - t2478);
  tv4rhosigmatau28 = t5 * t2480 + t1172;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t2485 = my_piecewise3(t2, 0, -0.21e2 / 0.32e3 * t414 * t1164 - t2467);
  tv4rhosigmatau29 = t5 * t2485 + t1167;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t2494 = my_piecewise3(t48, 0, -0.21e2 / 0.32e3 * t420 * t1169 - t2478 - 0.7e1 / 0.16e3 * t168 * t505 * t153 * t43);
  tv4rhosigmatau217 = t5 * t2494 + t1172;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t2499 = 0.27e2 / 0.4e2 * t1123 * t44;
  t2510 = 0.21e2 / 0.32e3 * t25 * t87 * t1176 * t181;
  t2512 = my_piecewise3(t2, 0, 0.81e2 / 0.4e2 * t1119 * t44 + t2499 + 0.27e2 / 0.8e1 * t497 * t93 + 0.21e2 / 0.32e3 * t1178 * t102 + 0.63e2 / 0.32e3 * t82 * t1177 * t181 + t2510);
  tv4rhotau30 = t5 * t2512 + t1182;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t2517 = 0.27e2 / 0.4e2 * t1137 * t70;
  t2524 = 0.21e2 / 0.32e3 * t57 * t87 * t1186 * t193;
  t2526 = my_piecewise3(t48, 0, 0.81e2 / 0.4e2 * t1133 * t70 + t2517 + 0.63e2 / 0.32e3 * t113 * t1187 * t193 + t2524);
  tv4rhotau33 = t5 * t2526 + t1192;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t2534 = my_piecewise3(t2, 0, 0.81e2 / 0.4e2 * t1145 * t44 + t2499 + 0.63e2 / 0.32e3 * t130 * t1177 * t181 + t2510);
  tv4rhotau34 = t5 * t2534 + t1182;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t2546 = my_piecewise3(t48, 0, 0.81e2 / 0.4e2 * t1157 * t70 + t2517 + 0.27e2 / 0.8e1 * t507 * t146 + 0.21e2 / 0.32e3 * t1188 * t155 + 0.63e2 / 0.32e3 * t141 * t1187 * t193 + t2524);
  tv4rhotau37 = t5 * t2546 + t1192;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t2552 = my_piecewise3(t2, 0, 0.21e2 / 0.8e2 * t162 * t1176 * t31 * t43);
  tv4sigmatau30 = t5 * t2552;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t2557 = my_piecewise3(t48, 0, 0.21e2 / 0.8e2 * t168 * t1186 * t62 * t43);
  tv4sigmatau311 = t5 * t2557;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t2567 = my_piecewise3(t2, 0, -0.81e2 / 0.1e2 * t1178 * t44 - 0.21e2 / 0.2e2 * t25 * t26 / t494 / t96 * t181);
  tv4tau40 = t5 * t2567;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t2577 = my_piecewise3(t48, 0, -0.81e2 / 0.1e2 * t1188 * t70 - 0.21e2 / 0.2e2 * t57 * t26 / t504 / t149 * t193);
  tv4tau44 = t5 * t2577;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

