/* LayoutsManager.c generated by valac 0.56.18, the Vala compiler
 * generated from LayoutsManager.vala, do not modify */

/*-
 * Copyright (c) 2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "keyboard.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_0_PROPERTY,
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY,
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY,
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* keyboard_widgets_layout_manager_properties[KEYBOARD_WIDGETS_LAYOUT_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _xmlXPathFreeObject0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeObject (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
enum  {
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_UPDATED_SIGNAL,
	KEYBOARD_WIDGETS_LAYOUT_MANAGER_NUM_SIGNALS
};
static guint keyboard_widgets_layout_manager_signals[KEYBOARD_WIDGETS_LAYOUT_MANAGER_NUM_SIGNALS] = {0};

struct _KeyboardWidgetsLayoutManagerPrivate {
	gchar* _current_language_code;
	gchar* _current_layout_variant;
	GSettings* settings;
	GList* engines;
	GtkBox* xkb_box;
	GtkBox* ibus_box;
	GtkRevealer* ibus_box_revealer;
	GtkRevealer* ibus_header_revealer;
	GraniteSwitchModelButton* ibus_header;
	IBusBus* bus;
	GSimpleActionGroup* actions;
};

struct _Block1Data {
	int _ref_count_;
	KeyboardWidgetsLayoutManager* self;
	gchar* xkb_label;
	gchar* ibus_label;
};

struct _Block2Data {
	int _ref_count_;
	KeyboardWidgetsLayoutManager* self;
	KeyboardWidgetsLayoutButton* previously_active_button;
	gboolean found;
	guint index;
};

static gint KeyboardWidgetsLayoutManager_private_offset;
static gpointer keyboard_widgets_layout_manager_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void keyboard_widgets_layout_manager_populate_layouts (KeyboardWidgetsLayoutManager* self);
static void __lambda4_ (KeyboardWidgetsLayoutManager* self,
                 GtkWidget* child);
static void ___lambda4__gfunc (gconstpointer data,
                        gpointer self);
static void __lambda5_ (KeyboardWidgetsLayoutManager* self,
                 GtkWidget* child);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void keyboard_widgets_layout_manager_set_ibus_engine (KeyboardWidgetsLayoutManager* self,
                                                      const gchar* manager,
                                                      const gchar* source);
static void keyboard_widgets_layout_manager_set_active_layout_from_settings (KeyboardWidgetsLayoutManager* self);
static void keyboard_widgets_layout_manager_action_change_layout (KeyboardWidgetsLayoutManager* self,
                                                           GSimpleAction* action,
                                                           GVariant* parameter);
static void keyboard_widgets_layout_manager_set_active_layout (KeyboardWidgetsLayoutManager* self,
                                                        guint32 index);
static GVariant* _variant_new1 (guint32 value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda8_ (Block1Data* _data1_,
                 GtkWidget* child);
static void ___lambda8__gfunc (gconstpointer data,
                        gpointer self);
static void __lambda9_ (Block1Data* _data1_,
                 GtkWidget* child);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
static GVariant* _variant_new2 (guint32 value);
static void keyboard_widgets_layout_manager_set_active_layout_to_xkb (KeyboardWidgetsLayoutManager* self);
static GVariant* _variant_new3 (guint32 value);
static void keyboard_widgets_layout_manager_set_layout_active_in_box (KeyboardWidgetsLayoutManager* self,
                                                               GtkBox* layout_box,
                                                               guint index,
                                                               gboolean clear);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_,
                 GtkWidget* widget);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void ____lambda7_ (KeyboardWidgetsLayoutManager* self,
                   GtkWidget* widget);
static void _____lambda7__gfunc (gconstpointer data,
                          gpointer self);
static GObject * keyboard_widgets_layout_manager_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _keyboard_widgets_layout_manager___lambda10_ (KeyboardWidgetsLayoutManager* self);
static void __keyboard_widgets_layout_manager___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                              gpointer self);
static void _keyboard_widgets_layout_manager___lambda11_ (KeyboardWidgetsLayoutManager* self);
static void __keyboard_widgets_layout_manager___lambda11__g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _keyboard_widgets_layout_manager___lambda12_ (KeyboardWidgetsLayoutManager* self);
static void __keyboard_widgets_layout_manager___lambda12__ibus_bus_connected (IBusBus* _sender,
                                                                       gpointer self);
static void _keyboard_widgets_layout_manager___lambda13_ (KeyboardWidgetsLayoutManager* self);
static void __keyboard_widgets_layout_manager___lambda13__ibus_bus_disconnected (IBusBus* _sender,
                                                                          gpointer self);
static void _keyboard_widgets_layout_manager___lambda14_ (KeyboardWidgetsLayoutManager* self);
static void __keyboard_widgets_layout_manager___lambda14__g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _keyboard_widgets_layout_manager_action_change_layout_g_simple_action_activate (GSimpleAction* _sender,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void keyboard_widgets_layout_manager_finalize (GObject * obj);
static GType keyboard_widgets_layout_manager_get_type_once (void);
static void _vala_keyboard_widgets_layout_manager_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_keyboard_widgets_layout_manager_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
keyboard_widgets_layout_manager_get_instance_private (KeyboardWidgetsLayoutManager* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardWidgetsLayoutManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda4_ (KeyboardWidgetsLayoutManager* self,
            GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda4__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda4_ ((KeyboardWidgetsLayoutManager*) self, (GtkWidget*) data);
}

static void
__lambda5_ (KeyboardWidgetsLayoutManager* self,
            GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ ((KeyboardWidgetsLayoutManager*) self, (GtkWidget*) data);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
keyboard_widgets_layout_manager_populate_layouts (KeyboardWidgetsLayoutManager* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkBox* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkRevealer* _tmp7_;
	GVariant* source_list = NULL;
	GSettings* _tmp8_;
	GVariant* _tmp9_;
	IBusBus* _tmp10_;
	KeyboardWidgetsLayoutButton* layout_button = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp13_;
	GVariantIter* _tmp14_;
	guint32 i = 0U;
	gchar* manager_type = NULL;
	gchar* source = NULL;
	GtkBox* _tmp97_;
	GList* _tmp98_;
	GList* _tmp99_;
	gboolean _tmp100_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xkb_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda4__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	_tmp3_ = self->priv->ibus_box;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_list_foreach (_tmp5_, ___lambda5__gfunc, self);
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	_tmp6_ = self->priv->ibus_header_revealer;
	gtk_revealer_set_reveal_child (_tmp6_, FALSE);
	_tmp7_ = self->priv->ibus_box_revealer;
	gtk_revealer_set_reveal_child (_tmp7_, FALSE);
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_value (_tmp8_, "sources");
	source_list = _tmp9_;
	(self->priv->engines == NULL) ? NULL : (self->priv->engines = (_g_list_free__g_object_unref0_ (self->priv->engines), NULL));
	self->priv->engines = NULL;
	_tmp10_ = self->priv->bus;
	if (ibus_bus_is_connected (_tmp10_)) {
		IBusBus* _tmp11_;
		GList* _tmp12_;
		_tmp11_ = self->priv->bus;
		_tmp12_ = ibus_bus_list_engines (_tmp11_);
		(self->priv->engines == NULL) ? NULL : (self->priv->engines = (_g_list_free__g_object_unref0_ (self->priv->engines), NULL));
		self->priv->engines = _tmp12_;
		keyboard_widgets_layout_manager_set_ibus_engine (self, KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_MANAGER_TYPE, "");
	}
	layout_button = NULL;
	_tmp13_ = source_list;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	iter = _tmp14_;
	i = (guint32) 0;
	while (TRUE) {
		GVariantIter* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gboolean _tmp18_;
		gchar* language = NULL;
		gchar* _tmp19_;
		gchar* layout_variant = NULL;
		gchar* button_label = NULL;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GQuark _tmp23_ = 0U;
		static GQuark _tmp22_label0 = 0;
		static GQuark _tmp22_label1 = 0;
		const gchar* _tmp66_ = NULL;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		const gchar* _tmp69_;
		GVariant* action_target = NULL;
		GVariant* _tmp77_;
		const gchar* _tmp78_ = NULL;
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		GVariant* _tmp86_;
		KeyboardWidgetsLayoutButton* _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		GQuark _tmp91_ = 0U;
		static GQuark _tmp90_label0 = 0;
		static GQuark _tmp90_label1 = 0;
		guint32 _tmp96_;
		_tmp15_ = iter;
		_tmp18_ = g_variant_iter_next (_tmp15_, "(ss)", &_tmp16_, &_tmp17_, NULL);
		_g_free0 (manager_type);
		manager_type = _tmp16_;
		_g_free0 (source);
		source = _tmp17_;
		if (!_tmp18_) {
			break;
		}
		_tmp19_ = g_strdup ("us");
		language = _tmp19_;
		layout_variant = NULL;
		button_label = NULL;
		_tmp20_ = manager_type;
		_tmp21_ = _tmp20_;
		_tmp23_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
		if (_tmp23_ == ((0 != _tmp22_label0) ? _tmp22_label0 : (_tmp22_label0 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_MANAGER_TYPE)))) {
			switch (0) {
				default:
				{
					const gchar* _tmp24_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp24_ = source;
					if (string_contains (_tmp24_, "+")) {
						gchar** layouts = NULL;
						const gchar* _tmp25_;
						gchar** _tmp26_;
						gchar** _tmp27_;
						gint layouts_length1;
						gint _layouts_size_;
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp25_ = source;
						_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "+", 2);
						layouts = _tmp27_;
						layouts_length1 = _vala_array_length (_tmp26_);
						_layouts_size_ = layouts_length1;
						_tmp28_ = layouts;
						_tmp28__length1 = layouts_length1;
						_tmp29_ = _tmp28_[0];
						_tmp30_ = g_strdup (_tmp29_);
						_g_free0 (language);
						language = _tmp30_;
						_tmp31_ = layouts;
						_tmp31__length1 = layouts_length1;
						_tmp32_ = _tmp31_[1];
						_tmp33_ = g_strdup (_tmp32_);
						_g_free0 (layout_variant);
						layout_variant = _tmp33_;
						layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
					} else {
						const gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp34_ = source;
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (language);
						language = _tmp35_;
					}
					_tmp36_ = language;
					_tmp37_ = layout_variant;
					_tmp38_ = keyboard_widgets_layout_manager_get_name_for_xkb_layout (self, _tmp36_, _tmp37_);
					_g_free0 (button_label);
					button_label = _tmp38_;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label1) ? _tmp22_label1 : (_tmp22_label1 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_IBUS_MANAGER_TYPE)))) {
			switch (0) {
				default:
				{
					GList* _tmp39_;
					GList* _tmp40_;
					_tmp39_ = self->priv->engines;
					if (_tmp39_ == NULL) {
						_g_free0 (button_label);
						_g_free0 (layout_variant);
						_g_free0 (language);
						continue;
					}
					_tmp40_ = self->priv->engines;
					{
						GList* engine_collection = NULL;
						GList* engine_it = NULL;
						engine_collection = _tmp40_;
						for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
							IBusEngineDesc* _tmp41_;
							IBusEngineDesc* engine = NULL;
							_tmp41_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
							engine = _tmp41_;
							{
								gboolean _tmp42_ = FALSE;
								IBusEngineDesc* _tmp43_;
								_tmp43_ = engine;
								if (_tmp43_ != NULL) {
									IBusEngineDesc* _tmp44_;
									const gchar* _tmp45_;
									const gchar* _tmp46_;
									const gchar* _tmp47_;
									_tmp44_ = engine;
									_tmp45_ = ibus_engine_desc_get_name (_tmp44_);
									_tmp46_ = _tmp45_;
									_tmp47_ = source;
									_tmp42_ = g_strcmp0 (_tmp46_, _tmp47_) == 0;
								} else {
									_tmp42_ = FALSE;
								}
								if (_tmp42_) {
									const gchar* _tmp48_;
									IBusEngineDesc* _tmp59_;
									const gchar* _tmp60_;
									gchar* _tmp61_;
									IBusEngineDesc* _tmp62_;
									const gchar* _tmp63_;
									gchar* _tmp64_;
									_tmp48_ = source;
									if (string_contains (_tmp48_, "xkb")) {
										IBusEngineDesc* _tmp49_;
										const gchar* _tmp50_;
										gchar* _tmp51_;
										_tmp49_ = engine;
										_tmp50_ = ibus_engine_desc_get_longname (_tmp49_);
										_tmp51_ = g_strdup (_tmp50_);
										_g_free0 (button_label);
										button_label = _tmp51_;
									} else {
										gchar* lang_name = NULL;
										IBusEngineDesc* _tmp52_;
										const gchar* _tmp53_;
										gchar* _tmp54_;
										const gchar* _tmp55_;
										IBusEngineDesc* _tmp56_;
										const gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp52_ = engine;
										_tmp53_ = ibus_engine_desc_get_language (_tmp52_);
										_tmp54_ = ibus_get_language_name (_tmp53_);
										lang_name = _tmp54_;
										_tmp55_ = lang_name;
										_tmp56_ = engine;
										_tmp57_ = ibus_engine_desc_get_longname (_tmp56_);
										_tmp58_ = g_strdup_printf ("%s (%s)", _tmp55_, _tmp57_);
										_g_free0 (button_label);
										button_label = _tmp58_;
										_g_free0 (lang_name);
									}
									_tmp59_ = engine;
									_tmp60_ = ibus_engine_desc_get_language (_tmp59_);
									_tmp61_ = g_strdup (_tmp60_);
									_g_free0 (language);
									language = _tmp61_;
									_tmp62_ = engine;
									_tmp63_ = ibus_engine_desc_get_layout_variant (_tmp62_);
									_tmp64_ = g_strdup (_tmp63_);
									_g_free0 (layout_variant);
									layout_variant = _tmp64_;
								}
								_g_object_unref0 (engine);
							}
						}
					}
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					const gchar* _tmp65_;
					_tmp65_ = manager_type;
					g_warning ("LayoutsManager.vala:196: unrecognised input manager %s", _tmp65_);
					_g_free0 (button_label);
					_g_free0 (layout_variant);
					_g_free0 (language);
					continue;
				}
			}
		}
		_tmp67_ = layout_variant;
		_tmp66_ = _tmp67_;
		if (_tmp66_ == NULL) {
			_tmp66_ = "";
		}
		_tmp68_ = g_strdup (_tmp66_);
		_g_free0 (layout_variant);
		layout_variant = _tmp68_;
		_tmp69_ = button_label;
		if (_tmp69_ == NULL) {
			gchar* variant = NULL;
			gchar* _tmp70_;
			const gchar* _tmp71_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			gchar* _tmp76_;
			_tmp70_ = g_strdup ("");
			variant = _tmp70_;
			_tmp71_ = layout_variant;
			if (g_strcmp0 (_tmp71_, "") != 0) {
				const gchar* _tmp72_;
				gchar* _tmp73_;
				_tmp72_ = layout_variant;
				_tmp73_ = g_strdup_printf (" (%s)", _tmp72_);
				_g_free0 (variant);
				variant = _tmp73_;
			}
			_tmp74_ = language;
			_tmp75_ = variant;
			_tmp76_ = g_strconcat (_tmp74_, _tmp75_, NULL);
			_g_free0 (button_label);
			button_label = _tmp76_;
			_g_free0 (variant);
		}
		_tmp77_ = g_variant_new ("u", i, NULL);
		g_variant_ref_sink (_tmp77_);
		action_target = _tmp77_;
		_tmp79_ = layout_variant;
		_tmp78_ = _tmp79_;
		if (_tmp78_ == NULL) {
			_tmp78_ = "";
		}
		_tmp80_ = button_label;
		_tmp81_ = string_replace (_tmp80_, "_", "__");
		_tmp82_ = _tmp81_;
		_tmp83_ = manager_type;
		_tmp84_ = source;
		_tmp85_ = language;
		_tmp86_ = action_target;
		_tmp87_ = keyboard_widgets_layout_button_new (_tmp82_, _tmp83_, _tmp84_, _tmp85_, _tmp78_, i, "manager.change-layout", _tmp86_);
		g_object_ref_sink (_tmp87_);
		_g_object_unref0 (layout_button);
		layout_button = _tmp87_;
		_g_free0 (_tmp82_);
		_tmp88_ = manager_type;
		_tmp89_ = _tmp88_;
		_tmp91_ = (NULL == _tmp89_) ? 0 : g_quark_from_string (_tmp89_);
		if (_tmp91_ == ((0 != _tmp90_label0) ? _tmp90_label0 : (_tmp90_label0 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_MANAGER_TYPE)))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp92_;
					KeyboardWidgetsLayoutButton* _tmp93_;
					_tmp92_ = self->priv->xkb_box;
					_tmp93_ = layout_button;
					gtk_container_add ((GtkContainer*) _tmp92_, (GtkWidget*) _tmp93_);
					break;
				}
			}
		} else if (_tmp91_ == ((0 != _tmp90_label1) ? _tmp90_label1 : (_tmp90_label1 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_IBUS_MANAGER_TYPE)))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp94_;
					KeyboardWidgetsLayoutButton* _tmp95_;
					_tmp94_ = self->priv->ibus_box;
					_tmp95_ = layout_button;
					gtk_container_add ((GtkContainer*) _tmp94_, (GtkWidget*) _tmp95_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					g_assert_not_reached ();
				}
			}
		}
		_tmp96_ = i;
		i = _tmp96_ + 1;
		_g_variant_unref0 (action_target);
		_g_free0 (button_label);
		_g_free0 (layout_variant);
		_g_free0 (language);
	}
	_tmp97_ = self->priv->ibus_box;
	_tmp98_ = gtk_container_get_children ((GtkContainer*) _tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_list_length (_tmp99_) > ((guint) 0);
	(_tmp99_ == NULL) ? NULL : (_tmp99_ = (g_list_free (_tmp99_), NULL));
	if (_tmp100_) {
		GtkRevealer* _tmp101_;
		GtkRevealer* _tmp102_;
		GraniteSwitchModelButton* _tmp103_;
		gboolean _tmp104_;
		gboolean _tmp105_;
		_tmp101_ = self->priv->ibus_header_revealer;
		gtk_revealer_set_reveal_child (_tmp101_, TRUE);
		_tmp102_ = self->priv->ibus_box_revealer;
		_tmp103_ = self->priv->ibus_header;
		_tmp104_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp103_);
		_tmp105_ = _tmp104_;
		gtk_revealer_set_reveal_child (_tmp102_, _tmp105_);
	}
	keyboard_widgets_layout_manager_set_active_layout_from_settings (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_free0 (source);
	_g_free0 (manager_type);
	_g_variant_iter_free0 (iter);
	_g_object_unref0 (layout_button);
	_g_variant_unref0 (source_list);
}

gchar*
keyboard_widgets_layout_manager_get_xml_rules_file_path (KeyboardWidgetsLayoutManager* self)
{
	const gchar* base_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_getenv ("XKB_CONFIG_ROOT");
	base_path = _tmp0_;
	_tmp1_ = base_path;
	if (_tmp1_ == NULL) {
		base_path = CONSTANTS_XKB_BASE;
	}
	_tmp2_ = base_path;
	_tmp3_ = g_build_filename (_tmp2_, "rules", KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_RULES_FILE, NULL);
	result = _tmp3_;
	return result;
}

static GVariant*
_variant_new1 (guint32 value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

static void
keyboard_widgets_layout_manager_action_change_layout (KeyboardWidgetsLayoutManager* self,
                                                      GSimpleAction* action,
                                                      GVariant* parameter)
{
	guint32 current_source_index = 0U;
	guint32 _tmp0_ = 0U;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_variant_get (parameter, "u", &_tmp0_, NULL);
	current_source_index = _tmp0_;
	keyboard_widgets_layout_manager_set_active_layout (self, current_source_index);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "current");
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != current_source_index;
	_g_variant_unref0 (_tmp3_);
	if (_tmp4_) {
		GSettings* _tmp5_;
		GVariant* _tmp6_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = _variant_new1 (current_source_index);
		g_settings_set_value (_tmp5_, "current", _tmp6_);
		_g_variant_unref0 (_tmp6_);
	}
}

static void
keyboard_widgets_layout_manager_set_ibus_engine (KeyboardWidgetsLayoutManager* self,
                                                 const gchar* manager,
                                                 const gchar* source)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = manager;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_MANAGER_TYPE)))) {
		switch (0) {
			default:
			{
				IBusBus* _tmp3_;
				_tmp3_ = self->priv->bus;
				ibus_bus_set_global_engine (_tmp3_, "xkb:us::eng");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (KEYBOARD_WIDGETS_LAYOUT_MANAGER_IBUS_MANAGER_TYPE)))) {
		switch (0) {
			default:
			{
				IBusBus* _tmp4_;
				_tmp4_ = self->priv->bus;
				ibus_bus_set_global_engine (_tmp4_, source);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("LayoutsManager.vala:283: unrecognised input manager %s", manager);
				break;
			}
		}
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
keyboard_widgets_layout_manager_get_name_for_xkb_layout (KeyboardWidgetsLayoutManager* self,
                                                         const gchar* language,
                                                         const gchar* variant)
{
	xmlDoc* doc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* _tmp4_;
	xmlXPathContext* cntx = NULL;
	xmlDoc* _tmp5_;
	xmlXPathContext* _tmp6_;
	gchar* xpath = NULL;
	gchar* _tmp7_;
	xmlXPathObject* res = NULL;
	xmlXPathContext* _tmp13_;
	const gchar* _tmp14_;
	xmlXPathObject* _tmp15_;
	xmlXPathObject* _tmp16_;
	gboolean _tmp18_ = FALSE;
	xmlXPathObject* _tmp19_;
	gchar* name = NULL;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp24_;
	xmlNodeSet* _tmp25_;
	xmlNode* _tmp26_;
	xmlNode* _tmp27_;
	xmlXPathObject* _tmp32_;
	xmlDoc* _tmp33_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (language != NULL, NULL);
	g_debug ("LayoutsManager.vala:289: get_name_for_xkb_layout (%s, %s)", language, variant);
	_tmp0_ = keyboard_widgets_layout_manager_get_xml_rules_file_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = xmlParseFile (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		g_critical ("LayoutsManager.vala:292: '%s' not found or permissions incorrect\n", KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_RULES_FILE);
		result = NULL;
		return result;
	}
	_tmp5_ = doc;
	_tmp6_ = xmlXPathNewContext (_tmp5_);
	cntx = _tmp6_;
	_tmp7_ = g_strdup ("");
	xpath = _tmp7_;
	if (variant == NULL) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = string_to_string (language);
		_tmp9_ = g_strconcat ("/xkbConfigRegistry/layoutList/layout/configItem/name[text()='", _tmp8_, "']/../description", NULL);
		_g_free0 (xpath);
		xpath = _tmp9_;
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = string_to_string (language);
		_tmp11_ = string_to_string (variant);
		_tmp12_ = g_strconcat ("/xkbConfigRegistry/layoutList/layout/configItem/name[text()='", _tmp10_, "']/../../variantList/variant/configItem/name[text()='", _tmp11_, "']/../description", NULL);
		_g_free0 (xpath);
		xpath = _tmp12_;
	}
	_tmp13_ = cntx;
	_tmp14_ = xpath;
	_tmp15_ = xmlXPathEvalExpression ((xmlChar*) _tmp14_, _tmp13_);
	res = _tmp15_;
	_tmp16_ = res;
	if (_tmp16_ == NULL) {
		xmlDoc* _tmp17_;
		_tmp17_ = doc;
		_xmlFreeDoc0 (_tmp17_);
		g_critical ("LayoutsManager.vala:309: Unable to parse '%s'", KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_RULES_FILE);
		result = NULL;
		_g_free0 (xpath);
		_xmlXPathFreeContext0 (cntx);
		return result;
	}
	_tmp19_ = res;
	if (_tmp19_->type != XPATH_NODESET) {
		_tmp18_ = TRUE;
	} else {
		xmlXPathObject* _tmp20_;
		xmlNodeSet* _tmp21_;
		_tmp20_ = res;
		_tmp21_ = _tmp20_->nodesetval;
		_tmp18_ = _tmp21_ == NULL;
	}
	if (_tmp18_) {
		xmlXPathObject* _tmp22_;
		xmlDoc* _tmp23_;
		_tmp22_ = res;
		_xmlXPathFreeObject0 (_tmp22_);
		_tmp23_ = doc;
		_xmlFreeDoc0 (_tmp23_);
		g_warning ("LayoutsManager.vala:316: No name for %s: %s found in '%s'", language, variant, KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_RULES_FILE);
		result = NULL;
		_g_free0 (xpath);
		_xmlXPathFreeContext0 (cntx);
		return result;
	}
	name = NULL;
	_tmp24_ = res;
	_tmp25_ = _tmp24_->nodesetval;
	_tmp26_ = xmlXPathNodeSetItem (_tmp25_, 0);
	node = _tmp26_;
	_tmp27_ = node;
	if (_tmp27_ != NULL) {
		xmlNode* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp28_ = node;
		_tmp29_ = (gchar*) xmlNodeGetContent (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup (g_dgettext ("xkeyboard-config", _tmp30_));
		_g_free0 (name);
		name = _tmp31_;
		_g_free0 (_tmp30_);
	}
	_tmp32_ = res;
	_xmlXPathFreeObject0 (_tmp32_);
	_tmp33_ = doc;
	_xmlFreeDoc0 (_tmp33_);
	result = name;
	_g_free0 (xpath);
	_xmlXPathFreeContext0 (cntx);
	return result;
}

gchar*
keyboard_widgets_layout_manager_get_current_with_variant (KeyboardWidgetsLayoutManager* self)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_layout_variant;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->_current_language_code;
		_tmp2_ = g_strconcat (_tmp1_, "\t", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_current_layout_variant;
		_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp3_);
		result = _tmp6_;
		return result;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->_current_language_code;
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		return result;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		KeyboardWidgetsLayoutManager* self;
		self = _data1_->self;
		_g_free0 (_data1_->ibus_label);
		_g_free0 (_data1_->xkb_label);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda8_ (Block1Data* _data1_,
            GtkWidget* child)
{
	KeyboardWidgetsLayoutManager* self;
	KeyboardWidgetsLayoutButton* row = NULL;
	KeyboardWidgetsLayoutButton* _tmp0_;
	KeyboardWidgetsLayoutButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, KEYBOARD_WIDGETS_TYPE_LAYOUT_BUTTON, KeyboardWidgetsLayoutButton));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = keyboard_widgets_layout_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		KeyboardWidgetsLayoutButton* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = row;
		_tmp5_ = keyboard_widgets_layout_button_get_description (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("Keyboard Layout: %s"), _tmp7_);
		_g_free0 (_data1_->xkb_label);
		_data1_->xkb_label = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_g_object_unref0 (row);
}

static void
___lambda8__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda8_ (self, (GtkWidget*) data);
}

static void
__lambda9_ (Block1Data* _data1_,
            GtkWidget* child)
{
	KeyboardWidgetsLayoutManager* self;
	KeyboardWidgetsLayoutButton* row = NULL;
	KeyboardWidgetsLayoutButton* _tmp0_;
	KeyboardWidgetsLayoutButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, KEYBOARD_WIDGETS_TYPE_LAYOUT_BUTTON, KeyboardWidgetsLayoutButton));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = keyboard_widgets_layout_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		KeyboardWidgetsLayoutButton* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = row;
		_tmp5_ = keyboard_widgets_layout_button_get_description (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("Input Method: %s"), _tmp7_);
		_g_free0 (_data1_->ibus_label);
		_data1_->ibus_label = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_g_object_unref0 (row);
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (GtkWidget*) data);
}

gchar*
keyboard_widgets_layout_manager_get_current_description (KeyboardWidgetsLayoutManager* self)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GtkBox* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	const gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Default keyboard layout"));
	_data1_->xkb_label = _tmp0_;
	_tmp1_ = g_strdup ("");
	_data1_->ibus_label = _tmp1_;
	_tmp2_ = self->priv->xkb_box;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_list_foreach (_tmp4_, ___lambda8__gfunc, _data1_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	_tmp5_ = self->priv->ibus_box;
	_tmp6_ = gtk_container_get_children ((GtkContainer*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_list_foreach (_tmp7_, ___lambda9__gfunc, _data1_);
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
	_tmp8_ = _data1_->ibus_label;
	if (g_strcmp0 (_tmp8_, "") != 0) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = _data1_->ibus_label;
		_tmp10_ = _data1_->xkb_label;
		_tmp11_ = g_strdup_printf ("%s\n%s", _tmp9_, _tmp10_);
		result = _tmp11_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = _data1_->xkb_label;
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
}

static GVariant*
_variant_new2 (guint32 value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

void
keyboard_widgets_layout_manager_next (KeyboardWidgetsLayoutManager* self)
{
	GVariant* current = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	guint32 next = 0U;
	GVariant* _tmp2_;
	GtkBox* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GtkBox* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gboolean _tmp9_;
	GSettings* _tmp10_;
	GVariant* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "current");
	current = _tmp1_;
	_tmp2_ = current;
	next = g_variant_get_uint32 (_tmp2_) + 1;
	_tmp3_ = self->priv->xkb_box;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->ibus_box;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = next >= ((guint32) (g_list_length (_tmp5_) + g_list_length (_tmp8_)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	if (_tmp9_) {
		next = (guint32) 0;
	}
	_tmp10_ = self->priv->settings;
	_tmp11_ = _variant_new2 (next);
	g_settings_set_value (_tmp10_, "current", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_g_variant_unref0 (current);
}

static void
keyboard_widgets_layout_manager_set_active_layout_from_settings (KeyboardWidgetsLayoutManager* self)
{
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "current");
	_tmp2_ = _tmp1_;
	keyboard_widgets_layout_manager_set_active_layout (self, g_variant_get_uint32 (_tmp2_));
	_g_variant_unref0 (_tmp2_);
}

static GVariant*
_variant_new3 (guint32 value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

static void
keyboard_widgets_layout_manager_set_active_layout_to_xkb (KeyboardWidgetsLayoutManager* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xkb_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* child = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp2_;
			{
				KeyboardWidgetsLayoutButton* button = NULL;
				GtkWidget* _tmp3_;
				KeyboardWidgetsLayoutButton* _tmp4_;
				KeyboardWidgetsLayoutButton* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp3_ = child;
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, KEYBOARD_WIDGETS_TYPE_LAYOUT_BUTTON, KeyboardWidgetsLayoutButton));
				button = _tmp4_;
				_tmp5_ = button;
				_tmp6_ = keyboard_widgets_layout_button_get_active (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_) {
					GSettings* _tmp8_;
					KeyboardWidgetsLayoutButton* _tmp9_;
					guint32 _tmp10_;
					guint32 _tmp11_;
					GVariant* _tmp12_;
					KeyboardWidgetsLayoutButton* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp8_ = self->priv->settings;
					_tmp9_ = button;
					_tmp10_ = keyboard_widgets_layout_button_get_index (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = _variant_new3 (_tmp11_);
					g_settings_set_value (_tmp8_, "current", _tmp12_);
					_g_variant_unref0 (_tmp12_);
					_tmp13_ = button;
					_tmp14_ = keyboard_widgets_layout_button_get_source (_tmp13_);
					_tmp15_ = _tmp14_;
					keyboard_widgets_layout_manager_set_ibus_engine (self, KEYBOARD_WIDGETS_LAYOUT_MANAGER_XKB_MANAGER_TYPE, _tmp15_);
				}
				_g_object_unref0 (button);
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
keyboard_widgets_layout_manager_set_active_layout (KeyboardWidgetsLayoutManager* self,
                                                   guint32 index)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xkb_box;
	keyboard_widgets_layout_manager_set_layout_active_in_box (self, _tmp0_, (guint) index, FALSE);
	_tmp1_ = self->priv->ibus_box;
	keyboard_widgets_layout_manager_set_layout_active_in_box (self, _tmp1_, (guint) index, TRUE);
	g_signal_emit (self, keyboard_widgets_layout_manager_signals[KEYBOARD_WIDGETS_LAYOUT_MANAGER_UPDATED_SIGNAL], 0);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		KeyboardWidgetsLayoutManager* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->previously_active_button);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda6_ (Block2Data* _data2_,
            GtkWidget* widget)
{
	KeyboardWidgetsLayoutManager* self;
	KeyboardWidgetsLayoutButton* button = NULL;
	KeyboardWidgetsLayoutButton* _tmp0_;
	KeyboardWidgetsLayoutButton* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	self = _data2_->self;
	g_return_if_fail (widget != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, KEYBOARD_WIDGETS_TYPE_LAYOUT_BUTTON, KeyboardWidgetsLayoutButton));
	button = _tmp0_;
	_tmp1_ = button;
	_tmp2_ = keyboard_widgets_layout_button_get_index (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint32) _data2_->index)) {
		KeyboardWidgetsLayoutButton* _tmp4_;
		KeyboardWidgetsLayoutButton* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		KeyboardWidgetsLayoutButton* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		IBusBus* _tmp11_;
		_data2_->found = TRUE;
		_tmp4_ = button;
		keyboard_widgets_layout_button_set_active (_tmp4_, TRUE);
		_tmp5_ = button;
		_tmp6_ = keyboard_widgets_layout_button_get_language_code (_tmp5_);
		_tmp7_ = _tmp6_;
		keyboard_widgets_layout_manager_set_current_language_code (self, _tmp7_);
		_tmp8_ = button;
		_tmp9_ = keyboard_widgets_layout_button_get_layout_variant (_tmp8_);
		_tmp10_ = _tmp9_;
		keyboard_widgets_layout_manager_set_current_layout_variant (self, _tmp10_);
		_tmp11_ = self->priv->bus;
		if (ibus_bus_is_connected (_tmp11_)) {
			KeyboardWidgetsLayoutButton* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			KeyboardWidgetsLayoutButton* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp12_ = button;
			_tmp13_ = keyboard_widgets_layout_button_get_manager_type (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = button;
			_tmp16_ = keyboard_widgets_layout_button_get_source (_tmp15_);
			_tmp17_ = _tmp16_;
			keyboard_widgets_layout_manager_set_ibus_engine (self, _tmp14_, _tmp17_);
		}
	} else {
		KeyboardWidgetsLayoutButton* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = button;
		_tmp19_ = keyboard_widgets_layout_button_get_active (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			KeyboardWidgetsLayoutButton* _tmp21_;
			_tmp21_ = button;
			button = NULL;
			_g_object_unref0 (_data2_->previously_active_button);
			_data2_->previously_active_button = _tmp21_;
		}
	}
	_g_object_unref0 (button);
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (GtkWidget*) data);
}

static void
____lambda7_ (KeyboardWidgetsLayoutManager* self,
              GtkWidget* widget)
{
	g_return_if_fail (widget != NULL);
	keyboard_widgets_layout_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (widget, KEYBOARD_WIDGETS_TYPE_LAYOUT_BUTTON, KeyboardWidgetsLayoutButton), FALSE);
}

static void
_____lambda7__gfunc (gconstpointer data,
                     gpointer self)
{
	____lambda7_ ((KeyboardWidgetsLayoutManager*) self, (GtkWidget*) data);
}

static void
keyboard_widgets_layout_manager_set_layout_active_in_box (KeyboardWidgetsLayoutManager* self,
                                                          GtkBox* layout_box,
                                                          guint index,
                                                          gboolean clear)
{
	Block2Data* _data2_;
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout_box != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->index = index;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) layout_box);
	children = _tmp0_;
	_data2_->previously_active_button = NULL;
	_data2_->found = FALSE;
	_tmp1_ = children;
	g_list_foreach (_tmp1_, ___lambda6__gfunc, _data2_);
	if (_data2_->found) {
		KeyboardWidgetsLayoutButton* _tmp2_;
		_tmp2_ = _data2_->previously_active_button;
		if (_tmp2_ != NULL) {
			KeyboardWidgetsLayoutButton* _tmp3_;
			_tmp3_ = _data2_->previously_active_button;
			keyboard_widgets_layout_button_set_active (_tmp3_, FALSE);
		}
	} else {
		if (clear) {
			GList* _tmp4_;
			_tmp4_ = children;
			g_list_foreach (_tmp4_, _____lambda7__gfunc, self);
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

gboolean
keyboard_widgets_layout_manager_has_multiple_layouts (KeyboardWidgetsLayoutManager* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkBox* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->xkb_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->ibus_box;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (g_list_length (_tmp2_) + g_list_length (_tmp5_)) > ((guint) 1);
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	result = _tmp6_;
	return result;
}

KeyboardWidgetsLayoutManager*
keyboard_widgets_layout_manager_construct (GType object_type)
{
	KeyboardWidgetsLayoutManager * self = NULL;
	self = (KeyboardWidgetsLayoutManager*) g_object_new (object_type, NULL);
	return self;
}

KeyboardWidgetsLayoutManager*
keyboard_widgets_layout_manager_new (void)
{
	return keyboard_widgets_layout_manager_construct (KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER);
}

const gchar*
keyboard_widgets_layout_manager_get_current_language_code (KeyboardWidgetsLayoutManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_language_code;
	result = _tmp0_;
	return result;
}

void
keyboard_widgets_layout_manager_set_current_language_code (KeyboardWidgetsLayoutManager* self,
                                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_widgets_layout_manager_get_current_language_code (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_current_language_code);
		self->priv->_current_language_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_widgets_layout_manager_properties[KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY]);
	}
}

const gchar*
keyboard_widgets_layout_manager_get_current_layout_variant (KeyboardWidgetsLayoutManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_layout_variant;
	result = _tmp0_;
	return result;
}

void
keyboard_widgets_layout_manager_set_current_layout_variant (KeyboardWidgetsLayoutManager* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_widgets_layout_manager_get_current_layout_variant (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_current_layout_variant);
		self->priv->_current_layout_variant = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_widgets_layout_manager_properties[KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY]);
	}
}

static void
_keyboard_widgets_layout_manager___lambda10_ (KeyboardWidgetsLayoutManager* self)
{
	GraniteSwitchModelButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->ibus_header;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_;
		_tmp3_ = self->priv->ibus_box_revealer;
		gtk_revealer_set_reveal_child (_tmp3_, TRUE);
	} else {
		GtkRevealer* _tmp4_;
		_tmp4_ = self->priv->ibus_box_revealer;
		gtk_revealer_set_reveal_child (_tmp4_, FALSE);
		keyboard_widgets_layout_manager_set_active_layout_to_xkb (self);
	}
}

static void
__keyboard_widgets_layout_manager___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self)
{
	_keyboard_widgets_layout_manager___lambda10_ ((KeyboardWidgetsLayoutManager*) self);
}

static void
_keyboard_widgets_layout_manager___lambda11_ (KeyboardWidgetsLayoutManager* self)
{
	keyboard_widgets_layout_manager_populate_layouts (self);
}

static void
__keyboard_widgets_layout_manager___lambda11__g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	_keyboard_widgets_layout_manager___lambda11_ ((KeyboardWidgetsLayoutManager*) self);
}

static void
_keyboard_widgets_layout_manager___lambda12_ (KeyboardWidgetsLayoutManager* self)
{
	keyboard_widgets_layout_manager_populate_layouts (self);
}

static void
__keyboard_widgets_layout_manager___lambda12__ibus_bus_connected (IBusBus* _sender,
                                                                  gpointer self)
{
	_keyboard_widgets_layout_manager___lambda12_ ((KeyboardWidgetsLayoutManager*) self);
}

static void
_keyboard_widgets_layout_manager___lambda13_ (KeyboardWidgetsLayoutManager* self)
{
	keyboard_widgets_layout_manager_populate_layouts (self);
}

static void
__keyboard_widgets_layout_manager___lambda13__ibus_bus_disconnected (IBusBus* _sender,
                                                                     gpointer self)
{
	_keyboard_widgets_layout_manager___lambda13_ ((KeyboardWidgetsLayoutManager*) self);
}

static void
_keyboard_widgets_layout_manager___lambda14_ (KeyboardWidgetsLayoutManager* self)
{
	keyboard_widgets_layout_manager_set_active_layout_from_settings (self);
	g_signal_emit (self, keyboard_widgets_layout_manager_signals[KEYBOARD_WIDGETS_LAYOUT_MANAGER_UPDATED_SIGNAL], 0);
}

static void
__keyboard_widgets_layout_manager___lambda14__g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	_keyboard_widgets_layout_manager___lambda14_ ((KeyboardWidgetsLayoutManager*) self);
}

static void
_keyboard_widgets_layout_manager_action_change_layout_g_simple_action_activate (GSimpleAction* _sender,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	keyboard_widgets_layout_manager_action_change_layout ((KeyboardWidgetsLayoutManager*) self, _sender, parameter);
}

static GObject *
keyboard_widgets_layout_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardWidgetsLayoutManager * self;
	IBusBus* _tmp0_;
	GtkLabel* xkb_header = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBox* _tmp4_ = NULL;
	GtkBox* ibus_header_box = NULL;
	GtkBox* _tmp5_;
	GtkSeparator* ibus_separator = NULL;
	GtkSeparator* _tmp6_ = NULL;
	GraniteSwitchModelButton* _tmp7_ = NULL;
	GraniteSwitchModelButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBox* _tmp10_;
	GtkSeparator* _tmp11_;
	GtkBox* _tmp12_;
	GraniteSwitchModelButton* _tmp13_;
	GtkRevealer* _tmp14_;
	GtkRevealer* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_ = NULL;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkBox* _tmp20_;
	GraniteSwitchModelButton* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkRevealer* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	IBusBus* _tmp28_;
	IBusBus* _tmp29_;
	GSettings* _tmp30_;
	GSimpleActionGroup* _tmp31_;
	GSimpleAction* action_change_current_layout = NULL;
	GVariantType* _tmp32_;
	GVariantType* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GSimpleAction* _tmp36_;
	GSimpleAction* _tmp37_;
	GSimpleAction* _tmp38_;
	GSimpleActionGroup* _tmp39_;
	GSimpleAction* _tmp40_;
	GSimpleActionGroup* _tmp41_;
	parent_class = G_OBJECT_CLASS (keyboard_widgets_layout_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER, KeyboardWidgetsLayoutManager);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	ibus_init ();
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Keyboard Layout"));
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp1_);
	xkb_header = _tmp1_;
	_tmp2_ = xkb_header;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->xkb_box);
	self->priv->xkb_box = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	ibus_header_box = _tmp5_;
	_tmp6_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp6_, 3);
	g_object_ref_sink (_tmp6_);
	ibus_separator = _tmp6_;
	_tmp7_ = granite_switch_model_button_new (_ ("Input Method"));
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->ibus_header);
	self->priv->ibus_header = _tmp7_;
	_tmp8_ = self->priv->ibus_header;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp10_ = ibus_header_box;
	_tmp11_ = ibus_separator;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = ibus_header_box;
	_tmp13_ = self->priv->ibus_header;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->ibus_header_revealer);
	self->priv->ibus_header_revealer = _tmp14_;
	_tmp15_ = self->priv->ibus_header_revealer;
	_tmp16_ = ibus_header_box;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->ibus_box);
	self->priv->ibus_box = _tmp17_;
	_tmp18_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->ibus_box_revealer);
	self->priv->ibus_box_revealer = _tmp18_;
	_tmp19_ = self->priv->ibus_box_revealer;
	_tmp20_ = self->priv->ibus_box;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->ibus_header;
	g_signal_connect_object ((GtkToggleButton*) _tmp21_, "toggled", (GCallback) __keyboard_widgets_layout_manager___lambda10__gtk_toggle_button_toggled, self, 0);
	_tmp22_ = xkb_header;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->xkb_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->ibus_header_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->ibus_box_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp26_;
	_tmp27_ = self->priv->settings;
	g_signal_connect_object (_tmp27_, "changed::sources", (GCallback) __keyboard_widgets_layout_manager___lambda11__g_settings_changed, self, 0);
	_tmp28_ = self->priv->bus;
	g_signal_connect_object (_tmp28_, "connected", (GCallback) __keyboard_widgets_layout_manager___lambda12__ibus_bus_connected, self, 0);
	_tmp29_ = self->priv->bus;
	g_signal_connect_object (_tmp29_, "disconnected", (GCallback) __keyboard_widgets_layout_manager___lambda13__ibus_bus_disconnected, self, 0);
	_tmp30_ = self->priv->settings;
	g_signal_connect_object (_tmp30_, "changed::current", (GCallback) __keyboard_widgets_layout_manager___lambda14__g_settings_changed, self, G_CONNECT_AFTER);
	_tmp31_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp31_;
	_tmp32_ = g_variant_type_new ("u");
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_new_boolean (TRUE);
	g_variant_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_simple_action_new_stateful ("change-layout", _tmp33_, _tmp35_);
	_tmp37_ = _tmp36_;
	_g_variant_unref0 (_tmp35_);
	_g_variant_type_free0 (_tmp33_);
	action_change_current_layout = _tmp37_;
	_tmp38_ = action_change_current_layout;
	g_signal_connect_object (_tmp38_, "activate", (GCallback) _keyboard_widgets_layout_manager_action_change_layout_g_simple_action_activate, self, 0);
	_tmp39_ = self->priv->actions;
	_tmp40_ = action_change_current_layout;
	g_action_map_add_action ((GActionMap*) _tmp39_, (GAction*) _tmp40_);
	_tmp41_ = self->priv->actions;
	gtk_widget_insert_action_group ((GtkWidget*) self, "manager", (GActionGroup*) _tmp41_);
	gtk_widget_show_all ((GtkWidget*) self);
	keyboard_widgets_layout_manager_populate_layouts (self);
	_g_object_unref0 (action_change_current_layout);
	_g_object_unref0 (ibus_separator);
	_g_object_unref0 (ibus_header_box);
	_g_object_unref0 (xkb_header);
	return obj;
}

static void
keyboard_widgets_layout_manager_class_init (KeyboardWidgetsLayoutManagerClass * klass,
                                            gpointer klass_data)
{
	keyboard_widgets_layout_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardWidgetsLayoutManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_widgets_layout_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_widgets_layout_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_widgets_layout_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_widgets_layout_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY, keyboard_widgets_layout_manager_properties[KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY] = g_param_spec_string ("current-language-code", "current-language-code", "current-language-code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY, keyboard_widgets_layout_manager_properties[KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY] = g_param_spec_string ("current-layout-variant", "current-layout-variant", "current-layout-variant", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	keyboard_widgets_layout_manager_signals[KEYBOARD_WIDGETS_LAYOUT_MANAGER_UPDATED_SIGNAL] = g_signal_new ("updated", KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
keyboard_widgets_layout_manager_instance_init (KeyboardWidgetsLayoutManager * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = keyboard_widgets_layout_manager_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_current_language_code = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_current_layout_variant = _tmp1_;
}

static void
keyboard_widgets_layout_manager_finalize (GObject * obj)
{
	KeyboardWidgetsLayoutManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER, KeyboardWidgetsLayoutManager);
	_g_free0 (self->priv->_current_language_code);
	_g_free0 (self->priv->_current_layout_variant);
	_g_object_unref0 (self->priv->settings);
	(self->priv->engines == NULL) ? NULL : (self->priv->engines = (_g_list_free__g_object_unref0_ (self->priv->engines), NULL));
	_g_object_unref0 (self->priv->xkb_box);
	_g_object_unref0 (self->priv->ibus_box);
	_g_object_unref0 (self->priv->ibus_box_revealer);
	_g_object_unref0 (self->priv->ibus_header_revealer);
	_g_object_unref0 (self->priv->ibus_header);
	_g_object_unref0 (self->priv->bus);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (keyboard_widgets_layout_manager_parent_class)->finalize (obj);
}

static GType
keyboard_widgets_layout_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardWidgetsLayoutManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_widgets_layout_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardWidgetsLayoutManager), 0, (GInstanceInitFunc) keyboard_widgets_layout_manager_instance_init, NULL };
	GType keyboard_widgets_layout_manager_type_id;
	keyboard_widgets_layout_manager_type_id = g_type_register_static (gtk_box_get_type (), "KeyboardWidgetsLayoutManager", &g_define_type_info, 0);
	KeyboardWidgetsLayoutManager_private_offset = g_type_add_instance_private (keyboard_widgets_layout_manager_type_id, sizeof (KeyboardWidgetsLayoutManagerPrivate));
	return keyboard_widgets_layout_manager_type_id;
}

GType
keyboard_widgets_layout_manager_get_type (void)
{
	static volatile gsize keyboard_widgets_layout_manager_type_id__once = 0;
	if (g_once_init_enter (&keyboard_widgets_layout_manager_type_id__once)) {
		GType keyboard_widgets_layout_manager_type_id;
		keyboard_widgets_layout_manager_type_id = keyboard_widgets_layout_manager_get_type_once ();
		g_once_init_leave (&keyboard_widgets_layout_manager_type_id__once, keyboard_widgets_layout_manager_type_id);
	}
	return keyboard_widgets_layout_manager_type_id__once;
}

static void
_vala_keyboard_widgets_layout_manager_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	KeyboardWidgetsLayoutManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER, KeyboardWidgetsLayoutManager);
	switch (property_id) {
		case KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY:
		g_value_set_string (value, keyboard_widgets_layout_manager_get_current_language_code (self));
		break;
		case KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY:
		g_value_set_string (value, keyboard_widgets_layout_manager_get_current_layout_variant (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_widgets_layout_manager_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	KeyboardWidgetsLayoutManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_WIDGETS_TYPE_LAYOUT_MANAGER, KeyboardWidgetsLayoutManager);
	switch (property_id) {
		case KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LANGUAGE_CODE_PROPERTY:
		keyboard_widgets_layout_manager_set_current_language_code (self, g_value_get_string (value));
		break;
		case KEYBOARD_WIDGETS_LAYOUT_MANAGER_CURRENT_LAYOUT_VARIANT_PROPERTY:
		keyboard_widgets_layout_manager_set_current_layout_variant (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

