// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "ShadowProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::ShadowPropertyPrivate
{
public:
    std::optional<OffsetProperty> offset;
    std::optional<Union::Color> color;
    std::optional<qreal> size;
    std::optional<qreal> blur;
    std::optional<LineProperty> left;
    std::optional<LineProperty> right;
    std::optional<LineProperty> top;
    std::optional<LineProperty> bottom;
    std::optional<CornerProperty> topLeft;
    std::optional<CornerProperty> topRight;
    std::optional<CornerProperty> bottomLeft;
    std::optional<CornerProperty> bottomRight;
};

ShadowProperty::ShadowProperty()
    : d(std::make_unique<ShadowPropertyPrivate>())
{
}

ShadowProperty::ShadowProperty(const ShadowProperty &other)
    : d(std::make_unique<ShadowPropertyPrivate>())
{
    d->offset = other.d->offset;
    d->color = other.d->color;
    d->size = other.d->size;
    d->blur = other.d->blur;
    d->left = other.d->left;
    d->right = other.d->right;
    d->top = other.d->top;
    d->bottom = other.d->bottom;
    d->topLeft = other.d->topLeft;
    d->topRight = other.d->topRight;
    d->bottomLeft = other.d->bottomLeft;
    d->bottomRight = other.d->bottomRight;
}

ShadowProperty::ShadowProperty(ShadowProperty &&other)
    : d(std::move(other.d))
{
}

ShadowProperty::~ShadowProperty() = default;

ShadowProperty &ShadowProperty::operator=(const ShadowProperty &other)
{
    if (this != &other) {
        d->offset = other.d->offset;
        d->color = other.d->color;
        d->size = other.d->size;
        d->blur = other.d->blur;
        d->left = other.d->left;
        d->right = other.d->right;
        d->top = other.d->top;
        d->bottom = other.d->bottom;
        d->topLeft = other.d->topLeft;
        d->topRight = other.d->topRight;
        d->bottomLeft = other.d->bottomLeft;
        d->bottomRight = other.d->bottomRight;
    }
    return *this;
}

ShadowProperty &ShadowProperty::operator=(ShadowProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<OffsetProperty> ShadowProperty::offset() const
{
    return d->offset;
}

OffsetProperty ShadowProperty::offset_or_new() const
{
    return d->offset.value_or(OffsetProperty{});
}

void ShadowProperty::setOffset(const std::optional<OffsetProperty> &newValue)
{
    if (newValue == d->offset) {
        return;
    }

    d->offset = newValue;
}
std::optional<Union::Color> ShadowProperty::color() const
{
    return d->color;
}

void ShadowProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}
std::optional<qreal> ShadowProperty::size() const
{
    return d->size;
}

void ShadowProperty::setSize(const std::optional<qreal> &newValue)
{
    if (newValue == d->size) {
        return;
    }

    d->size = newValue;
}
std::optional<qreal> ShadowProperty::blur() const
{
    return d->blur;
}

void ShadowProperty::setBlur(const std::optional<qreal> &newValue)
{
    if (newValue == d->blur) {
        return;
    }

    d->blur = newValue;
}
std::optional<LineProperty> ShadowProperty::left() const
{
    return d->left;
}

LineProperty ShadowProperty::left_or_new() const
{
    return d->left.value_or(LineProperty{});
}

void ShadowProperty::setLeft(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->left) {
        return;
    }

    d->left = newValue;
}
std::optional<LineProperty> ShadowProperty::right() const
{
    return d->right;
}

LineProperty ShadowProperty::right_or_new() const
{
    return d->right.value_or(LineProperty{});
}

void ShadowProperty::setRight(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->right) {
        return;
    }

    d->right = newValue;
}
std::optional<LineProperty> ShadowProperty::top() const
{
    return d->top;
}

LineProperty ShadowProperty::top_or_new() const
{
    return d->top.value_or(LineProperty{});
}

void ShadowProperty::setTop(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->top) {
        return;
    }

    d->top = newValue;
}
std::optional<LineProperty> ShadowProperty::bottom() const
{
    return d->bottom;
}

LineProperty ShadowProperty::bottom_or_new() const
{
    return d->bottom.value_or(LineProperty{});
}

void ShadowProperty::setBottom(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->bottom) {
        return;
    }

    d->bottom = newValue;
}
std::optional<CornerProperty> ShadowProperty::topLeft() const
{
    return d->topLeft;
}

CornerProperty ShadowProperty::topLeft_or_new() const
{
    return d->topLeft.value_or(CornerProperty{});
}

void ShadowProperty::setTopLeft(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->topLeft) {
        return;
    }

    d->topLeft = newValue;
}
std::optional<CornerProperty> ShadowProperty::topRight() const
{
    return d->topRight;
}

CornerProperty ShadowProperty::topRight_or_new() const
{
    return d->topRight.value_or(CornerProperty{});
}

void ShadowProperty::setTopRight(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->topRight) {
        return;
    }

    d->topRight = newValue;
}
std::optional<CornerProperty> ShadowProperty::bottomLeft() const
{
    return d->bottomLeft;
}

CornerProperty ShadowProperty::bottomLeft_or_new() const
{
    return d->bottomLeft.value_or(CornerProperty{});
}

void ShadowProperty::setBottomLeft(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->bottomLeft) {
        return;
    }

    d->bottomLeft = newValue;
}
std::optional<CornerProperty> ShadowProperty::bottomRight() const
{
    return d->bottomRight;
}

CornerProperty ShadowProperty::bottomRight_or_new() const
{
    return d->bottomRight.value_or(CornerProperty{});
}

void ShadowProperty::setBottomRight(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->bottomRight) {
        return;
    }

    d->bottomRight = newValue;
}

bool ShadowProperty::hasAnyValue() const
{
    if (d->offset.has_value() && d->offset->hasAnyValue()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    if (d->size.has_value()) {
        return true;
    }
    if (d->blur.has_value()) {
        return true;
    }
    if (d->left.has_value() && d->left->hasAnyValue()) {
        return true;
    }
    if (d->right.has_value() && d->right->hasAnyValue()) {
        return true;
    }
    if (d->top.has_value() && d->top->hasAnyValue()) {
        return true;
    }
    if (d->bottom.has_value() && d->bottom->hasAnyValue()) {
        return true;
    }
    if (d->topLeft.has_value() && d->topLeft->hasAnyValue()) {
        return true;
    }
    if (d->topRight.has_value() && d->topRight->hasAnyValue()) {
        return true;
    }
    if (d->bottomLeft.has_value() && d->bottomLeft->hasAnyValue()) {
        return true;
    }
    if (d->bottomRight.has_value() && d->bottomRight->hasAnyValue()) {
        return true;
    }
    return false;
}

bool ShadowProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->offset.has_value() && !d->offset->isEmpty()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }
    if (d->size.has_value() && d->size.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->blur.has_value() && d->blur.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->left.has_value() && !d->left->isEmpty()) {
        return false;
    }
    if (d->right.has_value() && !d->right->isEmpty()) {
        return false;
    }
    if (d->top.has_value() && !d->top->isEmpty()) {
        return false;
    }
    if (d->bottom.has_value() && !d->bottom->isEmpty()) {
        return false;
    }
    if (d->topLeft.has_value() && !d->topLeft->isEmpty()) {
        return false;
    }
    if (d->topRight.has_value() && !d->topRight->isEmpty()) {
        return false;
    }
    if (d->bottomLeft.has_value() && !d->bottomLeft->isEmpty()) {
        return false;
    }
    if (d->bottomRight.has_value() && !d->bottomRight->isEmpty()) {
        return false;
    }

    return true;
}

void ShadowProperty::resolveProperties(const ShadowProperty &source, ShadowProperty &destination)
{
    if (source.d->offset.has_value()) {
        OffsetProperty property;
        if (destination.d->offset.has_value()) {
            property = destination.d->offset.value();
        }
        OffsetProperty::resolveProperties(source.d->offset.value(), property);
        if (property.hasAnyValue()) {
            destination.d->offset = property;
        }
    }
    if (!destination.d->color.has_value()) {
        destination.d->color = source.d->color;
    }
    if (!destination.d->size.has_value()) {
        destination.d->size = source.d->size;
    }
    if (!destination.d->blur.has_value()) {
        destination.d->blur = source.d->blur;
    }
    if (source.d->left.has_value()) {
        LineProperty property;
        if (destination.d->left.has_value()) {
            property = destination.d->left.value();
        }
        LineProperty::resolveProperties(source.d->left.value(), property);
        if (property.hasAnyValue()) {
            destination.d->left = property;
        }
    }
    if (source.d->right.has_value()) {
        LineProperty property;
        if (destination.d->right.has_value()) {
            property = destination.d->right.value();
        }
        LineProperty::resolveProperties(source.d->right.value(), property);
        if (property.hasAnyValue()) {
            destination.d->right = property;
        }
    }
    if (source.d->top.has_value()) {
        LineProperty property;
        if (destination.d->top.has_value()) {
            property = destination.d->top.value();
        }
        LineProperty::resolveProperties(source.d->top.value(), property);
        if (property.hasAnyValue()) {
            destination.d->top = property;
        }
    }
    if (source.d->bottom.has_value()) {
        LineProperty property;
        if (destination.d->bottom.has_value()) {
            property = destination.d->bottom.value();
        }
        LineProperty::resolveProperties(source.d->bottom.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottom = property;
        }
    }
    if (source.d->topLeft.has_value()) {
        CornerProperty property;
        if (destination.d->topLeft.has_value()) {
            property = destination.d->topLeft.value();
        }
        CornerProperty::resolveProperties(source.d->topLeft.value(), property);
        if (property.hasAnyValue()) {
            destination.d->topLeft = property;
        }
    }
    if (source.d->topRight.has_value()) {
        CornerProperty property;
        if (destination.d->topRight.has_value()) {
            property = destination.d->topRight.value();
        }
        CornerProperty::resolveProperties(source.d->topRight.value(), property);
        if (property.hasAnyValue()) {
            destination.d->topRight = property;
        }
    }
    if (source.d->bottomLeft.has_value()) {
        CornerProperty property;
        if (destination.d->bottomLeft.has_value()) {
            property = destination.d->bottomLeft.value();
        }
        CornerProperty::resolveProperties(source.d->bottomLeft.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottomLeft = property;
        }
    }
    if (source.d->bottomRight.has_value()) {
        CornerProperty property;
        if (destination.d->bottomRight.has_value()) {
            property = destination.d->bottomRight.value();
        }
        CornerProperty::resolveProperties(source.d->bottomRight.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottomRight = property;
        }
    }
}

ShadowProperty ShadowProperty::empty()
{
    ShadowProperty result;
    result.d->offset = emptyValue<OffsetProperty>();
    result.d->color = emptyValue<Union::Color>();
    result.d->size = emptyValue<qreal>();
    result.d->blur = emptyValue<qreal>();
    result.d->left = emptyValue<LineProperty>();
    result.d->right = emptyValue<LineProperty>();
    result.d->top = emptyValue<LineProperty>();
    result.d->bottom = emptyValue<LineProperty>();
    result.d->topLeft = emptyValue<CornerProperty>();
    result.d->topRight = emptyValue<CornerProperty>();
    result.d->bottomLeft = emptyValue<CornerProperty>();
    result.d->bottomRight = emptyValue<CornerProperty>();
    return result;
}

bool Union::Properties::operator==(const ShadowProperty &left, const ShadowProperty &right)
{
    if (left.offset() != right.offset()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    if (left.size() != right.size()) {
        return false;
    }
    if (left.blur() != right.blur()) {
        return false;
    }
    if (left.left() != right.left()) {
        return false;
    }
    if (left.right() != right.right()) {
        return false;
    }
    if (left.top() != right.top()) {
        return false;
    }
    if (left.bottom() != right.bottom()) {
        return false;
    }
    if (left.topLeft() != right.topLeft()) {
        return false;
    }
    if (left.topRight() != right.topRight()) {
        return false;
    }
    if (left.bottomLeft() != right.bottomLeft()) {
        return false;
    }
    if (left.bottomRight() != right.bottomRight()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::ShadowProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "ShadowProperty(" //
                    << "offset: " << type.offset() //
                    << ", color: " << type.color() //
                    << ", size: " << type.size() //
                    << ", blur: " << type.blur() //
                    << ", left: " << type.left() //
                    << ", right: " << type.right() //
                    << ", top: " << type.top() //
                    << ", bottom: " << type.bottom() //
                    << ", topLeft: " << type.topLeft() //
                    << ", topRight: " << type.topRight() //
                    << ", bottomLeft: " << type.bottomLeft() //
                    << ", bottomRight: " << type.bottomRight() //
                    << ")";
    return debug;
}