/* BackupWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackupWindow.vala, do not modify */

/*
 * BackupWindow.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKUP_WINDOW (backup_window_get_type ())
#define BACKUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_WINDOW, BackupWindow))
#define BACKUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_WINDOW, BackupWindowClass))
#define IS_BACKUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_WINDOW))
#define IS_BACKUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_WINDOW))
#define BACKUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_WINDOW, BackupWindowClass))

typedef struct _BackupWindow BackupWindow;
typedef struct _BackupWindowClass BackupWindowClass;
typedef struct _BackupWindowPrivate BackupWindowPrivate;

#define TYPE_ESTIMATE_BOX (estimate_box_get_type ())
#define ESTIMATE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ESTIMATE_BOX, EstimateBox))
#define ESTIMATE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ESTIMATE_BOX, EstimateBoxClass))
#define IS_ESTIMATE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ESTIMATE_BOX))
#define IS_ESTIMATE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ESTIMATE_BOX))
#define ESTIMATE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ESTIMATE_BOX, EstimateBoxClass))

typedef struct _EstimateBox EstimateBox;
typedef struct _EstimateBoxClass EstimateBoxClass;

#define TYPE_BACKUP_DEVICE_BOX (backup_device_box_get_type ())
#define BACKUP_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBox))
#define BACKUP_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBoxClass))
#define IS_BACKUP_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_DEVICE_BOX))
#define IS_BACKUP_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_DEVICE_BOX))
#define BACKUP_DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBoxClass))

typedef struct _BackupDeviceBox BackupDeviceBox;
typedef struct _BackupDeviceBoxClass BackupDeviceBoxClass;

#define TYPE_BACKUP_BOX (backup_box_get_type ())
#define BACKUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_BOX, BackupBox))
#define BACKUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_BOX, BackupBoxClass))
#define IS_BACKUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_BOX))
#define IS_BACKUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_BOX))
#define BACKUP_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_BOX, BackupBoxClass))

typedef struct _BackupBox BackupBox;
typedef struct _BackupBoxClass BackupBoxClass;

#define TYPE_BACKUP_FINISH_BOX (backup_finish_box_get_type ())
#define BACKUP_FINISH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_FINISH_BOX, BackupFinishBox))
#define BACKUP_FINISH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_FINISH_BOX, BackupFinishBoxClass))
#define IS_BACKUP_FINISH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_FINISH_BOX))
#define IS_BACKUP_FINISH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_FINISH_BOX))
#define BACKUP_FINISH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_FINISH_BOX, BackupFinishBoxClass))

typedef struct _BackupFinishBox BackupFinishBox;
typedef struct _BackupFinishBoxClass BackupFinishBoxClass;
enum  {
	BACKUP_WINDOW_0_PROPERTY,
	BACKUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* backup_window_properties[BACKUP_WINDOW_NUM_PROPERTIES];
typedef enum  {
	BACKUP_WINDOW_TABS_ESTIMATE = 0,
	BACKUP_WINDOW_TABS_BACKUP_DEVICE = 1,
	BACKUP_WINDOW_TABS_BACKUP = 2,
	BACKUP_WINDOW_TABS_BACKUP_FINISH = 3
} BackupWindowTabs;

#define BACKUP_WINDOW_TYPE_TABS (backup_window_tabs_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())

struct _BackupWindow {
	GtkWindow parent_instance;
	BackupWindowPrivate * priv;
};

struct _BackupWindowClass {
	GtkWindowClass parent_class;
};

struct _BackupWindowPrivate {
	GtkBox* vbox_main;
	GtkNotebook* notebook;
	GtkButtonBox* bbox_action;
	EstimateBox* estimate_box;
	BackupDeviceBox* backup_dev_box;
	BackupBox* backup_box;
	BackupFinishBox* backup_finish_box;
	GtkButton* btn_prev;
	GtkButton* btn_next;
	GtkButton* btn_cancel;
	GtkButton* btn_pause;
	GtkButton* btn_close;
	guint tmr_init;
	gint def_width;
	gint def_height;
	gboolean success;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

static gint BackupWindow_private_offset;
static gpointer backup_window_parent_class = NULL;
VALA_EXTERN Main* App;
VALA_EXTERN guint64 main_first_snapshot_size;

VALA_EXTERN GType backup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupWindow, g_object_unref)
VALA_EXTERN GType estimate_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EstimateBox, g_object_unref)
VALA_EXTERN GType backup_device_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupDeviceBox, g_object_unref)
VALA_EXTERN GType backup_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupBox, g_object_unref)
VALA_EXTERN GType backup_finish_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupFinishBox, g_object_unref)
VALA_EXTERN GType backup_window_tabs_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackupWindow* backup_window_new (void);
VALA_EXTERN BackupWindow* backup_window_construct (GType object_type);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
static gboolean backup_window_on_delete_event (BackupWindow* self,
                                        GdkEventAny* event);
static gboolean _backup_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                 GdkEventAny* event,
                                                                 gpointer self);
VALA_EXTERN GtkNotebook* tee_jee_gtk_helper_add_notebook (GtkBox* box,
                                              gboolean show_tabs,
                                              gboolean show_border);
VALA_EXTERN EstimateBox* estimate_box_new (GtkWindow* _parent_window);
VALA_EXTERN EstimateBox* estimate_box_construct (GType object_type,
                                     GtkWindow* _parent_window);
VALA_EXTERN BackupDeviceBox* backup_device_box_new (GtkWindow* _parent_window);
VALA_EXTERN BackupDeviceBox* backup_device_box_construct (GType object_type,
                                              GtkWindow* _parent_window);
VALA_EXTERN BackupBox* backup_box_new (GtkWindow* _parent_window);
VALA_EXTERN BackupBox* backup_box_construct (GType object_type,
                                 GtkWindow* _parent_window);
VALA_EXTERN BackupFinishBox* backup_finish_box_new (GtkWindow* _parent_window);
VALA_EXTERN BackupFinishBox* backup_finish_box_construct (GType object_type,
                                              GtkWindow* _parent_window);
static void backup_window_create_actions (BackupWindow* self);
static gboolean backup_window_init_delayed (BackupWindow* self);
static gboolean _backup_window_init_delayed_gsource_func (gpointer self);
static void backup_window_go_first (BackupWindow* self);
static void backup_window_save_changes (BackupWindow* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN void main_cron_job_update (Main* self);
VALA_EXTERN GtkButton* tee_jee_gtk_helper_add_button (GtkBox* box,
                                          const gchar* text,
                                          const gchar* tooltip,
                                          GtkSizeGroup* size_group,
                                          GtkImage* icon);
static void __lambda95_ (BackupWindow* self);
static void backup_window_go_prev (BackupWindow* self);
static void ___lambda95__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda96_ (BackupWindow* self);
static void backup_window_go_next (BackupWindow* self);
static void ___lambda96__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda97_ (BackupWindow* self);
static void ___lambda97__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda98_ (BackupWindow* self);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void async_task_stop (AsyncTask* self,
                      AppStatus status_to_update);
static void ___lambda98__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda99_ (BackupWindow* self);
VALA_EXTERN void async_task_resume (AsyncTask* self,
                        AppStatus status_to_update);
VALA_EXTERN void backup_box_resume (BackupBox* self);
VALA_EXTERN void async_task_pause (AsyncTask* self,
                       AppStatus status_to_update);
VALA_EXTERN void backup_box_pause (BackupBox* self);
static void ___lambda99__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void backup_window_action_buttons_set_no_show_all (BackupWindow* self,
                                                   gboolean val);
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_has_space (SnapshotRepo* self,
                                  guint64 needed);
static void backup_window_initialize_tab (BackupWindow* self);
static gboolean backup_window_validate_current_tab (BackupWindow* self);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN void estimate_box_estimate_system_size (EstimateBox* self);
VALA_EXTERN void backup_device_box_refresh (BackupDeviceBox* self);
VALA_EXTERN gboolean backup_box_take_snapshot (BackupBox* self);
VALA_EXTERN void backup_finish_box_update_message (BackupFinishBox* self,
                                       gboolean success);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN void tee_jee_gtk_helper_wait_and_close_window (gint milliseconds,
                                               GtkWindow* window);
static void backup_window_finalize (GObject * obj);
static GType backup_window_get_type_once (void);

static inline gpointer
backup_window_get_instance_private (BackupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BackupWindow_private_offset);
}

static GType
backup_window_tabs_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKUP_WINDOW_TABS_ESTIMATE, "BACKUP_WINDOW_TABS_ESTIMATE", "estimate"}, {BACKUP_WINDOW_TABS_BACKUP_DEVICE, "BACKUP_WINDOW_TABS_BACKUP_DEVICE", "backup-device"}, {BACKUP_WINDOW_TABS_BACKUP, "BACKUP_WINDOW_TABS_BACKUP", "backup"}, {BACKUP_WINDOW_TABS_BACKUP_FINISH, "BACKUP_WINDOW_TABS_BACKUP_FINISH", "backup-finish"}, {0, NULL, NULL}};
	GType backup_window_tabs_type_id;
	backup_window_tabs_type_id = g_enum_register_static ("BackupWindowTabs", values);
	return backup_window_tabs_type_id;
}

GType
backup_window_tabs_get_type (void)
{
	static volatile gsize backup_window_tabs_type_id__once = 0;
	if (g_once_init_enter (&backup_window_tabs_type_id__once)) {
		GType backup_window_tabs_type_id;
		backup_window_tabs_type_id = backup_window_tabs_get_type_once ();
		g_once_init_leave (&backup_window_tabs_type_id__once, backup_window_tabs_type_id);
	}
	return backup_window_tabs_type_id__once;
}

static gboolean
_backup_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                        GdkEventAny* event,
                                                        gpointer self)
{
	gboolean result;
	result = backup_window_on_delete_event ((BackupWindow*) self, event);
	return result;
}

static gboolean
_backup_window_init_delayed_gsource_func (gpointer self)
{
	gboolean result;
	result = backup_window_init_delayed ((BackupWindow*) self);
	return result;
}

BackupWindow*
backup_window_construct (GType object_type)
{
	BackupWindow * self = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkNotebook* _tmp6_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_;
	EstimateBox* _tmp8_;
	EstimateBox* _tmp9_;
	GtkNotebook* _tmp10_;
	EstimateBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	BackupDeviceBox* _tmp14_;
	BackupDeviceBox* _tmp15_;
	GtkNotebook* _tmp16_;
	BackupDeviceBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	BackupBox* _tmp20_;
	BackupBox* _tmp21_;
	GtkNotebook* _tmp22_;
	BackupBox* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	BackupFinishBox* _tmp26_;
	BackupFinishBox* _tmp27_;
	GtkNotebook* _tmp28_;
	BackupFinishBox* _tmp29_;
	GtkLabel* _tmp30_;
	self = (BackupWindow*) g_object_new (object_type, NULL);
	tee_jee_logging_log_debug ("BackupWindow: BackupWindow()");
	gtk_window_set_title ((GtkWindow*) self, _ ("Create Snapshot"));
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER, NULL);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_default_size ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	_tmp0_ = icon_manager_lookup ("timeshift", 16, FALSE, FALSE, 1);
	_tmp1_ = _tmp0_;
	gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _backup_window_on_delete_event_gtk_widget_delete_event, self, 0);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->vbox_main);
	self->priv->vbox_main = _tmp2_;
	_tmp3_ = self->priv->vbox_main;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 0, NULL);
	_tmp4_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	gtk_window_resize ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	_tmp5_ = self->priv->vbox_main;
	_tmp6_ = tee_jee_gtk_helper_add_notebook (_tmp5_, FALSE, FALSE);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp6_;
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Estimate"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (label);
	label = _tmp7_;
	_tmp8_ = estimate_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->estimate_box);
	self->priv->estimate_box = _tmp8_;
	_tmp9_ = self->priv->estimate_box;
	g_object_set ((GtkWidget*) _tmp9_, "margin", 12, NULL);
	_tmp10_ = self->priv->notebook;
	_tmp11_ = self->priv->estimate_box;
	_tmp12_ = label;
	gtk_notebook_append_page (_tmp10_, (GtkWidget*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = (GtkLabel*) gtk_label_new (_ ("Location"));
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (label);
	label = _tmp13_;
	_tmp14_ = backup_device_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->backup_dev_box);
	self->priv->backup_dev_box = _tmp14_;
	_tmp15_ = self->priv->backup_dev_box;
	g_object_set ((GtkWidget*) _tmp15_, "margin", 12, NULL);
	_tmp16_ = self->priv->notebook;
	_tmp17_ = self->priv->backup_dev_box;
	_tmp18_ = label;
	gtk_notebook_append_page (_tmp16_, (GtkWidget*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkLabel*) gtk_label_new (_ ("Backup"));
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (label);
	label = _tmp19_;
	_tmp20_ = backup_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->backup_box);
	self->priv->backup_box = _tmp20_;
	_tmp21_ = self->priv->backup_box;
	g_object_set ((GtkWidget*) _tmp21_, "margin", 12, NULL);
	_tmp22_ = self->priv->notebook;
	_tmp23_ = self->priv->backup_box;
	_tmp24_ = label;
	gtk_notebook_append_page (_tmp22_, (GtkWidget*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = (GtkLabel*) gtk_label_new (_ ("Finish"));
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (label);
	label = _tmp25_;
	_tmp26_ = backup_finish_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->backup_finish_box);
	self->priv->backup_finish_box = _tmp26_;
	_tmp27_ = self->priv->backup_finish_box;
	g_object_set ((GtkWidget*) _tmp27_, "margin", 12, NULL);
	_tmp28_ = self->priv->notebook;
	_tmp29_ = self->priv->backup_finish_box;
	_tmp30_ = label;
	gtk_notebook_append_page (_tmp28_, (GtkWidget*) _tmp29_, (GtkWidget*) _tmp30_);
	backup_window_create_actions (self);
	gtk_widget_show_all ((GtkWidget*) self);
	self->priv->tmr_init = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _backup_window_init_delayed_gsource_func, g_object_ref (self), g_object_unref);
	tee_jee_logging_log_debug ("BackupWindow: BackupWindow(): exit");
	_g_object_unref0 (label);
	return self;
}

BackupWindow*
backup_window_new (void)
{
	return backup_window_construct (TYPE_BACKUP_WINDOW);
}

static gboolean
backup_window_init_delayed (BackupWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->tmr_init > ((guint) 0)) {
		g_source_remove (self->priv->tmr_init);
		self->priv->tmr_init = (guint) 0;
	}
	backup_window_go_first (self);
	result = FALSE;
	return result;
}

static gboolean
backup_window_on_delete_event (BackupWindow* self,
                               GdkEventAny* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	backup_window_save_changes (self);
	result = FALSE;
	return result;
}

static void
backup_window_save_changes (BackupWindow* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	main_cron_job_update (_tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda95_ (BackupWindow* self)
{
	backup_window_go_prev (self);
}

static void
___lambda95__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda95_ ((BackupWindow*) self);
}

static void
__lambda96_ (BackupWindow* self)
{
	backup_window_go_next (self);
}

static void
___lambda96__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda96_ ((BackupWindow*) self);
}

static void
__lambda97_ (BackupWindow* self)
{
	backup_window_save_changes (self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda97__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda97_ ((BackupWindow*) self);
}

static void
__lambda98_ (BackupWindow* self)
{
	Main* _tmp0_;
	RsyncTask* _tmp1_;
	_tmp0_ = App;
	_tmp1_ = _tmp0_->task;
	if (_tmp1_ != NULL) {
		Main* _tmp2_;
		RsyncTask* _tmp3_;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->task;
		async_task_stop ((AsyncTask*) _tmp3_, APP_STATUS_CANCELLED);
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda98__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda98_ ((BackupWindow*) self);
}

static void
__lambda99_ (BackupWindow* self)
{
	Main* _tmp0_;
	RsyncTask* _tmp1_;
	_tmp0_ = App;
	_tmp1_ = _tmp0_->task;
	if (_tmp1_ != NULL) {
		Main* _tmp2_;
		RsyncTask* _tmp3_;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->task;
		if (APP_STATUS_PAUSED == ((AsyncTask*) _tmp3_)->status) {
			Main* _tmp4_;
			RsyncTask* _tmp5_;
			BackupBox* _tmp6_;
			GtkButton* _tmp7_;
			_tmp4_ = App;
			_tmp5_ = _tmp4_->task;
			async_task_resume ((AsyncTask*) _tmp5_, APP_STATUS_RUNNING);
			_tmp6_ = self->priv->backup_box;
			backup_box_resume (_tmp6_);
			_tmp7_ = self->priv->btn_pause;
			gtk_button_set_label (_tmp7_, _ ("Pause"));
		} else {
			Main* _tmp8_;
			RsyncTask* _tmp9_;
			BackupBox* _tmp10_;
			GtkButton* _tmp11_;
			_tmp8_ = App;
			_tmp9_ = _tmp8_->task;
			async_task_pause ((AsyncTask*) _tmp9_, APP_STATUS_PAUSED);
			_tmp10_ = self->priv->backup_box;
			backup_box_pause (_tmp10_);
			_tmp11_ = self->priv->btn_pause;
			gtk_button_set_label (_tmp11_, _ ("Resume"));
		}
	}
}

static void
___lambda99__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda99_ ((BackupWindow*) self);
}

static void
backup_window_create_actions (BackupWindow* self)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkButtonBox* bbox = NULL;
	GtkButtonBox* _tmp2_;
	GtkButtonBox* _tmp3_;
	GtkSizeGroup* size_group = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) hbox);
	_tmp2_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp2_);
	bbox = _tmp2_;
	g_object_set ((GtkWidget*) bbox, "margin", 12, NULL);
	gtk_box_set_spacing ((GtkBox*) bbox, 6);
	gtk_widget_set_hexpand ((GtkWidget*) bbox, TRUE);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) bbox);
	_tmp3_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->bbox_action);
	self->priv->bbox_action = _tmp3_;
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_CENTER);
	size_group = NULL;
	_tmp4_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Previous"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_prev);
	self->priv->btn_prev = _tmp4_;
	_tmp5_ = self->priv->btn_prev;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) ___lambda95__gtk_button_clicked, self, 0);
	_tmp6_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Next"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_next);
	self->priv->btn_next = _tmp6_;
	_tmp7_ = self->priv->btn_next;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda96__gtk_button_clicked, self, 0);
	_tmp8_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Close"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_close);
	self->priv->btn_close = _tmp8_;
	_tmp9_ = self->priv->btn_close;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) ___lambda97__gtk_button_clicked, self, 0);
	_tmp10_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Cancel"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_cancel);
	self->priv->btn_cancel = _tmp10_;
	_tmp11_ = self->priv->btn_cancel;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) ___lambda98__gtk_button_clicked, self, 0);
	_tmp12_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Pause"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_pause);
	self->priv->btn_pause = _tmp12_;
	_tmp13_ = self->priv->btn_pause;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda99__gtk_button_clicked, self, 0);
	backup_window_action_buttons_set_no_show_all (self, TRUE);
	_g_object_unref0 (size_group);
	_g_object_unref0 (bbox);
	_g_object_unref0 (hbox);
}

static void
backup_window_action_buttons_set_no_show_all (BackupWindow* self,
                                              gboolean val)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->btn_prev;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, val);
	_tmp1_ = self->priv->btn_next;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, val);
	_tmp2_ = self->priv->btn_close;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, val);
	_tmp3_ = self->priv->btn_cancel;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, val);
	_tmp4_ = self->priv->btn_pause;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp4_, val);
}

static void
backup_window_go_first (BackupWindow* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (_tmp0_->btrfs_mode) {
		GtkNotebook* _tmp1_;
		_tmp1_ = self->priv->notebook;
		g_object_set (_tmp1_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP, NULL);
	} else {
		if (main_first_snapshot_size == ((guint64) 0)) {
			GtkNotebook* _tmp2_;
			_tmp2_ = self->priv->notebook;
			g_object_set (_tmp2_, "page", (gint) BACKUP_WINDOW_TABS_ESTIMATE, NULL);
		} else {
			gboolean _tmp3_ = FALSE;
			Main* _tmp4_;
			SnapshotRepo* _tmp5_;
			_tmp4_ = App;
			_tmp5_ = _tmp4_->repo;
			if (!snapshot_repo_available (_tmp5_)) {
				_tmp3_ = TRUE;
			} else {
				Main* _tmp6_;
				SnapshotRepo* _tmp7_;
				_tmp6_ = App;
				_tmp7_ = _tmp6_->repo;
				_tmp3_ = !snapshot_repo_has_space (_tmp7_, (guint64) 0);
			}
			if (_tmp3_) {
				GtkNotebook* _tmp8_;
				_tmp8_ = self->priv->notebook;
				g_object_set (_tmp8_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP_DEVICE, NULL);
			} else {
				GtkNotebook* _tmp9_;
				_tmp9_ = self->priv->notebook;
				g_object_set (_tmp9_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP, NULL);
			}
		}
	}
	backup_window_initialize_tab (self);
}

static void
backup_window_go_prev (BackupWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case BACKUP_WINDOW_TABS_ESTIMATE:
		case BACKUP_WINDOW_TABS_BACKUP_DEVICE:
		case BACKUP_WINDOW_TABS_BACKUP:
		{
			break;
		}
		default:
		break;
	}
	backup_window_initialize_tab (self);
}

static void
backup_window_go_next (BackupWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	if (!backup_window_validate_current_tab (self)) {
		return;
	}
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case BACKUP_WINDOW_TABS_ESTIMATE:
		{
			GtkNotebook* _tmp3_;
			_tmp3_ = self->priv->notebook;
			g_object_set (_tmp3_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP_DEVICE, NULL);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_DEVICE:
		{
			GtkNotebook* _tmp4_;
			_tmp4_ = self->priv->notebook;
			g_object_set (_tmp4_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP, NULL);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP:
		{
			GtkNotebook* _tmp5_;
			_tmp5_ = self->priv->notebook;
			g_object_set (_tmp5_, "page", (gint) BACKUP_WINDOW_TABS_BACKUP_FINISH, NULL);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_FINISH:
		{
			gtk_widget_destroy ((GtkWidget*) self);
			break;
		}
		default:
		break;
	}
	backup_window_initialize_tab (self);
}

static void
backup_window_initialize_tab (BackupWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkNotebook* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkNotebook* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 0) {
		return;
	}
	tee_jee_logging_log_msg ("", FALSE);
	_tmp3_ = self->priv->notebook;
	g_object_get (_tmp3_, "page", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("page: %d", _tmp5_);
	_tmp7_ = _tmp6_;
	tee_jee_logging_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	backup_window_action_buttons_set_no_show_all (self, FALSE);
	_tmp8_ = self->priv->notebook;
	g_object_get (_tmp8_, "page", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	switch (_tmp10_) {
		case BACKUP_WINDOW_TABS_ESTIMATE:
		{
			GtkButton* _tmp11_;
			GtkButton* _tmp12_;
			GtkButton* _tmp13_;
			GtkButton* _tmp14_;
			GtkButton* _tmp15_;
			_tmp11_ = self->priv->btn_prev;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
			_tmp12_ = self->priv->btn_next;
			gtk_widget_hide ((GtkWidget*) _tmp12_);
			_tmp13_ = self->priv->btn_close;
			gtk_widget_hide ((GtkWidget*) _tmp13_);
			_tmp14_ = self->priv->btn_cancel;
			gtk_widget_show ((GtkWidget*) _tmp14_);
			_tmp15_ = self->priv->btn_pause;
			gtk_widget_hide ((GtkWidget*) _tmp15_);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP:
		{
			GtkButton* _tmp16_;
			GtkButton* _tmp17_;
			GtkButton* _tmp18_;
			GtkButton* _tmp19_;
			GtkButton* _tmp20_;
			_tmp16_ = self->priv->btn_prev;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
			_tmp17_ = self->priv->btn_next;
			gtk_widget_hide ((GtkWidget*) _tmp17_);
			_tmp18_ = self->priv->btn_close;
			gtk_widget_hide ((GtkWidget*) _tmp18_);
			_tmp19_ = self->priv->btn_cancel;
			gtk_widget_show ((GtkWidget*) _tmp19_);
			_tmp20_ = self->priv->btn_pause;
			gtk_widget_show ((GtkWidget*) _tmp20_);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_DEVICE:
		{
			GtkButton* _tmp21_;
			GtkButton* _tmp22_;
			GtkButton* _tmp23_;
			GtkButton* _tmp24_;
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			GtkButton* _tmp27_;
			GtkButton* _tmp28_;
			_tmp21_ = self->priv->btn_prev;
			gtk_widget_show ((GtkWidget*) _tmp21_);
			_tmp22_ = self->priv->btn_next;
			gtk_widget_show ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->btn_close;
			gtk_widget_show ((GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->btn_cancel;
			gtk_widget_hide ((GtkWidget*) _tmp24_);
			_tmp25_ = self->priv->btn_pause;
			gtk_widget_hide ((GtkWidget*) _tmp25_);
			_tmp26_ = self->priv->btn_prev;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, FALSE);
			_tmp27_ = self->priv->btn_next;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp27_, TRUE);
			_tmp28_ = self->priv->btn_close;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp28_, TRUE);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_FINISH:
		{
			GtkButton* _tmp29_;
			GtkButton* _tmp30_;
			GtkButton* _tmp31_;
			GtkButton* _tmp32_;
			GtkButton* _tmp33_;
			GtkButton* _tmp34_;
			_tmp29_ = self->priv->btn_prev;
			gtk_widget_hide ((GtkWidget*) _tmp29_);
			_tmp30_ = self->priv->btn_next;
			gtk_widget_hide ((GtkWidget*) _tmp30_);
			_tmp31_ = self->priv->btn_close;
			gtk_widget_show ((GtkWidget*) _tmp31_);
			_tmp32_ = self->priv->btn_close;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, TRUE);
			_tmp33_ = self->priv->btn_cancel;
			gtk_widget_hide ((GtkWidget*) _tmp33_);
			_tmp34_ = self->priv->btn_pause;
			gtk_widget_hide ((GtkWidget*) _tmp34_);
			break;
		}
		default:
		break;
	}
	_tmp35_ = self->priv->notebook;
	g_object_get (_tmp35_, "page", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	switch (_tmp37_) {
		case BACKUP_WINDOW_TABS_ESTIMATE:
		{
			EstimateBox* _tmp38_;
			_tmp38_ = self->priv->estimate_box;
			estimate_box_estimate_system_size (_tmp38_);
			backup_window_go_next (self);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_DEVICE:
		{
			BackupDeviceBox* _tmp39_;
			_tmp39_ = self->priv->backup_dev_box;
			backup_device_box_refresh (_tmp39_);
			backup_window_go_next (self);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP:
		{
			BackupBox* _tmp40_;
			_tmp40_ = self->priv->backup_box;
			self->priv->success = backup_box_take_snapshot (_tmp40_);
			backup_window_go_next (self);
			break;
		}
		case BACKUP_WINDOW_TABS_BACKUP_FINISH:
		{
			BackupFinishBox* _tmp41_;
			Main* _tmp42_;
			SnapshotRepo* _tmp43_;
			_tmp41_ = self->priv->backup_finish_box;
			backup_finish_box_update_message (_tmp41_, self->priv->success);
			_tmp42_ = App;
			_tmp43_ = _tmp42_->repo;
			if (_tmp43_->status_code == SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE) {
				Main* _tmp44_;
				SnapshotRepo* _tmp45_;
				const gchar* _tmp46_;
				Main* _tmp47_;
				SnapshotRepo* _tmp48_;
				const gchar* _tmp49_;
				gtk_widget_hide ((GtkWidget*) self);
				_tmp44_ = App;
				_tmp45_ = _tmp44_->repo;
				_tmp46_ = _tmp45_->status_message;
				_tmp47_ = App;
				_tmp48_ = _tmp47_->repo;
				_tmp49_ = _tmp48_->status_details;
				tee_jee_gtk_helper_gtk_messagebox (_tmp46_, _tmp49_, (GtkWindow*) self, TRUE);
				gtk_widget_destroy ((GtkWidget*) self);
			} else {
				BackupFinishBox* _tmp50_;
				_tmp50_ = self->priv->backup_finish_box;
				backup_finish_box_update_message (_tmp50_, self->priv->success);
				tee_jee_gtk_helper_wait_and_close_window (1000, (GtkWindow*) self);
			}
			break;
		}
		default:
		break;
	}
}

static gboolean
backup_window_validate_current_tab (BackupWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((gint) BACKUP_WINDOW_TABS_BACKUP_DEVICE)) {
		gboolean _tmp3_ = FALSE;
		Main* _tmp4_;
		SnapshotRepo* _tmp5_;
		_tmp4_ = App;
		_tmp5_ = _tmp4_->repo;
		if (!snapshot_repo_available (_tmp5_)) {
			_tmp3_ = TRUE;
		} else {
			Main* _tmp6_;
			SnapshotRepo* _tmp7_;
			_tmp6_ = App;
			_tmp7_ = _tmp6_->repo;
			_tmp3_ = !snapshot_repo_has_space (_tmp7_, (guint64) 0);
		}
		if (_tmp3_) {
			Main* _tmp8_;
			SnapshotRepo* _tmp9_;
			const gchar* _tmp10_;
			Main* _tmp11_;
			SnapshotRepo* _tmp12_;
			const gchar* _tmp13_;
			_tmp8_ = App;
			_tmp9_ = _tmp8_->repo;
			_tmp10_ = _tmp9_->status_message;
			_tmp11_ = App;
			_tmp12_ = _tmp11_->repo;
			_tmp13_ = _tmp12_->status_details;
			tee_jee_gtk_helper_gtk_messagebox (_tmp10_, _tmp13_, (GtkWindow*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static void
backup_window_class_init (BackupWindowClass * klass,
                          gpointer klass_data)
{
	backup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BackupWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = backup_window_finalize;
}

static void
backup_window_instance_init (BackupWindow * self,
                             gpointer klass)
{
	self->priv = backup_window_get_instance_private (self);
	self->priv->def_width = 500;
	self->priv->def_height = 500;
	self->priv->success = FALSE;
}

static void
backup_window_finalize (GObject * obj)
{
	BackupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKUP_WINDOW, BackupWindow);
	_g_object_unref0 (self->priv->vbox_main);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->bbox_action);
	_g_object_unref0 (self->priv->estimate_box);
	_g_object_unref0 (self->priv->backup_dev_box);
	_g_object_unref0 (self->priv->backup_box);
	_g_object_unref0 (self->priv->backup_finish_box);
	_g_object_unref0 (self->priv->btn_prev);
	_g_object_unref0 (self->priv->btn_next);
	_g_object_unref0 (self->priv->btn_cancel);
	_g_object_unref0 (self->priv->btn_pause);
	_g_object_unref0 (self->priv->btn_close);
	G_OBJECT_CLASS (backup_window_parent_class)->finalize (obj);
}

static GType
backup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackupWindow), 0, (GInstanceInitFunc) backup_window_instance_init, NULL };
	GType backup_window_type_id;
	backup_window_type_id = g_type_register_static (gtk_window_get_type (), "BackupWindow", &g_define_type_info, 0);
	BackupWindow_private_offset = g_type_add_instance_private (backup_window_type_id, sizeof (BackupWindowPrivate));
	return backup_window_type_id;
}

GType
backup_window_get_type (void)
{
	static volatile gsize backup_window_type_id__once = 0;
	if (g_once_init_enter (&backup_window_type_id__once)) {
		GType backup_window_type_id;
		backup_window_type_id = backup_window_get_type_once ();
		g_once_init_leave (&backup_window_type_id__once, backup_window_type_id);
	}
	return backup_window_type_id__once;
}

