/* Interfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_SESSION_STRUCT (pc_daemon_session_struct_get_type ())
typedef struct _PCDaemonSessionStruct PCDaemonSessionStruct;
#define _g_free0(var) (var = (g_free (var), NULL))

#define PC_DAEMON_TYPE_SEAT_STRUCT (pc_daemon_seat_struct_get_type ())
typedef struct _PCDaemonSeatStruct PCDaemonSeatStruct;

#define PC_DAEMON_TYPE_IMANAGER (pc_daemon_imanager_get_type ())
#define PC_DAEMON_IMANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_IMANAGER, PCDaemonIManager))
#define PC_DAEMON_IS_IMANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_IMANAGER))
#define PC_DAEMON_IMANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_DAEMON_TYPE_IMANAGER, PCDaemonIManagerIface))

typedef struct _PCDaemonIManager PCDaemonIManager;
typedef struct _PCDaemonIManagerIface PCDaemonIManagerIface;

#define PC_DAEMON_TYPE_IMANAGER_PROXY (pc_daemon_imanager_proxy_get_type ())
enum  {
	PC_DAEMON_IMANAGER_SESSION_NEW_SIGNAL,
	PC_DAEMON_IMANAGER_SESSION_REMOVED_SIGNAL,
	PC_DAEMON_IMANAGER_NUM_SIGNALS
};
static guint pc_daemon_imanager_signals[PC_DAEMON_IMANAGER_NUM_SIGNALS] = {0};
typedef GDBusProxy PCDaemonIManagerProxy;
typedef GDBusProxyClass PCDaemonIManagerProxyClass;

#define PC_DAEMON_TYPE_ISESSION (pc_daemon_isession_get_type ())
#define PC_DAEMON_ISESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_ISESSION, PCDaemonISession))
#define PC_DAEMON_IS_ISESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_ISESSION))
#define PC_DAEMON_ISESSION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_DAEMON_TYPE_ISESSION, PCDaemonISessionIface))

typedef struct _PCDaemonISession PCDaemonISession;
typedef struct _PCDaemonISessionIface PCDaemonISessionIface;

#define PC_DAEMON_TYPE_ISESSION_PROXY (pc_daemon_isession_proxy_get_type ())
typedef GDBusProxy PCDaemonISessionProxy;
typedef GDBusProxyClass PCDaemonISessionProxyClass;

struct _PCDaemonSessionStruct {
	gchar* name;
	guint32 uid;
	gchar* user;
	gchar* seat;
	char* object_path;
};

struct _PCDaemonSeatStruct {
	gchar* seat_id;
	char* object_path;
};

struct _PCDaemonIManagerIface {
	GTypeInterface parent_iface;
	PCDaemonSessionStruct* (*list_sessions) (PCDaemonIManager* self, gint* result_length1, GError** error);
	PCDaemonSeatStruct* (*list_seats) (PCDaemonIManager* self, gint* result_length1, GError** error);
	char* (*get_seat) (PCDaemonIManager* self, const gchar* seat, GError** error);
};

struct _PCDaemonISessionIface {
	GTypeInterface parent_iface;
	void (*terminate) (PCDaemonISession* self, GError** error);
	gboolean (*get_active) (PCDaemonISession* self);
	gchar* (*get_name) (PCDaemonISession* self);
	gchar* (*get_id) (PCDaemonISession* self);
};

VALA_EXTERN GType pc_daemon_session_struct_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PCDaemonSessionStruct* pc_daemon_session_struct_dup (const PCDaemonSessionStruct* self);
VALA_EXTERN void pc_daemon_session_struct_free (PCDaemonSessionStruct* self);
VALA_EXTERN void pc_daemon_session_struct_copy (const PCDaemonSessionStruct* self,
                                    PCDaemonSessionStruct* dest);
VALA_EXTERN void pc_daemon_session_struct_destroy (PCDaemonSessionStruct* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PCDaemonSessionStruct, pc_daemon_session_struct_destroy)
VALA_EXTERN GType pc_daemon_seat_struct_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PCDaemonSeatStruct* pc_daemon_seat_struct_dup (const PCDaemonSeatStruct* self);
VALA_EXTERN void pc_daemon_seat_struct_free (PCDaemonSeatStruct* self);
VALA_EXTERN void pc_daemon_seat_struct_copy (const PCDaemonSeatStruct* self,
                                 PCDaemonSeatStruct* dest);
VALA_EXTERN void pc_daemon_seat_struct_destroy (PCDaemonSeatStruct* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PCDaemonSeatStruct, pc_daemon_seat_struct_destroy)
VALA_EXTERN GType pc_daemon_imanager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_daemon_imanager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType pc_daemon_imanager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonIManager, g_object_unref)
VALA_EXTERN PCDaemonSessionStruct* pc_daemon_imanager_list_sessions (PCDaemonIManager* self,
                                                         gint* result_length1,
                                                         GError** error);
VALA_EXTERN PCDaemonSeatStruct* pc_daemon_imanager_list_seats (PCDaemonIManager* self,
                                                   gint* result_length1,
                                                   GError** error);
VALA_EXTERN char* pc_daemon_imanager_get_seat (PCDaemonIManager* self,
                                   const gchar* seat,
                                   GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GType pc_daemon_imanager_get_type_once (void);
static void pc_daemon_imanager_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void _dbus_handle_pc_daemon_imanager_session_new (PCDaemonIManager* self,
                                                  GVariant* parameters);
static void _dbus_handle_pc_daemon_imanager_session_removed (PCDaemonIManager* self,
                                                      GVariant* parameters);
static PCDaemonSessionStruct* pc_daemon_imanager_proxy_list_sessions (PCDaemonIManager* self,
                                                               gint* result_length1,
                                                               GError** error);
static PCDaemonSeatStruct* pc_daemon_imanager_proxy_list_seats (PCDaemonIManager* self,
                                                         gint* result_length1,
                                                         GError** error);
static char* pc_daemon_imanager_proxy_get_seat (PCDaemonIManager* self,
                                         const gchar* seat,
                                         GError** error);
static void pc_daemon_imanager_proxy_pc_daemon_imanager_interface_init (PCDaemonIManagerIface* iface);
static void _vala_PCDaemonSessionStruct_array_free (PCDaemonSessionStruct * array,
                                             gssize array_length);
static void _dbus_pc_daemon_imanager_list_sessions (PCDaemonIManager* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _vala_PCDaemonSeatStruct_array_free (PCDaemonSeatStruct * array,
                                          gssize array_length);
static void _dbus_pc_daemon_imanager_list_seats (PCDaemonIManager* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_imanager_get_seat (PCDaemonIManager* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void pc_daemon_imanager_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* pc_daemon_imanager_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean pc_daemon_imanager_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _dbus_pc_daemon_imanager_session_new (GObject* _sender,
                                           const gchar* session,
                                           const char* object_path,
                                           gpointer* _data);
static void _dbus_pc_daemon_imanager_session_removed (GObject* _sender,
                                               const gchar* session,
                                               const char* object_path,
                                               gpointer* _data);
static void _pc_daemon_imanager_unregister_object (gpointer user_data);
VALA_EXTERN GType pc_daemon_isession_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_daemon_isession_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType pc_daemon_isession_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonISession, g_object_unref)
VALA_EXTERN void pc_daemon_isession_terminate (PCDaemonISession* self,
                                   GError** error);
VALA_EXTERN gboolean pc_daemon_isession_get_active (PCDaemonISession* self);
VALA_EXTERN gchar* pc_daemon_isession_get_name (PCDaemonISession* self);
VALA_EXTERN gchar* pc_daemon_isession_get_id (PCDaemonISession* self);
static GType pc_daemon_isession_get_type_once (void);
static void pc_daemon_isession_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void pc_daemon_isession_proxy_terminate (PCDaemonISession* self,
                                         GError** error);
static gboolean pc_daemon_isession_dbus_proxy_get_active (PCDaemonISession* self);
static gchar* pc_daemon_isession_dbus_proxy_get_name (PCDaemonISession* self);
static gchar* pc_daemon_isession_dbus_proxy_get_id (PCDaemonISession* self);
static void pc_daemon_isession_proxy_pc_daemon_isession_interface_init (PCDaemonISessionIface* iface);
static void _dbus_pc_daemon_isession_terminate (PCDaemonISession* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void pc_daemon_isession_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* pc_daemon_isession_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_pc_daemon_isession_get_active (PCDaemonISession* self);
static GVariant* _dbus_pc_daemon_isession_get_name (PCDaemonISession* self);
static GVariant* _dbus_pc_daemon_isession_get_id (PCDaemonISession* self);
static gboolean pc_daemon_isession_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _pc_daemon_isession_unregister_object (gpointer user_data);

static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_list_sessions_result = {-1, "result", "a(susso)", NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_list_sessions_in[] = {NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_list_sessions_out[] = {&_pc_daemon_imanager_dbus_arg_info_list_sessions_result, NULL};
static const GDBusMethodInfo _pc_daemon_imanager_dbus_method_info_list_sessions = {-1, "ListSessions", (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_list_sessions_in), (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_list_sessions_out), NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_list_seats_result = {-1, "result", "a(so)", NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_list_seats_in[] = {NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_list_seats_out[] = {&_pc_daemon_imanager_dbus_arg_info_list_seats_result, NULL};
static const GDBusMethodInfo _pc_daemon_imanager_dbus_method_info_list_seats = {-1, "ListSeats", (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_list_seats_in), (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_list_seats_out), NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_get_seat_seat = {-1, "seat", "s", NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_get_seat_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_get_seat_in[] = {&_pc_daemon_imanager_dbus_arg_info_get_seat_seat, NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_get_seat_out[] = {&_pc_daemon_imanager_dbus_arg_info_get_seat_result, NULL};
static const GDBusMethodInfo _pc_daemon_imanager_dbus_method_info_get_seat = {-1, "GetSeat", (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_get_seat_in), (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_get_seat_out), NULL};
static const GDBusMethodInfo * const _pc_daemon_imanager_dbus_method_info[] = {&_pc_daemon_imanager_dbus_method_info_list_sessions, &_pc_daemon_imanager_dbus_method_info_list_seats, &_pc_daemon_imanager_dbus_method_info_get_seat, NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_session_new_session = {-1, "session", "s", NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_session_new_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_session_new[] = {&_pc_daemon_imanager_dbus_arg_info_session_new_session, &_pc_daemon_imanager_dbus_arg_info_session_new_object_path, NULL};
static const GDBusSignalInfo _pc_daemon_imanager_dbus_signal_info_session_new = {-1, "SessionNew", (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_session_new), NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_session_removed_session = {-1, "session", "s", NULL};
static const GDBusArgInfo _pc_daemon_imanager_dbus_arg_info_session_removed_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo * const _pc_daemon_imanager_dbus_arg_info_session_removed[] = {&_pc_daemon_imanager_dbus_arg_info_session_removed_session, &_pc_daemon_imanager_dbus_arg_info_session_removed_object_path, NULL};
static const GDBusSignalInfo _pc_daemon_imanager_dbus_signal_info_session_removed = {-1, "SessionRemoved", (GDBusArgInfo **) (&_pc_daemon_imanager_dbus_arg_info_session_removed), NULL};
static const GDBusSignalInfo * const _pc_daemon_imanager_dbus_signal_info[] = {&_pc_daemon_imanager_dbus_signal_info_session_new, &_pc_daemon_imanager_dbus_signal_info_session_removed, NULL};
static const GDBusPropertyInfo * const _pc_daemon_imanager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pc_daemon_imanager_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_pc_daemon_imanager_dbus_method_info), (GDBusSignalInfo **) (&_pc_daemon_imanager_dbus_signal_info), (GDBusPropertyInfo **) (&_pc_daemon_imanager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pc_daemon_imanager_dbus_interface_vtable = {pc_daemon_imanager_dbus_interface_method_call, pc_daemon_imanager_dbus_interface_get_property, pc_daemon_imanager_dbus_interface_set_property};
static const GDBusArgInfo * const _pc_daemon_isession_dbus_arg_info_terminate_in[] = {NULL};
static const GDBusArgInfo * const _pc_daemon_isession_dbus_arg_info_terminate_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_isession_dbus_method_info_terminate = {-1, "Terminate", (GDBusArgInfo **) (&_pc_daemon_isession_dbus_arg_info_terminate_in), (GDBusArgInfo **) (&_pc_daemon_isession_dbus_arg_info_terminate_out), NULL};
static const GDBusMethodInfo * const _pc_daemon_isession_dbus_method_info[] = {&_pc_daemon_isession_dbus_method_info_terminate, NULL};
static const GDBusSignalInfo * const _pc_daemon_isession_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _pc_daemon_isession_dbus_property_info_active = {-1, "Active", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pc_daemon_isession_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pc_daemon_isession_dbus_property_info_id = {-1, "Id", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _pc_daemon_isession_dbus_property_info[] = {&_pc_daemon_isession_dbus_property_info_active, &_pc_daemon_isession_dbus_property_info_name, &_pc_daemon_isession_dbus_property_info_id, NULL};
static const GDBusInterfaceInfo _pc_daemon_isession_dbus_interface_info = {-1, "org.freedesktop.login1.Session", (GDBusMethodInfo **) (&_pc_daemon_isession_dbus_method_info), (GDBusSignalInfo **) (&_pc_daemon_isession_dbus_signal_info), (GDBusPropertyInfo **) (&_pc_daemon_isession_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pc_daemon_isession_dbus_interface_vtable = {pc_daemon_isession_dbus_interface_method_call, pc_daemon_isession_dbus_interface_get_property, pc_daemon_isession_dbus_interface_set_property};

void
pc_daemon_session_struct_copy (const PCDaemonSessionStruct* self,
                               PCDaemonSessionStruct* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const char* _tmp6_;
	char* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).uid = (*self).uid;
	_tmp2_ = (*self).user;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).user);
	(*dest).user = _tmp3_;
	_tmp4_ = (*self).seat;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).seat);
	(*dest).seat = _tmp5_;
	_tmp6_ = (*self).object_path;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).object_path);
	(*dest).object_path = _tmp7_;
}

void
pc_daemon_session_struct_destroy (PCDaemonSessionStruct* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).user);
	_g_free0 ((*self).seat);
	_g_free0 ((*self).object_path);
}

PCDaemonSessionStruct*
pc_daemon_session_struct_dup (const PCDaemonSessionStruct* self)
{
	PCDaemonSessionStruct* dup;
	dup = g_new0 (PCDaemonSessionStruct, 1);
	pc_daemon_session_struct_copy (self, dup);
	return dup;
}

void
pc_daemon_session_struct_free (PCDaemonSessionStruct* self)
{
	pc_daemon_session_struct_destroy (self);
	g_free (self);
}

static GType
pc_daemon_session_struct_get_type_once (void)
{
	GType pc_daemon_session_struct_type_id;
	pc_daemon_session_struct_type_id = g_boxed_type_register_static ("PCDaemonSessionStruct", (GBoxedCopyFunc) pc_daemon_session_struct_dup, (GBoxedFreeFunc) pc_daemon_session_struct_free);
	return pc_daemon_session_struct_type_id;
}

GType
pc_daemon_session_struct_get_type (void)
{
	static volatile gsize pc_daemon_session_struct_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_session_struct_type_id__once)) {
		GType pc_daemon_session_struct_type_id;
		pc_daemon_session_struct_type_id = pc_daemon_session_struct_get_type_once ();
		g_once_init_leave (&pc_daemon_session_struct_type_id__once, pc_daemon_session_struct_type_id);
	}
	return pc_daemon_session_struct_type_id__once;
}

void
pc_daemon_seat_struct_copy (const PCDaemonSeatStruct* self,
                            PCDaemonSeatStruct* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
	_tmp0_ = (*self).seat_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).seat_id);
	(*dest).seat_id = _tmp1_;
	_tmp2_ = (*self).object_path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).object_path);
	(*dest).object_path = _tmp3_;
}

void
pc_daemon_seat_struct_destroy (PCDaemonSeatStruct* self)
{
	_g_free0 ((*self).seat_id);
	_g_free0 ((*self).object_path);
}

PCDaemonSeatStruct*
pc_daemon_seat_struct_dup (const PCDaemonSeatStruct* self)
{
	PCDaemonSeatStruct* dup;
	dup = g_new0 (PCDaemonSeatStruct, 1);
	pc_daemon_seat_struct_copy (self, dup);
	return dup;
}

void
pc_daemon_seat_struct_free (PCDaemonSeatStruct* self)
{
	pc_daemon_seat_struct_destroy (self);
	g_free (self);
}

static GType
pc_daemon_seat_struct_get_type_once (void)
{
	GType pc_daemon_seat_struct_type_id;
	pc_daemon_seat_struct_type_id = g_boxed_type_register_static ("PCDaemonSeatStruct", (GBoxedCopyFunc) pc_daemon_seat_struct_dup, (GBoxedFreeFunc) pc_daemon_seat_struct_free);
	return pc_daemon_seat_struct_type_id;
}

GType
pc_daemon_seat_struct_get_type (void)
{
	static volatile gsize pc_daemon_seat_struct_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_seat_struct_type_id__once)) {
		GType pc_daemon_seat_struct_type_id;
		pc_daemon_seat_struct_type_id = pc_daemon_seat_struct_get_type_once ();
		g_once_init_leave (&pc_daemon_seat_struct_type_id__once, pc_daemon_seat_struct_type_id);
	}
	return pc_daemon_seat_struct_type_id__once;
}

PCDaemonSessionStruct*
pc_daemon_imanager_list_sessions (PCDaemonIManager* self,
                                  gint* result_length1,
                                  GError** error)
{
	PCDaemonIManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PC_DAEMON_IMANAGER_GET_INTERFACE (self);
	if (_iface_->list_sessions) {
		return _iface_->list_sessions (self, result_length1, error);
	}
	return NULL;
}

PCDaemonSeatStruct*
pc_daemon_imanager_list_seats (PCDaemonIManager* self,
                               gint* result_length1,
                               GError** error)
{
	PCDaemonIManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PC_DAEMON_IMANAGER_GET_INTERFACE (self);
	if (_iface_->list_seats) {
		return _iface_->list_seats (self, result_length1, error);
	}
	return NULL;
}

char*
pc_daemon_imanager_get_seat (PCDaemonIManager* self,
                             const gchar* seat,
                             GError** error)
{
	PCDaemonIManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PC_DAEMON_IMANAGER_GET_INTERFACE (self);
	if (_iface_->get_seat) {
		return _iface_->get_seat (self, seat, error);
	}
	return NULL;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
pc_daemon_imanager_default_init (PCDaemonIManagerIface * iface,
                                 gpointer iface_data)
{
	pc_daemon_imanager_signals[PC_DAEMON_IMANAGER_SESSION_NEW_SIGNAL] = g_signal_new ("session-new", PC_DAEMON_TYPE_IMANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pc_daemon_imanager_signals[PC_DAEMON_IMANAGER_SESSION_REMOVED_SIGNAL] = g_signal_new ("session-removed", PC_DAEMON_TYPE_IMANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}

static GType
pc_daemon_imanager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonIManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_imanager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pc_daemon_imanager_type_id;
	pc_daemon_imanager_type_id = g_type_register_static (G_TYPE_INTERFACE, "PCDaemonIManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pc_daemon_imanager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pc_daemon_imanager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pc_daemon_imanager_proxy_get_type);
	g_type_set_qdata (pc_daemon_imanager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (pc_daemon_imanager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pc_daemon_imanager_dbus_interface_info));
	g_type_set_qdata (pc_daemon_imanager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pc_daemon_imanager_register_object);
	return pc_daemon_imanager_type_id;
}

GType
pc_daemon_imanager_get_type (void)
{
	static volatile gsize pc_daemon_imanager_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_imanager_type_id__once)) {
		GType pc_daemon_imanager_type_id;
		pc_daemon_imanager_type_id = pc_daemon_imanager_get_type_once ();
		g_once_init_leave (&pc_daemon_imanager_type_id__once, pc_daemon_imanager_type_id);
	}
	return pc_daemon_imanager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PCDaemonIManagerProxy, pc_daemon_imanager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PC_DAEMON_TYPE_IMANAGER, pc_daemon_imanager_proxy_pc_daemon_imanager_interface_init) )
static void
pc_daemon_imanager_proxy_class_init (PCDaemonIManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pc_daemon_imanager_proxy_g_signal;
}

static void
_dbus_handle_pc_daemon_imanager_session_new (PCDaemonIManager* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* session = NULL;
	GVariant* _tmp45_;
	char* object_path = NULL;
	GVariant* _tmp46_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	session = g_variant_dup_string (_tmp45_, NULL);
	g_variant_unref (_tmp45_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp46_, NULL);
	g_variant_unref (_tmp46_);
	g_signal_emit_by_name (self, "session-new", session, object_path);
	_g_free0 (session);
	_g_free0 (object_path);
}

static void
_dbus_handle_pc_daemon_imanager_session_removed (PCDaemonIManager* self,
                                                 GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* session = NULL;
	GVariant* _tmp47_;
	char* object_path = NULL;
	GVariant* _tmp48_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	session = g_variant_dup_string (_tmp47_, NULL);
	g_variant_unref (_tmp47_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	g_signal_emit_by_name (self, "session-removed", session, object_path);
	_g_free0 (session);
	_g_free0 (object_path);
}

static void
pc_daemon_imanager_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
	if (strcmp (signal_name, "SessionNew") == 0) {
		_dbus_handle_pc_daemon_imanager_session_new ((PCDaemonIManager*) proxy, parameters);
	} else if (strcmp (signal_name, "SessionRemoved") == 0) {
		_dbus_handle_pc_daemon_imanager_session_removed ((PCDaemonIManager*) proxy, parameters);
	}
}

static void
pc_daemon_imanager_proxy_init (PCDaemonIManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pc_daemon_imanager_dbus_interface_info));
}

static PCDaemonSessionStruct*
pc_daemon_imanager_proxy_list_sessions (PCDaemonIManager* self,
                                        gint* result_length1,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	PCDaemonSessionStruct* _result = NULL;
	gint _result_length1;
	GVariant* _tmp49_;
	PCDaemonSessionStruct* _tmp50_;
	gint _tmp50__length;
	gint _tmp50__size;
	gint _tmp50__length1;
	GVariantIter _tmp51_;
	GVariant* _tmp52_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "ListSessions");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp49_ = g_variant_iter_next_value (&_reply_iter);
	_tmp50_ = g_new (PCDaemonSessionStruct, 5);
	_tmp50__length = 0;
	_tmp50__size = 4;
	_tmp50__length1 = 0;
	g_variant_iter_init (&_tmp51_, _tmp49_);
	for (; (_tmp52_ = g_variant_iter_next_value (&_tmp51_)) != NULL; _tmp50__length1++) {
		PCDaemonSessionStruct _tmp53_;
		GVariantIter _tmp54_;
		GVariant* _tmp55_;
		GVariant* _tmp56_;
		GVariant* _tmp57_;
		GVariant* _tmp58_;
		GVariant* _tmp59_;
		if (_tmp50__size == _tmp50__length) {
			_tmp50__size = 2 * _tmp50__size;
			_tmp50_ = g_renew (PCDaemonSessionStruct, _tmp50_, _tmp50__size + 1);
		}
		g_variant_iter_init (&_tmp54_, _tmp52_);
		_tmp55_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.name = g_variant_dup_string (_tmp55_, NULL);
		g_variant_unref (_tmp55_);
		_tmp56_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.uid = g_variant_get_uint32 (_tmp56_);
		g_variant_unref (_tmp56_);
		_tmp57_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.user = g_variant_dup_string (_tmp57_, NULL);
		g_variant_unref (_tmp57_);
		_tmp58_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.seat = g_variant_dup_string (_tmp58_, NULL);
		g_variant_unref (_tmp58_);
		_tmp59_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.object_path = g_variant_dup_string (_tmp59_, NULL);
		g_variant_unref (_tmp59_);
		_tmp50_[_tmp50__length++] = _tmp53_;
		g_variant_unref (_tmp52_);
	}
	_result_length1 = _tmp50__length1;
	_result = _tmp50_;
	g_variant_unref (_tmp49_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static PCDaemonSeatStruct*
pc_daemon_imanager_proxy_list_seats (PCDaemonIManager* self,
                                     gint* result_length1,
                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	PCDaemonSeatStruct* _result = NULL;
	gint _result_length1;
	GVariant* _tmp60_;
	PCDaemonSeatStruct* _tmp61_;
	gint _tmp61__length;
	gint _tmp61__size;
	gint _tmp61__length1;
	GVariantIter _tmp62_;
	GVariant* _tmp63_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "ListSeats");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp60_ = g_variant_iter_next_value (&_reply_iter);
	_tmp61_ = g_new (PCDaemonSeatStruct, 5);
	_tmp61__length = 0;
	_tmp61__size = 4;
	_tmp61__length1 = 0;
	g_variant_iter_init (&_tmp62_, _tmp60_);
	for (; (_tmp63_ = g_variant_iter_next_value (&_tmp62_)) != NULL; _tmp61__length1++) {
		PCDaemonSeatStruct _tmp64_;
		GVariantIter _tmp65_;
		GVariant* _tmp66_;
		GVariant* _tmp67_;
		if (_tmp61__size == _tmp61__length) {
			_tmp61__size = 2 * _tmp61__size;
			_tmp61_ = g_renew (PCDaemonSeatStruct, _tmp61_, _tmp61__size + 1);
		}
		g_variant_iter_init (&_tmp65_, _tmp63_);
		_tmp66_ = g_variant_iter_next_value (&_tmp65_);
		_tmp64_.seat_id = g_variant_dup_string (_tmp66_, NULL);
		g_variant_unref (_tmp66_);
		_tmp67_ = g_variant_iter_next_value (&_tmp65_);
		_tmp64_.object_path = g_variant_dup_string (_tmp67_, NULL);
		g_variant_unref (_tmp67_);
		_tmp61_[_tmp61__length++] = _tmp64_;
		g_variant_unref (_tmp63_);
	}
	_result_length1 = _tmp61__length1;
	_result = _tmp61_;
	g_variant_unref (_tmp60_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static char*
pc_daemon_imanager_proxy_get_seat (PCDaemonIManager* self,
                                   const gchar* seat,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp68_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "GetSeat");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (seat));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp68_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp68_, NULL);
	g_variant_unref (_tmp68_);
	g_object_unref (_reply_message);
	return _result;
}

static void
pc_daemon_imanager_proxy_pc_daemon_imanager_interface_init (PCDaemonIManagerIface* iface)
{
	iface->list_sessions = pc_daemon_imanager_proxy_list_sessions;
	iface->list_seats = pc_daemon_imanager_proxy_list_seats;
	iface->get_seat = pc_daemon_imanager_proxy_get_seat;
}

static void
_vala_PCDaemonSessionStruct_array_free (PCDaemonSessionStruct * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pc_daemon_session_struct_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_pc_daemon_imanager_list_sessions (PCDaemonIManager* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	PCDaemonSessionStruct* result;
	gint result_length1 = 0;
	PCDaemonSessionStruct* _tmp69_;
	GVariantBuilder _tmp70_;
	gint _tmp71_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pc_daemon_imanager_list_sessions (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp69_ = result;
	g_variant_builder_init (&_tmp70_, G_VARIANT_TYPE ("a(susso)"));
	for (_tmp71_ = 0; _tmp71_ < result_length1; _tmp71_++) {
		GVariantBuilder _tmp72_;
		g_variant_builder_init (&_tmp72_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp72_, g_variant_new_string ((*_tmp69_).name));
		g_variant_builder_add_value (&_tmp72_, g_variant_new_uint32 ((*_tmp69_).uid));
		g_variant_builder_add_value (&_tmp72_, g_variant_new_string ((*_tmp69_).user));
		g_variant_builder_add_value (&_tmp72_, g_variant_new_string ((*_tmp69_).seat));
		g_variant_builder_add_value (&_tmp72_, g_variant_new_object_path ((*_tmp69_).object_path));
		g_variant_builder_add_value (&_tmp70_, g_variant_builder_end (&_tmp72_));
		_tmp69_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp70_));
	result = (_vala_PCDaemonSessionStruct_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_vala_PCDaemonSeatStruct_array_free (PCDaemonSeatStruct * array,
                                     gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pc_daemon_seat_struct_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_pc_daemon_imanager_list_seats (PCDaemonIManager* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	PCDaemonSeatStruct* result;
	gint result_length1 = 0;
	PCDaemonSeatStruct* _tmp73_;
	GVariantBuilder _tmp74_;
	gint _tmp75_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pc_daemon_imanager_list_seats (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp73_ = result;
	g_variant_builder_init (&_tmp74_, G_VARIANT_TYPE ("a(so)"));
	for (_tmp75_ = 0; _tmp75_ < result_length1; _tmp75_++) {
		GVariantBuilder _tmp76_;
		g_variant_builder_init (&_tmp76_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp76_, g_variant_new_string ((*_tmp73_).seat_id));
		g_variant_builder_add_value (&_tmp76_, g_variant_new_object_path ((*_tmp73_).object_path));
		g_variant_builder_add_value (&_tmp74_, g_variant_builder_end (&_tmp76_));
		_tmp73_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp74_));
	result = (_vala_PCDaemonSeatStruct_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pc_daemon_imanager_get_seat (PCDaemonIManager* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* seat = NULL;
	GVariant* _tmp77_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	seat = g_variant_dup_string (_tmp77_, NULL);
	g_variant_unref (_tmp77_);
	result = pc_daemon_imanager_get_seat (self, seat, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (seat);
	;
}

static void
pc_daemon_imanager_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListSessions") == 0) {
		_dbus_pc_daemon_imanager_list_sessions (object, parameters, invocation);
	} else if (strcmp (method_name, "ListSeats") == 0) {
		_dbus_pc_daemon_imanager_list_seats (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSeat") == 0) {
		_dbus_pc_daemon_imanager_get_seat (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pc_daemon_imanager_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pc_daemon_imanager_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pc_daemon_imanager_session_new (GObject* _sender,
                                      const gchar* session,
                                      const char* object_path,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "SessionNew", _arguments, NULL);
}

static void
_dbus_pc_daemon_imanager_session_removed (GObject* _sender,
                                          const gchar* session,
                                          const char* object_path,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "SessionRemoved", _arguments, NULL);
}

guint
pc_daemon_imanager_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pc_daemon_imanager_dbus_interface_info), &_pc_daemon_imanager_dbus_interface_vtable, data, _pc_daemon_imanager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "session-new", (GCallback) _dbus_pc_daemon_imanager_session_new, data);
	g_signal_connect (object, "session-removed", (GCallback) _dbus_pc_daemon_imanager_session_removed, data);
	return result;
}

static void
_pc_daemon_imanager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pc_daemon_imanager_session_new, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pc_daemon_imanager_session_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
pc_daemon_isession_terminate (PCDaemonISession* self,
                              GError** error)
{
	PCDaemonISessionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PC_DAEMON_ISESSION_GET_INTERFACE (self);
	if (_iface_->terminate) {
		_iface_->terminate (self, error);
	}
}

gboolean
pc_daemon_isession_get_active (PCDaemonISession* self)
{
	PCDaemonISessionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = PC_DAEMON_ISESSION_GET_INTERFACE (self);
	if (_iface_->get_active) {
		return _iface_->get_active (self);
	}
	return FALSE;
}

gchar*
pc_daemon_isession_get_name (PCDaemonISession* self)
{
	PCDaemonISessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PC_DAEMON_ISESSION_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gchar*
pc_daemon_isession_get_id (PCDaemonISession* self)
{
	PCDaemonISessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PC_DAEMON_ISESSION_GET_INTERFACE (self);
	if (_iface_->get_id) {
		return _iface_->get_id (self);
	}
	return NULL;
}

static void
pc_daemon_isession_default_init (PCDaemonISessionIface * iface,
                                 gpointer iface_data)
{
}

static GType
pc_daemon_isession_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonISessionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_isession_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pc_daemon_isession_type_id;
	pc_daemon_isession_type_id = g_type_register_static (G_TYPE_INTERFACE, "PCDaemonISession", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pc_daemon_isession_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pc_daemon_isession_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pc_daemon_isession_proxy_get_type);
	g_type_set_qdata (pc_daemon_isession_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Session");
	g_type_set_qdata (pc_daemon_isession_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pc_daemon_isession_dbus_interface_info));
	g_type_set_qdata (pc_daemon_isession_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pc_daemon_isession_register_object);
	return pc_daemon_isession_type_id;
}

GType
pc_daemon_isession_get_type (void)
{
	static volatile gsize pc_daemon_isession_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_isession_type_id__once)) {
		GType pc_daemon_isession_type_id;
		pc_daemon_isession_type_id = pc_daemon_isession_get_type_once ();
		g_once_init_leave (&pc_daemon_isession_type_id__once, pc_daemon_isession_type_id);
	}
	return pc_daemon_isession_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PCDaemonISessionProxy, pc_daemon_isession_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PC_DAEMON_TYPE_ISESSION, pc_daemon_isession_proxy_pc_daemon_isession_interface_init) )
static void
pc_daemon_isession_proxy_class_init (PCDaemonISessionProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pc_daemon_isession_proxy_g_signal;
}

static void
pc_daemon_isession_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
pc_daemon_isession_proxy_init (PCDaemonISessionProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pc_daemon_isession_dbus_interface_info));
}

static void
pc_daemon_isession_proxy_terminate (PCDaemonISession* self,
                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Session", "Terminate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
pc_daemon_isession_dbus_proxy_get_active (PCDaemonISession* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Active");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.Session"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Active"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp78_ = FALSE;
			return _tmp78_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
pc_daemon_isession_dbus_proxy_get_name (PCDaemonISession* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.Session"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
pc_daemon_isession_dbus_proxy_get_id (PCDaemonISession* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Id");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.Session"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Id"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
pc_daemon_isession_proxy_pc_daemon_isession_interface_init (PCDaemonISessionIface* iface)
{
	iface->terminate = pc_daemon_isession_proxy_terminate;
	iface->get_active = pc_daemon_isession_dbus_proxy_get_active;
	iface->get_name = pc_daemon_isession_dbus_proxy_get_name;
	iface->get_id = pc_daemon_isession_dbus_proxy_get_id;
}

static void
_dbus_pc_daemon_isession_terminate (PCDaemonISession* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pc_daemon_isession_terminate (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
pc_daemon_isession_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Terminate") == 0) {
		_dbus_pc_daemon_isession_terminate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_pc_daemon_isession_get_active (PCDaemonISession* self)
{
	gboolean result;
	GVariant* _reply;
	result = pc_daemon_isession_get_active (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_pc_daemon_isession_get_name (PCDaemonISession* self)
{
	gchar* result;
	GVariant* _reply;
	result = pc_daemon_isession_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_pc_daemon_isession_get_id (PCDaemonISession* self)
{
	gchar* result;
	GVariant* _reply;
	result = pc_daemon_isession_get_id (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
pc_daemon_isession_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Active") == 0) {
		return _dbus_pc_daemon_isession_get_active (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_pc_daemon_isession_get_name (object);
	} else if (strcmp (property_name, "Id") == 0) {
		return _dbus_pc_daemon_isession_get_id (object);
	}
	return NULL;
}

static gboolean
pc_daemon_isession_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
pc_daemon_isession_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pc_daemon_isession_dbus_interface_info), &_pc_daemon_isession_dbus_interface_vtable, data, _pc_daemon_isession_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_pc_daemon_isession_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

