/* AccessControlLists.c generated by valac 0.56.17, the Vala compiler
 * generated from AccessControlLists.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2019 Adam Bieńkowski (https://github.com/elementary/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gobject/gvaluecollector.h>

#define PC_ACCESS_CONTROL_LISTS_DEFAULT_PERMISSIONS "r-x"
#define PC_ACCESS_CONTROL_LISTS_NO_EXEC_PERMISSIONS "---"
#define PC_CONSTANTS_CLIENT_PATH "/usr/lib/pantheon-parental-controls-client"
#define PC_CONSTANTS_PARENTAL_CONTROLS_ACTION_ID "io.elementary.settings.screentime-limits.administration"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_TYPE_ACCESS_CONTROL_LISTS (pc_access_control_lists_get_type ())
#define PC_ACCESS_CONTROL_LISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_TYPE_ACCESS_CONTROL_LISTS, PCAccessControlLists))
#define PC_ACCESS_CONTROL_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_TYPE_ACCESS_CONTROL_LISTS, PCAccessControlListsClass))
#define PC_IS_ACCESS_CONTROL_LISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_TYPE_ACCESS_CONTROL_LISTS))
#define PC_IS_ACCESS_CONTROL_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_TYPE_ACCESS_CONTROL_LISTS))
#define PC_ACCESS_CONTROL_LISTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_TYPE_ACCESS_CONTROL_LISTS, PCAccessControlListsClass))

typedef struct _PCAccessControlLists PCAccessControlLists;
typedef struct _PCAccessControlListsClass PCAccessControlListsClass;
typedef struct _PCAccessControlListsPrivate PCAccessControlListsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _PCParamSpecAccessControlLists PCParamSpecAccessControlLists;

struct _PCAccessControlLists {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PCAccessControlListsPrivate * priv;
};

struct _PCAccessControlListsClass {
	GTypeClass parent_class;
	void (*finalize) (PCAccessControlLists *self);
};

struct _PCParamSpecAccessControlLists {
	GParamSpec parent_instance;
};

static gpointer pc_access_control_lists_parent_class = NULL;

VALA_EXTERN gpointer pc_access_control_lists_ref (gpointer instance);
VALA_EXTERN void pc_access_control_lists_unref (gpointer instance);
VALA_EXTERN GParamSpec* pc_param_spec_access_control_lists (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void pc_value_set_access_control_lists (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void pc_value_take_access_control_lists (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer pc_value_get_access_control_lists (const GValue* value);
VALA_EXTERN GType pc_access_control_lists_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCAccessControlLists, pc_access_control_lists_unref)
static GAppInfo* pc_access_control_lists_get_match (const gchar* target,
                                             GList* infos);
static GFile* pc_access_control_lists_create_desktop_files_dir (const gchar* username);
static gchar* pc_access_control_lists_process_desktop_entry (const gchar* path,
                                                      const gchar* target,
                                                      const gchar* username,
                                                      gboolean admin);
VALA_EXTERN gchar* pc_utils_info_to_exec_path (GAppInfo* info,
                                   gchar*** args,
                                   gint* args_length1);
VALA_EXTERN gboolean pc_access_control_lists_get_supported (void);
VALA_EXTERN void pc_access_control_lists_setfacl (const gchar* username,
                                      const gchar* target,
                                      const gchar* permissions_str);
static void pc_access_control_lists_apply_permissions (const gchar* username,
                                                gchar** targets,
                                                gint targets_length1,
                                                const gchar* permissions_str,
                                                gboolean admin);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void pc_access_control_lists_apply_targets (const gchar* username,
                                            gchar** old_targets,
                                            gint old_targets_length1,
                                            gchar** targets,
                                            gint targets_length1,
                                            gboolean old_admin,
                                            gboolean admin);
VALA_EXTERN PCAccessControlLists* pc_access_control_lists_new (void);
VALA_EXTERN PCAccessControlLists* pc_access_control_lists_construct (GType object_type);
static void pc_access_control_lists_finalize (PCAccessControlLists * obj);
static GType pc_access_control_lists_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GAppInfo*
pc_access_control_lists_get_match (const gchar* target,
                                   GList* infos)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	GAppInfo* result;
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = g_path_get_basename (target);
	basename = _tmp0_;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = infos;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GAppInfo* _tmp1_;
			GAppInfo* info = NULL;
			_tmp1_ = _g_object_ref0 ((GAppInfo*) info_it->data);
			info = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				GAppInfo* _tmp3_;
				_tmp3_ = info;
				if (g_app_info_should_show (_tmp3_)) {
					GAppInfo* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					_tmp4_ = info;
					_tmp5_ = g_app_info_get_executable (_tmp4_);
					_tmp6_ = basename;
					_tmp2_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = info;
					_g_free0 (basename);
					return result;
				}
				_g_object_unref0 (info);
			}
		}
	}
	result = NULL;
	_g_free0 (basename);
	return result;
}

static GFile*
pc_access_control_lists_create_desktop_files_dir (const gchar* username)
{
	gchar* local_appdir = NULL;
	gchar* _tmp0_;
	GFile* appdir_file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = g_build_filename (G_DIR_SEPARATOR_S, "home", username, ".local", "share", "applications", NULL);
	local_appdir = _tmp0_;
	_tmp1_ = local_appdir;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	appdir_file = _tmp2_;
	_tmp3_ = appdir_file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		{
			gboolean _tmp4_ = FALSE;
			GFile* _tmp5_;
			_tmp5_ = appdir_file;
			_tmp4_ = g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (!_tmp4_) {
				result = NULL;
				_g_object_unref0 (appdir_file);
				_g_free0 (local_appdir);
				return result;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("AccessControlLists.vala:54: %s", _tmp7_);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (appdir_file);
			_g_free0 (local_appdir);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appdir_file);
			_g_free0 (local_appdir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = appdir_file;
	_g_free0 (local_appdir);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
pc_access_control_lists_process_desktop_entry (const gchar* path,
                                               const gchar* target,
                                               const gchar* username,
                                               gboolean admin)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* exec = NULL;
	GKeyFile* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GDesktopAppInfo* _tmp8_;
	gchar** _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GKeyFile* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		GKeyFile* _tmp1_;
		_tmp1_ = keyfile;
		g_key_file_load_from_file (_tmp1_, path, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("AccessControlLists.vala:67: %s", _tmp3_);
		result = NULL;
		_g_error_free0 (e);
		_g_key_file_unref0 (keyfile);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("AccessControlLists.vala:70: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		_g_key_file_unref0 (keyfile);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = keyfile;
	_tmp7_ = g_desktop_app_info_new_from_keyfile (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp11_ = pc_utils_info_to_exec_path ((GAppInfo*) _tmp8_, &_tmp9_, &_tmp10_);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp9_;
	args_length1 = _tmp10_;
	_args_size_ = args_length1;
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp8_);
	exec = _tmp12_;
	if (admin) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GKeyFile* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp13_ = args;
		_tmp13__length1 = args_length1;
		_tmp14_ = exec;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_tmp13_[0]);
		_tmp13_[0] = _tmp15_;
		_tmp16_ = keyfile;
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = _vala_g_strjoinv (" ", _tmp17_, (gint) _tmp17__length1);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%s -a \"%s:%s:%s\"", PC_CONSTANTS_CLIENT_PATH, username, PC_CONSTANTS_PARENTAL_CONTROLS_ACTION_ID, _tmp19_);
		_tmp21_ = _tmp20_;
		g_key_file_set_string (_tmp16_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_EXEC, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	} else {
		GKeyFile* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = keyfile;
		_tmp23_ = exec;
		_tmp24_ = g_strdup_printf ("%s -d %s", PC_CONSTANTS_CLIENT_PATH, _tmp23_);
		_tmp25_ = _tmp24_;
		g_key_file_set_string (_tmp22_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_EXEC, _tmp25_);
		_g_free0 (_tmp25_);
	}
	_tmp26_ = keyfile;
	_tmp27_ = g_key_file_to_data (_tmp26_, NULL, NULL);
	result = _tmp27_;
	_g_free0 (exec);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_key_file_unref0 (keyfile);
	return result;
}

gboolean
pc_access_control_lists_get_supported (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = g_find_program_in_path ("setfacl");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
pc_access_control_lists_setfacl (const gchar* username,
                                 const gchar* target,
                                 const gchar* permissions_str)
{
	gchar* r = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (username != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (permissions_str != NULL);
	_tmp0_ = g_strdup_printf ("u:%s:%s", username, permissions_str);
	r = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = g_strdup ("setfacl");
		_tmp2_ = g_strdup ("-m");
		_tmp3_ = g_strdup (r);
		_tmp4_ = g_strdup (target);
		_tmp5_ = g_new0 (gchar*, 4 + 1);
		_tmp5_[0] = _tmp1_;
		_tmp5_[1] = _tmp2_;
		_tmp5_[2] = _tmp3_;
		_tmp5_[3] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 4;
		g_spawn_async (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, NULL, &_inner_error0_);
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (r);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("AccessControlLists.vala:109: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (r);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (r);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
pc_access_control_lists_apply_permissions (const gchar* username,
                                           gchar** targets,
                                           gint targets_length1,
                                           const gchar* permissions_str,
                                           gboolean admin)
{
	GList* infos = NULL;
	GList* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (username != NULL);
	g_return_if_fail (permissions_str != NULL);
	{
		gchar** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = targets;
		target_collection_length1 = targets_length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			gchar* _tmp0_;
			gchar* target = NULL;
			_tmp0_ = g_strdup (target_collection[target_it]);
			target = _tmp0_;
			{
				const gchar* _tmp1_;
				_tmp1_ = target;
				pc_access_control_lists_setfacl (username, _tmp1_, permissions_str);
				_g_free0 (target);
			}
		}
	}
	_tmp2_ = g_app_info_get_all ();
	infos = _tmp2_;
	{
		gchar** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = targets;
		target_collection_length1 = targets_length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			gchar* _tmp3_;
			gchar* target = NULL;
			_tmp3_ = g_strdup (target_collection[target_it]);
			target = _tmp3_;
			{
				GAppInfo* match = NULL;
				const gchar* _tmp4_;
				GList* _tmp5_;
				GAppInfo* _tmp6_;
				gboolean _tmp7_ = FALSE;
				GAppInfo* _tmp8_;
				const gchar* target_filename = NULL;
				GAppInfo* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GFile* appdir_file = NULL;
				GFile* _tmp13_;
				GFile* target_file = NULL;
				const gchar* _tmp14_;
				GFile* _tmp15_;
				gboolean _tmp16_ = FALSE;
				GFile* _tmp17_;
				GFile* dest = NULL;
				GFile* _tmp19_;
				GFile* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GFile* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				gchar* contents = NULL;
				GFile* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp4_ = target;
				_tmp5_ = infos;
				_tmp6_ = pc_access_control_lists_get_match (_tmp4_, _tmp5_);
				match = _tmp6_;
				_tmp8_ = match;
				if (_tmp8_ == NULL) {
					_tmp7_ = TRUE;
				} else {
					GAppInfo* _tmp9_;
					_tmp9_ = match;
					_tmp7_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, G_TYPE_DESKTOP_APP_INFO);
				}
				if (_tmp7_) {
					_g_object_unref0 (match);
					_g_free0 (target);
					continue;
				}
				_tmp10_ = match;
				_tmp11_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
				target_filename = _tmp11_;
				_tmp12_ = target_filename;
				if (_tmp12_ == NULL) {
					_g_object_unref0 (match);
					_g_free0 (target);
					continue;
				}
				_tmp13_ = pc_access_control_lists_create_desktop_files_dir (username);
				appdir_file = _tmp13_;
				_tmp14_ = target_filename;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				target_file = _tmp15_;
				_tmp17_ = target_file;
				if (!g_file_query_exists (_tmp17_, NULL)) {
					_tmp16_ = TRUE;
				} else {
					GFile* _tmp18_;
					_tmp18_ = appdir_file;
					_tmp16_ = _tmp18_ == NULL;
				}
				if (_tmp16_) {
					_g_object_unref0 (target_file);
					_g_object_unref0 (appdir_file);
					_g_object_unref0 (match);
					_g_free0 (target);
					continue;
				}
				_tmp19_ = appdir_file;
				_tmp20_ = target_file;
				_tmp21_ = g_file_get_basename (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_file_get_child (_tmp19_, _tmp22_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp22_);
				dest = _tmp24_;
				_tmp25_ = dest;
				if (g_file_query_exists (_tmp25_, NULL)) {
					if (g_strcmp0 (permissions_str, PC_ACCESS_CONTROL_LISTS_DEFAULT_PERMISSIONS) == 0) {
						{
							GFile* _tmp26_;
							_tmp26_ = dest;
							g_file_delete (_tmp26_, NULL, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
						}
						goto __finally0;
						__catch0_g_error:
						{
							GError* e = NULL;
							GError* _tmp27_;
							const gchar* _tmp28_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp27_ = e;
							_tmp28_ = _tmp27_->message;
							g_warning ("AccessControlLists.vala:142: %s", _tmp28_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (dest);
							_g_object_unref0 (target_file);
							_g_object_unref0 (appdir_file);
							_g_object_unref0 (match);
							_g_free0 (target);
							(infos == NULL) ? NULL : (infos = (_g_list_free__g_object_unref0_ (infos), NULL));
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_g_object_unref0 (dest);
						_g_object_unref0 (target_file);
						_g_object_unref0 (appdir_file);
						_g_object_unref0 (match);
						_g_free0 (target);
						continue;
					}
				}
				_tmp29_ = target_file;
				_tmp30_ = g_file_get_path (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = target;
				_tmp33_ = pc_access_control_lists_process_desktop_entry (_tmp31_, _tmp32_, username, admin);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp31_);
				contents = _tmp34_;
				_tmp35_ = contents;
				if (_tmp35_ == NULL) {
					_g_free0 (contents);
					_g_object_unref0 (dest);
					_g_object_unref0 (target_file);
					_g_object_unref0 (appdir_file);
					_g_object_unref0 (match);
					_g_free0 (target);
					continue;
				}
				{
					GFileOutputStream* os = NULL;
					GFile* _tmp36_;
					GFileOutputStream* _tmp37_;
					GFileOutputStream* _tmp38_;
					const gchar* _tmp39_;
					guint8* _tmp40_;
					gint _tmp40__length1;
					gint _tmp41_ = 0;
					guint8* _tmp42_;
					gint _tmp42__length1;
					GFileOutputStream* _tmp43_;
					_tmp36_ = dest;
					_tmp37_ = g_file_create (_tmp36_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
					os = _tmp37_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp38_ = os;
					_tmp39_ = contents;
					_tmp40_ = string_get_data (_tmp39_, &_tmp41_);
					_tmp40__length1 = _tmp41_;
					_tmp42_ = _tmp40_;
					_tmp42__length1 = _tmp40__length1;
					g_output_stream_write_all ((GOutputStream*) _tmp38_, _tmp42_, (gsize) _tmp42__length1, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (os);
						goto __catch1_g_error;
					}
					_tmp43_ = os;
					g_output_stream_close ((GOutputStream*) _tmp43_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (os);
						goto __catch1_g_error;
					}
					_g_object_unref0 (os);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp44_;
					const gchar* _tmp45_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp44_ = e;
					_tmp45_ = _tmp44_->message;
					g_warning ("AccessControlLists.vala:159: %s", _tmp45_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (contents);
					_g_object_unref0 (dest);
					_g_object_unref0 (target_file);
					_g_object_unref0 (appdir_file);
					_g_object_unref0 (match);
					_g_free0 (target);
					(infos == NULL) ? NULL : (infos = (_g_list_free__g_object_unref0_ (infos), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (contents);
				_g_object_unref0 (dest);
				_g_object_unref0 (target_file);
				_g_object_unref0 (appdir_file);
				_g_object_unref0 (match);
				_g_free0 (target);
			}
		}
	}
	(infos == NULL) ? NULL : (infos = (_g_list_free__g_object_unref0_ (infos), NULL));
}

void
pc_access_control_lists_apply_targets (const gchar* username,
                                       gchar** old_targets,
                                       gint old_targets_length1,
                                       gchar** targets,
                                       gint targets_length1,
                                       gboolean old_admin,
                                       gboolean admin)
{
	g_return_if_fail (username != NULL);
	pc_access_control_lists_apply_permissions (username, old_targets, (gint) old_targets_length1, PC_ACCESS_CONTROL_LISTS_DEFAULT_PERMISSIONS, old_admin);
	pc_access_control_lists_apply_permissions (username, targets, (gint) targets_length1, PC_ACCESS_CONTROL_LISTS_NO_EXEC_PERMISSIONS, admin);
}

PCAccessControlLists*
pc_access_control_lists_construct (GType object_type)
{
	PCAccessControlLists* self = NULL;
	self = (PCAccessControlLists*) g_type_create_instance (object_type);
	return self;
}

PCAccessControlLists*
pc_access_control_lists_new (void)
{
	return pc_access_control_lists_construct (PC_TYPE_ACCESS_CONTROL_LISTS);
}

static void
pc_value_access_control_lists_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pc_value_access_control_lists_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pc_access_control_lists_unref (value->data[0].v_pointer);
	}
}

static void
pc_value_access_control_lists_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pc_access_control_lists_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pc_value_access_control_lists_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pc_value_access_control_lists_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PCAccessControlLists * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pc_access_control_lists_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pc_value_access_control_lists_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	PCAccessControlLists ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pc_access_control_lists_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pc_param_spec_access_control_lists (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	PCParamSpecAccessControlLists* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PC_TYPE_ACCESS_CONTROL_LISTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pc_value_get_access_control_lists (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_TYPE_ACCESS_CONTROL_LISTS), NULL);
	return value->data[0].v_pointer;
}

void
pc_value_set_access_control_lists (GValue* value,
                                   gpointer v_object)
{
	PCAccessControlLists * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_TYPE_ACCESS_CONTROL_LISTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PC_TYPE_ACCESS_CONTROL_LISTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pc_access_control_lists_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pc_access_control_lists_unref (old);
	}
}

void
pc_value_take_access_control_lists (GValue* value,
                                    gpointer v_object)
{
	PCAccessControlLists * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_TYPE_ACCESS_CONTROL_LISTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PC_TYPE_ACCESS_CONTROL_LISTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pc_access_control_lists_unref (old);
	}
}

static void
pc_access_control_lists_class_init (PCAccessControlListsClass * klass,
                                    gpointer klass_data)
{
	pc_access_control_lists_parent_class = g_type_class_peek_parent (klass);
	((PCAccessControlListsClass *) klass)->finalize = pc_access_control_lists_finalize;
}

static void
pc_access_control_lists_instance_init (PCAccessControlLists * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
pc_access_control_lists_finalize (PCAccessControlLists * obj)
{
	PCAccessControlLists * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_TYPE_ACCESS_CONTROL_LISTS, PCAccessControlLists);
	g_signal_handlers_destroy (self);
}

static GType
pc_access_control_lists_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pc_value_access_control_lists_init, pc_value_access_control_lists_free_value, pc_value_access_control_lists_copy_value, pc_value_access_control_lists_peek_pointer, "p", pc_value_access_control_lists_collect_value, "p", pc_value_access_control_lists_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PCAccessControlListsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_access_control_lists_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCAccessControlLists), 0, (GInstanceInitFunc) pc_access_control_lists_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pc_access_control_lists_type_id;
	pc_access_control_lists_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PCAccessControlLists", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return pc_access_control_lists_type_id;
}

GType
pc_access_control_lists_get_type (void)
{
	static volatile gsize pc_access_control_lists_type_id__once = 0;
	if (g_once_init_enter (&pc_access_control_lists_type_id__once)) {
		GType pc_access_control_lists_type_id;
		pc_access_control_lists_type_id = pc_access_control_lists_get_type_once ();
		g_once_init_leave (&pc_access_control_lists_type_id__once, pc_access_control_lists_type_id);
	}
	return pc_access_control_lists_type_id__once;
}

gpointer
pc_access_control_lists_ref (gpointer instance)
{
	PCAccessControlLists * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pc_access_control_lists_unref (gpointer instance)
{
	PCAccessControlLists * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PC_ACCESS_CONTROL_LISTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

