/* PairDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PairDialog.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bluetooth.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAIR_DIALOG_0_PROPERTY,
	PAIR_DIALOG_OBJECT_PATH_PROPERTY,
	PAIR_DIALOG_AUTH_TYPE_PROPERTY,
	PAIR_DIALOG_PASSKEY_PROPERTY,
	PAIR_DIALOG_CANCELLED_PROPERTY,
	PAIR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* pair_dialog_properties[PAIR_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PairDialogPrivate {
	char* _object_path;
	PairDialogAuthType _auth_type;
	gchar* _passkey;
	gboolean _cancelled;
};

struct _Block1Data {
	int _ref_count_;
	PairDialog* self;
	BluetoothServicesDevice* device;
};

static gint PairDialog_private_offset;
static gpointer pair_dialog_parent_class = NULL;

static PairDialog* pair_dialog_new (void);
static PairDialog* pair_dialog_construct (GType object_type);
static GObject * pair_dialog_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _pair_dialog____lambda4_ (Block1Data* _data1_,
                               GVariant* changed,
                               gchar** invalid);
static void __pair_dialog____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                  GVariant* changed_properties,
                                                                  gchar** invalidated_properties,
                                                                  gpointer self);
static void pair_dialog_finalize (GObject * obj);
static GType pair_dialog_get_type_once (void);
static void _vala_pair_dialog_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_pair_dialog_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
pair_dialog_get_instance_private (PairDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PairDialog_private_offset);
}

static GType
pair_dialog_auth_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PAIR_DIALOG_AUTH_TYPE_REQUEST_CONFIRMATION, "PAIR_DIALOG_AUTH_TYPE_REQUEST_CONFIRMATION", "request-confirmation"}, {PAIR_DIALOG_AUTH_TYPE_REQUEST_AUTHORIZATION, "PAIR_DIALOG_AUTH_TYPE_REQUEST_AUTHORIZATION", "request-authorization"}, {PAIR_DIALOG_AUTH_TYPE_DISPLAY_PASSKEY, "PAIR_DIALOG_AUTH_TYPE_DISPLAY_PASSKEY", "display-passkey"}, {PAIR_DIALOG_AUTH_TYPE_DISPLAY_PIN_CODE, "PAIR_DIALOG_AUTH_TYPE_DISPLAY_PIN_CODE", "display-pin-code"}, {0, NULL, NULL}};
	GType pair_dialog_auth_type_type_id;
	pair_dialog_auth_type_type_id = g_enum_register_static ("PairDialogAuthType", values);
	return pair_dialog_auth_type_type_id;
}

GType
pair_dialog_auth_type_get_type (void)
{
	static volatile gsize pair_dialog_auth_type_type_id__once = 0;
	if (g_once_init_enter (&pair_dialog_auth_type_type_id__once)) {
		GType pair_dialog_auth_type_type_id;
		pair_dialog_auth_type_type_id = pair_dialog_auth_type_get_type_once ();
		g_once_init_leave (&pair_dialog_auth_type_type_id__once, pair_dialog_auth_type_type_id);
	}
	return pair_dialog_auth_type_type_id__once;
}

static PairDialog*
pair_dialog_construct (GType object_type)
{
	PairDialog * self = NULL;
	self = (PairDialog*) g_object_new (object_type, "buttons", GTK_BUTTONS_CANCEL, NULL);
	return self;
}

static PairDialog*
pair_dialog_new (void)
{
	return pair_dialog_construct (TYPE_PAIR_DIALOG);
}

PairDialog*
pair_dialog_construct_request_authorization (GType object_type,
                                             const char* object_path,
                                             GtkWindow* main_window)
{
	PairDialog * self = NULL;
	g_return_val_if_fail (object_path != NULL, NULL);
	self = (PairDialog*) g_object_new (object_type, "auth-type", PAIR_DIALOG_AUTH_TYPE_REQUEST_AUTHORIZATION, "buttons", GTK_BUTTONS_CANCEL, "object-path", object_path, "primary-text", _ ("Confirm Bluetooth Pairing"), "transient-for", main_window, NULL);
	return self;
}

PairDialog*
pair_dialog_new_request_authorization (const char* object_path,
                                       GtkWindow* main_window)
{
	return pair_dialog_construct_request_authorization (TYPE_PAIR_DIALOG, object_path, main_window);
}

PairDialog*
pair_dialog_construct_display_passkey (GType object_type,
                                       const char* object_path,
                                       guint32 passkey,
                                       guint16 entered,
                                       GtkWindow* main_window)
{
	PairDialog * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (object_path != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", (guint) passkey);
	_tmp1_ = _tmp0_;
	self = (PairDialog*) g_object_new (object_type, "auth-type", PAIR_DIALOG_AUTH_TYPE_DISPLAY_PASSKEY, "buttons", GTK_BUTTONS_CANCEL, "object-path", object_path, "passkey", _tmp1_, "primary-text", _ ("Enter Bluetooth Passkey"), "transient-for", main_window, NULL);
	_g_free0 (_tmp1_);
	return self;
}

PairDialog*
pair_dialog_new_display_passkey (const char* object_path,
                                 guint32 passkey,
                                 guint16 entered,
                                 GtkWindow* main_window)
{
	return pair_dialog_construct_display_passkey (TYPE_PAIR_DIALOG, object_path, passkey, entered, main_window);
}

PairDialog*
pair_dialog_construct_request_confirmation (GType object_type,
                                            const char* object_path,
                                            guint32 passkey,
                                            GtkWindow* main_window)
{
	PairDialog * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (object_path != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", (guint) passkey);
	_tmp1_ = _tmp0_;
	self = (PairDialog*) g_object_new (object_type, "auth-type", PAIR_DIALOG_AUTH_TYPE_REQUEST_CONFIRMATION, "buttons", GTK_BUTTONS_CANCEL, "object-path", object_path, "passkey", _tmp1_, "primary-text", _ ("Confirm Bluetooth Passkey"), "transient-for", main_window, NULL);
	_g_free0 (_tmp1_);
	return self;
}

PairDialog*
pair_dialog_new_request_confirmation (const char* object_path,
                                      guint32 passkey,
                                      GtkWindow* main_window)
{
	return pair_dialog_construct_request_confirmation (TYPE_PAIR_DIALOG, object_path, passkey, main_window);
}

PairDialog*
pair_dialog_construct_display_pin_code (GType object_type,
                                        const char* object_path,
                                        const gchar* pincode,
                                        GtkWindow* main_window)
{
	PairDialog * self = NULL;
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (pincode != NULL, NULL);
	self = (PairDialog*) g_object_new (object_type, "auth-type", PAIR_DIALOG_AUTH_TYPE_DISPLAY_PIN_CODE, "buttons", GTK_BUTTONS_CANCEL, "object-path", object_path, "passkey", pincode, "primary-text", _ ("Enter Bluetooth PIN"), "transient-for", main_window, NULL);
	return self;
}

PairDialog*
pair_dialog_new_display_pin_code (const char* object_path,
                                  const gchar* pincode,
                                  GtkWindow* main_window)
{
	return pair_dialog_construct_display_pin_code (TYPE_PAIR_DIALOG, object_path, pincode, main_window);
}

const char*
pair_dialog_get_object_path (PairDialog* self)
{
	const char* result;
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	result = _tmp0_;
	return result;
}

static void
pair_dialog_set_object_path (PairDialog* self,
                             const char* value)
{
	char* old_value;
	g_return_if_fail (self != NULL);
	old_value = pair_dialog_get_object_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		char* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_object_path);
		self->priv->_object_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pair_dialog_properties[PAIR_DIALOG_OBJECT_PATH_PROPERTY]);
	}
}

PairDialogAuthType
pair_dialog_get_auth_type (PairDialog* self)
{
	PairDialogAuthType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_auth_type;
	return result;
}

static void
pair_dialog_set_auth_type (PairDialog* self,
                           PairDialogAuthType value)
{
	PairDialogAuthType old_value;
	g_return_if_fail (self != NULL);
	old_value = pair_dialog_get_auth_type (self);
	if (old_value != value) {
		self->priv->_auth_type = value;
		g_object_notify_by_pspec ((GObject *) self, pair_dialog_properties[PAIR_DIALOG_AUTH_TYPE_PROPERTY]);
	}
}

const gchar*
pair_dialog_get_passkey (PairDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_passkey;
	result = _tmp0_;
	return result;
}

static void
pair_dialog_set_passkey (PairDialog* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pair_dialog_get_passkey (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_passkey);
		self->priv->_passkey = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pair_dialog_properties[PAIR_DIALOG_PASSKEY_PROPERTY]);
	}
}

gboolean
pair_dialog_get_cancelled (PairDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cancelled;
	return result;
}

void
pair_dialog_set_cancelled (PairDialog* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pair_dialog_get_cancelled (self);
	if (old_value != value) {
		self->priv->_cancelled = value;
		g_object_notify_by_pspec ((GObject *) self, pair_dialog_properties[PAIR_DIALOG_CANCELLED_PROPERTY]);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PairDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->device);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_pair_dialog____lambda4_ (Block1Data* _data1_,
                          GVariant* changed,
                          gchar** invalid)
{
	PairDialog* self;
	GVariant* paired = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GVariant* _tmp5_;
	self = _data1_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Paired", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	paired = _tmp3_;
	_tmp5_ = paired;
	if (_tmp5_ != NULL) {
		BluetoothServicesDevice* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = _data1_->device;
		_tmp7_ = bluetooth_services_device_get_paired (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
	}
	_g_variant_unref0 (paired);
}

static void
__pair_dialog____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                             GVariant* changed_properties,
                                                             gchar** invalidated_properties,
                                                             gpointer self)
{
	_pair_dialog____lambda4_ (self, changed_properties, invalidated_properties);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
pair_dialog_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PairDialog * self;
	Block1Data* _data1_;
	gchar* device_name = NULL;
	gchar* _tmp0_;
	PairDialogAuthType _tmp25_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pair_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAIR_DIALOG, PairDialog);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Unknown Bluetooth Device"));
	device_name = _tmp0_;
	{
		BluetoothServicesDevice* _tmp1_ = NULL;
		const char* _tmp2_;
		BluetoothServicesDevice* _tmp3_;
		BluetoothServicesDevice* _tmp4_;
		gchar* _tmp5_ = NULL;
		BluetoothServicesDevice* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GThemedIcon* _tmp10_;
		GThemedIcon* _tmp11_;
		gchar* _tmp12_ = NULL;
		BluetoothServicesDevice* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp19_;
		BluetoothServicesDevice* _tmp20_;
		_tmp2_ = self->priv->_object_path;
		_tmp3_ = (BluetoothServicesDevice*) g_initable_new (BLUETOOTH_SERVICES_TYPE_DEVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _tmp2_, "g-interface-name", "org.bluez.Device1", NULL);
		_tmp1_ = (BluetoothServicesDevice*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_free0 (device_name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (_data1_->device);
		_data1_->device = _tmp4_;
		_tmp6_ = _data1_->device;
		_tmp7_ = bluetooth_services_device_get_icon (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
		if (_tmp5_ == NULL) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("bluetooth");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp9_;
		}
		_tmp10_ = (GThemedIcon*) g_themed_icon_new (_tmp5_);
		_tmp11_ = _tmp10_;
		granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		_tmp13_ = _data1_->device;
		_tmp14_ = bluetooth_services_device_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp12_ = _tmp15_;
		if (_tmp12_ == NULL) {
			BluetoothServicesDevice* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = _data1_->device;
			_tmp17_ = bluetooth_services_device_get_address (_tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp18_;
		}
		_tmp19_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (device_name);
		device_name = _tmp19_;
		_tmp20_ = _data1_->device;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __pair_dialog____lambda4__g_dbus_proxy_g_properties_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp5_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GThemedIcon* _tmp21_;
		GThemedIcon* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = (GThemedIcon*) g_themed_icon_new ("bluetooth");
		_tmp22_ = _tmp21_;
		granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp22_);
		_g_object_unref0 (_tmp22_);
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_critical ("PairDialog.vala:98: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (device_name);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp25_ = self->priv->_auth_type;
	switch (_tmp25_) {
		case PAIR_DIALOG_AUTH_TYPE_REQUEST_CONFIRMATION:
		{
			GThemedIcon* _tmp26_;
			GThemedIcon* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GtkWidget* confirm_button = NULL;
			GtkWidget* _tmp31_;
			GtkWidget* _tmp32_;
			GtkWidget* _tmp33_;
			GtkStyleContext* _tmp34_;
			_tmp26_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
			_tmp27_ = _tmp26_;
			granite_message_dialog_set_badge_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp27_);
			_g_object_unref0 (_tmp27_);
			_tmp28_ = device_name;
			_tmp29_ = g_strdup_printf (_ ("Make sure the code displayed on “%s” matches the one below."), _tmp28_);
			_tmp30_ = _tmp29_;
			granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Pair"), (gint) GTK_RESPONSE_ACCEPT);
			_tmp32_ = _g_object_ref0 (_tmp31_);
			confirm_button = _tmp32_;
			_tmp33_ = confirm_button;
			_tmp34_ = gtk_widget_get_style_context (_tmp33_);
			gtk_style_context_add_class (_tmp34_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
			_g_object_unref0 (confirm_button);
			break;
		}
		case PAIR_DIALOG_AUTH_TYPE_DISPLAY_PASSKEY:
		case PAIR_DIALOG_AUTH_TYPE_DISPLAY_PIN_CODE:
		{
			GThemedIcon* _tmp35_;
			GThemedIcon* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp35_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
			_tmp36_ = _tmp35_;
			granite_message_dialog_set_badge_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp36_);
			_g_object_unref0 (_tmp36_);
			_tmp37_ = device_name;
			_tmp38_ = g_strdup_printf (_ ("Type the code displayed below on “%s”, followed by Enter."), _tmp37_);
			_tmp39_ = _tmp38_;
			granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _tmp39_);
			_g_free0 (_tmp39_);
			break;
		}
		case PAIR_DIALOG_AUTH_TYPE_REQUEST_AUTHORIZATION:
		{
			GThemedIcon* _tmp40_;
			GThemedIcon* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			GtkWidget* confirm_button = NULL;
			GtkWidget* _tmp45_;
			GtkWidget* _tmp46_;
			GtkWidget* _tmp47_;
			GtkStyleContext* _tmp48_;
			_tmp40_ = (GThemedIcon*) g_themed_icon_new ("dialog-question");
			_tmp41_ = _tmp40_;
			granite_message_dialog_set_badge_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp41_);
			_g_object_unref0 (_tmp41_);
			_tmp42_ = device_name;
			_tmp43_ = g_strdup_printf (_ ("“%s” would like to pair with this device."), _tmp42_);
			_tmp44_ = _tmp43_;
			granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Pair"), (gint) GTK_RESPONSE_ACCEPT);
			_tmp46_ = _g_object_ref0 (_tmp45_);
			confirm_button = _tmp46_;
			_tmp47_ = confirm_button;
			_tmp48_ = gtk_widget_get_style_context (_tmp47_);
			gtk_style_context_add_class (_tmp48_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
			_g_object_unref0 (confirm_button);
			break;
		}
		default:
		break;
	}
	_tmp50_ = self->priv->_passkey;
	if (_tmp50_ != NULL) {
		const gchar* _tmp51_;
		_tmp51_ = self->priv->_passkey;
		_tmp49_ = g_strcmp0 (_tmp51_, "") != 0;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		GtkLabel* passkey_label = NULL;
		const gchar* _tmp52_;
		GtkLabel* _tmp53_;
		GtkLabel* _tmp54_;
		GtkStyleContext* _tmp55_;
		GtkBox* _tmp56_;
		GtkBox* _tmp57_;
		GtkLabel* _tmp58_;
		_tmp52_ = self->priv->_passkey;
		_tmp53_ = (GtkLabel*) gtk_label_new (_tmp52_);
		g_object_ref_sink (_tmp53_);
		passkey_label = _tmp53_;
		_tmp54_ = passkey_label;
		_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
		gtk_style_context_add_class (_tmp55_, GRANITE_STYLE_CLASS_H1_LABEL);
		_tmp56_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
		_tmp57_ = _tmp56_;
		_tmp58_ = passkey_label;
		gtk_box_append (_tmp57_, (GtkWidget*) _tmp58_);
		_g_object_unref0 (passkey_label);
	}
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_g_free0 (device_name);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
pair_dialog_class_init (PairDialogClass * klass,
                        gpointer klass_data)
{
	pair_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PairDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pair_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pair_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = pair_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = pair_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAIR_DIALOG_OBJECT_PATH_PROPERTY, pair_dialog_properties[PAIR_DIALOG_OBJECT_PATH_PROPERTY] = g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAIR_DIALOG_AUTH_TYPE_PROPERTY, pair_dialog_properties[PAIR_DIALOG_AUTH_TYPE_PROPERTY] = g_param_spec_enum ("auth-type", "auth-type", "auth-type", PAIR_DIALOG_TYPE_AUTH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAIR_DIALOG_PASSKEY_PROPERTY, pair_dialog_properties[PAIR_DIALOG_PASSKEY_PROPERTY] = g_param_spec_string ("passkey", "passkey", "passkey", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAIR_DIALOG_CANCELLED_PROPERTY, pair_dialog_properties[PAIR_DIALOG_CANCELLED_PROPERTY] = g_param_spec_boolean ("cancelled", "cancelled", "cancelled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pair_dialog_instance_init (PairDialog * self,
                           gpointer klass)
{
	self->priv = pair_dialog_get_instance_private (self);
}

static void
pair_dialog_finalize (GObject * obj)
{
	PairDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAIR_DIALOG, PairDialog);
	_g_free0 (self->priv->_object_path);
	_g_free0 (self->priv->_passkey);
	G_OBJECT_CLASS (pair_dialog_parent_class)->finalize (obj);
}

static GType
pair_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PairDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pair_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PairDialog), 0, (GInstanceInitFunc) pair_dialog_instance_init, NULL };
	GType pair_dialog_type_id;
	pair_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "PairDialog", &g_define_type_info, 0);
	PairDialog_private_offset = g_type_add_instance_private (pair_dialog_type_id, sizeof (PairDialogPrivate));
	return pair_dialog_type_id;
}

GType
pair_dialog_get_type (void)
{
	static volatile gsize pair_dialog_type_id__once = 0;
	if (g_once_init_enter (&pair_dialog_type_id__once)) {
		GType pair_dialog_type_id;
		pair_dialog_type_id = pair_dialog_get_type_once ();
		g_once_init_leave (&pair_dialog_type_id__once, pair_dialog_type_id);
	}
	return pair_dialog_type_id__once;
}

static void
_vala_pair_dialog_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PairDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAIR_DIALOG, PairDialog);
	switch (property_id) {
		case PAIR_DIALOG_OBJECT_PATH_PROPERTY:
		g_value_set_string (value, pair_dialog_get_object_path (self));
		break;
		case PAIR_DIALOG_AUTH_TYPE_PROPERTY:
		g_value_set_enum (value, pair_dialog_get_auth_type (self));
		break;
		case PAIR_DIALOG_PASSKEY_PROPERTY:
		g_value_set_string (value, pair_dialog_get_passkey (self));
		break;
		case PAIR_DIALOG_CANCELLED_PROPERTY:
		g_value_set_boolean (value, pair_dialog_get_cancelled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pair_dialog_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PairDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAIR_DIALOG, PairDialog);
	switch (property_id) {
		case PAIR_DIALOG_OBJECT_PATH_PROPERTY:
		pair_dialog_set_object_path (self, g_value_get_string (value));
		break;
		case PAIR_DIALOG_AUTH_TYPE_PROPERTY:
		pair_dialog_set_auth_type (self, g_value_get_enum (value));
		break;
		case PAIR_DIALOG_PASSKEY_PROPERTY:
		pair_dialog_set_passkey (self, g_value_get_string (value));
		break;
		case PAIR_DIALOG_CANCELLED_PROPERTY:
		pair_dialog_set_cancelled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

