/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright 2011-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
* Authored by: Avi Romanoff <avi@romanoff.me>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "switchboard.h"
#include <adwaita.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <locale.h>
#include <gio/gdesktopappinfo.h>

#define GETTEXT_PACKAGE "io.elementary.settings"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SWITCHBOARD_TYPE_SWITCHBOARD_APP (switchboard_switchboard_app_get_type ())
#define SWITCHBOARD_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp))
#define SWITCHBOARD_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))
#define SWITCHBOARD_IS_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_IS_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_SWITCHBOARD_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))

typedef struct _SwitchboardSwitchboardApp SwitchboardSwitchboardApp;
typedef struct _SwitchboardSwitchboardAppClass SwitchboardSwitchboardAppClass;
typedef struct _SwitchboardSwitchboardAppPrivate SwitchboardSwitchboardAppPrivate;

#define SWITCHBOARD_TYPE_CATEGORY_VIEW (switchboard_category_view_get_type ())
#define SWITCHBOARD_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView))
#define SWITCHBOARD_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))
#define SWITCHBOARD_IS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_IS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))

typedef struct _SwitchboardCategoryView SwitchboardCategoryView;
typedef struct _SwitchboardCategoryViewClass SwitchboardCategoryViewClass;
enum  {
	SWITCHBOARD_SWITCHBOARD_APP_0_PROPERTY,
	SWITCHBOARD_SWITCHBOARD_APP_NUM_PROPERTIES
};
static GParamSpec* switchboard_switchboard_app_properties[SWITCHBOARD_SWITCHBOARD_APP_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define SWITCHBOARD_TYPE_SEARCH_ENTRY (switchboard_search_entry_get_type ())
typedef struct _SwitchboardSearchEntry SwitchboardSearchEntry;
#define _switchboard_search_entry_free0(var) ((var == NULL) ? NULL : (var = (switchboard_search_entry_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SwitchboardSwitchboardApp {
	GtkApplication parent_instance;
	SwitchboardSwitchboardAppPrivate * priv;
};

struct _SwitchboardSwitchboardAppClass {
	GtkApplicationClass parent_class;
};

struct _SwitchboardSwitchboardAppPrivate {
	GHashTable* plug_widgets;
	AdwNavigationView* navigation_view;
	GtkWindow* main_window;
	SwitchboardCategoryView* category_view;
};

struct _Block1Data {
	int _ref_count_;
	SwitchboardSwitchboardApp* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

struct _Block2Data {
	int _ref_count_;
	SwitchboardSwitchboardApp* self;
	SwitchboardPlug* plug;
};

struct _SwitchboardSearchEntry {
	gchar* plug_name;
	gchar* ui_elements;
	gchar* open_window;
};

static gint SwitchboardSwitchboardApp_private_offset;
static gpointer switchboard_switchboard_app_parent_class = NULL;
static gboolean switchboard_switchboard_app_opened_directly;
static gboolean switchboard_switchboard_app_opened_directly = FALSE;
static gchar* switchboard_switchboard_app_link;
static gchar* switchboard_switchboard_app_link = NULL;
static gchar* switchboard_switchboard_app_open_window;
static gchar* switchboard_switchboard_app_open_window = NULL;
static gchar* switchboard_switchboard_app_plug_to_open;
static gchar* switchboard_switchboard_app_plug_to_open = NULL;

VALA_EXTERN GType switchboard_switchboard_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSwitchboardApp, g_object_unref)
VALA_EXTERN GType switchboard_category_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryView, g_object_unref)
static void switchboard_switchboard_app_real_open (GApplication* base,
                                            GFile** files,
                                            gint files_length1,
                                            const gchar* hint);
static void switchboard_switchboard_app_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda18_ (Block1Data* _data1_);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void switchboard_switchboard_app_action_navigate_back (SwitchboardSwitchboardApp* self);
static void _switchboard_switchboard_app_action_navigate_back_g_simple_action_activate (GSimpleAction* _sender,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void _g_application_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                   GVariant* parameter,
                                                   gpointer self);
static void __lambda19_ (SwitchboardSwitchboardApp* self);
static void ___lambda19__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void switchboard_switchboard_app_real_activate (GApplication* base);
VALA_EXTERN gboolean switchboard_switchboard_app_load_setting_path (SwitchboardSwitchboardApp* self,
                                                        const gchar* setting_path,
                                                        SwitchboardPlugsManager* plugsmanager);
VALA_EXTERN void switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                            SwitchboardPlug* plug);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_new (const gchar* plug);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_construct (GType object_type,
                                                              const gchar* plug);
static void __lambda17_ (SwitchboardSwitchboardApp* self);
static void ___lambda17__g_application_shutdown (GApplication* _sender,
                                          gpointer self);
static void switchboard_switchboard_app_update_navigation (SwitchboardSwitchboardApp* self);
static void _switchboard_switchboard_app_update_navigation_adw_navigation_view_popped (AdwNavigationView* _sender,
                                                                                AdwNavigationPage* page,
                                                                                gpointer self);
static void _switchboard_switchboard_app_update_navigation_adw_navigation_view_pushed (AdwNavigationView* _sender,
                                                                                gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
static void _switchboard_plug_hidden_adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                                          gpointer self);
static void _switchboard_plug_shown_adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                        gpointer self);
VALA_EXTERN GType switchboard_search_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SwitchboardSearchEntry* switchboard_search_entry_dup (const SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_free (SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_copy (const SwitchboardSearchEntry* self,
                                    SwitchboardSearchEntry* dest);
VALA_EXTERN void switchboard_search_entry_destroy (SwitchboardSearchEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwitchboardSearchEntry, switchboard_search_entry_destroy)
VALA_EXTERN GeeArrayList* switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self);
static gboolean __lambda9_ (Block2Data* _data2_,
                     SwitchboardSearchEntry* entry);
static gboolean ___lambda9__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean ___lambda8__gsource_func (gpointer self);
static gint switchboard_switchboard_app_main (gchar** args,
                                       gint args_length1);
VALA_EXTERN SwitchboardSwitchboardApp* switchboard_switchboard_app_new (void);
VALA_EXTERN SwitchboardSwitchboardApp* switchboard_switchboard_app_construct (GType object_type);
static GObject * switchboard_switchboard_app_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void switchboard_switchboard_app_finalize (GObject * obj);
static GType switchboard_switchboard_app_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
switchboard_switchboard_app_get_instance_private (SwitchboardSwitchboardApp* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardSwitchboardApp_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
switchboard_switchboard_app_real_open (GApplication* base,
                                       GFile** files,
                                       gint files_length1,
                                       const gchar* hint)
{
	SwitchboardSwitchboardApp * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	self = (SwitchboardSwitchboardApp*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (file);
		return;
	}
	_tmp3_ = file;
	_tmp4_ = g_file_get_uri_scheme (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "settings") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = file;
		_tmp8_ = g_file_get_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_replace (_tmp9_, "settings://", "");
		_g_free0 (switchboard_switchboard_app_link);
		switchboard_switchboard_app_link = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = switchboard_switchboard_app_link;
		if (g_str_has_suffix (_tmp11_, "/")) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = switchboard_switchboard_app_link;
			_tmp13_ = switchboard_switchboard_app_link;
			_tmp14_ = string_substring (_tmp12_, (glong) 0, (glong) string_last_index_of_char (_tmp13_, (gunichar) '/', 0));
			_g_free0 (switchboard_switchboard_app_link);
			switchboard_switchboard_app_link = _tmp14_;
		}
	} else {
		g_critical ("Application.vala:65: Calling Switchboard directly is unsupported, plea" \
"se use the settings:// scheme instead");
	}
	g_application_activate ((GApplication*) self);
	_g_object_unref0 (file);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SwitchboardSwitchboardApp* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda18_ (Block1Data* _data1_)
{
	SwitchboardSwitchboardApp* self;
	GraniteSettingsColorScheme _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	self = _data1_->self;
	_tmp0_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda18_ (self);
}

static void
_switchboard_switchboard_app_action_navigate_back_g_simple_action_activate (GSimpleAction* _sender,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	switchboard_switchboard_app_action_navigate_back ((SwitchboardSwitchboardApp*) self);
}

static void
_g_application_quit_g_simple_action_activate (GSimpleAction* _sender,
                                              GVariant* parameter,
                                              gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
__lambda19_ (SwitchboardSwitchboardApp* self)
{
	GFile* _tmp0_;
	GFile** _tmp1_;
	GFile** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_file_new_for_uri ("settings://about/os");
	_tmp1_ = g_new0 (GFile*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	g_application_open ((GApplication*) self, _tmp2_, (gint) 1, "");
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
___lambda19__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda19_ ((SwitchboardSwitchboardApp*) self);
}

static void
switchboard_switchboard_app_real_startup (GApplication* base)
{
	SwitchboardSwitchboardApp * self;
	Block1Data* _data1_;
	GraniteSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* _tmp3_;
	GraniteSettingsColorScheme _tmp4_;
	GraniteSettingsColorScheme _tmp5_;
	GSimpleAction* back_action = NULL;
	GSimpleAction* _tmp6_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp7_;
	GSimpleAction* updates_action = NULL;
	GSimpleAction* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	self = (SwitchboardSwitchboardApp*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (switchboard_switchboard_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	granite_init ();
	_tmp0_ = granite_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data1_->granite_settings = _tmp1_;
	_tmp2_ = gtk_settings_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data1_->gtk_settings = _tmp3_;
	_tmp4_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp5_ = _tmp4_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp5_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) _data1_->granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda18__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = g_simple_action_new ("back", NULL);
	back_action = _tmp6_;
	_tmp7_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp7_;
	_tmp8_ = g_simple_action_new ("show-updates", NULL);
	updates_action = _tmp8_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) back_action);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	g_action_map_add_action ((GActionMap*) self, (GAction*) updates_action);
	_tmp9_ = g_strdup ("<Control>q");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	g_signal_connect_object (back_action, "activate", (GCallback) _switchboard_switchboard_app_action_navigate_back_g_simple_action_activate, self, 0);
	g_signal_connect_object (quit_action, "activate", (GCallback) _g_application_quit_g_simple_action_activate, (GApplication*) self, 0);
	g_signal_connect_object (updates_action, "activate", (GCallback) ___lambda19__g_simple_action_activate, self, 0);
	_g_object_unref0 (updates_action);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (back_action);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda17_ (SwitchboardSwitchboardApp* self)
{
	AdwNavigationView* _tmp0_;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = adw_navigation_view_get_visible_page (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (_tmp2_, "hidden");
}

static void
___lambda17__g_application_shutdown (GApplication* _sender,
                                     gpointer self)
{
	__lambda17_ ((SwitchboardSwitchboardApp*) self);
}

static void
_switchboard_switchboard_app_update_navigation_adw_navigation_view_popped (AdwNavigationView* _sender,
                                                                           AdwNavigationPage* page,
                                                                           gpointer self)
{
	switchboard_switchboard_app_update_navigation ((SwitchboardSwitchboardApp*) self);
}

static void
_switchboard_switchboard_app_update_navigation_adw_navigation_view_pushed (AdwNavigationView* _sender,
                                                                           gpointer self)
{
	switchboard_switchboard_app_update_navigation ((SwitchboardSwitchboardApp*) self);
}

static void
switchboard_switchboard_app_real_activate (GApplication* base)
{
	SwitchboardSwitchboardApp * self;
	SwitchboardPlugsManager* plugsmanager = NULL;
	SwitchboardPlugsManager* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp21_;
	GHashTable* _tmp24_;
	const gchar* _tmp25_;
	SwitchboardCategoryView* _tmp26_;
	AdwNavigationView* _tmp27_ = NULL;
	AdwNavigationView* _tmp28_;
	SwitchboardCategoryView* _tmp29_;
	GtkApplication* _tmp30_;
	AdwNavigationView* _tmp31_;
	GtkWidget* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GtkGrid* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	GtkWindow* _tmp39_;
	GtkWindow* _tmp40_;
	GSettings* settings = NULL;
	GSettings* _tmp41_;
	GSettings* _tmp42_;
	GtkWindow* _tmp43_;
	GSettings* _tmp44_;
	GtkWindow* _tmp45_;
	GSettings* _tmp46_;
	GSettings* _tmp48_;
	GtkWindow* _tmp49_;
	AdwNavigationView* _tmp50_;
	AdwNavigationView* _tmp51_;
	self = (SwitchboardSwitchboardApp*) base;
	_tmp0_ = switchboard_plugs_manager_get_default ();
	plugsmanager = _tmp0_;
	_tmp1_ = switchboard_switchboard_app_link;
	if (_tmp1_ != NULL) {
		gboolean plug_found = FALSE;
		const gchar* _tmp2_;
		SwitchboardPlugsManager* _tmp3_;
		_tmp2_ = switchboard_switchboard_app_link;
		_tmp3_ = plugsmanager;
		plug_found = switchboard_switchboard_app_load_setting_path (self, _tmp2_, _tmp3_);
		if (plug_found) {
			_g_free0 (switchboard_switchboard_app_link);
			switchboard_switchboard_app_link = NULL;
			switchboard_switchboard_app_opened_directly = TRUE;
		} else {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = switchboard_switchboard_app_link;
			_tmp5_ = g_strdup_printf (_ ("Specified link '%s' does not exist, going back to the main panel"), _tmp4_);
			_tmp6_ = _tmp5_;
			g_warning ("Application.vala:113: %s", _tmp6_);
			_g_free0 (_tmp6_);
		}
	} else {
		const gchar* _tmp7_;
		_tmp7_ = switchboard_switchboard_app_plug_to_open;
		if (_tmp7_ != NULL) {
			{
				GeeIterator* _plug_it = NULL;
				SwitchboardPlugsManager* _tmp8_;
				GeeCollection* _tmp9_;
				GeeCollection* _tmp10_;
				GeeIterator* _tmp11_;
				GeeIterator* _tmp12_;
				_tmp8_ = plugsmanager;
				_tmp9_ = switchboard_plugs_manager_get_plugs (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp10_);
				_plug_it = _tmp12_;
				while (TRUE) {
					GeeIterator* _tmp13_;
					SwitchboardPlug* plug = NULL;
					GeeIterator* _tmp14_;
					gpointer _tmp15_;
					const gchar* _tmp16_;
					SwitchboardPlug* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp13_ = _plug_it;
					if (!gee_iterator_next (_tmp13_)) {
						break;
					}
					_tmp14_ = _plug_it;
					_tmp15_ = gee_iterator_get (_tmp14_);
					plug = (SwitchboardPlug*) _tmp15_;
					_tmp16_ = switchboard_switchboard_app_plug_to_open;
					_tmp17_ = plug;
					_tmp18_ = switchboard_plug_get_code_name (_tmp17_);
					_tmp19_ = _tmp18_;
					if (g_str_has_suffix (_tmp16_, _tmp19_)) {
						SwitchboardPlug* _tmp20_;
						_tmp20_ = plug;
						switchboard_switchboard_app_load_plug (self, _tmp20_);
						_g_free0 (switchboard_switchboard_app_plug_to_open);
						switchboard_switchboard_app_plug_to_open = NULL;
						switchboard_switchboard_app_opened_directly = TRUE;
						_g_object_unref0 (plug);
						break;
					}
					_g_object_unref0 (plug);
				}
				_g_object_unref0 (_plug_it);
			}
		}
	}
	_tmp21_ = gtk_application_get_windows ((GtkApplication*) self);
	if (g_list_length (_tmp21_) > ((guint) 0)) {
		GList* _tmp22_;
		gconstpointer _tmp23_;
		_tmp22_ = gtk_application_get_windows ((GtkApplication*) self);
		_tmp23_ = _tmp22_->data;
		gtk_window_present ((GtkWindow*) _tmp23_);
		_g_object_unref0 (plugsmanager);
		return;
	}
	_tmp24_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->plug_widgets);
	self->priv->plug_widgets = _tmp24_;
	_tmp25_ = switchboard_switchboard_app_plug_to_open;
	_tmp26_ = switchboard_category_view_new (_tmp25_);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->category_view);
	self->priv->category_view = _tmp26_;
	_tmp27_ = (AdwNavigationView*) adw_navigation_view_new ();
	adw_navigation_view_set_pop_on_escape (_tmp27_, FALSE);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->navigation_view);
	self->priv->navigation_view = _tmp27_;
	_tmp28_ = self->priv->navigation_view;
	_tmp29_ = self->priv->category_view;
	adw_navigation_view_add (_tmp28_, (AdwNavigationPage*) _tmp29_);
	_tmp30_ = _g_object_ref0 ((GtkApplication*) self);
	_tmp31_ = self->priv->navigation_view;
	_tmp32_ = _g_object_ref0 ((GtkWidget*) _tmp31_);
	_tmp33_ = g_application_get_application_id ((GApplication*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strdup (_tmp34_);
	_tmp36_ = g_strdup (_ ("System Settings"));
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp37_, FALSE);
	g_object_ref_sink (_tmp37_);
	_tmp38_ = (GtkWindow*) gtk_window_new ();
	gtk_window_set_application (_tmp38_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	gtk_window_set_child (_tmp38_, _tmp32_);
	_g_object_unref0 (_tmp32_);
	g_object_set ((GtkWidget*) _tmp38_, "height-request", 500, NULL);
	gtk_window_set_icon_name (_tmp38_, _tmp35_);
	_g_free0 (_tmp35_);
	gtk_window_set_title (_tmp38_, _tmp36_);
	_g_free0 (_tmp36_);
	gtk_window_set_titlebar (_tmp38_, (GtkWidget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp38_;
	_tmp39_ = self->priv->main_window;
	gtk_application_add_window ((GtkApplication*) self, _tmp39_);
	_tmp40_ = self->priv->main_window;
	gtk_window_present (_tmp40_);
	_tmp41_ = g_settings_new ("io.elementary.settings");
	settings = _tmp41_;
	_tmp42_ = settings;
	_tmp43_ = self->priv->main_window;
	g_settings_bind (_tmp42_, "window-height", (GObject*) _tmp43_, "default-height", G_SETTINGS_BIND_DEFAULT);
	_tmp44_ = settings;
	_tmp45_ = self->priv->main_window;
	g_settings_bind (_tmp44_, "window-width", (GObject*) _tmp45_, "default-width", G_SETTINGS_BIND_DEFAULT);
	_tmp46_ = settings;
	if (g_settings_get_boolean (_tmp46_, "window-maximized")) {
		GtkWindow* _tmp47_;
		_tmp47_ = self->priv->main_window;
		gtk_window_maximize (_tmp47_);
	}
	_tmp48_ = settings;
	_tmp49_ = self->priv->main_window;
	g_settings_bind (_tmp48_, "window-maximized", (GObject*) _tmp49_, "maximized", G_SETTINGS_BIND_SET);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) ___lambda17__g_application_shutdown, self, 0);
	_tmp50_ = self->priv->navigation_view;
	g_signal_connect_object (_tmp50_, "popped", (GCallback) _switchboard_switchboard_app_update_navigation_adw_navigation_view_popped, self, 0);
	_tmp51_ = self->priv->navigation_view;
	g_signal_connect_object (_tmp51_, "pushed", (GCallback) _switchboard_switchboard_app_update_navigation_adw_navigation_view_pushed, self, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (plugsmanager);
}

static void
switchboard_switchboard_app_update_navigation (SwitchboardSwitchboardApp* self)
{
	GtkWindow* _tmp0_;
	AdwNavigationView* _tmp1_;
	AdwNavigationPage* _tmp2_;
	AdwNavigationPage* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->navigation_view;
	_tmp2_ = adw_navigation_view_get_visible_page (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = adw_navigation_page_get_title (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_window_set_title (_tmp0_, _tmp5_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwitchboardSwitchboardApp* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->plug);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_switchboard_plug_hidden_adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                                     gpointer self)
{
	switchboard_plug_hidden ((SwitchboardPlug*) self);
}

static void
_switchboard_plug_shown_adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                   gpointer self)
{
	switchboard_plug_shown ((SwitchboardPlug*) self);
}

static gboolean
__lambda9_ (Block2Data* _data2_,
            SwitchboardSearchEntry* entry)
{
	SwitchboardSwitchboardApp* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = switchboard_plug_get_display_name (_data2_->plug);
	_tmp1_ = _tmp0_;
	_tmp2_ = (*entry).plug_name;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		const gchar* _tmp3_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = (*entry).open_window;
		if (_tmp3_ == NULL) {
			switchboard_plug_search_callback (_data2_->plug, "");
		} else {
			const gchar* _tmp4_;
			_tmp4_ = (*entry).open_window;
			switchboard_plug_search_callback (_data2_->plug, _tmp4_);
		}
		_tmp5_ = (*entry).open_window;
		_tmp6_ = switchboard_plug_get_display_name (_data2_->plug);
		_tmp7_ = _tmp6_;
		g_debug ("Application.vala:203: open section:%s of plug: %s", _tmp5_, _tmp7_);
		result = TRUE;
		_switchboard_search_entry_free0 (entry);
		return result;
	}
	result = FALSE;
	_switchboard_search_entry_free0 (entry);
	return result;
}

static gboolean
___lambda9__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, (SwitchboardSearchEntry*) g);
	return result;
}

static gboolean
__lambda8_ (Block2Data* _data2_)
{
	SwitchboardSwitchboardApp* self;
	GtkWidget* plug_widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GHashTable* _tmp12_;
	GtkWidget* _tmp13_;
	gconstpointer _tmp14_;
	SwitchboardCategoryView* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	const gchar* _tmp22_;
	AdwNavigationView* _tmp29_;
	GtkWidget* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	GtkWidget* _tmp33_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = switchboard_plug_get_widget (_data2_->plug);
	plug_widget = _tmp0_;
	_tmp1_ = plug_widget;
	_tmp2_ = gtk_widget_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		AdwNavigationPage* navigation_page = NULL;
		GtkWidget* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		AdwNavigationPage* _tmp7_;
		AdwNavigationPage* _tmp8_;
		AdwNavigationPage* _tmp9_;
		AdwNavigationView* _tmp10_;
		AdwNavigationPage* _tmp11_;
		_tmp4_ = plug_widget;
		_tmp5_ = switchboard_plug_get_display_name (_data2_->plug);
		_tmp6_ = _tmp5_;
		_tmp7_ = adw_navigation_page_new (_tmp4_, _tmp6_);
		g_object_ref_sink (_tmp7_);
		navigation_page = _tmp7_;
		_tmp8_ = navigation_page;
		g_signal_connect_object (_tmp8_, "hidden", (GCallback) _switchboard_plug_hidden_adw_navigation_page_hidden, _data2_->plug, 0);
		_tmp9_ = navigation_page;
		g_signal_connect_object (_tmp9_, "shown", (GCallback) _switchboard_plug_shown_adw_navigation_page_shown, _data2_->plug, 0);
		_tmp10_ = self->priv->navigation_view;
		_tmp11_ = navigation_page;
		adw_navigation_view_add (_tmp10_, _tmp11_);
		_g_object_unref0 (navigation_page);
	}
	_tmp12_ = self->priv->plug_widgets;
	_tmp13_ = plug_widget;
	_tmp14_ = g_hash_table_lookup (_tmp12_, _tmp13_);
	if (((SwitchboardPlug*) _tmp14_) == NULL) {
		GHashTable* _tmp15_;
		GtkWidget* _tmp16_;
		GtkWidget* _tmp17_;
		SwitchboardPlug* _tmp18_;
		_tmp15_ = self->priv->plug_widgets;
		_tmp16_ = plug_widget;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_tmp18_ = _g_object_ref0 (_data2_->plug);
		g_hash_table_insert (_tmp15_, _tmp17_, _tmp18_);
	}
	_tmp19_ = self->priv->category_view;
	_tmp20_ = switchboard_category_view_get_plug_search_result (_tmp19_);
	_tmp21_ = _tmp20_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp21_, ___lambda9__gee_forall_func, _data2_);
	_tmp22_ = switchboard_switchboard_app_open_window;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		_tmp23_ = switchboard_switchboard_app_open_window;
		switchboard_plug_search_callback (_data2_->plug, _tmp23_);
		_g_free0 (switchboard_switchboard_app_open_window);
		switchboard_switchboard_app_open_window = NULL;
	}
	if (switchboard_switchboard_app_opened_directly) {
		AdwNavigationView* _tmp24_;
		_tmp24_ = self->priv->navigation_view;
		adw_navigation_view_set_animate_transitions (_tmp24_, FALSE);
		switchboard_switchboard_app_opened_directly = FALSE;
	} else {
		AdwNavigationView* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp25_ = self->priv->navigation_view;
		_tmp26_ = adw_navigation_view_get_animate_transitions (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == FALSE) {
			AdwNavigationView* _tmp28_;
			_tmp28_ = self->priv->navigation_view;
			adw_navigation_view_set_animate_transitions (_tmp28_, TRUE);
		}
	}
	_tmp29_ = self->priv->navigation_view;
	_tmp30_ = switchboard_plug_get_widget (_data2_->plug);
	_tmp31_ = _tmp30_;
	_tmp32_ = gtk_widget_get_parent (_tmp31_);
	_tmp33_ = _tmp32_;
	adw_navigation_view_push (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, adw_navigation_page_get_type (), AdwNavigationPage));
	_g_object_unref0 (_tmp31_);
	result = FALSE;
	_g_object_unref0 (plug_widget);
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ (self);
	return result;
}

void
switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                       SwitchboardPlug* plug)
{
	Block2Data* _data2_;
	SwitchboardPlug* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plug != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (plug);
	_g_object_unref0 (_data2_->plug);
	_data2_->plug = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
switchboard_switchboard_app_action_navigate_back (SwitchboardSwitchboardApp* self)
{
	AdwNavigationView* _tmp0_;
	AdwNavigationView* _tmp1_;
	AdwNavigationPage* _tmp2_;
	AdwNavigationPage* _tmp3_;
	AdwNavigationPage* _tmp4_;
	SwitchboardCategoryView* _tmp5_;
	AdwNavigationView* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = self->priv->navigation_view;
	_tmp2_ = adw_navigation_view_get_visible_page (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = adw_navigation_view_get_previous_page (_tmp0_, _tmp3_);
	_tmp5_ = self->priv->category_view;
	if (_tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, adw_navigation_page_get_type (), AdwNavigationPage)) {
		AdwNavigationView* _tmp6_;
		switchboard_switchboard_app_opened_directly = FALSE;
		_tmp6_ = self->priv->navigation_view;
		adw_navigation_view_set_animate_transitions (_tmp6_, TRUE);
	}
	_tmp7_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp7_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
switchboard_switchboard_app_load_setting_path (SwitchboardSwitchboardApp* self,
                                               const gchar* setting_path,
                                               SwitchboardPlugsManager* plugsmanager)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (setting_path != NULL, FALSE);
	g_return_val_if_fail (plugsmanager != NULL, FALSE);
	{
		GeeIterator* _plug_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = switchboard_plugs_manager_get_plugs (plugsmanager);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_plug_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			SwitchboardPlug* plug = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeTreeMap* supported_settings = NULL;
			SwitchboardPlug* _tmp7_;
			GeeTreeMap* _tmp8_;
			GeeTreeMap* _tmp9_;
			GeeTreeMap* _tmp10_;
			GeeTreeMap* _tmp11_;
			GeeTreeMap* _tmp12_;
			_tmp4_ = _plug_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _plug_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			plug = (SwitchboardPlug*) _tmp6_;
			_tmp7_ = plug;
			_tmp8_ = switchboard_plug_get_supported_settings (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			supported_settings = _tmp10_;
			_tmp11_ = supported_settings;
			if (_tmp11_ == NULL) {
				_g_object_unref0 (supported_settings);
				_g_object_unref0 (plug);
				continue;
			}
			_tmp12_ = supported_settings;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, setting_path)) {
				SwitchboardPlug* _tmp13_;
				GeeTreeMap* _tmp14_;
				gpointer _tmp15_;
				_tmp13_ = plug;
				switchboard_switchboard_app_load_plug (self, _tmp13_);
				_tmp14_ = supported_settings;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, setting_path);
				_g_free0 (switchboard_switchboard_app_open_window);
				switchboard_switchboard_app_open_window = (gchar*) _tmp15_;
				result = TRUE;
				_g_object_unref0 (supported_settings);
				_g_object_unref0 (plug);
				_g_object_unref0 (_plug_it);
				return result;
			}
			_g_object_unref0 (supported_settings);
			_g_object_unref0 (plug);
		}
		_g_object_unref0 (_plug_it);
	}
	if (string_contains (setting_path, "/")) {
		gint last_index = 0;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_;
		last_index = string_last_index_of_char (setting_path, (gunichar) '/', 0);
		_tmp16_ = string_substring (setting_path, (glong) 0, (glong) last_index);
		_tmp17_ = _tmp16_;
		_tmp18_ = switchboard_switchboard_app_load_setting_path (self, _tmp17_, plugsmanager);
		_g_free0 (_tmp17_);
		result = _tmp18_;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
switchboard_switchboard_app_main (gchar** args,
                                  gint args_length1)
{
	SwitchboardSwitchboardApp* app = NULL;
	SwitchboardSwitchboardApp* _tmp0_;
	gint result;
	_tmp0_ = switchboard_switchboard_app_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return switchboard_switchboard_app_main (argv, argc);
}

SwitchboardSwitchboardApp*
switchboard_switchboard_app_construct (GType object_type)
{
	SwitchboardSwitchboardApp * self = NULL;
	self = (SwitchboardSwitchboardApp*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardSwitchboardApp*
switchboard_switchboard_app_new (void)
{
	return switchboard_switchboard_app_construct (SWITCHBOARD_TYPE_SWITCHBOARD_APP);
}

static GObject *
switchboard_switchboard_app_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardSwitchboardApp * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	GAppInfo* _tmp2_;
	GAppInfo* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (switchboard_switchboard_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	g_application_set_application_id ((GApplication*) self, "io.elementary.settings");
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_OPEN);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp2_ = g_app_info_get_default_for_uri_scheme ("settings");
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GDesktopAppInfo* appinfo = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		_tmp5_ = g_application_get_application_id ((GApplication*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, ".desktop", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_desktop_app_info_new (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		appinfo = _tmp10_;
		{
			GDesktopAppInfo* _tmp11_;
			_tmp11_ = appinfo;
			g_app_info_set_as_default_for_type ((GAppInfo*) _tmp11_, "x-scheme-handler/settings", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_critical ("Application.vala:48: Unable to set default for the settings scheme: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_g_object_unref0 (appinfo);
	}
	return obj;
}

static void
switchboard_switchboard_app_class_init (SwitchboardSwitchboardAppClass * klass,
                                        gpointer klass_data)
{
	switchboard_switchboard_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardSwitchboardApp_private_offset);
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) switchboard_switchboard_app_real_open;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) switchboard_switchboard_app_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) switchboard_switchboard_app_real_activate;
	G_OBJECT_CLASS (klass)->constructor = switchboard_switchboard_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_switchboard_app_finalize;
}

static void
switchboard_switchboard_app_instance_init (SwitchboardSwitchboardApp * self,
                                           gpointer klass)
{
	self->priv = switchboard_switchboard_app_get_instance_private (self);
}

static void
switchboard_switchboard_app_finalize (GObject * obj)
{
	SwitchboardSwitchboardApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
	_g_hash_table_unref0 (self->priv->plug_widgets);
	_g_object_unref0 (self->priv->navigation_view);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->category_view);
	G_OBJECT_CLASS (switchboard_switchboard_app_parent_class)->finalize (obj);
}

static GType
switchboard_switchboard_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardSwitchboardAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_switchboard_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardSwitchboardApp), 0, (GInstanceInitFunc) switchboard_switchboard_app_instance_init, NULL };
	GType switchboard_switchboard_app_type_id;
	switchboard_switchboard_app_type_id = g_type_register_static (gtk_application_get_type (), "SwitchboardSwitchboardApp", &g_define_type_info, 0);
	SwitchboardSwitchboardApp_private_offset = g_type_add_instance_private (switchboard_switchboard_app_type_id, sizeof (SwitchboardSwitchboardAppPrivate));
	return switchboard_switchboard_app_type_id;
}

GType
switchboard_switchboard_app_get_type (void)
{
	static volatile gsize switchboard_switchboard_app_type_id__once = 0;
	if (g_once_init_enter (&switchboard_switchboard_app_type_id__once)) {
		GType switchboard_switchboard_app_type_id;
		switchboard_switchboard_app_type_id = switchboard_switchboard_app_get_type_once ();
		g_once_init_leave (&switchboard_switchboard_app_type_id__once, switchboard_switchboard_app_type_id);
	}
	return switchboard_switchboard_app_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

