// 

/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

#include <Inventor/Qt/engines/SoGuiRadioGroup.h>
#include <cassert>

SO_ENGINE_SOURCE(SoGuiRadioGroup);

void
SoGuiRadioGroup::initClass(void)
{
  SO_ENGINE_INIT_CLASS(SoGuiRadioGroup, SoEngine, "Engine");
}

SoGuiRadioGroup::SoGuiRadioGroup(void)
{
  this->index = -1;

  SO_ENGINE_CONSTRUCTOR(SoGuiRadioGroup);

  SO_ENGINE_ADD_INPUT(in0, (FALSE));
  SO_ENGINE_ADD_INPUT(in1, (FALSE));
  SO_ENGINE_ADD_INPUT(in2, (FALSE));
  SO_ENGINE_ADD_INPUT(in3, (FALSE));
  SO_ENGINE_ADD_INPUT(in4, (FALSE));
  SO_ENGINE_ADD_INPUT(in5, (FALSE));
  SO_ENGINE_ADD_INPUT(in6, (FALSE));
  SO_ENGINE_ADD_INPUT(in7, (FALSE));

  SO_ENGINE_ADD_OUTPUT(out0, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out1, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out2, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out3, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out4, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out5, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out6, SoSFBool);
  SO_ENGINE_ADD_OUTPUT(out7, SoSFBool);
}

SoGuiRadioGroup::~SoGuiRadioGroup(void)
{
}

void
SoGuiRadioGroup::inputChanged(SoField * which)
{
  SoSFBool * fields[] = {
    &(this->in0),
    &(this->in1),
    &(this->in2),
    &(this->in3),
    &(this->in4),
    &(this->in5),
    &(this->in6),
    &(this->in7),
    NULL
  };
  int i;
  for ( i = 0; which != fields[i] && fields[i] != NULL; i++ ) { }
  assert(fields[i] != NULL );
  if ( ((SoSFBool *)which)->getValue() != FALSE ) {
    this->index = i;
  } else {
    if ( this->index == i ) this->index = -1;
  }
}

void
SoGuiRadioGroup::evaluate(void)
{
  if ( this->index == -1 ) return; // avoid update
  SoSFBool * fields[] = {
    &(this->in0), &(this->in1), &(this->in2), &(this->in3),
    &(this->in4), &(this->in5), &(this->in6), &(this->in7),
    NULL
  };
  SoEngineOutput * outputs[] = {
    &(this->out0), &(this->out1), &(this->out2), &(this->out3),
    &(this->out4), &(this->out5), &(this->out6), &(this->out7),
    NULL
  };
  int i;
  for ( i = 0; i < 8; i++ ) {
    if ( i == this->index ) {
      SO_ENGINE_OUTPUT((*outputs[i]), SoSFBool, setValue(TRUE));
    } else {
      SO_ENGINE_OUTPUT((*outputs[i]), SoSFBool, setValue(FALSE));
    }
  }
}

