/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_initshutdown.h"
#include "bin/default/librpc/gen_ndr/ndr_initshutdown_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* initshutdown - dcerpc server boilerplate generated by pidl */
static NTSTATUS initshutdown__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_INITSHUTDOWN_BIND
	return DCESRV_INTERFACE_INITSHUTDOWN_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void initshutdown__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_INITSHUTDOWN_UNBIND
	DCESRV_INTERFACE_INITSHUTDOWN_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS initshutdown__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_initshutdown.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_initshutdown.calls[opnum].struct_size, "struct %s", ndr_table_initshutdown.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_initshutdown.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS initshutdown__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* initshutdown_Init */
		struct initshutdown_Init *r2 = (struct initshutdown_Init *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_Init, NDR_IN, r2);
		}
		r2->out.result = _initshutdown_Init(p, r2);
		break;
	}
	case 1: { /* initshutdown_Abort */
		struct initshutdown_Abort *r2 = (struct initshutdown_Abort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_Abort, NDR_IN, r2);
		}
		r2->out.result = _initshutdown_Abort(p, r2);
		break;
	}
	case 2: { /* initshutdown_InitEx */
		struct initshutdown_InitEx *r2 = (struct initshutdown_InitEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_InitEx, NDR_IN, r2);
		}
		r2->out.result = _initshutdown_InitEx(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS initshutdown__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return initshutdown__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS initshutdown__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* initshutdown_Init */
		struct initshutdown_Init *r2 = (struct initshutdown_Init *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function initshutdown_Init replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_Init, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in initshutdown_Init\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* initshutdown_Abort */
		struct initshutdown_Abort *r2 = (struct initshutdown_Abort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function initshutdown_Abort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_Abort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in initshutdown_Abort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* initshutdown_InitEx */
		struct initshutdown_InitEx *r2 = (struct initshutdown_InitEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function initshutdown_InitEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(initshutdown_InitEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in initshutdown_InitEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS initshutdown__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_initshutdown.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS initshutdown__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return initshutdown__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_initshutdown_interface = {
	.name      = "initshutdown",
	.syntax_id = {{0x894de0c0,0x0d55,0x11d3,{0xa3,0x22},{0x00,0xc0,0x4f,0xa3,0x21,0xa1}},1.0},
	.bind      = initshutdown__op_bind,
	.unbind    = initshutdown__op_unbind,
	.ndr_pull  = initshutdown__op_ndr_pull,
	.dispatch  = initshutdown__op_dispatch,
	.reply     = initshutdown__op_reply,
	.ndr_push  = initshutdown__op_ndr_push,
	.local     = initshutdown__op_local,
#ifdef DCESRV_INTERFACE_INITSHUTDOWN_FLAGS
	.flags     = DCESRV_INTERFACE_INITSHUTDOWN_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS initshutdown__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_INITSHUTDOWN_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_INITSHUTDOWN_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_initshutdown.endpoints->count;i++) {
		const char *name = ndr_table_initshutdown.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_initshutdown_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS initshutdown__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool initshutdown__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_initshutdown_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_initshutdown_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_initshutdown_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool initshutdown__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_initshutdown_interface.name, name)==0) {
		memcpy(iface, &dcesrv_initshutdown_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server initshutdown_ep_server = {
	/* fill in our name */
	.name = "initshutdown",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_INITSHUTDOWN_INIT_SERVER
	.init_server = DCESRV_INTERFACE_INITSHUTDOWN_INIT_SERVER,
#else
	.init_server = initshutdown__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_INITSHUTDOWN_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_INITSHUTDOWN_SHUTDOWN_SERVER,
#else
	.shutdown_server = initshutdown__op_shutdown_server,
#endif
	.interface_by_uuid = initshutdown__op_interface_by_uuid,
	.interface_by_name = initshutdown__op_interface_by_name
};

const struct dcesrv_endpoint_server *initshutdown_get_ep_server(void)
{
	return &initshutdown_ep_server;
}
