
#line 1 "src/internal_modules/roc_address/io_uri_parse.rl"
/*
 * Copyright (c) 2019 Roc Streaming authors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "roc_address/io_uri.h"
#include "roc_core/log.h"
#include "roc_core/panic.h"

namespace roc {
namespace address {


#line 20 "build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/internal_modules/roc_address/io_uri_parse.cpp"
static const char _parse_io_uri_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 2, 
	3, 4
};

static const char _parse_io_uri_key_offsets[] = {
	0, 0, 7, 14, 15, 16, 18, 26, 
	34, 42, 49, 50, 53, 56, 59, 60, 
	61, 62, 63, 64, 65, 66, 67, 68, 
	70
};

static const char _parse_io_uri_trans_keys[] = {
	102, 48, 57, 65, 90, 97, 122, 58, 
	48, 57, 65, 90, 97, 122, 47, 47, 
	35, 63, 58, 105, 48, 57, 65, 90, 
	97, 122, 58, 108, 48, 57, 65, 90, 
	97, 122, 58, 101, 48, 57, 65, 90, 
	97, 122, 58, 48, 57, 65, 90, 97, 
	122, 47, 35, 47, 63, 45, 47, 108, 
	35, 47, 63, 111, 99, 97, 108, 104, 
	111, 115, 116, 47, 35, 63, 0
};

static const char _parse_io_uri_single_lengths[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 
	2, 1, 1, 3, 3, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 
	0
};

static const char _parse_io_uri_range_lengths[] = {
	0, 3, 3, 0, 0, 0, 3, 3, 
	3, 3, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const char _parse_io_uri_index_offsets[] = {
	0, 0, 5, 10, 12, 14, 17, 23, 
	29, 35, 40, 42, 46, 50, 54, 56, 
	58, 60, 62, 64, 66, 68, 70, 72, 
	75
};

static const char _parse_io_uri_indicies[] = {
	2, 0, 0, 0, 1, 4, 3, 3, 
	3, 1, 5, 1, 6, 1, 1, 1, 
	7, 4, 8, 3, 3, 3, 1, 4, 
	9, 3, 3, 3, 1, 4, 10, 3, 
	3, 3, 1, 11, 3, 3, 3, 1, 
	12, 7, 1, 14, 1, 13, 15, 16, 
	17, 1, 1, 1, 1, 13, 18, 1, 
	19, 1, 20, 1, 21, 1, 22, 1, 
	23, 1, 24, 1, 25, 1, 16, 1, 
	1, 1, 13, 1, 0
};

static const char _parse_io_uri_trans_targs[] = {
	2, 0, 6, 2, 3, 4, 5, 23, 
	7, 8, 9, 10, 11, 23, 12, 24, 
	13, 14, 15, 16, 17, 18, 19, 20, 
	21, 22
};

static const char _parse_io_uri_trans_actions[] = {
	1, 0, 1, 0, 3, 0, 0, 1, 
	0, 0, 0, 5, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const char _parse_io_uri_eof_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 7, 
	7
};

static const int parse_io_uri_start = 1;
static const int parse_io_uri_first_final = 23;
static const int parse_io_uri_error = 0;

static const int parse_io_uri_en_main = 1;


#line 19 "src/internal_modules/roc_address/io_uri_parse.rl"


namespace {

bool parse_io_uri_imp(const char* str, IoUri& result) {
    if (!str) {
        roc_log(LogError, "parse io uri: input string is null");
        return false;
    }

    result.clear();

    // for ragel
    const char* p = str;
    const char *pe = str + strlen(str);

    const char *eof = pe;
    int cs = 0;

    // for start_token
    const char* start_p = NULL;

    // parse result
    bool success = false;

    
#line 134 "build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/internal_modules/roc_address/io_uri_parse.cpp"
	{
	cs = parse_io_uri_start;
	}

#line 139 "build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/internal_modules/roc_address/io_uri_parse.cpp"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _parse_io_uri_trans_keys + _parse_io_uri_key_offsets[cs];
	_trans = _parse_io_uri_index_offsets[cs];

	_klen = _parse_io_uri_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _parse_io_uri_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _parse_io_uri_indicies[_trans];
	cs = _parse_io_uri_trans_targs[_trans];

	if ( _parse_io_uri_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _parse_io_uri_actions + _parse_io_uri_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 45 "src/internal_modules/roc_address/io_uri_parse.rl"
	{
            start_p = p;
        }
	break;
	case 1:
#line 49 "src/internal_modules/roc_address/io_uri_parse.rl"
	{
            if (!result.set_scheme(start_p, p - start_p)) {
                roc_log(LogError, "parse io uri: invalid scheme");
                return false;
            }
        }
	break;
	case 2:
#line 56 "src/internal_modules/roc_address/io_uri_parse.rl"
	{
            const char* scheme = "file";

            if (!result.set_scheme(scheme, strlen(scheme))) {
                roc_log(LogError, "parse io uri: invalid scheme");
                return false;
            }
        }
	break;
#line 239 "build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/internal_modules/roc_address/io_uri_parse.cpp"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _parse_io_uri_actions + _parse_io_uri_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 3:
#line 65 "src/internal_modules/roc_address/io_uri_parse.rl"
	{
            if (!result.set_encoded_path(start_p, p - start_p)) {
                roc_log(LogError, "parse io uri: invalid path");
                return false;
            }
        }
	break;
	case 4:
#line 92 "src/internal_modules/roc_address/io_uri_parse.rl"
	{ success = true; }
	break;
#line 268 "build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/internal_modules/roc_address/io_uri_parse.cpp"
		}
	}
	}

	_out: {}
	}

#line 97 "src/internal_modules/roc_address/io_uri_parse.rl"


    if (!success) {
        roc_log(LogError,
                "parse io uri: expected one of:\n"
                " 'DEVICE_TYPE://DEVICE_NAME',\n"
                " 'file:///ABS/PATH',\n"
                " 'file://localhost/ABS/PATH',\n"
                " 'file:/ABS/PATH',\n"
                " 'file:REL/PATH',\n"
                " 'file://-',\n"
                " 'file:-',\n"
                " got '%s'",
                str);
        return false;
    }

    return true;
}

} // namespace

bool parse_io_uri(const char* str, IoUri& result) {
    if (!parse_io_uri_imp(str, result)) {
        result.clear();
        return false;
    }
    return true;
}

} // namespace address
} // namespace roc
