/* PreferencesWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from PreferencesWindow.vala, do not modify */

/**/
/*  Copyright (C) 2014 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "plank-internal.h"
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_PREFERENCES_WINDOW_0_PROPERTY,
	PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY,
	PLANK_PREFERENCES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* plank_preferences_window_properties[PLANK_PREFERENCES_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _PlankPreferencesWindowPrivate {
	PlankDockController* _controller;
	PlankDockPreferences* prefs;
	GtkComboBoxText* cb_theme;
	GtkComboBoxText* cb_hidemode;
	GtkComboBoxText* cb_display_plug;
	GtkComboBoxText* cb_position;
	GtkComboBoxText* cb_alignment;
	GtkComboBoxText* cb_items_alignment;
	GtkSpinButton* sp_hide_delay;
	GtkSpinButton* sp_unhide_delay;
	GtkScale* s_offset;
	GtkScale* s_zoom_percent;
	GtkAdjustment* adj_hide_delay;
	GtkAdjustment* adj_unhide_delay;
	GtkAdjustment* adj_iconsize;
	GtkAdjustment* adj_offset;
	GtkAdjustment* adj_zoom_percent;
	GtkSwitch* sw_hide;
	GtkSwitch* sw_primary_display;
	GtkSwitch* sw_workspace_only;
	GtkSwitch* sw_show_unpinned;
	GtkSwitch* sw_lock_items;
	GtkSwitch* sw_pressure_reveal;
	GtkSwitch* sw_zoom_enabled;
	GtkIconView* view_docklets;
};

static gint PlankPreferencesWindow_private_offset;
static gpointer plank_preferences_window_parent_class = NULL;

static void plank_preferences_window_controller_changed (PlankPreferencesWindow* self);
static void plank_preferences_window_disconnect_signals (PlankPreferencesWindow* self);
static void plank_preferences_window_init_dock_tab (PlankPreferencesWindow* self);
static void plank_preferences_window_connect_signals (PlankPreferencesWindow* self);
static gboolean plank_preferences_window_real_key_press_event (GtkWidget* base,
                                                        GdkEventKey* event);
static void plank_preferences_window_prefs_changed (PlankPreferencesWindow* self,
                                             GObject* o,
                                             GParamSpec* prop);
static void plank_preferences_window_theme_changed (PlankPreferencesWindow* self,
                                             GtkComboBox* widget);
static void plank_preferences_window_hidemode_changed (PlankPreferencesWindow* self,
                                                GtkComboBox* widget);
static void plank_preferences_window_position_changed (PlankPreferencesWindow* self,
                                                GtkComboBox* widget);
static void plank_preferences_window_alignment_changed (PlankPreferencesWindow* self,
                                                 GtkComboBox* widget);
static void plank_preferences_window_items_alignment_changed (PlankPreferencesWindow* self,
                                                       GtkComboBox* widget);
static void plank_preferences_window_hide_toggled (PlankPreferencesWindow* self,
                                            GObject* widget,
                                            GParamSpec* param);
static void plank_preferences_window_primary_display_toggled (PlankPreferencesWindow* self,
                                                       GObject* widget,
                                                       GParamSpec* param);
static void plank_preferences_window_workspace_only_toggled (PlankPreferencesWindow* self,
                                                      GObject* widget,
                                                      GParamSpec* param);
static void plank_preferences_window_show_unpinned_toggled (PlankPreferencesWindow* self,
                                                     GObject* widget,
                                                     GParamSpec* param);
static void plank_preferences_window_lock_items_toggled (PlankPreferencesWindow* self,
                                                  GObject* widget,
                                                  GParamSpec* param);
static void plank_preferences_window_pressure_reveal_toggled (PlankPreferencesWindow* self,
                                                       GObject* widget,
                                                       GParamSpec* param);
static void plank_preferences_window_zoom_enabled_toggled (PlankPreferencesWindow* self,
                                                    GObject* widget,
                                                    GParamSpec* param);
static void plank_preferences_window_iconsize_changed (PlankPreferencesWindow* self,
                                                GtkAdjustment* adj);
static void plank_preferences_window_offset_changed (PlankPreferencesWindow* self,
                                              GtkAdjustment* adj);
static void plank_preferences_window_hide_delay_changed (PlankPreferencesWindow* self,
                                                  GtkAdjustment* adj);
static void plank_preferences_window_unhide_delay_changed (PlankPreferencesWindow* self,
                                                    GtkAdjustment* adj);
static void plank_preferences_window_zoom_percent_changed (PlankPreferencesWindow* self,
                                                    GtkAdjustment* adj);
static void plank_preferences_window_monitor_changed (PlankPreferencesWindow* self,
                                               GtkComboBox* widget);
static void _plank_preferences_window_prefs_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _plank_preferences_window_theme_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                    gpointer self);
static void _plank_preferences_window_hidemode_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self);
static void _plank_preferences_window_position_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self);
static void _plank_preferences_window_hide_delay_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                gpointer self);
static void _plank_preferences_window_unhide_delay_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                  gpointer self);
static void _plank_preferences_window_monitor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self);
static void _plank_preferences_window_iconsize_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                              gpointer self);
static void _plank_preferences_window_offset_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void _plank_preferences_window_zoom_percent_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                  gpointer self);
static void _plank_preferences_window_hide_toggled_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void _plank_preferences_window_primary_display_toggled_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void _plank_preferences_window_workspace_only_toggled_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void _plank_preferences_window_show_unpinned_toggled_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void _plank_preferences_window_lock_items_toggled_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _plank_preferences_window_pressure_reveal_toggled_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void _plank_preferences_window_zoom_enabled_toggled_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _plank_preferences_window_alignment_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self);
static void _plank_preferences_window_items_alignment_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                              gpointer self);
static void plank_preferences_window_init_docklets_tab (PlankPreferencesWindow* self);
static void plank_preferences_window_view_drag_begin (GtkWidget* widget,
                                               GdkDragContext* context,
                                               PlankPreferencesWindow* self);
static void _plank_preferences_window_view_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                      GdkDragContext* context,
                                                                      gpointer self);
static void plank_preferences_window_view_item_activated (GtkIconView* view,
                                                   GtkTreePath* path,
                                                   PlankPreferencesWindow* self);
static void _plank_preferences_window_view_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender,
                                                                                 GtkTreePath* path,
                                                                                 gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static GObject * plank_preferences_window_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _plank_preferences_window_controller_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void plank_preferences_window_finalize (GObject * obj);
static GType plank_preferences_window_get_type_once (void);
static void _vala_plank_preferences_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_plank_preferences_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_preferences_window_get_instance_private (PlankPreferencesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PlankPreferencesWindow_private_offset);
}

PlankPreferencesWindow*
plank_preferences_window_construct (GType object_type,
                                    PlankDockController* controller)
{
	PlankPreferencesWindow * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankPreferencesWindow*) g_object_new (object_type, "controller", controller, NULL);
	return self;
}

PlankPreferencesWindow*
plank_preferences_window_new (PlankDockController* controller)
{
	return plank_preferences_window_construct (PLANK_TYPE_PREFERENCES_WINDOW, controller);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_preferences_window_controller_changed (PlankPreferencesWindow* self)
{
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	g_return_if_fail (self != NULL);
	plank_preferences_window_disconnect_signals (self);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->prefs);
	self->priv->prefs = _tmp3_;
	plank_preferences_window_init_dock_tab (self);
	plank_preferences_window_connect_signals (self);
}

static gboolean
plank_preferences_window_real_key_press_event (GtkWidget* base,
                                               GdkEventKey* event)
{
	PlankPreferencesWindow * self;
	gboolean result;
	self = (PlankPreferencesWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Escape) {
		gtk_widget_hide ((GtkWidget*) self);
	}
	result = GTK_WIDGET_CLASS (plank_preferences_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), event);
	return result;
}

static void
plank_preferences_window_prefs_changed (PlankPreferencesWindow* self,
                                        GObject* o,
                                        GParamSpec* prop)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Alignment")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp4_;
				PlankDockPreferences* _tmp5_;
				GtkAlign _tmp6_;
				GtkAlign _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp4_ = self->priv->cb_alignment;
				_tmp5_ = self->priv->prefs;
				_tmp6_ = plank_dock_preferences_get_Alignment (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup_printf ("%i", (gint) _tmp7_);
				_tmp9_ = _tmp8_;
				gtk_combo_box_set_active_id ((GtkComboBox*) _tmp4_, _tmp9_);
				_g_free0 (_tmp9_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("CurrentWorkspaceOnly")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp10_;
				PlankDockPreferences* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp10_ = self->priv->sw_workspace_only;
				_tmp11_ = self->priv->prefs;
				_tmp12_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp11_);
				_tmp13_ = _tmp12_;
				gtk_switch_set_active (_tmp10_, _tmp13_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("IconSize")))) {
		switch (0) {
			default:
			{
				GtkAdjustment* _tmp14_;
				PlankDockPreferences* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp14_ = self->priv->adj_iconsize;
				_tmp15_ = self->priv->prefs;
				_tmp16_ = plank_dock_preferences_get_IconSize (_tmp15_);
				_tmp17_ = _tmp16_;
				gtk_adjustment_set_value (_tmp14_, (gdouble) _tmp17_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ItemsAlignment")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp18_;
				PlankDockPreferences* _tmp19_;
				GtkAlign _tmp20_;
				GtkAlign _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp18_ = self->priv->cb_items_alignment;
				_tmp19_ = self->priv->prefs;
				_tmp20_ = plank_dock_preferences_get_ItemsAlignment (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%i", (gint) _tmp21_);
				_tmp23_ = _tmp22_;
				gtk_combo_box_set_active_id ((GtkComboBox*) _tmp18_, _tmp23_);
				_g_free0 (_tmp23_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("HideMode")))) {
		switch (0) {
			default:
			{
				gboolean hide_none = FALSE;
				PlankDockPreferences* _tmp24_;
				PlankHideType _tmp25_;
				PlankHideType _tmp26_;
				GtkSwitch* _tmp27_;
				_tmp24_ = self->priv->prefs;
				_tmp25_ = plank_dock_preferences_get_HideMode (_tmp24_);
				_tmp26_ = _tmp25_;
				hide_none = _tmp26_ != PLANK_HIDE_TYPE_NONE;
				_tmp27_ = self->priv->sw_hide;
				gtk_switch_set_active (_tmp27_, hide_none);
				if (!hide_none) {
					GtkComboBoxText* _tmp28_;
					PlankDockPreferences* _tmp29_;
					PlankHideType _tmp30_;
					PlankHideType _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp28_ = self->priv->cb_hidemode;
					_tmp29_ = self->priv->prefs;
					_tmp30_ = plank_dock_preferences_get_HideMode (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strdup_printf ("%i", (gint) _tmp31_);
					_tmp33_ = _tmp32_;
					gtk_combo_box_set_active_id ((GtkComboBox*) _tmp28_, _tmp33_);
					_g_free0 (_tmp33_);
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("LockItems")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp34_;
				PlankDockPreferences* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp34_ = self->priv->sw_lock_items;
				_tmp35_ = self->priv->prefs;
				_tmp36_ = plank_dock_preferences_get_LockItems (_tmp35_);
				_tmp37_ = _tmp36_;
				gtk_switch_set_active (_tmp34_, _tmp37_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("Monitor")))) {
		switch (0) {
			default:
			{
				gint pos = 0;
				GdkScreen* _tmp38_;
				gint _tmp39_ = 0;
				gchar** _tmp40_;
				pos = 0;
				_tmp38_ = gtk_window_get_screen ((GtkWindow*) self);
				_tmp40_ = plank_position_manager_get_monitor_plug_names (_tmp38_, &_tmp39_);
				{
					gchar** plug_name_collection = NULL;
					gint plug_name_collection_length1 = 0;
					gint _plug_name_collection_size_ = 0;
					gint plug_name_it = 0;
					plug_name_collection = _tmp40_;
					plug_name_collection_length1 = _tmp39_;
					for (plug_name_it = 0; plug_name_it < plug_name_collection_length1; plug_name_it = plug_name_it + 1) {
						const gchar* plug_name = NULL;
						plug_name = plug_name_collection[plug_name_it];
						{
							const gchar* _tmp41_;
							PlankDockPreferences* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							gint _tmp46_;
							_tmp41_ = plug_name;
							_tmp42_ = self->priv->prefs;
							_tmp43_ = plank_dock_preferences_get_Monitor (_tmp42_);
							_tmp44_ = _tmp43_;
							if (g_strcmp0 (_tmp41_, _tmp44_) == 0) {
								GtkComboBoxText* _tmp45_;
								_tmp45_ = self->priv->cb_display_plug;
								gtk_combo_box_set_active ((GtkComboBox*) _tmp45_, pos);
							}
							_tmp46_ = pos;
							pos = _tmp46_ + 1;
						}
					}
					plug_name_collection = (_vala_array_free (plug_name_collection, plug_name_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("Offset")))) {
		switch (0) {
			default:
			{
				GtkAdjustment* _tmp47_;
				PlankDockPreferences* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				_tmp47_ = self->priv->adj_offset;
				_tmp48_ = self->priv->prefs;
				_tmp49_ = plank_dock_preferences_get_Offset (_tmp48_);
				_tmp50_ = _tmp49_;
				gtk_adjustment_set_value (_tmp47_, (gdouble) _tmp50_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("PinnedOnly")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp51_;
				PlankDockPreferences* _tmp52_;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp51_ = self->priv->sw_show_unpinned;
				_tmp52_ = self->priv->prefs;
				_tmp53_ = plank_dock_preferences_get_PinnedOnly (_tmp52_);
				_tmp54_ = _tmp53_;
				gtk_switch_set_active (_tmp51_, !_tmp54_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("Position")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp55_;
				PlankDockPreferences* _tmp56_;
				GtkPositionType _tmp57_;
				GtkPositionType _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = self->priv->cb_position;
				_tmp56_ = self->priv->prefs;
				_tmp57_ = plank_dock_preferences_get_Position (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strdup_printf ("%i", (gint) _tmp58_);
				_tmp60_ = _tmp59_;
				gtk_combo_box_set_active_id ((GtkComboBox*) _tmp55_, _tmp60_);
				_g_free0 (_tmp60_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("PressureReveal")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp61_;
				PlankDockPreferences* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				_tmp61_ = self->priv->sw_pressure_reveal;
				_tmp62_ = self->priv->prefs;
				_tmp63_ = plank_dock_preferences_get_PressureReveal (_tmp62_);
				_tmp64_ = _tmp63_;
				gtk_switch_set_active (_tmp61_, _tmp64_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("Theme")))) {
		switch (0) {
			default:
			{
				gint pos = 0;
				gint _tmp65_ = 0;
				gchar** _tmp66_;
				pos = 0;
				_tmp66_ = plank_theme_get_theme_list (&_tmp65_);
				{
					gchar** theme_collection = NULL;
					gint theme_collection_length1 = 0;
					gint _theme_collection_size_ = 0;
					gint theme_it = 0;
					theme_collection = _tmp66_;
					theme_collection_length1 = _tmp65_;
					for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
						const gchar* theme = NULL;
						theme = theme_collection[theme_it];
						{
							const gchar* _tmp67_;
							PlankDockPreferences* _tmp68_;
							const gchar* _tmp69_;
							const gchar* _tmp70_;
							gint _tmp72_;
							_tmp67_ = theme;
							_tmp68_ = self->priv->prefs;
							_tmp69_ = plank_dock_preferences_get_Theme (_tmp68_);
							_tmp70_ = _tmp69_;
							if (g_strcmp0 (_tmp67_, _tmp70_) == 0) {
								GtkComboBoxText* _tmp71_;
								_tmp71_ = self->priv->cb_theme;
								gtk_combo_box_set_active ((GtkComboBox*) _tmp71_, pos);
							}
							_tmp72_ = pos;
							pos = _tmp72_ + 1;
						}
					}
					theme_collection = (_vala_array_free (theme_collection, theme_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("HideDelay")))) {
		switch (0) {
			default:
			{
				GtkAdjustment* _tmp73_;
				PlankDockPreferences* _tmp74_;
				guint _tmp75_;
				guint _tmp76_;
				_tmp73_ = self->priv->adj_hide_delay;
				_tmp74_ = self->priv->prefs;
				_tmp75_ = plank_dock_preferences_get_HideDelay (_tmp74_);
				_tmp76_ = _tmp75_;
				gtk_adjustment_set_value (_tmp73_, (gdouble) _tmp76_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("UnhideDelay")))) {
		switch (0) {
			default:
			{
				GtkAdjustment* _tmp77_;
				PlankDockPreferences* _tmp78_;
				guint _tmp79_;
				guint _tmp80_;
				_tmp77_ = self->priv->adj_unhide_delay;
				_tmp78_ = self->priv->prefs;
				_tmp79_ = plank_dock_preferences_get_UnhideDelay (_tmp78_);
				_tmp80_ = _tmp79_;
				gtk_adjustment_set_value (_tmp77_, (gdouble) _tmp80_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("ZoomEnabled")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp81_;
				PlankDockPreferences* _tmp82_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				_tmp81_ = self->priv->sw_zoom_enabled;
				_tmp82_ = self->priv->prefs;
				_tmp83_ = plank_dock_preferences_get_ZoomEnabled (_tmp82_);
				_tmp84_ = _tmp83_;
				gtk_switch_set_active (_tmp81_, _tmp84_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("ZoomPercent")))) {
		switch (0) {
			default:
			{
				GtkAdjustment* _tmp85_;
				PlankDockPreferences* _tmp86_;
				guint _tmp87_;
				guint _tmp88_;
				_tmp85_ = self->priv->adj_zoom_percent;
				_tmp86_ = self->priv->prefs;
				_tmp87_ = plank_dock_preferences_get_ZoomPercent (_tmp86_);
				_tmp88_ = _tmp87_;
				gtk_adjustment_set_value (_tmp85_, (gdouble) _tmp88_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("DockItems")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp89_;
				_tmp89_ = prop->name;
				g_warning ("PreferencesWindow.vala:187: %s not supported", _tmp89_);
				break;
			}
		}
	}
}

static void
plank_preferences_window_theme_changed (PlankPreferencesWindow* self,
                                        GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_text_get_active_text (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_combo_box_text_get_type (), GtkComboBoxText));
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_Theme (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
plank_preferences_window_hidemode_changed (PlankPreferencesWindow* self,
                                           GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_get_active_id (widget);
	plank_dock_preferences_set_HideMode (_tmp0_, (PlankHideType) atoi (_tmp1_));
}

static void
plank_preferences_window_position_changed (PlankPreferencesWindow* self,
                                           GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_get_active_id (widget);
	plank_dock_preferences_set_Position (_tmp0_, (GtkPositionType) atoi (_tmp1_));
}

static void
plank_preferences_window_alignment_changed (PlankPreferencesWindow* self,
                                            GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	const gchar* _tmp1_;
	GtkComboBoxText* _tmp2_;
	PlankDockPreferences* _tmp3_;
	GtkAlign _tmp4_;
	GtkAlign _tmp5_;
	GtkScale* _tmp6_;
	PlankDockPreferences* _tmp7_;
	GtkAlign _tmp8_;
	GtkAlign _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_get_active_id (widget);
	plank_dock_preferences_set_Alignment (_tmp0_, (GtkAlign) atoi (_tmp1_));
	_tmp2_ = self->priv->cb_items_alignment;
	_tmp3_ = self->priv->prefs;
	_tmp4_ = plank_dock_preferences_get_Alignment (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, _tmp5_ == GTK_ALIGN_FILL);
	_tmp6_ = self->priv->s_offset;
	_tmp7_ = self->priv->prefs;
	_tmp8_ = plank_dock_preferences_get_Alignment (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp9_ == GTK_ALIGN_CENTER);
}

static void
plank_preferences_window_items_alignment_changed (PlankPreferencesWindow* self,
                                                  GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_get_active_id (widget);
	plank_dock_preferences_set_ItemsAlignment (_tmp0_, (GtkAlign) atoi (_tmp1_));
}

static void
plank_preferences_window_hide_toggled (PlankPreferencesWindow* self,
                                       GObject* widget,
                                       GParamSpec* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	if (gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch))) {
		PlankDockPreferences* _tmp0_;
		GtkComboBoxText* _tmp1_;
		GtkSpinButton* _tmp2_;
		GtkSpinButton* _tmp3_;
		GtkSwitch* _tmp4_;
		_tmp0_ = self->priv->prefs;
		plank_dock_preferences_set_HideMode (_tmp0_, PLANK_HIDE_TYPE_INTELLIGENT);
		_tmp1_ = self->priv->cb_hidemode;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
		_tmp2_ = self->priv->sp_hide_delay;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->priv->sp_unhide_delay;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->sw_pressure_reveal;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	} else {
		PlankDockPreferences* _tmp5_;
		GtkComboBoxText* _tmp6_;
		GtkSpinButton* _tmp7_;
		GtkSpinButton* _tmp8_;
		GtkSwitch* _tmp9_;
		_tmp5_ = self->priv->prefs;
		plank_dock_preferences_set_HideMode (_tmp5_, PLANK_HIDE_TYPE_NONE);
		_tmp6_ = self->priv->cb_hidemode;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->sp_hide_delay;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = self->priv->sp_unhide_delay;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = self->priv->sw_pressure_reveal;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
	}
}

static void
plank_preferences_window_primary_display_toggled (PlankPreferencesWindow* self,
                                                  GObject* widget,
                                                  GParamSpec* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	if (gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch))) {
		PlankDockPreferences* _tmp0_;
		GtkComboBoxText* _tmp1_;
		_tmp0_ = self->priv->prefs;
		plank_dock_preferences_set_Monitor (_tmp0_, "");
		_tmp1_ = self->priv->cb_display_plug;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	} else {
		PlankDockPreferences* _tmp2_;
		GtkComboBoxText* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GtkComboBoxText* _tmp6_;
		_tmp2_ = self->priv->prefs;
		_tmp3_ = self->priv->cb_display_plug;
		_tmp4_ = gtk_combo_box_text_get_active_text (_tmp3_);
		_tmp5_ = _tmp4_;
		plank_dock_preferences_set_Monitor (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->cb_display_plug;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
	}
}

static void
plank_preferences_window_workspace_only_toggled (PlankPreferencesWindow* self,
                                                 GObject* widget,
                                                 GParamSpec* param)
{
	PlankDockPreferences* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->prefs;
	plank_dock_preferences_set_CurrentWorkspaceOnly (_tmp0_, gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch)));
}

static void
plank_preferences_window_show_unpinned_toggled (PlankPreferencesWindow* self,
                                                GObject* widget,
                                                GParamSpec* param)
{
	PlankDockPreferences* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->prefs;
	plank_dock_preferences_set_PinnedOnly (_tmp0_, !gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch)));
}

static void
plank_preferences_window_lock_items_toggled (PlankPreferencesWindow* self,
                                             GObject* widget,
                                             GParamSpec* param)
{
	PlankDockPreferences* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->prefs;
	plank_dock_preferences_set_LockItems (_tmp0_, gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch)));
}

static void
plank_preferences_window_pressure_reveal_toggled (PlankPreferencesWindow* self,
                                                  GObject* widget,
                                                  GParamSpec* param)
{
	PlankDockPreferences* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->prefs;
	plank_dock_preferences_set_PressureReveal (_tmp0_, gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch)));
}

static void
plank_preferences_window_zoom_enabled_toggled (PlankPreferencesWindow* self,
                                               GObject* widget,
                                               GParamSpec* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (param != NULL);
	if (gtk_switch_get_active (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_switch_get_type (), GtkSwitch))) {
		PlankDockPreferences* _tmp0_;
		GtkScale* _tmp1_;
		_tmp0_ = self->priv->prefs;
		plank_dock_preferences_set_ZoomEnabled (_tmp0_, TRUE);
		_tmp1_ = self->priv->s_zoom_percent;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	} else {
		PlankDockPreferences* _tmp2_;
		GtkScale* _tmp3_;
		_tmp2_ = self->priv->prefs;
		plank_dock_preferences_set_ZoomEnabled (_tmp2_, FALSE);
		_tmp3_ = self->priv->s_zoom_percent;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	}
}

static void
plank_preferences_window_iconsize_changed (PlankPreferencesWindow* self,
                                           GtkAdjustment* adj)
{
	PlankDockPreferences* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_adjustment_get_value (adj);
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_IconSize (_tmp0_, (gint) _tmp2_);
}

static void
plank_preferences_window_offset_changed (PlankPreferencesWindow* self,
                                         GtkAdjustment* adj)
{
	PlankDockPreferences* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_adjustment_get_value (adj);
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_Offset (_tmp0_, (gint) _tmp2_);
}

static void
plank_preferences_window_hide_delay_changed (PlankPreferencesWindow* self,
                                             GtkAdjustment* adj)
{
	PlankDockPreferences* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_adjustment_get_value (adj);
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_HideDelay (_tmp0_, (guint) ((gint) _tmp2_));
}

static void
plank_preferences_window_unhide_delay_changed (PlankPreferencesWindow* self,
                                               GtkAdjustment* adj)
{
	PlankDockPreferences* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_adjustment_get_value (adj);
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_UnhideDelay (_tmp0_, (guint) ((gint) _tmp2_));
}

static void
plank_preferences_window_zoom_percent_changed (PlankPreferencesWindow* self,
                                               GtkAdjustment* adj)
{
	PlankDockPreferences* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_adjustment_get_value (adj);
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_ZoomPercent (_tmp0_, (guint) ((gint) _tmp2_));
}

static void
plank_preferences_window_monitor_changed (PlankPreferencesWindow* self,
                                          GtkComboBox* widget)
{
	PlankDockPreferences* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->prefs;
	_tmp1_ = gtk_combo_box_text_get_active_text (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_combo_box_text_get_type (), GtkComboBoxText));
	_tmp2_ = _tmp1_;
	plank_dock_preferences_set_Monitor (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_plank_preferences_window_prefs_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	plank_preferences_window_prefs_changed ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_theme_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                               gpointer self)
{
	plank_preferences_window_theme_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_hidemode_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self)
{
	plank_preferences_window_hidemode_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_position_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self)
{
	plank_preferences_window_position_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_hide_delay_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                           gpointer self)
{
	plank_preferences_window_hide_delay_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_unhide_delay_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                             gpointer self)
{
	plank_preferences_window_unhide_delay_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_monitor_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self)
{
	plank_preferences_window_monitor_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_iconsize_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                         gpointer self)
{
	plank_preferences_window_iconsize_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_offset_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
	plank_preferences_window_offset_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_zoom_percent_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                             gpointer self)
{
	plank_preferences_window_zoom_percent_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_hide_toggled_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	plank_preferences_window_hide_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_primary_display_toggled_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	plank_preferences_window_primary_display_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_workspace_only_toggled_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	plank_preferences_window_workspace_only_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_show_unpinned_toggled_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	plank_preferences_window_show_unpinned_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_lock_items_toggled_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	plank_preferences_window_lock_items_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_pressure_reveal_toggled_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	plank_preferences_window_pressure_reveal_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_zoom_enabled_toggled_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	plank_preferences_window_zoom_enabled_toggled ((PlankPreferencesWindow*) self, _sender, pspec);
}

static void
_plank_preferences_window_alignment_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self)
{
	plank_preferences_window_alignment_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
_plank_preferences_window_items_alignment_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                         gpointer self)
{
	plank_preferences_window_items_alignment_changed ((PlankPreferencesWindow*) self, _sender);
}

static void
plank_preferences_window_connect_signals (PlankPreferencesWindow* self)
{
	PlankDockPreferences* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkSwitch* _tmp11_;
	GtkSwitch* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkSwitch* _tmp14_;
	GtkSwitch* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkComboBoxText* _tmp17_;
	GtkComboBoxText* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prefs;
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) _plank_preferences_window_prefs_changed_g_object_notify, self, 0);
	_tmp1_ = self->priv->cb_theme;
	g_signal_connect_object ((GtkComboBox*) _tmp1_, "changed", (GCallback) _plank_preferences_window_theme_changed_gtk_combo_box_changed, self, 0);
	_tmp2_ = self->priv->cb_hidemode;
	g_signal_connect_object ((GtkComboBox*) _tmp2_, "changed", (GCallback) _plank_preferences_window_hidemode_changed_gtk_combo_box_changed, self, 0);
	_tmp3_ = self->priv->cb_position;
	g_signal_connect_object ((GtkComboBox*) _tmp3_, "changed", (GCallback) _plank_preferences_window_position_changed_gtk_combo_box_changed, self, 0);
	_tmp4_ = self->priv->adj_hide_delay;
	g_signal_connect_object (_tmp4_, "value-changed", (GCallback) _plank_preferences_window_hide_delay_changed_gtk_adjustment_value_changed, self, 0);
	_tmp5_ = self->priv->adj_unhide_delay;
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) _plank_preferences_window_unhide_delay_changed_gtk_adjustment_value_changed, self, 0);
	_tmp6_ = self->priv->cb_display_plug;
	g_signal_connect_object ((GtkComboBox*) _tmp6_, "changed", (GCallback) _plank_preferences_window_monitor_changed_gtk_combo_box_changed, self, 0);
	_tmp7_ = self->priv->adj_iconsize;
	g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _plank_preferences_window_iconsize_changed_gtk_adjustment_value_changed, self, 0);
	_tmp8_ = self->priv->adj_offset;
	g_signal_connect_object (_tmp8_, "value-changed", (GCallback) _plank_preferences_window_offset_changed_gtk_adjustment_value_changed, self, 0);
	_tmp9_ = self->priv->adj_zoom_percent;
	g_signal_connect_object (_tmp9_, "value-changed", (GCallback) _plank_preferences_window_zoom_percent_changed_gtk_adjustment_value_changed, self, 0);
	_tmp10_ = self->priv->sw_hide;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::active", (GCallback) _plank_preferences_window_hide_toggled_g_object_notify, self, 0);
	_tmp11_ = self->priv->sw_primary_display;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::active", (GCallback) _plank_preferences_window_primary_display_toggled_g_object_notify, self, 0);
	_tmp12_ = self->priv->sw_workspace_only;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::active", (GCallback) _plank_preferences_window_workspace_only_toggled_g_object_notify, self, 0);
	_tmp13_ = self->priv->sw_show_unpinned;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::active", (GCallback) _plank_preferences_window_show_unpinned_toggled_g_object_notify, self, 0);
	_tmp14_ = self->priv->sw_lock_items;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::active", (GCallback) _plank_preferences_window_lock_items_toggled_g_object_notify, self, 0);
	_tmp15_ = self->priv->sw_pressure_reveal;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::active", (GCallback) _plank_preferences_window_pressure_reveal_toggled_g_object_notify, self, 0);
	_tmp16_ = self->priv->sw_zoom_enabled;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::active", (GCallback) _plank_preferences_window_zoom_enabled_toggled_g_object_notify, self, 0);
	_tmp17_ = self->priv->cb_alignment;
	g_signal_connect_object ((GtkComboBox*) _tmp17_, "changed", (GCallback) _plank_preferences_window_alignment_changed_gtk_combo_box_changed, self, 0);
	_tmp18_ = self->priv->cb_items_alignment;
	g_signal_connect_object ((GtkComboBox*) _tmp18_, "changed", (GCallback) _plank_preferences_window_items_alignment_changed_gtk_combo_box_changed, self, 0);
}

static void
plank_preferences_window_disconnect_signals (PlankPreferencesWindow* self)
{
	PlankDockPreferences* _tmp0_;
	guint _tmp1_;
	GtkComboBoxText* _tmp2_;
	guint _tmp3_;
	GtkComboBoxText* _tmp4_;
	guint _tmp5_;
	GtkComboBoxText* _tmp6_;
	guint _tmp7_;
	GtkAdjustment* _tmp8_;
	guint _tmp9_;
	GtkAdjustment* _tmp10_;
	guint _tmp11_;
	GtkComboBoxText* _tmp12_;
	guint _tmp13_;
	GtkAdjustment* _tmp14_;
	guint _tmp15_;
	GtkAdjustment* _tmp16_;
	guint _tmp17_;
	GtkAdjustment* _tmp18_;
	guint _tmp19_;
	GtkSwitch* _tmp20_;
	guint _tmp21_;
	GQuark _tmp22_;
	GtkSwitch* _tmp23_;
	guint _tmp24_;
	GQuark _tmp25_;
	GtkSwitch* _tmp26_;
	guint _tmp27_;
	GQuark _tmp28_;
	GtkSwitch* _tmp29_;
	guint _tmp30_;
	GQuark _tmp31_;
	GtkSwitch* _tmp32_;
	guint _tmp33_;
	GQuark _tmp34_;
	GtkSwitch* _tmp35_;
	guint _tmp36_;
	GQuark _tmp37_;
	GtkSwitch* _tmp38_;
	guint _tmp39_;
	GQuark _tmp40_;
	GtkComboBoxText* _tmp41_;
	guint _tmp42_;
	GtkComboBoxText* _tmp43_;
	guint _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prefs;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_preferences_window_prefs_changed_g_object_notify, self);
	_tmp2_ = self->priv->cb_theme;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_preferences_window_theme_changed_gtk_combo_box_changed, self);
	_tmp4_ = self->priv->cb_hidemode;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _plank_preferences_window_hidemode_changed_gtk_combo_box_changed, self);
	_tmp6_ = self->priv->cb_position;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _plank_preferences_window_position_changed_gtk_combo_box_changed, self);
	_tmp8_ = self->priv->adj_hide_delay;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _plank_preferences_window_hide_delay_changed_gtk_adjustment_value_changed, self);
	_tmp10_ = self->priv->adj_unhide_delay;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _plank_preferences_window_unhide_delay_changed_gtk_adjustment_value_changed, self);
	_tmp12_ = self->priv->cb_display_plug;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _plank_preferences_window_monitor_changed_gtk_combo_box_changed, self);
	_tmp14_ = self->priv->adj_iconsize;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _plank_preferences_window_iconsize_changed_gtk_adjustment_value_changed, self);
	_tmp16_ = self->priv->adj_offset;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _plank_preferences_window_offset_changed_gtk_adjustment_value_changed, self);
	_tmp18_ = self->priv->adj_zoom_percent;
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _plank_preferences_window_zoom_percent_changed_gtk_adjustment_value_changed, self);
	_tmp20_ = self->priv->sw_hide;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp21_, &_tmp22_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, _tmp22_, NULL, (GCallback) _plank_preferences_window_hide_toggled_g_object_notify, self);
	_tmp23_ = self->priv->sw_primary_display;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp24_, &_tmp25_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, _tmp25_, NULL, (GCallback) _plank_preferences_window_primary_display_toggled_g_object_notify, self);
	_tmp26_ = self->priv->sw_workspace_only;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp27_, &_tmp28_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, _tmp28_, NULL, (GCallback) _plank_preferences_window_workspace_only_toggled_g_object_notify, self);
	_tmp29_ = self->priv->sw_show_unpinned;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp30_, &_tmp31_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp29_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp30_, _tmp31_, NULL, (GCallback) _plank_preferences_window_show_unpinned_toggled_g_object_notify, self);
	_tmp32_ = self->priv->sw_lock_items;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp33_, &_tmp34_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp32_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp33_, _tmp34_, NULL, (GCallback) _plank_preferences_window_lock_items_toggled_g_object_notify, self);
	_tmp35_ = self->priv->sw_pressure_reveal;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp36_, &_tmp37_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp35_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp36_, _tmp37_, NULL, (GCallback) _plank_preferences_window_pressure_reveal_toggled_g_object_notify, self);
	_tmp38_ = self->priv->sw_zoom_enabled;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp39_, &_tmp40_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp38_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp39_, _tmp40_, NULL, (GCallback) _plank_preferences_window_zoom_enabled_toggled_g_object_notify, self);
	_tmp41_ = self->priv->cb_alignment;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp42_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp41_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp42_, 0, NULL, (GCallback) _plank_preferences_window_alignment_changed_gtk_combo_box_changed, self);
	_tmp43_ = self->priv->cb_items_alignment;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp44_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp43_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp44_, 0, NULL, (GCallback) _plank_preferences_window_items_alignment_changed_gtk_combo_box_changed, self);
}

static void
plank_preferences_window_init_dock_tab (PlankPreferencesWindow* self)
{
	gint pos = 0;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	GtkComboBoxText* _tmp13_;
	PlankDockPreferences* _tmp14_;
	PlankHideType _tmp15_;
	PlankHideType _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkComboBoxText* _tmp19_;
	PlankDockPreferences* _tmp20_;
	PlankHideType _tmp21_;
	PlankHideType _tmp22_;
	GtkComboBoxText* _tmp23_;
	PlankDockPreferences* _tmp24_;
	GtkPositionType _tmp25_;
	GtkPositionType _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkAdjustment* _tmp29_;
	PlankDockPreferences* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	GtkAdjustment* _tmp33_;
	PlankDockPreferences* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	GtkComboBoxText* _tmp37_;
	GdkScreen* _tmp38_;
	gint _tmp39_ = 0;
	gchar** _tmp40_;
	PlankDockPreferences* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GtkComboBoxText* _tmp55_;
	PlankDockPreferences* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	GtkSpinButton* _tmp59_;
	PlankDockPreferences* _tmp60_;
	PlankHideType _tmp61_;
	PlankHideType _tmp62_;
	GtkSpinButton* _tmp63_;
	PlankDockPreferences* _tmp64_;
	PlankHideType _tmp65_;
	PlankHideType _tmp66_;
	GtkAdjustment* _tmp67_;
	PlankDockPreferences* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	GtkAdjustment* _tmp71_;
	PlankDockPreferences* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	GtkAdjustment* _tmp75_;
	PlankDockPreferences* _tmp76_;
	guint _tmp77_;
	guint _tmp78_;
	GtkScale* _tmp79_;
	PlankDockPreferences* _tmp80_;
	GtkAlign _tmp81_;
	GtkAlign _tmp82_;
	GtkScale* _tmp83_;
	PlankDockPreferences* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	GtkSwitch* _tmp87_;
	PlankDockPreferences* _tmp88_;
	PlankHideType _tmp89_;
	PlankHideType _tmp90_;
	GtkSwitch* _tmp91_;
	PlankDockPreferences* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp94_;
	GtkSwitch* _tmp95_;
	PlankDockPreferences* _tmp96_;
	gboolean _tmp97_;
	gboolean _tmp98_;
	GtkSwitch* _tmp99_;
	PlankDockPreferences* _tmp100_;
	gboolean _tmp101_;
	gboolean _tmp102_;
	GtkSwitch* _tmp103_;
	PlankDockPreferences* _tmp104_;
	gboolean _tmp105_;
	gboolean _tmp106_;
	GtkSwitch* _tmp107_;
	PlankDockPreferences* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	GtkSwitch* _tmp111_;
	PlankDockPreferences* _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp114_;
	GtkComboBoxText* _tmp115_;
	PlankDockPreferences* _tmp116_;
	GtkAlign _tmp117_;
	GtkAlign _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	GtkComboBoxText* _tmp121_;
	PlankDockPreferences* _tmp122_;
	GtkAlign _tmp123_;
	GtkAlign _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	GtkComboBoxText* _tmp127_;
	PlankDockPreferences* _tmp128_;
	GtkAlign _tmp129_;
	GtkAlign _tmp130_;
	g_return_if_fail (self != NULL);
	pos = 0;
	_tmp0_ = self->priv->cb_theme;
	gtk_combo_box_text_remove_all (_tmp0_);
	_tmp2_ = plank_theme_get_theme_list (&_tmp1_);
	{
		gchar** theme_collection = NULL;
		gint theme_collection_length1 = 0;
		gint _theme_collection_size_ = 0;
		gint theme_it = 0;
		theme_collection = _tmp2_;
		theme_collection_length1 = _tmp1_;
		for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
			const gchar* theme = NULL;
			theme = theme_collection[theme_it];
			{
				GtkComboBoxText* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				PlankDockPreferences* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp12_;
				_tmp3_ = self->priv->cb_theme;
				_tmp4_ = g_strdup_printf ("%i", pos);
				_tmp5_ = _tmp4_;
				_tmp6_ = theme;
				gtk_combo_box_text_append (_tmp3_, _tmp5_, _tmp6_);
				_g_free0 (_tmp5_);
				_tmp7_ = theme;
				_tmp8_ = self->priv->prefs;
				_tmp9_ = plank_dock_preferences_get_Theme (_tmp8_);
				_tmp10_ = _tmp9_;
				if (g_strcmp0 (_tmp7_, _tmp10_) == 0) {
					GtkComboBoxText* _tmp11_;
					_tmp11_ = self->priv->cb_theme;
					gtk_combo_box_set_active ((GtkComboBox*) _tmp11_, pos);
				}
				_tmp12_ = pos;
				pos = _tmp12_ + 1;
			}
		}
		theme_collection = (_vala_array_free (theme_collection, theme_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp13_ = self->priv->cb_hidemode;
	_tmp14_ = self->priv->prefs;
	_tmp15_ = plank_dock_preferences_get_HideMode (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf ("%i", (gint) _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp13_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->cb_hidemode;
	_tmp20_ = self->priv->prefs;
	_tmp21_ = plank_dock_preferences_get_HideMode (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, _tmp22_ != PLANK_HIDE_TYPE_NONE);
	_tmp23_ = self->priv->cb_position;
	_tmp24_ = self->priv->prefs;
	_tmp25_ = plank_dock_preferences_get_Position (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup_printf ("%i", (gint) _tmp26_);
	_tmp28_ = _tmp27_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp23_, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = self->priv->adj_hide_delay;
	_tmp30_ = self->priv->prefs;
	_tmp31_ = plank_dock_preferences_get_HideDelay (_tmp30_);
	_tmp32_ = _tmp31_;
	gtk_adjustment_set_value (_tmp29_, (gdouble) _tmp32_);
	_tmp33_ = self->priv->adj_unhide_delay;
	_tmp34_ = self->priv->prefs;
	_tmp35_ = plank_dock_preferences_get_UnhideDelay (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_adjustment_set_value (_tmp33_, (gdouble) _tmp36_);
	pos = 0;
	_tmp37_ = self->priv->cb_display_plug;
	gtk_combo_box_text_remove_all (_tmp37_);
	_tmp38_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp40_ = plank_position_manager_get_monitor_plug_names (_tmp38_, &_tmp39_);
	{
		gchar** plug_name_collection = NULL;
		gint plug_name_collection_length1 = 0;
		gint _plug_name_collection_size_ = 0;
		gint plug_name_it = 0;
		plug_name_collection = _tmp40_;
		plug_name_collection_length1 = _tmp39_;
		for (plug_name_it = 0; plug_name_it < plug_name_collection_length1; plug_name_it = plug_name_it + 1) {
			const gchar* plug_name = NULL;
			plug_name = plug_name_collection[plug_name_it];
			{
				GtkComboBoxText* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				PlankDockPreferences* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gint _tmp50_;
				_tmp41_ = self->priv->cb_display_plug;
				_tmp42_ = g_strdup_printf ("%i", pos);
				_tmp43_ = _tmp42_;
				_tmp44_ = plug_name;
				gtk_combo_box_text_append (_tmp41_, _tmp43_, _tmp44_);
				_g_free0 (_tmp43_);
				_tmp45_ = plug_name;
				_tmp46_ = self->priv->prefs;
				_tmp47_ = plank_dock_preferences_get_Monitor (_tmp46_);
				_tmp48_ = _tmp47_;
				if (g_strcmp0 (_tmp45_, _tmp48_) == 0) {
					GtkComboBoxText* _tmp49_;
					_tmp49_ = self->priv->cb_display_plug;
					gtk_combo_box_set_active ((GtkComboBox*) _tmp49_, pos);
				}
				_tmp50_ = pos;
				pos = _tmp50_ + 1;
			}
		}
		plug_name_collection = (_vala_array_free (plug_name_collection, plug_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp51_ = self->priv->prefs;
	_tmp52_ = plank_dock_preferences_get_Monitor (_tmp51_);
	_tmp53_ = _tmp52_;
	if (g_strcmp0 (_tmp53_, "") == 0) {
		GtkComboBoxText* _tmp54_;
		_tmp54_ = self->priv->cb_display_plug;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp54_, 0);
	}
	_tmp55_ = self->priv->cb_display_plug;
	_tmp56_ = self->priv->prefs;
	_tmp57_ = plank_dock_preferences_get_Monitor (_tmp56_);
	_tmp58_ = _tmp57_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp55_, g_strcmp0 (_tmp58_, "") != 0);
	_tmp59_ = self->priv->sp_hide_delay;
	_tmp60_ = self->priv->prefs;
	_tmp61_ = plank_dock_preferences_get_HideMode (_tmp60_);
	_tmp62_ = _tmp61_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp59_, _tmp62_ != PLANK_HIDE_TYPE_NONE);
	_tmp63_ = self->priv->sp_unhide_delay;
	_tmp64_ = self->priv->prefs;
	_tmp65_ = plank_dock_preferences_get_HideMode (_tmp64_);
	_tmp66_ = _tmp65_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp63_, _tmp66_ != PLANK_HIDE_TYPE_NONE);
	_tmp67_ = self->priv->adj_iconsize;
	_tmp68_ = self->priv->prefs;
	_tmp69_ = plank_dock_preferences_get_IconSize (_tmp68_);
	_tmp70_ = _tmp69_;
	gtk_adjustment_set_value (_tmp67_, (gdouble) _tmp70_);
	_tmp71_ = self->priv->adj_offset;
	_tmp72_ = self->priv->prefs;
	_tmp73_ = plank_dock_preferences_get_Offset (_tmp72_);
	_tmp74_ = _tmp73_;
	gtk_adjustment_set_value (_tmp71_, (gdouble) _tmp74_);
	_tmp75_ = self->priv->adj_zoom_percent;
	_tmp76_ = self->priv->prefs;
	_tmp77_ = plank_dock_preferences_get_ZoomPercent (_tmp76_);
	_tmp78_ = _tmp77_;
	gtk_adjustment_set_value (_tmp75_, (gdouble) _tmp78_);
	_tmp79_ = self->priv->s_offset;
	_tmp80_ = self->priv->prefs;
	_tmp81_ = plank_dock_preferences_get_Alignment (_tmp80_);
	_tmp82_ = _tmp81_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp79_, _tmp82_ == GTK_ALIGN_CENTER);
	_tmp83_ = self->priv->s_zoom_percent;
	_tmp84_ = self->priv->prefs;
	_tmp85_ = plank_dock_preferences_get_ZoomEnabled (_tmp84_);
	_tmp86_ = _tmp85_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp83_, _tmp86_);
	_tmp87_ = self->priv->sw_hide;
	_tmp88_ = self->priv->prefs;
	_tmp89_ = plank_dock_preferences_get_HideMode (_tmp88_);
	_tmp90_ = _tmp89_;
	gtk_switch_set_active (_tmp87_, _tmp90_ != PLANK_HIDE_TYPE_NONE);
	_tmp91_ = self->priv->sw_primary_display;
	_tmp92_ = self->priv->prefs;
	_tmp93_ = plank_dock_preferences_get_Monitor (_tmp92_);
	_tmp94_ = _tmp93_;
	gtk_switch_set_active (_tmp91_, g_strcmp0 (_tmp94_, "") == 0);
	_tmp95_ = self->priv->sw_workspace_only;
	_tmp96_ = self->priv->prefs;
	_tmp97_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp96_);
	_tmp98_ = _tmp97_;
	gtk_switch_set_active (_tmp95_, _tmp98_);
	_tmp99_ = self->priv->sw_show_unpinned;
	_tmp100_ = self->priv->prefs;
	_tmp101_ = plank_dock_preferences_get_PinnedOnly (_tmp100_);
	_tmp102_ = _tmp101_;
	gtk_switch_set_active (_tmp99_, !_tmp102_);
	_tmp103_ = self->priv->sw_lock_items;
	_tmp104_ = self->priv->prefs;
	_tmp105_ = plank_dock_preferences_get_LockItems (_tmp104_);
	_tmp106_ = _tmp105_;
	gtk_switch_set_active (_tmp103_, _tmp106_);
	_tmp107_ = self->priv->sw_pressure_reveal;
	_tmp108_ = self->priv->prefs;
	_tmp109_ = plank_dock_preferences_get_PressureReveal (_tmp108_);
	_tmp110_ = _tmp109_;
	gtk_switch_set_active (_tmp107_, _tmp110_);
	_tmp111_ = self->priv->sw_zoom_enabled;
	_tmp112_ = self->priv->prefs;
	_tmp113_ = plank_dock_preferences_get_ZoomEnabled (_tmp112_);
	_tmp114_ = _tmp113_;
	gtk_switch_set_active (_tmp111_, _tmp114_);
	_tmp115_ = self->priv->cb_alignment;
	_tmp116_ = self->priv->prefs;
	_tmp117_ = plank_dock_preferences_get_Alignment (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = g_strdup_printf ("%i", (gint) _tmp118_);
	_tmp120_ = _tmp119_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp115_, _tmp120_);
	_g_free0 (_tmp120_);
	_tmp121_ = self->priv->cb_items_alignment;
	_tmp122_ = self->priv->prefs;
	_tmp123_ = plank_dock_preferences_get_ItemsAlignment (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = g_strdup_printf ("%i", (gint) _tmp124_);
	_tmp126_ = _tmp125_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp121_, _tmp126_);
	_g_free0 (_tmp126_);
	_tmp127_ = self->priv->cb_items_alignment;
	_tmp128_ = self->priv->prefs;
	_tmp129_ = plank_dock_preferences_get_Alignment (_tmp128_);
	_tmp130_ = _tmp129_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp127_, _tmp130_ == GTK_ALIGN_FILL);
}

static void
_plank_preferences_window_view_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gpointer self)
{
	plank_preferences_window_view_drag_begin (_sender, context, (PlankPreferencesWindow*) self);
}

static void
_plank_preferences_window_view_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender,
                                                                            GtkTreePath* path,
                                                                            gpointer self)
{
	plank_preferences_window_view_item_activated (_sender, path, (PlankPreferencesWindow*) self);
}

static void
plank_preferences_window_init_docklets_tab (PlankPreferencesWindow* self)
{
	PlankDockletViewModel* model_docklets = NULL;
	PlankDockletViewModel* _tmp0_;
	GtkTreeModelSort* sorted_docklets = NULL;
	PlankDockletViewModel* _tmp1_;
	GtkTreeModelSort* _tmp2_;
	GtkTargetEntry te = {0};
	GtkTargetEntry _tmp3_ = {0};
	GtkIconView* _tmp4_;
	GtkTargetEntry _tmp5_;
	GtkTargetEntry* _tmp6_;
	GtkTargetEntry* _tmp7_;
	gint _tmp7__length1;
	GtkIconView* _tmp8_;
	GtkIconView* _tmp9_;
	GtkIconView* _tmp10_;
	GtkIconView* _tmp11_;
	GtkIconView* _tmp12_;
	GtkTreeModelSort* _tmp34_;
	GtkIconView* _tmp35_;
	GtkTreeModelSort* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_docklet_view_model_new ();
	model_docklets = _tmp0_;
	_tmp1_ = model_docklets;
	_tmp2_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) _tmp1_);
	sorted_docklets = _tmp2_;
	_tmp3_.target = "text/plank-uri-list";
	_tmp3_.flags = (guint) GTK_TARGET_SAME_APP;
	_tmp3_.info = (guint) 0;
	te = _tmp3_;
	_tmp4_ = self->priv->view_docklets;
	_tmp5_ = te;
	_tmp6_ = g_new0 (GtkTargetEntry, 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	gtk_icon_view_enable_model_drag_source (_tmp4_, GDK_BUTTON1_MASK, _tmp7_, (gint) 1, GDK_ACTION_PRIVATE);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = self->priv->view_docklets;
	gtk_icon_view_set_text_column (_tmp8_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME);
	_tmp9_ = self->priv->view_docklets;
	gtk_icon_view_set_tooltip_column (_tmp9_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_DESCRIPTION);
	_tmp10_ = self->priv->view_docklets;
	gtk_icon_view_set_pixbuf_column (_tmp10_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_PIXBUF);
	_tmp11_ = self->priv->view_docklets;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "drag-begin", (GCallback) _plank_preferences_window_view_drag_begin_gtk_widget_drag_begin, self, G_CONNECT_AFTER);
	_tmp12_ = self->priv->view_docklets;
	g_signal_connect_object (_tmp12_, "item-activated", (GCallback) _plank_preferences_window_view_item_activated_gtk_icon_view_item_activated, self, 0);
	{
		GeeIterator* _docklet_it = NULL;
		PlankDockletManager* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp13_ = plank_docklet_manager_get_default ();
		_tmp14_ = plank_docklet_manager_list_docklets (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_docklet_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			PlankDocklet* docklet = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			GdkPixbuf* pixbuf = NULL;
			PlankDocklet* _tmp21_;
			const gchar* _tmp22_;
			GdkPixbuf* _tmp23_;
			PlankDockletViewModel* _tmp24_;
			PlankDocklet* _tmp25_;
			const gchar* _tmp26_;
			PlankDocklet* _tmp27_;
			const gchar* _tmp28_;
			PlankDocklet* _tmp29_;
			const gchar* _tmp30_;
			PlankDocklet* _tmp31_;
			const gchar* _tmp32_;
			GdkPixbuf* _tmp33_;
			_tmp18_ = _docklet_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _docklet_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			docklet = (PlankDocklet*) _tmp20_;
			_tmp21_ = docklet;
			_tmp22_ = plank_docklet_get_icon (_tmp21_);
			_tmp23_ = plank_drawing_service_load_icon (_tmp22_, 48, 48);
			pixbuf = _tmp23_;
			_tmp24_ = model_docklets;
			_tmp25_ = docklet;
			_tmp26_ = plank_docklet_get_id (_tmp25_);
			_tmp27_ = docklet;
			_tmp28_ = plank_docklet_get_name (_tmp27_);
			_tmp29_ = docklet;
			_tmp30_ = plank_docklet_get_description (_tmp29_);
			_tmp31_ = docklet;
			_tmp32_ = plank_docklet_get_icon (_tmp31_);
			_tmp33_ = pixbuf;
			plank_docklet_view_model_add (_tmp24_, _tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp33_);
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (docklet);
		}
		_g_object_unref0 (_docklet_it);
	}
	_tmp34_ = sorted_docklets;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp34_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME, GTK_SORT_ASCENDING);
	_tmp35_ = self->priv->view_docklets;
	_tmp36_ = sorted_docklets;
	gtk_icon_view_set_model (_tmp35_, (GtkTreeModel*) _tmp36_);
	_g_object_unref0 (sorted_docklets);
	_g_object_unref0 (model_docklets);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
plank_preferences_window_view_drag_begin (GtkWidget* widget,
                                          GdkDragContext* context,
                                          PlankPreferencesWindow* self)
{
	GtkIconView* view = NULL;
	GList* selection = NULL;
	GtkIconView* _tmp0_;
	GList* _tmp1_;
	GList* path_list = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeIter iter = {0};
	GValue val = {0};
	GtkTreePath* path = NULL;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreeModel* _tmp10_;
	GtkTreePath* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	GtkTreeModel* _tmp13_;
	GtkTreeIter _tmp14_;
	GValue _tmp15_ = {0};
	gchar* icon_name = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gint icon_size = 0;
	PlankDockPreferences* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint window_scale_factor = 0;
	GdkWindow* _tmp21_;
	cairo_surface_t* surface = NULL;
	const gchar* _tmp22_;
	cairo_surface_t* _tmp23_;
	cairo_surface_t* _tmp24_;
	cairo_surface_t* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	view = G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_icon_view_get_type (), GtkIconView);
	_tmp0_ = view;
	_tmp1_ = gtk_icon_view_get_selected_items (_tmp0_);
	selection = _tmp1_;
	_tmp2_ = selection;
	_tmp3_ = g_list_first (_tmp2_);
	path_list = _tmp3_;
	_tmp4_ = path_list;
	if (_tmp4_ == NULL) {
		(selection == NULL) ? NULL : (selection = (_g_list_free___vala_GtkTreePath_free0_ (selection), NULL));
		return;
	}
	_tmp5_ = view;
	_tmp6_ = gtk_icon_view_get_model (_tmp5_);
	model = _tmp6_;
	_tmp7_ = path_list;
	_tmp8_ = _tmp7_->data;
	_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp8_);
	path = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = path;
	gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
	iter = _tmp12_;
	_tmp13_ = model;
	_tmp14_ = iter;
	gtk_tree_model_get_value (_tmp13_, &_tmp14_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_ICON, &_tmp15_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp15_;
	_tmp16_ = g_value_get_string (&val);
	_tmp17_ = g_strdup (_tmp16_);
	icon_name = _tmp17_;
	_tmp18_ = self->priv->prefs;
	_tmp19_ = plank_dock_preferences_get_IconSize (_tmp18_);
	_tmp20_ = _tmp19_;
	icon_size = _tmp20_;
	_tmp21_ = gtk_widget_get_window ((GtkWidget*) self);
	window_scale_factor = gdk_window_get_scale_factor (_tmp21_);
	icon_size *= window_scale_factor;
	_tmp22_ = icon_name;
	_tmp23_ = plank_drawing_service_load_icon_for_scale (_tmp22_, icon_size, icon_size, window_scale_factor);
	surface = _tmp23_;
	_tmp24_ = surface;
	cairo_surface_set_device_offset (_tmp24_, (-icon_size) / 2.0, (-icon_size) / 2.0);
	_tmp25_ = surface;
	gtk_drag_set_icon_surface (context, _tmp25_);
	_cairo_surface_destroy0 (surface);
	_g_free0 (icon_name);
	__vala_GtkTreePath_free0 (path);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	(selection == NULL) ? NULL : (selection = (_g_list_free___vala_GtkTreePath_free0_ (selection), NULL));
}

static void
plank_preferences_window_view_item_activated (GtkIconView* view,
                                              GtkTreePath* path,
                                              PlankPreferencesWindow* self)
{
	PlankApplicationDockItemProvider* provider = NULL;
	PlankDockController* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	PlankDockItemProvider* _tmp2_;
	PlankApplicationDockItemProvider* _tmp3_;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp4_;
	GtkTreeIter iter = {0};
	GValue val = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	GValue _tmp9_ = {0};
	gchar* uri = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	PlankApplicationDockItemProvider* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_default_provider (_tmp0_);
	_tmp2_ = _tmp1_;
	provider = PLANK_IS_APPLICATION_DOCK_ITEM_PROVIDER (_tmp2_) ? ((PlankApplicationDockItemProvider*) _tmp2_) : NULL;
	_tmp3_ = provider;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = gtk_icon_view_get_model (view);
	model = _tmp4_;
	_tmp5_ = model;
	gtk_tree_model_get_iter (_tmp5_, &_tmp6_, path);
	iter = _tmp6_;
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get_value (_tmp7_, &_tmp8_, (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID, &_tmp9_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp9_;
	_tmp10_ = g_value_get_string (&val);
	_tmp11_ = g_strdup_printf ("%s%s", PLANK_DOCKLET_URI_PREFIX, _tmp10_);
	uri = _tmp11_;
	_tmp12_ = uri;
	g_debug ("PreferencesWindow.vala:467: Try to add docklet for '%s'", _tmp12_);
	_tmp13_ = provider;
	_tmp14_ = uri;
	plank_dock_item_provider_add_item_with_uri ((PlankDockItemProvider*) _tmp13_, _tmp14_, NULL);
	_g_free0 (uri);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}

PlankDockController*
plank_preferences_window_get_controller (PlankPreferencesWindow* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

void
plank_preferences_window_set_controller (PlankPreferencesWindow* self,
                                         PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_preferences_window_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_preferences_window_properties[PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY]);
	}
}

static void
_plank_preferences_window_controller_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	plank_preferences_window_controller_changed ((PlankPreferencesWindow*) self);
}

static GObject *
plank_preferences_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankPreferencesWindow * self;
	gchar* title = NULL;
	gchar* _tmp0_;
	PlankDockController* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	PlankDockPreferences* _tmp4_;
	parent_class = G_OBJECT_CLASS (plank_preferences_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_PREFERENCES_WINDOW, PlankPreferencesWindow);
	_tmp0_ = g_strdup (_ ("Preferences"));
	title = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_prefs (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->prefs);
	self->priv->prefs = _tmp4_;
	plank_preferences_window_init_dock_tab (self);
	plank_preferences_window_init_docklets_tab (self);
	plank_preferences_window_connect_signals (self);
	g_signal_connect_object ((GObject*) self, "notify::controller", (GCallback) _plank_preferences_window_controller_changed_g_object_notify, self, 0);
	_g_free0 (title);
	return obj;
}

static void
plank_preferences_window_class_init (PlankPreferencesWindowClass * klass,
                                     gpointer klass_data)
{
	plank_preferences_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankPreferencesWindow_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) plank_preferences_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_preferences_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_preferences_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_preferences_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_preferences_window_finalize;
	/**
	 * The controller for this dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY, plank_preferences_window_properties[PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/net/launchpad/plank/ui/preferences.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_theme", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_theme));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_hidemode", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_hidemode));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_display_plug", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_display_plug));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_position", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_position));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_alignment", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_alignment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cb_items_alignment", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, cb_items_alignment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sp_hide_delay", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sp_hide_delay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sp_unhide_delay", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sp_unhide_delay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_offset", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, s_offset));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_zoom_percent", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, s_zoom_percent));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "adj_hide_delay", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, adj_hide_delay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "adj_unhide_delay", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, adj_unhide_delay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "adj_iconsize", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, adj_iconsize));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "adj_offset", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, adj_offset));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "adj_zoom_percent", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, adj_zoom_percent));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_hide", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_hide));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_primary_display", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_primary_display));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_workspace_only", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_workspace_only));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_show_unpinned", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_show_unpinned));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_lock_items", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_lock_items));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_pressure_reveal", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_pressure_reveal));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sw_zoom_enabled", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, sw_zoom_enabled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_docklets", FALSE, PlankPreferencesWindow_private_offset + G_STRUCT_OFFSET (PlankPreferencesWindowPrivate, view_docklets));
}

static void
plank_preferences_window_instance_init (PlankPreferencesWindow * self,
                                        gpointer klass)
{
	self->priv = plank_preferences_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
plank_preferences_window_finalize (GObject * obj)
{
	PlankPreferencesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_PREFERENCES_WINDOW, PlankPreferencesWindow);
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->prefs);
	G_OBJECT_CLASS (plank_preferences_window_parent_class)->finalize (obj);
}

static GType
plank_preferences_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankPreferencesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_preferences_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankPreferencesWindow), 0, (GInstanceInitFunc) plank_preferences_window_instance_init, NULL };
	GType plank_preferences_window_type_id;
	plank_preferences_window_type_id = g_type_register_static (gtk_window_get_type (), "PlankPreferencesWindow", &g_define_type_info, 0);
	PlankPreferencesWindow_private_offset = g_type_add_instance_private (plank_preferences_window_type_id, sizeof (PlankPreferencesWindowPrivate));
	return plank_preferences_window_type_id;
}

GType
plank_preferences_window_get_type (void)
{
	static volatile gsize plank_preferences_window_type_id__once = 0;
	if (g_once_init_enter (&plank_preferences_window_type_id__once)) {
		GType plank_preferences_window_type_id;
		plank_preferences_window_type_id = plank_preferences_window_get_type_once ();
		g_once_init_leave (&plank_preferences_window_type_id__once, plank_preferences_window_type_id);
	}
	return plank_preferences_window_type_id__once;
}

static void
_vala_plank_preferences_window_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	PlankPreferencesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_PREFERENCES_WINDOW, PlankPreferencesWindow);
	switch (property_id) {
		case PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_preferences_window_get_controller (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_preferences_window_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	PlankPreferencesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_PREFERENCES_WINDOW, PlankPreferencesWindow);
	switch (property_id) {
		case PLANK_PREFERENCES_WINDOW_CONTROLLER_PROPERTY:
		plank_preferences_window_set_controller (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

