// python wrapper for vtkPVRepresentedArrayListSettings
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVRepresentedArrayListSettings.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRepresentedArrayListSettings(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRepresentedArrayListSettings_ClassNew(); }


static PyObject *
PyvtkPVRepresentedArrayListSettings_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRepresentedArrayListSettings::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRepresentedArrayListSettings::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRepresentedArrayListSettings *tempr = vtkPVRepresentedArrayListSettings::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRepresentedArrayListSettings *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRepresentedArrayListSettings::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRepresentedArrayListSettings::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRepresentedArrayListSettings::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVRepresentedArrayListSettings *tempr = vtkPVRepresentedArrayListSettings::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetNumberOfFilterExpressions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfFilterExpressions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfFilterExpressions(temp0);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetNumberOfFilterExpressions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetNumberOfFilterExpressions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFilterExpressions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfFilterExpressions() :
      op->vtkPVRepresentedArrayListSettings::GetNumberOfFilterExpressions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetFilterExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFilterExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetFilterExpression(temp0, temp1);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetFilterExpression(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetFilterExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFilterExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFilterExpression(temp0) :
      op->vtkPVRepresentedArrayListSettings::GetFilterExpression(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetComputeArrayMagnitude(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeArrayMagnitude");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeArrayMagnitude(temp0);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetComputeArrayMagnitude(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetArrayMagnitudeException(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayMagnitudeException");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetArrayMagnitudeException(temp0, temp1);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetArrayMagnitudeException(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetNumberOfArrayMagnitudeExceptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfArrayMagnitudeExceptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfArrayMagnitudeExceptions(temp0);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetNumberOfArrayMagnitudeExceptions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_ShouldUseMagnitudeMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShouldUseMagnitudeMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ShouldUseMagnitudeMode(temp0) :
      op->vtkPVRepresentedArrayListSettings::ShouldUseMagnitudeMode(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsDefaultXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfChartsDefaultXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfChartsDefaultXAxis(temp0);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetNumberOfChartsDefaultXAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsDefaultXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfChartsDefaultXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfChartsDefaultXAxis() :
      op->vtkPVRepresentedArrayListSettings::GetNumberOfChartsDefaultXAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetChartsDefaultXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartsDefaultXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetChartsDefaultXAxis(temp0, temp1);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetChartsDefaultXAxis(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetChartsDefaultXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChartsDefaultXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetChartsDefaultXAxis(temp0) :
      op->vtkPVRepresentedArrayListSettings::GetChartsDefaultXAxis(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetAllChartsDefaultXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllChartsDefaultXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetAllChartsDefaultXAxis() :
      &op->vtkPVRepresentedArrayListSettings::GetAllChartsDefaultXAxis());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsHiddenAttributes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfChartsHiddenAttributes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfChartsHiddenAttributes(temp0);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetNumberOfChartsHiddenAttributes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsHiddenAttributes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfChartsHiddenAttributes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfChartsHiddenAttributes() :
      op->vtkPVRepresentedArrayListSettings::GetNumberOfChartsHiddenAttributes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_SetChartsHiddenAttributes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartsHiddenAttributes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetChartsHiddenAttributes(temp0, temp1);
    }
    else
    {
      op->vtkPVRepresentedArrayListSettings::SetChartsHiddenAttributes(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRepresentedArrayListSettings_GetSeriesVisibilityDefault(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeriesVisibilityDefault");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRepresentedArrayListSettings *op = static_cast<vtkPVRepresentedArrayListSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSeriesVisibilityDefault(temp0) :
      op->vtkPVRepresentedArrayListSettings::GetSeriesVisibilityDefault(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRepresentedArrayListSettings_Methods[] = {
  {"IsTypeOf", PyvtkPVRepresentedArrayListSettings_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRepresentedArrayListSettings_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRepresentedArrayListSettings_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVRepresentedArrayListSettings\nC++: static vtkPVRepresentedArrayListSettings *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRepresentedArrayListSettings_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRepresentedArrayListSettings\nC++: vtkPVRepresentedArrayListSettings *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRepresentedArrayListSettings_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRepresentedArrayListSettings_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkPVRepresentedArrayListSettings_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkPVRepresentedArrayListSettings\nC++: static vtkPVRepresentedArrayListSettings *GetInstance()\n\nAccess the singleton.\n"},
  {"SetNumberOfFilterExpressions", PyvtkPVRepresentedArrayListSettings_SetNumberOfFilterExpressions, METH_VARARGS,
   "SetNumberOfFilterExpressions(self, n:int) -> None\nC++: virtual void SetNumberOfFilterExpressions(int n)\n\nSet/get the number of filter expressions.\n"},
  {"GetNumberOfFilterExpressions", PyvtkPVRepresentedArrayListSettings_GetNumberOfFilterExpressions, METH_VARARGS,
   "GetNumberOfFilterExpressions(self) -> int\nC++: virtual int GetNumberOfFilterExpressions()\n\n"},
  {"SetFilterExpression", PyvtkPVRepresentedArrayListSettings_SetFilterExpression, METH_VARARGS,
   "SetFilterExpression(self, i:int, expression:str) -> None\nC++: virtual void SetFilterExpression(int i,\n    const char *expression)\n\nSet/get the filter expression at index i. If the index is outside\nthe valid range, this call is a noop.\n"},
  {"GetFilterExpression", PyvtkPVRepresentedArrayListSettings_GetFilterExpression, METH_VARARGS,
   "GetFilterExpression(self, i:int) -> str\nC++: virtual const char *GetFilterExpression(int i)\n\n"},
  {"SetComputeArrayMagnitude", PyvtkPVRepresentedArrayListSettings_SetComputeArrayMagnitude, METH_VARARGS,
   "SetComputeArrayMagnitude(self, _arg:bool) -> None\nC++: virtual void SetComputeArrayMagnitude(bool _arg)\n\nSetters to control whether ParaView should allow the user to\ndisplay the gradient of a given multi-component field.\n\nIf ComputeArrayMagnitude is true then ParaView will always\ncompute the magnitude. Otherwise it will not.\n\nArrayMagnitudeExceptions is the list of exceptions and will\nbehave differently depending on the value of\nComputeArrayMagnitude. If ComputeArrayMagnitude is false then the\nlist describes the number of components for which ParaView will\nstill compute the magnitude. Else the list describe the number of\ncomponents for which ParaView will not compute the magnitude.\n\n@see ShouldUseMagnitudeMode\n"},
  {"SetArrayMagnitudeException", PyvtkPVRepresentedArrayListSettings_SetArrayMagnitudeException, METH_VARARGS,
   "SetArrayMagnitudeException(self, idx:int, ncomp:int) -> None\nC++: virtual void SetArrayMagnitudeException(int idx, int ncomp)\n\n"},
  {"SetNumberOfArrayMagnitudeExceptions", PyvtkPVRepresentedArrayListSettings_SetNumberOfArrayMagnitudeExceptions, METH_VARARGS,
   "SetNumberOfArrayMagnitudeExceptions(self, nexceptions:int) -> None\nC++: virtual void SetNumberOfArrayMagnitudeExceptions(\n    int nexceptions)\n\n"},
  {"ShouldUseMagnitudeMode", PyvtkPVRepresentedArrayListSettings_ShouldUseMagnitudeMode, METH_VARARGS,
   "ShouldUseMagnitudeMode(self, ncomp:int) -> bool\nC++: virtual bool ShouldUseMagnitudeMode(int ncomp)\n\nCheck if the array mode for this number of components should be\nthe magnitude mode or not. This will internally use the\ninformations given by ComputeArrayMagnitude and\nArrayMagnitudeExceptions.\n\n@see SetComputeArrayMagnitude\n"},
  {"SetNumberOfChartsDefaultXAxis", PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsDefaultXAxis, METH_VARARGS,
   "SetNumberOfChartsDefaultXAxis(self, n:int) -> None\nC++: virtual void SetNumberOfChartsDefaultXAxis(int n)\n\nChartsDefaultXAxis is the list of array names that will be\nselected by default as the X axis when displaying some data in\ncharts.\n"},
  {"GetNumberOfChartsDefaultXAxis", PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsDefaultXAxis, METH_VARARGS,
   "GetNumberOfChartsDefaultXAxis(self) -> int\nC++: virtual int GetNumberOfChartsDefaultXAxis()\n\n"},
  {"SetChartsDefaultXAxis", PyvtkPVRepresentedArrayListSettings_SetChartsDefaultXAxis, METH_VARARGS,
   "SetChartsDefaultXAxis(self, i:int, expression:str) -> None\nC++: virtual void SetChartsDefaultXAxis(int i,\n    const char *expression)\n\n"},
  {"GetChartsDefaultXAxis", PyvtkPVRepresentedArrayListSettings_GetChartsDefaultXAxis, METH_VARARGS,
   "GetChartsDefaultXAxis(self, i:int) -> str\nC++: virtual const char *GetChartsDefaultXAxis(int i)\n\n"},
  {"GetAllChartsDefaultXAxis", PyvtkPVRepresentedArrayListSettings_GetAllChartsDefaultXAxis, METH_VARARGS,
   "GetAllChartsDefaultXAxis(self) -> (str, ...)\nC++: virtual const std::vector<std::string> &GetAllChartsDefaultXAxis(\n    )\n\n"},
  {"SetNumberOfChartsHiddenAttributes", PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsHiddenAttributes, METH_VARARGS,
   "SetNumberOfChartsHiddenAttributes(self, n:int) -> None\nC++: virtual void SetNumberOfChartsHiddenAttributes(int n)\n\nChartsHiddenAttributes is a list of regex that controls whether\nor not array should be visible by defaults in a chart. If the\nname of the array matches one of the regex then it will be hidden\nby defaults, otherwise it will be visible.\n\nSee GetSeriesVisibilityDefault to evaluate the default visibility\nof a given array name.\n"},
  {"GetNumberOfChartsHiddenAttributes", PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsHiddenAttributes, METH_VARARGS,
   "GetNumberOfChartsHiddenAttributes(self) -> int\nC++: virtual int GetNumberOfChartsHiddenAttributes()\n\n"},
  {"SetChartsHiddenAttributes", PyvtkPVRepresentedArrayListSettings_SetChartsHiddenAttributes, METH_VARARGS,
   "SetChartsHiddenAttributes(self, i:int, expression:str) -> None\nC++: virtual void SetChartsHiddenAttributes(int i,\n    const char *expression)\n\n"},
  {"GetSeriesVisibilityDefault", PyvtkPVRepresentedArrayListSettings_GetSeriesVisibilityDefault, METH_VARARGS,
   "GetSeriesVisibilityDefault(self, name:str) -> bool\nC++: virtual bool GetSeriesVisibilityDefault(const char *name)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRepresentedArrayListSettings_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("compute_array_magnitude"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRepresentedArrayListSettings_SetComputeArrayMagnitude(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRepresentedArrayListSettings_SetComputeArrayMagnitude(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComputeArrayMagnitude\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_magnitude_exception"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRepresentedArrayListSettings_SetArrayMagnitudeException(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRepresentedArrayListSettings_SetArrayMagnitudeException(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArrayMagnitudeException\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRepresentedArrayListSettings_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("all_charts_default_x_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRepresentedArrayListSettings_GetAllChartsDefaultXAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAllChartsDefaultXAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_array_magnitude_exceptions"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfArrayMagnitudeExceptions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfArrayMagnitudeExceptions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfArrayMagnitudeExceptions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_charts_default_x_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsDefaultXAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsDefaultXAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsDefaultXAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfChartsDefaultXAxis/SetNumberOfChartsDefaultXAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_charts_hidden_attributes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRepresentedArrayListSettings_GetNumberOfChartsHiddenAttributes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsHiddenAttributes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRepresentedArrayListSettings_SetNumberOfChartsHiddenAttributes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfChartsHiddenAttributes/SetNumberOfChartsHiddenAttributes\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRepresentedArrayListSettings_Doc =
  "vtkPVRepresentedArrayListSettings - singleton used to filter out\nundesired data attribute from the representation.\n\n"
  "Superclass: vtkObject\n\n"
  "Currently represent the \"Represented Attributes\" section of ParaView\n"
  "settings.\n\n"
  "vtkPVRepresentedArrayListSettings is a singleton used to keep track\n"
  "of a list of regular expressions that filter out arrays in a\n"
  "RepresentedArrayList domain, and contains other settings controlling\n"
  "which array should be visible in which situation.\n\n"
  "All calls to vtkPVRepresentedArrayListSettings::New() returns a\n"
  "reference to the singleton instance.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRepresentedArrayListSettings_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRepresentedArrayListSettings", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRepresentedArrayListSettings_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRepresentedArrayListSettings_StaticNew()
{
  return vtkPVRepresentedArrayListSettings::New();
}

PyObject *PyvtkPVRepresentedArrayListSettings_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRepresentedArrayListSettings_Type, PyvtkPVRepresentedArrayListSettings_Methods,
    "vtkPVRepresentedArrayListSettings",
 &PyvtkPVRepresentedArrayListSettings_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRepresentedArrayListSettings_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRepresentedArrayListSettings(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRepresentedArrayListSettings_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRepresentedArrayListSettings", o) != 0)
  {
    Py_DECREF(o);
  }

}

