/* DocumentThumbnail.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DocumentThumbnail.vala, do not modify */

/* DocumentThumbnail.vala
 *
 * Copyright 2023-2024 Diego Iván <diegoivan.mae@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <poppler.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <graphene-gobject.h>
#include <gsk/gsk.h>

#define PAPER_CLIP_DOCUMENT_THUMBNAIL_MAX_SIZE 350
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL (paper_clip_document_thumbnail_get_type ())
#define PAPER_CLIP_DOCUMENT_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnail))
#define PAPER_CLIP_DOCUMENT_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnailClass))
#define PAPER_CLIP_IS_DOCUMENT_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL))
#define PAPER_CLIP_IS_DOCUMENT_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL))
#define PAPER_CLIP_DOCUMENT_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnailClass))

typedef struct _PaperClipDocumentThumbnail PaperClipDocumentThumbnail;
typedef struct _PaperClipDocumentThumbnailClass PaperClipDocumentThumbnailClass;
typedef struct _PaperClipDocumentThumbnailPrivate PaperClipDocumentThumbnailPrivate;

#define PAPER_CLIP_SERVICES_TYPE_THUMBNAILER (paper_clip_services_thumbnailer_get_type ())
#define PAPER_CLIP_SERVICES_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailer))
#define PAPER_CLIP_SERVICES_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailerClass))
#define PAPER_CLIP_SERVICES_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER))
#define PAPER_CLIP_SERVICES_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER))
#define PAPER_CLIP_SERVICES_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailerClass))

typedef struct _PaperClipServicesThumbnailer PaperClipServicesThumbnailer;
typedef struct _PaperClipServicesThumbnailerClass PaperClipServicesThumbnailerClass;

#define PAPER_CLIP_TYPE_DOCUMENT (paper_clip_document_get_type ())
#define PAPER_CLIP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument))
#define PAPER_CLIP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))
#define PAPER_CLIP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))

typedef struct _PaperClipDocument PaperClipDocument;
typedef struct _PaperClipDocumentClass PaperClipDocumentClass;
enum  {
	PAPER_CLIP_DOCUMENT_THUMBNAIL_0_PROPERTY,
	PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY,
	PAPER_CLIP_DOCUMENT_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* paper_clip_document_thumbnail_properties[PAPER_CLIP_DOCUMENT_THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _paper_clip_services_thumbnailer_unref0(var) ((var == NULL) ? NULL : (var = (paper_clip_services_thumbnailer_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PaperClipDocumentThumbnailGeneratePngData PaperClipDocumentThumbnailGeneratePngData;

struct _PaperClipDocumentThumbnail {
	AdwBin parent_instance;
	PaperClipDocumentThumbnailPrivate * priv;
};

struct _PaperClipDocumentThumbnailClass {
	AdwBinClass parent_class;
};

struct _PaperClipDocumentThumbnailPrivate {
	GtkImage* thumbnail_image;
	PaperClipServicesThumbnailer* thumbnailer;
	PaperClipDocument* _document;
};

struct _PaperClipDocumentThumbnailGeneratePngData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipDocumentThumbnail* self;
	PopplerPage* page;
	PaperClipDocument* _tmp0_;
	PaperClipDocument* _tmp1_;
	PopplerPage* _tmp2_;
	gchar* basename;
	PaperClipDocument* _tmp3_;
	PaperClipDocument* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GtkImage* _tmp8_;
	GdkTexture* thumbnail_texture;
	PaperClipServicesThumbnailer* _tmp9_;
	GdkTexture* _tmp10_;
	GtkImage* _tmp11_;
	GdkPaintable* _tmp12_;
	GdkPaintable* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

static gint PaperClipDocumentThumbnail_private_offset;
static gpointer paper_clip_document_thumbnail_parent_class = NULL;

VALA_EXTERN GType paper_clip_document_thumbnail_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDocumentThumbnail, g_object_unref)
VALA_EXTERN gpointer paper_clip_services_thumbnailer_ref (gpointer instance);
VALA_EXTERN void paper_clip_services_thumbnailer_unref (gpointer instance);
VALA_EXTERN GParamSpec* paper_clip_services_param_spec_thumbnailer (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags);
VALA_EXTERN void paper_clip_services_value_set_thumbnailer (GValue* value,
                                                gpointer v_object);
VALA_EXTERN void paper_clip_services_value_take_thumbnailer (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN gpointer paper_clip_services_value_get_thumbnailer (const GValue* value);
VALA_EXTERN GType paper_clip_services_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipServicesThumbnailer, paper_clip_services_thumbnailer_unref)
VALA_EXTERN GType paper_clip_document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDocument, g_object_unref)
VALA_EXTERN PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_get_default (void);
static void paper_clip_document_thumbnail_generate_png_data_free (gpointer _data);
static void paper_clip_document_thumbnail_generate_png (PaperClipDocumentThumbnail* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void paper_clip_document_thumbnail_generate_png_finish (PaperClipDocumentThumbnail* self,
                                                        GAsyncResult* _res_);
static gboolean paper_clip_document_thumbnail_generate_png_co (PaperClipDocumentThumbnailGeneratePngData* _data_);
VALA_EXTERN PaperClipDocument* paper_clip_document_thumbnail_get_document (PaperClipDocumentThumbnail* self);
VALA_EXTERN PopplerPage* paper_clip_document_get_page_for_index (PaperClipDocument* self,
                                                     gint index);
VALA_EXTERN GFile* paper_clip_document_get_original_file (PaperClipDocument* self);
VALA_EXTERN void paper_clip_services_thumbnailer_create_thumbnail (PaperClipServicesThumbnailer* self,
                                                       PopplerPage* page,
                                                       const gchar* basename,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GdkTexture* paper_clip_services_thumbnailer_create_thumbnail_finish (PaperClipServicesThumbnailer* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void paper_clip_document_thumbnail_generate_png_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static GdkPaintable* paper_clip_document_thumbnail_scale_thumbnail (PaperClipDocumentThumbnail* self,
                                                             GdkTexture* thumbnail_texture);
static void paper_clip_document_thumbnail_compute_scaled_size (PaperClipDocumentThumbnail* self,
                                                        gint image_height,
                                                        gint image_width,
                                                        gfloat* scaled_height,
                                                        gfloat* scaled_width);
VALA_EXTERN PaperClipDocumentThumbnail* paper_clip_document_thumbnail_new (void);
VALA_EXTERN PaperClipDocumentThumbnail* paper_clip_document_thumbnail_construct (GType object_type);
VALA_EXTERN void paper_clip_document_thumbnail_set_document (PaperClipDocumentThumbnail* self,
                                                 PaperClipDocument* value);
static GObject * paper_clip_document_thumbnail_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
VALA_EXTERN void paper_clip_services_thumbnailer_set_max_size (PaperClipServicesThumbnailer* self,
                                                   gint value);
static void paper_clip_document_thumbnail_finalize (GObject * obj);
static GType paper_clip_document_thumbnail_get_type_once (void);
static void _vala_paper_clip_document_thumbnail_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_paper_clip_document_thumbnail_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
paper_clip_document_thumbnail_get_instance_private (PaperClipDocumentThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, PaperClipDocumentThumbnail_private_offset);
}

static void
paper_clip_document_thumbnail_generate_png_data_free (gpointer _data)
{
	PaperClipDocumentThumbnailGeneratePngData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipDocumentThumbnailGeneratePngData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
paper_clip_document_thumbnail_generate_png (PaperClipDocumentThumbnail* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	PaperClipDocumentThumbnailGeneratePngData* _data_;
	PaperClipDocumentThumbnail* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipDocumentThumbnailGeneratePngData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_document_thumbnail_generate_png_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_document_thumbnail_generate_png_co (_data_);
}

static void
paper_clip_document_thumbnail_generate_png_finish (PaperClipDocumentThumbnail* self,
                                                   GAsyncResult* _res_)
{
	PaperClipDocumentThumbnailGeneratePngData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_document_thumbnail_generate_png_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	PaperClipDocumentThumbnailGeneratePngData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_document_thumbnail_generate_png_co (_data_);
}

static gboolean
paper_clip_document_thumbnail_generate_png_co (PaperClipDocumentThumbnailGeneratePngData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = paper_clip_document_thumbnail_get_document (_data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = paper_clip_document_get_page_for_index (_data_->_tmp1_, 0);
		_data_->page = _data_->_tmp2_;
		_data_->_tmp3_ = paper_clip_document_thumbnail_get_document (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = paper_clip_document_get_original_file (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = g_file_get_basename (_data_->_tmp6_);
		_data_->basename = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->self->priv->thumbnail_image;
		gtk_image_clear (_data_->_tmp8_);
		_data_->_tmp9_ = _data_->self->priv->thumbnailer;
		_data_->_state_ = 1;
		paper_clip_services_thumbnailer_create_thumbnail (_data_->_tmp9_, _data_->page, _data_->basename, paper_clip_document_thumbnail_generate_png_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = paper_clip_services_thumbnailer_create_thumbnail_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		_data_->thumbnail_texture = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->basename);
			_g_object_unref0 (_data_->page);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->self->priv->thumbnail_image;
		_data_->_tmp12_ = paper_clip_document_thumbnail_scale_thumbnail (_data_->self, _data_->thumbnail_texture);
		_data_->_tmp13_ = _data_->_tmp12_;
		g_object_set (_data_->_tmp11_, "paintable", _data_->_tmp13_, NULL);
		_g_object_unref0 (_data_->_tmp13_);
		_g_object_unref0 (_data_->thumbnail_texture);
		_g_free0 (_data_->basename);
		_g_object_unref0 (_data_->page);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_critical ("DocumentThumbnail.vala:58: %s", _data_->_tmp15_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GdkPaintable*
paper_clip_document_thumbnail_scale_thumbnail (PaperClipDocumentThumbnail* self,
                                               GdkTexture* thumbnail_texture)
{
	gfloat scaled_height = 0.0F;
	gfloat scaled_width = 0.0F;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	GtkSnapshot* snapshot = NULL;
	GtkSnapshot* _tmp6_;
	graphene_rect_t thumbnail_rectangle = {0};
	graphene_point_t _tmp7_ = {0};
	graphene_size_t _tmp8_ = {0};
	graphene_rect_t _tmp9_ = {0};
	GskScalingFilter filter = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gint _tmp12_;
	GEnumValue* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkSnapshot* _tmp18_;
	GdkRGBA _tmp19_ = {0};
	graphene_rect_t _tmp20_;
	GtkSnapshot* _tmp21_;
	graphene_rect_t _tmp22_;
	GtkSnapshot* _tmp23_;
	GdkPaintable* _tmp24_;
	GdkPaintable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (thumbnail_texture != NULL, NULL);
	_tmp0_ = gdk_texture_get_height (thumbnail_texture);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_texture_get_width (thumbnail_texture);
	_tmp3_ = _tmp2_;
	paper_clip_document_thumbnail_compute_scaled_size (self, _tmp1_, _tmp3_, &_tmp4_, &_tmp5_);
	scaled_height = _tmp4_;
	scaled_width = _tmp5_;
	_tmp6_ = gtk_snapshot_new ();
	snapshot = _tmp6_;
	_tmp7_.x = (gfloat) 0;
	_tmp7_.y = (gfloat) 0;
	_tmp8_.width = floorf (scaled_width);
	_tmp8_.height = floorf (scaled_height);
	memset (&_tmp9_, 0, sizeof (graphene_rect_t));
	_tmp9_.origin = _tmp7_;
	_tmp9_.size = _tmp8_;
	thumbnail_rectangle = _tmp9_;
	filter = GSK_SCALING_FILTER_LINEAR;
	_tmp11_ = gdk_texture_get_width (thumbnail_texture);
	_tmp12_ = _tmp11_;
	if (scaled_width > ((gfloat) _tmp12_)) {
		_tmp10_ = TRUE;
	} else {
		gint _tmp13_;
		gint _tmp14_;
		_tmp13_ = gdk_texture_get_height (thumbnail_texture);
		_tmp14_ = _tmp13_;
		_tmp10_ = scaled_height > ((gfloat) _tmp14_);
	}
	if (_tmp10_) {
		filter = GSK_SCALING_FILTER_NEAREST;
	} else {
		filter = GSK_SCALING_FILTER_TRILINEAR;
	}
	_tmp15_ = g_enum_get_value (g_type_class_ref (gsk_scaling_filter_get_type ()), filter);
	_tmp16_ = g_strconcat ("Current filter for thumbnail: ", (_tmp15_ != NULL) ? _tmp15_->value_name : NULL, NULL);
	_tmp17_ = _tmp16_;
	g_debug ("DocumentThumbnail.vala:79: %s", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = snapshot;
	_tmp19_.red = (gfloat) 1;
	_tmp19_.green = (gfloat) 1;
	_tmp19_.blue = (gfloat) 1;
	_tmp19_.alpha = (gfloat) 1;
	_tmp20_ = thumbnail_rectangle;
	gtk_snapshot_append_color (_tmp18_, &_tmp19_, &_tmp20_);
	_tmp21_ = snapshot;
	_tmp22_ = thumbnail_rectangle;
	gtk_snapshot_append_scaled_texture (_tmp21_, thumbnail_texture, filter, &_tmp22_);
	_tmp23_ = snapshot;
	_tmp24_ = gtk_snapshot_to_paintable (_tmp23_, NULL);
	result = _tmp24_;
	_g_object_unref0 (snapshot);
	return result;
}

static void
paper_clip_document_thumbnail_compute_scaled_size (PaperClipDocumentThumbnail* self,
                                                   gint image_height,
                                                   gint image_width,
                                                   gfloat* scaled_height,
                                                   gfloat* scaled_width)
{
	gfloat _vala_scaled_height = 0.0F;
	gfloat _vala_scaled_width = 0.0F;
	gfloat size = 0.0F;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	size = (gfloat) (PAPER_CLIP_DOCUMENT_THUMBNAIL_MAX_SIZE * _tmp1_);
	if (image_width > image_height) {
		_vala_scaled_height = size;
		_vala_scaled_width = (image_width * _vala_scaled_height) / image_height;
	} else {
		if (image_height > image_width) {
			_vala_scaled_width = size;
			_vala_scaled_height = (image_height * _vala_scaled_width) / image_width;
		} else {
			_vala_scaled_height = size;
			_vala_scaled_width = _vala_scaled_height;
		}
	}
	if (scaled_height) {
		*scaled_height = _vala_scaled_height;
	}
	if (scaled_width) {
		*scaled_width = _vala_scaled_width;
	}
}

PaperClipDocumentThumbnail*
paper_clip_document_thumbnail_construct (GType object_type)
{
	PaperClipDocumentThumbnail * self = NULL;
	self = (PaperClipDocumentThumbnail*) g_object_new (object_type, NULL);
	return self;
}

PaperClipDocumentThumbnail*
paper_clip_document_thumbnail_new (void)
{
	return paper_clip_document_thumbnail_construct (PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL);
}

PaperClipDocument*
paper_clip_document_thumbnail_get_document (PaperClipDocumentThumbnail* self)
{
	PaperClipDocument* result;
	PaperClipDocument* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document;
	result = _tmp0_;
	return result;
}

void
paper_clip_document_thumbnail_set_document (PaperClipDocumentThumbnail* self,
                                            PaperClipDocument* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_document = value;
	paper_clip_document_thumbnail_generate_png (self, NULL, NULL);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_thumbnail_properties[PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY]);
}

static GObject *
paper_clip_document_thumbnail_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PaperClipDocumentThumbnail * self;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	PaperClipServicesThumbnailer* _tmp2_;
	GtkImage* _tmp3_;
	parent_class = G_OBJECT_CLASS (paper_clip_document_thumbnail_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnail);
	_tmp0_ = self->priv->thumbnail_image;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->thumbnail_image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "icon-dropshadow");
	_tmp2_ = self->priv->thumbnailer;
	paper_clip_services_thumbnailer_set_max_size (_tmp2_, PAPER_CLIP_DOCUMENT_THUMBNAIL_MAX_SIZE);
	_tmp3_ = self->priv->thumbnail_image;
	gtk_image_set_pixel_size (_tmp3_, PAPER_CLIP_DOCUMENT_THUMBNAIL_MAX_SIZE / 2);
	return obj;
}

static void
paper_clip_document_thumbnail_class_init (PaperClipDocumentThumbnailClass * klass,
                                          gpointer klass_data)
{
	paper_clip_document_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaperClipDocumentThumbnail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paper_clip_document_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paper_clip_document_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->constructor = paper_clip_document_thumbnail_constructor;
	G_OBJECT_CLASS (klass)->finalize = paper_clip_document_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY, paper_clip_document_thumbnail_properties[PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY] = g_param_spec_object ("document", "document", "document", PAPER_CLIP_TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
paper_clip_document_thumbnail_instance_init (PaperClipDocumentThumbnail * self,
                                             gpointer klass)
{
	GtkImage* _tmp0_;
	PaperClipServicesThumbnailer* _tmp1_;
	self->priv = paper_clip_document_thumbnail_get_instance_private (self);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->thumbnail_image = _tmp0_;
	_tmp1_ = paper_clip_services_thumbnailer_get_default ();
	self->priv->thumbnailer = _tmp1_;
}

static void
paper_clip_document_thumbnail_finalize (GObject * obj)
{
	PaperClipDocumentThumbnail * self;
	GtkImage* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnail);
	_tmp0_ = self->priv->thumbnail_image;
	gtk_image_clear (_tmp0_);
	_g_object_unref0 (self->priv->thumbnail_image);
	_paper_clip_services_thumbnailer_unref0 (self->priv->thumbnailer);
	G_OBJECT_CLASS (paper_clip_document_thumbnail_parent_class)->finalize (obj);
}

static GType
paper_clip_document_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PaperClipDocumentThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_clip_document_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperClipDocumentThumbnail), 0, (GInstanceInitFunc) paper_clip_document_thumbnail_instance_init, NULL };
	GType paper_clip_document_thumbnail_type_id;
	paper_clip_document_thumbnail_type_id = g_type_register_static (adw_bin_get_type (), "PaperClipDocumentThumbnail", &g_define_type_info, 0);
	PaperClipDocumentThumbnail_private_offset = g_type_add_instance_private (paper_clip_document_thumbnail_type_id, sizeof (PaperClipDocumentThumbnailPrivate));
	return paper_clip_document_thumbnail_type_id;
}

GType
paper_clip_document_thumbnail_get_type (void)
{
	static volatile gsize paper_clip_document_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_document_thumbnail_type_id__once)) {
		GType paper_clip_document_thumbnail_type_id;
		paper_clip_document_thumbnail_type_id = paper_clip_document_thumbnail_get_type_once ();
		g_once_init_leave (&paper_clip_document_thumbnail_type_id__once, paper_clip_document_thumbnail_type_id);
	}
	return paper_clip_document_thumbnail_type_id__once;
}

static void
_vala_paper_clip_document_thumbnail_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	PaperClipDocumentThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnail);
	switch (property_id) {
		case PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY:
		g_value_set_object (value, paper_clip_document_thumbnail_get_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_paper_clip_document_thumbnail_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	PaperClipDocumentThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_DOCUMENT_THUMBNAIL, PaperClipDocumentThumbnail);
	switch (property_id) {
		case PAPER_CLIP_DOCUMENT_THUMBNAIL_DOCUMENT_PROPERTY:
		paper_clip_document_thumbnail_set_document (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

