/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023 The OpenBLAS Project.                              */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_BARCELONA;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_BARCELONA.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_BARCELONA, sbdtobf16_k_BARCELONA, sbf16tos_k_BARCELONA, dbf16tod_k_BARCELONA,

  samax_k_BARCELONA,  samin_k_BARCELONA,  smax_k_BARCELONA,  smin_k_BARCELONA,
  isamax_k_BARCELONA, isamin_k_BARCELONA, ismax_k_BARCELONA, ismin_k_BARCELONA,
  snrm2_k_BARCELONA,  sasum_k_BARCELONA,  ssum_k_BARCELONA, scopy_k_BARCELONA, sbdot_k_BARCELONA,
  dsdot_k_BARCELONA,
  srot_k_BARCELONA,   srotm_k_BARCELONA,  saxpy_k_BARCELONA,  sscal_k_BARCELONA, sswap_k_BARCELONA,
  sbgemv_n_BARCELONA, sbgemv_t_BARCELONA, sger_k_BARCELONA,
  ssymv_L_BARCELONA, ssymv_U_BARCELONA,

  sbgemm_kernel_BARCELONA, sbgemm_beta_BARCELONA,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_BARCELONA, sbgemm_itcopy_BARCELONA,
#else
  sbgemm_oncopy_BARCELONA, sbgemm_otcopy_BARCELONA,
#endif
  sbgemm_oncopy_BARCELONA, sbgemm_otcopy_BARCELONA,

  strsm_kernel_LN_BARCELONA, strsm_kernel_LT_BARCELONA, strsm_kernel_RN_BARCELONA, strsm_kernel_RT_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_BARCELONA, strsm_iunncopy_BARCELONA, strsm_iutucopy_BARCELONA, strsm_iutncopy_BARCELONA,
  strsm_ilnucopy_BARCELONA, strsm_ilnncopy_BARCELONA, strsm_iltucopy_BARCELONA, strsm_iltncopy_BARCELONA,
#else
  strsm_ounucopy_BARCELONA, strsm_ounncopy_BARCELONA, strsm_outucopy_BARCELONA, strsm_outncopy_BARCELONA,
  strsm_olnucopy_BARCELONA, strsm_olnncopy_BARCELONA, strsm_oltucopy_BARCELONA, strsm_oltncopy_BARCELONA,
#endif
  strsm_ounucopy_BARCELONA, strsm_ounncopy_BARCELONA, strsm_outucopy_BARCELONA, strsm_outncopy_BARCELONA,
  strsm_olnucopy_BARCELONA, strsm_olnncopy_BARCELONA, strsm_oltucopy_BARCELONA, strsm_oltncopy_BARCELONA,
  strmm_kernel_RN_BARCELONA, strmm_kernel_RT_BARCELONA, strmm_kernel_LN_BARCELONA, strmm_kernel_LT_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_BARCELONA, strmm_iunncopy_BARCELONA, strmm_iutucopy_BARCELONA, strmm_iutncopy_BARCELONA,
  strmm_ilnucopy_BARCELONA, strmm_ilnncopy_BARCELONA, strmm_iltucopy_BARCELONA, strmm_iltncopy_BARCELONA,
#else
  strmm_ounucopy_BARCELONA, strmm_ounncopy_BARCELONA, strmm_outucopy_BARCELONA, strmm_outncopy_BARCELONA,
  strmm_olnucopy_BARCELONA, strmm_olnncopy_BARCELONA, strmm_oltucopy_BARCELONA, strmm_oltncopy_BARCELONA,
#endif
  strmm_ounucopy_BARCELONA, strmm_ounncopy_BARCELONA, strmm_outucopy_BARCELONA, strmm_outncopy_BARCELONA,
  strmm_olnucopy_BARCELONA, strmm_olnncopy_BARCELONA, strmm_oltucopy_BARCELONA, strmm_oltncopy_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_BARCELONA, ssymm_iltcopy_BARCELONA,
#else
  ssymm_outcopy_BARCELONA, ssymm_oltcopy_BARCELONA,
#endif
  ssymm_outcopy_BARCELONA, ssymm_oltcopy_BARCELONA,

#ifndef NO_LAPACK
  sneg_tcopy_BARCELONA, slaswp_ncopy_BARCELONA,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_BARCELONA,
  sbgemm_small_kernel_nn_BARCELONA, sbgemm_small_kernel_nt_BARCELONA, sbgemm_small_kernel_tn_BARCELONA, sbgemm_small_kernel_tt_BARCELONA,
  sbgemm_small_kernel_b0_nn_BARCELONA, sbgemm_small_kernel_b0_nt_BARCELONA, sbgemm_small_kernel_b0_tn_BARCELONA, sbgemm_small_kernel_b0_tt_BARCELONA,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_BARCELONA,  samin_k_BARCELONA,  smax_k_BARCELONA,  smin_k_BARCELONA,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_BARCELONA,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_BARCELONA, ismax_k_BARCELONA, ismin_k_BARCELONA,
  snrm2_k_BARCELONA,  sasum_k_BARCELONA,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_BARCELONA,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_BARCELONA, sdot_k_BARCELONA,
//  dsdot_k_BARCELONA,
  srot_k_BARCELONA,  srotm_k_BARCELONA,  saxpy_k_BARCELONA,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_BARCELONA,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_BARCELONA,
  sgemv_n_BARCELONA,  sgemv_t_BARCELONA,
#endif
#if BUILD_SINGLE == 1
  sger_k_BARCELONA,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_BARCELONA, ssymv_U_BARCELONA,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_BARCELONA,
  sgemm_direct_performant_BARCELONA,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_BARCELONA,
#endif

  sgemm_kernel_BARCELONA, sgemm_beta_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_BARCELONA, sgemm_itcopy_BARCELONA,
#else
  sgemm_oncopy_BARCELONA, sgemm_otcopy_BARCELONA,
#endif
  sgemm_oncopy_BARCELONA, sgemm_otcopy_BARCELONA,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_BARCELONA,
  sgemm_small_kernel_nn_BARCELONA, sgemm_small_kernel_nt_BARCELONA, sgemm_small_kernel_tn_BARCELONA, sgemm_small_kernel_tt_BARCELONA,
  sgemm_small_kernel_b0_nn_BARCELONA, sgemm_small_kernel_b0_nt_BARCELONA, sgemm_small_kernel_b0_tn_BARCELONA, sgemm_small_kernel_b0_tt_BARCELONA,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_BARCELONA, strsm_kernel_LT_BARCELONA, strsm_kernel_RN_BARCELONA, strsm_kernel_RT_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_BARCELONA, strsm_iunncopy_BARCELONA, strsm_iutucopy_BARCELONA, strsm_iutncopy_BARCELONA,
  strsm_ilnucopy_BARCELONA, strsm_ilnncopy_BARCELONA, strsm_iltucopy_BARCELONA, strsm_iltncopy_BARCELONA,
#else
  strsm_ounucopy_BARCELONA, strsm_ounncopy_BARCELONA, strsm_outucopy_BARCELONA, strsm_outncopy_BARCELONA,
  strsm_olnucopy_BARCELONA, strsm_olnncopy_BARCELONA, strsm_oltucopy_BARCELONA, strsm_oltncopy_BARCELONA,
#endif
  strsm_ounucopy_BARCELONA, strsm_ounncopy_BARCELONA, strsm_outucopy_BARCELONA, strsm_outncopy_BARCELONA,
  strsm_olnucopy_BARCELONA, strsm_olnncopy_BARCELONA, strsm_oltucopy_BARCELONA, strsm_oltncopy_BARCELONA,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_BARCELONA, strmm_kernel_RT_BARCELONA, strmm_kernel_LN_BARCELONA, strmm_kernel_LT_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_BARCELONA, strmm_iunncopy_BARCELONA, strmm_iutucopy_BARCELONA, strmm_iutncopy_BARCELONA,
  strmm_ilnucopy_BARCELONA, strmm_ilnncopy_BARCELONA, strmm_iltucopy_BARCELONA, strmm_iltncopy_BARCELONA,
#else
  strmm_ounucopy_BARCELONA, strmm_ounncopy_BARCELONA, strmm_outucopy_BARCELONA, strmm_outncopy_BARCELONA,
  strmm_olnucopy_BARCELONA, strmm_olnncopy_BARCELONA, strmm_oltucopy_BARCELONA, strmm_oltncopy_BARCELONA,
#endif
  strmm_ounucopy_BARCELONA, strmm_ounncopy_BARCELONA, strmm_outucopy_BARCELONA, strmm_outncopy_BARCELONA,
  strmm_olnucopy_BARCELONA, strmm_olnncopy_BARCELONA, strmm_oltucopy_BARCELONA, strmm_oltncopy_BARCELONA,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_BARCELONA, ssymm_iltcopy_BARCELONA,
#else
  ssymm_outcopy_BARCELONA, ssymm_oltcopy_BARCELONA,
#endif
  ssymm_outcopy_BARCELONA, ssymm_oltcopy_BARCELONA,
#ifndef NO_LAPACK
  sneg_tcopy_BARCELONA, slaswp_ncopy_BARCELONA,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_BARCELONA,  damin_k_BARCELONA,  dmax_k_BARCELONA,  dmin_k_BARCELONA,
  idamax_k_BARCELONA, idamin_k_BARCELONA, idmax_k_BARCELONA, idmin_k_BARCELONA,
  dnrm2_k_BARCELONA, dasum_k_BARCELONA,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_BARCELONA,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_BARCELONA, ddot_k_BARCELONA,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_BARCELONA,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_BARCELONA,
  drotm_k_BARCELONA,
  daxpy_k_BARCELONA,
  dscal_k_BARCELONA, 
  dswap_k_BARCELONA,
  dgemv_n_BARCELONA,  dgemv_t_BARCELONA,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_BARCELONA,
  dsymv_L_BARCELONA,  dsymv_U_BARCELONA,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_BARCELONA, dgemm_beta_BARCELONA,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_BARCELONA, dgemm_itcopy_BARCELONA,
#else
  dgemm_oncopy_BARCELONA, dgemm_otcopy_BARCELONA,
#endif
  dgemm_oncopy_BARCELONA, dgemm_otcopy_BARCELONA,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_BARCELONA,
  dgemm_small_kernel_nn_BARCELONA, dgemm_small_kernel_nt_BARCELONA, dgemm_small_kernel_tn_BARCELONA, dgemm_small_kernel_tt_BARCELONA,
  dgemm_small_kernel_b0_nn_BARCELONA, dgemm_small_kernel_b0_nt_BARCELONA, dgemm_small_kernel_b0_tn_BARCELONA, dgemm_small_kernel_b0_tt_BARCELONA,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_BARCELONA, dtrsm_kernel_LT_BARCELONA, dtrsm_kernel_RN_BARCELONA, dtrsm_kernel_RT_BARCELONA,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_BARCELONA, dtrsm_iunncopy_BARCELONA, dtrsm_iutucopy_BARCELONA, dtrsm_iutncopy_BARCELONA,
  dtrsm_ilnucopy_BARCELONA, dtrsm_ilnncopy_BARCELONA, dtrsm_iltucopy_BARCELONA, dtrsm_iltncopy_BARCELONA,
#else
  dtrsm_ounucopy_BARCELONA, dtrsm_ounncopy_BARCELONA, dtrsm_outucopy_BARCELONA, dtrsm_outncopy_BARCELONA,
  dtrsm_olnucopy_BARCELONA, dtrsm_olnncopy_BARCELONA, dtrsm_oltucopy_BARCELONA, dtrsm_oltncopy_BARCELONA,
#endif
  dtrsm_ounucopy_BARCELONA, dtrsm_ounncopy_BARCELONA, dtrsm_outucopy_BARCELONA, dtrsm_outncopy_BARCELONA,
  dtrsm_olnucopy_BARCELONA, dtrsm_olnncopy_BARCELONA, dtrsm_oltucopy_BARCELONA, dtrsm_oltncopy_BARCELONA,
  dtrmm_kernel_RN_BARCELONA, dtrmm_kernel_RT_BARCELONA, dtrmm_kernel_LN_BARCELONA, dtrmm_kernel_LT_BARCELONA,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_BARCELONA, dtrmm_iunncopy_BARCELONA, dtrmm_iutucopy_BARCELONA, dtrmm_iutncopy_BARCELONA,
  dtrmm_ilnucopy_BARCELONA, dtrmm_ilnncopy_BARCELONA, dtrmm_iltucopy_BARCELONA, dtrmm_iltncopy_BARCELONA,
#else
  dtrmm_ounucopy_BARCELONA, dtrmm_ounncopy_BARCELONA, dtrmm_outucopy_BARCELONA, dtrmm_outncopy_BARCELONA,
  dtrmm_olnucopy_BARCELONA, dtrmm_olnncopy_BARCELONA, dtrmm_oltucopy_BARCELONA, dtrmm_oltncopy_BARCELONA,
#endif
  dtrmm_ounucopy_BARCELONA, dtrmm_ounncopy_BARCELONA, dtrmm_outucopy_BARCELONA, dtrmm_outncopy_BARCELONA,
  dtrmm_olnucopy_BARCELONA, dtrmm_olnncopy_BARCELONA, dtrmm_oltucopy_BARCELONA, dtrmm_oltncopy_BARCELONA,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_BARCELONA, dsymm_iltcopy_BARCELONA,
#else
  dsymm_outcopy_BARCELONA, dsymm_oltcopy_BARCELONA,
#endif
  dsymm_outcopy_BARCELONA, dsymm_oltcopy_BARCELONA,

#ifndef NO_LAPACK
  dneg_tcopy_BARCELONA, dlaswp_ncopy_BARCELONA,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_BARCELONA,  qamin_k_BARCELONA,  qmax_k_BARCELONA,  qmin_k_BARCELONA,
  iqamax_k_BARCELONA, iqamin_k_BARCELONA, iqmax_k_BARCELONA, iqmin_k_BARCELONA,
  qnrm2_k_BARCELONA,  qasum_k_BARCELONA,  qsum_k_BARCELONA, qcopy_k_BARCELONA, qdot_k_BARCELONA,
  qrot_k_BARCELONA,   qrotm_k_BARCELONA,  qaxpy_k_BARCELONA,  qscal_k_BARCELONA, qswap_k_BARCELONA,
  qgemv_n_BARCELONA,  qgemv_t_BARCELONA,  qger_k_BARCELONA,
  qsymv_L_BARCELONA,  qsymv_U_BARCELONA,
  qgemm_kernel_BARCELONA, qgemm_beta_BARCELONA,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_BARCELONA, qgemm_itcopy_BARCELONA,
#else
  qgemm_oncopy_BARCELONA, qgemm_otcopy_BARCELONA,
#endif
  qgemm_oncopy_BARCELONA, qgemm_otcopy_BARCELONA,
  qtrsm_kernel_LN_BARCELONA, qtrsm_kernel_LT_BARCELONA, qtrsm_kernel_RN_BARCELONA, qtrsm_kernel_RT_BARCELONA,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_BARCELONA, qtrsm_iunncopy_BARCELONA, qtrsm_iutucopy_BARCELONA, qtrsm_iutncopy_BARCELONA,
  qtrsm_ilnucopy_BARCELONA, qtrsm_ilnncopy_BARCELONA, qtrsm_iltucopy_BARCELONA, qtrsm_iltncopy_BARCELONA,
#else
  qtrsm_ounucopy_BARCELONA, qtrsm_ounncopy_BARCELONA, qtrsm_outucopy_BARCELONA, qtrsm_outncopy_BARCELONA,
  qtrsm_olnucopy_BARCELONA, qtrsm_olnncopy_BARCELONA, qtrsm_oltucopy_BARCELONA, qtrsm_oltncopy_BARCELONA,
#endif
  qtrsm_ounucopy_BARCELONA, qtrsm_ounncopy_BARCELONA, qtrsm_outucopy_BARCELONA, qtrsm_outncopy_BARCELONA,
  qtrsm_olnucopy_BARCELONA, qtrsm_olnncopy_BARCELONA, qtrsm_oltucopy_BARCELONA, qtrsm_oltncopy_BARCELONA,
  qtrmm_kernel_RN_BARCELONA, qtrmm_kernel_RT_BARCELONA, qtrmm_kernel_LN_BARCELONA, qtrmm_kernel_LT_BARCELONA,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_BARCELONA, qtrmm_iunncopy_BARCELONA, qtrmm_iutucopy_BARCELONA, qtrmm_iutncopy_BARCELONA,
  qtrmm_ilnucopy_BARCELONA, qtrmm_ilnncopy_BARCELONA, qtrmm_iltucopy_BARCELONA, qtrmm_iltncopy_BARCELONA,
#else
  qtrmm_ounucopy_BARCELONA, qtrmm_ounncopy_BARCELONA, qtrmm_outucopy_BARCELONA, qtrmm_outncopy_BARCELONA,
  qtrmm_olnucopy_BARCELONA, qtrmm_olnncopy_BARCELONA, qtrmm_oltucopy_BARCELONA, qtrmm_oltncopy_BARCELONA,
#endif
  qtrmm_ounucopy_BARCELONA, qtrmm_ounncopy_BARCELONA, qtrmm_outucopy_BARCELONA, qtrmm_outncopy_BARCELONA,
  qtrmm_olnucopy_BARCELONA, qtrmm_olnncopy_BARCELONA, qtrmm_oltucopy_BARCELONA, qtrmm_oltncopy_BARCELONA,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_BARCELONA, qsymm_iltcopy_BARCELONA,
#else
  qsymm_outcopy_BARCELONA, qsymm_oltcopy_BARCELONA,
#endif
  qsymm_outcopy_BARCELONA, qsymm_oltcopy_BARCELONA,

#ifndef NO_LAPACK
  qneg_tcopy_BARCELONA, qlaswp_ncopy_BARCELONA,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_BARCELONA, camin_k_BARCELONA,
#endif
#if (BUILD_COMPLEX)
  icamax_k_BARCELONA, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_BARCELONA,
  cnrm2_k_BARCELONA, casum_k_BARCELONA, csum_k_BARCELONA,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_BARCELONA, cdotu_k_BARCELONA, cdotc_k_BARCELONA,
#endif
#if (BUILD_COMPLEX)
 csrot_k_BARCELONA,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_BARCELONA,
  caxpyc_k_BARCELONA, 
  cscal_k_BARCELONA, 
  cswap_k_BARCELONA,

  cgemv_n_BARCELONA, cgemv_t_BARCELONA, cgemv_r_BARCELONA, cgemv_c_BARCELONA,
  cgemv_o_BARCELONA, cgemv_u_BARCELONA, cgemv_s_BARCELONA, cgemv_d_BARCELONA,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_BARCELONA, cgerc_k_BARCELONA, cgerv_k_BARCELONA, cgerd_k_BARCELONA,
  csymv_L_BARCELONA, csymv_U_BARCELONA,
  chemv_L_BARCELONA, chemv_U_BARCELONA, chemv_M_BARCELONA, chemv_V_BARCELONA,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_BARCELONA, cgemm_kernel_l_BARCELONA, cgemm_kernel_r_BARCELONA, cgemm_kernel_b_BARCELONA,
  cgemm_beta_BARCELONA,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_BARCELONA, cgemm_itcopy_BARCELONA,
#else
  cgemm_oncopy_BARCELONA, cgemm_otcopy_BARCELONA,
#endif
  cgemm_oncopy_BARCELONA, cgemm_otcopy_BARCELONA,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_BARCELONA,
  cgemm_small_kernel_nn_BARCELONA, cgemm_small_kernel_nt_BARCELONA, cgemm_small_kernel_nr_BARCELONA, cgemm_small_kernel_nc_BARCELONA,
  cgemm_small_kernel_tn_BARCELONA, cgemm_small_kernel_tt_BARCELONA, cgemm_small_kernel_tr_BARCELONA, cgemm_small_kernel_tc_BARCELONA,
  cgemm_small_kernel_rn_BARCELONA, cgemm_small_kernel_rt_BARCELONA, cgemm_small_kernel_rr_BARCELONA, cgemm_small_kernel_rc_BARCELONA,
  cgemm_small_kernel_cn_BARCELONA, cgemm_small_kernel_ct_BARCELONA, cgemm_small_kernel_cr_BARCELONA, cgemm_small_kernel_cc_BARCELONA,
  cgemm_small_kernel_b0_nn_BARCELONA, cgemm_small_kernel_b0_nt_BARCELONA, cgemm_small_kernel_b0_nr_BARCELONA, cgemm_small_kernel_b0_nc_BARCELONA,
  cgemm_small_kernel_b0_tn_BARCELONA, cgemm_small_kernel_b0_tt_BARCELONA, cgemm_small_kernel_b0_tr_BARCELONA, cgemm_small_kernel_b0_tc_BARCELONA,
  cgemm_small_kernel_b0_rn_BARCELONA, cgemm_small_kernel_b0_rt_BARCELONA, cgemm_small_kernel_b0_rr_BARCELONA, cgemm_small_kernel_b0_rc_BARCELONA,
  cgemm_small_kernel_b0_cn_BARCELONA, cgemm_small_kernel_b0_ct_BARCELONA, cgemm_small_kernel_b0_cr_BARCELONA, cgemm_small_kernel_b0_cc_BARCELONA,
#endif

  ctrsm_kernel_LN_BARCELONA, ctrsm_kernel_LT_BARCELONA, ctrsm_kernel_LR_BARCELONA, ctrsm_kernel_LC_BARCELONA,
  ctrsm_kernel_RN_BARCELONA, ctrsm_kernel_RT_BARCELONA, ctrsm_kernel_RR_BARCELONA, ctrsm_kernel_RC_BARCELONA,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_BARCELONA,  ctrsm_iunncopy_BARCELONA,  ctrsm_iutucopy_BARCELONA,  ctrsm_iutncopy_BARCELONA,
  ctrsm_ilnucopy_BARCELONA,  ctrsm_ilnncopy_BARCELONA,  ctrsm_iltucopy_BARCELONA,  ctrsm_iltncopy_BARCELONA,
#else
  ctrsm_ounucopy_BARCELONA,  ctrsm_ounncopy_BARCELONA,  ctrsm_outucopy_BARCELONA,  ctrsm_outncopy_BARCELONA,
  ctrsm_olnucopy_BARCELONA,  ctrsm_olnncopy_BARCELONA,  ctrsm_oltucopy_BARCELONA,  ctrsm_oltncopy_BARCELONA,
#endif
  ctrsm_ounucopy_BARCELONA,  ctrsm_ounncopy_BARCELONA,  ctrsm_outucopy_BARCELONA,  ctrsm_outncopy_BARCELONA,
  ctrsm_olnucopy_BARCELONA,  ctrsm_olnncopy_BARCELONA,  ctrsm_oltucopy_BARCELONA,  ctrsm_oltncopy_BARCELONA,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_BARCELONA,  ctrmm_kernel_RT_BARCELONA,  ctrmm_kernel_RR_BARCELONA,  ctrmm_kernel_RC_BARCELONA,
  ctrmm_kernel_LN_BARCELONA,  ctrmm_kernel_LT_BARCELONA,  ctrmm_kernel_LR_BARCELONA,  ctrmm_kernel_LC_BARCELONA,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_BARCELONA,  ctrmm_iunncopy_BARCELONA,  ctrmm_iutucopy_BARCELONA,  ctrmm_iutncopy_BARCELONA,
  ctrmm_ilnucopy_BARCELONA,  ctrmm_ilnncopy_BARCELONA,  ctrmm_iltucopy_BARCELONA,  ctrmm_iltncopy_BARCELONA,
#else
  ctrmm_ounucopy_BARCELONA,  ctrmm_ounncopy_BARCELONA,  ctrmm_outucopy_BARCELONA,  ctrmm_outncopy_BARCELONA,
  ctrmm_olnucopy_BARCELONA,  ctrmm_olnncopy_BARCELONA,  ctrmm_oltucopy_BARCELONA,  ctrmm_oltncopy_BARCELONA,
#endif
  ctrmm_ounucopy_BARCELONA,  ctrmm_ounncopy_BARCELONA,  ctrmm_outucopy_BARCELONA,  ctrmm_outncopy_BARCELONA,
  ctrmm_olnucopy_BARCELONA,  ctrmm_olnncopy_BARCELONA,  ctrmm_oltucopy_BARCELONA,  ctrmm_oltncopy_BARCELONA,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_BARCELONA,  csymm_iltcopy_BARCELONA,
#else
  csymm_outcopy_BARCELONA,  csymm_oltcopy_BARCELONA,
#endif
  csymm_outcopy_BARCELONA,  csymm_oltcopy_BARCELONA,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_BARCELONA,  chemm_iltcopy_BARCELONA,
#else
  chemm_outcopy_BARCELONA,  chemm_oltcopy_BARCELONA,
#endif
  chemm_outcopy_BARCELONA,  chemm_oltcopy_BARCELONA,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_BARCELONA,

  cgemm3m_incopyb_BARCELONA,  cgemm3m_incopyr_BARCELONA,
  cgemm3m_incopyi_BARCELONA,  cgemm3m_itcopyb_BARCELONA,
  cgemm3m_itcopyr_BARCELONA,  cgemm3m_itcopyi_BARCELONA,
  cgemm3m_oncopyb_BARCELONA,  cgemm3m_oncopyr_BARCELONA,
  cgemm3m_oncopyi_BARCELONA,  cgemm3m_otcopyb_BARCELONA,
  cgemm3m_otcopyr_BARCELONA,  cgemm3m_otcopyi_BARCELONA,

  csymm3m_iucopyb_BARCELONA,  csymm3m_ilcopyb_BARCELONA,
  csymm3m_iucopyr_BARCELONA,  csymm3m_ilcopyr_BARCELONA,
  csymm3m_iucopyi_BARCELONA,  csymm3m_ilcopyi_BARCELONA,
  csymm3m_oucopyb_BARCELONA,  csymm3m_olcopyb_BARCELONA,
  csymm3m_oucopyr_BARCELONA,  csymm3m_olcopyr_BARCELONA,
  csymm3m_oucopyi_BARCELONA,  csymm3m_olcopyi_BARCELONA,

  chemm3m_iucopyb_BARCELONA,  chemm3m_ilcopyb_BARCELONA,
  chemm3m_iucopyr_BARCELONA,  chemm3m_ilcopyr_BARCELONA,
  chemm3m_iucopyi_BARCELONA,  chemm3m_ilcopyi_BARCELONA,

  chemm3m_oucopyb_BARCELONA,  chemm3m_olcopyb_BARCELONA,
  chemm3m_oucopyr_BARCELONA,  chemm3m_olcopyr_BARCELONA,
  chemm3m_oucopyi_BARCELONA,  chemm3m_olcopyi_BARCELONA,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_BARCELONA,
  
   claswp_ncopy_BARCELONA,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_BARCELONA, zamin_k_BARCELONA, izamax_k_BARCELONA, izamin_k_BARCELONA,
  znrm2_k_BARCELONA, zasum_k_BARCELONA, zsum_k_BARCELONA, zcopy_k_BARCELONA,
  zdotu_k_BARCELONA, zdotc_k_BARCELONA, zdrot_k_BARCELONA,
  zaxpy_k_BARCELONA, zaxpyc_k_BARCELONA, zscal_k_BARCELONA, zswap_k_BARCELONA,

  zgemv_n_BARCELONA, zgemv_t_BARCELONA, zgemv_r_BARCELONA, zgemv_c_BARCELONA,
  zgemv_o_BARCELONA, zgemv_u_BARCELONA, zgemv_s_BARCELONA, zgemv_d_BARCELONA,
  zgeru_k_BARCELONA, zgerc_k_BARCELONA, zgerv_k_BARCELONA, zgerd_k_BARCELONA,
  zsymv_L_BARCELONA, zsymv_U_BARCELONA,
  zhemv_L_BARCELONA, zhemv_U_BARCELONA, zhemv_M_BARCELONA, zhemv_V_BARCELONA,

  zgemm_kernel_n_BARCELONA, zgemm_kernel_l_BARCELONA, zgemm_kernel_r_BARCELONA, zgemm_kernel_b_BARCELONA,
  zgemm_beta_BARCELONA,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_BARCELONA, zgemm_itcopy_BARCELONA,
#else
  zgemm_oncopy_BARCELONA, zgemm_otcopy_BARCELONA,
#endif
  zgemm_oncopy_BARCELONA, zgemm_otcopy_BARCELONA,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_BARCELONA,
  zgemm_small_kernel_nn_BARCELONA, zgemm_small_kernel_nt_BARCELONA, zgemm_small_kernel_nr_BARCELONA, zgemm_small_kernel_nc_BARCELONA,
  zgemm_small_kernel_tn_BARCELONA, zgemm_small_kernel_tt_BARCELONA, zgemm_small_kernel_tr_BARCELONA, zgemm_small_kernel_tc_BARCELONA,
  zgemm_small_kernel_rn_BARCELONA, zgemm_small_kernel_rt_BARCELONA, zgemm_small_kernel_rr_BARCELONA, zgemm_small_kernel_rc_BARCELONA,
  zgemm_small_kernel_cn_BARCELONA, zgemm_small_kernel_ct_BARCELONA, zgemm_small_kernel_cr_BARCELONA, zgemm_small_kernel_cc_BARCELONA,
  zgemm_small_kernel_b0_nn_BARCELONA, zgemm_small_kernel_b0_nt_BARCELONA, zgemm_small_kernel_b0_nr_BARCELONA, zgemm_small_kernel_b0_nc_BARCELONA,
  zgemm_small_kernel_b0_tn_BARCELONA, zgemm_small_kernel_b0_tt_BARCELONA, zgemm_small_kernel_b0_tr_BARCELONA, zgemm_small_kernel_b0_tc_BARCELONA,
  zgemm_small_kernel_b0_rn_BARCELONA, zgemm_small_kernel_b0_rt_BARCELONA, zgemm_small_kernel_b0_rr_BARCELONA, zgemm_small_kernel_b0_rc_BARCELONA,
  zgemm_small_kernel_b0_cn_BARCELONA, zgemm_small_kernel_b0_ct_BARCELONA, zgemm_small_kernel_b0_cr_BARCELONA, zgemm_small_kernel_b0_cc_BARCELONA,
#endif

  ztrsm_kernel_LN_BARCELONA, ztrsm_kernel_LT_BARCELONA, ztrsm_kernel_LR_BARCELONA, ztrsm_kernel_LC_BARCELONA,
  ztrsm_kernel_RN_BARCELONA, ztrsm_kernel_RT_BARCELONA, ztrsm_kernel_RR_BARCELONA, ztrsm_kernel_RC_BARCELONA,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_BARCELONA,  ztrsm_iunncopy_BARCELONA,  ztrsm_iutucopy_BARCELONA,  ztrsm_iutncopy_BARCELONA,
  ztrsm_ilnucopy_BARCELONA,  ztrsm_ilnncopy_BARCELONA,  ztrsm_iltucopy_BARCELONA,  ztrsm_iltncopy_BARCELONA,
#else
  ztrsm_ounucopy_BARCELONA,  ztrsm_ounncopy_BARCELONA,  ztrsm_outucopy_BARCELONA,  ztrsm_outncopy_BARCELONA,
  ztrsm_olnucopy_BARCELONA,  ztrsm_olnncopy_BARCELONA,  ztrsm_oltucopy_BARCELONA,  ztrsm_oltncopy_BARCELONA,
#endif
  ztrsm_ounucopy_BARCELONA,  ztrsm_ounncopy_BARCELONA,  ztrsm_outucopy_BARCELONA,  ztrsm_outncopy_BARCELONA,
  ztrsm_olnucopy_BARCELONA,  ztrsm_olnncopy_BARCELONA,  ztrsm_oltucopy_BARCELONA,  ztrsm_oltncopy_BARCELONA,

  ztrmm_kernel_RN_BARCELONA,  ztrmm_kernel_RT_BARCELONA,  ztrmm_kernel_RR_BARCELONA,  ztrmm_kernel_RC_BARCELONA,
  ztrmm_kernel_LN_BARCELONA,  ztrmm_kernel_LT_BARCELONA,  ztrmm_kernel_LR_BARCELONA,  ztrmm_kernel_LC_BARCELONA,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_BARCELONA,  ztrmm_iunncopy_BARCELONA,  ztrmm_iutucopy_BARCELONA,  ztrmm_iutncopy_BARCELONA,
  ztrmm_ilnucopy_BARCELONA,  ztrmm_ilnncopy_BARCELONA,  ztrmm_iltucopy_BARCELONA,  ztrmm_iltncopy_BARCELONA,
#else
  ztrmm_ounucopy_BARCELONA,  ztrmm_ounncopy_BARCELONA,  ztrmm_outucopy_BARCELONA,  ztrmm_outncopy_BARCELONA,
  ztrmm_olnucopy_BARCELONA,  ztrmm_olnncopy_BARCELONA,  ztrmm_oltucopy_BARCELONA,  ztrmm_oltncopy_BARCELONA,
#endif
  ztrmm_ounucopy_BARCELONA,  ztrmm_ounncopy_BARCELONA,  ztrmm_outucopy_BARCELONA,  ztrmm_outncopy_BARCELONA,
  ztrmm_olnucopy_BARCELONA,  ztrmm_olnncopy_BARCELONA,  ztrmm_oltucopy_BARCELONA,  ztrmm_oltncopy_BARCELONA,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_BARCELONA,  zsymm_iltcopy_BARCELONA,
#else
  zsymm_outcopy_BARCELONA,  zsymm_oltcopy_BARCELONA,
#endif
  zsymm_outcopy_BARCELONA,  zsymm_oltcopy_BARCELONA,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_BARCELONA,  zhemm_iltcopy_BARCELONA,
#else
  zhemm_outcopy_BARCELONA,  zhemm_oltcopy_BARCELONA,
#endif
  zhemm_outcopy_BARCELONA,  zhemm_oltcopy_BARCELONA,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_BARCELONA,

  zgemm3m_incopyb_BARCELONA,  zgemm3m_incopyr_BARCELONA,
  zgemm3m_incopyi_BARCELONA,  zgemm3m_itcopyb_BARCELONA,
  zgemm3m_itcopyr_BARCELONA,  zgemm3m_itcopyi_BARCELONA,
  zgemm3m_oncopyb_BARCELONA,  zgemm3m_oncopyr_BARCELONA,
  zgemm3m_oncopyi_BARCELONA,  zgemm3m_otcopyb_BARCELONA,
  zgemm3m_otcopyr_BARCELONA,  zgemm3m_otcopyi_BARCELONA,

  zsymm3m_iucopyb_BARCELONA,  zsymm3m_ilcopyb_BARCELONA,
  zsymm3m_iucopyr_BARCELONA,  zsymm3m_ilcopyr_BARCELONA,
  zsymm3m_iucopyi_BARCELONA,  zsymm3m_ilcopyi_BARCELONA,
  zsymm3m_oucopyb_BARCELONA,  zsymm3m_olcopyb_BARCELONA,
  zsymm3m_oucopyr_BARCELONA,  zsymm3m_olcopyr_BARCELONA,
  zsymm3m_oucopyi_BARCELONA,  zsymm3m_olcopyi_BARCELONA,

  zhemm3m_iucopyb_BARCELONA,  zhemm3m_ilcopyb_BARCELONA,
  zhemm3m_iucopyr_BARCELONA,  zhemm3m_ilcopyr_BARCELONA,
  zhemm3m_iucopyi_BARCELONA,  zhemm3m_ilcopyi_BARCELONA,

  zhemm3m_oucopyb_BARCELONA,  zhemm3m_olcopyb_BARCELONA,
  zhemm3m_oucopyr_BARCELONA,  zhemm3m_olcopyr_BARCELONA,
  zhemm3m_oucopyi_BARCELONA,  zhemm3m_olcopyi_BARCELONA,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_BARCELONA, zlaswp_ncopy_BARCELONA,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_BARCELONA, xamin_k_BARCELONA, ixamax_k_BARCELONA, ixamin_k_BARCELONA,
  xnrm2_k_BARCELONA, xasum_k_BARCELONA, xsum_k_BARCELONA, xcopy_k_BARCELONA,
  xdotu_k_BARCELONA, xdotc_k_BARCELONA, xqrot_k_BARCELONA,
  xaxpy_k_BARCELONA, xaxpyc_k_BARCELONA, xscal_k_BARCELONA, xswap_k_BARCELONA,

  xgemv_n_BARCELONA, xgemv_t_BARCELONA, xgemv_r_BARCELONA, xgemv_c_BARCELONA,
  xgemv_o_BARCELONA, xgemv_u_BARCELONA, xgemv_s_BARCELONA, xgemv_d_BARCELONA,
  xgeru_k_BARCELONA, xgerc_k_BARCELONA, xgerv_k_BARCELONA, xgerd_k_BARCELONA,
  xsymv_L_BARCELONA, xsymv_U_BARCELONA,
  xhemv_L_BARCELONA, xhemv_U_BARCELONA, xhemv_M_BARCELONA, xhemv_V_BARCELONA,

  xgemm_kernel_n_BARCELONA, xgemm_kernel_l_BARCELONA, xgemm_kernel_r_BARCELONA, xgemm_kernel_b_BARCELONA,
  xgemm_beta_BARCELONA,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_BARCELONA, xgemm_itcopy_BARCELONA,
#else
  xgemm_oncopy_BARCELONA, xgemm_otcopy_BARCELONA,
#endif
  xgemm_oncopy_BARCELONA, xgemm_otcopy_BARCELONA,

  xtrsm_kernel_LN_BARCELONA, xtrsm_kernel_LT_BARCELONA, xtrsm_kernel_LR_BARCELONA, xtrsm_kernel_LC_BARCELONA,
  xtrsm_kernel_RN_BARCELONA, xtrsm_kernel_RT_BARCELONA, xtrsm_kernel_RR_BARCELONA, xtrsm_kernel_RC_BARCELONA,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_BARCELONA,  xtrsm_iunncopy_BARCELONA,  xtrsm_iutucopy_BARCELONA,  xtrsm_iutncopy_BARCELONA,
  xtrsm_ilnucopy_BARCELONA,  xtrsm_ilnncopy_BARCELONA,  xtrsm_iltucopy_BARCELONA,  xtrsm_iltncopy_BARCELONA,
#else
  xtrsm_ounucopy_BARCELONA,  xtrsm_ounncopy_BARCELONA,  xtrsm_outucopy_BARCELONA,  xtrsm_outncopy_BARCELONA,
  xtrsm_olnucopy_BARCELONA,  xtrsm_olnncopy_BARCELONA,  xtrsm_oltucopy_BARCELONA,  xtrsm_oltncopy_BARCELONA,
#endif
  xtrsm_ounucopy_BARCELONA,  xtrsm_ounncopy_BARCELONA,  xtrsm_outucopy_BARCELONA,  xtrsm_outncopy_BARCELONA,
  xtrsm_olnucopy_BARCELONA,  xtrsm_olnncopy_BARCELONA,  xtrsm_oltucopy_BARCELONA,  xtrsm_oltncopy_BARCELONA,

  xtrmm_kernel_RN_BARCELONA,  xtrmm_kernel_RT_BARCELONA,  xtrmm_kernel_RR_BARCELONA,  xtrmm_kernel_RC_BARCELONA,
  xtrmm_kernel_LN_BARCELONA,  xtrmm_kernel_LT_BARCELONA,  xtrmm_kernel_LR_BARCELONA,  xtrmm_kernel_LC_BARCELONA,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_BARCELONA,  xtrmm_iunncopy_BARCELONA,  xtrmm_iutucopy_BARCELONA,  xtrmm_iutncopy_BARCELONA,
  xtrmm_ilnucopy_BARCELONA,  xtrmm_ilnncopy_BARCELONA,  xtrmm_iltucopy_BARCELONA,  xtrmm_iltncopy_BARCELONA,
#else
  xtrmm_ounucopy_BARCELONA,  xtrmm_ounncopy_BARCELONA,  xtrmm_outucopy_BARCELONA,  xtrmm_outncopy_BARCELONA,
  xtrmm_olnucopy_BARCELONA,  xtrmm_olnncopy_BARCELONA,  xtrmm_oltucopy_BARCELONA,  xtrmm_oltncopy_BARCELONA,
#endif
  xtrmm_ounucopy_BARCELONA,  xtrmm_ounncopy_BARCELONA,  xtrmm_outucopy_BARCELONA,  xtrmm_outncopy_BARCELONA,
  xtrmm_olnucopy_BARCELONA,  xtrmm_olnncopy_BARCELONA,  xtrmm_oltucopy_BARCELONA,  xtrmm_oltncopy_BARCELONA,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_BARCELONA,  xsymm_iltcopy_BARCELONA,
#else
  xsymm_outcopy_BARCELONA,  xsymm_oltcopy_BARCELONA,
#endif
  xsymm_outcopy_BARCELONA,  xsymm_oltcopy_BARCELONA,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_BARCELONA,  xhemm_iltcopy_BARCELONA,
#else
  xhemm_outcopy_BARCELONA,  xhemm_oltcopy_BARCELONA,
#endif
  xhemm_outcopy_BARCELONA,  xhemm_oltcopy_BARCELONA,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_BARCELONA,

  xgemm3m_incopyb_BARCELONA,  xgemm3m_incopyr_BARCELONA,
  xgemm3m_incopyi_BARCELONA,  xgemm3m_itcopyb_BARCELONA,
  xgemm3m_itcopyr_BARCELONA,  xgemm3m_itcopyi_BARCELONA,
  xgemm3m_oncopyb_BARCELONA,  xgemm3m_oncopyr_BARCELONA,
  xgemm3m_oncopyi_BARCELONA,  xgemm3m_otcopyb_BARCELONA,
  xgemm3m_otcopyr_BARCELONA,  xgemm3m_otcopyi_BARCELONA,

  xsymm3m_iucopyb_BARCELONA,  xsymm3m_ilcopyb_BARCELONA,
  xsymm3m_iucopyr_BARCELONA,  xsymm3m_ilcopyr_BARCELONA,
  xsymm3m_iucopyi_BARCELONA,  xsymm3m_ilcopyi_BARCELONA,
  xsymm3m_oucopyb_BARCELONA,  xsymm3m_olcopyb_BARCELONA,
  xsymm3m_oucopyr_BARCELONA,  xsymm3m_olcopyr_BARCELONA,
  xsymm3m_oucopyi_BARCELONA,  xsymm3m_olcopyi_BARCELONA,

  xhemm3m_iucopyb_BARCELONA,  xhemm3m_ilcopyb_BARCELONA,
  xhemm3m_iucopyr_BARCELONA,  xhemm3m_ilcopyr_BARCELONA,
  xhemm3m_iucopyi_BARCELONA,  xhemm3m_ilcopyi_BARCELONA,

  xhemm3m_oucopyb_BARCELONA,  xhemm3m_olcopyb_BARCELONA,
  xhemm3m_oucopyr_BARCELONA,  xhemm3m_olcopyr_BARCELONA,
  xhemm3m_oucopyi_BARCELONA,  xhemm3m_olcopyi_BARCELONA,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_BARCELONA, xlaswp_ncopy_BARCELONA,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_BARCELONA,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_BARCELONA,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_BARCELONA,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_BARCELONA,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_BARCELONA, somatcopy_k_ct_BARCELONA, somatcopy_k_rn_BARCELONA, somatcopy_k_rt_BARCELONA,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_BARCELONA, domatcopy_k_ct_BARCELONA, domatcopy_k_rn_BARCELONA, domatcopy_k_rt_BARCELONA,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_BARCELONA, comatcopy_k_ct_BARCELONA, comatcopy_k_rn_BARCELONA, comatcopy_k_rt_BARCELONA,
  comatcopy_k_cnc_BARCELONA, comatcopy_k_ctc_BARCELONA, comatcopy_k_rnc_BARCELONA, comatcopy_k_rtc_BARCELONA,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_BARCELONA, zomatcopy_k_ct_BARCELONA, zomatcopy_k_rn_BARCELONA, zomatcopy_k_rt_BARCELONA,
  zomatcopy_k_cnc_BARCELONA, zomatcopy_k_ctc_BARCELONA, zomatcopy_k_rnc_BARCELONA, zomatcopy_k_rtc_BARCELONA,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_BARCELONA, simatcopy_k_ct_BARCELONA, simatcopy_k_rn_BARCELONA, simatcopy_k_rt_BARCELONA,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_BARCELONA, dimatcopy_k_ct_BARCELONA, dimatcopy_k_rn_BARCELONA, dimatcopy_k_rt_BARCELONA,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_BARCELONA, cimatcopy_k_ct_BARCELONA, cimatcopy_k_rn_BARCELONA, cimatcopy_k_rt_BARCELONA,
  cimatcopy_k_cnc_BARCELONA, cimatcopy_k_ctc_BARCELONA, cimatcopy_k_rnc_BARCELONA, cimatcopy_k_rtc_BARCELONA,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_BARCELONA, zimatcopy_k_ct_BARCELONA, zimatcopy_k_rn_BARCELONA, zimatcopy_k_rt_BARCELONA,
  zimatcopy_k_cnc_BARCELONA, zimatcopy_k_ctc_BARCELONA, zimatcopy_k_rnc_BARCELONA, zimatcopy_k_rtc_BARCELONA,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_BARCELONA,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_BARCELONA,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_BARCELONA,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_BARCELONA,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
