/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mm-gdbus-sms.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_storage,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Sms
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusSms
 * @title: MmGdbusSms
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Sms D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Sms ---- */

static const _ExtendedGDBusMethodInfo _mm_gdbus_sms_method_info_send =
{
  {
    -1,
    (gchar *) "Send",
    NULL,
    NULL,
    NULL
  },
  "handle-send",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sms_method_info_store_IN_ARG_storage =
{
  {
    -1,
    (gchar *) "storage",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sms_method_info_store_IN_ARG_pointers[] =
{
  &_mm_gdbus_sms_method_info_store_IN_ARG_storage.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sms_method_info_store =
{
  {
    -1,
    (gchar *) "Store",
    (GDBusArgInfo **) &_mm_gdbus_sms_method_info_store_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-store",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_sms_method_info_pointers[] =
{
  &_mm_gdbus_sms_method_info_send.parent_struct,
  &_mm_gdbus_sms_method_info_store.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_pdu_type =
{
  {
    -1,
    (gchar *) "PduType",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "pdu-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_number =
{
  {
    -1,
    (gchar *) "Number",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_text =
{
  {
    -1,
    (gchar *) "Text",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "text",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_data =
{
  {
    -1,
    (gchar *) "Data",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "data",
  TRUE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_smsc =
{
  {
    -1,
    (gchar *) "SMSC",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smsc",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_validity =
{
  {
    -1,
    (gchar *) "Validity",
    (gchar *) "(uv)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "validity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_class =
{
  {
    -1,
    (gchar *) "Class",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "class",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_teleservice_id =
{
  {
    -1,
    (gchar *) "TeleserviceId",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "teleservice-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_service_category =
{
  {
    -1,
    (gchar *) "ServiceCategory",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "service-category",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_delivery_report_request =
{
  {
    -1,
    (gchar *) "DeliveryReportRequest",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "delivery-report-request",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_message_reference =
{
  {
    -1,
    (gchar *) "MessageReference",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "message-reference",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_timestamp =
{
  {
    -1,
    (gchar *) "Timestamp",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_discharge_timestamp =
{
  {
    -1,
    (gchar *) "DischargeTimestamp",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "discharge-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_delivery_state =
{
  {
    -1,
    (gchar *) "DeliveryState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "delivery-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sms_property_info_storage =
{
  {
    -1,
    (gchar *) "Storage",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "storage",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_sms_property_info_pointers[] =
{
  &_mm_gdbus_sms_property_info_state.parent_struct,
  &_mm_gdbus_sms_property_info_pdu_type.parent_struct,
  &_mm_gdbus_sms_property_info_number.parent_struct,
  &_mm_gdbus_sms_property_info_text.parent_struct,
  &_mm_gdbus_sms_property_info_data.parent_struct,
  &_mm_gdbus_sms_property_info_smsc.parent_struct,
  &_mm_gdbus_sms_property_info_validity.parent_struct,
  &_mm_gdbus_sms_property_info_class.parent_struct,
  &_mm_gdbus_sms_property_info_teleservice_id.parent_struct,
  &_mm_gdbus_sms_property_info_service_category.parent_struct,
  &_mm_gdbus_sms_property_info_delivery_report_request.parent_struct,
  &_mm_gdbus_sms_property_info_message_reference.parent_struct,
  &_mm_gdbus_sms_property_info_timestamp.parent_struct,
  &_mm_gdbus_sms_property_info_discharge_timestamp.parent_struct,
  &_mm_gdbus_sms_property_info_delivery_state.parent_struct,
  &_mm_gdbus_sms_property_info_storage.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_sms_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Sms",
    (GDBusMethodInfo **) &_mm_gdbus_sms_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_sms_property_info_pointers,
    NULL
  },
  "sms",
};


/**
 * mm_gdbus_sms_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_sms_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct;
}

/**
 * mm_gdbus_sms_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusSms interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_sms_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "pdu-type");
  g_object_class_override_property (klass, property_id_begin++, "number");
  g_object_class_override_property (klass, property_id_begin++, "text");
  g_object_class_override_property (klass, property_id_begin++, "data");
  g_object_class_override_property (klass, property_id_begin++, "smsc");
  g_object_class_override_property (klass, property_id_begin++, "validity");
  g_object_class_override_property (klass, property_id_begin++, "class");
  g_object_class_override_property (klass, property_id_begin++, "teleservice-id");
  g_object_class_override_property (klass, property_id_begin++, "service-category");
  g_object_class_override_property (klass, property_id_begin++, "delivery-report-request");
  g_object_class_override_property (klass, property_id_begin++, "message-reference");
  g_object_class_override_property (klass, property_id_begin++, "timestamp");
  g_object_class_override_property (klass, property_id_begin++, "discharge-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "delivery-state");
  g_object_class_override_property (klass, property_id_begin++, "storage");
  return property_id_begin - 1;
}


inline static void
mm_gdbus_sms_method_marshal_send (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_sms_method_marshal_store (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MmGdbusSms:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link>.
 */

/**
 * MmGdbusSmsIface:
 * @parent_iface: The parent interface.
 * @handle_send: Handler for the #MmGdbusSms::handle-send signal.
 * @handle_store: Handler for the #MmGdbusSms::handle-store signal.
 * @get_class: Getter for the #MmGdbusSms:class property.
 * @get_data: Getter for the #MmGdbusSms:data property.
 * @get_delivery_report_request: Getter for the #MmGdbusSms:delivery-report-request property.
 * @get_delivery_state: Getter for the #MmGdbusSms:delivery-state property.
 * @get_discharge_timestamp: Getter for the #MmGdbusSms:discharge-timestamp property.
 * @get_message_reference: Getter for the #MmGdbusSms:message-reference property.
 * @get_number: Getter for the #MmGdbusSms:number property.
 * @get_pdu_type: Getter for the #MmGdbusSms:pdu-type property.
 * @get_service_category: Getter for the #MmGdbusSms:service-category property.
 * @get_smsc: Getter for the #MmGdbusSms:smsc property.
 * @get_state: Getter for the #MmGdbusSms:state property.
 * @get_storage: Getter for the #MmGdbusSms:storage property.
 * @get_teleservice_id: Getter for the #MmGdbusSms:teleservice-id property.
 * @get_text: Getter for the #MmGdbusSms:text property.
 * @get_timestamp: Getter for the #MmGdbusSms:timestamp property.
 * @get_validity: Getter for the #MmGdbusSms:validity property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link>.
 */

typedef MmGdbusSmsIface MmGdbusSmsInterface;
G_DEFINE_INTERFACE (MmGdbusSms, mm_gdbus_sms, G_TYPE_OBJECT)

static void
mm_gdbus_sms_default_init (MmGdbusSmsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusSms::handle-send:
   * @object: A #MmGdbusSms.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Send">Send()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sms_complete_send() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSmsIface, handle_send),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sms_method_marshal_send,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusSms::handle-store:
   * @object: A #MmGdbusSms.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_storage: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Store">Store()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sms_complete_store() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-store",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSmsIface, handle_store),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sms_method_marshal_store,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusSms:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:pdu-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.PduType">"PduType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("pdu-type", "PduType", "PduType", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Number">"Number"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("number", "Number", "Number", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:text:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Text">"Text"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("text", "Text", "Text", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:data:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Data">"Data"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("data", "Data", "Data", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:smsc:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.SMSC">"SMSC"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("smsc", "SMSC", "SMSC", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:validity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Validity">"Validity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("validity", "Validity", "Validity", G_VARIANT_TYPE ("(uv)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:class:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Class">"Class"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("class", "Class", "Class", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:teleservice-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.TeleserviceId">"TeleserviceId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("teleservice-id", "TeleserviceId", "TeleserviceId", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:service-category:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.ServiceCategory">"ServiceCategory"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("service-category", "ServiceCategory", "ServiceCategory", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:delivery-report-request:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryReportRequest">"DeliveryReportRequest"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("delivery-report-request", "DeliveryReportRequest", "DeliveryReportRequest", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:message-reference:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.MessageReference">"MessageReference"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("message-reference", "MessageReference", "MessageReference", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Timestamp">"Timestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("timestamp", "Timestamp", "Timestamp", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:discharge-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DischargeTimestamp">"DischargeTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("discharge-timestamp", "DischargeTimestamp", "DischargeTimestamp", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:delivery-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryState">"DeliveryState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("delivery-state", "DeliveryState", "DeliveryState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSms:storage:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Storage">"Storage"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("storage", "Storage", "Storage", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_sms_get_state: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_state (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_state (object);
}

/**
 * mm_gdbus_sms_set_state: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_state (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * mm_gdbus_sms_get_pdu_type: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.PduType">"PduType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_pdu_type (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_pdu_type (object);
}

/**
 * mm_gdbus_sms_set_pdu_type: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.PduType">"PduType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_pdu_type (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "pdu-type", value, NULL);
}

/**
 * mm_gdbus_sms_get_number: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Number">"Number"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_number() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sms_get_number (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_number (object);
}

/**
 * mm_gdbus_sms_dup_number: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Number">"Number"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sms_dup_number (MmGdbusSms *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "number", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_number: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Number">"Number"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_number (MmGdbusSms *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "number", value, NULL);
}

/**
 * mm_gdbus_sms_get_text: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Text">"Text"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_text() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sms_get_text (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_text (object);
}

/**
 * mm_gdbus_sms_dup_text: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Text">"Text"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sms_dup_text (MmGdbusSms *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "text", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_text: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Text">"Text"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_text (MmGdbusSms *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "text", value, NULL);
}

/**
 * mm_gdbus_sms_get_data: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Data">"Data"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_data() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_sms_get_data (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_data (object);
}

/**
 * mm_gdbus_sms_dup_data: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Data">"Data"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_sms_dup_data (MmGdbusSms *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "data", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_data: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Data">"Data"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_data (MmGdbusSms *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "data", value, NULL);
}

/**
 * mm_gdbus_sms_get_smsc: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.SMSC">"SMSC"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_smsc() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sms_get_smsc (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_smsc (object);
}

/**
 * mm_gdbus_sms_dup_smsc: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.SMSC">"SMSC"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sms_dup_smsc (MmGdbusSms *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "smsc", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_smsc: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.SMSC">"SMSC"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_smsc (MmGdbusSms *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "smsc", value, NULL);
}

/**
 * mm_gdbus_sms_get_validity: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Validity">"Validity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_validity() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_sms_get_validity (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_validity (object);
}

/**
 * mm_gdbus_sms_dup_validity: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Validity">"Validity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_sms_dup_validity (MmGdbusSms *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "validity", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_validity: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Validity">"Validity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_validity (MmGdbusSms *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "validity", value, NULL);
}

/**
 * mm_gdbus_sms_get_class: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Class">"Class"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mm_gdbus_sms_get_class (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_class (object);
}

/**
 * mm_gdbus_sms_set_class: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Class">"Class"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_class (MmGdbusSms *object, gint value)
{
  g_object_set (G_OBJECT (object), "class", value, NULL);
}

/**
 * mm_gdbus_sms_get_teleservice_id: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.TeleserviceId">"TeleserviceId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_teleservice_id (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_teleservice_id (object);
}

/**
 * mm_gdbus_sms_set_teleservice_id: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.TeleserviceId">"TeleserviceId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_teleservice_id (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "teleservice-id", value, NULL);
}

/**
 * mm_gdbus_sms_get_service_category: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.ServiceCategory">"ServiceCategory"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_service_category (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_service_category (object);
}

/**
 * mm_gdbus_sms_set_service_category: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.ServiceCategory">"ServiceCategory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_service_category (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "service-category", value, NULL);
}

/**
 * mm_gdbus_sms_get_delivery_report_request: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryReportRequest">"DeliveryReportRequest"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_sms_get_delivery_report_request (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), FALSE);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_delivery_report_request (object);
}

/**
 * mm_gdbus_sms_set_delivery_report_request: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryReportRequest">"DeliveryReportRequest"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_delivery_report_request (MmGdbusSms *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "delivery-report-request", value, NULL);
}

/**
 * mm_gdbus_sms_get_message_reference: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.MessageReference">"MessageReference"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_message_reference (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_message_reference (object);
}

/**
 * mm_gdbus_sms_set_message_reference: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.MessageReference">"MessageReference"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_message_reference (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "message-reference", value, NULL);
}

/**
 * mm_gdbus_sms_get_timestamp: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Timestamp">"Timestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_timestamp() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sms_get_timestamp (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_timestamp (object);
}

/**
 * mm_gdbus_sms_dup_timestamp: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Timestamp">"Timestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sms_dup_timestamp (MmGdbusSms *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "timestamp", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_timestamp: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Timestamp">"Timestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_timestamp (MmGdbusSms *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "timestamp", value, NULL);
}

/**
 * mm_gdbus_sms_get_discharge_timestamp: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DischargeTimestamp">"DischargeTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sms_dup_discharge_timestamp() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sms_get_discharge_timestamp (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), NULL);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_discharge_timestamp (object);
}

/**
 * mm_gdbus_sms_dup_discharge_timestamp: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DischargeTimestamp">"DischargeTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sms_dup_discharge_timestamp (MmGdbusSms *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "discharge-timestamp", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sms_set_discharge_timestamp: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DischargeTimestamp">"DischargeTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_discharge_timestamp (MmGdbusSms *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "discharge-timestamp", value, NULL);
}

/**
 * mm_gdbus_sms_get_delivery_state: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryState">"DeliveryState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_delivery_state (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_delivery_state (object);
}

/**
 * mm_gdbus_sms_set_delivery_state: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.DeliveryState">"DeliveryState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_delivery_state (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "delivery-state", value, NULL);
}

/**
 * mm_gdbus_sms_get_storage: (skip)
 * @object: A #MmGdbusSms.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Storage">"Storage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sms_get_storage (MmGdbusSms *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SMS (object), 0);

  return MM_GDBUS_SMS_GET_IFACE (object)->get_storage (object);
}

/**
 * mm_gdbus_sms_set_storage: (skip)
 * @object: A #MmGdbusSms.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sms.Storage">"Storage"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sms_set_storage (MmGdbusSms *object, guint value)
{
  g_object_set (G_OBJECT (object), "storage", value, NULL);
}

/**
 * mm_gdbus_sms_call_send:
 * @proxy: A #MmGdbusSmsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Send">Send()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sms_call_send_finish() to get the result of the operation.
 *
 * See mm_gdbus_sms_call_send_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sms_call_send (
    MmGdbusSms *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Send",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sms_call_send_finish:
 * @proxy: A #MmGdbusSmsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sms_call_send().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sms_call_send().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sms_call_send_finish (
    MmGdbusSms *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sms_call_send_sync:
 * @proxy: A #MmGdbusSmsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Send">Send()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sms_call_send() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sms_call_send_sync (
    MmGdbusSms *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Send",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sms_call_store:
 * @proxy: A #MmGdbusSmsProxy.
 * @arg_storage: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Store">Store()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sms_call_store_finish() to get the result of the operation.
 *
 * See mm_gdbus_sms_call_store_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sms_call_store (
    MmGdbusSms *proxy,
    guint arg_storage,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Store",
    g_variant_new ("(u)",
                   arg_storage),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sms_call_store_finish:
 * @proxy: A #MmGdbusSmsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sms_call_store().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sms_call_store().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sms_call_store_finish (
    MmGdbusSms *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sms_call_store_sync:
 * @proxy: A #MmGdbusSmsProxy.
 * @arg_storage: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Store">Store()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sms_call_store() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sms_call_store_sync (
    MmGdbusSms *proxy,
    guint arg_storage,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Store",
    g_variant_new ("(u)",
                   arg_storage),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sms_complete_send:
 * @object: A #MmGdbusSms.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Send">Send()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sms_complete_send (
    MmGdbusSms *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_sms_complete_store:
 * @object: A #MmGdbusSms.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sms.Store">Store()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sms_complete_store (
    MmGdbusSms *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusSmsProxy:
 *
 * The #MmGdbusSmsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusSmsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusSmsProxy.
 */

struct _MmGdbusSmsProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_sms_proxy_iface_init (MmGdbusSmsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusSmsProxy, mm_gdbus_sms_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusSmsProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SMS, mm_gdbus_sms_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusSmsProxy, mm_gdbus_sms_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SMS, mm_gdbus_sms_proxy_iface_init))

#endif
static void
mm_gdbus_sms_proxy_finalize (GObject *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_sms_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_sms_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 16);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sms_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_sms_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Sms: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_sms_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 16);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sms_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Sms", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_sms_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_sms_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_SMS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_SMS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_sms_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_sms_proxy_get_state (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_pdu_type (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PduType");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sms_proxy_get_number (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Number");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sms_proxy_get_text (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Text");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_sms_proxy_get_data (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Data");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
mm_gdbus_sms_proxy_get_smsc (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SMSC");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_sms_proxy_get_validity (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Validity");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gint 
mm_gdbus_sms_proxy_get_class (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Class");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_teleservice_id (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TeleserviceId");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_service_category (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ServiceCategory");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mm_gdbus_sms_proxy_get_delivery_report_request (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeliveryReportRequest");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_message_reference (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MessageReference");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sms_proxy_get_timestamp (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Timestamp");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sms_proxy_get_discharge_timestamp (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DischargeTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_delivery_state (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeliveryState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sms_proxy_get_storage (MmGdbusSms *object)
{
  MmGdbusSmsProxy *proxy = MM_GDBUS_SMS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Storage");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_sms_proxy_init (MmGdbusSmsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_sms_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_SMS_PROXY, MmGdbusSmsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_sms_interface_info ());
}

static void
mm_gdbus_sms_proxy_class_init (MmGdbusSmsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_sms_proxy_finalize;
  gobject_class->get_property = mm_gdbus_sms_proxy_get_property;
  gobject_class->set_property = mm_gdbus_sms_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_sms_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_sms_proxy_g_properties_changed;

  mm_gdbus_sms_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusSmsProxyPrivate));
#endif
}

static void
mm_gdbus_sms_proxy_iface_init (MmGdbusSmsIface *iface)
{
  iface->get_state = mm_gdbus_sms_proxy_get_state;
  iface->get_pdu_type = mm_gdbus_sms_proxy_get_pdu_type;
  iface->get_number = mm_gdbus_sms_proxy_get_number;
  iface->get_text = mm_gdbus_sms_proxy_get_text;
  iface->get_data = mm_gdbus_sms_proxy_get_data;
  iface->get_smsc = mm_gdbus_sms_proxy_get_smsc;
  iface->get_validity = mm_gdbus_sms_proxy_get_validity;
  iface->get_class = mm_gdbus_sms_proxy_get_class;
  iface->get_teleservice_id = mm_gdbus_sms_proxy_get_teleservice_id;
  iface->get_service_category = mm_gdbus_sms_proxy_get_service_category;
  iface->get_delivery_report_request = mm_gdbus_sms_proxy_get_delivery_report_request;
  iface->get_message_reference = mm_gdbus_sms_proxy_get_message_reference;
  iface->get_timestamp = mm_gdbus_sms_proxy_get_timestamp;
  iface->get_discharge_timestamp = mm_gdbus_sms_proxy_get_discharge_timestamp;
  iface->get_delivery_state = mm_gdbus_sms_proxy_get_delivery_state;
  iface->get_storage = mm_gdbus_sms_proxy_get_storage;
}

/**
 * mm_gdbus_sms_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sms_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_sms_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_sms_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_SMS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sms", NULL);
}

/**
 * mm_gdbus_sms_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sms_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_sms_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusSmsProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSms *
mm_gdbus_sms_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_SMS (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_sms_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sms_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusSmsProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSms *
mm_gdbus_sms_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_SMS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sms", NULL);
  if (ret != NULL)
    return MM_GDBUS_SMS (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_sms_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_sms_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sms_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_sms_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_sms_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_SMS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sms", NULL);
}

/**
 * mm_gdbus_sms_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sms_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_sms_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusSmsProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSms *
mm_gdbus_sms_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_SMS (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_sms_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_sms_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sms_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusSmsProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSms *
mm_gdbus_sms_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_SMS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sms", NULL);
  if (ret != NULL)
    return MM_GDBUS_SMS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusSmsSkeleton:
 *
 * The #MmGdbusSmsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusSmsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusSmsSkeleton.
 */

struct _MmGdbusSmsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_sms_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_SMS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_SMS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_sms_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_sms_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sms_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_sms_skeleton_vtable =
{
  _mm_gdbus_sms_skeleton_handle_method_call,
  _mm_gdbus_sms_skeleton_handle_get_property,
  _mm_gdbus_sms_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_sms_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_sms_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_sms_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_sms_skeleton_vtable;
}

static GVariant *
mm_gdbus_sms_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mm_gdbus_sms_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_sms_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_sms_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_sms_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Sms", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_sms_emit_changed (gpointer user_data);

static void
mm_gdbus_sms_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_sms_emit_changed (skeleton);
}

static void mm_gdbus_sms_skeleton_iface_init (MmGdbusSmsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusSmsSkeleton, mm_gdbus_sms_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusSmsSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SMS, mm_gdbus_sms_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusSmsSkeleton, mm_gdbus_sms_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SMS, mm_gdbus_sms_skeleton_iface_init))

#endif
static void
mm_gdbus_sms_skeleton_finalize (GObject *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint n;
  for (n = 0; n < 16; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_sms_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_sms_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 16);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_sms_emit_changed (gpointer user_data)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Sms",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_sms_schedule_emit_changed (MmGdbusSmsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_sms_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_sms_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_sms_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_sms_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 16);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sms_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_sms_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_sms_skeleton_init (MmGdbusSmsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_sms_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_SMS_SKELETON, MmGdbusSmsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 16);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_UINT);
}

static guint 
mm_gdbus_sms_skeleton_get_state (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_pdu_type (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sms_skeleton_get_number (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sms_skeleton_get_text (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_sms_skeleton_get_data (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sms_skeleton_get_smsc (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_sms_skeleton_get_validity (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
mm_gdbus_sms_skeleton_get_class (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_teleservice_id (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_service_category (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mm_gdbus_sms_skeleton_get_delivery_report_request (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_message_reference (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sms_skeleton_get_timestamp (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sms_skeleton_get_discharge_timestamp (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_delivery_state (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sms_skeleton_get_storage (MmGdbusSms *object)
{
  MmGdbusSmsSkeleton *skeleton = MM_GDBUS_SMS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_sms_skeleton_class_init (MmGdbusSmsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_sms_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_sms_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_sms_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_sms_skeleton_notify;


  mm_gdbus_sms_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_sms_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_sms_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_sms_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_sms_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusSmsSkeletonPrivate));
#endif
}

static void
mm_gdbus_sms_skeleton_iface_init (MmGdbusSmsIface *iface)
{
  iface->get_state = mm_gdbus_sms_skeleton_get_state;
  iface->get_pdu_type = mm_gdbus_sms_skeleton_get_pdu_type;
  iface->get_number = mm_gdbus_sms_skeleton_get_number;
  iface->get_text = mm_gdbus_sms_skeleton_get_text;
  iface->get_data = mm_gdbus_sms_skeleton_get_data;
  iface->get_smsc = mm_gdbus_sms_skeleton_get_smsc;
  iface->get_validity = mm_gdbus_sms_skeleton_get_validity;
  iface->get_class = mm_gdbus_sms_skeleton_get_class;
  iface->get_teleservice_id = mm_gdbus_sms_skeleton_get_teleservice_id;
  iface->get_service_category = mm_gdbus_sms_skeleton_get_service_category;
  iface->get_delivery_report_request = mm_gdbus_sms_skeleton_get_delivery_report_request;
  iface->get_message_reference = mm_gdbus_sms_skeleton_get_message_reference;
  iface->get_timestamp = mm_gdbus_sms_skeleton_get_timestamp;
  iface->get_discharge_timestamp = mm_gdbus_sms_skeleton_get_discharge_timestamp;
  iface->get_delivery_state = mm_gdbus_sms_skeleton_get_delivery_state;
  iface->get_storage = mm_gdbus_sms_skeleton_get_storage;
}

/**
 * mm_gdbus_sms_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sms.top_of_page">org.freedesktop.ModemManager1.Sms</link>.
 *
 * Returns: (transfer full) (type MmGdbusSmsSkeleton): The skeleton object.
 */
MmGdbusSms *
mm_gdbus_sms_skeleton_new (void)
{
  return MM_GDBUS_SMS (g_object_new (MM_GDBUS_TYPE_SMS_SKELETON, NULL));
}

